/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import com.fasterxml.jackson.databind.JsonNode;
import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.User;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import models.BankOrderWithPayments;
import play.libs.Json;

public final class BankOrderSignInfo {
    private User user;
    private List<BankOrderWithPayments> bankOrders;

    public boolean parseFromRequest(String request, Locale locale) {
        try {
            JsonNode json = Json.parse((String)request);
            this.user = json.get("user") != null ? User.getUser((String)json.get("user").asText()) : null;
            if (this.user == null) {
                throw new Exception("Missing user in request!");
            }
            JsonNode ordersArray = json.get("ords");
            if (ordersArray != null && ordersArray.isArray()) {
                Iterator bankOrderIterator = ordersArray.elements();
                while (bankOrderIterator.hasNext()) {
                    JsonNode bankOrderNode = (JsonNode)bankOrderIterator.next();
                    BankOrder bankOrder = BankOrder.fromString(this.user, bankOrderNode.get("info").asText(), locale);
                    if (bankOrder == null) {
                        BLLoggerPlay.warning("Failed to load bank order from info: " + bankOrderNode.get("info").asText());
                        continue;
                    }
                    if (this.bankOrders == null) {
                        this.bankOrders = new ArrayList<BankOrderWithPayments>();
                    }
                    if (bankOrderNode.has("pmts")) {
                        String paymentIdsString = bankOrderNode.get("pmts").asText();
                        if (paymentIdsString != null && !paymentIdsString.isEmpty()) {
                            ArrayList<Integer> paymentIds = new ArrayList<Integer>();
                            for (String id : paymentIdsString.split(",")) {
                                paymentIds.add(Integer.parseInt(id));
                            }
                            this.bankOrders.add(new BankOrderWithPayments(bankOrder, DB.find(OpenPayment.class).where().in("id", paymentIds).findList()));
                            continue;
                        }
                        this.bankOrders.add(new BankOrderWithPayments(bankOrder, null));
                        continue;
                    }
                    this.bankOrders.add(new BankOrderWithPayments(bankOrder, null));
                }
            }
            this.bankOrders = BankOrderWithPayments.sortByPmtType(this.bankOrders);
            return true;
        }
        catch (Throwable t) {
            BLLoggerPlay.error("Failed to read message from web socket: " + request, t);
            return false;
        }
    }

    public void committed() {
        this.user = null;
        this.bankOrders = null;
    }

    public void finished() {
        if (this.user == null || this.bankOrders == null || this.bankOrders.isEmpty()) {
            return;
        }
        for (BankOrderWithPayments bankOrderWithPayments : this.bankOrders) {
            BankOrder bankOrder = bankOrderWithPayments.getBankOrder();
            if (bankOrder.isExternalFile()) continue;
            List<OpenPayment> openPayments = bankOrderWithPayments.getOpenPayments();
            if (openPayments != null && !openPayments.isEmpty()) {
                OpenPayment.unlockPayments(openPayments);
            }
            bankOrder.deleteFile();
        }
    }
}

