/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.payments.api.AbstractBankOrderFactory;
import de.businesslogics.banking.payments.api.BankOrderCallback;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import models.payments.Mt101PaymentHandler;
import models.payments.PaymentHandler;
import org.xml.sax.SAXException;

public final class BankOrderFactory
extends AbstractBankOrderFactory<BankOrder, PaymentHandler<?>> {
    private final User user;
    private final Locale locale;

    public BankOrderFactory(User user, Locale locale) {
        this.user = user;
        this.locale = locale;
    }

    protected boolean isExceededPaymentExecutionDate(BankOrderPayment<PaymentHandler<?>> payment, PaymentProperties paymentProperties) {
        return ((PaymentHandler)payment.getPaymentData()).isExecutionDateExceeded(paymentProperties, payment.getOpenPayment().getOrderTypeOrFileType());
    }

    protected boolean isTooEarlyPaymentExecutionDate(BankOrderPayment<PaymentHandler<?>> payment, PaymentProperties paymentProperties) {
        return ((PaymentHandler)payment.getPaymentData()).isExecutionDateTooEarly(paymentProperties);
    }

    protected String getCorrectionMessage(BankOrderPayment<PaymentHandler<?>> payment, PaymentProperties paymentProperties) {
        return ((PaymentHandler)payment.getPaymentData()).getCorrectionMessage(paymentProperties, this.locale);
    }

    protected Map<BankOrder, List<OpenPayment>> createBankOrder(BankUser bankUser, PaymentTransferType.PmtType pmtType, String orderType, final List<BankOrderPayment<PaymentHandler<?>>> payments) {
        if (payments == null || payments.isEmpty()) {
            return null;
        }
        if (((PaymentHandler)payments.get(0).getPaymentData()).getPayment() instanceof SEPAPaymentData) {
            Iterator<BankOrderPayment<SEPAPaymentData>> paymentsIterator = new Iterator<BankOrderPayment<SEPAPaymentData>>(){
                private final Iterator<BankOrderPayment<PaymentHandler<?>>> sourceIterator;
                {
                    this.sourceIterator = payments.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.sourceIterator.hasNext();
                }

                @Override
                public BankOrderPayment<SEPAPaymentData> next() {
                    BankOrderPayment<PaymentHandler<?>> next = this.sourceIterator.next();
                    if (next != null && ((PaymentHandler)next.getPaymentData()).getPayment() instanceof SEPAPaymentData) {
                        return new BankOrderPayment(next.getOpenPayment(), (Object)((SEPAPaymentData)((PaymentHandler)next.getPaymentData()).getPayment()));
                    }
                    return null;
                }

                @Override
                public void remove() {
                    this.sourceIterator.remove();
                }
            };
            try {
                return SepaApi.createBankOrders((BankUser)bankUser, (PaymentTransferType.PmtType)pmtType, (String)orderType, (Iterator)paymentsIterator, (BankOrderCallback)new MyBankOrderCallback(this.locale), (Locale)this.locale);
            }
            catch (DisplayFileException | KnownFormatException | InvalidPasswordException | IOException | SAXException e) {
                BLLoggerPlay.error("Failed to create SEPA order!", e);
                throw new RuntimeException(e);
            }
        }
        if (((PaymentHandler)payments.get(0).getPaymentData()).getPayment() instanceof DTAZVPayment) {
            Iterator<BankOrderPayment<DTAZVPayment>> paymentsIterator = new Iterator<BankOrderPayment<DTAZVPayment>>(){
                private final Iterator<BankOrderPayment<PaymentHandler<?>>> sourceIterator;
                {
                    this.sourceIterator = payments.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.sourceIterator.hasNext();
                }

                @Override
                public BankOrderPayment<DTAZVPayment> next() {
                    BankOrderPayment<PaymentHandler<?>> next = this.sourceIterator.next();
                    if (next != null && ((PaymentHandler)next.getPaymentData()).getPayment() instanceof DTAZVPayment) {
                        return new BankOrderPayment(next.getOpenPayment(), (Object)((DTAZVPayment)((PaymentHandler)next.getPaymentData()).getPayment()));
                    }
                    return null;
                }

                @Override
                public void remove() {
                    this.sourceIterator.remove();
                }
            };
            try {
                return DtazvApi.createBankOrder((BankUser)bankUser, (String)orderType, (Iterator)paymentsIterator, (BankOrderCallback)new MyBankOrderCallback(this.locale));
            }
            catch (DisplayFileException | KnownFormatException | InvalidPasswordException | IOException e) {
                BLLoggerPlay.error("Failed to create DTAZV order!", e);
                throw new RuntimeException(e);
            }
        }
        if (((PaymentHandler)payments.get(0).getPaymentData()).getPayment() instanceof MT101PaymentData) {
            ArrayList<MT101PaymentData> mt101Payments = new ArrayList<MT101PaymentData>(payments.size());
            ArrayList<OpenPayment> paymentVos = new ArrayList<OpenPayment>();
            for (BankOrderPayment<PaymentHandler<?>> p : payments) {
                mt101Payments.add((MT101PaymentData)((Mt101PaymentHandler)p.getPaymentData()).getPayment());
                paymentVos.add(p.getOpenPayment());
            }
            try {
                return Collections.singletonMap((BankOrder)MT101Api.createOrderFile((BankUser)bankUser, (String)orderType, mt101Payments, (BankOrderCallback)new MyBankOrderCallback(this.locale)), paymentVos);
            }
            catch (DisplayFileException | KnownFormatException | InvalidPasswordException | IOException e) {
                BLLoggerPlay.error("Failed to create MT101 order!", e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected void newTask(String name, int units) {
    }

    protected void reportProgress(int progress) {
    }

    protected void reportFinished() {
    }

    protected boolean isCancelled() {
        return false;
    }

    private final class MyBankOrderCallback
    implements BankOrderCallback<BankOrder> {
        private final Locale locale;
        private final Map<BankSettings, BankUser> bankUserMap = new HashMap<BankSettings, BankUser>();

        private MyBankOrderCallback(Locale locale) {
            this.locale = locale;
        }

        public BankOrder createBankOrder(BankSettings bankSettings, PaymentTransferType.PmtType pmtType, String orderType, File orderFile, long orderDataSize) throws KnownFormatException, DisplayFileException, IOException {
            BankUser bankUser = this.bankUserMap.get(bankSettings);
            if (bankUser == null) {
                bankUser = BankUser.findBankUser((BankSettings)bankSettings, (User)BankOrderFactory.this.user);
                this.bankUserMap.put(bankSettings, bankUser);
            }
            try {
                return new BankOrder(bankUser, pmtType, orderFile, orderDataSize, SystemUtils.calculateMD5Hash((InputStream)EncryptData.getInstance().openInputStream(orderFile)), this.locale);
            }
            catch (GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to create bank order!", e);
                throw new RuntimeException(e);
            }
        }
    }
}

