/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.OpenPayments;
import controllers.util.AwvPaymentReportCollector;
import controllers.util.BLLoggerPlay;
import controllers.util.BankOrderCheckHandler;
import controllers.util.BankOrderResultHandler;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.DisplayMessageAndDigest;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.SepaChecker;
import de.businesslogics.banking.api.SigningInfo;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.VopUtil;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.payments.api.AbstractBankOrder;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import de.businesslogics.banking.payments.api.PaymentApiMessages;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.ticket.ATTHMTicket;
import de.businesslogics.format.ticket.BinaryGenerator;
import de.businesslogics.format.ticket.BulkMT101Ticket;
import de.businesslogics.format.ticket.CCCDisplayMessageGenerator;
import de.businesslogics.format.ticket.CCCTicket;
import de.businesslogics.format.ticket.CCTTicket;
import de.businesslogics.format.ticket.CDxContainerDisplayMessageGenerator;
import de.businesslogics.format.ticket.CDxContainerTicket;
import de.businesslogics.format.ticket.CDxTicket;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.MT101Generator;
import de.businesslogics.format.ticket.Pain00100103Ticket;
import de.businesslogics.format.ticket.Pain001ZZV05Ticket;
import de.businesslogics.format.ticket.Ticket;
import de.businesslogics.io.Streams;
import de.businesslogics.util.Currency;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import io.ebean.Expr;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Transaction;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import models.BankOrderWithPayments;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import models.payments.SepaPaymentHandler;

public final class BankOrder
extends AbstractBankOrder {
    private static final char BANK_ORDER_STRING_SEPARATOR = '-';
    private static final ExecutorService BACKGROUND_PROCESSING = Executors.newSingleThreadExecutor();
    private static Set<String> sendingOrders;
    private final BankUser bankUser;
    private final String md5Hash;
    private final DirectoryScanner directoryScanner;
    private final Locale locale;
    private List<? extends PaymentHandler<?>> payments;
    private Send recalledOrder = null;
    private List<SignedPayment> recalledSignedPayments;
    private final WorkspaceFile workspaceFile;
    private String originalFileName;
    private boolean useVop;

    public BankOrder(BankUser bankUser, String orderType, File orderFile, long orderFileSize, String md5Hash, String originalFileName, Locale locale) throws DisplayFileException, KnownFormatException, IOException {
        super(bankUser.getBank(), orderType, orderFileSize);
        this.workspaceFile = this.createWorkspaceFile(orderFile, orderFileSize, md5Hash);
        this.bankUser = bankUser;
        this.md5Hash = md5Hash;
        this.directoryScanner = null;
        this.locale = locale;
        this.originalFileName = originalFileName;
        this.useVop = false;
        this.getDisplayMessage();
    }

    private BankOrder(BankUser bankUser, String orderType, WorkspaceFile workspaceFile, long fileSize, String md5Hash, DirectoryScanner directoryScanner, Send recalledOrder, List<SignedPayment> recalledSignedPayments, String originalFileName, Locale locale) {
        super(bankUser.getBank(), orderType, fileSize);
        this.bankUser = bankUser;
        this.workspaceFile = workspaceFile;
        this.md5Hash = md5Hash;
        this.directoryScanner = directoryScanner;
        this.recalledOrder = recalledOrder;
        this.recalledSignedPayments = recalledSignedPayments;
        this.locale = locale;
        this.originalFileName = originalFileName;
        this.useVop = false;
    }

    public BankOrder(BankUser bankUser, String orderType, File orderFile, long orderFileSize, Send recalledOrder, List<SignedPayment> recalledSignedPayments, String md5Hash, Locale locale) throws DisplayFileException, KnownFormatException, IOException {
        super(bankUser.getBank(), orderType, orderFileSize);
        this.workspaceFile = this.createWorkspaceFile(orderFile, orderFileSize, md5Hash);
        this.bankUser = bankUser;
        this.md5Hash = md5Hash;
        this.directoryScanner = null;
        this.locale = locale;
        this.recalledOrder = recalledOrder;
        this.recalledSignedPayments = recalledSignedPayments;
        this.originalFileName = "";
        this.useVop = false;
        this.getDisplayMessage();
    }

    public BankOrder(BankUser bankUser, PaymentTransferType.PmtType pmtType, File orderFile, long orderFileSize, String md5Hash, Locale locale) throws DisplayFileException, KnownFormatException, IOException {
        super(bankUser.getBank(), pmtType, orderFileSize);
        this.workspaceFile = this.createWorkspaceFile(orderFile, orderFileSize, md5Hash);
        this.bankUser = bankUser;
        this.md5Hash = md5Hash;
        this.directoryScanner = null;
        this.locale = locale;
        this.originalFileName = "";
        this.useVop = false;
        this.getDisplayMessage();
    }

    public BankOrder(BankUser bankUser, PaymentTransferType.PmtType pmtType, File orderFile, long orderFileSize, Send recalledOrder, List<SignedPayment> recalledSignedPayments, String md5Hash, Locale locale) throws DisplayFileException, KnownFormatException, IOException {
        super(bankUser.getBank(), pmtType, orderFileSize);
        this.workspaceFile = this.createWorkspaceFile(orderFile, orderFileSize, md5Hash);
        this.bankUser = bankUser;
        this.md5Hash = md5Hash;
        this.directoryScanner = null;
        this.locale = locale;
        this.recalledOrder = recalledOrder;
        this.recalledSignedPayments = recalledSignedPayments;
        this.originalFileName = "";
        this.useVop = false;
        this.getDisplayMessage();
    }

    public BankOrder(BankUser bankUser, String orderType, WorkspaceFile workspaceFile, DirectoryScanner directoryScanner, Locale locale) throws DisplayFileException, KnownFormatException, IOException {
        super(bankUser.getBank(), orderType, workspaceFile.getSize().longValue());
        this.workspaceFile = workspaceFile;
        this.bankUser = bankUser;
        this.md5Hash = workspaceFile.getMd5Hash();
        this.directoryScanner = directoryScanner;
        this.locale = locale;
        this.originalFileName = "";
        this.useVop = false;
        this.getDisplayMessage();
    }

    public BankOrder(BankUser bankUser, PaymentTransferType.PmtType pmtType, File orderFile, String md5Hash, DirectoryScanner directoryScanner, Locale locale) throws DisplayFileException, KnownFormatException, IOException {
        super(bankUser.getBank(), pmtType, orderFile.length());
        this.workspaceFile = this.createWorkspaceFile(orderFile, orderFile.length(), md5Hash);
        this.bankUser = bankUser;
        this.md5Hash = md5Hash;
        this.directoryScanner = directoryScanner;
        this.locale = locale;
        this.originalFileName = "";
        this.useVop = false;
        this.getDisplayMessage();
    }

    private WorkspaceFile createWorkspaceFile(File orderFile, long size, String md5Hash) throws IOException {
        WorkspaceFile wf = new WorkspaceFile();
        wf.setSize(Long.valueOf(size));
        wf.setMd5Hash(md5Hash);
        wf.setPrefix(WorkspaceFile.Prefix.TEMPORARY_FILE);
        File tmp = Util.createTempFile((String)"workspaceFile", (String)"bankOrder", (boolean)false);
        if (!orderFile.renameTo(tmp)) {
            Files.copy(orderFile.toPath(), tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        wf.setPath(tmp.getName());
        DB.save((Object)wf);
        return wf;
    }

    public static synchronized boolean checkForDoubleTransmission(String bankOrderString) {
        if (sendingOrders == null) {
            sendingOrders = new HashSet<String>();
        }
        return sendingOrders.add(bankOrderString);
    }

    public static void finishedBankOrder(String bankOrderString) {
        if (sendingOrders != null) {
            sendingOrders.remove(bankOrderString);
        }
    }

    public static List<BankOrderWithPayments> getBankOrdersFromRequestString(User user, String requestString, List<String> additionalInfos, List<Boolean> useVop, Locale locale) throws DisplayFileException, KnownFormatException, IOException {
        if (requestString == null || requestString.isEmpty()) {
            return null;
        }
        ArrayList<BankOrderWithPayments> result = new ArrayList<BankOrderWithPayments>();
        Matcher m = Pattern.compile("\\(([^#\\)]*)(#[^\\)]*)?\\)").matcher(requestString);
        int orderIndex = -1;
        while (m.find()) {
            Query q;
            List<Integer> idsList;
            SigningInfo signingInfo;
            ++orderIndex;
            BankOrder bankOrder = BankOrder.fromString(user, m.group(1), locale);
            if (bankOrder == null) {
                return null;
            }
            if (additionalInfos != null && additionalInfos.size() > orderIndex && (signingInfo = bankOrder.getDisplayMessage().getSigningInfo()) != null) {
                signingInfo.setAdditionalOrderInfo(additionalInfos.get(orderIndex));
            }
            if (useVop != null && useVop.size() > orderIndex && Boolean.TRUE.equals(useVop.get(orderIndex))) {
                boolean vopAllowed;
                PaymentTransferType.PmtType orderPmtType = bankOrder.getPmtType() != null ? bankOrder.getPmtType() : SendParameters.getPmtType((BankSettings)bankOrder.getBank(), (String)bankOrder.getOrderType());
                boolean bl = vopAllowed = PaymentUtils.getSupportedVopPaymentTypes(true).contains(orderPmtType) && VopUtil.hasVopPermission((User)user, (BankSettings)bankOrder.getBank(), (PaymentTransferType.PmtType)bankOrder.getPmtType());
                if (vopAllowed) {
                    bankOrder.setUseVop(true);
                    if (BankUtils.isProtocolH005OrNewer((String)bankOrder.getBank().getProtocolVersion())) {
                        bankOrder.setOrderType(SendParameters.getBTFVop((BankSettings)bankOrder.getBank(), (PaymentTransferType.PmtType)orderPmtType));
                    } else {
                        bankOrder.setOrderType(SendParameters.getOrderTypeVop((BankSettings)bankOrder.getBank(), (PaymentTransferType.PmtType)orderPmtType));
                    }
                }
            }
            String openPaymentIds = m.group(2);
            List openPayments = null;
            if (openPaymentIds != null && !openPaymentIds.isEmpty() && !(idsList = GeneralUtils.getSelectionIds(openPaymentIds.substring(1))).isEmpty() && (openPayments = (q = OpenPayments.getQueryCheckPermission(user).where().in("id", idsList).orderBy("id").query()).findList()) != null) {
                Iterator iter = openPayments.iterator();
                while (iter.hasNext()) {
                    OpenPayment openPayment = (OpenPayment)iter.next();
                    if (BankUser.findBankUser((BankSettings)openPayment.getBank(), (User)user) != null) continue;
                    iter.remove();
                    BLLoggerPlay.warning("BankOrderDebug: The open payment " + openPayment.getId() + " has been removed from the list of open payments for a bank order because User " + user.getName() + " (" + user.getId() + ") has no permission for the bank!");
                }
            }
            result.add(new BankOrderWithPayments(bankOrder, openPayments));
        }
        return BankOrderWithPayments.sortByPmtType(result);
    }

    public static String getRequestStringForBankOrders(List<BankOrderWithPayments> bankOrders) {
        if (bankOrders == null || bankOrders.isEmpty()) {
            return null;
        }
        List<BankOrderWithPayments> bankOrdersSorted = BankOrderWithPayments.sortByPmtType(bankOrders);
        StringBuilder result = new StringBuilder();
        for (BankOrderWithPayments bankOrder : bankOrdersSorted) {
            result.append('(').append(bankOrder.getBankOrder().toString());
            if (bankOrder.getOpenPayments() != null) {
                StringBuilder openPaymentIds = new StringBuilder();
                boolean firstPayment = true;
                for (OpenPayment openPayment : bankOrder.getOpenPayments()) {
                    if (openPayment.getId() == null) continue;
                    if (!firstPayment) {
                        openPaymentIds.append(',');
                    }
                    openPaymentIds.append(openPayment.getId());
                    firstPayment = false;
                }
                if (!openPaymentIds.toString().isEmpty()) {
                    result.append('#');
                    result.append((CharSequence)openPaymentIds);
                }
            }
            result.append(')');
        }
        return result.toString();
    }

    public static BankOrder fromString(User user, String bankOrderString, Locale locale) throws DisplayFileException, KnownFormatException, IOException {
        WorkspaceFile workspaceFile;
        DirectoryScanner directoryScanner;
        Integer recalledOrderId;
        long orderDataSize;
        int bankId;
        if (bankOrderString == null || bankOrderString.isEmpty()) {
            return null;
        }
        String[] parts = bankOrderString.split("-");
        int n = parts.length;
        if (n < 5 || n > 7) {
            return null;
        }
        String bankIdString = parts[0];
        String orderTypeOrBtf = parts[1];
        String orderFileIdString = parts[2];
        String orderDataSizeString = parts[3];
        String md5Hash = parts[4];
        String originalFileName = n >= 6 ? new String(Base64.getDecoder().decode(parts[5]), StandardCharsets.UTF_8) : null;
        String recalledOrderString = n == 7 ? parts[6] : null;
        ArrayList<Integer> recalledSignedPaymentIds = new ArrayList<Integer>();
        try {
            bankId = Integer.parseInt(bankIdString);
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to parse bank id from order string!", e);
            return null;
        }
        try {
            orderDataSize = Long.parseLong(orderDataSizeString);
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to parse order data size from order string!", e);
            return null;
        }
        if (recalledOrderString == null) {
            recalledOrderId = null;
        } else {
            String[] recalledOrderIdStringParts = recalledOrderString.split(":");
            String recalledOrderIdString = recalledOrderIdStringParts[0];
            try {
                recalledOrderId = Integer.parseInt(recalledOrderIdString);
            }
            catch (NumberFormatException e) {
                BLLoggerPlay.error("Failed to parse recalled send order id from order string!", e);
                return null;
            }
            if (recalledOrderIdStringParts.length > 1) {
                String[] ids;
                String recalledSignedPaymentsString = recalledOrderIdStringParts[1];
                for (String id2 : ids = recalledSignedPaymentsString.split(",")) {
                    try {
                        int recalledSignedPaymentId = Integer.parseInt(id2);
                        recalledSignedPaymentIds.add(recalledSignedPaymentId);
                    }
                    catch (NumberFormatException e) {
                        BLLoggerPlay.error("Failed to parse recalled send order id from order string!", e);
                        return null;
                    }
                }
            }
        }
        if (orderFileIdString.indexOf(58) > 0) {
            String[] orderFileInfo = orderFileIdString.split(":", 2);
            directoryScanner = (DirectoryScanner)DB.find(DirectoryScanner.class, (Object)Integer.parseInt(orderFileInfo[0]));
            if (directoryScanner == null) {
                BLLoggerPlay.error("No directory scanner present with ID " + orderFileInfo[0] + "!");
                return null;
            }
            workspaceFile = (WorkspaceFile)DB.find(WorkspaceFile.class, (Object)orderFileInfo[1]);
        } else {
            workspaceFile = (WorkspaceFile)DB.find(WorkspaceFile.class, (Object)orderFileIdString);
            directoryScanner = null;
        }
        if (workspaceFile == null) {
            BLLoggerPlay.error("WorkspaceFile with id " + orderFileIdString + " not found!");
            return null;
        }
        if (!WorkspaceFileSystem.getFile((WorkspaceFile)workspaceFile).isFile()) {
            BLLoggerPlay.error("File " + WorkspaceFileSystem.toFile((WorkspaceFile)workspaceFile).getAbsolutePath() + " has been deleted!");
            return null;
        }
        BankSettings bank = BankSettings.getById((Integer)(bankId + 1));
        if (bank == null) {
            BLLoggerPlay.error("No bank found with ID " + bankId);
            return null;
        }
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (bankUser == null) {
            BLLoggerPlay.error("Bank " + bankId + " is not configured for user " + user.getId());
            return null;
        }
        if (directoryScanner != null) {
            return new BankOrder(bankUser, orderTypeOrBtf, workspaceFile, orderDataSize, md5Hash, directoryScanner, null, null, originalFileName, locale);
        }
        if (recalledOrderId != null) {
            Send originalOrder = (Send)DB.find(Send.class, (Object)recalledOrderId);
            List<SignedPayment> originalSignedPayments = recalledSignedPaymentIds.stream().map(id -> (SignedPayment)DB.find(SignedPayment.class, (Object)id)).toList();
            return new BankOrder(bankUser, orderTypeOrBtf, workspaceFile, orderDataSize, md5Hash, null, originalOrder, originalSignedPayments, originalFileName, locale);
        }
        return new BankOrder(bankUser, orderTypeOrBtf, workspaceFile, orderDataSize, md5Hash, null, null, null, originalFileName, locale);
    }

    public Send getRecalledOrder() {
        return this.recalledOrder;
    }

    public List<SignedPayment> getRecalledSignedOrders() {
        if (this.recalledSignedPayments != null && !this.recalledSignedPayments.isEmpty()) {
            return this.recalledSignedPayments;
        }
        if (this.recalledOrder != null) {
            return SignedPayment.findBySend((Send)this.recalledOrder);
        }
        return new ArrayList<SignedPayment>();
    }

    public static void createSignedPaymentsForAllUnknownSendOrders(Tenant tenant, User user, BankOrderResultHandler resultHandler, List<PaymentFolder> folders2) throws DisplayFileException, KnownFormatException, IOException {
        ExpressionList query = DB.find(Send.class).where();
        if (tenant != null) {
            query = query.eq("bank.tenant", (Object)tenant);
        }
        for (Send send : query.or(Expr.isNull((String)"signedPayments"), Expr.eq((String)"signedPayments", (Object)Send.SignedPayments.UNKNOWN)).findList()) {
            File orderFile;
            if (send.getFile() == null || !(orderFile = WorkspaceFileSystem.getFile((WorkspaceFile)send.getFile())).isFile() || orderFile.length() == 0L) continue;
            BankUser bankUser = BankUser.findBankUser((BankSettings)send.getBank(), (User)user);
            if (bankUser == null) {
                bankUser = new BankUser();
                bankUser.setBank(send.getBank());
                bankUser.setUser(user);
            }
            boolean manual = send.getOrigFileName() == null || send.getOrigFileName().contains("payments") && send.getOrigFileName().contains("orders") && send.getOrigFileName().contains("Order");
            BankOrder.createSignedPayments(bankUser, orderFile, send, manual, resultHandler, folders2);
        }
    }

    public static List<BankOrderPayment<PaymentHandler<?>>> loadPayments(Query<OpenPayment> openPaymentQuery, User user) throws PaymentException {
        ArrayList result = new ArrayList();
        for (OpenPayment openPayment : openPaymentQuery.findList()) {
            if (BankUser.findBankUser((BankSettings)openPayment.getBank(), (User)user) == null) continue;
            PaymentHandler<?> handler = PaymentHandler.getHandler(openPayment.getPmtType(), openPayment.getPaymentData());
            result.add(new BankOrderPayment(openPayment, handler));
        }
        return result;
    }

    public static List<BankOrderPayment<PaymentHandler<?>>> loadPaymentsToSign(Query<OpenPayment> openPaymentQuery, User user) throws PaymentException {
        ArrayList result = new ArrayList();
        for (OpenPayment openPayment : openPaymentQuery.findList()) {
            BankUser bankUser = BankUser.findBankUser((BankSettings)openPayment.getBank(), (User)user);
            if (bankUser == null || !BankUser.UserState.READY.equals((Object)bankUser.getState())) continue;
            PaymentHandler<?> handler = PaymentHandler.getHandler(openPayment.getPmtType(), openPayment.getPaymentData());
            result.add(new BankOrderPayment(openPayment, handler));
        }
        return result;
    }

    protected DisplayMessageAndDigest generateDisplayMessage() throws DisplayFileException, KnownFormatException, IOException {
        InputStream inputStream = null;
        try {
            SigningInfo signingInfo;
            boolean isCreditType;
            MessageDigest ripeMd160 = SignatureHandler.A004.getMessageDigest();
            MessageDigest sha256 = SignatureHandler.A005.getMessageDigest();
            inputStream = this.isExternalFile() ? new DigestInputStream(new DigestInputStream(Files.newInputStream(this.getOrderFile().toPath(), new OpenOption[0]), sha256), ripeMd160) : new DigestInputStream(new DigestInputStream(EncryptData.getInstance().openInputStream(this.getOrderFile()), sha256), ripeMd160);
            HashSet<Account> accounts2 = new HashSet<Account>();
            for (PaymentHandler<?> p : this.getPayments()) {
                Account account = p.getOriginatorAccount(this.bankUser.getBank());
                if (account == null) continue;
                accounts2.add(account);
            }
            boolean bl = isCreditType = this.getPmtType() != null && SepaApi.isCreditPmtType((PaymentTransferType.PmtType)this.getPmtType());
            if (this.getPmtType() != null && isCreditType) {
                checker = new SepaChecker(this.getPmtType(), this.locale);
                signingInfo = Util.parseSEPACreditFile((InputStream)inputStream, (BankSettings)this.bank, (Util.CheckServiceLevel)checker, (Util.CheckLocalInstruments)checker, (Locale)this.locale);
            } else if (this.getPmtType() != null && SepaApi.isDebitOrderType((String)this.orderType)) {
                checker = new SepaChecker(this.getPmtType(), this.locale);
                signingInfo = Util.parseSEPADebitFile((InputStream)inputStream, (BankSettings)this.bank, (Util.CheckDebitType)checker, (Locale)this.locale);
            } else {
                DisplayMessage displayMessage;
                DisplayMessageGenerator displayMessageGenerator = Util.getDisplayMessageGenerator((String)this.orderType);
                try {
                    displayMessage = displayMessageGenerator.getMessage(inputStream);
                }
                catch (Exception e) {
                    BLLoggerPlay.warning("Could not generate send order display message for " + this.orderType + ", using binary display message instead: " + e.getLocalizedMessage());
                    inputStream.close();
                    inputStream = this.isExternalFile() ? new DigestInputStream(new DigestInputStream(Files.newInputStream(this.getOrderFile().toPath(), new OpenOption[0]), sha256), ripeMd160) : new DigestInputStream(new DigestInputStream(EncryptData.getInstance().openInputStream(this.getOrderFile()), sha256), ripeMd160);
                    displayMessageGenerator = new BinaryGenerator();
                    displayMessage = displayMessageGenerator.getMessage(inputStream);
                }
                DisplayMessage e = displayMessage;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ticket.class, CCTTicket.class, CDxTicket.class, BulkMT101Ticket.class, CCCTicket.class, CDxContainerTicket.class, Pain001ZZV05Ticket.class, ATTHMTicket.class}, (Object)e, n)) {
                    case 0: {
                        Ticket ticket = (Ticket)e;
                        BigDecimal amount2 = ticket.getTotalAmount();
                        if (amount2 == null) {
                            amount2 = ticket.getTotalAmountInAnyCurrency();
                        }
                        signingInfo = new SigningInfo(displayMessage, amount2, ticket.getCurrency(), ticket.containsSalaryPayments());
                        break;
                    }
                    case 1: {
                        CCTTicket cctTicket = (CCTTicket)e;
                        signingInfo = new SigningInfo(displayMessage, cctTicket.getTotalAmount());
                        break;
                    }
                    case 2: {
                        CDxTicket cDxTicket = (CDxTicket)e;
                        signingInfo = new SigningInfo(displayMessage, cDxTicket.getTotalAmount());
                        break;
                    }
                    case 3: {
                        Currency currency;
                        BigDecimal totalAmount;
                        BulkMT101Ticket bulkMT101Ticket = (BulkMT101Ticket)e;
                        if (displayMessageGenerator instanceof MT101Generator) {
                            totalAmount = ((MT101Generator)displayMessageGenerator).getTotalAmount();
                            currency = ((MT101Generator)displayMessageGenerator).getCurrency();
                        } else {
                            totalAmount = null;
                            currency = null;
                        }
                        signingInfo = new SigningInfo(displayMessage, totalAmount, currency);
                        break;
                    }
                    case 4: {
                        CCCTicket cccTicket = (CCCTicket)e;
                        signingInfo = Util.getSigningInfoSEPACreditContainerFile((CCCTicket)cccTicket, (CCCDisplayMessageGenerator)((CCCDisplayMessageGenerator)displayMessageGenerator), (BankSettings)this.bank);
                        break;
                    }
                    case 5: {
                        CDxContainerTicket cDxContainerTicket = (CDxContainerTicket)e;
                        signingInfo = Util.getSigningInfoSEPADebitContainerFile((CDxContainerTicket)cDxContainerTicket, (CDxContainerDisplayMessageGenerator)((CDxContainerDisplayMessageGenerator)displayMessageGenerator), (BankSettings)this.bank);
                        break;
                    }
                    case 6: {
                        Currency currency;
                        BigDecimal totalAmount;
                        Pain001ZZV05Ticket pain001ZZV05Ticket = (Pain001ZZV05Ticket)e;
                        if (displayMessageGenerator instanceof MT101Generator) {
                            totalAmount = pain001ZZV05Ticket.getTotalAmount();
                            currency = Currency.getInstance((String)pain001ZZV05Ticket.getCurrency());
                        } else {
                            totalAmount = null;
                            currency = null;
                        }
                        signingInfo = new SigningInfo(displayMessage, totalAmount, currency);
                        break;
                    }
                    case 7: {
                        ATTHMTicket atthmTicket = (ATTHMTicket)e;
                        signingInfo = new SigningInfo(displayMessage, atthmTicket.getTotalAmount(), atthmTicket.getCurrency());
                        signingInfo.setNumberOfTxs(atthmTicket.getTotalNumberOfPayments());
                        signingInfo.setMessageId(((Pain00100103Ticket)atthmTicket.getSingleTickets().getFirst()).getMessageIdentification());
                        signingInfo.setAdditionalFileInfo("pain.001");
                        break;
                    }
                    default: {
                        signingInfo = new SigningInfo(displayMessage);
                    }
                }
                signingInfo.setAccounts(new ArrayList(accounts2));
            }
            DisplayMessageAndDigest result = new DisplayMessageAndDigest(signingInfo);
            result.setRipeMd160Digest(ripeMd160.digest());
            result.setSha256Digest(sha256.digest());
            DisplayMessageAndDigest displayMessageAndDigest = result;
            return displayMessageAndDigest;
        }
        catch (DisplayFileException | KnownFormatException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DisplayFileException("Failed to create display file! " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    BLLoggerPlay.warning("Failed to close input stream on bank order file " + this.getOrderFile().getAbsolutePath() + "!", e);
                }
            }
        }
    }

    public String getDigestHex() throws DisplayFileException, KnownFormatException, IOException {
        return HexTool.toHex((byte[])this.getDisplayMessage().digest(SignatureVersion.getInstance((String)this.bankUser.getSignatureVersion())));
    }

    public BankUser getBankUser() {
        return this.bankUser;
    }

    public String getOriginalFileName() {
        if (this.originalFileName != null && this.originalFileName.isEmpty()) {
            return null;
        }
        return this.originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public List<? extends PaymentHandler<?>> getPayments() {
        if (this.payments == null) {
            long limit = Long.parseLong(de.businesslogics.banking.preferences.PreferenceConstants.SEND_REPORT_MAX_FILE_SIZE_FOR_DETAILS.getDefaultValue());
            boolean isHandlerPresent = PaymentHandler.isHandlerPresent(this.getPmtType());
            if (isHandlerPresent && this.getOrderFileSize() < limit) {
                InputStream inputStream = null;
                try {
                    inputStream = this.isExternalFile() ? Files.newInputStream(this.getOrderFile().toPath(), new OpenOption[0]) : EncryptData.getInstance().openInputStream(this.getOrderFile());
                    this.payments = PaymentHandler.getHandlers(inputStream, this.getPmtType(), this.bankUser.getBank().getCountryCode());
                }
                catch (InvalidPasswordException | IOException | PaymentException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        Util.closeStream(inputStream);
                        throw throwable;
                    }
                }
                Util.closeStream((Closeable)inputStream);
            }
            if (this.payments == null) {
                this.payments = new ArrayList(0);
            }
        }
        return this.payments;
    }

    public String getAdditionalInfo() throws DisplayFileException, KnownFormatException, IOException {
        if (this.getDisplayMessage() != null && this.getDisplayMessage().getSigningInfo() != null) {
            return this.getDisplayMessage().getSigningInfo().getAdditionalOrderInfo();
        }
        return null;
    }

    public void checkPaymentInformation(User user, Locale locale, BankOrderCheckHandler checkHandler) {
        boolean isHandlerPresent = PaymentHandler.isHandlerPresent(this.getPmtType());
        if (!isHandlerPresent) {
            return;
        }
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, this.bank.getTenant());
        boolean allowInvalidBankConnection = preferenceStore.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
        boolean allowUnknownAccounts = preferenceStore.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_UNKNOWN_ACCOUNTS);
        boolean doLimitCheck = preferenceStore.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.CHECK_LIMIT);
        preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user);
        boolean sepaExtendedCheck = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.EXTENDED_FILE_CHECK);
        boolean allowInvalidCreditorId = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_CREDITOR_ID);
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)user);
        boolean useMandate = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
        if (allowInvalidBankConnection && allowUnknownAccounts && !sepaExtendedCheck && allowRecipientRecording && allowInvalidCreditorId && !doLimitCheck) {
            return;
        }
        for (PaymentHandler<?> paymentHandler : this.getPayments()) {
            if (!allowInvalidBankConnection && !paymentHandler.checkRecipientAccount()) {
                checkHandler.invalidBankConnection(paymentHandler.getRecipientAccount());
                return;
            }
            if (allowUnknownAccounts || paymentHandler.getOriginatorAccount(this.bank) != null) continue;
            checkHandler.unknownOriginatorAccount(paymentHandler.getOriginatorAccount());
            return;
        }
        if (sepaExtendedCheck || !allowInvalidCreditorId || !allowRecipientRecording) {
            ArrayList<SEPAPaymentData> sepaPayments = new ArrayList<SEPAPaymentData>();
            for (PaymentHandler<?> paymentHandler : this.getPayments()) {
                if (!(paymentHandler instanceof SepaPaymentHandler)) continue;
                sepaPayments.add((SEPAPaymentData)((SepaPaymentHandler)paymentHandler).getPayment());
            }
            if (!sepaPayments.isEmpty() && sepaExtendedCheck) {
                try {
                    SepaApi.doExtendedFileCheck(sepaPayments, (Locale)locale);
                }
                catch (KnownFormatException knownFormatException) {
                    checkHandler.handleException((Exception)((Object)knownFormatException));
                }
            }
            if (!sepaPayments.isEmpty() && !allowRecipientRecording) {
                for (SEPAPaymentData sEPAPaymentData : sepaPayments) {
                    PaymentType paymentType = !sEPAPaymentData.isCredit() && useMandate ? PaymentType.MANDATE : PaymentType.SEPA;
                    PaymentRecipient recipient = PaymentRecipient.findRecipientByAccountInfo((PaymentType)paymentType, null, (String)sEPAPaymentData.getRecipientIban(), null, (Tenant)this.bank.getTenant());
                    boolean confirmedRecipientExists = recipient != null && !recipient.isDeleted() && !recipient.isInProcess();
                    if (confirmedRecipientExists) continue;
                    String messageKey = sEPAPaymentData.isCredit() ? "ExtendedFileHandler.fileContainsUnknownRecipientAccount" : "ExtendedFileHandler.fileContainsUnknownPayerAccount";
                    String message = PaymentApiMessages.getString((Locale)locale, (String)messageKey, (Object[])new Object[]{sEPAPaymentData.getRecipientIban()});
                    checkHandler.handleException(new Exception(message));
                }
            }
            if (!allowInvalidCreditorId) {
                ArrayList<SEPAPaymentData> arrayList = new ArrayList<SEPAPaymentData>();
                for (SEPAPaymentData payment : sepaPayments) {
                    if (payment.isCredit()) continue;
                    arrayList.add(payment);
                }
                if (!arrayList.isEmpty()) {
                    try {
                        SepaApi.checkForInvalidCreditorIds(arrayList, (Locale)locale);
                    }
                    catch (KnownFormatException knownFormatException) {
                        checkHandler.handleException((Exception)((Object)knownFormatException));
                    }
                }
            }
        }
        if (doLimitCheck) {
            this.doLimitCheck(checkHandler, locale);
        }
    }

    private void doLimitCheck(BankOrderCheckHandler checkHandler, Locale locale) {
        HashMap<Account, BigDecimal> accountAmounts = new HashMap<Account, BigDecimal>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        String currency = null;
        for (PaymentHandler<?> p : this.getPayments()) {
            currency = currency == null ? p.getCurrencyCode() : (currency.equals(p.getCurrencyCode()) ? p.getCurrencyCode() : "");
            totalAmount = totalAmount.add(p.getAmount());
            Account originatorAccount = p.getOriginatorAccount(this.getBank());
            if (!p.getCurrencyCode().equals(originatorAccount.getCurrency())) continue;
            accountAmounts.put(originatorAccount, accountAmounts.getOrDefault(originatorAccount, BigDecimal.ZERO).add(p.getAmount()));
        }
        ArrayList messages = new ArrayList();
        this.doLimitCheck(this.bankUser, accountAmounts, totalAmount, currency, messages, locale);
        for (String message : messages) {
            checkHandler.exceededAmount(message);
        }
    }

    public Send storeSend(String orderId, boolean manual, BankOrderResultHandler resultHandler, PaymentTransferType.PmtType pmtType, List<PaymentFolder> folders2, String csvMd5Hash, String ipAddress) throws KnownFormatException, DisplayFileException, GeneralSecurityException, IOException {
        String sendFileType;
        String sendOrderType;
        String prefix;
        if (BTFTranslator.isBTFString((String)this.orderType)) {
            prefix = BTFTranslator.convertFrom((String)this.orderType).getMsgName().getValue();
            sendOrderType = "BTU";
            sendFileType = this.orderType;
        } else if (this.orderType.matches("[A-Z0-9]{3}")) {
            prefix = this.orderType;
            sendOrderType = this.orderType;
            sendFileType = null;
        } else {
            sendOrderType = "FUL";
            prefix = "FUL";
            sendFileType = this.orderType;
        }
        SigningInfo signingInfo = this.getDisplayMessage().getSigningInfo();
        File sentDir = new File(new File(Util.WORKSPACEDIR, "data"), "sent");
        File bankSentDir = new File(sentDir, this.getBank().getUniqueKey());
        if (!bankSentDir.isDirectory() && !bankSentDir.mkdirs()) {
            throw new IOException("Failed to create directory for sent file of a bank: " + bankSentDir.getAbsolutePath());
        }
        File sentFile = File.createTempFile(prefix + "_" + orderId + "_", ".data", bankSentDir);
        if (this.isExternalFile()) {
            Streams.copy((InputStream)Files.newInputStream(this.getOrderFile().toPath(), new OpenOption[0]), (OutputStream)EncryptData.getInstance().openOutputStream(sentFile));
            boolean fileArchived = false;
            if (this.directoryScanner.getArchiveDirectory() != null && !this.directoryScanner.getArchiveDirectory().isEmpty()) {
                File archiveDir = new File(this.directoryScanner.getArchiveDirectory());
                if (archiveDir.isDirectory() || archiveDir.mkdirs()) {
                    SystemUtils.renameFile((File)this.getOrderFile(), (File)new File(archiveDir, this.getOrderFile().getName()));
                    fileArchived = true;
                } else {
                    BLLoggerPlay.error("Could not move sent file to archive directory " + archiveDir.getAbsolutePath() + " - does not exist!");
                }
            }
            if (!fileArchived && !this.getOrderFile().delete()) {
                BLLoggerPlay.warning("Failed to delete order file " + this.getOrderFile().getAbsolutePath() + "!");
                this.getOrderFile().deleteOnExit();
            }
        } else {
            SystemUtils.renameFile((File)this.getOrderFile(), (File)sentFile);
        }
        Object sender = this.bankUser.getUser().getName() + " (" + this.bankUser.getBank().getCustomerId() + " / " + this.bankUser.getDefaultUser() + ")";
        if (((String)sender).length() > 255) {
            sender = ((String)sender).substring(255);
        }
        Send send = new Send();
        send.setBank(this.getBank());
        send.setSent(new Timestamp(System.currentTimeMillis()));
        WorkspaceFile workspaceFile = csvMd5Hash != null && !csvMd5Hash.isEmpty() ? WorkspaceFileSystem.createFile((WorkspaceFile.Prefix)WorkspaceFile.Prefix.DATA_SENT, (File)sentFile, (long)this.getOrderFileSize(), (String)csvMd5Hash, null) : WorkspaceFileSystem.createFile((WorkspaceFile.Prefix)WorkspaceFile.Prefix.DATA_SENT, (File)sentFile, (long)this.getOrderFileSize(), (String)this.md5Hash, null);
        send.setIpAddress(ipAddress);
        send.setFile(workspaceFile);
        send.setOrigFileName(this.originalFileName);
        send.setState(Send.State.SENT);
        send.setSender((String)sender);
        send.setFileType(sendFileType);
        send.setOrderType(sendOrderType);
        send.setOrderNumber(orderId);
        if (pmtType == null) {
            pmtType = SendParameters.getPmtType((BankSettings)this.getBank(), (String)(sendFileType == null ? sendOrderType : sendFileType));
        }
        send.setPmtType(pmtType);
        if (signingInfo != null) {
            send.setAmount(signingInfo.getAmount());
            if (signingInfo.getCurrency() != null) {
                send.setCurrency(signingInfo.getCurrency().getCurrencyCode());
            }
            send.setWithSelaries(signingInfo.containsSalaryPayments());
            send.setAccounts(signingInfo.getAccounts());
            send.setMsgId(signingInfo.getMessageId());
            send.setNbOfTxs(Integer.valueOf(signingInfo.getNumberOfTxs()));
            send.setScheme(signingInfo.getAdditionalFileInfo());
            send.setAdditionalOrderInfo(signingInfo.getAdditionalOrderInfo());
        }
        send.save();
        BankOrder.createSignedPayments(this.bankUser, sentFile, send, manual, resultHandler, folders2);
        return send;
    }

    public File getOrderFile() {
        return WorkspaceFileSystem.getFile((WorkspaceFile)this.workspaceFile);
    }

    public String toString() {
        int separator = 45;
        Object orderFileId = "";
        if (this.directoryScanner != null && this.workspaceFile != null) {
            orderFileId = this.directoryScanner.getId() + ":" + this.workspaceFile.getId();
        } else if (this.workspaceFile != null) {
            orderFileId = (String)orderFileId + this.workspaceFile.getId();
        }
        Object recalledOrderPart = "";
        if (this.recalledOrder != null || this.recalledSignedPayments != null && !this.recalledSignedPayments.isEmpty()) {
            String orderId = this.recalledOrder != null ? this.recalledOrder.getId().toString() : this.recalledSignedPayments.getFirst().getSend().getId().toString();
            String signedPaymentIds = this.recalledSignedPayments != null && !this.recalledSignedPayments.isEmpty() ? this.recalledSignedPayments.stream().map(s -> s.getId().toString()).collect(Collectors.joining(",")) : SignedPayment.findBySend((Send)this.recalledOrder).stream().map(s -> s.getId().toString()).collect(Collectors.joining(","));
            recalledOrderPart = orderId + ":" + signedPaymentIds;
        }
        String filename = "";
        if (this.originalFileName != null && !this.originalFileName.isEmpty()) {
            filename = Base64.getEncoder().encodeToString(this.originalFileName.getBytes(StandardCharsets.UTF_8));
        }
        return this.bank.getUniqueKey() + "-" + this.orderType + "-" + (String)orderFileId + "-" + this.getOrderFileSize() + "-" + this.md5Hash + "-" + filename + "-" + (String)recalledOrderPart;
    }

    private static void createSignedPayments(BankUser bankUser, File sentFile, Send send, boolean manual, BankOrderResultHandler resultHandler, List<PaymentFolder> folders2) {
        BACKGROUND_PROCESSING.submit(() -> {
            boolean isHandlerPresent = PaymentHandler.isHandlerPresent(send.getPmtType());
            if (!isHandlerPresent) {
                return;
            }
            User user = bankUser.getUser();
            Tenant tenant = bankUser.getBank().getTenant();
            boolean createSignedPayments = manual || new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, tenant).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SHOW_ALL_SIGNED_PAYMENTS);
            AwvPaymentReportCollector awvCollector = new DatabasePreferenceStore(Preference.ApplicationId.AWZEL, user, tenant).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.awzel.PreferenceConstants.COLLECT_FROM_PAYMENTS) ? new AwvPaymentReportCollector() : null;
            if (!createSignedPayments && awvCollector == null) {
                return;
            }
            InputStream inputStream = null;
            int awvCollectorCount = 0;
            int folderIndex = 0;
            try (Transaction t = DB.beginTransaction();){
                inputStream = EncryptData.getInstance().openInputStream(sentFile);
                SignedPayment signedPayment = null;
                List<PaymentHandler<?>> paymentHandlers = PaymentHandler.getHandlers(inputStream, send.getPmtType(), bankUser.getBank().getCountryCode());
                for (PaymentHandler<?> paymentHandler : paymentHandlers) {
                    AwvPaymentReportCollector.PaymentInfo paymentInfo;
                    if (createSignedPayments) {
                        signedPayment = new SignedPayment();
                        signedPayment.setSend(send);
                        signedPayment.setManualPayment(manual);
                        signedPayment.setPmtType(send.getPmtType());
                        paymentHandler.updateSignedPayment(signedPayment);
                        PaymentFolder folder = folders2.size() > folderIndex ? (PaymentFolder)folders2.get(folderIndex++) : null;
                        signedPayment.setFolder(folder);
                        signedPayment.setOriginator(paymentHandler.getOriginator());
                        signedPayment.save();
                        if (send.getSignedPayments() != Send.SignedPayments.EXIST) {
                            send.setSignedPayments(Send.SignedPayments.EXIST);
                            send.save();
                        }
                    }
                    if (awvCollector == null || !awvCollector.checkPayment(paymentInfo = signedPayment == null ? new AwvPaymentReportCollector.PaymentInfo(bankUser.getBank(), paymentHandler) : new AwvPaymentReportCollector.PaymentInfo(signedPayment)) || !awvCollector.checkForUnknownExchangeRate(paymentInfo) || awvCollector.storePayment(paymentInfo) == null) continue;
                    ++awvCollectorCount;
                }
                t.commit();
            }
            catch (IOException | GeneralSecurityException | PaymentException e) {
                send.setSignedPayments(Send.SignedPayments.NEVER);
                BLLoggerPlay.error("Failed to create signed payments from bank order!", e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        BLLoggerPlay.warning("Failed to close input stream on order file " + sentFile.getAbsolutePath() + "!", e);
                    }
                }
            }
            if (awvCollectorCount > 0 && resultHandler != null) {
                resultHandler.createdAwvReports(awvCollectorCount);
            }
        });
    }

    public boolean isExternalFile() {
        return this.directoryScanner != null;
    }

    public void handleSendFailed() {
        if (this.directoryScanner != null && this.directoryScanner.getErrorDirectory() != null) {
            try {
                SystemUtils.renameFile((File)this.getOrderFile(), (File)new File(this.directoryScanner.getErrorDirectory(), this.getOrderFile().getName()));
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to move bank order file " + this.getOrderFile().getAbsolutePath() + " to error directory " + this.directoryScanner.getErrorDirectory());
            }
        }
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public boolean containsSingleBookingSalaPayment() {
        for (PaymentHandler<?> handler : this.payments) {
            if (!(handler instanceof SepaPaymentHandler) || !handler.isSalaryPayment() || !((SEPAPaymentData)((SepaPaymentHandler)handler).getPayment()).displayAsSingleBooking()) continue;
            return true;
        }
        return false;
    }

    public void deleteFile() {
        WorkspaceFileSystem.delete((WorkspaceFile)this.workspaceFile);
    }

    public void setUseVop(boolean useVop) {
        this.useVop = useVop;
    }

    public boolean isVopOrder() {
        return this.useVop;
    }
}

