/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.awzel.PreferenceConstants;
import de.businesslogics.banking.awzel.api.AwzelApi;
import de.businesslogics.banking.awzel.api.PaymentReportCollector;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.Date;
import models.payments.PaymentException;
import models.payments.PaymentHandler;

public final class AwvPaymentReportCollector
extends PaymentReportCollector<PaymentInfo> {
    protected Account getOriginatorAccount(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getPayment() == null) {
            return null;
        }
        return paymentInfo.getPayment().getOriginatorAccount(paymentInfo.getBank());
    }

    protected Date getExecutionDate(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getPayment() == null) {
            return null;
        }
        return paymentInfo.getPayment().getExecutionDate();
    }

    protected String getReference(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getPayment() == null) {
            return null;
        }
        return paymentInfo.getPayment().getReference();
    }

    protected BigDecimal getAmount(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getPayment() == null) {
            return null;
        }
        return paymentInfo.getPayment().getAmount();
    }

    protected Currency getCurrency(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getPayment() == null || paymentInfo.getPayment().getCurrencyCode() == null || paymentInfo.getPayment().getCurrencyCode().length() == 0) {
            return null;
        }
        return Currency.getInstance((String)paymentInfo.getPayment().getCurrencyCode());
    }

    protected String getRecipientISOCountry(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getPayment() == null) {
            return null;
        }
        return paymentInfo.getPayment().getRecipientCountry();
    }

    protected String getPurpose(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getPayment() == null) {
            return null;
        }
        return paymentInfo.getPayment().getPurpose();
    }

    protected Tenant getTenant(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getBank() == null) {
            return null;
        }
        return paymentInfo.getBank().getTenant();
    }

    protected SignedPayment getSignedPayment(PaymentInfo payment) {
        return payment.signedPayment;
    }

    public boolean checkForUnknownExchangeRate(PaymentInfo paymentInfo) {
        return "always".equals(new DatabasePreferenceStore(Preference.ApplicationId.AWZEL, null, paymentInfo.getBank().getTenant()).getString((DatabasePreferenceConstant)PreferenceConstants.REPORT_WITHOUT_CONVERSION)) || AwzelApi.getAmountInEuro((BigDecimal)this.getAmount(paymentInfo), (Currency)this.getCurrency(paymentInfo)) != null;
    }

    public static final class PaymentInfo {
        private final BankSettings bank;
        private final PaymentHandler<?> paymentHandler;
        private final SignedPayment signedPayment;

        public PaymentInfo(SignedPayment signedPayment) throws PaymentException {
            this.signedPayment = signedPayment;
            this.bank = signedPayment.getSend().getBank();
            this.paymentHandler = PaymentHandler.getHandler(signedPayment.getPmtType(), signedPayment.getPaymentData());
        }

        public PaymentInfo(BankSettings bank, PaymentHandler<?> paymentHandler) {
            this.bank = bank;
            this.paymentHandler = paymentHandler;
            this.signedPayment = null;
        }

        private BankSettings getBank() {
            return this.bank;
        }

        private PaymentHandler<?> getPayment() {
            return this.paymentHandler;
        }
    }
}

