/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.awzel.PreferenceConstants;
import de.businesslogics.banking.awzel.api.AwzelApi;
import de.businesslogics.banking.awzel.api.StatementBookingReportCollector;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;

public final class AwvBookingsCollector
extends StatementBookingReportCollector
implements StatementBookingReportHandler {
    public void initialize() {
    }

    public void handle(CmBooking booking) {
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.AWZEL, null, booking.getAccount().getBank().getTenant());
        if (!preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.COLLECT_FROM_STATEMENTS) || !this.checkBooking(booking)) {
            return;
        }
        if (AwzelApi.getAmountInEuro((BigDecimal)booking.getAmount(), (Currency)booking.getCurrency()) == null && !"always".equals(preferenceStore.getString((DatabasePreferenceConstant)PreferenceConstants.REPORT_WITHOUT_CONVERSION))) {
            return;
        }
        this.storeStatementBooking(booking);
    }

    public void showInfoMessage() {
    }
}

