/*
 * Decompiled with CFR 0.152.
 */
package controllers.cm;

import controllers.cm.CmPostProcessing;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.BundesbankDtaProcessingApi;
import de.businesslogics.banking.mt940.api.BundesbankSwiftProcessingApi;
import de.businesslogics.banking.mt940.api.Camt054ProcessingApi;
import de.businesslogics.banking.mt940.api.DTIProcessingApi;
import de.businesslogics.banking.mt940.bka.api.BKAProcessing;
import de.businesslogics.banking.mt940.bka.api.BKIProcessing;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.banking.transfer.api.UserProcessing;
import de.businesslogics.util.BLLogger;
import models.cm.CmUtils;

public class CmSchedulerPostProcessing
implements UserProcessing {
    BLLogger logger;
    EncryptData encrypt;
    DatabasePreferenceStore preferences;
    Tenant tenant;

    public void doPostProcessing(Fetch item) {
    }

    public void doPostProcessing(Fetch item, User user) throws Exception {
        if (item == null) {
            return;
        }
        String orderType = item.getOrderType();
        if (orderType == null) {
            return;
        }
        this.tenant = item.getBank().getTenant();
        this.logger = BLLoggerPlay.getLogger();
        this.encrypt = EncryptData.getInstance();
        this.preferences = new DatabasePreferenceStore(Preference.ApplicationId.CM, user, this.tenant);
        CmPostProcessing staVmkProcessing = new CmPostProcessing(null, this.logger, this.encrypt, user, this.tenant, CmUtils.getReportHandlers());
        staVmkProcessing.doPostProcessing(item);
        if (staVmkProcessing.isWorkDone()) {
            return;
        }
        BKAProcessing bkaProcessing = new BKAProcessing(this.encrypt, this.preferences.getString((DatabasePreferenceConstant)CmPreferenceConstants.BKA_EXPORT_DIRECTORY), this.logger);
        bkaProcessing.doPostProcessing(item);
        if (bkaProcessing.isWorkDone()) {
            return;
        }
        BKIProcessing bkiProcessing = new BKIProcessing(this.encrypt, this.preferences.getString((DatabasePreferenceConstant)CmPreferenceConstants.BKA_EXPORT_DIRECTORY), this.logger);
        bkiProcessing.doPostProcessing(item);
        if (bkiProcessing.isWorkDone()) {
            return;
        }
        Processing processing = this.findProcessing(orderType);
        if (processing != null) {
            if (processing instanceof UserProcessing) {
                ((UserProcessing)processing).doPostProcessing(item, user);
            }
            processing.doPostProcessing(item);
        }
    }

    private Processing findProcessing(String orderType) {
        switch (orderType) {
            case "C54": 
            case "X54": {
                return new Camt054ProcessingApi(this.logger, this.encrypt, this.preferences, CmUtils.getReportHandlers());
            }
            case "DTI": 
            case "YCG": 
            case "YCL": 
            case "YCD": 
            case "QE1": 
            case "QE3": 
            case "QE5": {
                return new DTIProcessingApi(this.logger, this.encrypt, this.preferences, CmUtils.getReportHandlers());
            }
            case "YG1": 
            case "YGB": 
            case "YLB": 
            case "YGD": 
            case "QG3": 
            case "QE2": 
            case "QE4": 
            case "QE6": {
                return new BundesbankDtaProcessingApi(this.logger, this.encrypt, this.preferences, CmUtils.getReportHandlers());
            }
            case "YWA": 
            case "QWA": 
            case "YG2": 
            case "QG4": 
            case "YGS": 
            case "YCS": 
            case "QEB": 
            case "QE7": {
                return new BundesbankSwiftProcessingApi(this.logger, this.encrypt, this.preferences, CmUtils.getReportHandlers());
            }
        }
        return null;
    }
}

