/*
 * Decompiled with CFR 0.152.
 */
package controllers.cm;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmCheck;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.CmReporterApi;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CmCheckReporter
extends CmReporterApi {
    private boolean doCheckNewStatements = true;

    public static void markNewStatements(Collection<CmStatement> newStatements, Collection<CmPage> newPages, boolean onlyForActiveUsers) {
        try (Transaction transaction = DB.beginTransaction();){
            HashMap<User, Boolean> userHighlightsNewStatements = new HashMap<User, Boolean>();
            HashSet<Account> accounts2 = new HashSet<Account>();
            if (newStatements != null) {
                for (CmStatement statement : newStatements) {
                    for (User user : CmCheckReporter.getUsersToSetStatementsCheckedFor(statement.getAccount().getBank(), userHighlightsNewStatements, onlyForActiveUsers)) {
                        CmCheck.setChecked((User)user, (CmStatement)statement, (boolean)true);
                    }
                    accounts2.add(statement.getAccount());
                }
            }
            if (newPages != null) {
                for (CmPage page : newPages) {
                    for (User user : CmCheckReporter.getUsersToSetStatementsCheckedFor(page.getStatement().getAccount().getBank(), userHighlightsNewStatements, onlyForActiveUsers)) {
                        CmCheck.setChecked((User)user, (CmPage)page, (boolean)true);
                    }
                    accounts2.add(page.getStatement().getAccount());
                }
            }
            for (Account account : accounts2) {
                for (Integer obsoleteAdviceId : ValueBalanceCalculator.getObsoleteAdviceIds((Account)account, (CmStatement)CmStatement.findNewestStatement((Account)account, (Date)null))) {
                    CmCheck.deleteByStatement((int)obsoleteAdviceId);
                }
            }
            transaction.commit();
        }
    }

    private static Set<User> getUsersToSetStatementsCheckedFor(BankSettings b, Map<User, Boolean> userHighlightsNewStatements, boolean onlyForActiveUsers) {
        List bankUsers = onlyForActiveUsers ? BankUser.findActiveBankUsersForBank((BankSettings)b) : BankUser.findAllBankUsersForBank((BankSettings)b);
        HashSet<User> result = new HashSet<User>();
        for (BankUser bankUser : bankUsers) {
            if (!userHighlightsNewStatements.containsKey(bankUser.getUser())) {
                DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, bankUser.getUser());
                userHighlightsNewStatements.put(bankUser.getUser(), !"NONE".equals(store.getString((DatabasePreferenceConstant)CmPreferenceConstants.HIGHLIGHT_NEW_STATEMENTS)));
            }
            if (!userHighlightsNewStatements.get(bankUser.getUser()).booleanValue()) continue;
            result.add(bankUser.getUser());
        }
        return result;
    }

    public CmCheckReporter(CmReporter.Mode mode, BLLogger logger, EncryptData encrypt, User user, List<StatementBookingReportHandler> reportHandlers) {
        super(mode, logger, encrypt, user, reportHandlers);
    }

    public CmCheckReporter(CmReporter.Mode mode, String format, BLLogger logger, EncryptData encrypt, User user, List<StatementBookingReportHandler> reportHandlers) {
        super(mode, format, logger, encrypt, user, reportHandlers);
    }

    private void checkNewStatements() {
        if (!this.doCheckNewStatements) {
            return;
        }
        if (!CmReporter.Mode.MIGRATE.equals((Object)this.mode)) {
            CmCheckReporter.markNewStatements(this.newStatements, this.newPages, true);
        }
    }

    protected void newStatementsFetched() {
        this.checkNewStatements();
    }

    protected void newStatementsImported() {
        this.checkNewStatements();
    }

    protected void newAdvicesFetched() {
        this.checkNewStatements();
    }

    protected void newAdvicesImported() {
        this.checkNewStatements();
    }

    protected void newDtiFilesFetched() {
        this.checkNewStatements();
    }

    protected void newDtiFilesImported() {
        this.checkNewStatements();
    }

    public boolean isDoCheckNewStatements() {
        return this.doCheckNewStatements;
    }

    public void setDoCheckNewStatements(boolean doCheckNewStatements) {
        this.doCheckNewStatements = doCheckNewStatements;
    }
}

