/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding.scim;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.branding.scim.SCIMApiEndpoint;
import controllers.branding.scim.SCIMGroup;
import controllers.branding.scim.routes;
import de.businesslogics.banking.database.vo.User;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import play.mvc.Result;
import play.mvc.Results;

public abstract class SCIMUtil {
    public static String getOptionalJsonFieldValue(JsonNode json, String jsonKey, String defaultValue) {
        String fieldContent;
        JsonNode field = SCIMUtil.getJsonFieldInternal(json, jsonKey);
        String string = fieldContent = field == null ? null : field.asText();
        if (fieldContent == null || fieldContent.isEmpty()) {
            if (defaultValue != null && !defaultValue.isEmpty()) {
                SCIMApiEndpoint.SCIM_LOGGER.warn("Could not find JSON field '" + jsonKey + "', using default value '" + defaultValue + "' instead.");
            }
            return defaultValue;
        }
        return fieldContent;
    }

    public static String getMandatoryJsonFieldValue(JsonNode json, String jsonKey) throws SCIMApiEndpoint.MandatoryFieldMissingException {
        return SCIMUtil.getMandatoryJsonField(json, jsonKey).textValue();
    }

    public static JsonNode getMandatoryJsonField(JsonNode json, String jsonKey) throws SCIMApiEndpoint.MandatoryFieldMissingException {
        JsonNode field = SCIMUtil.getJsonFieldInternal(json, jsonKey);
        if (field == null) {
            throw new SCIMApiEndpoint.MandatoryFieldMissingException("Could not find mandatory JSON field '" + jsonKey + "'!");
        }
        return field;
    }

    public static JsonNode getJsonFieldInternal(JsonNode json, String jsonKey) {
        String[] path = jsonKey.split("\\.");
        for (int i = 0; i < path.length; ++i) {
            JsonNode pathElement = json.get(path[i]);
            if (pathElement == null) {
                return null;
            }
            if (i == path.length - 1) {
                return pathElement;
            }
            json = pathElement;
        }
        return null;
    }

    public static void logError(String description, Exception exception) {
        description = description == null ? "" : description;
        Object exceptionDescription = "";
        if (exception != null) {
            description = !((String)description).isEmpty() ? (String)description + "\n" : description;
            String stacktrace = "\n\t" + Arrays.stream(exception.getStackTrace()).map(StackTraceElement::toString).reduce((s1, s2) -> s1 + "\n\t" + s2).orElse("");
            exceptionDescription = exception.getMessage() + stacktrace;
        }
        SCIMApiEndpoint.SCIM_LOGGER.error((String)description + (String)exceptionDescription);
    }

    public static Result cannotProcess(String methodName, String resourceType) throws JsonProcessingException {
        String message = "Received a '" + methodName + "' call for resource type '" + resourceType + "' which cannot be processed by the Server.";
        return SCIMUtil.errorResult(405, message, null);
    }

    public static Result errorResult(SCIMApiEndpoint.ErrorResultException exception) throws JsonProcessingException {
        return SCIMUtil.errorResult(exception.getStatusCode(), exception.getDescription(), exception.getScimType());
    }

    public static Result errorResult(int statusCode, String description, SCIMApiEndpoint.ScimErrorResponseType scimType) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put("status", statusCode);
        if (description != null) {
            rootNode.put("detail", description);
        }
        if (scimType != null) {
            rootNode.put("scimType", scimType.toString());
        }
        ArrayNode schemas = mapper.createArrayNode();
        schemas.add("urn:ietf:params:scim:api:messages:2.0:Error");
        rootNode.set("schemas", (JsonNode)schemas);
        String payload = mapper.writeValueAsString((Object)rootNode);
        SCIMApiEndpoint.SCIM_LOGGER.warn("Returned error status: [" + statusCode + "] " + description);
        return Results.status((int)405, (String)payload).as("application/scim+json");
    }

    public static ObjectNode getJsonUserRepresentation(User forUser, ObjectMapper mapper, char[] passwordToInclude, boolean includeGroupMemberships) {
        Timestamp lastLogin;
        boolean hasFamilyName;
        boolean newUser = passwordToInclude != null;
        ObjectNode rootNode = mapper.createObjectNode();
        String uuid = forUser.getOrCreateUUID().toString();
        rootNode.put("id", uuid);
        rootNode.put("userName", forUser.getName());
        boolean hasGivenName = forUser.getGivenName() != null && !forUser.getGivenName().isEmpty();
        boolean bl = hasFamilyName = forUser.getFamilyName() != null && !forUser.getFamilyName().isEmpty();
        if (hasGivenName || hasFamilyName) {
            ObjectNode nameNode = mapper.createObjectNode();
            if (hasGivenName) {
                nameNode.put("givenName", forUser.getGivenName());
            }
            if (hasFamilyName) {
                nameNode.put("familyName", forUser.getFamilyName());
            }
            rootNode.set("name", (JsonNode)nameNode);
        }
        if (forUser.getEmail() != null && !forUser.getEmail().isEmpty()) {
            ArrayNode emailsNode = mapper.createArrayNode();
            ObjectNode workEmailNode = mapper.createObjectNode();
            workEmailNode.put("value", forUser.getEmail());
            workEmailNode.put("type", "work");
            workEmailNode.put("primary", true);
            emailsNode.add((JsonNode)workEmailNode);
            rootNode.set("emails", (JsonNode)emailsNode);
        }
        rootNode.put("active", SCIMUtil.isUserActive(forUser));
        if (passwordToInclude != null) {
            rootNode.put("password", new String(passwordToInclude));
        }
        if ((lastLogin = forUser.getLastLogin()) != null) {
            rootNode.put("lastLogin", lastLogin.toString());
        } else {
            rootNode.put("lastLogin", "null");
        }
        if (includeGroupMemberships) {
            ArrayNode groupsNode = mapper.createArrayNode();
            for (SCIMGroup group : SCIMGroup.getGroups(forUser)) {
                String groupUUID = group.getUUID().toString();
                ObjectNode groupNode = mapper.createObjectNode();
                groupNode.put("value", groupUUID);
                groupNode.put("displayName", group.getDisplayName());
                groupNode.put("$ref", routes.SCIMApiEndpoint.read("Groups", groupUUID).toString());
                groupsNode.add((JsonNode)groupNode);
            }
            rootNode.set("groups", (JsonNode)groupsNode);
        }
        ArrayNode schemas = mapper.createArrayNode();
        schemas.add("urn:ietf:params:scim:schemas:core:2.0:User");
        rootNode.set("schemas", (JsonNode)schemas);
        ObjectNode metaNode = mapper.createObjectNode();
        metaNode.put("resourceType", "User");
        if (newUser) {
            String utcNow = Instant.now().toString();
            metaNode.put("created", utcNow);
            metaNode.put("lastModified", utcNow);
        }
        metaNode.put("location", routes.SCIMApiEndpoint.read("Users", uuid).toString());
        rootNode.set("meta", (JsonNode)metaNode);
        return rootNode;
    }

    public static UUID parseUUID(String uuidString) throws SCIMApiEndpoint.ErrorResultException {
        try {
            return UUID.fromString(uuidString);
        }
        catch (Exception e) {
            throw new SCIMApiEndpoint.ErrorResultException(400, "Cannot parse '" + uuidString + "' as UUID!", SCIMApiEndpoint.ScimErrorResponseType.INVALID_VALUE);
        }
    }

    public static boolean isUserActive(User user) {
        return user.getErrorCounter() != 99 && user.getErrorSignCounter() != 99;
    }

    public static String getWorkEmailFromBaseNode(JsonNode jsonNode) {
        if (jsonNode.get("emails") != null) {
            JsonNode emailsNode = jsonNode.get("emails");
            return SCIMUtil.getWorkEmailFromEmailsNode(emailsNode);
        }
        return null;
    }

    public static boolean hasEmailBaseNode(JsonNode jsonNode) {
        return jsonNode.get("emails") != null;
    }

    public static String getWorkEmailFromEmailsNode(JsonNode emailsNode) {
        if (!emailsNode.isArray()) {
            return null;
        }
        Iterator it = emailsNode.elements();
        while (it.hasNext()) {
            JsonNode emailNode = (JsonNode)it.next();
            String type = emailNode.get("type") != null ? emailNode.get("type").textValue() : null;
            if (!"work".equals(type)) continue;
            return emailNode.get("value") != null ? emailNode.get("value").textValue() : null;
        }
        return null;
    }

    public static List<SCIMGroup> getGroups(JsonNode groupsNode) throws SCIMApiEndpoint.ErrorResultException {
        if (!groupsNode.isArray()) {
            return null;
        }
        ArrayList<SCIMGroup> groups = new ArrayList<SCIMGroup>();
        Iterator it = groupsNode.elements();
        while (it.hasNext()) {
            JsonNode groupNode = (JsonNode)it.next();
            String groupUUIDString = groupNode.get("value") != null ? groupNode.get("value").textValue() : null;
            if (groupUUIDString == null) continue;
            UUID groupUUID = SCIMUtil.parseUUID(groupUUIDString);
            SCIMGroup group = SCIMGroup.getGroup(groupUUID);
            if (group == null) {
                throw new SCIMApiEndpoint.ErrorResultException(404, "Group '" + groupUUIDString + "' does not exist!", null);
            }
            groups.add(group);
        }
        if (groups.isEmpty()) {
            throw new SCIMApiEndpoint.ErrorResultException(400, "Could not find 'value' field in groups node!", SCIMApiEndpoint.ScimErrorResponseType.INVALID_VALUE);
        }
        return groups;
    }

    public static List<User> getUsers(JsonNode usersNode) throws SCIMApiEndpoint.ErrorResultException {
        if (!usersNode.isArray()) {
            return null;
        }
        ArrayList<User> users2 = new ArrayList<User>();
        Iterator it = usersNode.elements();
        while (it.hasNext()) {
            JsonNode userNode = (JsonNode)it.next();
            String userUUIDString = userNode.get("value") != null ? userNode.get("value").textValue() : null;
            if (userUUIDString == null) continue;
            UUID userUUID = SCIMUtil.parseUUID(userUUIDString);
            User user = User.getByUUID((UUID)userUUID);
            if (user == null) {
                throw new SCIMApiEndpoint.ErrorResultException(404, "User '" + userUUIDString + "' does not exist!", null);
            }
            users2.add(user);
        }
        return users2;
    }

    public static boolean setUserName(User user, String newUserName) {
        if (newUserName != null && !newUserName.equals(user.getName())) {
            user.setName(newUserName);
            return true;
        }
        return false;
    }

    public static boolean setUserFamilyName(User user, String newFamilyName) {
        if (!Objects.equals(newFamilyName, user.getFamilyName())) {
            user.setFamilyName(newFamilyName);
            return true;
        }
        return false;
    }

    public static boolean setUserGivenName(User user, String newGivenName) {
        if (!Objects.equals(newGivenName, user.getGivenName())) {
            user.setGivenName(newGivenName);
            return true;
        }
        return false;
    }

    public static boolean setUserEmail(User user, String newEmail) {
        if (!Objects.equals(newEmail, user.getEmail())) {
            user.setEmail(newEmail);
            return true;
        }
        return false;
    }

    public static boolean setUserActiveStatus(User user, Boolean newActiveStatus) {
        if (newActiveStatus != null && newActiveStatus != SCIMUtil.isUserActive(user)) {
            if (newActiveStatus.booleanValue()) {
                user.resetLoginErrorCounter();
                user.resetSignatureErrorCounter();
            } else {
                user.lock();
            }
            return true;
        }
        return false;
    }

    public static boolean addUserToGroups(User user, JsonNode groupsArrayNode) throws SCIMApiEndpoint.ErrorResultException {
        boolean userIsModified = false;
        List<SCIMGroup> groups = SCIMUtil.getGroups(groupsArrayNode);
        if (groups != null) {
            for (SCIMGroup group : groups) {
                userIsModified |= group.setMembershipStatus(user, true);
            }
        }
        return userIsModified;
    }

    public static boolean addUsersToGroup(SCIMGroup group, JsonNode usersArrayNode) throws SCIMApiEndpoint.ErrorResultException {
        boolean groupIsModified = false;
        List<User> users2 = SCIMUtil.getUsers(usersArrayNode);
        if (users2 != null) {
            for (User user : users2) {
                groupIsModified |= group.setMembershipStatus(user, true);
            }
        }
        return groupIsModified;
    }

    public static boolean removeOtherUsersFromGroup(SCIMGroup group, JsonNode usersArrayNode) throws SCIMApiEndpoint.ErrorResultException {
        boolean groupIsModified = false;
        List<User> users2 = SCIMUtil.getUsers(usersArrayNode);
        HashSet keepUsersWithTheseUUIDs = users2 == null ? new HashSet() : users2.stream().map(User::getUUID).collect(Collectors.toSet());
        for (User userToRemove : group.getMembers()) {
            if (keepUsersWithTheseUUIDs.contains(userToRemove.getUUID())) continue;
            groupIsModified |= group.setMembershipStatus(userToRemove, false);
        }
        return groupIsModified;
    }

    public static boolean removeUserFromOtherGroups(User user, JsonNode groupsArrayNode) throws SCIMApiEndpoint.ErrorResultException {
        boolean userIsModified = false;
        List<SCIMGroup> groups = SCIMUtil.getGroups(groupsArrayNode);
        if (groups == null || groups.isEmpty()) {
            return SCIMUtil.removeUserFromAllGroups(user);
        }
        Set keepGroupsWithTheseUUIDs = groups.stream().map(SCIMGroup::getUUID).collect(Collectors.toSet());
        for (SCIMGroup groupToRemove : SCIMGroup.getGroups(user)) {
            if (keepGroupsWithTheseUUIDs.contains(groupToRemove.getUUID())) continue;
            userIsModified |= groupToRemove.setMembershipStatus(user, false);
        }
        return userIsModified;
    }

    public static boolean removeUserFromAllGroups(User user) {
        boolean userIsModified = false;
        for (SCIMGroup groupToRemove : SCIMGroup.getGroups(user)) {
            userIsModified |= groupToRemove.setMembershipStatus(user, false);
        }
        return userIsModified;
    }

    public static boolean removeUserFromGroup(String userUuidString, SCIMGroup group) throws SCIMApiEndpoint.ErrorResultException {
        UUID uuid = SCIMUtil.parseUUID(userUuidString);
        User user = User.getByUUID((UUID)uuid);
        if (user == null) {
            throw new SCIMApiEndpoint.ErrorResultException(404, "User '" + userUuidString + "' does not exist!", null);
        }
        return group.setMembershipStatus(user, false);
    }

    public static boolean removeUserFromGroup(User user, String groupUuidString) throws SCIMApiEndpoint.ErrorResultException {
        UUID uuid = SCIMUtil.parseUUID(groupUuidString);
        SCIMGroup group = SCIMGroup.getGroup(uuid);
        if (group == null) {
            throw new SCIMApiEndpoint.ErrorResultException(404, "Group '" + groupUuidString + "' does not exist!", null);
        }
        return group.setMembershipStatus(user, false);
    }

    public static String generateRandomPassword() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 12);
    }
}

