/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding.scim;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.branding.scim.routes;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.preferences.PreferenceConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class SCIMGroup {
    private static final Map<UUID, SCIMGroup> STATIC_GROUPS_BY_UUID = new HashMap<UUID, SCIMGroup>();
    private static final SCIMGroup ADMIN_GROUP = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("13ce9e90-7109-4df4-9522-b14cc931173b");
        }

        @Override
        public String getDisplayName() {
            return "Administrators";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            return userToCheck.isAdmin();
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            user.setAdmin(status);
            user.save();
            return true;
        }

        @Override
        protected List<User> getMembersInternal() {
            return User.getAllAdmins().stream().filter(Predicate.not(GeneralUtils::isSuperAdmin)).collect(Collectors.toList());
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_SALARY_PERMISSIONS_FULL = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("fd16a988-da56-4746-adfe-9977004082ba");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to see and create salary payments";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            String permission = preferenceStore.getString((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS);
            return permission.equals(PreferenceConstants.SALARY_PERMISSION.FULL.toString());
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            if (status) {
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, PreferenceConstants.SALARY_PERMISSION.FULL.toString());
            } else {
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, PreferenceConstants.SALARY_PERMISSION.NO.toString());
            }
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_SALARY_PERMISSIONS_PARTIAL = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("f5071d5e-b6cb-406b-a205-83d25b857591");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to only see salary payments during signing (without amounts)";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            String permission = preferenceStore.getString((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS);
            return permission.equals(PreferenceConstants.SALARY_PERMISSION.PARTIAL.toString());
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            if (status) {
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, PreferenceConstants.SALARY_PERMISSION.PARTIAL.toString());
            } else {
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, PreferenceConstants.SALARY_PERMISSION.NO.toString());
            }
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_SALARY_PERMISSIONS_PARTIAL_NO_DETAILS = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("0be4cd77-1cd5-43c6-a43e-60a51ee4a3b2");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to only see salary payments during signing (without amounts or details)";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            String permission = preferenceStore.getString((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS);
            return permission.equals(PreferenceConstants.SALARY_PERMISSION.PARTIAL_NO_DETAILS.toString());
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            if (status) {
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, PreferenceConstants.SALARY_PERMISSION.PARTIAL_NO_DETAILS.toString());
            } else {
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, PreferenceConstants.SALARY_PERMISSION.NO.toString());
            }
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_CONFIRM_RECIPIENT_PERMISSION = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("bb353675-3cf4-4ed0-b49f-baad30db54ec");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to confirm payment recipients in four-eyes principle";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_VIEW_ACCOUNT_STATEMENTS = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("f3db9c03-938b-406b-80e4-d70e1e6cc6e5");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to view account statements";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_FETCH_FILES = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("4b62e787-91b4-4b88-8df7-1e3da627e17c");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to fetch files from banks";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FETCH_FILES);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FETCH_FILES, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_SEND_FILES = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("f281ba75-e9af-4c42-8de7-35a6ab9cf1e4");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to send files to banks";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SEND_FILES);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SEND_FILES, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_VEU = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("c0eb6a0e-807c-4ba1-bf3a-c4760db57983");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to sign orders in the Electronic Distributed Signature (EDS)";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VEU);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VEU, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_PAYMENT_RECORDING = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("a46efff0-d2e2-4dce-b104-9daf6fc9f8ff");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to record payments";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_PAYMENT_RECORDING);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_PAYMENT_RECORDING, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_AWV_RECORDING = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("31ea90aa-b9c7-4fcd-8863-3245a839aea6");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to record AWV notifications";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_AWV_RECORDING);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_AWV_RECORDING, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_FOLDER_FILES = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("408293bb-b936-47f0-ba17-c8287dcebcf1");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to view and send files from watched directories";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FOLDER_FILES);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FOLDER_FILES, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_SETTINGS = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("9010dd96-f141-4123-b5d1-1ef13510425b");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to access the settings menu";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SETTINGS);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SETTINGS, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_BANKS_AND_ACCOUNTS = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("8046dae0-f5b4-4fe7-8308-3d9152bf953f");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to view banks and accounts in the settings menu";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_SYNCHRONISATION = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("3828bdd1-2733-4c35-a274-7f1b5b1b9b32");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to synchronize with Android\u2122 or iPhone\u00ae app";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SYNCHRONISATION);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SYNCHRONISATION, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_USER_CREATION = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("cb290a06-97ea-453b-82d4-4c763e464664");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to create other users";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_TENANT_CREATION = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("e97d803d-e0e5-4002-b427-1ef73053b02a");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to create tenants";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_DELETE_STATEMENTS = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("a27b9076-770a-415c-8f95-62875960e457");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to delete account statements and PDF statements";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_EDIT_BANK_SETTINGS = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("aaa711b2-f2d8-4d2a-b015-57b2a0616acd");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to edit bank settings";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_EDIT_BANK_SETTINGS);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_EDIT_BANK_SETTINGS, status);
            return true;
        }
    };
    private static final SCIMGroup PREFERENCE_GROUP_ALLOW_NOTIFICATIONS = new SCIMGroup(){

        @Override
        public boolean isUsed() {
            return true;
        }

        @Override
        public UUID getUUID() {
            return UUID.fromString("09dd6d0d-55a9-4f97-8636-8691754b4232");
        }

        @Override
        public String getDisplayName() {
            return "Users with permission to access the notifications overview";
        }

        @Override
        protected boolean isMemberInternal(User userToCheck) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, userToCheck);
            return preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_NOTIFICATIONS);
        }

        @Override
        protected boolean setMembershipStatusInternal(User user, boolean status) {
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_NOTIFICATIONS, status);
            return true;
        }
    };

    public static SCIMGroup buildTenantMembersGroup(final Tenant forTenant) {
        if (forTenant != null) {
            return new SCIMGroup(){

                @Override
                public boolean isUsed() {
                    return true;
                }

                @Override
                public UUID getUUID() {
                    return forTenant.getOrCreateUUID();
                }

                @Override
                public String getDisplayName() {
                    return "Members of the tenant '" + forTenant.getName() + "' (id=" + forTenant.getId() + ")";
                }

                @Override
                protected boolean isMemberInternal(User userToCheck) {
                    return userToCheck.getTenants().contains(forTenant);
                }

                @Override
                protected boolean setMembershipStatusInternal(User user, boolean status) {
                    BankUser existingBankUser;
                    boolean tenantsChanged;
                    List tenants2 = user.getTenants();
                    if (status) {
                        tenantsChanged = !tenants2.contains(forTenant);
                        tenants2.add(forTenant);
                    } else {
                        tenantsChanged = tenants2.contains(forTenant);
                        tenants2.remove(forTenant);
                        if (tenantsChanged) {
                            for (BankSettings bank : BankSettings.findBanksForTenants(Collections.singletonList(forTenant))) {
                                existingBankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
                                if (existingBankUser == null) continue;
                                existingBankUser.delete();
                            }
                        }
                    }
                    user.setTenants(tenants2);
                    user.save();
                    if (status && tenantsChanged) {
                        for (BankSettings bank : BankSettings.findBanksForTenants(Collections.singletonList(forTenant))) {
                            existingBankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
                            if (existingBankUser != null) continue;
                            BankUser bankUser = BankUser.createBankUser((BankSettings)bank, (User)user);
                            for (OrderType o : OrderType.findSendOrderTypesForBank((BankSettings)bank)) {
                                UserPermission userPermission = new UserPermission();
                                userPermission.setBankUser(bankUser);
                                userPermission.setOrderType(o);
                                userPermission.save();
                            }
                        }
                    }
                    return tenantsChanged;
                }

                @Override
                protected List<User> getMembersInternal() {
                    return User.getAllForTenants(Collections.singletonList(forTenant), (boolean)true).stream().filter(Predicate.not(GeneralUtils::isSuperAdmin)).collect(Collectors.toList());
                }
            };
        }
        return null;
    }

    public static SCIMGroup buildTenantAdminsGroup(final Tenant forTenant) {
        if (forTenant != null) {
            return new SCIMGroup(){

                @Override
                public boolean isUsed() {
                    return true;
                }

                @Override
                public UUID getUUID() {
                    return forTenant.getOrCreateAdminsUUID();
                }

                @Override
                public String getDisplayName() {
                    return "Users with permission to manage the tenant '" + forTenant.getName() + "' (id=" + forTenant.getId() + ")";
                }

                @Override
                protected boolean isMemberInternal(User userToCheck) {
                    return userToCheck.getManagedTenants().contains(forTenant);
                }

                @Override
                protected boolean setMembershipStatusInternal(User user, boolean status) {
                    boolean tenantsChanged;
                    List managedTenants = user.getManagedTenants();
                    if (status) {
                        tenantsChanged = !managedTenants.contains(forTenant);
                        managedTenants.add(forTenant);
                    } else {
                        tenantsChanged = managedTenants.contains(forTenant);
                        managedTenants.remove(forTenant);
                    }
                    user.setManagedTenants(managedTenants);
                    user.save();
                    return tenantsChanged;
                }

                @Override
                protected List<User> getMembersInternal() {
                    return forTenant.getManagingUsers();
                }
            };
        }
        return null;
    }

    public static SCIMGroup getGroup(UUID forUUID) {
        if (STATIC_GROUPS_BY_UUID.containsKey(forUUID)) {
            if (STATIC_GROUPS_BY_UUID.get(forUUID).isUsed()) {
                return STATIC_GROUPS_BY_UUID.get(forUUID);
            }
            return null;
        }
        Tenant tenantWithMembershipForUser = Tenant.findByUUID((UUID)forUUID);
        if (tenantWithMembershipForUser != null) {
            return SCIMGroup.buildTenantMembersGroup(tenantWithMembershipForUser);
        }
        Tenant tenantWithAdminPrivilegesForUser = Tenant.findByAdminsUUID((UUID)forUUID);
        if (tenantWithAdminPrivilegesForUser != null) {
            return SCIMGroup.buildTenantAdminsGroup(tenantWithAdminPrivilegesForUser);
        }
        return null;
    }

    public static List<SCIMGroup> getAllGroups() {
        ArrayList<SCIMGroup> groups = new ArrayList<SCIMGroup>();
        for (SCIMGroup group : STATIC_GROUPS_BY_UUID.values()) {
            if (!group.isUsed()) continue;
            groups.add(group);
        }
        for (Tenant tenant : Tenant.getAllTenants()) {
            SCIMGroup adminsGroup;
            SCIMGroup membersGroup = SCIMGroup.buildTenantMembersGroup(tenant);
            if (membersGroup.isUsed()) {
                groups.add(membersGroup);
            }
            if (!(adminsGroup = SCIMGroup.buildTenantAdminsGroup(tenant)).isUsed()) continue;
            groups.add(adminsGroup);
        }
        return groups;
    }

    public static List<SCIMGroup> getGroups(User forUser) {
        ArrayList<SCIMGroup> groupsForUser = new ArrayList<SCIMGroup>();
        for (SCIMGroup group : STATIC_GROUPS_BY_UUID.values()) {
            if (!group.isUsed() || !group.isMember(forUser)) continue;
            groupsForUser.add(group);
        }
        for (Tenant tenant : Tenant.getAllTenants()) {
            SCIMGroup adminsGroup;
            SCIMGroup membersGroup = SCIMGroup.buildTenantMembersGroup(tenant);
            if (membersGroup.isUsed() && membersGroup.isMember(forUser)) {
                groupsForUser.add(membersGroup);
            }
            if (!(adminsGroup = SCIMGroup.buildTenantAdminsGroup(tenant)).isUsed() || !adminsGroup.isMember(forUser)) continue;
            groupsForUser.add(adminsGroup);
        }
        return groupsForUser;
    }

    public abstract boolean isUsed();

    public abstract UUID getUUID();

    public abstract String getDisplayName();

    protected abstract boolean isMemberInternal(User var1);

    protected abstract boolean setMembershipStatusInternal(User var1, boolean var2);

    protected List<User> getMembersInternal() {
        return User.getAll().stream().filter(this::isMemberInternal).filter(Predicate.not(GeneralUtils::isSuperAdmin)).collect(Collectors.toList());
    }

    public boolean isMember(User userToCheck) {
        if (!this.isUsed()) {
            return false;
        }
        return this.isMemberInternal(userToCheck);
    }

    public boolean setMembershipStatus(User user, boolean status) {
        if (!this.isUsed()) {
            return false;
        }
        if (this.isMemberInternal(user) == status) {
            return false;
        }
        return this.setMembershipStatusInternal(user, status);
    }

    public List<User> getMembers() {
        if (!this.isUsed()) {
            return new ArrayList<User>();
        }
        return this.getMembersInternal();
    }

    public ObjectNode getJsonRepresentation(ObjectMapper mapper, boolean includeMembers) {
        ObjectNode rootNode = mapper.createObjectNode();
        String uuid = this.getUUID().toString();
        rootNode.put("id", uuid);
        rootNode.put("displayName", this.getDisplayName());
        if (includeMembers) {
            ArrayNode groupsNode = mapper.createArrayNode();
            rootNode.set("members", (JsonNode)groupsNode);
            for (User member : this.getMembers()) {
                String memberUUID = member.getOrCreateUUID().toString();
                ObjectNode memberNode = mapper.createObjectNode();
                memberNode.put("type", "User");
                memberNode.put("value", memberUUID);
                memberNode.put("$ref", routes.SCIMApiEndpoint.read("Users", memberUUID).toString());
                groupsNode.add((JsonNode)memberNode);
            }
        }
        ArrayNode schemas = mapper.createArrayNode();
        schemas.add("urn:ietf:params:scim:schemas:core:2.0:Group");
        rootNode.set("schema", (JsonNode)schemas);
        ObjectNode metaNode = mapper.createObjectNode();
        metaNode.put("resourceType", "Group");
        metaNode.put("location", routes.SCIMApiEndpoint.read("Groups", uuid).toString());
        rootNode.set("meta", (JsonNode)metaNode);
        return rootNode;
    }

    static {
        STATIC_GROUPS_BY_UUID.put(ADMIN_GROUP.getUUID(), ADMIN_GROUP);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_SALARY_PERMISSIONS_FULL.getUUID(), PREFERENCE_GROUP_SALARY_PERMISSIONS_FULL);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_SALARY_PERMISSIONS_PARTIAL.getUUID(), PREFERENCE_GROUP_SALARY_PERMISSIONS_PARTIAL);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_SALARY_PERMISSIONS_PARTIAL_NO_DETAILS.getUUID(), PREFERENCE_GROUP_SALARY_PERMISSIONS_PARTIAL_NO_DETAILS);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_CONFIRM_RECIPIENT_PERMISSION.getUUID(), PREFERENCE_GROUP_CONFIRM_RECIPIENT_PERMISSION);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_VIEW_ACCOUNT_STATEMENTS.getUUID(), PREFERENCE_GROUP_ALLOW_VIEW_ACCOUNT_STATEMENTS);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_FETCH_FILES.getUUID(), PREFERENCE_GROUP_ALLOW_FETCH_FILES);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_SEND_FILES.getUUID(), PREFERENCE_GROUP_ALLOW_SEND_FILES);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_VEU.getUUID(), PREFERENCE_GROUP_ALLOW_VEU);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_PAYMENT_RECORDING.getUUID(), PREFERENCE_GROUP_ALLOW_PAYMENT_RECORDING);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_AWV_RECORDING.getUUID(), PREFERENCE_GROUP_ALLOW_AWV_RECORDING);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_FOLDER_FILES.getUUID(), PREFERENCE_GROUP_ALLOW_FOLDER_FILES);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_SETTINGS.getUUID(), PREFERENCE_GROUP_ALLOW_SETTINGS);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_BANKS_AND_ACCOUNTS.getUUID(), PREFERENCE_GROUP_ALLOW_BANKS_AND_ACCOUNTS);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_SYNCHRONISATION.getUUID(), PREFERENCE_GROUP_ALLOW_SYNCHRONISATION);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_USER_CREATION.getUUID(), PREFERENCE_GROUP_ALLOW_USER_CREATION);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_TENANT_CREATION.getUUID(), PREFERENCE_GROUP_ALLOW_TENANT_CREATION);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_DELETE_STATEMENTS.getUUID(), PREFERENCE_GROUP_ALLOW_DELETE_STATEMENTS);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_EDIT_BANK_SETTINGS.getUUID(), PREFERENCE_GROUP_ALLOW_EDIT_BANK_SETTINGS);
        STATIC_GROUPS_BY_UUID.put(PREFERENCE_GROUP_ALLOW_NOTIFICATIONS.getUUID(), PREFERENCE_GROUP_ALLOW_NOTIFICATIONS);
    }
}

