/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding.scim;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Setup;
import controllers.branding.scim.SCIMGroup;
import controllers.branding.scim.SCIMUtil;
import controllers.util.GeneralUtils;
import controllers.util.PasswordKeyEncryptionHandler;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Transaction;
import java.io.FileWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.Logger;
import play.mvc.BodyParser;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.StatusHeader;

public class SCIMApiEndpoint
extends Controller {
    public static final Logger.ALogger SCIM_LOGGER = Logger.of((String)"scim");
    public static boolean SCIM_ACTIVATED = false;
    private static String apiSecret;
    private static FileWriter dumpFileWriter;

    private static JsonNode getJSON(Http.Request request) {
        JsonNode jsonNode = request.body().asJson();
        if (SCIM_LOGGER.isDebugEnabled()) {
            SCIM_LOGGER.debug(request.method() + " " + request.path());
            SCIM_LOGGER.debug(jsonNode.toPrettyString());
        }
        return jsonNode;
    }

    public static void setDumpFileConfig(String filename) throws IOException {
        String name = MessageFormat.format(filename, new Date());
        dumpFileWriter = new FileWriter(name);
    }

    public static void setApiSecret(String apiSecret) {
        SCIMApiEndpoint.apiSecret = apiSecret;
    }

    public static boolean isApiSecretSet() {
        return apiSecret != null && !apiSecret.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result processApiCall(Method method, Http.Request request, String resourceType, String resourceUUID, String filter, String sortBy, String sortOrder, Integer startIndex, Integer count) throws JsonProcessingException {
        if (!SCIM_ACTIVATED) {
            return SCIMApiEndpoint.notFound();
        }
        try {
            SCIM_LOGGER.trace("Start processing SCIM '" + method.name() + "' call ...");
            try {
                Optional secret = request.header("Authorization");
                if (!secret.isPresent()) {
                    SCIM_LOGGER.error("Missing header 'Authorization' in API event request!");
                    StatusHeader statusHeader = SCIMApiEndpoint.unauthorized();
                    return statusHeader;
                }
                String sentSecret = (String)secret.get();
                if (!Objects.equals(sentSecret, "Bearer " + apiSecret)) {
                    SCIM_LOGGER.error("API secret received in event header 'Authorization' (" + sentSecret + ") does not match local API secret!");
                    StatusHeader statusHeader = SCIMApiEndpoint.forbidden();
                    return statusHeader;
                }
                Result result = switch (method.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> this.createInternal(request, resourceType);
                    case 1 -> this.searchInternal(request, resourceType, filter, sortBy, sortOrder, startIndex, count);
                    case 2 -> this.readInternal(request, resourceType, resourceUUID);
                    case 3 -> this.replaceInternal(request, resourceType, resourceUUID);
                    case 4 -> this.deleteInternal(request, resourceType, resourceUUID);
                    case 5 -> this.updateInternal(request, resourceType, resourceUUID);
                };
                return result;
            }
            finally {
                SCIM_LOGGER.trace("... Finished processing SCIM '" + method.name() + "' call.");
            }
        }
        catch (MandatoryFieldMissingException e) {
            return SCIMUtil.errorResult(400, e.getMessage(), null);
        }
        catch (ErrorResultException e) {
            return SCIMUtil.errorResult(e);
        }
        catch (Exception e) {
            SCIMUtil.logError("Error occurred while processing API call!", e);
            return SCIMUtil.errorResult(500, null, null);
        }
    }

    @BodyParser.Of(value=BodyParser.TolerantJson.class)
    public Result create(Http.Request request, String resourceType) throws JsonProcessingException {
        return this.processApiCall(Method.CREATE, request, resourceType, null, null, null, null, null, null);
    }

    private Result createInternal(Http.Request request, String resourceType) throws MandatoryFieldMissingException, IOException, GeneralSecurityException {
        switch (resourceType) {
            case "Users": {
                JsonNode jsonContent = SCIMApiEndpoint.getJSON(request);
                return this.createOrReplaceUser(jsonContent, null);
            }
            case "Groups": {
                return SCIMUtil.cannotProcess(Method.CREATE.name(), resourceType);
            }
        }
        return SCIMUtil.cannotProcess(Method.CREATE.name(), resourceType);
    }

    public Result search(Http.Request request, String resourceType, String filter, String sortBy, String sortOrder, Integer startIndex, Integer count) throws JsonProcessingException {
        return this.processApiCall(Method.SEARCH, request, resourceType, null, filter, sortBy, sortOrder, startIndex, count);
    }

    private Result searchInternal(Http.Request request, String resourceType, String filter, String sortBy, String sortOrder, Integer startIndex, Integer count) throws JsonProcessingException {
        switch (resourceType) {
            case "Users": {
                List usersToReturn;
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode rootNode = mapper.createObjectNode();
                ArrayNode schemas = mapper.createArrayNode();
                schemas.add("urn:ietf:params:scim:api:messages:2.0:ListResponse");
                rootNode.set("schemas", (JsonNode)schemas);
                String orderBy = "name asc";
                if (startIndex != null || count != null) {
                    if (startIndex == null) {
                        startIndex = 1;
                    }
                    usersToReturn = count != null ? DB.find(User.class).setMaxRows(count.intValue()).setFirstRow(startIndex.intValue()).order(orderBy).findList() : DB.find(User.class).setFirstRow(startIndex.intValue()).order(orderBy).findList();
                } else {
                    usersToReturn = User.getAll();
                }
                int numberOfResults = User.getAll().size();
                rootNode.put("totalResults", numberOfResults);
                ArrayNode usersNode = mapper.createArrayNode();
                for (User user : usersToReturn) {
                    if (GeneralUtils.isSuperAdmin(user)) continue;
                    ObjectNode userNode = SCIMUtil.getJsonUserRepresentation(user, mapper, null, true);
                    usersNode.add((JsonNode)userNode);
                }
                rootNode.set("Resources", (JsonNode)usersNode);
                return SCIMApiEndpoint.ok((String)mapper.writeValueAsString((Object)rootNode)).as("application/scim+json");
            }
            case "Groups": {
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode rootNode = mapper.createObjectNode();
                ArrayNode schemas = mapper.createArrayNode();
                schemas.add("urn:ietf:params:scim:api:messages:2.0:ListResponse");
                rootNode.set("schemas", (JsonNode)schemas);
                List<SCIMGroup> groupsToReturn = SCIMGroup.getAllGroups();
                int numberOfResults = groupsToReturn.size();
                rootNode.put("totalResults", numberOfResults);
                ArrayNode groupsNode = mapper.createArrayNode();
                for (SCIMGroup group : groupsToReturn) {
                    ObjectNode groupNode = group.getJsonRepresentation(mapper, true);
                    groupsNode.add((JsonNode)groupNode);
                }
                rootNode.set("Resources", (JsonNode)groupsNode);
                return SCIMApiEndpoint.ok((String)mapper.writeValueAsString((Object)rootNode)).as("application/scim+json");
            }
        }
        return SCIMUtil.cannotProcess(Method.SEARCH.name(), resourceType);
    }

    public Result read(Http.Request request, String resourceType, String uuid) throws JsonProcessingException {
        return this.processApiCall(Method.READ, request, resourceType, uuid, null, null, null, null, null);
    }

    private Result readInternal(Http.Request request, String resourceType, String resourceUUID) throws JsonProcessingException, ErrorResultException {
        UUID uuid = SCIMUtil.parseUUID(resourceUUID);
        switch (resourceType) {
            case "Users": {
                User user = User.getByUUID((UUID)uuid);
                if (user == null) {
                    return SCIMUtil.errorResult(404, "User '" + resourceUUID + "' does not exist!", null);
                }
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode userJsonNode = SCIMUtil.getJsonUserRepresentation(user, mapper, null, true);
                return SCIMApiEndpoint.ok((String)mapper.writeValueAsString((Object)userJsonNode)).as("application/scim+json");
            }
            case "Groups": {
                SCIMGroup group = SCIMGroup.getGroup(uuid);
                if (group == null) {
                    return SCIMUtil.errorResult(404, "Group '" + resourceUUID + "' does not exist!", null);
                }
                ObjectMapper mapper = new ObjectMapper();
                ObjectNode groupJsonNode = group.getJsonRepresentation(mapper, true);
                return SCIMApiEndpoint.ok((String)mapper.writeValueAsString((Object)groupJsonNode)).as("application/scim+json");
            }
        }
        return SCIMUtil.cannotProcess(Method.READ.name(), resourceType);
    }

    @BodyParser.Of(value=BodyParser.TolerantJson.class)
    public Result replace(Http.Request request, String resourceType, String uuid) throws JsonProcessingException {
        return this.processApiCall(Method.REPLACE, request, resourceType, uuid, null, null, null, null, null);
    }

    private Result replaceInternal(Http.Request request, String resourceType, String resourceUUID) throws IOException, GeneralSecurityException, MandatoryFieldMissingException, ErrorResultException {
        UUID uuid = SCIMUtil.parseUUID(resourceUUID);
        JsonNode jsonContent = SCIMApiEndpoint.getJSON(request);
        switch (resourceType) {
            case "Users": {
                User userToBeReplaced = User.getByUUID((UUID)uuid);
                if (userToBeReplaced == null) {
                    return SCIMUtil.errorResult(404, "User '" + resourceUUID + "' does not exist", null);
                }
                return this.createOrReplaceUser(jsonContent, userToBeReplaced);
            }
            case "Groups": {
                SCIMGroup groupToBeReplaces = SCIMGroup.getGroup(uuid);
                if (groupToBeReplaces == null) {
                    return SCIMUtil.errorResult(404, "Group '" + resourceUUID + "' does not exist", null);
                }
                return this.replaceGroup(jsonContent, groupToBeReplaces);
            }
        }
        return SCIMUtil.cannotProcess(Method.REPLACE.name(), resourceType);
    }

    public Result delete(Http.Request request, String resourceType, String uuid) throws JsonProcessingException {
        return this.processApiCall(Method.DELETE, request, resourceType, uuid, null, null, null, null, null);
    }

    private Result deleteInternal(Http.Request request, String resourceType, String resourceUUID) throws JsonProcessingException, ErrorResultException {
        UUID uuid = SCIMUtil.parseUUID(resourceUUID);
        switch (resourceType) {
            case "Users": {
                User userToBeReplaced = User.getByUUID((UUID)uuid);
                if (userToBeReplaced == null) {
                    return SCIMUtil.errorResult(404, "User '" + resourceUUID + "' does not exist", null);
                }
                String userName = userToBeReplaced.getName();
                Integer userId = userToBeReplaced.getId();
                try (Transaction t = DB.beginTransaction();){
                    userToBeReplaced.delete(Setup.DELETE_USER_NAME);
                    t.commit();
                }
                SCIM_LOGGER.info("Successfully deleted User '" + userName + "' (id=" + userId + ", uuid=" + resourceUUID + ") after receiving delete request.");
                return SCIMApiEndpoint.noContent();
            }
            case "Groups": {
                return SCIMUtil.cannotProcess(Method.DELETE.name(), resourceType);
            }
        }
        return SCIMUtil.cannotProcess(Method.DELETE.name(), resourceType);
    }

    @BodyParser.Of(value=BodyParser.TolerantJson.class)
    public Result update(Http.Request request, String resourceType, String uuid) throws JsonProcessingException {
        return this.processApiCall(Method.UPDATE, request, resourceType, uuid, null, null, null, null, null);
    }

    /*
     * Unable to fully structure code
     */
    private Result updateInternal(Http.Request request, String resourceType, String resourceUUID) throws IOException, MandatoryFieldMissingException, ErrorResultException {
        uuid = SCIMUtil.parseUUID(resourceUUID);
        jsonContent = SCIMApiEndpoint.getJSON(request);
        operations = SCIMUtil.getMandatoryJsonField(jsonContent, "Operations");
        if (!operations.isArray()) {
            return SCIMUtil.errorResult(400, "'Operations' node in PATCH request must be an array node!", ScimErrorResponseType.INVALID_SYNTAX);
        }
        var7_7 = resourceType;
        var8_8 = -1;
        switch (var7_7.hashCode()) {
            case 82025960: {
                if (!var7_7.equals("Users")) break;
                var8_8 = 0;
                break;
            }
            case 2141373940: {
                if (!var7_7.equals("Groups")) break;
                var8_8 = 1;
            }
        }
        switch (var8_8) {
            case 0: {
                userToBeUpdated = User.getByUUID((UUID)uuid);
                if (userToBeUpdated == null) {
                    return SCIMUtil.errorResult(404, "User '" + resourceUUID + "' does not exist", null);
                }
                anyChanges = false;
                t = DB.beginTransaction();
                try {
                    try {
                        for (JsonNode operation : operations) {
                            anyChanges |= this.updateUser(operation, userToBeUpdated);
                        }
                        userToBeUpdated.save();
                    }
                    catch (ErrorResultException e) {
                        operation = SCIMUtil.errorResult(e);
                        if (t != null) {
                            t.close();
                        }
                        return operation;
                    }
                    catch (Exception e) {
                        SCIMUtil.logError("Error occurred while processing PATCH User call!", e);
                        operation = SCIMUtil.errorResult(500, "An error occurred while processing PATCH request.", null);
                        if (t == null) ** GOTO lbl41
                        t.close();
lbl41:
                        // 2 sources

                        return operation;
                    }
                    t.commit();
                    ** GOTO lbl54
                    {
                        catch (Throwable e) {
                            throw e;
                        }
                    }
                }
                finally {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable operation) {
                            e.addSuppressed(operation);
                        }
                    }
                }
lbl54:
                // 1 sources

                mapper = new ObjectMapper();
                userJsonNode = SCIMUtil.getJsonUserRepresentation(userToBeUpdated, mapper, null, true);
                return SCIMApiEndpoint.ok((String)mapper.writeValueAsString((Object)userJsonNode)).as("application/scim+json");
            }
            case 1: {
                groupToBeUpdated = SCIMGroup.getGroup(uuid);
                if (groupToBeUpdated == null) {
                    return SCIMUtil.errorResult(404, "Group '" + resourceUUID + "' does not exist", null);
                }
                anyChanges = false;
                t = DB.beginTransaction();
                try {
                    try {
                        for (JsonNode operation : operations) {
                            anyChanges |= this.updateGroup(operation, groupToBeUpdated);
                        }
                    }
                    catch (ErrorResultException e) {
                        var13_28 = SCIMUtil.errorResult(e);
                        if (t != null) {
                            t.close();
                        }
                        return var13_28;
                    }
                    catch (Exception e) {
                        SCIMUtil.logError("Error occurred while processing PATCH Group call!", e);
                        var13_29 = SCIMUtil.errorResult(500, "An error occurred while processing PATCH request.", null);
                        if (t == null) ** GOTO lbl80
                        t.close();
lbl80:
                        // 2 sources

                        return var13_29;
                    }
                    t.commit();
                    ** GOTO lbl93
                    {
                        catch (Throwable e) {
                            throw e;
                        }
                    }
                }
                finally {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable var13_30) {
                            e.addSuppressed(var13_30);
                        }
                    }
                }
lbl93:
                // 1 sources

                mapper = new ObjectMapper();
                userJsonNode = groupToBeUpdated.getJsonRepresentation(mapper, true);
                return SCIMApiEndpoint.ok((String)mapper.writeValueAsString((Object)userJsonNode)).as("application/scim+json");
            }
        }
        return SCIMUtil.cannotProcess(Method.UPDATE.name(), resourceType);
    }

    private Result replaceGroup(JsonNode jsonContent, SCIMGroup groupToBeReplaced) throws MandatoryFieldMissingException, ErrorResultException, JsonProcessingException {
        if (jsonContent != null) {
            JsonNode members = SCIMUtil.getMandatoryJsonField(jsonContent, "members");
            SCIMUtil.addUsersToGroup(groupToBeReplaced, members);
            boolean groupIsModified = SCIMUtil.addUsersToGroup(groupToBeReplaced, members);
            groupIsModified |= SCIMUtil.removeOtherUsersFromGroup(groupToBeReplaced, members);
            SCIM_LOGGER.info("Successfully replaced Group '" + groupToBeReplaced.getDisplayName() + "' (uuid=" + String.valueOf(groupToBeReplaced.getUUID()) + ") after receiving PUT REPLACE request.");
        } else {
            SCIM_LOGGER.warn("Nothing to replace in Group '" + groupToBeReplaced.getDisplayName() + "' (uuid=" + String.valueOf(groupToBeReplaced.getUUID()) + ") after receiving PUT REPLACE request.");
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode groupNode = groupToBeReplaced.getJsonRepresentation(mapper, true);
        return SCIMApiEndpoint.ok((String)mapper.writeValueAsString((Object)groupNode)).as("application/scim+json");
    }

    private Result createOrReplaceUser(JsonNode jsonContent, User userToBeReplaced) throws MandatoryFieldMissingException, IOException, GeneralSecurityException {
        boolean createNewUser = userToBeReplaced == null;
        String userName = SCIMUtil.getMandatoryJsonFieldValue(jsonContent, "userName");
        String activeString = SCIMUtil.getOptionalJsonFieldValue(jsonContent, "active", null);
        Boolean active = activeString == null ? null : Boolean.valueOf(Boolean.parseBoolean(activeString));
        String familyName = SCIMUtil.getOptionalJsonFieldValue(jsonContent, "name.familyName", null);
        String givenName = SCIMUtil.getOptionalJsonFieldValue(jsonContent, "name.givenName", null);
        char[] password2 = SCIMUtil.getOptionalJsonFieldValue(jsonContent, "password", "").toCharArray();
        if (createNewUser && password2.length == 0) {
            password2 = SCIMUtil.generateRandomPassword().toCharArray();
        }
        String email = SCIMUtil.getWorkEmailFromBaseNode(jsonContent);
        if (createNewUser) {
            boolean userWithNameExists;
            boolean bl = userWithNameExists = User.getUser((String)userName) != null;
            if (userWithNameExists) {
                return SCIMUtil.errorResult(409, "User with userName = '" + userName + "' already exists!", ScimErrorResponseType.UNIQUENESS);
            }
            User newUser = new User();
            newUser.setName(userName);
            newUser.setGivenName(givenName);
            newUser.setFamilyName(familyName);
            newUser.setEmail(email);
            newUser.setAdmin(false);
            newUser.setSecurityMedium(User.SecurityMedium.SOFTWARE);
            newUser.setEncryptionKey(EncryptData.getInstance().copyKey((EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(password2)));
            License webLicense = User.getAll().stream().map(User::getWebLicense).filter(Objects::nonNull).findAny().orElse(null);
            newUser.setWebLicense(webLicense);
            newUser.getOrCreateUUID();
            if (Boolean.FALSE.equals(active)) {
                newUser.lock();
            }
            newUser.save();
            SCIMUtil.removeUserFromAllGroups(newUser);
            SCIM_LOGGER.info("Successfully created new User '" + userName + "' (id=" + newUser.getId() + ", uuid=" + String.valueOf(newUser.getUUID()) + ") after receiving CREATE request.");
            boolean passwordProvidedByClient = SCIMUtil.getJsonFieldInternal(jsonContent, "password") != null;
            char[] passwordInResponse = (char[])(!passwordProvidedByClient ? password2 : null);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode userJsonNode = SCIMUtil.getJsonUserRepresentation(newUser, mapper, passwordInResponse, true);
            return SCIMApiEndpoint.created((String)mapper.writeValueAsString((Object)userJsonNode)).as("application/scim+json");
        }
        String oldUserName = userToBeReplaced.getName();
        if (!oldUserName.equals(userName)) {
            boolean userWithNameExists;
            boolean bl = userWithNameExists = User.getUser((String)userName) != null;
            if (userWithNameExists) {
                return SCIMUtil.errorResult(409, "User with userName = '" + userName + "' already exists!", ScimErrorResponseType.UNIQUENESS);
            }
            userToBeReplaced.setName(userName);
        }
        if (password2.length > 0) {
            // empty if block
        }
        userToBeReplaced.setGivenName(givenName);
        userToBeReplaced.setFamilyName(familyName);
        userToBeReplaced.setEmail(email);
        if (active != null) {
            if (active.booleanValue()) {
                userToBeReplaced.resetLoginErrorCounter();
                userToBeReplaced.resetSignatureErrorCounter();
            } else {
                userToBeReplaced.lock();
            }
        }
        userToBeReplaced.save();
        SCIM_LOGGER.info("Successfully replaced User '" + userName + "' (id=" + userToBeReplaced.getId() + ", uuid=" + String.valueOf(userToBeReplaced.getUUID()) + ") after receiving PUT request.");
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode userJsonNode = SCIMUtil.getJsonUserRepresentation(userToBeReplaced, mapper, null, true);
        return SCIMApiEndpoint.ok((String)mapper.writeValueAsString((Object)userJsonNode)).as("application/scim+json");
    }

    private boolean updateUser(JsonNode operationNode, User userToBeUpdated) throws MandatoryFieldMissingException, ErrorResultException {
        String operationString = SCIMUtil.getMandatoryJsonFieldValue(operationNode, "op");
        PatchOperation operation = PatchOperation.getForName(operationString);
        if (operation == null) {
            throw new ErrorResultException(400, "Invalid PATCH operation '" + operationString + "' (must be 'add'/'remove'/'replace').", ScimErrorResponseType.INVALID_VALUE);
        }
        String path = SCIMUtil.getOptionalJsonFieldValue(operationNode, "path", null);
        Object valueNode = PatchOperation.ADD.equals((Object)operation) || PatchOperation.REPLACE.equals((Object)operation) ? SCIMUtil.getMandatoryJsonField(operationNode, "value") : null;
        boolean userIsModified = false;
        switch (operation.ordinal()) {
            case 0: 
            case 2: {
                if (path == null) {
                    String userName = SCIMUtil.getOptionalJsonFieldValue(valueNode, "userName", null);
                    String activeString = SCIMUtil.getOptionalJsonFieldValue(valueNode, "active", null);
                    Boolean active = activeString == null ? null : Boolean.valueOf(Boolean.parseBoolean(activeString));
                    String familyName = SCIMUtil.getOptionalJsonFieldValue(valueNode, "name.familyName", null);
                    String givenName = SCIMUtil.getOptionalJsonFieldValue(valueNode, "name.givenName", null);
                    boolean hasEmail = SCIMUtil.hasEmailBaseNode(valueNode);
                    if (userName != null) {
                        userIsModified |= SCIMUtil.setUserName(userToBeUpdated, userName);
                    }
                    if (active != null) {
                        userIsModified |= SCIMUtil.setUserActiveStatus(userToBeUpdated, active);
                    }
                    if (familyName != null) {
                        userIsModified |= SCIMUtil.setUserFamilyName(userToBeUpdated, familyName);
                    }
                    if (givenName != null) {
                        userIsModified |= SCIMUtil.setUserGivenName(userToBeUpdated, givenName);
                    }
                    if (hasEmail) {
                        userIsModified |= SCIMUtil.setUserEmail(userToBeUpdated, SCIMUtil.getWorkEmailFromBaseNode(valueNode));
                    }
                    if (valueNode.get("groups") == null) break;
                    userIsModified |= SCIMUtil.addUserToGroups(userToBeUpdated, valueNode.get("groups"));
                    if (operation != PatchOperation.REPLACE) break;
                    userIsModified |= SCIMUtil.removeUserFromOtherGroups(userToBeUpdated, valueNode.get("groups"));
                    break;
                }
                if ("name".equals(path)) {
                    String familyName = SCIMUtil.getOptionalJsonFieldValue(valueNode, "familyName", null);
                    String givenName = SCIMUtil.getOptionalJsonFieldValue(valueNode, "givenName", null);
                    if (familyName != null) {
                        userIsModified |= SCIMUtil.setUserFamilyName(userToBeUpdated, familyName);
                    }
                    if (givenName == null) break;
                    userIsModified |= SCIMUtil.setUserGivenName(userToBeUpdated, givenName);
                    break;
                }
                if ("name.familyName".equals(path)) {
                    userIsModified |= SCIMUtil.setUserFamilyName(userToBeUpdated, valueNode.asText());
                    break;
                }
                if ("name.givenName".equals(path)) {
                    userIsModified |= SCIMUtil.setUserGivenName(userToBeUpdated, valueNode.asText());
                    break;
                }
                if ("userName".equals(path)) {
                    String userName = valueNode.textValue();
                    userIsModified |= SCIMUtil.setUserName(userToBeUpdated, userName);
                    break;
                }
                if ("active".equals(path)) {
                    String activeString = valueNode.textValue();
                    Boolean active = activeString == null ? null : Boolean.valueOf(Boolean.parseBoolean(activeString));
                    userIsModified |= SCIMUtil.setUserActiveStatus(userToBeUpdated, active);
                    break;
                }
                if ("emails[type eq \"work\"]".equals(path)) {
                    String email = valueNode.textValue();
                    userIsModified |= SCIMUtil.setUserEmail(userToBeUpdated, email);
                    break;
                }
                if ("emails".equals(path)) {
                    String email = SCIMUtil.getWorkEmailFromEmailsNode(valueNode);
                    userIsModified |= SCIMUtil.setUserEmail(userToBeUpdated, email);
                    break;
                }
                if ("groups".equals(path)) {
                    userIsModified |= SCIMUtil.addUserToGroups(userToBeUpdated, valueNode);
                    if (operation != PatchOperation.REPLACE) break;
                    userIsModified |= SCIMUtil.removeUserFromOtherGroups(userToBeUpdated, valueNode);
                    break;
                }
                throw new ErrorResultException(400, "Invalid or unsupported path '" + path + "' for '" + operationString + "' method for Groups!", ScimErrorResponseType.INVALID_PATH);
            }
            case 1: {
                if (path == null) {
                    throw new ErrorResultException(400, "Missing path for '" + operationString + " user' method!", ScimErrorResponseType.NO_TARGET);
                }
                if ("userName".equals(path) || "active".equals(path)) {
                    throw new ErrorResultException(400, "Cannot remove the required path '" + path + "' for a User!", ScimErrorResponseType.MUTABILITY);
                }
                if ("name".equals(path)) {
                    userIsModified |= SCIMUtil.setUserFamilyName(userToBeUpdated, null);
                    userIsModified |= SCIMUtil.setUserGivenName(userToBeUpdated, null);
                    break;
                }
                if ("emails[type eq \"work\"]".equals(path) || "emails".equals(path)) {
                    userIsModified |= SCIMUtil.setUserEmail(userToBeUpdated, null);
                    break;
                }
                if ("groups".equals(path)) {
                    userIsModified |= SCIMUtil.removeUserFromAllGroups(userToBeUpdated);
                    break;
                }
                if (path.startsWith("groups[value eq")) {
                    Matcher matcher = Pattern.compile("groups\\[value eq ([^]]*)]").matcher(path);
                    if (!matcher.matches()) break;
                    userIsModified |= SCIMUtil.removeUserFromGroup(userToBeUpdated, matcher.group(1).replace("\\", "").replace("\"", ""));
                    break;
                }
                throw new ErrorResultException(400, "Invalid or unsupported path '" + path + "' for '" + operationString + "' method for Users!", ScimErrorResponseType.INVALID_PATH);
            }
        }
        if (userIsModified) {
            // empty if block
        }
        return userIsModified;
    }

    private boolean updateGroup(JsonNode operationNode, SCIMGroup groupToBeUpdated) throws MandatoryFieldMissingException, ErrorResultException {
        String operationString = SCIMUtil.getMandatoryJsonFieldValue(operationNode, "op");
        PatchOperation operation = PatchOperation.getForName(operationString);
        if (operation == null) {
            throw new ErrorResultException(400, "Invalid PATCH operation '" + operationString + "' (must be 'add'/'remove'/'replace').", ScimErrorResponseType.INVALID_VALUE);
        }
        String path = SCIMUtil.getOptionalJsonFieldValue(operationNode, "path", null);
        Object valueNode = PatchOperation.ADD.equals((Object)operation) || PatchOperation.REPLACE.equals((Object)operation) ? SCIMUtil.getMandatoryJsonField(operationNode, "value") : null;
        boolean groupIsModified = false;
        switch (operation.ordinal()) {
            case 0: 
            case 2: {
                if ("members".equals(path)) {
                    groupIsModified |= SCIMUtil.addUsersToGroup(groupToBeUpdated, valueNode);
                    if (operation != PatchOperation.REPLACE) break;
                    groupIsModified |= SCIMUtil.removeOtherUsersFromGroup(groupToBeUpdated, valueNode);
                    break;
                }
                throw new ErrorResultException(400, "Invalid or unsupported path '" + path + "' for '" + operationString + "' method for Groups!", ScimErrorResponseType.INVALID_PATH);
            }
            case 1: {
                if (path == null) {
                    throw new ErrorResultException(400, "Missing path for '" + operationString + " group' method!", ScimErrorResponseType.NO_TARGET);
                }
                if ("members".equals(path)) {
                    for (User member : groupToBeUpdated.getMembers()) {
                        groupIsModified |= groupToBeUpdated.setMembershipStatus(member, false);
                    }
                    break;
                }
                if (path.startsWith("members[value eq")) {
                    Matcher matcher = Pattern.compile("members\\[value eq ([^]]*)]").matcher(path);
                    if (!matcher.matches()) break;
                    groupIsModified |= SCIMUtil.removeUserFromGroup(matcher.group(1).replace("\\", "").replace("\"", ""), groupToBeUpdated);
                    break;
                }
                throw new ErrorResultException(400, "Invalid or unsupported path '" + path + "' for '" + operationString + "' method for Groups!", ScimErrorResponseType.INVALID_PATH);
            }
        }
        if (groupIsModified) {
            // empty if block
        }
        return groupIsModified;
    }

    static {
        dumpFileWriter = null;
    }

    public static enum Method {
        CREATE,
        SEARCH,
        READ,
        REPLACE,
        DELETE,
        UPDATE;

    }

    public static class MandatoryFieldMissingException
    extends Exception {
        private final String message;

        public MandatoryFieldMissingException(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static final class ScimErrorResponseType {
        private final String stringValue;
        static final ScimErrorResponseType INVALID_FILTER = new ScimErrorResponseType("invalidFilter");
        static final ScimErrorResponseType TOO_MANY = new ScimErrorResponseType("tooMany");
        static final ScimErrorResponseType UNIQUENESS = new ScimErrorResponseType("uniqueness");
        static final ScimErrorResponseType MUTABILITY = new ScimErrorResponseType("mutability");
        static final ScimErrorResponseType INVALID_SYNTAX = new ScimErrorResponseType("invalidSyntax");
        static final ScimErrorResponseType INVALID_PATH = new ScimErrorResponseType("invalidPath");
        static final ScimErrorResponseType NO_TARGET = new ScimErrorResponseType("noTarget");
        static final ScimErrorResponseType INVALID_VALUE = new ScimErrorResponseType("invalidValue");
        static final ScimErrorResponseType INVALID_VERSION = new ScimErrorResponseType("invalidVers");
        static final ScimErrorResponseType SENSITIVE = new ScimErrorResponseType("sensitive");

        public String toString() {
            return this.stringValue;
        }

        private ScimErrorResponseType(String stringValue) {
            this.stringValue = stringValue;
        }
    }

    public static class ErrorResultException
    extends Exception {
        private final int statusCode;
        private final String description;
        private final ScimErrorResponseType scimType;

        public ErrorResultException(int statusCode, String description, ScimErrorResponseType scimType) {
            this.statusCode = statusCode;
            this.description = description;
            this.scimType = scimType;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getDescription() {
            return this.description;
        }

        public ScimErrorResponseType getScimType() {
            return this.scimType;
        }
    }

    public static enum PatchOperation {
        ADD,
        REMOVE,
        REPLACE;


        public static PatchOperation getForName(String name) {
            return switch (name) {
                case "add" -> ADD;
                case "remove" -> REMOVE;
                case "replace" -> REPLACE;
                default -> null;
            };
        }
    }
}

