/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding.raisin;

import com.fasterxml.jackson.databind.JsonNode;
import controllers.cm.CmCheckReporter;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.DsBank;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.transfer.api.CustomerProtocolSettings;
import de.businesslogics.banking.transfer.api.NotificationSettings;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import io.ebean.Transaction;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;

public class RaisinApiEndpoint
extends Controller {
    private static final String HOST_ID_PLACEHOLDER = "RAISINAPI";
    private static final String CUSTOMER_ID_PLACEHOLDER = "RAISINAPI";
    private static final String RAISIN_BIC = "MHBFDEFFXXX";
    private static final String LOGGER_PREFIX = "Raisin API: ";
    private static final DateFormat UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final DateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static boolean USE_RAISIN_BANK = false;
    public static String RAISIN_API_KEY = null;
    public static String SUBSCRIPTION_ID = null;
    public static String RAISIN_API_URL = "https://rsb-api.com";
    public static String RAISIN_TENANT_NAME = null;
    public static int API_THROTTLED_DEFAULT_WAIT_TIME_SECONDS = 2;
    public static int API_THROTTLED_MAX_WAIT_TIME_SECONDS = 10;
    public static int API_THROTTLED_MAX_RETRIES = 10;
    public static int PAGED_API_REQUEST_PAGE_SIZE = 200;

    public static BankSettings getRaisinBank() {
        if (!USE_RAISIN_BANK) {
            return null;
        }
        return (BankSettings)DB.find(BankSettings.class).where().eq("customer_id", (Object)"RAISINAPI").eq("host_id", (Object)"RAISINAPI").findOne();
    }

    private static String getRaisinBankUrl() {
        BankSettings raisinBank = RaisinApiEndpoint.getRaisinBank();
        if (raisinBank == null) {
            BLLoggerPlay.warning("Raisin API: Could not find Raisin bank in database!");
            return RAISIN_API_URL;
        }
        String url = raisinBank.getUrl();
        if (url == null || url.isEmpty()) {
            BLLoggerPlay.warning("Raisin API: URL of Raisin bank in database is null/empty!");
            return RAISIN_API_URL;
        }
        return url;
    }

    public static Account getRaisinAccount(String depositRaisinApiId) {
        if (!USE_RAISIN_BANK) {
            return null;
        }
        BankSettings raisinBank = RaisinApiEndpoint.getRaisinBank();
        if (raisinBank == null) {
            BLLoggerPlay.warning("Raisin API: Attempt to find Raisin Account with API ID '" + depositRaisinApiId + "', but Raisin bank does not exist!");
            return null;
        }
        if (depositRaisinApiId == null || depositRaisinApiId.isEmpty()) {
            BLLoggerPlay.warning("Raisin API: Attempt to find Raisin Account with an empty deposit API ID!");
            return null;
        }
        return Account.findAccountByCmIdentification((BankSettings)raisinBank, (String)depositRaisinApiId);
    }

    public static Account getOrCreateRaisinAccount(String raisinApiDepositId, String iban, String currencyCode) {
        Account accountInDatabase = RaisinApiEndpoint.getRaisinAccount(raisinApiDepositId);
        if (accountInDatabase != null) {
            return accountInDatabase;
        }
        return RaisinApiEndpoint.createOrUpdateDepositAccount(raisinApiDepositId, "", iban, currencyCode, true);
    }

    public static CmBooking getRaisinBooking(Account forAccount, String transactionRaisinApiId) {
        if (!USE_RAISIN_BANK) {
            return null;
        }
        if (forAccount == null) {
            BLLoggerPlay.warning("Raisin API: Attempt to find Raisin CmBooking with account==null!");
            return null;
        }
        if (transactionRaisinApiId == null || transactionRaisinApiId.isEmpty()) {
            BLLoggerPlay.warning("Raisin API: Attempt to find Raisin CmBooking with an empty transaction API ID!");
            return null;
        }
        List bookings2 = CmBooking.findByMsgId((String)transactionRaisinApiId, (Account)forAccount);
        if (bookings2.isEmpty()) {
            return null;
        }
        if (bookings2.size() > 1) {
            BLLoggerPlay.warning("Raisin API: Found multiple CmBookings for transaction ID '" + transactionRaisinApiId + "'! Database ids of these bookings: " + String.valueOf(bookings2.stream().map(b -> b.getId().toString()).reduce((i, j) -> i + "," + j)));
        }
        return (CmBooking)bookings2.get(0);
    }

    private static CmStatement getStatementForAccountAndDay(Account account, Date date2) {
        List statements = DB.find(CmStatement.class).where().eq("account", (Object)account).eq("closingDate", (Object)date2).orderBy("id desc").findList();
        if (statements.size() == 0) {
            BLLoggerPlay.info("Raisin API: No Statements exist yet for Raisin account " + account.getIban() + " for date " + String.valueOf(date2));
            return null;
        }
        if (statements.size() > 1) {
            BLLoggerPlay.warning("Raisin API: Found multiple Statements for Raisin account '" + account.getIban() + "' for the date " + String.valueOf(date2) + " (there should be only one statement per account per day)");
        }
        return (CmStatement)statements.get(0);
    }

    @Deprecated
    private static Integer getNextRaisinStatementNumber(Account account) {
        Date startOfCurrentYear = Date.valueOf(LocalDate.now().withMonth(1).withDayOfMonth(1));
        CmStatement statement = (CmStatement)DB.find(CmStatement.class).where().eq("account", (Object)account).ge("closingDate", (Object)startOfCurrentYear).orderBy("statement_number desc").setMaxRows(1).findOne();
        if (statement != null) {
            return statement.getStatementNumber() + 1;
        }
        return 1;
    }

    private static Integer getRaisinStatementNumber() {
        return Integer.parseInt(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
    }

    public static BankSettings createOrUpdateRaisinBank() {
        if (USE_RAISIN_BANK) {
            BankSettings raisinBank = RaisinApiEndpoint.getRaisinBank();
            boolean createdRaisinBank = false;
            try (Transaction t = DB.beginTransaction();){
                if (raisinBank == null) {
                    createdRaisinBank = true;
                    raisinBank = new BankSettings();
                    raisinBank.setUrl(RAISIN_API_URL);
                    Tenant raisinBankTenant = null;
                    if (RAISIN_TENANT_NAME != null && DB.find(Tenant.class).where().eq("name", (Object)RAISIN_TENANT_NAME).findCount() == 1) {
                        raisinBankTenant = (Tenant)DB.find(Tenant.class).where().eq("name", (Object)RAISIN_TENANT_NAME).findOne();
                    }
                    if (raisinBankTenant == null) {
                        BLLoggerPlay.error("Raisin API: No (unique) tenant found for the specified bl.raisin.tenant_name='" + RAISIN_TENANT_NAME + "'!)");
                        BankSettings bankSettings = null;
                        return bankSettings;
                    }
                    raisinBank.setTenant(raisinBankTenant);
                    raisinBank.setCountryCode("DE");
                    raisinBank.setCustomerId("RAISINAPI");
                    raisinBank.setDisplayName("Raisin Bank");
                    raisinBank.setHostId("RAISINAPI");
                    raisinBank.setIcon("raisin.ico");
                    raisinBank.setProtocolVersion("H005");
                    raisinBank.save();
                    CMBank cmBank = CMBank.get((BankSettings)raisinBank);
                    cmBank.setStatementFetchActivated(false);
                    cmBank.setAdviceFetchActivated(false);
                    cmBank.setCreditAdviceFetchActivated(false);
                    cmBank.setC54FetchActivated(false);
                    cmBank.setBkaFetchActivated(false);
                    cmBank.setBkiFetchActivated(false);
                    cmBank.save();
                    CustomerProtocolSettings protocolHandler = CustomerProtocolSettings.byBank((BankSettings)raisinBank);
                    protocolHandler.set(false);
                    NotificationSettings notificationsHandler = NotificationSettings.getForBank((BankSettings)raisinBank);
                    notificationsHandler.setIsActivated(false);
                    notificationsHandler.setFetchBundesbankNotifications(false);
                    notificationsHandler.setFetchCreditNotifications(false);
                    notificationsHandler.setFetchCallbackNotifications(false);
                    notificationsHandler.setFetchDebitNotifications(false);
                    notificationsHandler.setFetchInstantNotifications(false);
                    notificationsHandler.save();
                    DsBank dsBank = DsBank.get((BankSettings)raisinBank);
                    dsBank.setActivated(false);
                    dsBank.save();
                }
                if (RAISIN_API_URL != null && !raisinBank.getUrl().equals(RAISIN_API_URL)) {
                    raisinBank.setUrl(RAISIN_API_URL);
                    raisinBank.save();
                    BLLoggerPlay.info("Raisin API: Updated Raisin bank API URL from configuration.");
                }
                for (User adminUser : User.getAllTenantAdmins((Tenant)raisinBank.getTenant())) {
                    if (BankUser.findBankUser((BankSettings)raisinBank, (User)adminUser) != null) continue;
                    BankUser.createBankUser((BankSettings)raisinBank, (User)adminUser);
                }
                t.commit();
                if (createdRaisinBank) {
                    BLLoggerPlay.info("Raisin API: Created Raisin bank from configuration with id=" + raisinBank.getBankId());
                }
                RaisinApiEndpoint.updateApiSecret();
            }
            return raisinBank;
        }
        return null;
    }

    private static CmStatement getOrCreateTodaysStatementForAccount(Account account, BigDecimal openingBalance) {
        return RaisinApiEndpoint.getOrCreateStatementForAccount(account, null, openingBalance);
    }

    private static CmStatement getOrCreateStatementForAccount(Account account, Date forDate, BigDecimal openingBalance) {
        CmStatement todaysStatement;
        Timestamp now = new Timestamp(Calendar.getInstance().getTime().getTime());
        if (forDate == null) {
            forDate = Date.valueOf(now.toLocalDateTime().toLocalDate());
        }
        if ((todaysStatement = RaisinApiEndpoint.getStatementForAccountAndDay(account, forDate)) != null) {
            return todaysStatement;
        }
        todaysStatement = new CmStatement();
        if (openingBalance == null) {
            openingBalance = BigDecimal.ZERO;
        }
        try (Transaction t = DB.beginTransaction();){
            Integer statementNumber = RaisinApiEndpoint.getRaisinStatementNumber();
            todaysStatement.setAccount(account);
            todaysStatement.setType(CmStatement.Type.CAMT053);
            todaysStatement.setCreationDate(now);
            todaysStatement.setReference1(null);
            todaysStatement.setReference2(null);
            todaysStatement.setOpeningDate(forDate);
            todaysStatement.setOpeningBalance(openingBalance);
            todaysStatement.setOpeningFinal(true);
            todaysStatement.setClosingDate(forDate);
            todaysStatement.setClosingBalance(openingBalance);
            todaysStatement.setClosingFinal(true);
            todaysStatement.setCurrencyCode(account.getCurrency());
            todaysStatement.setStatementNumber(statementNumber);
            todaysStatement.setPageNumber(null);
            todaysStatement.setLegalNumber(null);
            todaysStatement.setUniqueId(CMProcessingDb.getUniqueStatementId((java.util.Date)forDate, (String)statementNumber.toString(), (String)"_RaisinStatement"));
            todaysStatement.setCountCredit(0);
            todaysStatement.setCountDebit(0);
            todaysStatement.setSumCredit(BigDecimal.ZERO);
            todaysStatement.setSumDebit(BigDecimal.ZERO);
            todaysStatement.setMaxCredit(null);
            todaysStatement.setMaxDebit(null);
            todaysStatement.setMinCredit(null);
            todaysStatement.setMinDebit(null);
            todaysStatement.setOriginalFilename(null);
            todaysStatement.setFile(null);
            DB.save((Object)todaysStatement);
            t.commit();
            BLLoggerPlay.info("Raisin API: Created statement for account '" + account.getIban() + "' and date " + String.valueOf(forDate));
        }
        return todaysStatement;
    }

    private static int getBookingPositionForStatement(CmStatement statement) {
        CmBooking bookingWithRecentPosition = (CmBooking)DB.find(CmBooking.class).where().eq("statement", (Object)statement).orderBy("pos desc").setMaxRows(1).findOne();
        if (bookingWithRecentPosition != null) {
            return bookingWithRecentPosition.getPos() + 1;
        }
        return 0;
    }

    public static Account createOrUpdateDepositAccountForDeposit(JsonNode depositJson, boolean saveAccountInDatabase) {
        if (USE_RAISIN_BANK) {
            try {
                boolean isActive;
                String raisinApiDepositId = RaisinApiEndpoint.getMandatoryJsonField(depositJson, "id");
                String state = RaisinApiEndpoint.getOptionalJsonField(depositJson, "state", "ACTIVE");
                boolean bl = isActive = "APPROVED".equals(state) || "ACTIVE".equals(state);
                if (!isActive) {
                    BLLoggerPlay.warning("Raisin API: Deposit account with API ID '" + raisinApiDepositId + "' is not in an active state and will not be processed! (state = '" + state + "')");
                    return null;
                }
                String iban = RaisinApiEndpoint.getOptionalJsonField(depositJson, "iban", "");
                if (iban.isEmpty()) {
                    BLLoggerPlay.warning("Raisin API: Deposit account with API ID '" + raisinApiDepositId + "' has no iban and will not be processed!");
                    return null;
                }
                String currency = RaisinApiEndpoint.getOptionalJsonField(depositJson, "currencyCode", "EUR");
                String accountHolderName = RaisinApiEndpoint.loadAccountHolderFromAPI(RaisinApiEndpoint.getMandatoryJsonField(depositJson, "accountHolderId"));
                Account depositAccount = RaisinApiEndpoint.createOrUpdateDepositAccount(raisinApiDepositId, accountHolderName, iban, currency, saveAccountInDatabase);
                if (saveAccountInDatabase && DB.find(CmStatement.class).where().eq("account", (Object)depositAccount).findOne() == null) {
                    RaisinApiEndpoint.getOrCreateTodaysStatementForAccount(depositAccount, RaisinApiEndpoint.getMandatoryJsonDecimal(depositJson, "balance"));
                }
                return depositAccount;
            }
            catch (MandatoryFieldMissingException e) {
                RaisinApiEndpoint.logError(e);
                return null;
            }
        }
        return null;
    }

    private static Account createOrUpdateDepositAccount(String depositRaisinApiId, String accountHolderName, String iban, String currency, boolean saveAccountInDatabase) {
        String description = "API ID: " + depositRaisinApiId;
        Account account = RaisinApiEndpoint.getRaisinAccount(depositRaisinApiId);
        if (account == null) {
            account = new Account();
        }
        account.setType(Account.Type.HTD);
        account.setCmIdentification(StringUtils.shorten((String)depositRaisinApiId, (int)256));
        account.setBank(RaisinApiEndpoint.getRaisinBank());
        account.setDescription(StringUtils.shorten((String)description, (int)256));
        account.setAccountHolder(StringUtils.shorten((String)accountHolderName, (int)256));
        account.setAccountHolderHTD(null);
        account.setFolder(null);
        account.setUseVirtualBalances(Boolean.valueOf(false));
        account.setIgnoreAccountInformation(Boolean.valueOf(true));
        account.setBic(RAISIN_BIC);
        account.setCurrency(StringUtils.shorten((String)currency, (int)3));
        account.setName(null);
        account.setIban(StringUtils.shorten((String)iban, (int)34));
        String nationalBankCode = null;
        String nationalAccountNumber = null;
        if (iban.startsWith("FR")) {
            nationalBankCode = iban.substring(4, 9);
            account.setFrenchBankCode(nationalBankCode);
            nationalAccountNumber = iban.substring(9, 14);
            account.setFrenchAccountNumber(nationalAccountNumber);
            account.setFrenchBranchCode(iban.substring(14, 25));
            account.setFrenchCheckCode(iban.substring(25, 27));
        } else if (iban.startsWith("DE")) {
            nationalBankCode = iban.substring(4, 12);
            account.setGermanBankCode(nationalBankCode);
            nationalAccountNumber = iban.substring(12);
            account.setGermanAccountNumber(nationalAccountNumber);
        }
        account.setNationalAccountNumber(nationalAccountNumber);
        account.setNationalBankCode(nationalBankCode);
        if (saveAccountInDatabase) {
            account.save();
            AccountPermission.createPermissionForAllUsers((Account)account);
            ValueBalanceCalculator.recalculate((Account)account);
        }
        return account;
    }

    private static Result apiCallback_incomingTransaction(JsonNode transactionJson) {
        BLLoggerPlay.info("Raisin API: Start processing incoming payment transaction ...");
        CmBooking booking = RaisinApiEndpoint.createNewBookingForTransaction(transactionJson, false);
        return booking == null ? RaisinApiEndpoint.badRequest() : RaisinApiEndpoint.noContent();
    }

    private static Result apiCallback_incomingTransactionCancellation(JsonNode transactionJson) {
        BLLoggerPlay.info("Raisin API: Start processing incoming payment cancellation transaction ...");
        CmBooking booking = RaisinApiEndpoint.createNewBookingForTransaction(transactionJson, true);
        return booking == null ? RaisinApiEndpoint.badRequest() : RaisinApiEndpoint.noContent();
    }

    private static Result apiCallback_outgoingTransaction(JsonNode transactionJson) {
        BLLoggerPlay.info("Raisin API: Start processing outgoing payment transaction ...");
        CmBooking booking = RaisinApiEndpoint.createNewBookingForTransaction(transactionJson, false);
        return booking == null ? RaisinApiEndpoint.badRequest() : RaisinApiEndpoint.noContent();
    }

    private static Result apiCallback_outgoingTransactionCancellation(JsonNode transactionJson) {
        BLLoggerPlay.info("Raisin API: Start processing outgoing payment cancellation transaction ...");
        CmBooking booking = RaisinApiEndpoint.createNewBookingForTransaction(transactionJson, true);
        return booking == null ? RaisinApiEndpoint.badRequest() : RaisinApiEndpoint.noContent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CmBooking createNewBookingForTransaction(JsonNode transactionJson, boolean isCancellation) {
        if (!USE_RAISIN_BANK) return null;
        String transactionId = null;
        try {
            transactionId = RaisinApiEndpoint.getMandatoryJsonField(transactionJson, "id");
            BigDecimal amount2 = RaisinApiEndpoint.getMandatoryJsonDecimal(transactionJson, "amount");
            BigDecimal balanceAfterTransaction = RaisinApiEndpoint.getMandatoryJsonDecimal(transactionJson, "balance");
            String localPartyIban = RaisinApiEndpoint.getMandatoryJsonField(transactionJson, "iban");
            String localPartyDepositId = RaisinApiEndpoint.getMandatoryJsonField(transactionJson, "depositId");
            String transactionType = RaisinApiEndpoint.getMandatoryJsonField(transactionJson, "type");
            String creationDateString = RaisinApiEndpoint.getMandatoryJsonField(transactionJson, "creationDate");
            String bookingDateString = RaisinApiEndpoint.getMandatoryJsonField(transactionJson, "bookingDate");
            String valueDateString = RaisinApiEndpoint.getMandatoryJsonField(transactionJson, "valueDate");
            String currencyCode = RaisinApiEndpoint.getMandatoryJsonField(transactionJson, "currencyCode");
            String endToEndId = RaisinApiEndpoint.getOptionalJsonField(transactionJson, "endToEndId", null);
            String purpose = RaisinApiEndpoint.getOptionalJsonField(transactionJson, "purpose", "");
            String counterPartyName = RaisinApiEndpoint.getOptionalJsonField(transactionJson, "counterpartyName", null);
            String counterPartyIban = RaisinApiEndpoint.getOptionalJsonField(transactionJson, "counterpartyIban", null);
            String counterPartyBic = RaisinApiEndpoint.getOptionalJsonField(transactionJson, "counterpartyBic", null);
            String counterPartyAccountId = RaisinApiEndpoint.getOptionalJsonField(transactionJson, "counterpartyAccountId", null);
            if ((counterPartyName == null || counterPartyIban == null) && counterPartyAccountId != null) {
                try {
                    Account counterpartyAccount = RaisinApiEndpoint.loadCounterPartyAccountFromAPI(counterPartyAccountId);
                    if (counterpartyAccount != null) {
                        counterPartyName = counterpartyAccount.getAccountHolder();
                        counterPartyIban = RaisinApiEndpoint.getIbanOrAccountNumber(counterpartyAccount);
                        counterPartyBic = RaisinApiEndpoint.getBicOrBankcode(counterpartyAccount);
                    }
                }
                catch (Exception e) {
                    RaisinApiEndpoint.logError("Failed to load counterparty account with ID " + counterPartyAccountId + " from API!", e);
                }
            }
            try (Transaction t = DB.beginTransaction();){
                CmBooking existingBooking;
                Account localPartyAccount = RaisinApiEndpoint.loadLocalPartyAccountFromAPI(localPartyDepositId, false);
                if (localPartyAccount == null) {
                    BLLoggerPlay.error("Raisin API: Could not load local party account from API for new transaction!");
                    localPartyAccount = RaisinApiEndpoint.getOrCreateRaisinAccount(localPartyDepositId, localPartyIban, currencyCode);
                }
                if (!localPartyAccount.getIban().replaceAll(" ", "").equals(localPartyIban.replaceAll(" ", ""))) {
                    BLLoggerPlay.warning("Raisin API: Local party IBAN '" + localPartyIban + "' of new transaction is not equal to the IBAN '" + localPartyAccount.getIban() + "' of the local party account!");
                    localPartyAccount.setIban(localPartyIban);
                }
                if ((existingBooking = RaisinApiEndpoint.getRaisinBooking(localPartyAccount, transactionId)) != null) {
                    BLLoggerPlay.warning("Raisin API: CmBooking already exists in database for transaction ID '" + transactionId + "'!");
                    CmBooking cmBooking = existingBooking;
                    return cmBooking;
                }
                BigDecimal balanceBeforeTransaction = balanceAfterTransaction.subtract(amount2);
                Date transactionCreationDate = new Date(UTC_DATE_FORMAT.parse(creationDateString).getTime());
                CmStatement statementForBooking = RaisinApiEndpoint.getOrCreateStatementForAccount(localPartyAccount, transactionCreationDate, balanceBeforeTransaction);
                boolean isReversal = isCancellation || RaisinApiEndpoint.isReversalBooking(transactionType);
                boolean isDebit = amount2.compareTo(BigDecimal.ZERO) < 0;
                String bookingKey = RaisinApiEndpoint.getBookingKeyForTransactionType(transactionType);
                String gvc = RaisinApiEndpoint.getGvcForTransactionType(transactionType);
                CmBooking booking = new CmBooking();
                booking.setStatement(statementForBooking);
                booking.setPage(null);
                booking.setAccount(localPartyAccount);
                booking.setParentBooking(null);
                booking.setPos(RaisinApiEndpoint.getBookingPositionForStatement(statementForBooking));
                booking.setBookingDate(new Date(UTC_DATE_FORMAT.parse(bookingDateString).getTime()));
                booking.setValueDate(new Date(SIMPLE_DATE_FORMAT.parse(valueDateString).getTime()));
                booking.setSts("BOOK");
                booking.setBookingKey(bookingKey);
                booking.setPurpose(StringUtils.shorten((String)purpose, (int)400));
                booking.setPurposeOverview(StringUtils.shorten((String)purpose, (int)140));
                booking.setGvc(gvc);
                booking.setAmount(amount2);
                booking.setCurrency(Currency.getInstance((String)currencyCode));
                booking.setBalance(balanceAfterTransaction);
                booking.setCollective(false);
                booking.setDebit(isDebit);
                booking.setReversal(isReversal);
                booking.setEndToEndId(StringUtils.shorten((String)endToEndId, (int)35));
                String localPartyAccountNumber = RaisinApiEndpoint.getIbanOrAccountNumber(localPartyAccount);
                String localPartyBankCode = RaisinApiEndpoint.getBicOrBankcode(localPartyAccount);
                booking.setLocalParty(StringUtils.shorten((String)localPartyAccount.getAccountHolder(), (int)140));
                booking.setLocalPartyBankCode(StringUtils.shorten((String)localPartyBankCode, (int)30));
                booking.setLocalPartyAccountNumber(StringUtils.shorten((String)localPartyAccountNumber, (int)40));
                booking.setLocalPartyMandateReference(null);
                booking.setLocalPartyCreditorId(null);
                booking.setUltimateLocalParty(null);
                booking.setCounterParty(StringUtils.shorten((String)counterPartyName, (int)140));
                booking.setCounterPartyAccountNumber(StringUtils.shorten((String)counterPartyIban, (int)40));
                booking.setCounterPartyBankCode(StringUtils.shorten((String)counterPartyBic, (int)30));
                booking.setCounterPartyMandateReference(null);
                booking.setCounterPartyCreditorId(null);
                booking.setUltimateCounterParty(null);
                booking.setAdditionalInformation(transactionType);
                booking.setMsgId(transactionId);
                booking.setTransactionId(transactionId);
                booking.setRejectionCauseCode(null);
                booking.setBankReference(null);
                booking.setOriginalAmount(null);
                booking.setOriginalCurrency(null);
                booking.setSettlementAmount(null);
                booking.setSettlementCurrency(null);
                booking.setChargesAmount(null);
                booking.setChargesCurrency(null);
                booking.setFeeType(null);
                booking.setConvertedAmount(null);
                booking.setConvertedCurrency(null);
                booking.setExchangeRate(null);
                booking.setExchangeRateDate(null);
                booking.setBookingText(null);
                booking.setPrimanota(null);
                booking.setTextKeyAppendix(null);
                booking.setCustomerReference(null);
                booking.setCustomerReferenceDate(null);
                booking.setInstrId(null);
                booking.setPmtInfId(null);
                booking.setTransactionCode(null);
                booking.setDomainCode(null);
                booking.setFamilyCode(null);
                booking.setSubFamilyCode(null);
                booking.setInterbankTransactionCode(null);
                booking.setEntryNumber(null);
                booking.setExemption(null);
                booking.setUnavailabiltyRating(null);
                booking.setSignedPayments(null);
                DB.save((Object)booking);
                BigDecimal newClosingBalance = statementForBooking.getClosingBalance().add(amount2);
                statementForBooking.setClosingBalance(newClosingBalance);
                BookingStatistics statistics = new BookingStatistics();
                statistics.addStatement(statementForBooking);
                statistics.addBooking(amount2);
                statistics.storeStatistics(statementForBooking);
                ValueBalanceCalculator.recalculate((Account)localPartyAccount);
                CmCheckReporter.markNewStatements(Collections.singletonList(statementForBooking), null, false);
                t.commit();
                BLLoggerPlay.info("Raisin API: finished processing transaction with ID " + transactionId + ".");
                CmBooking cmBooking = booking;
                return cmBooking;
            }
            catch (Exception e) {
                BLLoggerPlay.warning("Raisin API: finished processing transaction with ID " + transactionId + " with errors!");
                RaisinApiEndpoint.logError(e);
                return null;
            }
        }
        catch (MandatoryFieldMissingException e) {
            BLLoggerPlay.warning("Raisin API: finished processing transaction with ID " + transactionId + " with errors!");
            RaisinApiEndpoint.logError(e);
            return null;
        }
    }

    public static Result apiCallback_accountApproved(JsonNode accountApprovedJson) {
        if (USE_RAISIN_BANK) {
            BLLoggerPlay.info("Raisin API: Start processing 'account approved' event ...");
            try {
                String closedAccountNameSuffix;
                String name;
                String raisinApiDepositId = RaisinApiEndpoint.getMandatoryJsonField(accountApprovedJson, "id");
                Account approvedAccount = RaisinApiEndpoint.loadLocalPartyAccountFromAPI(raisinApiDepositId, true);
                if (approvedAccount != null && (name = approvedAccount.getName()).endsWith(closedAccountNameSuffix = " (closed)")) {
                    approvedAccount.setName(name.substring(0, name.length() - closedAccountNameSuffix.length()));
                    approvedAccount.setType(Account.Type.HTD);
                    approvedAccount.save();
                }
                return RaisinApiEndpoint.noContent();
            }
            catch (MandatoryFieldMissingException e) {
                RaisinApiEndpoint.logError(e);
                return RaisinApiEndpoint.badRequest();
            }
        }
        return RaisinApiEndpoint.noContent();
    }

    public static Result apiCallback_accountClosed(JsonNode accountClosedJson) {
        if (USE_RAISIN_BANK) {
            BLLoggerPlay.info("Raisin API: Start processing 'account closed' event ...");
            try {
                String closedAccountNameSuffix;
                String name;
                String raisinApiDepositId = RaisinApiEndpoint.getMandatoryJsonField(accountClosedJson, "id");
                Account closedAccount = RaisinApiEndpoint.getRaisinAccount(raisinApiDepositId);
                if (closedAccount != null && !(name = closedAccount.getName()).endsWith(closedAccountNameSuffix = " (closed)")) {
                    closedAccount.setName(name + closedAccountNameSuffix);
                    closedAccount.setType(Account.Type.MANUAL);
                    closedAccount.save();
                }
                return RaisinApiEndpoint.noContent();
            }
            catch (MandatoryFieldMissingException e) {
                RaisinApiEndpoint.logError(e);
                return RaisinApiEndpoint.badRequest();
            }
        }
        return RaisinApiEndpoint.noContent();
    }

    private static Account loadLocalPartyAccountFromAPI(String raisinApiDepositId, boolean forceFreshLoadFromAPI) {
        return RaisinApiEndpoint.loadAccountFromAPI(raisinApiDepositId, forceFreshLoadFromAPI, true);
    }

    private static Account loadCounterPartyAccountFromAPI(String raisinApiDepositId) {
        return RaisinApiEndpoint.loadAccountFromAPI(raisinApiDepositId, true, false);
    }

    private static Account loadAccountFromAPI(String raisinApiDepositId, boolean forceFreshLoadFromAPI, boolean saveAccountInDatabase) {
        Account accountInDatabase;
        if (!forceFreshLoadFromAPI && (accountInDatabase = RaisinApiEndpoint.getRaisinAccount(raisinApiDepositId)) != null) {
            return accountInDatabase;
        }
        String downloadUrlPath = "/deposits/" + raisinApiDepositId;
        try {
            String depositJsonString = RaisinApiEndpoint.makeApiGetRequestWithRetries(downloadUrlPath);
            return RaisinApiEndpoint.createOrUpdateDepositAccountForDeposit(Json.parse((String)depositJsonString), saveAccountInDatabase);
        }
        catch (IOException | InterruptedException e) {
            RaisinApiEndpoint.logError("Failed to load deposit from URL '" + RaisinApiEndpoint.getRaisinBankUrl() + downloadUrlPath + "'", e);
            return null;
        }
    }

    public static void loadAllAccountsFromAPI() {
        if (!USE_RAISIN_BANK) {
            return;
        }
        String downloadUrlPath = null;
        try {
            int pageLimit = PAGED_API_REQUEST_PAGE_SIZE;
            int pageOffset = 0;
            int numberOfDepositsFound = pageLimit;
            while (numberOfDepositsFound == pageLimit) {
                downloadUrlPath = "/deposits?limit=" + pageLimit + "&offset=" + pageOffset;
                String depositJsonString = RaisinApiEndpoint.makeApiGetRequestWithRetries(downloadUrlPath);
                JsonNode jsonListOfDeposits = Json.parse((String)depositJsonString);
                numberOfDepositsFound = jsonListOfDeposits.size();
                for (JsonNode depositJson : jsonListOfDeposits) {
                    RaisinApiEndpoint.createOrUpdateDepositAccountForDeposit(depositJson, true);
                }
                pageOffset += numberOfDepositsFound;
            }
        }
        catch (Exception e) {
            RaisinApiEndpoint.logError("Failed to load deposits from URL '" + RaisinApiEndpoint.getRaisinBankUrl() + downloadUrlPath + "'", e);
        }
    }

    public static String loadAccountHolderFromAPI(String raisinApiAccountHolderId) {
        if (!USE_RAISIN_BANK) {
            return null;
        }
        String downloadUrlPath = "/businesses/" + raisinApiAccountHolderId;
        try {
            String resultJsonString = RaisinApiEndpoint.makeApiGetRequestWithRetries(downloadUrlPath);
            JsonNode businessCustomerJson = Json.parse((String)resultJsonString);
            return RaisinApiEndpoint.getMandatoryJsonField(businessCustomerJson, "name");
        }
        catch (IOException | InterruptedException e) {
            RaisinApiEndpoint.logError("Failed to load account holder from URL '" + RaisinApiEndpoint.getRaisinBankUrl() + downloadUrlPath + "'", e);
        }
        catch (MandatoryFieldMissingException e) {
            RaisinApiEndpoint.logError(e);
            return null;
        }
        return null;
    }

    public static void triggerMissedEvents() {
        if (!USE_RAISIN_BANK) {
            return;
        }
        if (SUBSCRIPTION_ID == null || SUBSCRIPTION_ID.isEmpty()) {
            BLLoggerPlay.error("Raisin API: Attempt to trigger re-sending of missed API events, but subscription ID is null/empty!");
            return;
        }
        String postUrlPath = "/notifications/" + SUBSCRIPTION_ID + "/missed-events";
        try {
            RaisinApiEndpoint.makeApiPostRequestWithRetries(postUrlPath);
            BLLoggerPlay.info("Raisin API: Successfully triggered the re-sending of missed events.");
        }
        catch (IOException | InterruptedException e) {
            RaisinApiEndpoint.logError("Failed to trigger the re-sending of missed events by POSTing to '" + RaisinApiEndpoint.getRaisinBankUrl() + postUrlPath + "'!", e);
        }
    }

    public static void updateApiSecret() {
        if (!USE_RAISIN_BANK) {
            return;
        }
        if (SUBSCRIPTION_ID == null || SUBSCRIPTION_ID.isEmpty()) {
            BLLoggerPlay.error("Raisin API: Attempt to update API secret, but subscription ID is null/empty!");
            return;
        }
        String requestUrlPath = "/notifications/" + SUBSCRIPTION_ID + "/secrets";
        try {
            boolean apiSecretChanged;
            String resultJsonString = RaisinApiEndpoint.makeApiGetRequestWithRetries(requestUrlPath);
            String oldApiSecret = RaisinApiEndpoint.getApiSecret();
            String newApiSecret = RaisinApiEndpoint.getMandatoryJsonField(Json.parse((String)resultJsonString), "secretKey");
            boolean bl = apiSecretChanged = !Objects.equals(oldApiSecret, newApiSecret);
            if (apiSecretChanged) {
                RaisinApiEndpoint.setApiSecret(newApiSecret);
                BLLoggerPlay.info("Raisin API: Fetched the recent API secret and stored it in database.");
            } else {
                BLLoggerPlay.info("Raisin API: Fetched the recent API secret, current version in database is already up-to-date.");
            }
        }
        catch (MandatoryFieldMissingException e) {
            RaisinApiEndpoint.logError(e);
        }
        catch (IOException | InterruptedException e) {
            RaisinApiEndpoint.logError("Failed to fetch the recent API secret from '" + RaisinApiEndpoint.getRaisinBankUrl() + requestUrlPath + "'!", e);
        }
    }

    public static String getApiSecret() {
        if (USE_RAISIN_BANK) {
            BankSettings raisinBank = RaisinApiEndpoint.getRaisinBank();
            if (raisinBank != null) {
                return raisinBank.getExpectedDigestX001();
            }
            BLLoggerPlay.warning("Raisin API: Could not find Raisin Bank in database for reading the API secret!");
        }
        return null;
    }

    private static void setApiSecret(String newApiSecret) {
        if (USE_RAISIN_BANK) {
            BankSettings raisinBank = RaisinApiEndpoint.getRaisinBank();
            if (raisinBank != null) {
                raisinBank.setExpectedDigestX001(newApiSecret);
                raisinBank.save();
            } else {
                BLLoggerPlay.warning("Raisin API: Could not find Raisin Bank in database for storing the API secret!");
            }
        }
    }

    private static boolean isReversalBooking(String transactionType) {
        return transactionType.endsWith("CANCELLATION");
    }

    private static boolean isInternalTransaction(String transactionType) {
        return transactionType.contains("INTERNAL");
    }

    private static String getBookingKeyForTransactionType(String transactionType) {
        switch (transactionType) {
            case "INCOMING_PAYMENT": 
            case "INCOMING_INTERNAL_TRANSFER": 
            case "OUTGOING_PAYMENT": 
            case "OUTGOING_INTERNAL_TRANSFER": {
                return "TRF";
            }
            case "INTEREST_APPLIED": {
                return "INT";
            }
            case "FEE_APPLIED": {
                return "CHG";
            }
            case "WITHHOLDING_TAX": {
                return "TAX";
            }
            case "FEE_APPLIED_CANCELLATION": 
            case "FEES_DUE_REDUCED_CANCELLATION": 
            case "INCOMING_INTERNAL_TRANSFER_CANCELLATION": 
            case "INCOMING_PAYMENT_CANCELLATION": 
            case "INTEREST_APPLIED_CANCELLATION": 
            case "LOAN_REPAID_CANCELLATION": 
            case "OUTGOING_INTERNAL_TRANSFER_CANCELLATION": 
            case "OUTGOING_PAYMENT_CANCELLATION": 
            case "WITHHOLDING_TAX_CANCELLATION": 
            case "WRITE_OFF_CANCELLATION": {
                return "RTI";
            }
            case "FEES_DUE_REDUCED": 
            case "INTEREST_RATE_CHANGED": 
            case "LOAN_REPAID": 
            case "MIGRATION": 
            case "OTHER": 
            case "OVERDRAFT_INTEREST_RATE_CHANGED": 
            case "OVERDRAFT_LIMIT_CHANGED": 
            case "WRITE_OFF": {
                return null;
            }
        }
        BLLoggerPlay.warning("Raisin API: Received transaction with unknown transaction type '" + transactionType + "'");
        return null;
    }

    private static String getGvcForTransactionType(String transactionType) {
        switch (transactionType) {
            case "INCOMING_PAYMENT": 
            case "INCOMING_INTERNAL_TRANSFER": 
            case "OUTGOING_PAYMENT": 
            case "OUTGOING_INTERNAL_TRANSFER": {
                return "201";
            }
            case "FEE_APPLIED": {
                return "807";
            }
            case "FEE_APPLIED_CANCELLATION": 
            case "FEES_DUE_REDUCED_CANCELLATION": 
            case "INCOMING_INTERNAL_TRANSFER_CANCELLATION": 
            case "INCOMING_PAYMENT_CANCELLATION": 
            case "INTEREST_APPLIED_CANCELLATION": 
            case "LOAN_REPAID_CANCELLATION": 
            case "OUTGOING_INTERNAL_TRANSFER_CANCELLATION": 
            case "OUTGOING_PAYMENT_CANCELLATION": 
            case "WITHHOLDING_TAX_CANCELLATION": 
            case "WRITE_OFF_CANCELLATION": {
                return "399";
            }
            case "FEES_DUE_REDUCED": 
            case "INTEREST_RATE_CHANGED": 
            case "LOAN_REPAID": 
            case "MIGRATION": 
            case "OTHER": 
            case "OVERDRAFT_INTEREST_RATE_CHANGED": 
            case "OVERDRAFT_LIMIT_CHANGED": 
            case "WRITE_OFF": 
            case "INTEREST_APPLIED": 
            case "WITHHOLDING_TAX": {
                return null;
            }
        }
        BLLoggerPlay.warning("Raisin API: Received transaction with unknown transaction type '" + transactionType + "'");
        return null;
    }

    private static String getIbanOrAccountNumber(Account account) {
        return account.getIban() != null && !account.getIban().isEmpty() ? account.getIban() : account.getNationalAccountNumber();
    }

    private static String getBicOrBankcode(Account account) {
        return account.getBic() != null && !account.getBic().isEmpty() ? account.getBic() : account.getNationalBankCode();
    }

    private static String getOptionalJsonField(JsonNode json, String jsonKey, String defaultValue) {
        if (json.get(jsonKey) != null) {
            return json.get(jsonKey).asText();
        }
        BLLoggerPlay.warning("Raisin API: Could not find JSON field '" + jsonKey + "', using default value '" + defaultValue + "' instead.");
        return defaultValue;
    }

    private static String getMandatoryJsonField(JsonNode json, String jsonKey) throws MandatoryFieldMissingException {
        if (json.get(jsonKey) == null) {
            throw new MandatoryFieldMissingException("Could not find mandatory JSON field '" + jsonKey + "'!");
        }
        return json.get(jsonKey).asText();
    }

    private static BigDecimal getMandatoryJsonDecimal(JsonNode json, String jsonKey) throws MandatoryFieldMissingException {
        BigDecimal result;
        String stringRepresentation = RaisinApiEndpoint.getMandatoryJsonField(json, jsonKey);
        try {
            result = new BigDecimal(stringRepresentation);
        }
        catch (Exception e) {
            throw new MandatoryFieldMissingException("Could not parse String '" + stringRepresentation + "' as BigDecimal! " + e.getMessage());
        }
        return result;
    }

    private static void logError(Exception exception) {
        RaisinApiEndpoint.logError(null, exception);
    }

    public static void logError(String description, Exception exception) {
        description = description == null ? "" : description;
        Object exceptionDescription = "";
        if (exception != null) {
            description = !((String)description).isEmpty() ? (String)description + "\n" : description;
            String stacktrace = "\n\t" + Arrays.stream(exception.getStackTrace()).map(StackTraceElement::toString).reduce((s1, s2) -> s1 + "\n\t" + s2).orElse("");
            exceptionDescription = exception.getMessage() + stacktrace;
        }
        BLLoggerPlay.error(LOGGER_PREFIX + (String)description + (String)exceptionDescription);
    }

    /*
     * Exception decompiling
     */
    public Result processApiEvent(Http.Request request, String event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 22[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String makeApiGetRequestWithRetries(String getUrlPath) throws IOException, InterruptedException {
        HttpGet request = new HttpGet(RaisinApiEndpoint.getRaisinBankUrl() + getUrlPath);
        request.setHeader("x-api-key", RAISIN_API_KEY);
        return RaisinApiEndpoint.makeApiCallWithRetries((HttpUriRequest)request);
    }

    private static String makeApiPostRequestWithRetries(String postUrlPath) throws IOException, InterruptedException {
        HttpPost request = new HttpPost(RaisinApiEndpoint.getRaisinBankUrl() + postUrlPath);
        request.setHeader("x-api-key", RAISIN_API_KEY);
        String idempotencyKey = UUID.randomUUID().toString();
        request.setHeader("idempotency-key", idempotencyKey);
        return RaisinApiEndpoint.makeApiCallWithRetries((HttpUriRequest)request);
    }

    private static String makeApiCallWithRetries(HttpUriRequest request) throws IOException, InterruptedException {
        int currentTry = 1;
        while (currentTry <= API_THROTTLED_MAX_RETRIES) {
            String string;
            block10: {
                CloseableHttpClient client = HttpClients.createDefault();
                try {
                    string = (String)client.execute(request, (ResponseHandler)new RaisinResponseHandler());
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RateLimitReachedException e) {
                        int retryAfterSeconds = API_THROTTLED_DEFAULT_WAIT_TIME_SECONDS;
                        if (e.getRetryAfterSeconds() != null) {
                            retryAfterSeconds = Math.min(API_THROTTLED_MAX_WAIT_TIME_SECONDS, e.getRetryAfterSeconds());
                        }
                        int tryAgainAfterMillis = 1000 * retryAfterSeconds;
                        BLLoggerPlay.warning("Raisin API: Rate limit reached for API call " + String.valueOf(request.getURI()) + ", trying again after " + tryAgainAfterMillis + " milliseconds.\n" + e.getMessage());
                        Thread.sleep(tryAgainAfterMillis);
                        ++currentTry;
                    }
                }
                client.close();
            }
            return string;
        }
        throw new IOException("Tried " + API_THROTTLED_MAX_RETRIES + " times to execute API call " + String.valueOf(request.getURI()) + ", giving up ...");
    }

    static {
        UTC_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected static class MandatoryFieldMissingException
    extends Exception {
        private final String message;

        public MandatoryFieldMissingException(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    protected static class RaisinResponseHandler
    extends BasicResponseHandler {
        protected RaisinResponseHandler() {
        }

        public String handleResponse(HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 300) {
                Object errorCode = "";
                Object message = "";
                Object details2 = "";
                try {
                    String jsonResultString = EntityUtils.toString((HttpEntity)entity);
                    JsonNode jsonResult = Json.parse((String)jsonResultString);
                    if (jsonResult.has("code") && !jsonResult.get("code").asText().isEmpty()) {
                        errorCode = ", code: " + jsonResult.get("code").asText();
                    }
                    if (jsonResult.has("message") && !jsonResult.get("message").asText().isEmpty()) {
                        message = ", message: " + jsonResult.get("message").asText();
                    }
                    if (jsonResult.has("details") && !jsonResult.get("details").asText().isEmpty()) {
                        details2 = ", details: " + jsonResult.get("details").asText();
                    }
                }
                catch (Exception jsonResultString) {
                    // empty catch block
                }
                if (statusCode == 429) {
                    StringBuilder retryAfterMessage = new StringBuilder();
                    Integer retryAfterSeconds = null;
                    for (Header header : response.getHeaders("Retry-After")) {
                        if (retryAfterMessage.length() == 0) {
                            retryAfterMessage.append("Retry-After:");
                        }
                        String retryAfterValue = header.getValue();
                        retryAfterMessage.append(" ").append(retryAfterValue);
                        try {
                            retryAfterSeconds = Integer.parseInt(retryAfterValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    throw new RateLimitReachedException(statusLine.getStatusCode(), statusLine.getReasonPhrase() + (String)errorCode + (String)message + (String)details2 + String.valueOf(retryAfterMessage), retryAfterSeconds);
                }
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase() + (String)errorCode + (String)message + (String)details2);
            }
            return entity == null ? null : this.handleEntity(entity);
        }
    }

    protected static class RateLimitReachedException
    extends HttpResponseException {
        private final Integer retryAfterSeconds;

        public RateLimitReachedException(int statusCode, String reasonPhrase, Integer retryAfterSeconds) {
            super(statusCode, reasonPhrase);
            this.retryAfterSeconds = retryAfterSeconds;
        }

        public Integer getRetryAfterSeconds() {
            return this.retryAfterSeconds;
        }
    }
}

