/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding.geva;

import controllers.branding.geva.GevaEbicsUser;
import controllers.util.BLLoggerPlay;
import controllers.util.PasswordKeyEncryptionHandler;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.ebics.schema.response.EbicsException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import models.GevaSetupForm;
import play.Environment;

public class GevaEbicsUserLoader {
    private static GevaEbicsUserLoader instance;
    private byte[] encryptionKey;
    private GevaEbicsUser user = null;
    ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor();

    public static GevaEbicsUserLoader getInstance() {
        if (instance == null) {
            instance = new GevaEbicsUserLoader();
        }
        return instance;
    }

    private GevaEbicsUserLoader() {
    }

    public void initialize(GevaSetupForm form, Environment environment, License license2) throws GeneralSecurityException, IOException, URISyntaxException, EbicsException {
        this.user = new GevaEbicsUser(form, environment.getFile("geva.properties"), license2, this.getEncryptionKey());
        this.user.initialize(environment.getFile("geva.pdf"));
    }

    public void start(Environment environment) throws IOException, URISyntaxException, EbicsException, GeneralSecurityException {
        if (this.user == null) {
            this.user = new GevaEbicsUser(environment.getFile("geva.properties"), this.getEncryptionKey());
        }
        this.user.loadData();
    }

    public boolean isSetupComplete(Environment environment) {
        File configFile;
        if (this.user == null && (configFile = environment.getFile("geva.properties")).isFile()) {
            try {
                this.user = new GevaEbicsUser(configFile, this.getEncryptionKey());
            }
            catch (IOException | URISyntaxException | GeneralSecurityException io) {
                BLLoggerPlay.error("Error reading geva.properties.", io);
            }
        }
        if (this.user != null && SetupState.DONE.equals((Object)this.user.getState())) {
            this.threadPool.scheduleWithFixedDelay(this.user, 0L, this.user.getRefreshInterval(), TimeUnit.MINUTES);
            return true;
        }
        return false;
    }

    public SetupState getDoneState() {
        if (this.user == null) {
            return SetupState.START;
        }
        return this.user.getState();
    }

    private byte[] getEncryptionKey() {
        if (this.encryptionKey == null) {
            try {
                ApplicationInfo info = ApplicationInfo.findByKey((ApplicationInfo.PropKey)ApplicationInfo.PropKey.DATA_ENC_KEY);
                EncryptData data = info == null ? EncryptData.createEncryptionKey() : EncryptData.getInstance();
                this.encryptionKey = data.copyKey((EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler("changeit".toCharArray()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.encryptionKey;
    }

    public static enum SetupState {
        START,
        INITIALIZED,
        DONE;

    }
}

