/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding.geva;

import controllers.Setup;
import controllers.branding.geva.GevaEbicsUserLoader;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.RSAPublicKey;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.bcs.appetizer.HIALetter;
import de.businesslogics.ebics.client.EbicsBank;
import de.businesslogics.ebics.client.EbicsHttpEngine;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.ebics.client.EbicsPartner;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.EbicsUser;
import de.businesslogics.ebics.client.FileTransfer;
import de.businesslogics.ebics.client.KeyManagement;
import de.businesslogics.ebics.schema.orders.HPDResponseOrderData;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.InvalidOrderDataFormatException;
import de.businesslogics.ebics.schema.types.AuthenticationPubKeyInfo;
import de.businesslogics.ebics.schema.types.AuthenticationVersion;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyInfo;
import de.businesslogics.ebics.schema.types.EncryptionVersion;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.A006PrivateKey;
import de.businesslogics.zkasecurity.E002PrivateKey;
import de.businesslogics.zkasecurity.X002PrivateKey;
import io.ebean.Transaction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import models.GevaSetupForm;

class GevaEbicsUser
implements EbicsUser,
EbicsPartner,
EbicsBank,
Runnable {
    private static final List<String> ORDER_TYPES_FOR_UPLOAD = Arrays.asList("CCT", "CDD", "AZV", "CCU");
    private static final String DIRECTORY_PATH = System.getProperty("bl.geva.exportpath", "/srv/TRANSFER/interface/tmp");
    private final URL url;
    private final String hostId;
    private final String customerId;
    private final String userId;
    private final String orderType;
    private final int refreshInterval;
    private final File configFile;
    private final A006PrivateKey a006PrivateKey;
    private final E002PrivateKey e002PrivateKey;
    private final X002PrivateKey x002PrivateKey;
    private java.security.interfaces.RSAPublicKey encryptionKeyBank;
    private RSAPublicKey encryptionKeyBankVO;
    private java.security.interfaces.RSAPublicKey authenticationKeyBank;
    private RSAPublicKey authenticationKeyBankVO;
    private final byte[] encryptionKey;
    private final License license;
    private GevaEbicsUserLoader.SetupState setupState = GevaEbicsUserLoader.SetupState.START;

    GevaEbicsUser(GevaSetupForm form, File configFile, License license2, byte[] encryptionKey) throws GeneralSecurityException, IOException, URISyntaxException {
        this.a006PrivateKey = new A006PrivateKey(2048, null);
        this.e002PrivateKey = new E002PrivateKey(form.userId, (SecureRandom)null);
        this.x002PrivateKey = new X002PrivateKey(form.userId, (SecureRandom)null);
        this.url = new URI(form.url).toURL();
        this.hostId = form.hostId;
        this.customerId = form.customerId;
        this.userId = form.userId;
        this.orderType = form.orderType;
        this.refreshInterval = form.refreshInterval;
        this.configFile = configFile;
        this.license = license2;
        this.encryptionKey = encryptionKey;
    }

    public GevaEbicsUser(File configFile, byte[] encryptionKey) throws IOException, GeneralSecurityException, URISyntaxException {
        this.configFile = configFile;
        Properties properties = new Properties();
        properties.load(Files.newInputStream(configFile.toPath(), new OpenOption[0]));
        this.url = new URI(properties.getProperty("URL")).toURL();
        this.hostId = properties.getProperty("HOST_ID");
        this.customerId = properties.getProperty("CUSTOMER_ID");
        this.userId = properties.getProperty("USER_ID");
        this.a006PrivateKey = A006PrivateKey.fromPKCS((byte[])HexTool.fromHex((String)properties.getProperty("A006")), null);
        this.e002PrivateKey = E002PrivateKey.fromPKCS((byte[])HexTool.fromHex((String)properties.getProperty("E002")), (String)this.userId, null);
        this.x002PrivateKey = X002PrivateKey.fromPKCS((byte[])HexTool.fromHex((String)properties.getProperty("X002")), (String)this.userId, null);
        if (properties.getProperty("BANK_ENCRYPTION_KEY") != null) {
            this.encryptionKeyBankVO = (RSAPublicKey)DB.find(RSAPublicKey.class, (Object)Long.valueOf(properties.getProperty("BANK_ENCRYPTION_KEY")));
            if (this.encryptionKeyBankVO != null) {
                this.encryptionKeyBank = Provider.buildKey((byte[])this.encryptionKeyBankVO.getModulo(), (byte[])this.encryptionKeyBankVO.getExponent());
            }
        }
        if (properties.getProperty("BANK_AUTHENTICATION_KEY") != null) {
            this.authenticationKeyBankVO = (RSAPublicKey)DB.find(RSAPublicKey.class, (Object)Long.valueOf(properties.getProperty("BANK_AUTHENTICATION_KEY")));
            if (this.authenticationKeyBankVO != null) {
                this.authenticationKeyBank = Provider.buildKey((byte[])this.authenticationKeyBankVO.getModulo(), (byte[])this.authenticationKeyBankVO.getExponent());
            }
        }
        this.orderType = properties.getProperty("ORDER_TYPE");
        this.refreshInterval = Integer.parseInt(properties.getProperty("REFRESH_INTERVAL"));
        this.setupState = GevaEbicsUserLoader.SetupState.valueOf(properties.getProperty("STATE"));
        this.license = License.findById((String)properties.getProperty("LICENSE"));
        this.encryptionKey = encryptionKey;
    }

    public void loadData() throws IOException, EbicsException {
        EbicsHttpEngineImpl ebicsHttpEngine = new EbicsHttpEngineImpl();
        EbicsSession s = new EbicsSession((EbicsUser)this, (EbicsHttpEngine)ebicsHttpEngine);
        FileTransfer ft = new FileTransfer(s);
        ByteArrayOutputStream memory = new ByteArrayOutputStream();
        ft.fetchFile(new OrderType(this.orderType), null, null, (OutputStream)memory);
        HashMap<String, String> customerNames = new HashMap<String, String>();
        HashMap<String, Set> allUsers = new HashMap<String, Set>();
        Scanner scanner = new Scanner(new ByteArrayInputStream(memory.toByteArray()));
        while (scanner.hasNext()) {
            String[] blocks = scanner.nextLine().split(";");
            String customerId = blocks[0];
            String customerName = blocks[1];
            customerNames.put(customerId, customerName);
            String userId = blocks[2];
            Set users2 = allUsers.computeIfAbsent(customerId, k -> new HashSet());
            users2.add(userId);
        }
        scanner.close();
        try (Transaction t = DB.beginTransaction();){
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_CHANGE_IN_DAYS, 0);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_CHECK_HISTORY, 12);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_MIN_LENGTH, 10);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_LETTER, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_LOWER, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_NUMBER, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_SPECIAL, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_UPPER, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_UP, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED_AGE, 180);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED_UNIT, 0);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED_AGE, 180);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED_UNIT, 0);
            preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, null);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_UP, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_FILES, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_AGE, 180);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_UNIT, 0);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_FILES, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_AGE, 180);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_UNIT, 0);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_FILES, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_AGE, 180);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_UNIT, 0);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL, true);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL_AGE, 180);
            preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL_UNIT, 0);
            List allTenants = Tenant.getAllTenants();
            HashSet<Tenant> done = new HashSet<Tenant>();
            for (String customerId : allUsers.keySet()) {
                Tenant found = null;
                BankSettings bank = null;
                String name = customerId + " - " + (String)customerNames.get(customerId);
                for (Tenant tenant : allTenants) {
                    if (!tenant.getName().startsWith(customerId + " - ")) continue;
                    found = tenant;
                    List banks2 = BankSettings.findByCustomer((String)this.url.toExternalForm(), (String)this.hostId, (String)customerId, (Tenant)found);
                    if (banks2 != null && !banks2.isEmpty()) {
                        bank = (BankSettings)banks2.getFirst();
                    }
                    if (name.equals(found.getName())) break;
                    found.setName(name);
                    found.save();
                    break;
                }
                if (found == null) {
                    found = new Tenant();
                    found.setName(name);
                    found.save();
                }
                if (bank == null) {
                    bank = new BankSettings();
                    bank.setCountryCode("DE");
                    bank.setCustomerId(customerId);
                    bank.setDisplayName(name);
                    bank.setHostId(this.hostId);
                    bank.setProtocolVersion(ProtocolVersion.H004.getValue());
                    bank.setTenant(found);
                    bank.setTransferSystem(false);
                    bank.setUrl(this.url.toExternalForm());
                    bank.setE002Key(this.encryptionKeyBankVO);
                    bank.setX002Key(this.authenticationKeyBankVO);
                    bank.save();
                    for (String string : ORDER_TYPES_FOR_UPLOAD) {
                        this.createDirectoryScanner(bank, string);
                    }
                } else {
                    if (!name.equals(bank.getDisplayName())) {
                        bank.setDisplayName(name);
                        bank.save();
                    }
                    List list = DirectoryScanner.findForBank((BankSettings)bank);
                    block9: for (String orderType2 : ORDER_TYPES_FOR_UPLOAD) {
                        for (Object directoryScanner : list) {
                            if (!directoryScanner.getOrderOrFileType().equals(orderType2)) continue;
                            continue block9;
                        }
                        this.createDirectoryScanner(bank, orderType2);
                    }
                }
                done.add(found);
                List users3 = User.getAllForTenants(Collections.singletonList(found), (boolean)true);
                HashSet<User> hashSet = new HashSet<User>();
                block11: for (String userId : (Set)allUsers.get(customerId)) {
                    Object directoryScanner;
                    directoryScanner = users3.iterator();
                    while (directoryScanner.hasNext()) {
                        User user = (User)directoryScanner.next();
                        if (!user.getName().equals(userId)) continue;
                        hashSet.add(user);
                        this.doUserSettings(user);
                        continue block11;
                    }
                    User user = new User();
                    user.setName(userId);
                    user.setTenants(Collections.singletonList(found));
                    user.setEncryptionKey(this.encryptionKey);
                    user.setAdmin(false);
                    user.setWebLicense(this.license);
                    user.save();
                    BankUser bankUser = new BankUser();
                    bankUser.setBank(bank);
                    bankUser.setDefaultUser(userId);
                    bankUser.setState(BankUser.UserState.NOT_USED);
                    bankUser.setUser(user);
                    bankUser.setAuthKeyLength(2048);
                    bankUser.setEncrKeyLength(2048);
                    bankUser.setSigKeyLength(2048);
                    bankUser.setSignatureVersion(SignatureVersion.A006.getValue());
                    bankUser.setWithCerts(false);
                    bankUser.save();
                    this.doUserSettings(user);
                }
                users3.removeAll(hashSet);
                for (User user : users3) {
                    user.delete(Setup.DELETE_USER_NAME);
                }
            }
            allTenants.removeAll(done);
            for (User user : User.getAllForTenants((Collection)allTenants, (boolean)true)) {
                user.delete(Setup.DELETE_USER_NAME);
            }
            t.commit();
        }
        BLLoggerPlay.info("Synchronized " + customerNames.size() + " customers with the EBICS server.");
        if (this.setupState.equals((Object)GevaEbicsUserLoader.SetupState.INITIALIZED)) {
            Properties p = new Properties();
            p.load(Files.newInputStream(this.configFile.toPath(), new OpenOption[0]));
            p.setProperty("STATE", GevaEbicsUserLoader.SetupState.DONE.name());
            p.store(Files.newOutputStream(this.configFile.toPath(), new OpenOption[0]), null);
            this.setupState = GevaEbicsUserLoader.SetupState.DONE;
        }
    }

    private void createDirectoryScanner(BankSettings bank, String orderType) throws IOException {
        String suffix = "/" + bank.getBankId() + "/" + orderType;
        DirectoryScanner s = new DirectoryScanner();
        s.setBank(bank);
        s.setDirectory(DIRECTORY_PATH + suffix);
        s.setOrderOrFileType(orderType);
        s.setRegEx("*");
        File dir = new File(s.getDirectory());
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Can not create directory: " + s.getDirectory());
        }
        DB.save((Object)s);
    }

    private void doUserSettings(User user) {
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.ALLOW_AWV_RECORDING, false);
        preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS, false);
        preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.ALLOW_SETTINGS, false);
        preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.SALARY_PERMISSIONS, PreferenceConstants.SALARY_PERMISSION.FULL.toString());
        preferenceStore.setValue((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_SHOW_SIGNATURES, true);
        preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.NEW_PAGE_ON_PRINT, false);
    }

    public void initialize(File iniFile) throws IOException, EbicsException {
        EbicsHttpEngineImpl ebicsHttpEngine = new EbicsHttpEngineImpl();
        EbicsSession session = new EbicsSession((EbicsUser)this, (EbicsHttpEngine)ebicsHttpEngine);
        KeyManagement km = new KeyManagement(session);
        km.sendINI(this.getSignatureVersion(), this.a006PrivateKey.getPublicKey(), null);
        km.sendHIA(this.getEncrPubKey(), null, this.x002PrivateKey.getPublicKey(), null);
        Properties p = new Properties();
        p.setProperty("URL", this.getURL().toExternalForm());
        p.setProperty("HOST_ID", this.getHostId());
        p.setProperty("CUSTOMER_ID", this.getPartnerID());
        p.setProperty("USER_ID", this.getUserID());
        p.setProperty("A006", HexTool.toHex((byte[])this.a006PrivateKey.toPKCS(null)));
        p.setProperty("E002", HexTool.toHex((byte[])this.e002PrivateKey.toPKCS(null)));
        p.setProperty("X002", HexTool.toHex((byte[])this.x002PrivateKey.toPKCS(null)));
        p.setProperty("ORDER_TYPE", this.orderType);
        p.setProperty("REFRESH_INTERVAL", String.valueOf(this.refreshInterval));
        p.setProperty("STATE", GevaEbicsUserLoader.SetupState.INITIALIZED.name());
        p.setProperty("LICENSE", this.license.getId());
        p.store(Files.newOutputStream(this.configFile.toPath(), new OpenOption[0]), null);
        this.setupState = GevaEbicsUserLoader.SetupState.INITIALIZED;
        HIALetter.printINIandHIA((OutputStream)Files.newOutputStream(iniFile.toPath(), new OpenOption[0]), (String)"GEVA Sync", (String)this.getHostId(), (String)this.getPartnerID(), (String)this.getUserID(), (String)this.getSignatureVersion().getValue(), (java.security.interfaces.RSAPublicKey)this.a006PrivateKey.getPublicKey(), (EncryptionVersion)EncryptionVersion.E002, (java.security.interfaces.RSAPublicKey)this.getEncrPubKey(), (AuthenticationVersion)AuthenticationVersion.X002, (java.security.interfaces.RSAPublicKey)this.x002PrivateKey.getPublicKey(), (Date)new Date(), (Locale)Locale.GERMAN);
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public GevaEbicsUserLoader.SetupState getState() {
        return this.setupState;
    }

    public EbicsPartner getPartner() {
        return this;
    }

    public byte[] authenticate(byte[] bytes) {
        return this.x002PrivateKey.authenticate(bytes);
    }

    public byte[] decrypt(byte[] bytes) throws IllegalBlockSizeException, BadPaddingException {
        return this.e002PrivateKey.decrypt(bytes);
    }

    public java.security.interfaces.RSAPublicKey getEncrPubKey() {
        return this.e002PrivateKey.getPublicKey();
    }

    public String getUserID() {
        return this.userId;
    }

    public EbicsBank getBank() {
        return this;
    }

    public String getPartnerID() {
        return this.customerId;
    }

    public String nextOrderID(String s) {
        return null;
    }

    public String getSecurityMedium() {
        return null;
    }

    public SignatureVersion getSignatureVersion() {
        return SignatureVersion.A006;
    }

    public byte[] sign(byte[] bytes, String s, Date date2, String s1) {
        return this.a006PrivateKey.sign(bytes, null);
    }

    public URL getURL() {
        return this.url;
    }

    public ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.H004;
    }

    public java.security.interfaces.RSAPublicKey getEncrKey(ProtocolVersion protocolVersion) {
        return this.encryptionKeyBank;
    }

    public java.security.interfaces.RSAPublicKey getAuthKey(ProtocolVersion protocolVersion) {
        return this.authenticationKeyBank;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setBankKeys(ProtocolVersion protocolVersion, EncryptionPubKeyInfo encryptionPubKeyInfo, byte[] bytes, AuthenticationPubKeyInfo authenticationPubKeyInfo, byte[] bytes1) throws InvalidOrderDataFormatException {
        this.encryptionKeyBank = encryptionPubKeyInfo.getPublicKey();
        this.encryptionKeyBankVO = new RSAPublicKey();
        this.encryptionKeyBankVO.setModulo(encryptionPubKeyInfo.getPublicKey().getModulus().toByteArray());
        this.encryptionKeyBankVO.setExponent(encryptionPubKeyInfo.getPublicKey().getPublicExponent().toByteArray());
        this.encryptionKeyBankVO.save();
        this.authenticationKeyBank = authenticationPubKeyInfo.getPublicKey();
        this.authenticationKeyBankVO = new RSAPublicKey();
        this.authenticationKeyBankVO.setModulo(authenticationPubKeyInfo.getPublicKey().getModulus().toByteArray());
        this.authenticationKeyBankVO.setExponent(authenticationPubKeyInfo.getPublicKey().getPublicExponent().toByteArray());
        this.authenticationKeyBankVO.save();
        Properties p = new Properties();
        try {
            p.load(Files.newInputStream(this.configFile.toPath(), new OpenOption[0]));
            p.setProperty("BANK_AUTHENTICATION_KEY", this.authenticationKeyBankVO.getKeyId().toString());
            p.setProperty("BANK_ENCRYPTION_KEY", this.encryptionKeyBankVO.getKeyId().toString());
            p.store(Files.newOutputStream(this.configFile.toPath(), new OpenOption[0]), null);
        }
        catch (IOException e) {
            BLLoggerPlay.error("Error saving the geva.properties file", e);
        }
    }

    public void setBankParameters(Date date2, HPDResponseOrderData hpdResponseOrderData) {
    }

    public Date getTimestampBankParameters() {
        return null;
    }

    public HPDResponseOrderData getBankParameters() {
        return null;
    }

    @Override
    public void run() {
        try {
            this.loadData();
        }
        catch (Exception e) {
            BLLoggerPlay.error("Error fetching user-list from Sync-Server", e);
        }
    }
}

