/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding;

import controllers.branding.Branding;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.ebics.schema.types.ProtocolVersion;

class VwfsBranding
extends Branding {
    private String EBICS_SERVER_URL = "https://ebics.volkswagenbank.de/ebics";
    private final String HOST_ID = "VWBANK";

    public VwfsBranding() {
        CMBank.setGermanDefaultStatementFormat((CMBank.StatementFormat)CMBank.StatementFormat.MT940);
    }

    @Override
    public boolean doTenantsWithBank() {
        return true;
    }

    @Override
    public boolean showUserTableForOneBankAtStartpage() {
        return true;
    }

    @Override
    public String getUrl() {
        return this.EBICS_SERVER_URL;
    }

    @Override
    public String getHostId() {
        return "VWBANK";
    }

    @Override
    public void fillBankData(BankSettings bank) {
        bank.setDisplayName("Volkswagenbank");
        bank.setIcon("vwbank.ico");
        bank.setUrl(this.getUrl());
        bank.setHostId(this.getHostId());
        bank.setProtocolVersion(ProtocolVersion.H004.getValue());
    }

    @Override
    public boolean hideHashesForBankInTenant() {
        return true;
    }

    @Override
    public boolean useBankAdminRoles() {
        return true;
    }

    @Override
    public void setEbicsServerUrl(String url) {
        this.EBICS_SERVER_URL = url;
    }
}

