/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding;

import controllers.BalanceLists;
import controllers.branding.Branding;
import controllers.branding.TenantFromExcel;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.bcs.appetizer.HIALetter;
import de.businesslogics.bcs.appetizer.INILetter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.io.Streams;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import models.LoginForm;
import play.data.Form;
import play.i18n.Messages;
import play.mvc.Http;
import play.twirl.api.Html;
import views.html.branding.santanderLogin;
import views.html.branding.santanderlogo;

class SantanderBranding
extends Branding {
    private String EBICS_SERVER_URL = "https://ebics.santanderbank.de/ebics";
    private final String HOST_ID = "SANEBICS";

    public SantanderBranding() {
        PreferenceConstants.DISPLAY_PAYMENT_AS_SINGLE_BOOKING.setDefaultValue("true");
        BalanceLists.DEFAULT_DATE_COUNT = 3;
        try {
            InputStream is = SantanderBranding.class.getClassLoader().getResourceAsStream("public/images/santander.png");
            byte[] santanderPng = Streams.readAllAndClose((InputStream)is);
            INILetter.IMAGE = santanderPng;
            HIALetter.IMAGE = santanderPng;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CMBank.setGermanDefaultStatementFormat((CMBank.StatementFormat)CMBank.StatementFormat.MT940);
    }

    @Override
    public boolean doTenantsWithBank() {
        return true;
    }

    @Override
    public boolean showUserTableForOneBankAtStartpage() {
        return true;
    }

    @Override
    public String getUrl() {
        return this.EBICS_SERVER_URL;
    }

    @Override
    public String getHostId() {
        return "SANEBICS";
    }

    @Override
    public void fillBankData(BankSettings bank) {
        bank.setDisplayName("Santander");
        bank.setIcon("santander.ico");
        bank.setUrl(this.getUrl());
        bank.setHostId(this.getHostId());
        bank.setProtocolVersion(ProtocolVersion.H004.getValue());
    }

    @Override
    public boolean hideHashesForBankInTenant() {
        return true;
    }

    @Override
    public boolean hidePDFStatements() {
        return true;
    }

    @Override
    public List<String> getBootstrapCSS() {
        return Collections.singletonList("santander/bootstrap.css");
    }

    @Override
    public List<String> getBrandingCSS() {
        return Collections.singletonList("santander/santander.css");
    }

    @Override
    public boolean hasLoginBranding() {
        return true;
    }

    @Override
    public Html getLoginBranding(Form<LoginForm> loginForm, Http.Request request, Messages messages) {
        return santanderLogin.render(loginForm, request, messages);
    }

    @Override
    public boolean showCreatedByBLText() {
        return false;
    }

    @Override
    public boolean showTenantMaxUserCount() {
        return false;
    }

    @Override
    public Optional<Html> getLogoHtmlForNavbar() {
        return Optional.of(santanderlogo.render());
    }

    @Override
    public boolean hideMastheadOnLoginAndLogoff() {
        return true;
    }

    @Override
    public boolean hideMastheadOnIndex() {
        return true;
    }

    @Override
    public boolean setLocalUserAsDefault() {
        return true;
    }

    @Override
    public boolean showCustomerColumnInFetchSchedulesTables() {
        return true;
    }

    @Override
    public boolean useBankAdminRoles() {
        return true;
    }

    @Override
    public TenantFromExcel getTenantFromExcel() {
        TenantFromExcel t = new TenantFromExcel();
        t.tenantNameColumn = 1;
        t.tenantNameRow = 3;
        t.customerIdColumn = 4;
        t.customerIdRow = 12;
        t.userStartingRow = 12;
        t.userIdColumn = 5;
        t.loginNameColumn = 6;
        return t;
    }

    @Override
    public void setEbicsServerUrl(String url) {
        this.EBICS_SERVER_URL = url;
    }
}

