/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding;

import controllers.Setup;
import controllers.branding.Branding;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.bcs.appetizer.HIALetter;
import de.businesslogics.bcs.appetizer.INILetter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.io.Streams;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import play.i18n.Messages;
import play.twirl.api.Html;
import views.html.branding.kdbanklogo;
import views.html.branding.kdbankmasthead;

public class KDBankBranding
extends Branding {
    private static final String URL = "https://ebics.multivia-suite.de/ebicsweb/ebicsweb";
    private static final String HOSTID = "MULTIVIA";
    private static final String NAME = "KD-Bank";
    private static final String BANKICON = "kdbank.ico";
    private static final String CONTACT_TARGET = "https://www.kd-bank.de/kd-bankingweb-hilfe";
    private static final String REMOTE_SUPPORT_TARGET = "https://brs022.gad.de/";

    public KDBankBranding() {
        Setup.DISPLAY_NAME = "KD Banking Web";
        Setup.APPLE_TOUCH_ICON = "images/kdbank-apple-touch-icon-180px.png";
        Setup.FAVICON_PNG = "images/kdbank-favicon-32px.png";
        Setup.FAVICON_ICO = "images/kdbank-favicon-48px.ico";
        Setup.MSTILE = "images/kdbank-mstile-144px.png";
        try {
            InputStream is = KDBankBranding.class.getClassLoader().getResourceAsStream("public/images/kdbank-print-header.png");
            byte[] kdBankPng = Streams.readAllAndClose((InputStream)is);
            INILetter.IMAGE = kdBankPng;
            HIALetter.IMAGE = kdBankPng;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Setup.REMOTESUPPORT_URL = REMOTE_SUPPORT_TARGET;
        System.setProperty("de.businesslogics.iniletter.url", CONTACT_TARGET);
    }

    @Override
    public boolean alwaysPrintLogo() {
        return true;
    }

    @Override
    public List<String> getBootstrapCSS() {
        return Collections.singletonList("kdbank/bootstrap.css");
    }

    @Override
    public List<String> getBrandingCSS() {
        return Collections.singletonList("kdbank/kd_bank.css");
    }

    @Override
    public Optional<Html> getLogoHtmlForNavbar() {
        return Optional.of(kdbanklogo.render());
    }

    @Override
    public String getNavbarColorClass(String navbarId) {
        if ("top-navbar".equals(navbarId)) {
            return "kdbank-navbar";
        }
        return super.getNavbarColorClass(navbarId);
    }

    @Override
    public String getLogoffButtonClass() {
        return "btn-secondary";
    }

    @Override
    public String getFirstLoginMessage() {
        return "kdbank.login.done.first";
    }

    @Override
    public String getLoginMessage() {
        return "kdbank.login.done";
    }

    @Override
    public boolean hideUpdateAvailableBanner() {
        return true;
    }

    @Override
    public boolean hideSendDirectories() {
        return true;
    }

    @Override
    public boolean doTenantsWithBank() {
        return true;
    }

    @Override
    public boolean showUserTableForOneBankAtStartpage() {
        return true;
    }

    @Override
    public void fillBankData(BankSettings bank) {
        bank.setDisplayName(NAME);
        bank.setIcon(BANKICON);
        bank.setUrl(URL);
        bank.setHostId(HOSTID);
        bank.setProtocolVersion(ProtocolVersion.H005.getValue());
        bank.setCountryCode(this.getCountryCode());
    }

    @Override
    protected Optional<String> getDefaultRemoteSupportURL() {
        return Optional.of(REMOTE_SUPPORT_TARGET);
    }

    @Override
    public Optional<Html> getMasthead(Messages messages) {
        return Optional.of(kdbankmasthead.render(messages));
    }

    @Override
    public boolean showSendLogsMenu() {
        return false;
    }

    @Override
    public String getOnlineHelpLabel() {
        return "main.display.handbook";
    }

    @Override
    public String getRemoteSupportLabel() {
        return "kdbank.remotesupport";
    }

    @Override
    public String getHostId() {
        return HOSTID;
    }

    @Override
    public String getDefaultBankIcon() {
        return BANKICON;
    }

    @Override
    public boolean showTenantMaxUserCount() {
        return false;
    }

    @Override
    public Optional<List<PaymentTransferType.PmtType>> excludedPaymentTypes() {
        List result = super.excludedPaymentTypes().orElse(new ArrayList());
        result.add(PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN);
        result.add(PaymentTransferType.PmtType.MT101_TRANSFER);
        result.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE);
        return Optional.of(result);
    }

    @Override
    public boolean hasContactButton() {
        return true;
    }

    @Override
    public String getContactButtonLabel() {
        return "kdbank.contact";
    }

    @Override
    public String getContactButtonLink() {
        return CONTACT_TARGET;
    }

    @Override
    public String getCmNavbarLabel(Messages messages) {
        return messages.at("kdbank.cmHeader", new Object[0]);
    }

    @Override
    public String getRecipientsLabel(Messages messages) {
        return messages.at("kdbank.recipientsLabel", new Object[0]);
    }

    @Override
    public String getNewRecipientLabel(Messages messages) {
        return messages.at("kdbank.newRecipientLabel", new Object[0]);
    }

    @Override
    public String getRecipientsFilterLabel(Messages messages) {
        return messages.at("kdbank.recipientsFilterLabel", new Object[0]);
    }

    @Override
    public String getSepaRecipientLabel(Messages messages) {
        return messages.at("kdbank.recipients.type.sepa", new Object[0]);
    }

    @Override
    public String getSepaMandateLabel(Messages messages) {
        return messages.at("kdbank.recipients.type.mandate", new Object[0]);
    }

    @Override
    public String getEditRecipientTitle(PaymentType paymentType, boolean isNew, Messages messages) {
        if (paymentType == PaymentType.SEPA) {
            if (isNew) {
                return messages.at("kdbank.newRecipient.sepa", new Object[0]);
            }
            return messages.at("kdbank.editRecipient.sepa", new Object[0]);
        }
        if (paymentType == PaymentType.MANDATE) {
            if (isNew) {
                return messages.at("kdbank.newRecipient.mandate", new Object[0]);
            }
            return messages.at("kdbank.editRecipient.mandate", new Object[0]);
        }
        return super.getEditRecipientTitle(paymentType, isNew, messages);
    }

    @Override
    public boolean showAllowInvalidBankConnectionPreference() {
        return false;
    }
}

