/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding;

import controllers.Setup;
import controllers.branding.Branding;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.bcs.appetizer.HIALetter;
import de.businesslogics.bcs.appetizer.INILetter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.io.Streams;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import play.i18n.Messages;
import play.twirl.api.Html;
import views.html.branding.icicilogo;
import views.html.branding.icicimasthead;

class ICICIBranding
extends Branding {
    private static String EBICS_SERVER_URL = "https://cibgermanyuatapp.icicibankltd.com:9444/ebics/EbicsServlet";
    private static final String HOST_ID = "ICICDEFF";

    public ICICIBranding() {
        Setup.DISPLAY_NAME = "ICICI Bank Germany";
        Setup.APPLE_TOUCH_ICON = "images/icici-apple-touch-icon-180px.png";
        Setup.FAVICON_PNG = "images/icici-favicon-32px.png";
        Setup.FAVICON_ICO = "images/icici-favicon-48px.ico";
        Setup.MSTILE = "images/icici-mstile-144px.png";
        try {
            InputStream is = ICICIBranding.class.getClassLoader().getResourceAsStream("public/images/icici-print-header.png");
            byte[] iciciPng = Streams.readAllAndClose((InputStream)is);
            INILetter.IMAGE = iciciPng;
            HIALetter.IMAGE = iciciPng;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.setProperty("de.businesslogics.iniletter.url", "https://www.icicibank.de/");
    }

    @Override
    public boolean doTenantsWithBank() {
        return true;
    }

    @Override
    public boolean showUserTableForOneBankAtStartpage() {
        return true;
    }

    @Override
    public String getUrl() {
        return EBICS_SERVER_URL;
    }

    @Override
    public String getHostId() {
        return HOST_ID;
    }

    @Override
    public void fillBankData(BankSettings bank) {
        bank.setDisplayName("ICICI Bank Germany");
        bank.setIcon("icici.ico");
        bank.setUrl(this.getUrl());
        bank.setHostId(this.getHostId());
        bank.setProtocolVersion(ProtocolVersion.H005.getValue());
        bank.setCountryCode(this.getCountryCode());
    }

    @Override
    public boolean hideHashesForBankInTenant() {
        return true;
    }

    @Override
    public List<String> getBootstrapCSS() {
        return Collections.singletonList("icici/bootstrap.css");
    }

    @Override
    public List<String> getBrandingCSS() {
        return Collections.singletonList("icici/icici.css");
    }

    @Override
    public boolean showCreatedByBLText() {
        return false;
    }

    @Override
    public Optional<Html> getLogoHtmlForNavbar() {
        return Optional.of(icicilogo.render());
    }

    @Override
    public Optional<Html> getMasthead(Messages messages) {
        return Optional.of(icicimasthead.render(messages));
    }

    @Override
    public boolean hideMastheadOnIndex() {
        return true;
    }

    @Override
    public boolean setLocalUserAsDefault() {
        return true;
    }

    @Override
    public boolean showCustomerColumnInFetchSchedulesTables() {
        return true;
    }

    @Override
    public String[] getPrintedStatementFooter() {
        return new String[]{"This is a system-generated statement. Hence, it does not require any signature. This is an authenticated intimation/statement.", "Customers are requested to immediately notify the Bank, in case of any error in the statement."};
    }

    @Override
    public boolean alwaysPrintLogo() {
        return true;
    }

    @Override
    public Optional<List<PaymentTransferType.PmtType>> excludedPaymentTypes() {
        List result = super.excludedPaymentTypes().orElse(new ArrayList());
        result.add(PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN);
        return Optional.of(result);
    }

    @Override
    public boolean allowOnlyCSVForSending(User user) {
        for (BankUser bankUser : BankUser.findBanksForUser((User)user)) {
            BankSettings bank = bankUser.getBank();
            boolean isICICI = bank.getDisplayName().contains("ICICI") || this.getHostId().equals(bank.getHostId()) || this.getUrl().equals(bank.getUrl());
            if (isICICI) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEbicsServerUrl(String url) {
        EBICS_SERVER_URL = url;
    }

    @Override
    public String getDefaultBankIcon() {
        return "icici.ico";
    }
}

