/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding;

import controllers.Setup;
import controllers.branding.GevaBranding;
import de.businesslogics.bcs.appetizer.HIALetter;
import de.businesslogics.bcs.appetizer.INILetter;
import de.businesslogics.io.Streams;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import models.LoginForm;
import play.data.Form;
import play.i18n.Messages;
import play.mvc.Http;
import play.twirl.api.Html;
import views.html.branding.dzBankLogin;
import views.html.branding.gevadzbanklogo;

class GevaDzBankBranding
extends GevaBranding {
    public GevaDzBankBranding() {
        Setup.DISPLAY_NAME = "DZ PRIVATBANK";
        Setup.APPLE_TOUCH_ICON = "images/dzbank-apple-touch-icon-180px.png";
        Setup.FAVICON_PNG = "images/dzbank-favicon-32px.png";
        Setup.FAVICON_ICO = "images/dzbank-favicon-48px.ico";
        Setup.MSTILE = "images/dzbank-mstile-144px.png";
        try {
            InputStream is = GevaDzBankBranding.class.getClassLoader().getResourceAsStream("public/images/dzbank-print-header-ini.png");
            byte[] dzBankPng = Streams.readAllAndClose((InputStream)is);
            INILetter.IMAGE = dzBankPng;
            HIALetter.IMAGE = dzBankPng;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.setProperty("de.businesslogics.iniletter.url", "https://www.dzbank.de");
    }

    @Override
    public boolean alwaysPrintLogo() {
        return true;
    }

    @Override
    public List<String> getBootstrapCSS() {
        return Collections.singletonList("geva_dz_bank/bootstrap.css");
    }

    @Override
    public List<String> getBrandingCSS() {
        return Collections.singletonList("geva_dz_bank/geva_dz_bank.css");
    }

    @Override
    public Optional<Html> getLogoHtmlForNavbar() {
        return Optional.of(gevadzbanklogo.render());
    }

    @Override
    public String getNavbarColorClass(String navbarId) {
        if ("top-navbar".equals(navbarId)) {
            return "dzbank-navbar-light dzbank-bg-light";
        }
        return super.getNavbarColorClass(navbarId);
    }

    @Override
    public String getNavbarQuickButtonsClass() {
        return "dzbank-navbar-add-button";
    }

    @Override
    public String getLogoffButtonClass() {
        return "dzbank-logoff-button";
    }

    @Override
    public String getNavbarHelpButtonClass() {
        return "dzbank-help-button";
    }

    @Override
    public boolean hideBankIconOnLandingPage() {
        return true;
    }

    @Override
    public boolean hasLoginBranding() {
        return true;
    }

    @Override
    public Html getLoginBranding(Form<LoginForm> loginForm, Http.Request request, Messages messages) {
        return dzBankLogin.render(loginForm, request, messages);
    }

    @Override
    public String getFirstLoginMessage() {
        return "dzbank.login.done.first";
    }

    @Override
    public String getLoginMessage() {
        return "dzbank.login.done";
    }

    @Override
    public String getDefaultBankIcon() {
        return "dz_bank.ico";
    }

    @Override
    public String getCustomDashboardIconClass() {
        return "dashboard-icon";
    }

    @Override
    public String getCustomDashboardIconEds() {
        return "images/dzbank_dashboard_eds.png";
    }

    @Override
    public String getCustomDashboardIconPayments() {
        return "images/dzbank_dashboard_payments.png";
    }

    @Override
    public String getCustomDashboardIconStatements() {
        return "images/dzbank_dashboard_statements.png";
    }

    @Override
    public String getCustomDashboardIconTenants() {
        return "images/dzbank_dashboard_tenants.png";
    }

    @Override
    public String getCustomDashboardIconBanks() {
        return "images/dzbank_dashboard_banks.png";
    }

    @Override
    public String getCustomDashboardIconSendFile() {
        return "images/dzbank_dashboard_send_file.png";
    }

    @Override
    public String getCustomDashboardIconFetchFile() {
        return "images/dzbank_dashboard_fetch_file.png";
    }

    @Override
    public boolean hideShareUserKeysButton() {
        return true;
    }

    @Override
    public boolean hideUpdateAvailableBanner() {
        return true;
    }

    @Override
    public String sendLogsButtonLabel(Messages messages) {
        return messages.at("geva.sendtraces", new Object[0]);
    }

    @Override
    public String sendLogsSubmitButtonLabel(Messages messages) {
        return messages.at("geva.sendtraces.submit", new Object[0]);
    }

    @Override
    public boolean isSendLogsCommentMandatory() {
        return true;
    }

    @Override
    public boolean showAllowInvalidBankConnectionPreference() {
        return false;
    }
}

