/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding;

import controllers.Banks;
import controllers.branding.Branding;
import controllers.branding.GevaBranding;
import controllers.branding.geva.GevaEbicsUserLoader;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt101.api.MT101ApiMessages;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.transfer.api.SendOrderHandler;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.format.dta.DTAZVCapitalMessage;
import de.businesslogics.format.dta.DTAZVMessage;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.format.dta.DTAZVTransitMessage;
import de.businesslogics.format.dta.DtazvApi;
import de.businesslogics.format.dta.DtazvFederalState;
import de.businesslogics.format.dta.DtazvFeeType;
import de.businesslogics.format.dta.DtazvInstructionCode;
import de.businesslogics.format.dta.DtazvPaymentType;
import de.businesslogics.format.printer.PaymentPrinterMessages;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import io.ebean.Query;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import models.payments.DtazvPaymentHandler;
import models.payments.Mt101PaymentHandler;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.SepaPaymentHandler;
import play.Environment;
import play.i18n.Messages;
import play.mvc.Call;
import play.mvc.Http;
import scala.Option;

class GevaDaimlerBranding
extends GevaBranding {
    private boolean setupComplete = false;

    GevaDaimlerBranding() {
    }

    @Override
    public List<String> getBootstrapCSS() {
        return Collections.singletonList("geva_daimler/bootstrap.css");
    }

    @Override
    public List<String> getBrandingCSS() {
        return Collections.singletonList("geva_daimler/geva_daimler.css");
    }

    public play.api.mvc.Call doBrandingSetup(Http.Request request) {
        if (GevaEbicsUserLoader.getInstance().getDoneState() == GevaEbicsUserLoader.SetupState.DONE) {
            return null;
        }
        return routes.GevaSetup.index();
    }

    @Override
    public boolean isSetupComplete(Environment environment) {
        if (this.setupComplete) {
            return true;
        }
        if (GevaEbicsUserLoader.getInstance().isSetupComplete(environment)) {
            this.setupComplete = true;
            return true;
        }
        return false;
    }

    @Override
    public Call getNewUserSetup() {
        return routes.GevaSetup.newUser();
    }

    @Override
    public String getOpenPaymentsLabel() {
        return "GeneralMessages.payments";
    }

    @Override
    public boolean showSettingsMenuPref() {
        return true;
    }

    @Override
    public boolean showOrderTypeInTitle() {
        return true;
    }

    @Override
    public String getSignedPaymentStateLabel() {
        return "GeneralMessages.status";
    }

    @Override
    public boolean autofillBICFromIBAN() {
        return true;
    }

    @Override
    public Option<String> getAccountAfterOriginator() {
        return Option.apply((Object)"afterOriginator");
    }

    @Override
    public boolean showUltimateOriginatorAndRecipient() {
        return false;
    }

    @Override
    public boolean showDiscountButton() {
        return false;
    }

    @Override
    public boolean doSEPAThreeLinesPurpose() {
        return true;
    }

    @Override
    public boolean isPurposeMandatory() {
        return true;
    }

    @Override
    public Optional<String> prefillEndToEndId() {
        return Optional.of(this.buildNextEndToEndID());
    }

    private String buildNextEndToEndID() {
        SimpleDateFormat timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-");
        return timeStamp.format(new Date()) + this.createNextRunningNumber();
    }

    private int createNextRunningNumber() {
        SimpleDateFormat dateStamp = new SimpleDateFormat("yyyy-MM-dd");
        int num = 1;
        String date2 = dateStamp.format(new Date());
        ApplicationInfo info = ApplicationInfo.findByKey((ApplicationInfo.PropKey)ApplicationInfo.PropKey.END_TO_END_ID_NUMBER);
        if (info == null) {
            info = ApplicationInfo.createInstance((ApplicationInfo.PropKey)ApplicationInfo.PropKey.END_TO_END_ID_NUMBER, (String)"");
        } else {
            String[] values = info.getPropValue().split(",");
            if (date2.equals(values[0])) {
                num = Integer.parseInt(values[1]) + 1;
            }
        }
        info.setPropValue(date2 + "," + num);
        info.save();
        return num;
    }

    @Override
    public boolean showBatchBookingWarning() {
        return true;
    }

    @Override
    public String originatorLabelForSEPADebit() {
        return "GeneralMessages.originator";
    }

    @Override
    public Optional<String> SEPADebitPaymentCategory() {
        return Optional.of("OTHR");
    }

    @Override
    public Optional<String> SEPADebitPurposeCode() {
        return Optional.of("COLL");
    }

    @Override
    public Optional<List<PaymentTransferType.PmtType>> excludedPaymentTypes() {
        List result = super.excludedPaymentTypes().orElse(new ArrayList());
        result.add(PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT);
        result.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE);
        result.add(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN);
        return Optional.of(result);
    }

    @Override
    public boolean showBatchBookingCheckboxForCDD() {
        return false;
    }

    @Override
    public Option<String> reorderFieldsForDebitPayments() {
        return Option.apply((Object)"reorderInputs");
    }

    @Override
    public boolean hideOneDTAZVPurposeLine() {
        return true;
    }

    @Override
    public boolean hidePaymentImport() {
        return true;
    }

    @Override
    public boolean hideSaveInDes() {
        return true;
    }

    @Override
    public boolean hidePrintInDes() {
        return true;
    }

    @Override
    public boolean hideSaveInSentFiles() {
        return true;
    }

    @Override
    public boolean showCategoryInSendLogs() {
        return true;
    }

    @Override
    public boolean showResetPasswordInSendLogs() {
        return true;
    }

    @Override
    public String getAccountSuffix(Account account) {
        if (account.getAccountHolder() == null || account.getAccountHolder().isEmpty()) {
            return "";
        }
        return " (" + account.getAccountHolder() + ")";
    }

    @Override
    public boolean showHTDReport() {
        return true;
    }

    @Override
    public List<User> getUserForHTDReport(User currentUser) {
        ArrayList<Future<Boolean>> list = new ArrayList<Future<Boolean>>();
        for (BankUser bankUser : BankUser.findActiveBanksForUser((User)currentUser)) {
            list.add(Banks.updateHKD(bankUser, null));
        }
        for (Future future : list) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return User.getAllForTenants((Collection)currentUser.getTenants(), (boolean)true);
    }

    @Override
    public void addToHTDReport(PDFCreator creator, BLDocument document, Messages messages) throws PDFException {
        BLTable table = creator.createTable(3);
        table.setWidths(new int[]{1, 1, 8});
        table.setBorder(BLBorder.NO_BORDER);
        table.addCell(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.yes", (Object[])new Object[0]));
        table.addCell("____");
        table.addCell(messages.at("openpayments.printHTDReport.yes.message", new Object[0]));
        table.addCell(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.no", (Object[])new Object[0]));
        table.addCell("____");
        table.addCell(messages.at("openpayments.printHTDReport.no.message", new Object[0]));
        document.addTable(table);
        table = creator.createTable(1);
        table.setBorder(BLBorder.TOP);
        table.setSpacingBefore(50.0f);
        table.addCell(messages.at("openpayments.printHTDReport.signature", new Object[0]));
        document.addTable(table);
    }

    @Override
    public void setupBlApi() {
        super.setupBlApi();
        SepaApi.messageIdGenerator = (bankUser, orderType) -> {
            String order = orderType != null && orderType.length() > 3 ? orderType.substring(0, 3) : orderType;
            return "GWP-" + bankUser.getBank().getCustomerId() + "-" + bankUser.getDefaultUser() + "-" + order + "-" + String.valueOf(new StringBuilder(String.valueOf(SepaApi.getMsgId((BankUser)bankUser))).reverse());
        };
    }

    @Override
    public boolean hideEdsOverviewImportAsOpenPaymentButton() {
        return true;
    }

    @Override
    public List<DtazvPaymentType> excludedDtazvPaymentTypes() {
        ArrayList<DtazvPaymentType> result = new ArrayList<DtazvPaymentType>();
        for (DtazvPaymentType paymentType : DtazvPaymentType.values()) {
            if (paymentType == DtazvPaymentType.TYPE_00 || paymentType == DtazvPaymentType.TYPE_10 || paymentType == DtazvPaymentType.TYPE_20) continue;
            result.add(paymentType);
        }
        return result;
    }

    @Override
    public Optional<String> SEPACreditPaymentCategory(User user) {
        if (user != null) {
            for (BankSettings bank : BankSettings.findBanksForUser((User)user)) {
                if (!"DGSB0000".equals(bank.getCustomerId())) continue;
                return Optional.of("SUPP");
            }
        }
        return super.SEPACreditPaymentCategory(user);
    }

    @Override
    public Optional<String> SEPACreditPurposeCode(User user) {
        if (user != null) {
            for (BankSettings bank : BankSettings.findBanksForUser((User)user)) {
                if (!"DGSB0000".equals(bank.getCustomerId())) continue;
                return Optional.of("SUPP");
            }
        }
        return super.SEPACreditPurposeCode(user);
    }

    @Override
    public boolean hideUpdateAvailableBanner() {
        return true;
    }

    @Override
    public File printSendReport(Send send, User user, Messages msg) throws IOException {
        File dest = Util.createTempFile((String)(StringUtils.convertToValidFileName((String)send.getBank().getDisplayName()) + "_" + send.getOrderNumber()), (String)".pdf", (boolean)true);
        Locale locale = msg.lang().toLocale();
        try {
            String orderInfo;
            boolean hasOrderName;
            SendOrderHandler handler = new SendOrderHandler(send);
            SendOrderHandler.SendReportPrintHelper helper = Branding.getBranding().getSendReportPrintHelper(handler, user, msg, false);
            FileOutputStream fos = new FileOutputStream(dest);
            BLDocument document = Util.createBLDocument((OutputStream)fos, (BLDocument.PageLayout)BLDocument.PageLayout.A4, (String)BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.sentReport", (Object[])new Object[0]), (boolean)GeneralUtils.printLogo(user), (Locale)locale, (boolean)Util.printLogo((User)user));
            GeneralMessages messages = GeneralMessages.getInstance((Locale)locale);
            String orderName = helper.getOrderName(send, locale);
            String orderNumber = send.getOrderNumber();
            String orderIdentification = Util.getOrderRepresentation((Send)send);
            boolean bl = hasOrderName = orderName != null;
            if (hasOrderName) {
                orderInfo = orderNumber;
            } else {
                orderName = messages.ORDER;
                orderInfo = orderIdentification;
            }
            BankSettings bank = send.getBank();
            String bankName = bank.getDisplayName();
            String title = TransferApiMessages.getString((Locale)locale, (String)"sendorder.print.titleWithOrderName", (Object[])new Object[]{orderName, orderInfo, bankName});
            BLFont font = BLFont.FONT_BIG_BOLD;
            document.addHeadline(title, font, Alignment.ALIGN_CENTER, 10.0f);
            Query query = SignedPayment.getDefaultQuery((User)user, Collections.singletonList(send), (boolean)true, (boolean)false, (boolean)false);
            for (SignedPayment signedPayment : query.findList()) {
                try {
                    PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(signedPayment.getPmtType(), signedPayment.getPaymentData());
                    if (paymentHandler instanceof SepaPaymentHandler) {
                        this.printSepaSendReport((SEPAPaymentData)((SepaPaymentHandler)paymentHandler).getPayment(), signedPayment, document, locale);
                        continue;
                    }
                    if (paymentHandler instanceof Mt101PaymentHandler) {
                        this.printMt101SendReport((MT101PaymentData)((Mt101PaymentHandler)paymentHandler).getPayment(), signedPayment, document, locale);
                        continue;
                    }
                    if (!(paymentHandler instanceof DtazvPaymentHandler)) continue;
                    this.printDtazvSendReport((DTAZVPayment)((DtazvPaymentHandler)paymentHandler).getPayment(), signedPayment, document, locale);
                }
                catch (PaymentException e) {
                    BLLoggerPlay.error("Failed to load signed payment information for printing!", e);
                }
            }
            String ticket = helper.generateTicket(handler, locale);
            if (ticket != null) {
                document.addVSpace(20.0f);
                document.addTextln(ticket, BLFont.COURIER_SMALL, 0.0f);
            }
            document.close();
            fos.close();
        }
        catch (Exception e) {
            BLLoggerPlay.error("Error occurred while printing send report! " + e.getMessage());
            return null;
        }
        return dest;
    }

    private void printSepaSendReport(SEPAPaymentData paymentData, SignedPayment signedPayment, BLDocument document, Locale locale) throws PDFException {
        Send send = signedPayment.getSend();
        String orderOrFileType = send.getOriginalSendType();
        BLTable t = PDFCreator.getInstance().createTable(4);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(100.0f);
        t.setWidths(new int[]{17, 33, 17, 33});
        boolean isCredit = paymentData.isCredit();
        String headerText = isCredit ? (GeneralSEPAExtractor.URGP.equals(paymentData.getServiceLevel()) ? SepaApiMessages.getString((Locale)locale, (String)"printer.urgentcreditpayment", (Object[])new Object[0]) : (paymentData.isInstantPayment() ? SepaApiMessages.getString((Locale)locale, (String)"printer.instantcreditpayment", (Object[])new Object[0]) : SepaApiMessages.getString((Locale)locale, (String)"printer.creditpayment", (Object[])new Object[0]))) : (SEPALocalInstrument.B2B.name().equals(paymentData.getDebitType()) ? SepaApiMessages.getString((Locale)locale, (String)"printer.b2bdebitpayment", (Object[])new Object[0]) : SepaApiMessages.getString((Locale)locale, (String)"printer.coredebitpayment", (Object[])new Object[0]));
        t.setDefaultPaddingTop(3.0f);
        t.setDefaultPaddingBottom(6.0f);
        t.setBackgroundColor(new Color(200, 200, 200));
        t.setDefaultColspan(t.getColumnCount());
        t.addCell(headerText, BLFont.FONT_BOLD);
        t.resetDefaults();
        t.setDefaultColspan(2);
        String textOriginatorData = isCredit ? PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.originatorData", (Object[])new Object[0]) : PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.payeeData", (Object[])new Object[0]);
        t.addCell(textOriginatorData, BLFont.FONT_BOLD);
        String recipientData = isCredit ? PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.recipientData", (Object[])new Object[0]) : PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.payerData", (Object[])new Object[0]);
        t.addCell(recipientData, BLFont.FONT_BOLD);
        t.setDefaultColspan(1);
        String textName = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.name", (Object[])new Object[0]);
        t.addCell(textName, BLFont.FONT_NORMAL);
        t.addCell(paymentData.getOriginator(), BLFont.FONT_NORMAL);
        t.addCell(textName, BLFont.FONT_NORMAL);
        t.addCell(paymentData.getRecipient(), BLFont.FONT_NORMAL);
        String textIban = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.iban", (Object[])new Object[0]);
        t.addCell(textIban, BLFont.FONT_NORMAL);
        t.addCell(IbanUtil.formatIBAN((String)paymentData.getOriginatorIban()), BLFont.FONT_NORMAL);
        t.addCell(textIban, BLFont.FONT_NORMAL);
        t.addCell(IbanUtil.formatIBAN((String)paymentData.getRecipientIban()), BLFont.FONT_NORMAL);
        String textBic = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.bic", (Object[])new Object[0]);
        t.addCell(textBic, BLFont.FONT_NORMAL);
        t.addCell(paymentData.getOriginatorBic(), BLFont.FONT_NORMAL);
        t.addCell(textBic, BLFont.FONT_NORMAL);
        t.addCell(paymentData.getRecipientBic(), BLFont.FONT_NORMAL);
        if (!isCredit) {
            t.addCell(SepaApiMessages.getString((Locale)locale, (String)"printer.creditorid", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            t.addCell(paymentData.getCreditorId(), BLFont.FONT_NORMAL);
            t.addCell(SepaApiMessages.getString((Locale)locale, (String)"printer.mandatereference", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            t.addCell(paymentData.getMandateId(), BLFont.FONT_NORMAL);
            t.addCell("", BLFont.FONT_NORMAL);
            t.addCell("", BLFont.FONT_NORMAL);
            t.addCell(SepaApiMessages.getString((Locale)locale, (String)"printer.mandatesigndate", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            if (paymentData.getMandateSignDate() != null) {
                t.addCell(DateFormat.getDateInstance(2, locale).format(paymentData.getMandateSignDate()), BLFont.FONT_NORMAL);
            } else {
                t.addCell("", BLFont.FONT_NORMAL);
            }
            t.addCell("", BLFont.FONT_NORMAL);
            t.addCell("", BLFont.FONT_NORMAL);
            t.addCell(SepaApiMessages.getString((Locale)locale, (String)"printer.sequencetype", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            t.addCell(paymentData.getSequenceType(), BLFont.FONT_NORMAL);
        }
        t.setDefaultColspan(4);
        t.addCell("", BLFont.FONT_NORMAL);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.paymentData", (Object[])new Object[0]), BLFont.FONT_BOLD);
        t.setDefaultColspan(1);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.amount", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.addCell(PaymentUtils.formatAmount((BigDecimal)paymentData.getAmount(), (Currency)paymentData.getCurrency(), (Locale)locale), BLFont.FONT_NORMAL);
        if (paymentData.hasExecutionTime()) {
            t.addCell(GeneralMessages.getInstance((Locale)locale).EXECUTION_TIME, BLFont.FONT_NORMAL);
            if (paymentData.getExecutionDate() != null) {
                t.addCell(DateFormat.getDateTimeInstance(2, 3, locale).format(paymentData.getExecutionDate()), BLFont.FONT_NORMAL);
            } else {
                t.addCell("", BLFont.FONT_NORMAL);
            }
        } else {
            String executionDate = isCredit ? PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.executionDate", (Object[])new Object[0]) : PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.paymentDate", (Object[])new Object[0]);
            t.addCell(executionDate, BLFont.FONT_NORMAL);
            if (paymentData.getExecutionDate() != null) {
                t.addCell(DateFormat.getDateInstance(2, locale).format(paymentData.getExecutionDate()), BLFont.FONT_NORMAL);
            } else {
                t.addCell("", BLFont.FONT_NORMAL);
            }
        }
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.orderType", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.addCell(orderOrFileType, BLFont.FONT_NORMAL);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.reference", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.addCell(paymentData.getEndToEndId(), BLFont.FONT_NORMAL);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.purpose", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.setDefaultColspan(3);
        t.addCell(paymentData.getPurpose(), BLFont.FONT_NORMAL);
        document.addTable(t);
    }

    private void printMt101SendReport(MT101PaymentData payment, SignedPayment signedPayment, BLDocument document, Locale locale) throws PDFException {
        BLTable t = PDFCreator.getInstance().createTable(4);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(100.0f);
        t.setWidths(new int[]{17, 33, 17, 33});
        String headerText = MT101ApiMessages.getString((Locale)locale, (String)"printer.mt101payment", (Object[])new Object[0]);
        t.setDefaultPaddingTop(3.0f);
        t.setDefaultPaddingBottom(6.0f);
        t.setBackgroundColor(new Color(200, 200, 200));
        t.setDefaultColspan(t.getColumnCount());
        t.addCell(headerText, BLFont.FONT_BOLD);
        t.resetDefaults();
        t.setDefaultColspan(2);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.originatorData", (Object[])new Object[0]), BLFont.FONT_BOLD);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.recipientData", (Object[])new Object[0]), BLFont.FONT_BOLD);
        t.setDefaultColspan(1);
        String textName = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.name", (Object[])new Object[0]);
        t.addCell(textName, BLFont.FONT_NORMAL);
        t.addCell(payment.getOriginatorName(), BLFont.FONT_NORMAL);
        t.addCell(textName, BLFont.FONT_NORMAL);
        t.addCell(payment.getRecipientName(), BLFont.FONT_NORMAL);
        String textIban = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.accountNumber", (Object[])new Object[0]);
        t.addCell(textIban, BLFont.FONT_NORMAL);
        if (IbanUtil.checkIban((String)payment.getOriginatorAccount())) {
            t.addCell(IbanUtil.formatIBAN((String)payment.getOriginatorAccount()), BLFont.FONT_NORMAL);
        } else {
            t.addCell(payment.getOriginatorAccount(), BLFont.FONT_NORMAL);
        }
        t.addCell(textIban, BLFont.FONT_NORMAL);
        if (IbanUtil.checkIban((String)payment.getRecipientAccount())) {
            t.addCell(IbanUtil.formatIBAN((String)payment.getRecipientAccount()), BLFont.FONT_NORMAL);
        } else {
            t.addCell(payment.getRecipientAccount(), BLFont.FONT_NORMAL);
        }
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.bic", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.addCell(payment.getOriginatorBic(), BLFont.FONT_NORMAL);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.blz", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.addCell(payment.getRecipientBankCode(), BLFont.FONT_NORMAL);
        String intermediary = payment.getIntermediaryBankCode();
        if (intermediary != null && !intermediary.trim().isEmpty()) {
            t.addCell("", BLFont.FONT_NORMAL);
            t.addCell("", BLFont.FONT_NORMAL);
            t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.intermediaryInstitution", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            t.addCell(payment.getIntermediaryBankCode(), BLFont.FONT_NORMAL);
        }
        t.setDefaultColspan(4);
        t.addCell("", BLFont.FONT_NORMAL);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.paymentData", (Object[])new Object[0]), BLFont.FONT_BOLD);
        t.setDefaultColspan(1);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.amount", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.addCell(PaymentUtils.formatAmount((BigDecimal)payment.getAmount(), (Currency)payment.getCurrency(), (Locale)locale), BLFont.FONT_NORMAL);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.executionDate", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        Date d = null;
        try {
            d = payment.getExecutionDateAsDate();
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to get Mt101 payment execution date as date!", e);
        }
        if (d != null) {
            t.addCell(DateFormat.getDateInstance(2, locale).format(d), BLFont.FONT_NORMAL);
        } else {
            t.addCell("", BLFont.FONT_NORMAL);
        }
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.reference", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.addCell(payment.getTransactionReference(), BLFont.FONT_NORMAL);
        t.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.purpose", (Object[])new Object[0]), BLFont.FONT_NORMAL);
        t.setDefaultColspan(3);
        t.addCell(payment.getPurpose(), BLFont.FONT_NORMAL);
        document.addTable(t);
    }

    private void printDtazvSendReport(DTAZVPayment payment, SignedPayment signedPayment, BLDocument document, Locale locale) throws PDFException {
        boolean onePaymentPerPage = false;
        String orderOrFileType = signedPayment.getSend().getOriginalSendType();
        if (payment.getTransactions() == null || payment.getTransactions().isEmpty()) {
            return;
        }
        boolean firstPage = true;
        for (DTAZVTransaction transaction : payment.getTransactions()) {
            List messages;
            String[] additionalPurposeLines;
            Currency currency;
            boolean isBankAddressPresent;
            if (firstPage) {
                firstPage = false;
            }
            BLTable table = PDFCreator.getInstance().createTable(4);
            table.setBorder(BLBorder.NO_BORDER);
            table.setWidth(100.0f);
            table.setWidths(new int[]{18, 32, 18, 32});
            String paymentType = Byte.toString(transaction.getPaymentType());
            boolean isEsuPayment = "13".equals(paymentType);
            String headerText = isEsuPayment ? PaymentPrinterMessages.getString((Locale)locale, (String)"paymentprinter.esupayment", (Object[])new Object[0]) : ("11".equals(paymentType) ? PaymentPrinterMessages.getString((Locale)locale, (String)"paymentprinter.euepayment", (Object[])new Object[0]) : PaymentPrinterMessages.getString((Locale)locale, (String)"paymentprinter.azvpayment", (Object[])new Object[0]));
            table.setDefaultPaddingTop(3.0f);
            table.setDefaultPaddingBottom(6.0f);
            table.setBackgroundColor(new Color(200, 200, 200));
            table.setDefaultColspan(table.getColumnCount());
            table.addCell(headerText, BLFont.FONT_BOLD);
            table.resetDefaults();
            table.setDefaultColspan(2);
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.originatorData", (Object[])new Object[0]), BLFont.FONT_BOLD);
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.recipientData", (Object[])new Object[0]), BLFont.FONT_BOLD);
            table.setDefaultColspan(1);
            String textName = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.name", (Object[])new Object[0]);
            table.addCell(textName, BLFont.FONT_NORMAL);
            table.addCell(payment.getOriginator(), BLFont.FONT_NORMAL);
            table.addCell(textName, BLFont.FONT_NORMAL);
            table.addCell(transaction.getRecipient(), BLFont.FONT_NORMAL);
            table.addCell("", BLFont.FONT_NORMAL);
            table.addCell(payment.getOriginator2(), BLFont.FONT_NORMAL);
            table.addCell("", BLFont.FONT_NORMAL);
            table.addCell(transaction.getRecipient2(), BLFont.FONT_NORMAL);
            String textStreet = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.street", (Object[])new Object[0]);
            table.addCell(textStreet, BLFont.FONT_NORMAL);
            table.addCell(payment.getOriginator3(), BLFont.FONT_NORMAL);
            table.addCell(textStreet, BLFont.FONT_NORMAL);
            table.addCell(transaction.getRecipient3(), BLFont.FONT_NORMAL);
            String textTown = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.town", (Object[])new Object[0]);
            table.addCell(textTown, BLFont.FONT_NORMAL);
            table.addCell(payment.getOriginator4(), BLFont.FONT_NORMAL);
            table.addCell(textTown, BLFont.FONT_NORMAL);
            table.addCell(transaction.getRecipient4(), BLFont.FONT_NORMAL);
            if (isEsuPayment) {
                table.addCell("", BLFont.FONT_NORMAL);
                table.addCell("", BLFont.FONT_NORMAL);
            } else {
                table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.federalState", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                DtazvFederalState state = DtazvFederalState.getByKey((String)Byte.toString(payment.getCountryCode()));
                if (state != null) {
                    table.addCell(state.getName(locale), BLFont.FONT_NORMAL);
                } else {
                    table.addCell("", BLFont.FONT_NORMAL);
                }
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.country", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            if (transaction.getRecipientCountry() != null) {
                table.addCell(transaction.getRecipientCountry(), BLFont.FONT_NORMAL);
            } else {
                table.addCell("", BLFont.FONT_NORMAL);
            }
            String textAccountNumber = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.accountNumber", (Object[])new Object[0]);
            table.addCell(textAccountNumber, BLFont.FONT_NORMAL);
            table.addCell(String.valueOf(transaction.getAccount()), BLFont.FONT_NORMAL);
            boolean isChequePayment = DtazvApi.isChequePaymentType((String)paymentType);
            if (isChequePayment) {
                table.addCell("", BLFont.FONT_NORMAL);
                table.addCell("", BLFont.FONT_NORMAL);
            } else {
                String iban = transaction.getIban();
                if (iban != null && !iban.isEmpty() && iban.charAt(0) == '/') {
                    iban = iban.substring(1);
                }
                if (iban == null || iban.isEmpty() || IbanUtil.checkIban((String)iban)) {
                    table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.iban", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                    iban = IbanUtil.formatIBAN((String)iban);
                } else {
                    table.addCell(textAccountNumber, BLFont.FONT_NORMAL);
                }
                table.addCell(iban == null ? "" : iban, BLFont.FONT_NORMAL);
            }
            String textBlz = PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.blz", (Object[])new Object[0]);
            String originatorBlz = String.valueOf(payment.getBlz());
            table.addCell(textBlz, BLFont.FONT_NORMAL);
            table.addCell(originatorBlz, BLFont.FONT_NORMAL);
            if (isChequePayment) {
                table.addCell("", BLFont.FONT_NORMAL);
                table.addCell("", BLFont.FONT_NORMAL);
            } else {
                String bic = transaction.getBic();
                if (bic != null && bic.startsWith("///")) {
                    table.addCell(textBlz, BLFont.FONT_NORMAL);
                } else {
                    table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.bic", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                }
                table.addCell(bic == null ? "" : bic, BLFont.FONT_NORMAL);
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.currency", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            if (transaction.getAccountCurrency() != null) {
                table.addCell(transaction.getAccountCurrency(), BLFont.FONT_NORMAL);
            } else {
                table.addCell("", BLFont.FONT_NORMAL);
            }
            boolean bl = isBankAddressPresent = transaction.getBank() != null && !transaction.getBank().isEmpty() || transaction.getBank2() != null && !transaction.getBank2().isEmpty() || transaction.getBank3() != null && !transaction.getBank3().isEmpty() || transaction.getBank4() != null && !transaction.getBank4().isEmpty() || transaction.getBankCountry() != null && !transaction.getBankCountry().isEmpty();
            if (isBankAddressPresent) {
                table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.bank", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                table.addCell(transaction.getBank(), BLFont.FONT_NORMAL);
            } else {
                table.addCell("", BLFont.FONT_NORMAL);
                table.addCell("", BLFont.FONT_NORMAL);
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.bank", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.unknown", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            table.addCell("", BLFont.FONT_NORMAL);
            if (isBankAddressPresent) {
                table.addCell(transaction.getBank2(), BLFont.FONT_NORMAL);
            } else {
                table.addCell("", BLFont.FONT_NORMAL);
            }
            if (!isEsuPayment) {
                table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.companyNumber", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                if (payment.getCompanyCode() != 0) {
                    table.addCell(Integer.toString(payment.getCompanyCode()), BLFont.FONT_NORMAL);
                } else {
                    table.addCell("", BLFont.FONT_NORMAL);
                }
                if (isBankAddressPresent) {
                    table.addCell(textStreet, BLFont.FONT_NORMAL);
                    table.addCell(transaction.getBank3(), BLFont.FONT_NORMAL);
                } else {
                    table.addCell("", BLFont.FONT_NORMAL);
                    table.addCell("", BLFont.FONT_NORMAL);
                }
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.contact", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            table.addCell(transaction.getContact(), BLFont.FONT_NORMAL);
            if (isBankAddressPresent) {
                table.addCell(textTown, BLFont.FONT_NORMAL);
                table.addCell(transaction.getBank4(), BLFont.FONT_NORMAL);
            } else {
                table.addCell("", BLFont.FONT_NORMAL);
                table.addCell("", BLFont.FONT_NORMAL);
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.customerNumber", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            if (payment.getCustomerNumber() != 0L) {
                table.addCell(Long.toString(payment.getCustomerNumber()), BLFont.FONT_NORMAL);
            } else {
                table.addCell("", BLFont.FONT_NORMAL);
            }
            if (isBankAddressPresent) {
                table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.country", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                table.addCell(transaction.getBankCountry(), BLFont.FONT_NORMAL);
            } else {
                table.addCell("", BLFont.FONT_NORMAL);
                table.addCell("", BLFont.FONT_NORMAL);
            }
            table.setDefaultColspan(4);
            table.addCell("", BLFont.FONT_NORMAL);
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.paymentData", (Object[])new Object[0]), BLFont.FONT_BOLD);
            table.setDefaultColspan(1);
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.amount", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            boolean isCounterValue = "91".equals(Byte.toString(transaction.getInstructionCode4()));
            if (isCounterValue) {
                currency = Currency.getInstance((String)"EUR");
                table.addCell(PaymentUtils.formatAmount((BigDecimal)transaction.getAmount(), (Currency)Currency.getInstance((String)transaction.getAccountCurrency()), (Locale)locale), BLFont.FONT_NORMAL);
                table.setDefaultColspan(2);
                table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.counterValuePayment", (Object[])new Object[]{transaction.getCurrency()}), BLFont.FONT_NORMAL);
                table.setDefaultColspan(1);
            } else {
                currency = Currency.getInstance((String)transaction.getCurrency());
                table.addCell(PaymentUtils.formatAmount((BigDecimal)transaction.getAmount(), (Currency)currency, (Locale)locale), BLFont.FONT_NORMAL);
                table.addCell("", BLFont.FONT_NORMAL);
                table.addCell("", BLFont.FONT_NORMAL);
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.paymentType", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            DtazvPaymentType dtazvPaymentType = DtazvPaymentType.getForKey((String)paymentType);
            if (dtazvPaymentType == null) {
                table.addCell(DtazvPaymentType.TYPE_00.getDescription(locale), BLFont.FONT_NORMAL);
            } else {
                table.addCell(dtazvPaymentType.getDescription(locale));
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.executionDate", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            Date date2 = transaction.getExecutionDate();
            if (date2 == null) {
                date2 = payment.getExecutionDate();
            }
            if (date2 != null) {
                table.addCell(DateFormat.getDateInstance(2, locale).format(date2), BLFont.FONT_NORMAL);
            } else {
                table.addCell("", BLFont.FONT_NORMAL);
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.orderType", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            table.addCell(orderOrFileType, BLFont.FONT_NORMAL);
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.reference", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            table.addCell(transaction.getReference(), BLFont.FONT_NORMAL);
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.purpose", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            table.setDefaultColspan(3);
            table.addCell(transaction.getPurpose(), BLFont.FONT_NORMAL);
            table.setDefaultColspan(1);
            for (String content : additionalPurposeLines = new String[]{transaction.getPurpose2(), transaction.getPurpose3(), transaction.getPurpose4()}) {
                if (content == null || content.isEmpty()) continue;
                table.addCell("", BLFont.FONT_NORMAL);
                table.setDefaultColspan(3);
                table.addCell(content, BLFont.FONT_NORMAL);
                table.setDefaultColspan(1);
            }
            if (isChequePayment) {
                table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.orderComment", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                table.setDefaultColspan(3);
                table.addCell(transaction.getOrderComment(), BLFont.FONT_NORMAL);
                table.setDefaultColspan(1);
                if (transaction.getOrderComment2() != null && !transaction.getOrderComment2().isEmpty()) {
                    table.addCell("", BLFont.FONT_NORMAL);
                    table.setDefaultColspan(3);
                    table.addCell(transaction.getOrderComment2(), BLFont.FONT_NORMAL);
                    table.setDefaultColspan(1);
                }
            }
            if (!isEsuPayment && transaction.getFeeBlz() > 0) {
                String feeAccountDisplayName = String.valueOf(transaction.getFeeBlz()) + "/" + transaction.getFeeAccount() + "/" + transaction.getFeeCurrency();
                table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.feeAccount", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                table.setDefaultColspan(3);
                table.addCell(feeAccountDisplayName, BLFont.FONT_NORMAL);
                table.setDefaultColspan(1);
            }
            table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.feeType", (Object[])new Object[0]), BLFont.FONT_NORMAL);
            table.setDefaultColspan(3);
            DtazvFeeType feeType = DtazvFeeType.getByKey((String)Byte.toString(transaction.getFeeType()));
            if (feeType == null) {
                table.addCell(DtazvFeeType.TYPE_00.getDescription(locale), BLFont.FONT_NORMAL);
            } else {
                table.addCell(feeType.getDescription(locale), BLFont.FONT_NORMAL);
            }
            table.setDefaultColspan(1);
            if (!isEsuPayment && !isChequePayment) {
                String additionalInfo;
                DtazvInstructionCode instrCode1 = DtazvInstructionCode.getByKey((String)Byte.toString(transaction.getInstructionCode()));
                DtazvInstructionCode instrCode2 = DtazvInstructionCode.getByKey((String)Byte.toString(transaction.getInstructionCode2()));
                DtazvInstructionCode instrCode3 = DtazvInstructionCode.getByKey((String)Byte.toString(transaction.getInstructionCode3()));
                DtazvInstructionCode instrCode4 = DtazvInstructionCode.getByKey((String)Byte.toString(transaction.getInstructionCode4()));
                if (instrCode1 != null && instrCode1 != DtazvInstructionCode.TYPE_00 || instrCode2 != null && instrCode2 != DtazvInstructionCode.TYPE_00 || instrCode3 != null && instrCode3 != DtazvInstructionCode.TYPE_00 || instrCode4 != null && instrCode4 != DtazvInstructionCode.TYPE_00) {
                    table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.instrCode1", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                    table.setDefaultColspan(3);
                    if (instrCode1 == null || instrCode1 == DtazvInstructionCode.TYPE_00) {
                        table.addCell("", BLFont.FONT_NORMAL);
                    } else {
                        table.addCell(instrCode1.getDescription(locale), BLFont.FONT_NORMAL);
                    }
                    table.setDefaultColspan(1);
                    table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.instrCode2", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                    table.setDefaultColspan(3);
                    if (instrCode2 == null || instrCode2 == DtazvInstructionCode.TYPE_00) {
                        table.addCell("", BLFont.FONT_NORMAL);
                    } else {
                        table.addCell(instrCode2.getDescription(locale), BLFont.FONT_NORMAL);
                    }
                    table.setDefaultColspan(1);
                    table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.instrCode3", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                    table.setDefaultColspan(3);
                    if (instrCode3 == null || instrCode3 == DtazvInstructionCode.TYPE_00) {
                        table.addCell("", BLFont.FONT_NORMAL);
                    } else {
                        table.addCell(instrCode3.getDescription(locale), BLFont.FONT_NORMAL);
                    }
                    table.setDefaultColspan(1);
                    table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.instrCode4", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                    table.setDefaultColspan(3);
                    if (instrCode4 == null || instrCode4 == DtazvInstructionCode.TYPE_00) {
                        table.addCell("", BLFont.FONT_NORMAL);
                    } else {
                        table.addCell(instrCode4.getDescription(locale), BLFont.FONT_NORMAL);
                    }
                    table.setDefaultColspan(1);
                }
                if ((additionalInfo = transaction.getInstructions()) != null && !additionalInfo.isEmpty()) {
                    table.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.instructions", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                    table.setDefaultColspan(3);
                    table.addCell(transaction.getInstructions(), BLFont.FONT_NORMAL);
                    table.setDefaultColspan(1);
                }
            }
            boolean hasMessages = (messages = transaction.getMessages()) != null && !messages.isEmpty();
            document.addTable(table);
            if (!hasMessages) continue;
            BLTable t2 = PDFCreator.getInstance().createTable(3);
            t2.setBorder(BLBorder.NO_BORDER);
            t2.setWidth(100.0f);
            t2.setWidths(new int[]{40, 40, 20});
            t2.setDefaultColspan(3);
            t2.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.messages", (Object[])new Object[0]), BLFont.FONT_BOLD);
            t2.setDefaultColspan(1);
            t2.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.type", (Object[])new Object[0]), BLFont.FONT_BOLD);
            t2.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.messageDescription", (Object[])new Object[0]), BLFont.FONT_BOLD);
            t2.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.amount", (Object[])new Object[0]), BLFont.FONT_BOLD);
            for (DTAZVMessage message : messages) {
                if (message instanceof DTAZVCapitalMessage) {
                    DTAZVCapitalMessage capitalMessage = (DTAZVCapitalMessage)message;
                    t2.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.capitalType", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                    t2.addCell(capitalMessage.getDescription(), BLFont.FONT_NORMAL);
                    t2.addCell(PaymentUtils.formatAmount((BigDecimal)BigDecimal.valueOf(capitalMessage.getAmount()), (Currency)Currency.getInstance((String)transaction.getCurrency()), (Locale)locale), BLFont.FONT_NORMAL);
                    continue;
                }
                if (!(message instanceof DTAZVTransitMessage)) continue;
                DTAZVTransitMessage transitMessage = (DTAZVTransitMessage)message;
                t2.addCell(PaymentPrinterMessages.getString((Locale)locale, (String)"PaymentPrinter.transitType", (Object[])new Object[0]), BLFont.FONT_NORMAL);
                t2.addCell(transitMessage.getBuyDesciption(), BLFont.FONT_NORMAL);
                t2.addCell(PaymentUtils.formatAmount((BigDecimal)BigDecimal.valueOf(transitMessage.getBuyPrice()), (Currency)currency, (Locale)locale), BLFont.FONT_NORMAL);
            }
            document.addTable(t2);
        }
    }
}

