/*
 * Decompiled with CFR 0.152.
 */
package controllers.branding;

import controllers.Banks;
import controllers.Sent;
import controllers.Setup;
import controllers.branding.BAWAGBranding;
import controllers.branding.GevaDaimlerBranding;
import controllers.branding.GevaDzBankBranding;
import controllers.branding.ICICIBranding;
import controllers.branding.KDBankBranding;
import controllers.branding.SantanderBranding;
import controllers.branding.TenantFromExcel;
import controllers.branding.VwfsBranding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PrintUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.transfer.api.SendOrderHandler;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.format.dta.DtazvPaymentType;
import de.businesslogics.format.sepa.GeneralSEPAReportExtractor;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.pdf.StatusReportGenerator;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import models.LoginForm;
import models.payments.PaymentUtils;
import org.xml.sax.SAXException;
import play.Environment;
import play.data.Form;
import play.i18n.Messages;
import play.mvc.Call;
import play.mvc.Http;
import play.twirl.api.Html;
import scala.Option;
import views.html.branding.blbankingwebgreybox;
import views.html.branding.blbankingweblogo;

public class Branding {
    private static Branding INSTANCE;
    protected static boolean logCmLoadTimes;
    public String SEPACreditorID = null;

    public static void setBranding(String config) {
        Flavor flavor = Flavor.fromConfig(config);
        INSTANCE = switch (flavor.ordinal()) {
            case 1 -> new GevaDaimlerBranding();
            case 2 -> new BAWAGBranding();
            case 3 -> new SantanderBranding();
            case 4 -> new VwfsBranding();
            case 5 -> new ICICIBranding();
            case 6 -> new GevaDzBankBranding();
            case 7 -> new KDBankBranding();
            default -> new Branding();
        };
    }

    public static Branding getBranding() {
        return INSTANCE;
    }

    public String getOpenPaymentsLabel() {
        return "GeneralMessages.openPayments";
    }

    public boolean showSettingsMenuPref() {
        return false;
    }

    public boolean showOrderTypeInTitle() {
        return false;
    }

    public String getSignedPaymentStateLabel() {
        return "GeneralMessages.state";
    }

    public boolean autofillBICFromIBAN() {
        return false;
    }

    public Option<String> getAccountAfterOriginator() {
        return Option.empty();
    }

    public boolean showUltimateOriginatorAndRecipient() {
        return true;
    }

    public boolean showUserTableForOneBankAtStartpage() {
        return false;
    }

    public String getUrl() {
        return null;
    }

    public String getHostId() {
        return null;
    }

    public String getCountryCode() {
        return "DE";
    }

    public boolean showDiscountButton() {
        return true;
    }

    public boolean doSEPAThreeLinesPurpose() {
        return false;
    }

    public boolean isPurposeMandatory() {
        return false;
    }

    public Optional<String> prefillEndToEndId() {
        return Optional.empty();
    }

    public boolean showBatchBookingWarning() {
        return false;
    }

    public String originatorLabelForSEPADebit() {
        return "GeneralMessages.payee";
    }

    public Optional<String> SEPADebitPaymentCategory() {
        return Optional.empty();
    }

    public Optional<String> SEPADebitPurposeCode() {
        return Optional.empty();
    }

    public Optional<String> SEPACreditPaymentCategory(User user) {
        return Optional.empty();
    }

    public Optional<String> SEPACreditPurposeCode(User user) {
        return Optional.empty();
    }

    public Optional<List<PaymentTransferType.PmtType>> excludedPaymentTypes() {
        return Optional.empty();
    }

    public boolean showBatchBookingCheckboxForCDD() {
        return true;
    }

    public Option<String> reorderFieldsForDebitPayments() {
        return Option.empty();
    }

    public boolean hideOneDTAZVPurposeLine() {
        return false;
    }

    public boolean hidePaymentImport() {
        return false;
    }

    public boolean hidePDFStatements() {
        return false;
    }

    public boolean hideSaveInDes() {
        return false;
    }

    public boolean hidePrintInDes() {
        return false;
    }

    public boolean hideSaveInSentFiles() {
        return false;
    }

    public boolean showCategoryInSendLogs() {
        return false;
    }

    public boolean showResetPasswordInSendLogs() {
        return false;
    }

    public boolean showSendLogsButton() {
        return false;
    }

    public String sendLogsButtonLabel(Messages messages) {
        return messages.at("sendtraces", new Object[0]);
    }

    public String sendLogsSubmitButtonLabel(Messages messages) {
        return messages.at("sendlogs.send", new Object[0]);
    }

    public boolean isSendLogsCommentMandatory() {
        return false;
    }

    public boolean setLocalUserAsDefault() {
        return false;
    }

    public Call doBrandingSetup(Http.Request request) {
        return null;
    }

    public boolean isSetupComplete(Environment environment) {
        return true;
    }

    public Call getNewUserSetup() {
        return routes.UserSetup.newUserSetup();
    }

    public String getAccountSuffix(Account account) {
        return " (" + account.getBank().getDisplayName() + ")";
    }

    protected SendOrderHandler.SendReportPrintHelper getSendReportPrintHelper(final SendOrderHandler handler, final User user, final Messages messages, final boolean pageBreak) {
        return new SendOrderHandler.SendReportPrintHelper(){

            public void printDetails(BLDocument document, Send send) throws PDFException {
                if (!PrintUtil.isFileTooLargeForDetails((long)send.getSize(), (BLDocument)document, (User)user, (Locale)messages.lang().locale())) {
                    Sent.printPaymentsToSendReport(handler.getDataFile(), document, send.getPmtType(), user, messages.lang().locale(), pageBreak);
                }
            }

            public String generateTicket(SendOrderHandler send, Locale locale) throws IOException {
                try {
                    return Util.getDisplayMessage((Send)send.getSend(), (Locale)locale);
                }
                catch (Exception e) {
                    BLLoggerPlay.error("Failed to generate ticket for send order!", e);
                    return null;
                }
            }

            public String getOrderName(Send send, Locale locale) {
                PaymentTransferType.PmtType pmtType = send.getPmtType();
                if (pmtType != null && SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
                    return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.orderName.transferOrder", (Object[])new Object[]{this.getFormat(send)});
                }
                if ("CDB".equals(send.getOrderType()) || "pain.008.001.01.sbb".equals(send.getFileType())) {
                    return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.orderName.businessDebitOrder", (Object[])new Object[]{this.getFormat(send)});
                }
                if (pmtType != null && SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
                    return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.orderName.baseDebitOrder", (Object[])new Object[]{this.getFormat(send)});
                }
                if (DtazvApi.isDtazvOrderType((String)send.getOrderType())) {
                    return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.orderName.foreignTransferOrder", (Object[])new Object[]{this.getFormat(send)});
                }
                if (MT101Api.isMt101OrderType((String)send.getOrderType())) {
                    return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.orderName.transferOrder", (Object[])new Object[]{this.getFormat(send)});
                }
                return null;
            }

            public String getFormat(Send send) {
                PaymentTransferType.PmtType pmtType = send.getPmtType();
                if (pmtType != null && (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType) || SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType))) {
                    return "SEPA";
                }
                if (DtazvApi.isDtazvOrderType((String)send.getOrderType())) {
                    return "DTAZV";
                }
                if (MT101Api.isMt101OrderType((String)send.getOrderType())) {
                    return "MT101";
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void printStatusReports(BLDocument document, List<Notification> statusReports) throws PDFException {
                document.setPageSize(BLDocument.PageLayout.A4_LANDSCAPE);
                for (Notification statusReport : statusReports) {
                    document.newPage();
                    InputStream in = null;
                    try {
                        in = EncryptData.getInstance().openInputStream(WorkspaceFileSystem.getFile((WorkspaceFile)statusReport.getFile()));
                        List orders = GeneralSEPAReportExtractor.getRejectedOrders((InputStream)in);
                        for (RejectedSEPAOrder order : orders) {
                            order.setOrderType(handler.getSend().getOriginalSendType());
                            order.setOrderNumber(handler.getSend().getOrderNumber());
                        }
                        StatusReportGenerator generator = new StatusReportGenerator(orders, Locale.getDefault());
                        generator.addToDocument(StatusReportGenerator.getReportType((String)statusReport.getOrderType()), statusReport.getBank().getDisplayName(), document);
                    }
                    catch (PDFException | IOException | GeneralSecurityException | SAXException e) {
                        try {
                            BLLoggerPlay.error("Error when printing status reports", e);
                        }
                        catch (Throwable throwable) {
                            Util.closeStream(in);
                            throw throwable;
                        }
                        Util.closeStream((Closeable)in);
                        continue;
                    }
                    Util.closeStream((Closeable)in);
                }
            }
        };
    }

    public File printSendReport(Send send, User user, Messages messages) throws IOException, PDFException {
        SendOrderHandler handler = new SendOrderHandler(send);
        Tenant tenant = send.getBank().getTenant();
        boolean pageBreak = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user, tenant).getBoolean((DatabasePreferenceConstant)PreferenceConstants.SEND_REPORT_DETAILS_WITH_PAGE_BREAK);
        return handler.printSendReport(messages.lang().locale(), user, this.getSendReportPrintHelper(handler, user, messages, pageBreak), GeneralUtils.printLogo(user));
    }

    public boolean showHTDReport() {
        return false;
    }

    public List<User> getUserForHTDReport(User currentUser) {
        return Collections.singletonList(currentUser);
    }

    public boolean doTenantsWithBank() {
        return false;
    }

    public boolean hidePreferencesLeadDescription() {
        return false;
    }

    public boolean createUserWithWebAuthn() {
        return false;
    }

    public void fillBankData(BankSettings bank) {
    }

    public boolean hideHashesForBankInTenant() {
        return false;
    }

    public void addToHTDReport(PDFCreator creator, BLDocument document, Messages messages) throws PDFException {
    }

    public List<String> getBootstrapCSS() {
        return Collections.singletonList("bootstrap.css");
    }

    public List<String> getBrandingCSS() {
        return Collections.singletonList("default.css");
    }

    public boolean hasLoginBranding() {
        return false;
    }

    public Html getLoginBranding(Form<LoginForm> loginForm, Http.Request request, Messages messages) {
        return null;
    }

    public boolean showCreatedByBLText() {
        return true;
    }

    public Optional<Html> getLogoHtmlForNavbar() {
        return Optional.of(blbankingweblogo.render());
    }

    public boolean hideMastheadOnLoginAndLogoff() {
        return false;
    }

    public boolean hideMastheadOnIndex() {
        return false;
    }

    public boolean hideUpdateAvailableBanner() {
        return false;
    }

    public Optional<Html> getMasthead(Messages messages) {
        return Optional.of(blbankingwebgreybox.render(messages));
    }

    protected Optional<String> getDefaultRemoteSupportURL() {
        return Optional.of("https://get.teamviewer.com/7qvsca3");
    }

    public Optional<String> getRemoteSupportURL() {
        if (Setup.REMOTESUPPORT_URL != null) {
            return Optional.of(Setup.REMOTESUPPORT_URL);
        }
        return this.getDefaultRemoteSupportURL();
    }

    public String getRemoteSupportLabel() {
        if (Setup.REMOTESUPPORT_URL != null) {
            return "remotesupport2";
        }
        return "remotesupport";
    }

    public boolean hasContactButton() {
        return false;
    }

    public String getContactButtonLabel() {
        return null;
    }

    public String getContactButtonLink() {
        return null;
    }

    public boolean showSendLogsMenu() {
        return true;
    }

    public boolean hideYubikey2FAButton() {
        return false;
    }

    public boolean hideAdding2FAButtons() {
        return !Setup.ALLOW_ADMINS_TO_ADD_2FA;
    }

    public boolean hideAuthenticatorApp2FAButton() {
        return false;
    }

    public boolean hideUserImportButton() {
        return false;
    }

    public boolean showTenantMaxUserCount() {
        return true;
    }

    public boolean usersTable2FAColumnHasButtons() {
        return false;
    }

    public void setupBlApi() {
    }

    public boolean hideEdsOverviewImportAsOpenPaymentButton() {
        return false;
    }

    public List<DtazvPaymentType> excludedDtazvPaymentTypes() {
        return null;
    }

    public boolean allowTenantAdminUsernameUpdate() {
        return true;
    }

    public Optional<String> getUsernameSuffix() {
        return Optional.empty();
    }

    public boolean showCustomerColumnInFetchSchedulesTables() {
        return false;
    }

    public boolean useBankAdminRoles() {
        return false;
    }

    public TenantFromExcel getTenantFromExcel() {
        return null;
    }

    public String[] getPrintedStatementFooter() {
        return null;
    }

    public boolean alwaysPrintLogo() {
        return false;
    }

    public boolean allowOnlyCSVForSending(User user) {
        return false;
    }

    public void setEbicsServerUrl(String url) {
    }

    public String getNavbarColorClass(String navbarId) {
        return "navbar-light bg-light";
    }

    public String getNavbarQuickButtonsClass() {
        return "btn-success";
    }

    public String getLogoffButtonClass() {
        return "btn-primary";
    }

    public String getNavbarHelpButtonClass() {
        return "btn-secondary";
    }

    public String getOnlineHelpLabel() {
        return "main.display.help";
    }

    public boolean hideBankIconOnLandingPage() {
        return false;
    }

    public String getFirstLoginMessage() {
        return "login.done.first";
    }

    public String getLoginMessage() {
        return "login.done";
    }

    public String getDefaultBankIcon() {
        return Banks.defaultIcon();
    }

    public String getCustomDashboardIconClass() {
        return null;
    }

    public String getCustomDashboardIconEds() {
        return null;
    }

    public String getCustomDashboardIconPayments() {
        return null;
    }

    public String getCustomDashboardIconStatements() {
        return null;
    }

    public String getCustomDashboardIconTenants() {
        return null;
    }

    public String getCustomDashboardIconBanks() {
        return null;
    }

    public String getCustomDashboardIconSendFile() {
        return null;
    }

    public String getCustomDashboardIconFetchFile() {
        return null;
    }

    public boolean hideShareUserKeysButton() {
        return false;
    }

    public boolean hideSendDirectories() {
        return false;
    }

    public boolean logCmLoadTimes() {
        return logCmLoadTimes;
    }

    public void setLogCmLoadTimes(boolean logCmLoadTimes) {
        Branding.logCmLoadTimes = logCmLoadTimes;
    }

    public String getCmNavbarLabel(Messages messages) {
        return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountStatements", (Object[])new Object[0]);
    }

    public String getRecipientsLabel(Messages messages) {
        return messages.at("recipients", new Object[0]);
    }

    public String getNewRecipientLabel(Messages messages) {
        return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.newRecipient", (Object[])new Object[0]);
    }

    public String getRecipientsFilterLabel(Messages messages) {
        return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.recipients.title", (Object[])new Object[0]);
    }

    public String getSepaRecipientLabel(Messages messages) {
        return messages.at("recipients.type.sepa", new Object[0]);
    }

    public String getSepaMandateLabel(Messages messages) {
        return SepaApiMessages.getString((Locale)messages.lang().locale(), (String)"printer.sepaMandate", (Object[])new Object[0]);
    }

    public String getEditRecipientTitle(PaymentType paymentType, boolean isNew, Messages messages) {
        return PaymentUtils.getTitleRecipient(paymentType, isNew, messages);
    }

    public boolean showAllowInvalidBankConnectionPreference() {
        return true;
    }

    public String vopDisabledWarning(Locale locale) {
        return null;
    }

    static {
        logCmLoadTimes = false;
    }

    private static enum Flavor {
        DEFAULT(""),
        GEVA_DAIMLER("geva_daimler"),
        BAWAG("bawag"),
        SANTANDER("santander"),
        VWFS("vwfs"),
        ICICI("icici"),
        GEVA_DZ_BANK("geva_dz_bank"),
        KD_BANK("kdbank");

        private final String config;

        private static Flavor fromConfig(String config) {
            if (config != null) {
                for (Flavor flavor : Flavor.values()) {
                    if (!config.equals(flavor.config)) continue;
                    return flavor;
                }
                BLLoggerPlay.warning("Unknown branding:" + config);
            }
            return DEFAULT;
        }

        private Flavor(String config) {
            this.config = config;
        }
    }
}

