/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.server.ServerProperty;
import controllers.AppSync;
import controllers.Authenticator;
import controllers.Setup;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.UserAPI;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WebAuthn;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.yubikey.api.Oath;
import de.businesslogics.banking.yubikey.api.YubikeyWrapper;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.HexTool;
import io.ebean.Query;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.WebAuthnData;
import models.YubikeyForm;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.html.settings.yubikeyAddOathView;
import views.html.settings.yubikeyAddView;
import views.html.settings.yubikeyAddWebAuthnView;
import views.html.settings.yubikeyRemoveView;
import views.html.settings.yubikeys;

@Security.Authenticated(value=Authenticator.class)
public final class Yubikeys
extends Controller {
    public static final WebAuthnManager WEB_AUTHN_MANAGER = WebAuthnManager.createNonStrictWebAuthnManager();
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    @Inject
    public Yubikeys(MessagesApi messagesApi, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
    }

    public Result indexFromTenant(Http.Request request, Integer userId, Integer tenantId) {
        return this.indexYubikeys(request, userId, tenantId);
    }

    public Result index(Http.Request request, Integer userId) {
        return this.indexYubikeys(request, userId, null);
    }

    public Result indexYubikeys(Http.Request request, Integer userId, Integer tenantId) {
        List list;
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        SortingHandler sorting = new SortingHandler(loggedInUser, Sorting.Table.YUBIKEYS);
        Query<Yubikey> query = this.query(keyUser, sorting.getSortingColumn(), sorting.isSortingAscending());
        sorting.computeForQuery(query);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            play.api.mvc.Call redirectTo = tenantId == null ? routes.Yubikeys.index(userId) : routes.Yubikeys.indexFromTenant(userId, tenantId);
            return GeneralUtils.handleLoadOverviewFailed(e, messages, loggedInUser, Sorting.Table.YUBIKEYS, (Call)redirectTo);
        }
        return Yubikeys.ok((Content)yubikeys.render(list, sorting, keyUser, tenantId, request, messages));
    }

    private User getKeyUser(User currentUser, Integer keyUserId) {
        if (currentUser == null) {
            return null;
        }
        if (keyUserId == null || keyUserId.equals(currentUser.getId())) {
            return currentUser;
        }
        return User.getByIdForTenants((int)keyUserId, (Collection)currentUser.getManageableTenants(), (boolean)currentUser.isAdmin());
    }

    private Query<Yubikey> query(User user, int sort, boolean asc) {
        Query query = Yubikey.findForUser((User)user, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.YUBIKEY, Yubikey.SecurityType.OATH, Yubikey.SecurityType.WEBAUTHN});
        switch (sort) {
            case 0: {
                if (asc) {
                    query = query.order("securityType asc");
                    break;
                }
                query = query.order("securityType desc");
                break;
            }
            case 1: {
                if (asc) {
                    query = query.order("publicId asc");
                    break;
                }
                query = query.order("publicId desc");
                break;
            }
            case 2: {
                if (asc) {
                    query = query.order("usedSince asc");
                    break;
                }
                query = query.order("usedSince desc");
                break;
            }
            case 3: {
                query = asc ? query.order("description asc") : query.order("description desc");
            }
        }
        return query;
    }

    public Result sort(Http.Request request, int sort, boolean asc, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(loggedInUser, Sorting.Table.YUBIKEYS).updateSort(sort, asc);
        return Yubikeys.redirect((Call)routes.Yubikeys.index(userId));
    }

    public Result pageSize(Http.Request request, int page, int pageSize, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(loggedInUser, Sorting.Table.YUBIKEYS).updatePage(page, pageSize);
        return Yubikeys.redirect((Call)routes.Yubikeys.index(userId));
    }

    public Result addTokenPage(Http.Request request, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        return Yubikeys.ok((Content)yubikeyAddView.render((Form<YubikeyForm>)this.formFactory.form(YubikeyForm.class), Yubikey.hasKeyOfType((User)keyUser, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.YUBIKEY, Yubikey.SecurityType.OATH}), keyUser, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> addToken(Http.Request request, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return CompletableFuture.supplyAsync(() -> Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0])), this.executionContext.current());
        }
        Form form = this.formFactory.form(YubikeyForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            boolean hasOtherKey = Yubikey.hasKeyOfType((User)keyUser, (Yubikey.SecurityType[])new Yubikey.SecurityType[0]);
            Form validatedForm = !form.hasErrors() ? ((YubikeyForm)form.get()).checkExistingOTP((Form<YubikeyForm>)form, keyUser, messages) : form;
            if (validatedForm.hasErrors()) {
                return Yubikeys.ok((Content)yubikeyAddView.render(validatedForm, hasOtherKey, keyUser, request, messages));
            }
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            String publicId = ((YubikeyForm)validatedForm.get()).addNewToken(keyUser, loggedInUser, errors, messages);
            if (!errors.isEmpty()) {
                for (ValidationError error : errors) {
                    validatedForm = validatedForm.withError(error);
                }
                return Yubikeys.ok((Content)yubikeyAddView.render(validatedForm, hasOtherKey, keyUser, request, messages));
            }
            String flashMessage = Yubikeys.getFlashMessageForKeyAdded(loggedInUser, keyUser, publicId, hasOtherKey, messages);
            if (Objects.equals(loggedInUser.getId(), keyUser.getId())) {
                return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("success", flashMessage);
            }
            return Yubikeys.redirect((Call)routes.Users.index()).flashing("success", flashMessage);
        }, this.executionContext.current());
    }

    public Result removeTokenPage(Http.Request request, int tokenId, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        Yubikey tokenToRemove = Yubikey.findForIdAndUser((int)tokenId, (User)keyUser);
        if (tokenToRemove == null) {
            return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("error", messages.at("yubikeys.noPermission", new Object[0]));
        }
        if (Authenticator.require2FAforLogin(keyUser) && Yubikey.findForUser((User)keyUser, (Yubikey.SecurityType[])new Yubikey.SecurityType[0]).findIds().size() < 2) {
            return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("error", messages.at("yubikeys.removeToken.forbiddenForLastKey", new Object[0]));
        }
        return Yubikeys.ok((Content)yubikeyRemoveView.render(tokenToRemove, (Form<YubikeyForm>)this.formFactory.form(YubikeyForm.class), keyUser, request, messages));
    }

    public Result editDescription(Http.Request request, int tokenId, Integer userId) {
        User keyUser;
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Map inputs = request.body().asFormUrlEncoded();
        String[] des = (String[])inputs.get("description");
        String description = "";
        if (des != null) {
            description = des[0];
        }
        if ((keyUser = this.getKeyUser(loggedInUser, userId)) == null) {
            return Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        Yubikey y = Yubikey.findForIdAndUser((int)tokenId, (User)keyUser);
        if (y == null) {
            return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("error", messages.at("yubikeys.noPermission", new Object[0]));
        }
        y.setDescription(description);
        y.save();
        String publicId = y.getDisplayString();
        return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("success", messages.at("yubikeys.updated", new Object[]{publicId}));
    }

    public CompletionStage<Result> removeToken(Http.Request request, int tokenId, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return CompletableFuture.supplyAsync(() -> Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0])), this.executionContext.current());
        }
        Form form = this.formFactory.form(YubikeyForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            Yubikey y = Yubikey.findForIdAndUser((int)tokenId, (User)keyUser);
            if (y == null) {
                return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("error", messages.at("yubikeys.noPermission", new Object[0]));
            }
            Form validatedForm = form;
            if (!form.hasErrors()) {
                DynamicForm dynamicForm;
                boolean verifiedWebAuthn = false;
                if (Yubikey.hasKeyOfType((User)loggedInUser, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.WEBAUTHN}) && !Boolean.parseBoolean((dynamicForm = this.formFactory.form().bindFromRequest(request, new String[0])).get("useOtp"))) {
                    if (Yubikeys.isWebAuthnInvalid(loggedInUser, dynamicForm, null)) {
                        validatedForm = form.withGlobalError("yubikeys.invalidwebauthn");
                    }
                    verifiedWebAuthn = true;
                }
                if (!verifiedWebAuthn) {
                    validatedForm = ((YubikeyForm)form.get()).checkExistingOTP((Form<YubikeyForm>)form, loggedInUser, messages);
                }
            }
            if (validatedForm.hasErrors()) {
                return Yubikeys.ok((Content)yubikeyRemoveView.render(y, (Form<YubikeyForm>)validatedForm, keyUser, request, messages));
            }
            if (Authenticator.require2FAforLogin(keyUser) && Yubikey.findForUser((User)keyUser, (Yubikey.SecurityType[])new Yubikey.SecurityType[0]).findIds().size() < 2) {
                return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("error", messages.at("yubikeys.removeToken.forbiddenForLastKey", new Object[0]));
            }
            return this.removeYubikey(y, keyUser, loggedInUser, messages);
        }, this.executionContext.current());
    }

    private Result removeYubikey(Yubikey y, User keyUser, User operator, Messages messages) {
        String publicId = y.getDisplayString();
        UserAPI.deleteTwoFactorTokenForUser((Yubikey)y, (User)keyUser, (User)operator, (BLLogger)BLLoggerAdmin.getLogger());
        String flashMessage = Yubikey.hasKeyOfType((User)keyUser, (Yubikey.SecurityType[])new Yubikey.SecurityType[0]) ? BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.tokenRemoved", (Object[])new Object[]{publicId}) : messages.at("yubikeys.tokenRemovedLast", new Object[]{publicId});
        return Yubikeys.redirect((Call)routes.Yubikeys.index(keyUser.getId())).flashing("success", flashMessage);
    }

    public Result addOathPage(Http.Request request, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        try {
            String token = Oath.createNewToken();
            String uri = AppSync.encryptForPage(Oath.getURI((String)token, (String)Setup.DISPLAY_NAME, (String)keyUser.getName()));
            return Yubikeys.ok((Content)yubikeyAddOathView.render((Form<YubikeyForm>)this.formFactory.form(YubikeyForm.class), token, uri, keyUser, request, messages));
        }
        catch (Exception e) {
            BLLoggerPlay.error("Could not build URI for Oath.", e);
            return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("error", messages.at("Could not build URI for Oath.", new Object[0]));
        }
    }

    public CompletionStage<Result> addOath(Http.Request request, String token, String encryptedURI, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return CompletableFuture.supplyAsync(() -> Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0])), this.executionContext.current());
        }
        Form form = this.formFactory.form(YubikeyForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors()) {
                return Yubikeys.ok((Content)yubikeyAddOathView.render((Form<YubikeyForm>)form, token, encryptedURI, keyUser, request, messages));
            }
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            boolean hasOtherKey = Yubikey.hasKeyOfType((User)keyUser, (Yubikey.SecurityType[])new Yubikey.SecurityType[0]);
            String id = ((YubikeyForm)form.get()).addNewOathToken(encryptedURI, (Form<YubikeyForm>)form, keyUser, loggedInUser, errors, messages.lang().locale());
            if (!errors.isEmpty()) {
                Form validatedForm = form;
                for (ValidationError error : errors) {
                    validatedForm = validatedForm.withError(error);
                }
                return Yubikeys.ok((Content)yubikeyAddOathView.render((Form<YubikeyForm>)validatedForm, token, encryptedURI, keyUser, request, messages));
            }
            String flashMessage = Yubikeys.getFlashMessageForKeyAdded(loggedInUser, keyUser, id, hasOtherKey, messages);
            if (Objects.equals(loggedInUser.getId(), keyUser.getId())) {
                return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("success", flashMessage);
            }
            return Yubikeys.redirect((Call)routes.Users.index()).flashing("success", flashMessage);
        }, this.executionContext.current());
    }

    public static String formatPrivateKey(String privateKey) {
        return Oath.formatToken((String)privateKey);
    }

    public static boolean validateOTP(String otp, User keyUser) {
        try {
            if (Oath.isValidOath((String)otp)) {
                return Oath.validate((String)otp, (User)keyUser);
            }
            return YubikeyWrapper.verifyForUser((String)otp, (User)keyUser);
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Invalid OTP for user " + keyUser.getName() + ".", e);
            return false;
        }
    }

    public static byte[] convertString(String in) {
        String[] s1 = in.split(",");
        byte[] bytes = new byte[s1.length];
        for (int i = 0; i < s1.length; ++i) {
            bytes[i] = Integer.valueOf(s1[i]).byteValue();
        }
        return bytes;
    }

    public static String checkWebAuthnRegistration(Http.Request request, User keyUser, byte[] challange) throws IOException {
        Map formData = request.body().asFormUrlEncoded();
        byte[] attestationObject = Yubikeys.convertString(((String[])formData.get("attestationObject"))[0]);
        byte[] clientDataJSON = Yubikeys.convertString(((String[])formData.get("clientDataJSON"))[0]);
        String credentialId = ((String[])formData.get("credentialId"))[0];
        RegistrationRequest registrationRequest = new RegistrationRequest(attestationObject, clientDataJSON);
        ServerProperty serverProperty = new ServerProperty(new Origin(Setup.WEBAUTHN_URL), Setup.WEBAUTHN_RPID, (Challenge)new DefaultChallenge(challange), null);
        RegistrationParameters registrationParameters = new RegistrationParameters(serverProperty, false);
        RegistrationData registrationData = WEB_AUTHN_MANAGER.parse(registrationRequest);
        WEB_AUTHN_MANAGER.validate(registrationData, registrationParameters);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bout);
        oos.writeObject(registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData());
        oos.close();
        Yubikey key = new Yubikey();
        key.setCredentialId(credentialId);
        key.setSecurityType(Yubikey.SecurityType.WEBAUTHN);
        key.setUsedSince(new Date(System.currentTimeMillis()));
        key.setUser(keyUser);
        DB.save((Object)key);
        WebAuthn webAuthnKey = new WebAuthn();
        webAuthnKey.setCounter(Long.valueOf(0L));
        webAuthnKey.setSerializedData(bout.toByteArray());
        webAuthnKey.setYubikey(key);
        webAuthnKey.setRpId(Setup.WEBAUTHN_RPID);
        DB.save((Object)webAuthnKey);
        if (request.attrs().containsKey(Security.USERNAME)) {
            User admin = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logYubikeyAdded(admin, keyUser, key);
        }
        return credentialId;
    }

    public Result addWebAuthn(Http.Request request, Integer userId) {
        String flashMessage;
        String flashKey;
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        byte[] tmp = User.getChallenge((User)keyUser);
        if (tmp == null) {
            return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing("error", messages.at("yubikeys.addWebauthnError", new Object[0]));
        }
        try {
            boolean hasOtherKey = Yubikey.hasKeyOfType((User)keyUser, (Yubikey.SecurityType[])new Yubikey.SecurityType[0]);
            String credentialId = Yubikeys.checkWebAuthnRegistration(request, keyUser, tmp);
            if (credentialId != null) {
                flashKey = "success";
                flashMessage = Yubikeys.getFlashMessageForKeyAdded(loggedInUser, keyUser, credentialId, hasOtherKey, messages);
            } else {
                flashKey = "error";
                flashMessage = messages.at("yubikeys.addWebauthnError", new Object[0]);
            }
        }
        catch (Exception e) {
            BLLoggerPlay.error("Could not validate WebAuthn key", e);
            flashKey = "error";
            flashMessage = messages.at("yubikeys.addWebauthnError", new Object[0]);
        }
        if (Objects.equals(loggedInUser.getId(), keyUser.getId())) {
            return Yubikeys.redirect((Call)routes.Yubikeys.index(userId)).flashing(flashKey, flashMessage);
        }
        return Yubikeys.redirect((Call)routes.Users.index()).flashing(flashKey, flashMessage);
    }

    public static String buildWebAuthnScript(User keyUser) {
        String challenge = User.createChallenge((User)keyUser);
        String userIdString = keyUser.getRandomId();
        if (userIdString == null) {
            byte[] id = new byte[64];
            SecureRandom r = new SecureRandom();
            r.nextBytes(id);
            keyUser.setRandomId(HexTool.toHex((byte[])id));
            DB.save((Object)keyUser);
            userIdString = keyUser.getRandomId();
        }
        StringBuilder userIdBuilder = new StringBuilder();
        for (Object b : (SecureRandom)HexTool.fromHex((String)userIdString)) {
            if (userIdBuilder.length() > 0) {
                userIdBuilder.append(',');
            }
            userIdBuilder.append(Byte.toUnsignedInt((byte)b));
        }
        ObjectNode json = Json.newObject();
        json.put("challenge", challenge);
        ObjectNode node = json.putObject("rp");
        node.put("name", Setup.PRODUCT_ID);
        node.put("id", Setup.WEBAUTHN_RPID);
        node = json.putObject("user");
        node.put("id", userIdBuilder.toString());
        node.put("name", keyUser.getName());
        node.put("displayName", keyUser.getName());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)json).getBytes(StandardCharsets.US_ASCII));
    }

    public static boolean isWebAuthnInvalid(User user, DynamicForm form, List<WebAuthn> usedKey) {
        String credentialId;
        byte[] signature;
        byte[] clientDataJSON;
        byte[] authenticatorData = Yubikeys.convertString(form.get("authenticatorData"));
        return !WebAuthnData.checkWebAuthn(user, authenticatorData, clientDataJSON = Yubikeys.convertString(form.get("clientDataJSON")), signature = Yubikeys.convertString(form.get("signature")), credentialId = form.get("credentialId"), User.getChallenge((User)user), usedKey);
    }

    public Result addWebAuthnPage(Http.Request request, Integer userId) {
        User loggedInUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User keyUser = this.getKeyUser(loggedInUser, userId);
        if (keyUser == null) {
            return Yubikeys.redirect((Call)routes.Application.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        return Yubikeys.ok((Content)yubikeyAddWebAuthnView.render(Yubikeys.buildWebAuthnScript(keyUser), keyUser, false, null, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public static String getFlashMessageForKeyAdded(User operatingUser, User keyUser, String keyID, boolean hasOtherKeyOfType, Messages messages) {
        if (!Objects.equals(keyUser.getId(), operatingUser.getId())) {
            return messages.at("yubikeys.tokenAddedForUser", new Object[]{keyID, keyUser.getName()});
        }
        if (hasOtherKeyOfType) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.tokenAddedAnotherToken", (Object[])new Object[]{keyID});
        }
        return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.tokenAddedFirst", (Object[])new Object[]{keyID});
    }
}

