/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.DatabaseConnection;
import controllers.Setup;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.LicenseHandler;
import controllers.util.PasswordKeyEncryptionHandler;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.AbstractLicenseHandler;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankUserCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.UserAPI;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.LoginSession;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.BLLogger;
import io.ebean.Expression;
import io.ebean.Query;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.SimpleTextForm;
import models.UserForm;
import models.UserResetPasswordForm;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.settings.edituser;
import views.html.settings.newBankAdmin;
import views.html.settings.newuser;
import views.html.settings.newusertenantselect;
import views.html.settings.users;

@Security.Authenticated(value=AuthenticatorFor.Settings.class)
public final class Users
extends Controller {
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    public static Seq<Tuple2<String, String>> getAccountOptions(Integer userId, Account account, Messages messages) {
        boolean isNewUser;
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)String.valueOf(true), (Object)messages.at("users.accountpermission.yes", new Object[0])));
        result.add(Scala.Tuple((Object)String.valueOf(false), (Object)messages.at("users.accountpermission.no", new Object[0])));
        User user = userId != null ? (User)DB.find(User.class, (Object)userId) : null;
        boolean bl = isNewUser = user == null;
        if (isNewUser) {
            result.add(Scala.Tuple((Object)"default", (Object)(messages.at("users.accountpermission.fromprofile", new Object[0]) + " (" + BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.htdNotKnown", (Object[])new Object[0]) + ")")));
        } else if (account.getType() == Account.Type.HTD && !user.isLocalUser()) {
            ApOverwrite apOverwrite;
            BankUser bankUser = BankUser.findBankUser((BankSettings)account.getBank(), (User)user);
            String defaultValue = bankUser == null ? BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.htdNotKnown", (Object[])new Object[0]) : (BankUser.UserState.READY != bankUser.getState() ? BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.htdNotKnown", (Object[])new Object[0]) : (null != (apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bankUser, (Account)account)) ? (apOverwrite.isPreviousEnabled() ? messages.at("users.accountpermission.yes", new Object[0]) : messages.at("users.accountpermission.no", new Object[0])) : (AccountPermission.findAccountPermissionForBank((BankUser)BankUser.findBankUser((BankSettings)account.getBank(), (User)user), (Account)account) == null ? messages.at("users.accountpermission.no", new Object[0]) : messages.at("users.accountpermission.yes", new Object[0]))));
            result.add(Scala.Tuple((Object)"default", (Object)(messages.at("users.accountpermission.fromprofile", new Object[0]) + " (" + defaultValue + ")")));
        }
        return Scala.toSeq(result);
    }

    public static boolean isNumberOfUsersExceeded(User user) {
        try {
            String numberString = LicenseHandler.getInstance().getLicenseProperties(user).getProperty("NUMBER_OF_USERS");
            if (numberString == null) {
                return false;
            }
            int allowedNumber = Integer.parseInt(numberString);
            if (allowedNumber <= 0) {
                return false;
            }
            return allowedNumber <= User.getNonLocalUserCountByWebLicense((License)user.getWebLicense());
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to read license information!", e);
            return true;
        }
    }

    public static boolean isNumberOfUsersExceeded(Tenant tenant) {
        if (tenant.getUserCount() == null) {
            return false;
        }
        if (tenant.getUserCount() < 0) {
            return false;
        }
        int userCount = User.getNonLocalUserCountForTenant((Tenant)tenant, (boolean)true);
        return tenant.getUserCount() <= userCount;
    }

    public static boolean isNumberOfUsersExceededForAny(List<Tenant> tenants2) {
        for (Tenant tenant : tenants2) {
            if (!Users.isNumberOfUsersExceeded(tenant)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumberOfUsersExceededForAll(List<Tenant> tenants2) {
        for (Tenant tenant : tenants2) {
            if (Users.isNumberOfUsersExceeded(tenant)) continue;
            return false;
        }
        return true;
    }

    public static List<Tenant> getTenantsWithNumberNotExceeded(User user) {
        ArrayList<Tenant> tenants2 = new ArrayList<Tenant>();
        for (Tenant tenant : user.getManageableTenants()) {
            if (Users.isNumberOfUsersExceeded(tenant)) continue;
            tenants2.add(tenant);
        }
        return tenants2;
    }

    @Inject
    public Users(MessagesApi messagesApi, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
    }

    public Result index(Http.Request request) {
        HashMap<String, String> flashMap;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (Users.isNotManagingUser(messages, user, flashMap = new HashMap<String, String>())) {
            return Users.redirect((Call)routes.Application.index());
        }
        UserResetPasswordForm userResetPasswordForm = new UserResetPasswordForm();
        userResetPasswordForm.lockBankAccess = true;
        Form resetPasswordForm = this.formFactory.form(UserResetPasswordForm.class).fill((Object)userResetPasswordForm);
        return this.index(request, user, (Form<UserResetPasswordForm>)resetPasswordForm, null);
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        HashMap<String, String> flashMap;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (Users.isNotManagingUser(messages, user, flashMap = new HashMap<String, String>())) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        new SortingHandler(user, Sorting.Table.USERS).updateSort(sort, ascending);
        return Users.redirect((Call)routes.Users.index());
    }

    public Result switchTenant(Http.Request request, Integer tenantId) {
        HashMap<String, String> flashMap;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (Users.isNotManagingUser(messages, user, flashMap = new HashMap<String, String>())) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        new SortingHandler(user, Sorting.Table.USERS).setProperty("TENANT", tenantId != null ? tenantId.toString() : null);
        return Users.redirect((Call)routes.Users.index());
    }

    public Result indexWithPage(Http.Request request, int pageNumber, int pageSize) {
        HashMap<String, String> flashMap;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (Users.isNotManagingUser(messages, user, flashMap = new HashMap<String, String>())) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        new SortingHandler(user, Sorting.Table.USERS).updatePage(pageNumber, pageSize);
        return Users.redirect((Call)routes.Users.index());
    }

    public CompletionStage<Result> exportOverview(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.USERS);
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.USERS);
        Expression filterExpression = null;
        if (filter.isFilterActive()) {
            filterExpression = User.getFilterExpression((String)filter.getFilterText());
        }
        Tenant selectedTenant = null;
        try {
            selectedTenant = Tenant.findById((int)Integer.parseInt(sorting.getProperty("TENANT", "-1")), (User)user, (boolean)true);
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Invalid value for tenant in users table!", e);
        }
        List tenantList = selectedTenant != null ? Collections.singletonList(selectedTenant) : user.getManageableTenants();
        Query query = User.getQueryForTenants((Collection)tenantList, (boolean)user.isAdmin(), (Expression)filterExpression);
        ArrayList users2 = new ArrayList(query.findList());
        ArrayList banks2 = new ArrayList(BankSettings.findBanksForTenants((List)tenantList));
        return CompletableFuture.supplyAsync(() -> {
            File exportFile;
            try {
                exportFile = Util.createTempFile((String)"useroverview", (String)".csv", (boolean)true);
                new BankUserCsvExport(messages.lang().locale(), users2).write(exportFile, (Iterable)banks2);
            }
            catch (IOException e) {
                return Users.redirect((Call)routes.Users.index()).flashing("HTMLerror", messages.at("error.failedcsvexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
            try {
                return GeneralUtils.supplyWorkspaceFile(exportFile, true, false).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(messages.at("users.overview", new Object[0]) + ".csv"));
            }
            catch (IOException | GeneralSecurityException e) {
                return Users.redirect((Call)routes.Users.index()).flashing("HTMLerror", messages.at("desoverview.exportfailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public Result index_filter(Http.Request request, boolean active) {
        Users.setupUsersFilter(request, active, this.formFactory);
        return Users.redirect((Call)routes.Users.index());
    }

    public static void setupUsersFilter(Http.Request request, boolean filterActive, FormFactory formFactory) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.USERS);
        if (filterActive) {
            Form filterForm = formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
            String filterText = ((SimpleTextForm)filterForm.get()).text;
            if (filterText != null && !filterText.isEmpty()) {
                filter.setFilterText(filterText);
                filter.setFilterActive(true);
            } else {
                filter.setFilterText(null);
                filter.setFilterActive(false);
            }
        } else {
            filter.setFilterActive(false);
        }
        filter.save();
    }

    public Result create(Http.Request request) {
        return this.create(request, false);
    }

    public Result createImport(Http.Request request) {
        return this.create(request, true);
    }

    public Result create(Http.Request request, boolean toBeImported) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        DatabasePreferenceStore pref = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (!pref.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION)) {
            flashMap.put("error", messages.at("users.error.noPermissionToCreate", new Object[0]));
            return Users.redirect((Call)routes.Users.index()).flashing(flashMap);
        }
        if (Users.isNotManagingUser(messages, operator, flashMap)) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        if (operator.getManageableTenants().size() > 1) {
            Tenant t;
            DynamicForm form = this.formFactory.form();
            int tenantId = Integer.parseInt(new SortingHandler(operator, Sorting.Table.USERS).getProperty("TENANT", "-1"));
            Tenant selectedTenant = Tenant.findById((int)tenantId, (User)operator, (boolean)true);
            if (selectedTenant == null && tenantId != -1 && operator.isAdmin() && (t = Tenant.findById((int)tenantId)) != null) {
                selectedTenant = t;
            }
            if (selectedTenant != null) {
                form = form.fill(Collections.singletonMap("tenant_" + selectedTenant.getId(), true));
            }
            return Users.ok((Content)newusertenantselect.render((Form<DynamicForm.Dynamic>)form, toBeImported, toBeImported ? Users.getTenantsWithNumberNotExceeded(operator) : operator.getManageableTenants(), request, messages));
        }
        return this.create(request, operator, operator.getManageableTenants(), toBeImported);
    }

    public Result createForTenants(Http.Request request) {
        return this.createOrImportForTenants(request, false);
    }

    public Result importForTenants(Http.Request request) {
        return this.createOrImportForTenants(request, true);
    }

    public Result createOrImportForTenants(Http.Request request, boolean toBeImported) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        DatabasePreferenceStore pref = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (!pref.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION)) {
            flashMap.put("error", messages.at("users.error.noPermissionToCreate", new Object[0]));
            return Users.redirect((Call)routes.Users.index()).flashing(flashMap);
        }
        if (Users.isNotManagingUser(messages, operator, flashMap)) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        DynamicForm form = this.formFactory.form().bindFromRequest(request, new String[0]);
        ArrayList<Tenant> tenants2 = new ArrayList<Tenant>();
        for (Tenant t : operator.getManageableTenants()) {
            if (!"true".equals(form.get("tenant_" + t.getId()))) continue;
            tenants2.add(t);
        }
        if (tenants2.isEmpty()) {
            return Users.ok((Content)newusertenantselect.render((Form<DynamicForm.Dynamic>)form.withGlobalError("users.selectTenants.atLeastOne"), toBeImported, toBeImported ? Users.getTenantsWithNumberNotExceeded(operator) : operator.getManageableTenants(), request, messages));
        }
        return this.create(request, operator, tenants2, toBeImported);
    }

    public Result createBankAdmin(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        DatabasePreferenceStore pref = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (!operator.isAdmin()) {
            flashMap.put("error", messages.at("users.restricted", new Object[0]));
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        if (!pref.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION)) {
            flashMap.put("error", messages.at("users.error.noPermissionToCreate", new Object[0]));
            return Users.redirect((Call)routes.Users.index()).flashing(flashMap);
        }
        UserForm userForm = UserForm.getDefaults();
        Form form = this.formFactory.form(UserForm.class).fill((Object)userForm);
        return Users.ok((Content)newBankAdmin.render((Form<UserForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result cloneUser(Http.Request request) {
        String id = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return this.cloneUser(request, Integer.parseInt(id));
    }

    public Result cloneUserinDetail(Http.Request request, int id) {
        return this.cloneUser(request, id);
    }

    public Result cloneUser(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canModifyAdmins = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (Users.isNotManagingUser(messages, operator, flashMap)) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        User toEdit = User.getByIdForTenants((int)id, (Collection)operator.getManageableTenants(), (boolean)operator.isAdmin());
        if (toEdit == null) {
            return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        if (toEdit.isAdmin() && !canModifyAdmins) {
            return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.error.noPermissionToModify", new Object[]{toEdit.getName()}));
        }
        UserForm userForm = UserForm.fill(toEdit);
        Form form = this.formFactory.form(UserForm.class).fill((Object)userForm);
        Object displayName = toEdit.getName();
        boolean uniqueName = false;
        int pos = 1;
        do {
            User user;
            if ((user = User.getUser((String)displayName)) != null) {
                displayName = toEdit.getName() + "." + pos++;
                continue;
            }
            uniqueName = true;
        } while (!uniqueName);
        ((UserForm)form.get()).name = displayName;
        ((UserForm)form.get()).subscriberIDs = new HashMap<Integer, String>();
        return Users.ok((Content)newuser.render((Form<UserForm>)form, false, toEdit.getTenants(), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result saveBankAdmin(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        DatabasePreferenceStore pref = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (!operator.isAdmin()) {
            flashMap.put("error", messages.at("users.restricted", new Object[0]));
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        if (!pref.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION)) {
            flashMap.put("error", messages.at("users.error.noPermissionToCreate", new Object[0]));
            return Users.redirect((Call)routes.Users.index()).flashing(flashMap);
        }
        Form form = this.formFactory.form(UserForm.class).bindFromRequest(request, new String[0]);
        List<Tenant> defaultTenant = Collections.singletonList(Tenant.getDefaultTenant());
        if (!form.hasErrors()) {
            form = ((UserForm)form.get()).validate((Form<UserForm>)form, operator, null, defaultTenant, messages.lang().toLocale());
        }
        if (form.hasErrors()) {
            return Users.ok((Content)newBankAdmin.render((Form<UserForm>)form, request, messages));
        }
        UserForm validatedForm = (UserForm)form.get();
        validatedForm.isAdmin = true;
        validatedForm.localUser = true;
        validatedForm.banking_allowAWVRecording = false;
        validatedForm.banking_allowFetchFiles = false;
        validatedForm.banking_allowFolderFiles = false;
        validatedForm.banking_allowPaymentRecording = false;
        validatedForm.banking_allowSendFiles = false;
        validatedForm.banking_allowVEU = false;
        validatedForm.banking_allowViewAccountStatements = false;
        validatedForm.banking_allowSynchronisation = false;
        validatedForm.banking_allowBanksAndAccounts = false;
        validatedForm.banking_allowNotifications = false;
        if (validatedForm.roleId == UserForm.SANTANDER_ROLES.BANK_ADMIN.ordinal()) {
            validatedForm.banking_allowUserCreation = true;
            validatedForm.banking_allowTenantCreation = true;
        } else if (validatedForm.roleId == UserForm.SANTANDER_ROLES.HOTLINE_USER.ordinal()) {
            validatedForm.banking_allowUserCreation = false;
            validatedForm.banking_allowTenantCreation = false;
        } else if (validatedForm.roleId == UserForm.SANTANDER_ROLES.CUSTOMER_MANAGER.ordinal()) {
            validatedForm.banking_allowUserCreation = false;
            validatedForm.banking_allowTenantCreation = true;
        } else {
            validatedForm.banking_allowUserCreation = true;
            validatedForm.banking_allowTenantCreation = true;
        }
        User newUser = new User();
        try {
            validatedForm.store(operator, newUser, operator.getWebLicense(), defaultTenant);
            return Users.redirect((Call)routes.Users.index()).flashing("newUser", newUser.getName());
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to create bank user!", e);
            form = form.withGlobalError(messages.at("users.failedtocreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            return Users.ok((Content)newBankAdmin.render((Form<UserForm>)form, request, messages));
        }
    }

    private Result create(Http.Request request, User operator, List<Tenant> tenants2, boolean toBeImported) {
        UserForm userForm = UserForm.getDefaults();
        if (Users.isNumberOfUsersExceeded(operator) || Users.isNumberOfUsersExceededForAny(tenants2)) {
            userForm.localUser = true;
        }
        for (BankSettings bank : BankSettings.findBanksForTenants(tenants2)) {
            userForm.banks.put(bank.getBankId(), true);
            for (Account account : Account.findAccountsForBank((BankSettings)bank)) {
                userForm.accounts.put(account.getId(), "default");
            }
        }
        Form form = this.formFactory.form(UserForm.class).fill((Object)userForm);
        if (toBeImported) {
            ((UserForm)form.get()).toBeImported = true;
        }
        if (Utils.getBranding().setLocalUserAsDefault() && operator.isTenantAdmin()) {
            ((UserForm)form.get()).localUser = true;
        }
        return Users.ok((Content)newuser.render((Form<UserForm>)form, toBeImported, tenants2, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result edit(Http.Request request, int id, String openTab) {
        return this.editUser(request, id, false, openTab);
    }

    public Result editMode(Http.Request request, int id, String openTab) {
        return this.editUser(request, id, true, openTab);
    }

    public Result editUser(Http.Request request, int id, boolean inEditMode, String openTab) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canModifyAdmins = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (Users.isNotManagingUser(messages, operator, flashMap)) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        User toEdit = User.getByIdForTenants((int)id, (Collection)operator.getManageableTenants(), (boolean)operator.isAdmin());
        if (toEdit == null) {
            return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        if (toEdit.isAdmin() && !canModifyAdmins) {
            return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.error.noPermissionToModify", new Object[]{toEdit.getName()}));
        }
        UserForm userForm = UserForm.fill(toEdit);
        Form form = this.formFactory.form(UserForm.class).fill((Object)userForm);
        UserResetPasswordForm userResetPasswordForm = new UserResetPasswordForm();
        userResetPasswordForm.lockBankAccess = true;
        userResetPasswordForm.userId = id;
        Form resetPasswordForm = this.formFactory.form(UserResetPasswordForm.class).fill((Object)userResetPasswordForm);
        return Users.ok((Content)edituser.render((Form<UserForm>)form, (Form<UserResetPasswordForm>)resetPasswordForm, toEdit, inEditMode, openTab, request, messages));
    }

    public Result saveNew(Http.Request request, String tenantIds) {
        return this.saveNewOrImport(request, tenantIds, false);
    }

    public Result saveImport(Http.Request request, String tenantIds) {
        return this.saveNewOrImport(request, tenantIds, true);
    }

    public Result saveNewOrImport(Http.Request request, String tenantIds, boolean toBeImported) {
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        DatabasePreferenceStore pref = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (!pref.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION)) {
            flashMap.put("error", messages.at("users.error.noPermissionToCreate", new Object[0]));
            return Users.redirect((Call)routes.Users.index()).flashing(flashMap);
        }
        if (Users.isNotManagingUser(messages, operator, flashMap)) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        List tenants2 = Tenant.findByIds(GeneralUtils.getSelectionIds(tenantIds), (User)operator, (boolean)true);
        Form form = this.formFactory.form(UserForm.class).bindFromRequest(request, new String[0]);
        if ((Users.isNumberOfUsersExceeded(operator) || Users.isNumberOfUsersExceededForAny(tenants2)) && !Boolean.parseBoolean((String)form.rawData().get("localUser"))) {
            return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.error.numberexceeded", new Object[0]));
        }
        if (!form.hasErrors()) {
            form = ((UserForm)form.get()).validate((Form<UserForm>)form, operator, null, tenants2, messages.lang().toLocale());
        }
        if (form.hasErrors()) {
            return Users.ok((Content)newuser.render((Form<UserForm>)form, toBeImported, tenants2, request, messages));
        }
        User newUser = new User();
        newUser.setAdmin(false);
        if (toBeImported) {
            newUser.setSecurityMedium(User.SecurityMedium.IMPORT);
        }
        try {
            ((UserForm)form.get()).store(operator, newUser, operator.getWebLicense(), tenants2);
            if (toBeImported) {
                return Users.redirect((Call)routes.Users.index()).flashing("success", messages.at("users.import.created", new Object[0]));
            }
            return Users.redirect((Call)routes.Users.index()).flashing("newUser", newUser.getName());
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to update user!", e);
            form = form.withGlobalError(messages.at("users.failedtocreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            return Users.ok((Content)newuser.render((Form<UserForm>)form, toBeImported, tenants2, request, messages));
        }
    }

    public Result update(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canModifyAdmins = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (Users.isNotManagingUser(messages, operator, flashMap)) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        User toUpdate = User.getByIdForTenants((int)id, (Collection)operator.getManageableTenants(), (boolean)operator.isAdmin());
        if (toUpdate == null) {
            return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        if (toUpdate.isAdmin() && !canModifyAdmins) {
            return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.error.noPermissionToModify", new Object[]{toUpdate.getName()}));
        }
        Form form = this.formFactory.form(UserForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            form = ((UserForm)form.get()).validate((Form<UserForm>)form, operator, toUpdate, null, messages.lang().toLocale());
        }
        if (form.hasErrors()) {
            UserResetPasswordForm userResetPasswordForm = new UserResetPasswordForm();
            userResetPasswordForm.lockBankAccess = true;
            userResetPasswordForm.userId = id;
            Form resetPasswordForm = this.formFactory.form(UserResetPasswordForm.class).fill((Object)userResetPasswordForm);
            return Users.ok((Content)edituser.render((Form<UserForm>)form, (Form<UserResetPasswordForm>)resetPasswordForm, toUpdate, true, UserForm.Tab.GENERAL.label, request, messages));
        }
        List<Tenant> tenants2 = null;
        if (toUpdate.getTenants().isEmpty()) {
            tenants2 = Collections.singletonList(Tenant.getDefaultTenant());
        }
        try {
            ((UserForm)form.get()).store(operator, toUpdate, null, tenants2);
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (operator.equals(toUpdate) && !operator.getName().equals(toUpdate.getName())) {
                attrs.put("username", toUpdate.getName());
            }
            return Users.redirect((Call)routes.Users.index()).flashing("success", messages.at("users.updated", new Object[0])).addingToSession(request, attrs);
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to update user!", e);
            form = form.withGlobalError(messages.at("users.failedtoupdate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            UserResetPasswordForm userResetPasswordForm = new UserResetPasswordForm();
            userResetPasswordForm.lockBankAccess = true;
            userResetPasswordForm.userId = id;
            Form resetPasswordForm = this.formFactory.form(UserResetPasswordForm.class).fill((Object)userResetPasswordForm);
            return Users.ok((Content)edituser.render((Form<UserForm>)form, (Form<UserResetPasswordForm>)resetPasswordForm, toUpdate, true, UserForm.Tab.GENERAL.label, request, messages));
        }
    }

    public Result delete(Http.Request request) {
        return this.deleteUsers(request, null);
    }

    public Result deleteUser(Http.Request request, Integer id) {
        return this.deleteUsers(request, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result deleteUsers(Http.Request request, Integer userId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canDeleteAdmins = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (Users.isNotManagingUser(messages, user, flashMap)) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        String userIds = userId != null ? userId.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        if (userIds != null && !userIds.isEmpty()) {
            List<Integer> ids = GeneralUtils.getSelectionIds(userIds);
            try {
                String userName = null;
                int deletedUsers = 0;
                for (Integer id : ids) {
                    File keyDirectory;
                    if (id.equals(user.getId())) {
                        flashMap.put("warning", messages.at("users.noselfdeletion", new Object[0]));
                        continue;
                    }
                    User toDelete = User.getByIdForTenants((int)id, (Collection)user.getManageableTenants(), (boolean)user.isAdmin());
                    if (toDelete == null) continue;
                    if (toDelete.isAdmin() && !canDeleteAdmins) {
                        Utils.addToFlash(flashMap, "error", messages.at("users.error.noPermissionToDelete", new Object[]{toDelete.getName()}));
                        continue;
                    }
                    if (toDelete.getKeyDirectory() != null && (keyDirectory = new File(toDelete.getKeyDirectory().replaceAll("[\\\\/]", Matcher.quoteReplacement(File.separator)))).isDirectory() && !keyDirectory.renameTo(new File(keyDirectory.getParent(), "BACKUP_" + toDelete.getName()))) {
                        BLLoggerPlay.warning("Failed to create a backup for the key directory of the user " + toDelete.getName());
                    }
                    userName = toDelete.getName();
                    try (Transaction t = DB.beginTransaction();){
                        toDelete.delete(Setup.DELETE_USER_NAME);
                        t.commit();
                    }
                    ++deletedUsers;
                    new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logUserDeleted(user, toDelete);
                }
                if (deletedUsers == 1) {
                    Utils.addToFlash(flashMap, "success", messages.at("users.deleted.success.singular", new Object[]{userName}));
                } else {
                    String flashType = deletedUsers == 0 ? "warning" : "success";
                    Utils.addToFlash(flashMap, flashType, messages.at("users.deleted.success.plural", new Object[]{deletedUsers}));
                }
                if (deletedUsers < ids.size()) {
                    Utils.addToFlash(flashMap, "error", messages.at("users.deleted.failed", new Object[]{ids.size() - deletedUsers}));
                }
            }
            finally {
                DB.endTransaction();
            }
        }
        return Users.redirect((Call)routes.Users.index()).flashing(flashMap);
    }

    public CompletionStage<Result> updateLicense(Http.Request request, int userId, String openTab) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canModifyAdmins = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION);
        return CompletableFuture.supplyAsync(() -> {
            String flashMessage;
            String flashKey;
            User toUpdate = (User)DB.find(User.class, (Object)userId);
            if (toUpdate == null) {
                return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.unknown", new Object[0]));
            }
            if (toUpdate.isAdmin() && !canModifyAdmins) {
                return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.error.noPermissionToModify", new Object[]{toUpdate.getName()}));
            }
            if (toUpdate.getWebLicense() == null || toUpdate.isLocalUser()) {
                return Users.redirect((Call)routes.Users.edit(userId, openTab)).flashing("error", messages.at("users.nolicense", new Object[0]));
            }
            AbstractLicenseHandler.LicenseCheckResult result = LicenseHandler.getInstance().downloadLicense(toUpdate.getWebLicense());
            if (result != AbstractLicenseHandler.LicenseCheckResult.OK) {
                flashKey = "error";
                flashMessage = result.getMessage(messages.lang().locale());
            } else {
                flashKey = "success";
                flashMessage = messages.at("users.license.updated", new Object[0]);
            }
            return Users.redirect((Call)routes.Users.edit(userId, openTab)).flashing(flashKey, flashMessage);
        }, this.executionContext.current());
    }

    public Result resetErrorCounter(Http.Request request, int userId, boolean redirectToEditUserPage, String openTab) {
        return this.resetErrorCounter(request, userId, (Call)(redirectToEditUserPage ? routes.Users.edit(userId, openTab) : routes.Users.index()));
    }

    private Result resetErrorCounter(Http.Request request, int userId, Call redirectTo) {
        HashMap<String, String> flashMap;
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (Users.isNotManagingUser(messages, operator, flashMap = new HashMap<String, String>())) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        User toReset = User.getByIdForTenants((int)userId, (Collection)operator.getManageableTenants(), (boolean)operator.isAdmin());
        if (toReset == null) {
            Utils.addToFlash(flashMap, "error", messages.at("users.unknown", new Object[0]));
            return Users.redirect((Call)routes.Users.index()).flashing(flashMap);
        }
        boolean loginErrorReset = toReset.getErrorCounter() > 1;
        boolean signErrorReset = toReset.getErrorSignCounter() > 1;
        toReset.resetLoginErrorCounter();
        toReset.resetSignatureErrorCounter();
        new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logUserResetErrorCounter(operator, toReset);
        if (loginErrorReset) {
            Utils.addToFlash(flashMap, "success", messages.at("users.loginErrorCounterReset", new Object[]{toReset.getName(), toReset.getRemainingPasswordTries()}));
        }
        if (signErrorReset) {
            Utils.addToFlash(flashMap, "success", messages.at("users.signErrorCounterReset", new Object[]{toReset.getName(), toReset.getRemainingSignatureTries()}));
        }
        return Users.redirect((Call)redirectTo).flashing(flashMap);
    }

    public Result lockLogin(Http.Request request, boolean redirectToEditUserPage, String openTab) {
        HashMap<String, String> flashMap;
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (Users.isNotManagingUser(messages, operator, flashMap = new HashMap<String, String>())) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        String userIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = GeneralUtils.getSelectionIds(userIds);
        ids.remove(operator.getId());
        int nSuccessful = 0;
        String userName = null;
        AdminLogger adminLogger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        for (Integer userId : ids) {
            User toLock = User.getByIdForTenants((int)userId, (Collection)operator.getManageableTenants(), (boolean)operator.isAdmin());
            if (toLock == null) continue;
            toLock.lock();
            adminLogger.logUserLocked(operator, toLock);
            userName = toLock.getName();
            ++nSuccessful;
        }
        if (nSuccessful == 1) {
            Utils.addToFlash(flashMap, "success", messages.at("users.locklogin.success.singular", new Object[]{userName}));
        } else {
            String flashType = nSuccessful == 0 ? "warning" : "success";
            Utils.addToFlash(flashMap, flashType, messages.at("users.locklogin.success.plural", new Object[]{nSuccessful}));
        }
        if (nSuccessful < ids.size()) {
            Utils.addToFlash(flashMap, "error", messages.at("users.locklogin.failed", new Object[]{ids.size() - nSuccessful}));
        }
        play.api.mvc.Call redirectTo = ids.size() == 1 && redirectToEditUserPage ? routes.Users.edit(ids.get(0), openTab) : routes.Users.index();
        return Users.redirect((Call)redirectTo).flashing(flashMap);
    }

    public Result resetUser(Http.Request request, boolean redirectToEditUserPage, String openTab) {
        User userToReset;
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form<UserResetPasswordForm> form = this.formFactory.form(UserResetPasswordForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            userToReset = User.getByIdForTenants((int)((UserResetPasswordForm)form.get()).userId, (Collection)operatingUser.getManageableTenants(), (boolean)operatingUser.isAdmin());
            if (userToReset == null) {
                return Users.redirect((Call)routes.Users.index()).flashing("error", messages.at("users.unknown", new Object[0])).flashing(flashMap);
            }
            form = ((UserResetPasswordForm)form.get()).validate(form, userToReset, messages.lang().toLocale());
        } else {
            userToReset = null;
        }
        if (userToReset == null || form.hasErrors()) {
            List<Integer> selection = userToReset != null ? Collections.singletonList(userToReset.getId()) : null;
            return this.index(request, operatingUser, form, selection).flashing(flashMap);
        }
        BLLoggerPlay.info("Resetting user " + userToReset.getName());
        play.api.mvc.Call redirectTo = redirectToEditUserPage ? routes.Users.edit(userToReset.getId(), openTab) : routes.Users.index();
        if (Users.isNotManagingUser(messages, operatingUser, flashMap)) {
            return Users.redirect((Call)routes.Application.index()).flashing(flashMap);
        }
        if (operatingUser.getId().equals(userToReset.getId())) {
            return Users.redirect((Call)redirectTo).flashing("error", messages.at("users.resetuser.sameuser", new Object[0])).flashing(flashMap);
        }
        try {
            byte[] newEncryptionData = EncryptData.getInstance().copyKey((EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(((UserResetPasswordForm)form.get()).newPassword.toCharArray()));
            List failedBanks = UserAPI.resetUser((User)operatingUser, (User)userToReset, (byte[])newEncryptionData, (BLLogger)BLLoggerPlay.getLogger(), (BLLogger)BLLoggerAdmin.getLogger(), (UserAPI.LockUserInBanks)(((UserResetPasswordForm)form.get()).lockBankAccess ? this::lockUserAtBanks : null), (boolean)((UserResetPasswordForm)form.get()).resetYubikeys);
            if (userToReset.isLocalUser()) {
                flashMap.put("success", messages.at("users.resetuser.done.local", new Object[]{userToReset.getName()}));
            } else {
                if (!failedBanks.isEmpty()) {
                    StringBuilder banks2 = new StringBuilder();
                    for (BankSettings b : failedBanks) {
                        if (!banks2.isEmpty()) {
                            banks2.append(", ");
                        }
                        banks2.append(b.getDisplayName());
                    }
                    flashMap.put("warning", messages.at("users.resetuser.lockUser.failed", new Object[]{failedBanks.size(), banks2.toString(), userToReset.getName()}));
                }
                if (((UserResetPasswordForm)form.get()).lockBankAccess) {
                    flashMap.put("success", messages.at("users.resetuser.done", new Object[]{userToReset.getName()}));
                } else {
                    flashMap.put("success", messages.at("users.resetuser.done.local", new Object[]{userToReset.getName()}));
                }
            }
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logUserReset(operatingUser, userToReset);
        }
        catch (Exception e) {
            BLLoggerPlay.getLogger().logError("error resetting user", (Throwable)e);
            flashMap.put("error", messages.at("users.resetuser.failed", new Object[0]));
        }
        return Users.redirect((Call)redirectTo).flashing(flashMap);
    }

    private List<BankSettings> lockUserAtBanks(User user) {
        ArrayList<BankSettings> list = new ArrayList<BankSettings>();
        UserResetPasswordForm.lockUserInBanks(user, list);
        return list;
    }

    public static boolean isNotManagingUser(Messages messages, User user, Map<String, String> flashMap) {
        if (user == null || user.getManageableTenants().isEmpty()) {
            flashMap.put("error", messages.at("users.restricted", new Object[0]));
            return true;
        }
        return false;
    }

    private Result index(Http.Request request, User user, Form<UserResetPasswordForm> resetPasswordForm, List<Integer> selectedUsers) {
        List list;
        String orderBy;
        String sortColumnDirection;
        List<Tenant> tenantList;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.USERS);
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.USERS);
        Expression filterExpression = null;
        if (filter.isFilterActive()) {
            filterExpression = User.getFilterExpression((String)filter.getFilterText());
        }
        int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
        Tenant selectedTenant = null;
        try {
            selectedTenant = Tenant.findById((int)tenantId, (User)user, (boolean)true);
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Invalid value for tenant in users table!", e);
        }
        if (selectedTenant != null) {
            tenantList = Collections.singletonList(selectedTenant);
        } else if (tenantId != -1 && user.isAdmin()) {
            Tenant t = Tenant.findById((int)tenantId);
            if (t != null) {
                selectedTenant = t;
                tenantList = Collections.singletonList(t);
            } else {
                tenantList = user.getManageableTenants();
            }
        } else {
            tenantList = user.getManageableTenants();
        }
        Query query = User.getQueryForTenants((Collection)tenantList, (boolean)user.isAdmin(), (Expression)filterExpression);
        sorting.computeForQuery(query);
        String string = sortColumnDirection = sorting.isSortingAscending() ? " ASC" : " DESC";
        if (sorting.getSortingColumn() == 0) {
            orderBy = "name" + sortColumnDirection;
        } else if (sorting.getSortingColumn() == 1) {
            orderBy = "admin" + sortColumnDirection + ", managedTenants" + sortColumnDirection;
        } else if (sorting.getSortingColumn() == 2) {
            orderBy = "securityMedium" + sortColumnDirection;
        } else if (sorting.getSortingColumn() == 3) {
            orderBy = "lastLogin" + sortColumnDirection;
            if (DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType())) {
                orderBy = orderBy + (sorting.isSortingAscending() ? " NULLS FIRST" : " NULLS LAST");
            }
        } else {
            orderBy = sorting.getSortingColumn() == 4 ? "errorCounter" + sortColumnDirection : (sorting.getSortingColumn() == 5 ? "yubikeys" + sortColumnDirection : null);
        }
        if (orderBy != null) {
            query.orderBy(orderBy);
        }
        SimpleTextForm filterValue = new SimpleTextForm();
        filterValue.text = filter.getFilterText();
        Form filterForm = this.formFactory.form(SimpleTextForm.class).fill((Object)filterValue);
        String filterText = filter.isFilterActive() ? filter.getFilterText() : null;
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.USERS, (Call)routes.Users.index());
        }
        if (sorting.getSortingColumn() == 5) {
            LinkedHashSet tmp = new LinkedHashSet(list);
            tmp.addAll(list);
            list.clear();
            list.addAll(tmp);
        }
        return Users.ok((Content)users.render(list, sorting, resetPasswordForm, selectedUsers, BankSettings.findBanksForTenants(tenantList), selectedTenant, (Form<SimpleTextForm>)filterForm, filterText, request, messages));
    }

    public static boolean isTenantUser(User operatingUser, User user, Tenant tenant) {
        if (tenant == null) {
            if (operatingUser.getManagedTenants().size() == 1 && !operatingUser.isAdmin()) {
                return user.getManagedTenants().contains(operatingUser.getManagedTenants().get(0));
            }
            return user.isTenantAdmin();
        }
        return user.getManageableTenants().contains(tenant);
    }

    public Result impersonate(Http.Request request, int id) {
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (GeneralUtils.isSuperAdmin(operatingUser)) {
            User impersonate = (User)DB.find(User.class, (Object)id);
            if (impersonate == null) {
                return Users.notFound();
            }
            long sessionId = Long.parseLong(request.session().get("id").orElse("0"));
            LoginSession.impersonateUser((long)sessionId, (User)impersonate);
            request = request.addAttr(Security.USERNAME, (Object)impersonate.getName());
            return Users.redirect((Call)routes.Application.index()).addingToSession(request, "iid", operatingUser.getId().toString());
        }
        return Users.forbidden();
    }
}

