/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.UserSetupAuthenticator;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import controllers.util.GeneralUtils;
import controllers.util.LicenseHandler;
import de.businesslogics.banking.api.AbstractLicenseHandler;
import de.businesslogics.banking.bank.PropertiesKeys;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import models.ChangePasswordForm;
import models.NewUserIniForm;
import models.PasswordForm;
import models.UserSelectImportForm;
import models.WebAuthnData;
import org.xml.sax.SAXException;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.banks.iniComplete;
import views.html.banks.newUserIni;
import views.html.login.changeFirstPassword;
import views.html.login.license;
import views.html.settings.userselectimportform;

@Security.Authenticated(value=UserSetupAuthenticator.class)
public class UserSetup
extends Controller {
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;
    private final MessagesApi messagesApi;

    @Inject
    public UserSetup(FormFactory formFactory, ClassLoaderExecutionContext executionContext, MessagesApi messagesApi) {
        this.formFactory = formFactory;
        this.executionContext = executionContext;
        this.messagesApi = messagesApi;
    }

    public Result newUserSetup(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (user.isLocalUser() || user.getWebLicense() != null && LicenseHandler.getInstance().checkLicense(user) == AbstractLicenseHandler.LicenseCheckResult.OK) {
            return UserSetup.ok((Content)changeFirstPassword.render((Form<ChangePasswordForm>)this.formFactory.form(ChangePasswordForm.class), true, request, messages));
        }
        return UserSetup.ok((Content)license.render(this.formFactory.form(), request, messages));
    }

    public Result changePasswordPage(Http.Request request) {
        return UserSetup.ok((Content)changeFirstPassword.render((Form<ChangePasswordForm>)this.formFactory.form(ChangePasswordForm.class), false, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result changePassword(Http.Request request, boolean firstChange) {
        Form<ChangePasswordForm> form = this.formFactory.form(ChangePasswordForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (!form.hasErrors()) {
            form = ((ChangePasswordForm)form.get()).validate(form, user, false, messages.lang().toLocale());
        }
        if (form.hasErrors()) {
            return UserSetup.ok((Content)changeFirstPassword.render(form, firstChange, request, messages));
        }
        if (!((ChangePasswordForm)form.get()).update(user)) {
            return UserSetup.ok((Content)changeFirstPassword.render((Form<ChangePasswordForm>)form.withGlobalError("login.error.passwordChangeFailed"), firstChange, request, messages));
        }
        if (!firstChange) {
            return UserSetup.redirect((Call)routes.Application.index());
        }
        if (user.isLocalUser()) {
            user.setKeyDirectory(".");
            user.save();
            return UserSetup.redirect((Call)routes.Application.index());
        }
        List<BankUser> bankUsers = this.getBankUsersForIni(user);
        if (bankUsers.isEmpty()) {
            if (!user.getManageableTenants().isEmpty()) {
                return UserSetup.redirect((Call)routes.Banks.createBank(null));
            }
            return UserSetup.redirect((Call)routes.Banks.index());
        }
        for (BankUser bankUser : bankUsers) {
            if (bankUser.getAuthKey() == null || bankUser.getEncrKey() == null) continue;
            return UserSetup.redirect((Call)routes.Application.index());
        }
        return UserSetup.redirect((Call)routes.UserSetup.newUserIni());
    }

    private List<BankUser> getBankUsersForIni(User forUser) {
        return BankUser.findBanksForUser((User)forUser).stream().filter(bu -> !bu.hasActiveEBICSKeys()).toList();
    }

    public Result newUserIni(Http.Request request) {
        try {
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            List<BankUser> bankUsers = this.getBankUsersForIni(user);
            if (bankUsers.isEmpty()) {
                return UserSetup.redirect((Call)routes.Banks.index());
            }
            Properties p = LicenseHandler.getInstance().getLicenseProperties(user).getProperties();
            NewUserIniForm f = new NewUserIniForm();
            for (BankUser bankUser : bankUsers) {
                String hostId = bankUser.getBank().getHostId();
                String url = bankUser.getBank().getUrl();
                String customerId = bankUser.getBank().getCustomerId();
                if (bankUser.getDefaultUser() != null && !bankUser.getDefaultUser().isEmpty()) {
                    f.userId.put(bankUser.getId(), bankUser.getDefaultUser());
                    continue;
                }
                if (hostId != null && url != null && customerId != null && hostId.equals(p.getProperty(PropertiesKeys.Bank.HOST_ID.name())) && url.equals(p.getProperty(PropertiesKeys.Bank.URL.name())) && customerId.equals(p.getProperty(PropertiesKeys.Bank.CUSTOMER_ID.name()))) {
                    f.userId.put(bankUser.getId(), p.getProperty(PropertiesKeys.User.DEFAULT_USER.name()));
                    continue;
                }
                f.userId.put(bankUser.getId(), "");
            }
            Form form = this.formFactory.form(NewUserIniForm.class).fill((Object)f);
            return UserSetup.ok((Content)newUserIni.render(bankUsers, (Form<NewUserIniForm>)form, WebAuthnData.build(user), null, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to load form for initialization of a new user!", e);
            throw new RuntimeException(e);
        }
    }

    public CompletionStage<Result> doNewUserIni(Http.Request request) {
        Form form = this.formFactory.form(NewUserIniForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List<BankUser> bankUsers = this.getBankUsersForIni(user);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            Form passwordResultForm;
            if (!form.hasErrors()) {
                passwordResultForm = ((NewUserIniForm)form.get()).checkPassword(form, user, PasswordForm.PasswordType.EBICS_PASSWORD, messages.lang().locale());
                if (passwordResultForm.value().isPresent() && ((NewUserIniForm)passwordResultForm.value().get()).isUserLocked()) {
                    BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                    return UserSetup.ok((Content)newUserIni.render(bankUsers, (Form<NewUserIniForm>)passwordResultForm.withGlobalError("login.locked.user"), WebAuthnData.build(user), null, request, messages));
                }
            } else {
                passwordResultForm = form;
            }
            if (passwordResultForm.hasErrors()) {
                return UserSetup.ok((Content)newUserIni.render(bankUsers, passwordResultForm, WebAuthnData.build(user), null, request, messages));
            }
            Map<Integer, String> userIds = ((NewUserIniForm)form.get()).userId;
            boolean allNull = true;
            for (String s : userIds.values()) {
                if (s == null || s.isEmpty()) continue;
                allNull = false;
                break;
            }
            if (allNull) {
                return UserSetup.ok((Content)newUserIni.render(bankUsers, (Form<NewUserIniForm>)form.withGlobalError("ini.newUserIni.error.enterValue"), WebAuthnData.build(user), null, request, messages));
            }
            ArrayList<BankSettings> initializedBanks = new ArrayList<BankSettings>();
            ArrayList<BankSettings> failedBanks = new ArrayList<BankSettings>();
            HashMap<String, String> flashMap = new HashMap<String, String>();
            for (Integer id : userIds.keySet()) {
                if (userIds.get(id) == null || userIds.get(id).isEmpty()) continue;
                BankUser oldBankUser = BankUser.findById((Integer)id);
                BankSettings bank = oldBankUser.getBank();
                boolean worked = false;
                try {
                    BankUser newBankUser = ((NewUserIniForm)form.get()).createTemporaryBankUser(oldBankUser);
                    worked = EbicsUtil.initializeUser(bank, user, newBankUser, ((NewUserIniForm)form.get()).password.toCharArray(), this.messagesApi.preferred((Http.RequestHeader)request).lang().locale());
                }
                catch (Exception e) {
                    String errorMsg = GeneralUtils.getIniErrorMessage(e, messages, bank);
                    Utils.addToFlash(flashMap, "HTMLerror", errorMsg);
                    failedBanks.add(bank);
                }
                if (!worked) continue;
                Utils.addToFlash(flashMap, "success", messages.at("ini.success", new Object[]{bank.getDisplayName()}));
                initializedBanks.add(bank);
            }
            if (initializedBanks.isEmpty()) {
                return UserSetup.ok((Content)newUserIni.render(bankUsers, form, WebAuthnData.build(user), flashMap, request, messages));
            }
            if (!failedBanks.isEmpty()) {
                Utils.addToFlash(flashMap, "warning", messages.at("ini.newUserIni.someFailed", new Object[0]));
            }
            return UserSetup.ok((Content)iniComplete.render(initializedBanks, null, flashMap, request, messages));
        }, this.executionContext.current());
    }

    public Result selectImport(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        UserSelectImportForm form = new UserSelectImportForm();
        return UserSetup.ok((Content)userselectimportform.render((Form<UserSelectImportForm>)this.formFactory.form(UserSelectImportForm.class).fill((Object)form), request, messages));
    }

    public CompletionStage<Result> selectImportForm(Http.Request request) {
        User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form form = this.formFactory.form(UserSelectImportForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors()) {
                return UserSetup.ok((Content)userselectimportform.render((Form<UserSelectImportForm>)form, request, messages));
            }
            Form<UserSelectImportForm> validatedForm = ((UserSelectImportForm)form.get()).validate((Form<UserSelectImportForm>)form, operatingUser, messages);
            try {
                if (validatedForm.hasErrors()) {
                    return UserSetup.ok((Content)userselectimportform.render(validatedForm, request, messages));
                }
                ((UserSelectImportForm)validatedForm.get()).runImport(operatingUser);
            }
            catch (TimeoutException e) {
                BLLoggerPlay.error("Synchronization failed!", e);
                return UserSetup.ok((Content)userselectimportform.render((Form<UserSelectImportForm>)validatedForm.withGlobalError(messages.at("users.import.timeout", new Object[]{Utils.getLocalizedMessage(e, messages)})), request, messages));
            }
            catch (InvalidPasswordException e) {
                BLLoggerPlay.error("Wrong password for the user synchronization!", e);
                return UserSetup.ok((Content)userselectimportform.render((Form<UserSelectImportForm>)validatedForm.withError("importPassword", "general.passwordwrong"), request, messages));
            }
            catch (FileNotFoundException e) {
                BLLoggerPlay.error("Wrong synchronization number when importing the user!", e);
                return UserSetup.ok((Content)userselectimportform.render((Form<UserSelectImportForm>)validatedForm.withError("syncNumber", "users.import.wrongsyncnumber"), request, messages));
            }
            catch (IllegalArgumentException | SAXException e) {
                BLLoggerPlay.error("Format error in the synchronization data!", e);
                return UserSetup.ok((Content)userselectimportform.render((Form<UserSelectImportForm>)validatedForm.withGlobalError(messages.at("users.import.couldnotread", new Object[]{Utils.getLocalizedMessage(e, messages)})), request, messages));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Synchronization from BL Banking failed!", e);
                return UserSetup.ok((Content)userselectimportform.render((Form<UserSelectImportForm>)validatedForm.withGlobalError(Utils.getLocalizedMessage(e, messages)), request, messages));
            }
            return UserSetup.redirect((Call)routes.Application.index()).flashing("success", messages.at("users.imported", new Object[0]));
        }, this.executionContext.current());
    }
}

