/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.ClusterFetchScheduler;
import controllers.FetchSchedule;
import controllers.Users;
import controllers.Yubikeys;
import controllers.branding.Branding;
import controllers.branding.TenantFromExcel;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.PasswordKeyEncryptionHandler;
import controllers.util.SortingHandler;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.format.csv.XLSUtil;
import de.businesslogics.util.BLLogger;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.text.Collator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.SchedulerForm;
import models.SimpleTextForm;
import models.TenantForm;
import models.TenantUser;
import models.TenantsUsersAddForm;
import models.banks.BankDeleteHandler;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.libs.ws.WSClient;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.settings.tenantdeletequestion;
import views.html.settings.tenantform;
import views.html.settings.tenants;
import views.html.settings.yubikeyAddWebAuthnView;

@Security.Authenticated(value=AuthenticatorFor.Settings.class)
public final class Tenants
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;
    private final ClusterFetchScheduler clusterFetchScheduler;
    private static final String NO_VALUE = "---";
    private static final String SELECTED = "X";

    @Inject
    public Tenants(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext, WSClient wsClient) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
        this.clusterFetchScheduler = new ClusterFetchScheduler(wsClient);
    }

    public Result index(Http.Request request) {
        return this.openForm(request, false);
    }

    public Result newTenantDirect(Http.Request request) {
        return this.openForm(request, true);
    }

    public Result openForm(Http.Request request, boolean openNewTenant) {
        List list;
        String filterText;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (!user.isAdmin() && !user.isTenantAdmin()) {
            return Tenants.redirect((Call)routes.Application.index()).flashing("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
        }
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.TENANT);
        ExpressionList expr = user.isAdmin() ? DB.find(Tenant.class).where() : DB.find(Tenant.class).where().eq("managingUsers", (Object)user);
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.TENANTS);
        Expression filterExpression = null;
        if (filter.isFilterActive()) {
            filterExpression = Tenant.getFilterExpression((String)filter.getFilterText());
        }
        SimpleTextForm filterValue = new SimpleTextForm();
        filterValue.text = filter.getFilterText();
        Form filterForm = this.formFactory.form(SimpleTextForm.class).fill((Object)filterValue);
        String string = filterText = filter.isFilterActive() ? filter.getFilterText() : null;
        if (filterExpression != null) {
            expr.add(filterExpression);
        }
        Query query = expr.query();
        sorting.computeForQuery(query);
        String sortString = switch (sorting.getSortingColumn()) {
            case 0 -> {
                if (sorting.isSortingAscending()) {
                    yield "name asc";
                }
                yield "name desc";
            }
            case 1 -> {
                if (sorting.isSortingAscending()) {
                    yield "userCount asc";
                }
                yield "userCount desc";
            }
            default -> null;
        };
        if (sortString != null) {
            query.orderBy(sortString);
        }
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.TENANT, (Call)routes.Tenants.index());
        }
        return Tenants.ok((Content)tenants.render(list, sorting, (Form<SimpleTextForm>)filterForm, filterText, openNewTenant, request, messages));
    }

    public static int getNumberOfFetchingPlans(Tenant tenant) {
        List banks2 = BankSettings.findBanksForTenants(Collections.singletonList(tenant));
        int schedulerCount = 0;
        for (BankSettings bank : banks2) {
            schedulerCount += Scheduler.findByBank((BankSettings)bank).size();
        }
        return schedulerCount;
    }

    public Result indexSort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.TENANT).updateSort(sort, asc);
        return Tenants.redirect((Call)routes.Tenants.index());
    }

    public Result indexPageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.TENANT).updatePage(page, pageSize);
        return Tenants.redirect((Call)routes.Tenants.index());
    }

    public Result filter(Http.Request request, boolean filterActive) {
        Tenants.setupTenantFilter(request, filterActive, this.formFactory);
        return Tenants.redirect((Call)routes.Tenants.index());
    }

    public static void setupTenantFilter(Http.Request request, boolean filterActive, FormFactory formFactory) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.TENANTS);
        if (filterActive) {
            Form filterForm = formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
            String filterText = ((SimpleTextForm)filterForm.get()).text;
            if (filterText != null && !filterText.isEmpty()) {
                filter.setFilterText(filterText);
                filter.setFilterActive(true);
            } else {
                filter.setFilterText(null);
                filter.setFilterActive(false);
            }
        } else {
            filter.setFilterActive(false);
        }
        filter.save();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result importCustomer(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canCreateTenants = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION);
        if (!operator.isAdmin()) {
            return Tenants.redirect((Call)routes.Application.index()).flashing("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
        }
        if (!canCreateTenants) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing("error", messages.at("tenants.error.noPermissionToCreate", new Object[0]));
        }
        Http.MultipartFormData formData = request.body().asMultipartFormData();
        Http.MultipartFormData.FilePart file2 = formData.getFile("importTenant");
        if (file2 == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing("error", messages.at("cm.import.error.noFile", new Object[0]));
        }
        TenantFromExcel tenantFromExcel = Branding.getBranding().getTenantFromExcel();
        if (tenantFromExcel == null) return Tenants.redirect((Call)routes.Tenants.index());
        try (Workbook workbook = XLSUtil.createWorkbook((File)((Files.DelegateTemporaryFile)file2.getRef()).path().toFile());){
            Sheet sheet = workbook.getSheetAt(0);
            String tenantName = sheet.getRow(tenantFromExcel.tenantNameRow).getCell(tenantFromExcel.tenantNameColumn).getStringCellValue();
            String customerId = sheet.getRow(tenantFromExcel.customerIdRow).getCell(tenantFromExcel.customerIdColumn).getStringCellValue();
            Tenant tenant = (Tenant)DB.find(Tenant.class).where().eq("name", (Object)tenantName).findOne();
            if (tenant == null) {
                tenant = new Tenant();
                tenant.setName(tenantName);
                tenant.save();
            }
            AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            logger.logTenantCreated(operator, tenant);
            BankSettings tenantBank = null;
            if (Branding.getBranding().doTenantsWithBank() && customerId != null && !customerId.isEmpty() && !customerId.equals((tenantBank = TenantForm.getBankForTenant(tenant)).getCustomerId())) {
                tenantBank.setCustomerId(customerId);
                tenantBank.save();
                TenantForm.createStatementsFetchSchedulersForTenant(tenant, null, this.clusterFetchScheduler, operator);
                TenantForm.createAdviceFetchSchedulersForTenant(tenant, null, this.clusterFetchScheduler, operator);
            }
            String newUserPassword = ((String[])request.body().asMultipartFormData().asFormUrlEncoded().get("importPassword"))[0];
            boolean generatedPassword = false;
            if (newUserPassword == null || newUserPassword.isEmpty()) {
                PasswordRequirement requirement = PasswordRequirement.getRequirement();
                Object passwordChards = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
                if (requirement.isSpecial()) {
                    passwordChards = (String)passwordChards + ",.;:!$%&/()=#+-_";
                }
                StringBuilder b = new StringBuilder();
                SecureRandom random = SecureRandom.getInstanceStrong();
                int length = Math.max(requirement.getMinLength(), 8);
                for (int i = 0; i < length; ++i) {
                    b.append(((String)passwordChards).charAt(random.nextInt(((String)passwordChards).length())));
                }
                newUserPassword = b.toString();
                generatedPassword = true;
            }
            int userCreated = 0;
            if (tenantBank != null) {
                boolean more = true;
                int row = tenantFromExcel.userStartingRow;
                do {
                    String userId = sheet.getRow(row).getCell(tenantFromExcel.userIdColumn).getStringCellValue();
                    String loginname = sheet.getRow(row).getCell(tenantFromExcel.loginNameColumn).getStringCellValue();
                    if (userId != null && !userId.isEmpty() && loginname != null && !loginname.isEmpty()) {
                        if (User.getUser((String)loginname) == null) {
                            User newUser = new User();
                            newUser.setName(loginname);
                            newUser.setSecurityMedium(User.SecurityMedium.SOFTWARE);
                            newUser.setEncryptionKey(EncryptData.getInstance().copyKey((EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(newUserPassword.toCharArray())));
                            newUser.setWebLicense(operator.getWebLicense());
                            newUser.setTenants(Collections.singletonList(tenant));
                            newUser.setManagedTenants(Collections.singletonList(tenant));
                            newUser.save();
                            logger.logUserCreated(operator, newUser);
                            logger.logTenantAddedUser(operator, newUser, tenant);
                            logger.logTenantGrantManagingUserPrivileges(operator, newUser, tenant);
                            BankUser bankUser = new BankUser();
                            bankUser.setBank(tenantBank);
                            bankUser.setDefaultUser(userId);
                            bankUser.setUser(newUser);
                            bankUser.setState(BankUser.UserState.USED_NO_INI);
                            bankUser.save();
                            ++userCreated;
                        }
                        ++row;
                        continue;
                    }
                    more = false;
                } while (more);
            }
            if (userCreated == 0) {
                Result result = Tenants.redirect((Call)routes.Tenants.editTenant(tenant.getId())).flashing("error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
                return result;
            }
            if (generatedPassword) {
                Result result = Tenants.redirect((Call)routes.Tenants.editTenant(tenant.getId())).flashing("success", messages.at("tenants.import.done", new Object[]{newUserPassword}));
                return result;
            }
            Result result = Tenants.redirect((Call)routes.Tenants.editTenant(tenant.getId())).flashing("success", messages.at("tenants.created", new Object[]{tenant.getName()}));
            return result;
        }
        catch (Exception e) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing("error", messages.at("general.import.failed", new Object[]{e.getMessage()}));
        }
    }

    public Result newTenantModal(Http.Request request, String name, Integer maxUserCount, String tenantBankCustomerId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canCreateTenants = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, operator).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION);
        if (!operator.isAdmin()) {
            return Tenants.redirect((Call)routes.Application.index()).flashing("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
        }
        if (!canCreateTenants) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing("error", messages.at("tenants.error.noPermissionToCreate", new Object[0]));
        }
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        ObjectNode resultJson = Json.newObject();
        if (name == null || name.isEmpty()) {
            resultJson.put("nameError", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameIsMandatory", (Object[])new Object[0]));
            if (maxUserCount <= 0) {
                resultJson.put("maxUserCount", maxUserCount);
            }
            return Tenants.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
        }
        Tenant tenant = new Tenant();
        tenant.setName(name);
        if (!tenant.checkUniqueName()) {
            resultJson.put("nameError", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
            resultJson.put("name", name);
            if (maxUserCount <= 0) {
                resultJson.put("maxUserCount", maxUserCount);
            }
            return Tenants.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
        }
        if (maxUserCount > 0) {
            tenant.setUserCount(maxUserCount);
        }
        tenant.save();
        logger.logTenantCreated(operator, tenant);
        if (Branding.getBranding().doTenantsWithBank() && tenantBankCustomerId != null && !tenantBankCustomerId.isEmpty()) {
            BankSettings tenantBank = TenantForm.getBankForTenant(tenant);
            tenantBank.setCustomerId(tenantBankCustomerId);
            tenantBank.save();
            TenantForm.createStatementsFetchSchedulersForTenant(tenant, null, this.clusterFetchScheduler, operator);
            TenantForm.createAdviceFetchSchedulersForTenant(tenant, null, this.clusterFetchScheduler, operator);
        }
        resultJson.put("nameError", "");
        resultJson.put("redirect", routes.Tenants.newTenantModalOK(name, tenant.getId()).toString());
        return Tenants.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public Result editTenantModalOK(Http.Request request, Integer tenantId) {
        return this.editTenantModalOKResult(request, tenantId, false);
    }

    public Result editTenantModalOKOverview(Http.Request request, Integer tenantId) {
        return this.editTenantModalOKResult(request, tenantId, true);
    }

    public Result editTenantModalOKResult(Http.Request request, Integer tenantId, boolean fromOverview) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, tenantId, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
        play.api.mvc.Call redirectTo = fromOverview ? routes.Tenants.index() : routes.Tenants.editTenant(tenantId);
        return Tenants.redirect((Call)redirectTo).flashing("success", messages.at("tenants.updated", new Object[]{tenant.getName()}));
    }

    public Result newTenantModalOK(Http.Request request, String tenantName, Integer tenantId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (tenantId != null) {
            return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing("success", messages.at("tenants.created", new Object[]{tenantName}));
        }
        return Tenants.redirect((Call)routes.Tenants.index()).flashing("success", messages.at("tenants.created", new Object[]{tenantName}));
    }

    public static Seq<User> getAddableUsers(int tenantId) {
        Tenant tenant = Tenant.findById((int)tenantId);
        if (tenant == null) {
            return Scala.toSeq(new ArrayList());
        }
        return Tenants.getAddableUsers(tenant);
    }

    public static Seq<User> getAddableUsers(Tenant tenant) {
        ArrayList<User> addableUser = new ArrayList<User>();
        for (User u : User.getAll()) {
            if (Users.isNumberOfUsersExceeded(tenant) && !u.isLocalUser() || u.getTenants().contains(tenant)) continue;
            addableUser.add(u);
        }
        return Scala.toSeq(addableUser);
    }

    public static boolean tenantAdminHasMoreTenants(User user, User operatingUser) {
        if (user.getTenants().size() == 1 || operatingUser.getManagedTenants().size() == 1) {
            return false;
        }
        int count = 0;
        for (Tenant t : user.getTenants()) {
            if (!operatingUser.getManagedTenants().contains(t)) continue;
            ++count;
        }
        return count > 1;
    }

    public Result editTenantModal(Http.Request request, Integer tenantId, String name, Integer maxUserCount, boolean overview) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, tenantId, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        String oldName = tenant.getName();
        int oldLimit = tenant.getUserCount() == null ? -1 : tenant.getUserCount();
        int newLimit = maxUserCount == null ? -1 : maxUserCount;
        ObjectNode resultJson = Json.newObject();
        if (name == null || name.isEmpty()) {
            resultJson.put("nameError", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameIsMandatory", (Object[])new Object[0]));
            if (maxUserCount == null || maxUserCount <= 0) {
                resultJson.put("maxUserCount", maxUserCount);
            }
            return Tenants.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
        }
        if (!oldName.equals(name)) {
            tenant.setName(name);
            if (!tenant.checkUniqueName()) {
                resultJson.put("nameError", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
                resultJson.put("name", name);
                if (maxUserCount == null || maxUserCount != -1) {
                    resultJson.put("maxUserCount", maxUserCount);
                }
                return Tenants.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
            }
            logger.logTenantRenamed(user, tenant, oldName);
        }
        if (oldLimit != newLimit) {
            int currentUserCount = User.getNonLocalUserCountForTenant((Tenant)tenant, (boolean)true);
            if (newLimit > -1 && newLimit < currentUserCount) {
                resultJson.put("nameError", messages.at("tenants.userCountWarning", new Object[]{tenant.getName(), currentUserCount, newLimit}));
                resultJson.put("name", name);
                if (maxUserCount != -1) {
                    resultJson.put("maxUserCount", maxUserCount);
                }
                return Tenants.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
            }
            if (newLimit > -1) {
                tenant.setUserCount(maxUserCount);
            } else {
                tenant.setUserCount(null);
            }
            logger.logTenantChangedUserLimit(user, tenant, Integer.valueOf(oldLimit));
        }
        tenant.save();
        resultJson.put("nameError", "");
        if (overview) {
            resultJson.put("redirect", routes.Tenants.editTenantModalOKOverview(tenantId).toString());
        } else {
            resultJson.put("redirect", routes.Tenants.editTenantModalOK(tenantId).toString());
        }
        return Tenants.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public Result editTenant(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, id, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
        TenantForm form = new TenantForm();
        form.fill(tenant);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.TENANT_USERS);
        BankSettings bank = TenantForm.getBankForTenant(tenant);
        List<TenantUser> users2 = TenantForm.getUsersForTenant(tenant, bank, sorting);
        Form addForm = this.formFactory.form(TenantsUsersAddForm.class).fill((Object)new TenantsUsersAddForm());
        return Tenants.ok((Content)tenantform.render((Form<TenantForm>)this.formFactory.form(TenantForm.class).fill((Object)form), sorting, users2, SchedulerForm.getSelectableUsers(messages, bank), false, tenant.getId(), -1, (Form<TenantsUsersAddForm>)addForm, request, messages));
    }

    public Result editTenantSort(Http.Request request, int tenantId, int sort, boolean asc) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, tenantId, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.TENANT_USERS).updateSort(sort, asc);
        return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId));
    }

    public Result editTenantWithPage(Http.Request request, int tenantId, int pageNumber, int pageSize) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, tenantId, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.TENANT_USERS).updatePage(pageNumber, pageSize);
        return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId));
    }

    public CompletionStage<Result> save(Http.Request request, int tenantId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            String tenantUserName;
            HashMap<String, String> flashMap = new HashMap<String, String>();
            Tenant tenant = this.checkPermission(request, tenantId, flashMap);
            if (tenant == null) {
                return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
            }
            Form form = this.formFactory.form(TenantForm.class).bindFromRequest(request, new String[0]);
            BankSettings bank = TenantForm.getBankForTenant(tenant);
            if (form.hasErrors()) {
                SortingHandler sorting = new SortingHandler(user, Sorting.Table.TENANT_USERS);
                Form addForm = this.formFactory.form(TenantsUsersAddForm.class).fill((Object)new TenantsUsersAddForm());
                return Tenants.ok((Content)tenantform.render((Form<TenantForm>)form, sorting, TenantForm.getUsersForTenant(tenant, bank, sorting), SchedulerForm.getSelectableUsers(messages, bank), false, tenantId, -1, (Form<TenantsUsersAddForm>)addForm, request, messages));
            }
            List<ValidationError> errors = ((TenantForm)form.get()).validateAndSave(tenant, user, this.clusterFetchScheduler, messages.lang().locale());
            if (errors != null) {
                boolean showUserModal = ((TenantForm)form.get()).isNewUserError();
                SortingHandler sorting = new SortingHandler(user, Sorting.Table.TENANT_USERS);
                Form addForm = this.formFactory.form(TenantsUsersAddForm.class).fill((Object)new TenantsUsersAddForm());
                return Tenants.ok((Content)tenantform.render(GeneralUtils.formWithErrors(form, errors), sorting, TenantForm.getUsersForTenant(tenant, bank, sorting), SchedulerForm.getSelectableUsers(messages, bank), showUserModal, tenantId, -1, (Form<TenantsUsersAddForm>)addForm, request, messages));
            }
            int currentUserCount = User.getNonLocalUserCountForTenant((Tenant)tenant, (boolean)true);
            if (tenant.getUserCount() != null && tenant.getUserCount() < currentUserCount) {
                flashMap.put("warning", messages.at("tenants.userCountWarning", new Object[]{tenant.getName(), currentUserCount, tenant.getUserCount()}));
            }
            if ((tenantUserName = ((TenantForm)form.get()).getNameWithSuffix()) != null && !tenantUserName.isEmpty()) {
                User tenantUser;
                if (Branding.getBranding().createUserWithWebAuthn() && (tenantUser = User.getUser((String)tenantUserName)) != null) {
                    return Tenants.redirect((Call)routes.Tenants.addWebAuthnPage(tenantUser.getId(), tenantId)).flashing("newUser", tenantUserName);
                }
                return Tenants.redirect((Call)routes.Tenants.editTenant(tenant.getId())).flashing("newUser", tenantUserName).flashing(flashMap);
            }
            play.api.mvc.Call redirectRoute = Branding.getBranding().doTenantsWithBank() ? routes.Tenants.editTenant(tenant.getId()) : routes.Tenants.index();
            return Tenants.redirect((Call)redirectRoute).flashing("success", messages.at("tenants.updated", new Object[]{tenant.getName()})).flashing(flashMap);
        }, this.executionContext.current());
    }

    public Result addWebAuthnPage(Http.Request request, int userId, int tenantId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, tenantId, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing(flashMap);
        }
        User keyUser = User.getByIdForTenants((int)userId, Collections.singletonList(tenant), (boolean)true);
        if (keyUser == null) {
            return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        return Tenants.ok((Content)yubikeyAddWebAuthnView.render(Yubikeys.buildWebAuthnScript(keyUser), keyUser, false, tenantId, request, messages));
    }

    public Result addWebAuthn(Http.Request request, int userId, int tenantId) {
        String flashMessage;
        String flashKey;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, tenantId, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing(flashMap);
        }
        User keyUser = User.getByIdForTenants((int)userId, Collections.singletonList(tenant), (boolean)true);
        if (keyUser == null) {
            return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        byte[] challenge = User.getChallenge((User)keyUser);
        if (challenge == null) {
            return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing("error", messages.at("yubikeys.addWebauthnError", new Object[0]));
        }
        try {
            String credentialId = Yubikeys.checkWebAuthnRegistration(request, keyUser, challenge);
            if (credentialId != null) {
                flashKey = "success";
                flashMessage = messages.at("tenants.tokenAdded", new Object[]{keyUser.getName()});
            } else {
                flashKey = "error";
                flashMessage = messages.at("yubikeys.addWebauthnError", new Object[0]);
            }
        }
        catch (Exception e) {
            BLLoggerPlay.error("Could not validate WebAuthn key", e);
            flashKey = "error";
            flashMessage = messages.at("yubikeys.addWebauthnError", new Object[0]);
        }
        return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing(flashKey, flashMessage);
    }

    public Result prepareDeleteTenant(Http.Request request, int id) {
        return this.prepareDeleteTenantPage(request, id, false);
    }

    public Result prepareDeleteTenantDetails(Http.Request request, int id) {
        return this.prepareDeleteTenantPage(request, id, true);
    }

    public Result prepareDeleteTenantPage(Http.Request request, int id, boolean inDetails) {
        play.api.mvc.Call redirectTo = inDetails ? routes.Tenants.editTenant(id) : routes.Tenants.index();
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canDeleteTenants = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, id, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
        if (!canDeleteTenants) {
            return Tenants.redirect((Call)redirectTo).flashing("error", messages.at("tenants.error.noPermissionToDelete", new Object[0]));
        }
        List<String> deleteInfo = null;
        if (Branding.getBranding().doTenantsWithBank()) {
            deleteInfo = BankDeleteHandler.prepareDeleteQuestion(BankSettings.findBanksForTenants(Collections.singletonList(tenant)), messages.lang().toLocale());
        } else {
            List banks2 = BankSettings.findBanksForTenants(Collections.singletonList(tenant));
            if (!banks2.isEmpty()) {
                StringBuilder bankNames = new StringBuilder();
                for (BankSettings bank : banks2) {
                    if (!bankNames.isEmpty()) {
                        bankNames.append(", ");
                    }
                    bankNames.append(bank.getDisplayName());
                }
                return Tenants.redirect((Call)redirectTo).flashing("error", messages.at("tenants.delete.notempty", new Object[]{tenant.getName(), banks2.size(), bankNames}));
            }
            List<User> users2 = TenantUtils.prepareDeleteCheckForEmptyUsers(tenant);
            if (!users2.isEmpty()) {
                StringBuilder userNames = new StringBuilder();
                for (User u : users2) {
                    if (!userNames.isEmpty()) {
                        userNames.append(", ");
                    }
                    userNames.append(u.getName());
                }
                return Tenants.redirect((Call)redirectTo).flashing("error", messages.at("tenants.delete.emptyusers", new Object[]{tenant.getName(), users2.size(), userNames}));
            }
        }
        if (deleteInfo != null) {
            deleteInfo.addAll(TenantUtils.prepareDeleteQuestion(tenant, messages));
        } else {
            deleteInfo = TenantUtils.prepareDeleteQuestion(tenant, messages);
        }
        return Tenants.ok((Content)tenantdeletequestion.render(tenant, deleteInfo, inDetails, request, messages));
    }

    public CompletionStage<Result> deleteTenant(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean canDeleteTenants = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION);
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> flashMap;
            Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
            int id = GeneralUtils.getSingleSelectionId(((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text);
            Tenant tenant = this.checkPermission(request, id, flashMap = new HashMap<String, String>());
            if (tenant == null) {
                return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
            }
            if (!canDeleteTenants) {
                return Tenants.redirect((Call)routes.Tenants.index()).flashing("error", messages.at("tenants.error.noPermissionToDelete", new Object[0]));
            }
            try {
                TenantUtils.deleteTenant(tenant, user);
                flashMap.put("success", messages.at("tenants.deleted", new Object[0]));
            }
            catch (Exception e) {
                BLLoggerPlay.error("Failed to delete tenant " + tenant.getName(), e);
                flashMap.put("error", messages.at("tenants.delete.failed", new Object[]{tenant.getName()}));
            }
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }, this.executionContext.current());
    }

    public Result addUser(Http.Request request, int tenantId) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, tenantId, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
        Form form = this.formFactory.form(TenantsUsersAddForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
            User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            User user = (User)DB.find(User.class).where().eq("id", (Object)((TenantsUsersAddForm)form.get()).userId).eq("deleted", (Object)false).setMaxRows(1).findOne();
            if (user == null) {
                flashMap.put("error", messages.at("users.unknown", new Object[0]));
            } else {
                boolean grantManagingPrivileges;
                user.getTenants().add(tenant);
                boolean bl = grantManagingPrivileges = !user.isAdmin() && ((TenantsUsersAddForm)form.get()).isManagingUser && !user.getManagedTenants().contains(tenant);
                if (grantManagingPrivileges) {
                    user.getManagedTenants().add(tenant);
                }
                user.save();
                flashMap.put("success", messages.at("tenants.users.added.done", new Object[]{user.getName()}));
                logger.logTenantAddedUser(operatingUser, user, tenant);
                if (grantManagingPrivileges) {
                    logger.logTenantGrantManagingUserPrivileges(operatingUser, user, tenant);
                }
            }
        }
        return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing(flashMap);
    }

    public Result dropUser(Http.Request request, int tenantId) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Tenant tenant = this.checkPermission(request, tenantId, flashMap);
        if (tenant == null) {
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String userIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        for (int userId : GeneralUtils.getSelectionIds(userIds)) {
            User user = User.getByIdForTenants((int)userId, Collections.singletonList(tenant), (boolean)true);
            if (user == null) {
                Utils.addToFlash(flashMap, "error", messages.at("users.unknown", new Object[0]));
                continue;
            }
            if (user.getTenants().size() <= 1) {
                Utils.addToFlash(flashMap, "error", messages.at("tenants.users.delete.noothertenants", new Object[]{user.getName()}));
                continue;
            }
            if (this.hasBanksOfTenant(user, tenant)) {
                Utils.addToFlash(flashMap, "error", messages.at("tenants.users.delete.hasbankoftenant", new Object[]{user.getName()}));
                continue;
            }
            user.getTenants().remove(tenant);
            user.getManagedTenants().remove(tenant);
            user.save();
            Utils.addToFlash(flashMap, "success", messages.at("tenants.users.delete.done", new Object[]{user.getName()}));
            User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logTenantDroppedUser(operatingUser, user, tenant);
        }
        return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing(flashMap);
    }

    private boolean hasBanksOfTenant(User user, Tenant tenant) {
        for (BankSettings bank : BankSettings.findBanksForUser((User)user)) {
            if (!bank.getTenant().equals(tenant)) continue;
            return true;
        }
        return false;
    }

    public CompletionStage<Result> toggleUserPermission(Http.Request request, int userId, int tenantId) {
        return this.toggleUserPermission(request, userId, tenantId, false);
    }

    public CompletionStage<Result> toggleManagingUserPermission(Http.Request request, int userId, int tenantId) {
        return this.toggleUserPermission(request, userId, tenantId, false);
    }

    private CompletionStage<Result> toggleUserPermission(Http.Request request, int userId, int tenantId, boolean modal2) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            Tenant tenant = this.checkPermission(request, tenantId, flashMap);
            if (tenant == null) {
                return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
            }
            Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
            User operatingUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            AdminLogger adminLogger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            User user = User.getByIdForTenants((int)userId, Collections.singletonList(tenant), (boolean)true);
            if (user == null) {
                flashMap.put("error", messages.at("users.unknown", new Object[0]));
            } else if (user.getManagedTenants().contains(tenant)) {
                if (tenant.getManagingUsers().size() > 1 || operatingUser.isAdmin()) {
                    user.getManagedTenants().remove(tenant);
                    user.save();
                    flashMap.put("success", messages.at("tenants.users.permission.removed", new Object[]{user.getName(), tenant.getName()}));
                    adminLogger.logTenantRemoveManagingUserPrivileges(operatingUser, user, tenant);
                } else {
                    flashMap.put("error", messages.at("tenants.users.permission.remove.nomoreadmins", new Object[]{user.getName(), tenant.getName()}));
                }
            } else {
                user.getManagedTenants().add(tenant);
                user.save();
                flashMap.put("success", messages.at("tenants.users.permission.added", new Object[]{user.getName(), tenant.getName()}));
                adminLogger.logTenantGrantManagingUserPrivileges(operatingUser, user, tenant);
            }
            if (modal2) {
                SortingHandler sorting = new SortingHandler(user, Sorting.Table.TENANT_USERS);
                BankSettings bank = TenantForm.getBankForTenant(tenant);
                List<TenantUser> users2 = TenantForm.getUsersForTenant(tenant, bank, sorting);
                TenantForm form = new TenantForm();
                form.fill(tenant);
                Form addForm = this.formFactory.form(TenantsUsersAddForm.class).fill((Object)new TenantsUsersAddForm());
                if (flashMap.containsKey("error")) {
                    addForm = addForm.withGlobalError((String)flashMap.get("error"));
                }
                return Tenants.ok((Content)tenantform.render((Form<TenantForm>)this.formFactory.form(TenantForm.class).fill((Object)form), sorting, users2, SchedulerForm.getSelectableUsers(messages, bank), false, tenant.getId(), userId, (Form<TenantsUsersAddForm>)addForm, request, messages));
            }
            return Tenants.redirect((Call)routes.Tenants.editTenant(tenantId)).flashing(flashMap);
        }, this.executionContext.current());
    }

    public CompletionStage<Result> toggleTenantUserPermissionModal(Http.Request request, int userId, int tenantId) {
        return this.toggleUserPermission(request, userId, tenantId, true);
    }

    public CompletionStage<Result> moveBankToTenant(Http.Request request, int bankId, int tenantId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            Tenant tenant = this.checkPermission(request, tenantId, flashMap);
            if (tenant == null) {
                return Tenants.redirect((Call)routes.Banks.index()).flashing(flashMap);
            }
            BankSettings bank = BankSettings.getById((Integer)bankId);
            User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            if (bank == null || bank.getTenant().equals(tenant) || !operator.getManageableTenants().contains(bank.getTenant())) {
                flashMap.put("error", "bank.error.noSuchBank");
                return Tenants.redirect((Call)routes.Banks.index()).flashing(flashMap);
            }
            TenantUtils.moveBankToTenant(bank, tenant, operator);
            return Tenants.redirect((Call)routes.Banks.index()).flashing("success", messages.at("tenants.movedbank", new Object[]{bank.getDisplayName(), tenant.getName()}));
        }, this.executionContext.current());
    }

    public Result exportCustomer(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String idsString = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = GeneralUtils.getSelectionIds(idsString);
        List tenants2 = ids.isEmpty() ? user.getManageableTenants() : Tenant.findByIds(ids, (User)user, (boolean)true);
        Collator collator = Collator.getInstance(this.messagesApi.preferred((Http.RequestHeader)request).lang().toLocale());
        tenants2.sort((tenant, t1) -> collator.compare(tenant.getName(), t1.getName()));
        try {
            BankSettings bank;
            File tmpFile = Util.createTempFile((String)"tenant_export_customer", (String)".csv", (boolean)true);
            OutputStream outputStream = EncryptData.getInstance().openOutputStream(tmpFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            writer.write(messages.at("tenants.exportCustomer.header", new Object[0]));
            HashMap<Tenant, BankSettings> banks2 = new HashMap<Tenant, BankSettings>();
            HashMap allScheduler = new HashMap();
            TreeSet<FetchSchedule.SchedulerType> types = new TreeSet<FetchSchedule.SchedulerType>();
            for (Tenant t : tenants2) {
                bank = TenantForm.getBankForTenant(t);
                if (bank.getBankId() == null) continue;
                banks2.put(t, bank);
                List list = Scheduler.findByBank((BankSettings)bank);
                HashMap<FetchSchedule.SchedulerType, List> map = new HashMap<FetchSchedule.SchedulerType, List>();
                for (Scheduler s : list) {
                    FetchSchedule.SchedulerType type = FetchSchedule.SchedulerType.getByClassname(s.getOrderOrFileType());
                    types.add(type);
                    List tmp = map.computeIfAbsent(type, schedulerType -> new ArrayList());
                    tmp.add(s);
                }
                allScheduler.put(bank, map);
            }
            for (FetchSchedule.SchedulerType type : types) {
                writer.write(type.getLabel(messages));
                writer.write(59);
            }
            writer.newLine();
            for (Tenant t : tenants2) {
                bank = (BankSettings)banks2.get(t);
                if (bank == null) continue;
                if (bank.getCustomerId() != null) {
                    writer.write(bank.getCustomerId());
                } else {
                    writer.write(NO_VALUE);
                }
                writer.write(59);
                writer.write(t.getName());
                writer.write(59);
                writer.write(String.valueOf(User.getNonLocalUserCountForTenant((Tenant)t, (boolean)false)));
                writer.write(59);
                for (FetchSchedule.SchedulerType type : types) {
                    List list = (List)((Map)allScheduler.get(bank)).get((Object)type);
                    if (list != null) {
                        boolean first = true;
                        for (Scheduler s : list) {
                            if (!first) {
                                writer.write(32);
                            }
                            if (s.getLoginUser() == null) {
                                writer.write(messages.at("fetchschedule.userAssignedAutomatically", new Object[0]));
                            } else {
                                writer.write(s.getLoginUser() != null ? s.getLoginUser().getName() : NO_VALUE);
                                writer.write(" (");
                                writer.write(s.getBankUser() != null ? s.getBankUser().getDefaultUser() : NO_VALUE);
                                writer.write(")");
                            }
                            first = false;
                        }
                    }
                    writer.write(59);
                }
                writer.newLine();
            }
            writer.close();
            return GeneralUtils.supplyWorkspaceFile(tmpFile, false, true).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(messages.at("tenants.exportCustomer.name", new Object[0]) + ".csv"));
        }
        catch (IOException | GeneralSecurityException e) {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("error", messages.at("tenants.exportCustomer.fails", new Object[0]));
            BLLoggerPlay.warning("Exception occurred while exporting a customer", e);
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
    }

    public Result exportUser(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String idsString = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = GeneralUtils.getSelectionIds(idsString);
        List tenants2 = ids.isEmpty() ? user.getManageableTenants() : Tenant.findByIds(ids, (User)user, (boolean)true);
        Collator collator = Collator.getInstance(this.messagesApi.preferred((Http.RequestHeader)request).lang().toLocale());
        tenants2.sort((tenant, t1) -> collator.compare(tenant.getName(), t1.getName()));
        try {
            File tmpFile = Util.createTempFile((String)"tenant_export_user", (String)".csv", (boolean)true);
            OutputStream outputStream = EncryptData.getInstance().openOutputStream(tmpFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            writer.write(messages.at("tenants.exportUser.header", new Object[0]));
            writer.newLine();
            DateFormat df = DateFormat.getDateTimeInstance(2, 3, messages.lang().locale());
            for (Tenant t : tenants2) {
                BankSettings bank = TenantForm.getBankForTenant(t);
                if (bank.getBankId() == null) continue;
                for (BankUser bu : BankUser.findForBankAndStates((BankSettings)bank, (BankUser.UserState[])BankUser.UserState.values())) {
                    if (bank.getCustomerId() != null) {
                        writer.write(bank.getCustomerId());
                    } else {
                        writer.write(NO_VALUE);
                    }
                    writer.write(59);
                    if (bu.getDefaultUser() != null) {
                        writer.write(bu.getDefaultUser());
                    } else {
                        writer.write(NO_VALUE);
                    }
                    writer.write(59);
                    if (bu.isDeactivated()) {
                        writer.write(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bank.state.deactivated", (Object[])new Object[0]));
                    } else {
                        writer.write(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.bank.state." + bu.getState().name()), (Object[])new Object[0]));
                    }
                    writer.write(59);
                    writer.write(bu.getUser().getName());
                    writer.write(59);
                    if (bu.getUser().getLastLogin() != null) {
                        writer.write(df.format(bu.getUser().getLastLogin()));
                    } else {
                        writer.write(NO_VALUE);
                    }
                    writer.write(59);
                    if (bu.getUser().isAdminOrTenantAdmin()) {
                        writer.write(SELECTED);
                    }
                    writer.write(59);
                    if (Yubikey.hasAnyKeys((User)bu.getUser())) {
                        writer.write(SELECTED);
                    }
                    writer.newLine();
                }
            }
            writer.close();
            return GeneralUtils.supplyWorkspaceFile(tmpFile, false, true).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(messages.at("tenants.exportUser.name", new Object[0]) + ".csv"));
        }
        catch (IOException | GeneralSecurityException e) {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("error", messages.at("tenants.exportUser.fails", new Object[0]));
            BLLoggerPlay.warning("Exception occurred while exporting a user", e);
            return Tenants.redirect((Call)routes.Tenants.index()).flashing(flashMap);
        }
    }

    public Result switchToUserAdministration(Http.Request request, Integer tenantId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.USERS);
        if (filter.isFilterActive()) {
            filter.setFilterActive(false);
            filter.save();
        }
        return Tenants.redirect((Call)routes.Users.switchTenant(tenantId));
    }

    private Tenant checkPermission(Http.Request request, int id, Map<String, String> flashMap) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Tenant tenant = Tenant.findById((int)id);
        if (!user.isAdmin() && !user.getManagedTenants().contains(tenant)) {
            Utils.addToFlash(flashMap, "error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
            return null;
        }
        return tenant;
    }

    public static String loadJsParameters(boolean openModalNewTenantDirectly) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("openNewTenantModalDirectly", openModalNewTenantDirectly);
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }
}

