/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.Payments;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.SignedPaymentsTableCsvExport;
import de.businesslogics.banking.payments.api.SignedPaymentsTableOverviewPrinter;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.pdf.PDFException;
import io.ebean.Expression;
import io.ebean.Query;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AustrianForeignPaymentForm;
import models.DeleteFolderForm;
import models.DtazvPaymentForm;
import models.GenerateOpenPaymentFromTemplateForm;
import models.MovePaymentToFolderForm;
import models.Mt101PaymentForm;
import models.PaymentFilterForm;
import models.PaymentFolderForm;
import models.PaymentForm;
import models.PeriodicParametersForm;
import models.PostbarPaymentForm;
import models.SepaPaymentForm;
import models.SimpleSelectionForm;
import models.SimpleTextForm;
import models.TaxOfficePaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.payments.editpayment;
import views.html.payments.signedpayments;

@Security.Authenticated(value=AuthenticatorFor.Payment.class)
public final class SignedPayments
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    @Inject
    public SignedPayments(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public static Query<SignedPayment> getQueryCheckPermission(User user) {
        return SignedPayments.getQueryCheckPermission(user, null);
    }

    public static Query<SignedPayment> getQueryCheckPermission(User user, PaymentFolder paymentFolder) {
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        return SignedPayment.getDefaultQuery((User)user, null, (PaymentFolder)paymentFolder, (boolean)preferences2.getBoolean((DatabasePreferenceConstant)PreferenceConstants.SHOW_ALL_SIGNED_PAYMENTS), (boolean)Util.hideSalariesCompletely((User)user), (boolean)preferences2.getBoolean((DatabasePreferenceConstant)PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION));
    }

    public static String loadJsParameters(List<SignedPayment> payments, Messages messages, boolean displaySalaries, int numberOfFolders, User user) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("numberOfFolders", numberOfFolders);
        ObjectNode node = resultJson.putObject("saveAsOpenPaymentMessage");
        node.put("single", messages.at("payment.saveasopenpayment", new Object[]{1}));
        node.put("multiple", messages.at("payment.saveasopenpayment", new Object[]{999}));
        node = resultJson.putObject("saveAsOpenSelectFolderMessage");
        node.put("single", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.chooseFolderForPayments", (Object[])new Object[]{1}));
        node.put("multiple", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.chooseFolderForPayments", (Object[])new Object[]{999}));
        node = resultJson.putObject("createAwvMessage");
        node.put("single", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.createAWVFromPayment", (Object[])new Object[]{1}));
        node.put("multiple", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.createAWVFromPayment", (Object[])new Object[]{999}));
        resultJson.put("fetchingMessage", messages.at("sent.fetching", new Object[0]));
        resultJson.put("saveAsPeriodicPaymentLink", routes.Payments.saveAsPeriodicPayment(999, PaymentContextType.SIGNED_TO_PERIODIC_PAYMENT.name()).toString());
        resultJson.put("saveAsPaymentTemplateLink", routes.Payments.saveAsPaymentTemplate(999, PaymentContextType.SIGNED_PAYMENT.name()).toString());
        resultJson.put("refreshLink", routes.Sent.update().toString());
        resultJson.put("indexLink", routes.SignedPayments.index(false).toString());
        boolean allowAllStates = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.ALLOW_CALLBACK_FOR_ALL_STATES);
        resultJson.put("alwaysAllowCallback", allowAllStates);
        if (payments != null && !payments.isEmpty()) {
            ArrayNode paymentsNode = resultJson.putArray("payments");
            for (SignedPayment payment : payments) {
                BigDecimal amount2 = displaySalaries ? payment.getAmount() : (payment.getSalaryAmount() != null ? payment.getSalaryAmount() : null);
                node = paymentsNode.addObject();
                node.put("id", payment.getId());
                node.put("amount", amount2);
                node.put("currency", payment.getAmountCurrency());
            }
        }
        resultJson.put("addDecimalsUrl", routes.Application.addSumsWithCurrencyDecimals().toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public Result index(Http.Request request, boolean loadSelection) {
        return this.index(request, null, loadSelection);
    }

    private Result index(Http.Request request, Form<PaymentFilterForm> paymentFilterForm, boolean loadSelection) {
        List list;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_SIGNED);
        int folderId = -1;
        try {
            folderId = Integer.parseInt(sorting.getProperty("folder", "-1"));
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to read parameters from sorting properties for open payments table!", e);
        }
        PaymentFolder paymentFolder = Payments.getFolder(user, folderId);
        String selection = null;
        if (loadSelection) {
            selection = sorting.getProperty("selection");
        }
        sorting.setProperty("selection", null);
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        if (paymentFilterForm == null) {
            PaymentFilterForm data = new PaymentFilterForm(filter);
            paymentFilterForm = this.formFactory.form(PaymentFilterForm.class).fill((Object)data);
        }
        if (!filter.isSignedPaymentsFilterActive()) {
            filter = null;
        }
        Query<SignedPayment> query = this.getQuery(user, sorting.getSorting(), filter, paymentFolder, Util.displaySalaries((User)user));
        sorting.computeForQuery(query);
        MovePaymentToFolderForm moveToFolderFormValues = new MovePaymentToFolderForm();
        moveToFolderFormValues.paymentContextType = PaymentContextType.SIGNED_PAYMENT;
        Form moveToFolderForm = this.formFactory.form(MovePaymentToFolderForm.class).fill((Object)moveToFolderFormValues);
        Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form folderSelectionForm = this.formFactory.form(SimpleSelectionForm.class);
        Form newFolderNameForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        if (paymentFolder != null && !paymentFolder.equals(PaymentFolder.NULL_FOLDER)) {
            newFolderNameForm = newFolderNameForm.fill((Object)new PaymentFolderForm(null, paymentFolder.getTenant().getId()));
            changeFolderNameForm = changeFolderNameForm.fill((Object)new SimpleTextForm(paymentFolder.getName()));
        }
        DeleteFolderForm deleteFolderFormValues = new DeleteFolderForm();
        deleteFolderFormValues.policyForOpenPayments = "dontdelete";
        deleteFolderFormValues.policyForPeriodicPayments = "dontdelete";
        deleteFolderFormValues.policyForPaymentTemplates = "dontdelete";
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class).fill((Object)deleteFolderFormValues);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.PMT_SIGNED, (Call)routes.SignedPayments.index(loadSelection));
        }
        return SignedPayments.ok((Content)signedpayments.render(list, sorting, paymentFolder, (Form<PaymentFilterForm>)paymentFilterForm, filter, selection, (Form<SimpleSelectionForm>)folderSelectionForm, (Form<MovePaymentToFolderForm>)moveToFolderForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<PaymentFolderForm>)newFolderNameForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<DeleteFolderForm>)deleteFolderForm, Util.displaySalaries((User)user), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result indexWithPage(Http.Request request, int pageNumber, int pageSize, int folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sortingHandler = new SortingHandler(user, Sorting.Table.PMT_SIGNED);
        sortingHandler.updatePage(pageNumber, pageSize);
        sortingHandler.setProperty("folder", String.valueOf(folderId));
        return SignedPayments.redirect((Call)routes.SignedPayments.index(false));
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.PMT_SIGNED).updateSort(sort, ascending);
        return SignedPayments.redirect((Call)routes.SignedPayments.index(false));
    }

    public Result filterForm(Http.Request request, boolean filterActive) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        if (!filterActive) {
            filter.setSignedPaymentsFilterActive(false);
            filter.save();
        } else {
            filter.setSignedPaymentsFilterActive(true);
            Form form = this.formFactory.form(PaymentFilterForm.class).bindFromRequest(request, new String[0]);
            if (form.hasErrors()) {
                return this.index(request, (Form<PaymentFilterForm>)form, false);
            }
            PaymentFilterForm data = (PaymentFilterForm)form.get();
            data.saveDataSigned(filter);
        }
        return SignedPayments.redirect((Call)routes.SignedPayments.index(false));
    }

    public Result payment(Http.Request request, int paymentId, String sendId) {
        Form form;
        Class formClass;
        PaymentContextType pct = PaymentContextType.SIGNED_PAYMENT;
        if (sendId != null && !sendId.isEmpty()) {
            pct = PaymentContextType.SENT_PAYMENT;
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SignedPayment payment = (SignedPayment)SignedPayments.getQueryCheckPermission(user).where().eq("id", (Object)paymentId).findOne();
        if (payment == null) {
            if (DB.find(SignedPayment.class, (Object)paymentId) == null) {
                return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing("error", messages.at("editpayment.error.deleted", new Object[0]));
            }
            return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing("error", messages.at("editpayment.error.nopermission", new Object[0]));
        }
        try {
            boolean allowRecipientRecording;
            boolean bl = allowRecipientRecording = !PreferenceUtil.disableRecipientRecording((User)user);
            if (SepaPaymentForm.isSepaPmtType(payment.getPmtType())) {
                boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION);
                formClass = SepaPaymentForm.class;
                form = this.formFactory.form(SepaPaymentForm.class).fill((Object)new SepaPaymentForm(payment, Util.displaySalaries((User)user), allowRecipientRecording, useMandates, false));
            } else if (DtazvPaymentForm.isAzvPmtType(payment.getPmtType())) {
                formClass = DtazvPaymentForm.class;
                form = this.formFactory.form(DtazvPaymentForm.class).fill((Object)new DtazvPaymentForm(payment, allowRecipientRecording, false));
            } else if (Mt101PaymentForm.isMt101PmtType(payment.getPmtType())) {
                formClass = Mt101PaymentForm.class;
                form = this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(payment, allowRecipientRecording, false));
            } else if (PostbarPaymentForm.isPostbarPmtType(payment.getPmtType())) {
                formClass = PostbarPaymentForm.class;
                form = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm(payment, Util.displaySalaries((User)user), allowRecipientRecording, false));
            } else if (TaxOfficePaymentForm.isTaxofficePmtType(payment.getPmtType())) {
                formClass = TaxOfficePaymentForm.class;
                form = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm(payment, Util.displaySalaries((User)user), allowRecipientRecording, false));
            } else if (AustrianForeignPaymentForm.isATXPmtType(payment.getPmtType())) {
                formClass = AustrianForeignPaymentForm.class;
                form = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)new AustrianForeignPaymentForm(payment, Util.displaySalaries((User)user), allowRecipientRecording, false));
            } else {
                formClass = null;
                form = null;
            }
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to load payment with ID " + paymentId + "!", e);
            return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing("HTMLerror", messages.at("payment.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
        PaymentFolder folder = payment.getFolder();
        Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
        Form folderSelectForm = this.formFactory.form(SimpleSelectionForm.class);
        MovePaymentToFolderForm moveToFolderFormValues = new MovePaymentToFolderForm();
        moveToFolderFormValues.folderId = folder == null ? -2 : folder.getId();
        moveToFolderFormValues.paymentContextType = PaymentContextType.SIGNED_PAYMENT;
        moveToFolderFormValues.paymentIds = "" + paymentId;
        Form moveToFolderForm = this.formFactory.form(MovePaymentToFolderForm.class).fill((Object)moveToFolderFormValues);
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class);
        Form newFolderForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form generateForm = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).bindFromRequest(request, new String[0]);
        return SignedPayments.ok((Content)editpayment.render((Form<? extends PaymentForm>)form, pct, paymentId, payment.getPmtType(), formClass, null, folder, (Form<SimpleSelectionForm>)folderSelectForm, (Form<MovePaymentToFolderForm>)moveToFolderForm, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateForm, false, request, messages));
    }

    public CompletionStage<Result> printOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String paymentIdsString = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> {
            List<Integer> paymentIds = GeneralUtils.getSelectionIds(paymentIdsString);
            Query<SignedPayment> query = paymentIds.isEmpty() ? this.getQuery(user, Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_SIGNED), PaymentFilter.getFilter((User)user), null, Util.displaySalaries((User)user)) : SignedPayments.getQueryCheckPermission(user).where().in("id", paymentIds).query();
            try {
                File file2 = new SignedPaymentsTableOverviewPrinter(this, user, messages.lang().locale(), BLLoggerPlay.getLogger(), GeneralUtils.printLogo(user)){
                    private Integer lastPaymentId;
                    private PaymentHandler<?> paymentHandler;

                    protected String getRecipientAccountRepresentation(SignedPayment payment) {
                        PaymentHandler<?> paymentHandler = this.getPaymentData(payment);
                        if (paymentHandler == null) {
                            return null;
                        }
                        return paymentHandler.getRecipientAccount();
                    }

                    protected String getPaymentOrderType(SignedPayment payment) {
                        return PaymentUtils.getOrderDescription(payment.getAccount().getBank(), payment.getPmtType(), payment.getSend().getOrderNumber(), payment.getSend().getOrderType(), messages);
                    }

                    protected String getOrderState(SignedPayment payment) {
                        return SendUtil.getExtendedState((SignedPayment)payment, (Locale)messages.lang().toLocale());
                    }

                    private PaymentHandler<?> getPaymentData(SignedPayment payment) {
                        if (this.paymentHandler == null || !payment.getId().equals(this.lastPaymentId)) {
                            try {
                                this.paymentHandler = PaymentHandler.getHandler(payment.getPmtType(), payment.getPaymentData());
                                this.lastPaymentId = payment.getId();
                            }
                            catch (PaymentException e) {
                                BLLoggerPlay.error("Failed to load payment handler for signed payment " + payment.getId(), e);
                                this.paymentHandler = null;
                                this.lastPaymentId = null;
                            }
                        }
                        return this.paymentHandler;
                    }
                }.print(query.findList());
                return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to print open payments overview to PDF file!", e);
                return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToPrintPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> exportOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String paymentIdsString = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        boolean includeIban = new SortingHandler(user, Sorting.Table.PMT_SIGNED).isColumnDisplayed(8);
        return CompletableFuture.supplyAsync(() -> {
            List<Integer> paymentIds = GeneralUtils.getSelectionIds(paymentIdsString);
            Query<SignedPayment> query = paymentIds.isEmpty() ? this.getQuery(user, Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_SIGNED), PaymentFilter.getFilter((User)user), null, Util.displaySalaries((User)user)) : SignedPayments.getQueryCheckPermission(user).where().in("id", paymentIds).query();
            try {
                String filename = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.signedPayments", (Object[])new Object[0]) + ".csv";
                File tmpFile = Util.createTempFile((String)filename, (String)".tmp", (boolean)true);
                CountingFilterOutputStream outputStream = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(tmpFile));
                try {
                    new SignedPaymentsTableCsvExport(this, messages.lang().locale(), Util.displaySalaries((User)user), includeIban){

                        protected String getState(SignedPayment payment) {
                            return PaymentUtils.getSendStateDescription(payment.getSend(), messages);
                        }
                    }.write((OutputStream)outputStream, (Iterable)query.findList());
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        BLLoggerPlay.warning("Failed to close output stream on temporary file " + tmpFile.getAbsolutePath() + "!", e);
                    }
                }
                return GeneralUtils.supplyWorkspaceFile(tmpFile, false, true).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(filename));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to export signed payments overview to CSV file!", e);
                return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing("HTMLerror", messages.at("payment.error.failedtoexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public Result createNewFolder(Http.Request request) {
        return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing(Payments.createNewFolder(request, this.formFactory, this.messagesApi));
    }

    public Result changeFolderName(Http.Request request, Integer folderId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFolder paymentFolder = PaymentFolder.findById((Integer)folderId, (User)user);
        if (paymentFolder == null) {
            return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing("error", messages.at("openpayments.folder.foldernotfound", new Object[0]));
        }
        return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing(Payments.renameFolder(request, paymentFolder, this.formFactory, this.messagesApi));
    }

    public Result moveToFolder(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Map<String, String> flashMap = Payments.moveToFolder(request, this.formFactory, this.messagesApi);
        String paymentIds = flashMap.get("paymentIds");
        flashMap.remove("paymentIds");
        if (!Utils.hasSuccessFlash(flashMap)) {
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_SIGNED);
            sorting.setProperty("selection", paymentIds);
            return SignedPayments.redirect((Call)routes.SignedPayments.index(true)).flashing(flashMap);
        }
        return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing(flashMap);
    }

    public Result deleteFolder(Http.Request request, Integer folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_PERIODIC);
        return SignedPayments.redirect((Call)routes.SignedPayments.index(false)).flashing(Payments.deleteFolder(request, this.formFactory, this.messagesApi, folderId, sorting));
    }

    public Result protocol(Http.Request request, int id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SignedPayment signedPayment = (SignedPayment)SignedPayments.getQueryCheckPermission(user).where().eq("id", (Object)id).findOne();
        if (signedPayment != null) {
            return SignedPayments.redirect((Call)routes.Sent.protocol(signedPayment.getSend().getId()));
        }
        return SignedPayments.redirect((Call)routes.Sent.protocol(-1));
    }

    public Result printProtocol(Http.Request request, int id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SignedPayment signedPayment = (SignedPayment)SignedPayments.getQueryCheckPermission(user).where().eq("id", (Object)id).findOne();
        if (signedPayment != null) {
            return SignedPayments.redirect((Call)routes.Sent.printProtocol(signedPayment.getSend().getId()));
        }
        return SignedPayments.redirect((Call)routes.Sent.printProtocol(-1));
    }

    private Query<SignedPayment> getQuery(User user, Sorting sorting, PaymentFilter filter, PaymentFolder paymentFolder, boolean fullSalaryPermission) {
        String[] sortColumnNames;
        boolean ascending;
        Expression filterExpr;
        Query<SignedPayment> query = SignedPayments.getQueryCheckPermission(user, paymentFolder);
        if (filter != null && filter.isSignedPaymentsFilterActive() && (filterExpr = filter.getSignedExpression(fullSalaryPermission)) != null) {
            query.where().add(filterExpr);
        }
        int sortingColumn = sorting.getSortingColumn() == null ? 7 : sorting.getSortingColumn();
        boolean bl = ascending = sorting.getSortingColumn() == null ? false : sorting.isSortAscending();
        if (sortingColumn == 0) {
            sortColumnNames = new String[]{"account.name"};
        } else if (sortingColumn == 1) {
            sortColumnNames = new String[]{"send.state"};
        } else if (sortingColumn == 2) {
            sortColumnNames = new String[]{"send.bank", "send.orderType", "send.fileType", "send.orderNumber"};
        } else if (sortingColumn == 3) {
            sortColumnNames = new String[]{"reference"};
        } else if (sortingColumn == 4) {
            sortColumnNames = new String[]{"recipient"};
        } else if (sortingColumn == 5) {
            sortColumnNames = fullSalaryPermission ? new String[]{"amount"} : new String[]{"salaryAmount"};
        } else if (sortingColumn == 6) {
            sortColumnNames = new String[]{"purpose"};
        } else if (sortingColumn == 7) {
            sortColumnNames = new String[]{"executionDate", "send.sent"};
        } else if (sortingColumn == 8) {
            sortColumnNames = new String[]{"account.iban"};
        } else if (sortingColumn == 9) {
            sortColumnNames = new String[]{"folder.name"};
        } else if (sortingColumn == 10) {
            sortColumnNames = new String[]{"originator"};
        } else {
            sortColumnNames = null;
            BLLoggerPlay.warning("User " + user.getName() + " (" + user.getId() + ") tried to sort signed payments by unknown column with ID " + sortingColumn + "!");
        }
        if (sortColumnNames != null) {
            query.orderBy(null);
            for (String sortColumnName : sortColumnNames) {
                if (ascending) {
                    query.orderBy().asc(sortColumnName);
                    continue;
                }
                query.orderBy().desc(sortColumnName);
            }
        }
        query.orderBy().desc("id");
        sorting.setSortingColumn(Integer.valueOf(sortingColumn));
        sorting.setSortAscending(ascending);
        return query;
    }

    public Result repairOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        filter.reset();
        filter.setSignedPaymentsFilterActive(true);
        List<Account> list = PaymentUtils.getAccounts(user.getName(), null, null, false);
        if (list != null && !list.isEmpty()) {
            filter.setAccountId(list.get(0).getId());
        }
        filter.setExecutionDateCompator(FilterComparator.Date.BETWEEN);
        filter.setFromExecutionDate(new Date(System.currentTimeMillis()));
        filter.setToExecutionDate(new Date(System.currentTimeMillis()));
        filter.save();
        Sorting.deleteByUserAndTable((User)user, (Sorting.Table)Sorting.Table.PMT_SIGNED);
        return SignedPayments.redirect((Call)routes.SignedPayments.index(false));
    }
}

