/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Setup;
import controllers.routes;
import java.util.Optional;
import javax.inject.Inject;
import play.Environment;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.mvc.Call;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.html.setupUnauthenticated;

public class SetupAuthenticator
extends Security.Authenticator {
    private static String IP_ADDRESS;
    private static final String SESSION_KEY = "SETUP";
    private final Environment environment;
    private final MessagesApi messagesApi;

    @Inject
    public SetupAuthenticator(Environment environment, MessagesApi messagerApi) {
        this.environment = environment;
        this.messagesApi = messagerApi;
    }

    public Optional<String> getUsername(Http.Request request) {
        if (Setup.setupComplete(this.environment)) {
            return Optional.empty();
        }
        if (IP_ADDRESS == null) {
            return Optional.empty();
        }
        String user = request.session().get(SESSION_KEY).orElse(null);
        if (IP_ADDRESS.equals(user)) {
            return Optional.of(user);
        }
        return Optional.empty();
    }

    public Result onUnauthorized(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (Setup.setupComplete(this.environment)) {
            String flash2 = messages.at("setup.alreadycompleted", new Object[0]);
            return SetupAuthenticator.redirect((Call)routes.Application.index()).flashing("info", flash2);
        }
        if (IP_ADDRESS == null) {
            IP_ADDRESS = request.remoteAddress();
            return SetupAuthenticator.redirect((Call)routes.Setup.index()).addingToSession(request, SESSION_KEY, IP_ADDRESS);
        }
        return SetupAuthenticator.ok((Content)setupUnauthenticated.render(IP_ADDRESS, request, messages));
    }
}

