/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.typesafe.config.Config;
import controllers.Authenticator;
import controllers.BLSyncCache;
import controllers.CacheFilter;
import controllers.DatabaseConnection;
import controllers.Logins;
import controllers.SetupAuthenticator;
import controllers.branding.Branding;
import controllers.branding.raisin.RaisinApiEndpoint;
import controllers.branding.raisin.RaisinDailyScheduler;
import controllers.branding.scim.SCIMApiEndpoint;
import controllers.cm.CmSchedulerPostProcessing;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.BlBankingWebPreferenceConstants;
import controllers.util.CleanupScheduler;
import controllers.util.DailyScheduleHandler;
import controllers.util.EbicsUtil;
import controllers.util.FetchBicListScheduler;
import controllers.util.FetchExchangeRatesScheduler;
import controllers.util.FileExportPostProcessing;
import controllers.util.LoginSessionCleanUp;
import controllers.util.MyCustomerProtocolPostScheduler;
import controllers.util.PeriodicPaymentExecutionRunnerImpl;
import controllers.util.SepaNotificationPostScheduler;
import controllers.util.UpdateCheck;
import controllers.util.UserNotificationHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.bank.Keybag;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.DatabaseUpdateRunner;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.api.JdbcSettings;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.ClusterNode;
import de.businesslogics.banking.database.vo.LoginSession;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WebAuthn;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.FetchScheduler;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.persistence.DBType;
import de.businesslogics.security.jce.BLTrustManager;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.KeyStore;
import io.ebean.QueryIterator;
import io.ebean.Update;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import models.Database;
import models.SetupForm;
import play.Application;
import play.Environment;
import play.cache.SyncCacheApi;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.MessagesApi;
import play.inject.ApplicationLifecycle;
import play.libs.ws.WSBodyReadables;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.html.setup.complete;
import views.html.setup.confirmDir;
import views.html.setup.database;
import views.html.setup.dbUpdate;
import views.html.setup.workspace;

@Singleton
@Security.Authenticated(value=SetupAuthenticator.class)
public class Setup
extends Controller {
    public static boolean SETUP_COMPLETE = false;
    public static String PRODUCT_ID;
    public static String VERSION;
    public static String DISPLAY_NAME;
    public static String INSTITUTE_ID;
    public static String REMOTESUPPORT_URL;
    public static String WEBSOCKET_URL;
    public static boolean WEBSOCKET_URL_SECURE;
    public static String IMPRINT_URL;
    public static String PRIVACY_PAGE_URL;
    public static String ACCESSIBILITY_PAGE_URL;
    public static String NEW_VERSION;
    public static String AUTOMATIC_EXPORT_PATH;
    public static boolean REQUIRE_2FA_FOR_LOGIN;
    public static boolean ALLOW_ADMINS_TO_ADD_2FA;
    public static boolean ALLOW_ADMINS_TO_DELETE_2FA;
    public static boolean DISABLE_LOGIN_AUTOCOMPLETE;
    public static boolean LOG_DES_DATA_AVAILABILITY;
    public static String HTML_HEADER;
    public static String FAVICON_ICO;
    public static String FAVICON_PNG;
    public static String APPLE_TOUCH_ICON;
    public static String MSTILE;
    public static String WEBAUTHN_URL;
    public static String WEBAUTHN_RPID;
    public static String WEBAUTHN_RPIP_OLD;
    public static AuthorizationCodeFlow OPENID_CLIENT;
    public static String OPENID_USERID_ATTRIBUTE;
    public static IdTokenVerifier OPENID_VERIFIER;
    public static String OPENID_ACR_VALUES;
    public static String OPENID_REDIRECT_URL;
    private static int OPENID_HTTP_READ_TIMEOUT;
    public static String OPENID_ADDITIONAL_USER_ATTRIBUTE;
    public static Integer OPENID_ADDITIONAL_USER_VALUE_GREATER_AS;
    public static String OPENID_LOCALE_ATTRIBUTE;
    public static List<String> SUPER_ADMINS;
    public static boolean IMPERSONATE;
    public static long SESSION_TIMEOUT;
    public static long INVALID_PASSWORD_DELAY;
    public static boolean DELETE_USER_NAME;
    private static String IP_ADDRESS_HEADER;
    public static File WORKSPACE_DIRECTORY;
    private static File CONFIG_INI;
    private static final String WORKSPACE = "workspace";
    private static final String NODE_URL = "node_url";
    private static Exception SETUP_EXCEPTION;
    public static DatabaseUpdateRunner DB_UPDATE_RUNNER;
    private final FormFactory formFactory;
    private final Environment environment;
    private final MessagesApi messagesApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean setupComplete(Environment environment) {
        block10: {
            block11: {
                if (SETUP_COMPLETE) {
                    return true;
                }
                CONFIG_INI = environment.getFile(System.getProperty("config.ini", "config.ini"));
                if (!CONFIG_INI.exists()) break block11;
                Properties properties = new Properties();
                InputStream inputStream = null;
                try {
                    inputStream = Files.newInputStream(CONFIG_INI.toPath(), new OpenOption[0]);
                    properties.load(inputStream);
                }
                catch (IOException io) {
                    try {
                        BLLoggerPlay.error("Error reading config.ini: ", io);
                        SETUP_EXCEPTION = io;
                    }
                    catch (Throwable throwable) {
                        SystemUtils.close(inputStream);
                        throw throwable;
                    }
                    SystemUtils.close((AutoCloseable)inputStream);
                }
                SystemUtils.close((AutoCloseable)inputStream);
                String wd = properties.getProperty(WORKSPACE, null);
                if (wd != null) {
                    WORKSPACE_DIRECTORY = new File(wd).getAbsoluteFile();
                    Setup.setupProxy(properties);
                    String nodeURL = properties.getProperty(NODE_URL, null);
                    if (nodeURL != null) {
                        System.setProperty("de.businesslogics.banking.Node", nodeURL);
                    }
                    try {
                        Setup.databaseSetup();
                        if (Setup.isDatabaseUpTodate()) {
                            Setup.applicationUpdate();
                            Setup.otherSetup();
                            SETUP_COMPLETE = Branding.getBranding().isSetupComplete(environment);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        SETUP_EXCEPTION = e;
                    }
                }
                break block10;
            }
            SETUP_EXCEPTION = new Exception("Could not find config.ini!");
        }
        return SETUP_COMPLETE;
    }

    @Inject
    public Setup(FormFactory formFactory, Application application, Environment environment, ApplicationLifecycle lifecycle, MessagesApi messagesApi, SyncCacheApi cacheApi, WSClient wsClient) {
        this.formFactory = formFactory;
        this.environment = environment;
        this.messagesApi = messagesApi;
        BLSyncCache.SYNC_CACHE = cacheApi;
        lifecycle.addStopHook(() -> {
            DatabaseConnection.shutdown();
            SETUP_COMPLETE = false;
            return CompletableFuture.completedFuture(null);
        });
        Setup.loadApplicationSettings(application);
        Setup.writeStartLog();
        if (Setup.setupComplete(environment)) {
            WorkspaceFileSystem.setFileSync((workspaceFile, file2) -> {
                for (ClusterNode node : workspaceFile.getClusterNodes()) {
                    String url = node.getBaseURL();
                    WSRequest request = wsClient.url(url + "/cluster/file/" + workspaceFile.getId());
                    request.addHeader("secret", node.getSecret());
                    try {
                        WSResponse response = (WSResponse)request.execute("GET").toCompletableFuture().get();
                        if (response.getStatus() != 200) continue;
                        File out = WorkspaceFileSystem.toFile((WorkspaceFile)workspaceFile);
                        File dir = out.getParentFile();
                        if (dir.isDirectory() || dir.mkdirs()) {
                            InputStream in = (InputStream)response.getBody(WSBodyReadables.instance.inputStream());
                            SystemUtils.copyStream((InputStream)in, (File)out, (boolean)true);
                            break;
                        }
                        BLLoggerPlay.error("Failed to create directory" + out.getParentFile().getAbsolutePath());
                        break;
                    }
                    catch (Exception e) {
                        BLLoggerPlay.error("Error getting file from another server.", e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupProxy(Properties properties) {
        final String proxyHost = properties.getProperty("proxyHost");
        final String proxyPort = properties.getProperty("proxyPort");
        if (proxyHost != null && !proxyHost.isEmpty() && proxyPort != null && !proxyPort.isEmpty()) {
            final ArrayList<Proxy> proxies = new ArrayList<Proxy>();
            proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort))));
            ProxySelector.setDefault(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    return proxies;
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                    BLLoggerPlay.error("Failed to connect to " + uri.toString() + " via proxy " + proxyHost + ":" + proxyPort, ioe);
                    throw new RuntimeException(ioe);
                }
            });
            BLLoggerPlay.info("Using proxy: " + proxyHost + ", port: " + proxyPort);
            char[] encPassword = new char[]{'i', '/', '<', 's', 'd', 'Y', 'o', '?', 'u', '>', '8', '#', 'T', 'k', '&', '.', 'D', 'L', '?', '7'};
            final String proxyUser = properties.getProperty("proxyUser");
            String proxyPassword = properties.getProperty("proxyPassword");
            if (proxyPassword == null) {
                proxyPassword = properties.getProperty("proxyPassword.enc");
                if (proxyPassword != null) {
                    try {
                        proxyPassword = new String(KeyStore.decryptData((byte[])HexTool.fromHex((String)proxyPassword), (char[])encPassword), StandardCharsets.UTF_8);
                    }
                    catch (InvalidPasswordException e) {
                        BLLoggerPlay.error("Failed to load proxy password!", e);
                        proxyPassword = null;
                    }
                }
            } else {
                OutputStream outputStream = null;
                try {
                    properties.setProperty("proxyPassword.enc", HexTool.toHex((byte[])KeyStore.encryptData((byte[])proxyPassword.getBytes(StandardCharsets.UTF_8), (char[])encPassword)));
                    properties.remove("proxyPassword");
                    outputStream = Files.newOutputStream(CONFIG_INI.toPath(), new OpenOption[0]);
                    properties.store(outputStream, null);
                    SystemUtils.close((AutoCloseable)outputStream);
                }
                catch (InvalidPasswordException | IOException e) {
                    BLLoggerPlay.error("Failed to store proxy password!", e);
                }
                finally {
                    SystemUtils.close(outputStream);
                }
            }
            if (proxyUser != null && !proxyUser.isEmpty() && proxyPassword != null && !proxyPassword.isEmpty()) {
                final String myProxyPassword = proxyPassword;
                java.net.Authenticator.setDefault(new java.net.Authenticator(){
                    private final PasswordAuthentication passwordAuthentication;
                    {
                        this.passwordAuthentication = new PasswordAuthentication(proxyUser, myProxyPassword.toCharArray());
                    }

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return this.passwordAuthentication;
                    }
                });
            }
        }
    }

    public Result index(Http.Request request) {
        SetupForm f = new SetupForm();
        if (WORKSPACE_DIRECTORY != null) {
            if (!WORKSPACE_DIRECTORY.exists() && !WORKSPACE_DIRECTORY.mkdirs()) {
                return Setup.internalServerError((String)"Failed to create workspace directory!");
            }
            f.workspaceDir = WORKSPACE_DIRECTORY.getAbsolutePath();
            Result result = this.databaseCheck(request);
            if (result != null) {
                return result;
            }
            if (SETUP_EXCEPTION != null) {
                BLLoggerPlay.error("Error during Setup", SETUP_EXCEPTION);
                return Setup.internalServerError((String)"Error during Setup, see Log for details.");
            }
            Call c = Branding.getBranding().doBrandingSetup(request);
            if (c != null) {
                return Setup.redirect((Call)c);
            }
            SETUP_COMPLETE = true;
            return Setup.ok((Content)complete.render(request, this.messagesApi.preferred((Http.RequestHeader)request))).withNewSession();
        }
        f.workspaceDir = this.getWorkspaceSuggestion().getAbsolutePath();
        return Setup.ok((Content)workspace.render((Form<SetupForm>)this.formFactory.form(SetupForm.class).fill((Object)f), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private File getWorkspaceSuggestion() {
        return this.environment.getFile(WORKSPACE);
    }

    public Result workspace(Http.Request request) {
        Form form = this.formFactory.form(SetupForm.class).bindFromRequest(request, new String[]{"workspaceDir"});
        if (form.hasErrors()) {
            return Setup.ok((Content)workspace.render((Form<SetupForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        File dir = new File(((SetupForm)form.get()).workspaceDir);
        if (this.getWorkspaceSuggestion().equals(dir) && !dir.mkdirs()) {
            BLLoggerPlay.warning("Failed to create workspace directory " + dir.getAbsolutePath() + "!");
            return this.updateWorkspaceDir(request, (Form<SetupForm>)form);
        }
        if (!dir.isDirectory()) {
            return Setup.ok((Content)confirmDir.render((Form<SetupForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        return this.updateWorkspaceDir(request, (Form<SetupForm>)form);
    }

    private Result updateWorkspaceDir(Http.Request request, Form<SetupForm> form) {
        Properties p = new Properties();
        try {
            FileWriter w = new FileWriter(CONFIG_INI);
            p.setProperty(WORKSPACE, ((SetupForm)form.get()).workspaceDir);
            p.store(w, null);
            w.close();
            WORKSPACE_DIRECTORY = new File(((SetupForm)form.get()).workspaceDir).getAbsoluteFile();
            Result result = this.databaseCheck(request);
            if (result != null) {
                return result;
            }
            return Setup.redirect((Call)routes.Application.index());
        }
        catch (IOException e) {
            return Setup.ok((Content)workspace.render((Form<SetupForm>)form.withError("workspaceDir", e.toString()), request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
    }

    public Result confirmDir(Http.Request request) {
        Form form = this.formFactory.form(SetupForm.class).bindFromRequest(request, new String[]{"workspaceDir", "confirm"});
        if (form.hasErrors()) {
            return Setup.ok((Content)workspace.render((Form<SetupForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        if (form.rawData().containsKey("confirm")) {
            File dir = new File(((SetupForm)form.get()).workspaceDir);
            if (!dir.isDirectory() && !dir.mkdirs()) {
                return Setup.ok((Content)workspace.render((Form<SetupForm>)form.withError("workspaceDir", "setup.workspace.create.failed"), request, this.messagesApi.preferred((Http.RequestHeader)request)));
            }
            return this.updateWorkspaceDir(request, (Form<SetupForm>)form);
        }
        return Setup.ok((Content)workspace.render((Form<SetupForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result databaseCreate(Http.Request request) {
        Form f = this.formFactory.form(Database.class).bindFromRequest(request, new String[0]);
        if (f.hasErrors()) {
            return Setup.ok((Content)database.render((Form<Database>)f, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        try {
            String url = ((Database)f.get()).url;
            if (url.contains("${workspace_loc}")) {
                url = url.replace("${workspace_loc}", WORKSPACE_DIRECTORY.getAbsolutePath());
            }
            Connection con = DriverManager.getConnection(url, ((Database)f.get()).username, ((Database)f.get()).password);
            DBType dbType = DBType.getInstance((Connection)con);
            con.close();
            JdbcSettings s = new JdbcSettings(WORKSPACE_DIRECTORY, dbType, ((Database)f.get()).url, ((Database)f.get()).username, ((Database)f.get()).password);
            s.storeSettings();
            Setup.databaseSetup();
            if (!Setup.isDatabaseUpTodate()) {
                return Setup.ok((Content)dbUpdate.render(request, this.messagesApi.preferred((Http.RequestHeader)request)));
            }
            Setup.applicationUpdate();
            Setup.otherSetup();
            Call brandingSetup = Branding.getBranding().doBrandingSetup(request);
            if (brandingSetup != null) {
                return Setup.redirect((Call)brandingSetup);
            }
            SETUP_COMPLETE = true;
            return Setup.ok((Content)complete.render(request, this.messagesApi.preferred((Http.RequestHeader)request))).withNewSession();
        }
        catch (Exception e) {
            BLLoggerPlay.error(e.toString(), e);
            f = f.withError("url", e.toString());
            return Setup.ok((Content)database.render((Form<Database>)f, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
    }

    private static void loadApplicationSettings(Application application) {
        String value;
        String url;
        PRODUCT_ID = application.config().getString("app.name");
        VERSION = application.config().getString("app.version");
        DISPLAY_NAME = application.config().getString("app.displayName");
        INSTITUTE_ID = application.config().getString("app.institute");
        if (INSTITUTE_ID == null || INSTITUTE_ID.isEmpty()) {
            INSTITUTE_ID = VERSION;
        }
        if (application.config().hasPath("remotesupport.url")) {
            REMOTESUPPORT_URL = application.config().getString("remotesupport.url");
        }
        if (application.config().hasPath("bl.sessionTimeout")) {
            SESSION_TIMEOUT = application.config().getDuration("bl.sessionTimeout", TimeUnit.MILLISECONDS);
            de.businesslogics.banking.preferences.PreferenceConstants.SESSION_TIMEOUT.setDefaultValue(String.valueOf(SESSION_TIMEOUT / 1000L / 60L));
        } else {
            SESSION_TIMEOUT = application.config().hasPath("play.http.session.jwt.expiresAfter") ? application.config().getDuration("play.http.session.jwt.expiresAfter", TimeUnit.MILLISECONDS) : 36000000L;
            de.businesslogics.banking.preferences.PreferenceConstants.SESSION_TIMEOUT.setDefaultValue(String.valueOf(SESSION_TIMEOUT / 1000L / 60L));
        }
        if (application.config().hasPath("bl.invalidPasswordDelay")) {
            INVALID_PASSWORD_DELAY = application.config().getDuration("bl.invalidPasswordDelay", TimeUnit.SECONDS);
        }
        if (application.config().hasPath("bl.ipAddressHeader")) {
            IP_ADDRESS_HEADER = application.config().getString("bl.ipAddressHeader");
        }
        if (application.config().hasPath("bl.deleteUsername")) {
            DELETE_USER_NAME = application.config().getBoolean("bl.deleteUsername");
        }
        if (application.config().hasPath("bl.htmlHeader")) {
            HTML_HEADER = application.config().getString("bl.htmlHeader");
        }
        String branding = null;
        if (application.config().hasPath("bl.branding")) {
            branding = application.config().getString("bl.branding");
        }
        Branding.setBranding(branding);
        if (application.config().hasPath("bl.brandingEbicsServerUrl") && (url = application.config().getString("bl.brandingEbicsServerUrl")) != null && !url.trim().isEmpty()) {
            Branding.getBranding().setEbicsServerUrl(url.trim());
        }
        if (application.config().hasPath("bl.superadmins")) {
            SUPER_ADMINS = application.config().getStringList("bl.superadmins");
        }
        if (application.config().hasPath("bl.impersonate")) {
            IMPERSONATE = application.config().getBoolean("bl.impersonate");
        }
        if (application.config().hasPath("bl.sepa.creditorID")) {
            Branding.getBranding().SEPACreditorID = application.config().getString("bl.sepa.creditorID");
        }
        if (application.config().hasPath("bl.favicon.ico")) {
            FAVICON_ICO = application.config().getString("bl.favicon.ico");
        }
        if (application.config().hasPath("bl.favicon.png")) {
            FAVICON_PNG = application.config().getString("bl.favicon.png");
        }
        if (application.config().hasPath("bl.favicon.appleTouchIcon")) {
            APPLE_TOUCH_ICON = application.config().getString("bl.favicon.appleTouchIcon");
        }
        if (application.config().hasPath("bl.favicon.MSTile")) {
            MSTILE = application.config().getString("bl.favicon.MSTile");
        }
        WEBAUTHN_URL = application.config().hasPath("bl.webauthn.url") ? application.config().getString("bl.webauthn.url") : "http://localhost:9000";
        if (application.config().hasPath("bl.webauthn.rpId")) {
            WEBAUTHN_RPID = application.config().getString("bl.webauthn.rpId");
            if (application.config().hasPath("bl.webauthn.rpIdold")) {
                WEBAUTHN_RPIP_OLD = application.config().getString("bl.webauthn.rpIdold");
            }
        } else {
            try {
                WEBAUTHN_RPID = new URI(WEBAUTHN_URL).getHost();
            }
            catch (URISyntaxException mal) {
                throw new RuntimeException(mal);
            }
        }
        if (application.config().hasPath("bl.websocket.host")) {
            WEBSOCKET_URL = application.config().getString("bl.websocket.host");
            if (application.config().hasPath("bl.websocket.secure")) {
                WEBSOCKET_URL_SECURE = application.config().getBoolean("bl.websocket.secure");
            }
        } else {
            WEBSOCKET_URL = System.getProperty("bl.websocket.host");
            if (WEBSOCKET_URL != null) {
                WEBSOCKET_URL_SECURE = Boolean.parseBoolean(System.getProperty("bl.websocket.secure"));
                BLLoggerPlay.info("Found system property bl.websocket.host for web socket URL host, should be configured in production.conf");
            }
        }
        AUTOMATIC_EXPORT_PATH = application.config().hasPath("bl.automaticexport.path") ? application.config().getString("bl.automaticexport.path") : null;
        if (application.config().hasPath("bl.openid")) {
            String revokeUrl;
            String refreshUrl;
            Config c = application.config().getConfig("bl.openid");
            String tokenUrl = c.getString("token");
            String authorizationUrl = c.getString("authorization");
            String clientId = c.getString("clientid");
            String clientSecret = c.getString("clientsecret");
            String issuer = c.getString("issuer");
            List<String> scopes = Collections.singletonList("openid");
            if (c.hasPath("scope")) {
                scopes = Arrays.asList(c.getString("scope").split(" "));
            }
            if (c.hasPath("logOffUrl")) {
                Logins.openIdLogOffUrl = c.getString("logOffUrl");
            }
            if (c.hasPath("acr")) {
                OPENID_ACR_VALUES = c.getString("acr");
            }
            if (c.hasPath("redirectURL")) {
                OPENID_REDIRECT_URL = c.getString("redirectURL");
            }
            OPENID_USERID_ATTRIBUTE = c.hasPath("userIdAttribute") ? c.getString("userIdAttribute") : "name";
            if (c.hasPath("readTimeout")) {
                OPENID_HTTP_READ_TIMEOUT = (int)c.getDuration("readTimeout", TimeUnit.MILLISECONDS);
            }
            OPENID_VERIFIER = new IdTokenVerifier.Builder().setIssuer(issuer).setAudience(Collections.singletonList(clientId)).build();
            String string = refreshUrl = c.hasPath("refreshUrl") ? c.getString("refreshUrl") : null;
            if (refreshUrl != null && !refreshUrl.isEmpty()) {
                Authenticator.openIdRefreshUrl = new GenericUrl(refreshUrl);
            }
            String string2 = revokeUrl = c.hasPath("revokeUrl") ? c.getString("revokeUrl") : null;
            if (revokeUrl != null && !revokeUrl.isEmpty()) {
                Authenticator.openIdRevokeUrl = new GenericUrl(revokeUrl);
            }
            OPENID_CLIENT = new AuthorizationCodeFlow.Builder(BearerToken.authorizationHeaderAccessMethod(), (HttpTransport)new NetHttpTransport.Builder().build(), (JsonFactory)JacksonFactory.getDefaultInstance(), new GenericUrl(tokenUrl), (HttpExecuteInterceptor)new BasicAuthentication(clientId, clientSecret), clientId, authorizationUrl).setScopes(scopes).setRequestInitializer(request -> request.setReadTimeout(OPENID_HTTP_READ_TIMEOUT)).build();
            OPENID_ADDITIONAL_USER_ATTRIBUTE = c.hasPath("additionalUserAttribute") ? c.getString("additionalUserAttribute") : null;
            OPENID_ADDITIONAL_USER_VALUE_GREATER_AS = c.hasPath("additionalUserValueGreaterAs") ? Integer.valueOf(c.getInt("additionalUserValueGreaterAs")) : null;
            OPENID_LOCALE_ATTRIBUTE = c.hasPath("") ? c.getString("locale") : null;
        }
        if (application.config().hasPath("bl.twofactor")) {
            Config twoFactorConfig = application.config().getConfig("bl.twofactor");
            if (twoFactorConfig.hasPath("required")) {
                REQUIRE_2FA_FOR_LOGIN = twoFactorConfig.getBoolean("required");
            }
            if (twoFactorConfig.hasPath("allowCreationByAdmins")) {
                ALLOW_ADMINS_TO_ADD_2FA = twoFactorConfig.getBoolean("allowCreationByAdmins");
            }
            if (twoFactorConfig.hasPath("allowDeletionByAdmins")) {
                ALLOW_ADMINS_TO_DELETE_2FA = twoFactorConfig.getBoolean("allowDeletionByAdmins");
            }
        }
        if (application.config().hasPath("bl.pushnotification")) {
            UserNotificationHandler.setupPushNotificationFromConfig(application.config().getConfig("bl.pushnotification"));
        }
        if (application.config().hasPath("bl.disableLoginAutocomplete")) {
            DISABLE_LOGIN_AUTOCOMPLETE = application.config().getBoolean("bl.disableLoginAutocomplete");
        }
        if (application.config().hasPath("bl.raisin")) {
            RaisinApiEndpoint.USE_RAISIN_BANK = true;
            Config raisinConfig = application.config().getConfig("bl.raisin");
            if (raisinConfig.hasPath("api_key")) {
                RaisinApiEndpoint.RAISIN_API_KEY = raisinConfig.getString("api_key");
            }
            if (raisinConfig.hasPath("subscription_id")) {
                RaisinApiEndpoint.SUBSCRIPTION_ID = raisinConfig.getString("subscription_id");
            }
            if (raisinConfig.hasPath("api_url")) {
                RaisinApiEndpoint.RAISIN_API_URL = raisinConfig.getString("api_url");
            }
            if (raisinConfig.hasPath("tenant_name")) {
                RaisinApiEndpoint.RAISIN_TENANT_NAME = raisinConfig.getString("tenant_name");
            }
            if (raisinConfig.hasPath("default_wait_seconds_after_throttled")) {
                RaisinApiEndpoint.API_THROTTLED_DEFAULT_WAIT_TIME_SECONDS = raisinConfig.getInt("default_wait_seconds_after_throttled");
            }
            if (raisinConfig.hasPath("max_wait_seconds_after_throttled")) {
                RaisinApiEndpoint.API_THROTTLED_MAX_WAIT_TIME_SECONDS = raisinConfig.getInt("max_wait_seconds_after_throttled");
            }
            if (raisinConfig.hasPath("max_retries_after_throttled")) {
                RaisinApiEndpoint.API_THROTTLED_MAX_RETRIES = raisinConfig.getInt("max_retries_after_throttled");
            }
            if (raisinConfig.hasPath("api_page_size")) {
                RaisinApiEndpoint.PAGED_API_REQUEST_PAGE_SIZE = raisinConfig.getInt("api_page_size");
            }
        }
        if (application.config().hasPath("bl.scim")) {
            String apiSecret;
            SCIMApiEndpoint.SCIM_ACTIVATED = true;
            Config scimConfig = application.config().getConfig("bl.scim");
            if (scimConfig.hasPath("api_secret") && (apiSecret = scimConfig.getString("api_secret")) != null && !apiSecret.isEmpty()) {
                SCIMApiEndpoint.setApiSecret(apiSecret);
            }
            SCIMApiEndpoint.SCIM_ACTIVATED &= SCIMApiEndpoint.isApiSecretSet();
            if (scimConfig.hasPath("active")) {
                SCIMApiEndpoint.SCIM_ACTIVATED &= scimConfig.getBoolean("active");
            }
        }
        if (application.config().hasPath("bl.static_sites")) {
            Config staticSitesConfig = application.config().getConfig("bl.static_sites");
            if (staticSitesConfig.hasPath("imprint")) {
                IMPRINT_URL = staticSitesConfig.getString("imprint");
            }
            if (staticSitesConfig.hasPath("privacy")) {
                PRIVACY_PAGE_URL = staticSitesConfig.getString("privacy");
            }
            if (staticSitesConfig.hasPath("accessibility")) {
                ACCESSIBILITY_PAGE_URL = staticSitesConfig.getString("accessibility");
            }
        }
        if (application.config().hasPath("bl.multipleLogin")) {
            LoginSession.ALLOW_MULTIPLE_LOGIN = application.config().getBoolean("bl.multipleLogin");
        }
        if (application.config().hasPath("play.http.context")) {
            String context;
            CacheFilter.prefixToIgnore = application.isDev() ? "IGNORE_NOTHING" : ((context = application.config().getString("play.http.context")).endsWith("/") ? context + "assets" : context + "/assets");
        }
        if (application.config().hasPath("bl.logCmLoadTimes")) {
            value = application.config().getString("bl.logCmLoadTimes");
            Branding.getBranding().setLogCmLoadTimes(!"false".equals(value.trim()));
        }
        if (application.config().hasPath("bl.logDesOrderDataAvailability")) {
            value = application.config().getString("bl.logDesOrderDataAvailability");
            LOG_DES_DATA_AVAILABILITY = Boolean.parseBoolean(value.trim());
        }
    }

    private static void writeStartLog() {
        BLLoggerPlay.info("Started product: " + PRODUCT_ID + " " + VERSION);
        System.setProperty("http.agent", PRODUCT_ID + "_" + VERSION);
    }

    private static void applicationUpdate() {
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BL_BANKING_WEB, null);
        if (!preferenceStore.getBoolean((DatabasePreferenceConstant)BlBankingWebPreferenceConstants.UPDATED_LAST_PASSWORD_CHANGE)) {
            Update update = DB.createUpdate(User.class, (String)"UPDATE User SET lastPasswordChange = :lpc WHERE lastPasswordChange IS NULL AND deleted = :d");
            update.set("lpc", (Object)new Date(0L));
            update.set("d", (Object)false);
            update.execute();
            preferenceStore.setValue((DatabasePreferenceConstant)BlBankingWebPreferenceConstants.UPDATED_LAST_PASSWORD_CHANGE, true);
        }
        if (WEBAUTHN_RPIP_OLD != null) {
            int i = WebAuthn.updateOldRpId((String)WEBAUTHN_RPIP_OLD);
            BLLoggerPlay.info("Updated " + i + " WebAuthn keys to the old RpId: " + WEBAUTHN_RPIP_OLD);
        }
        User.LIMIT_ERROR_COUNTER = preferenceStore.getInt((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_USER_LOCKED);
    }

    private static void otherSetup() {
        DatabaseToken.userKeysInKeybag = false;
        Setup.setupSSL();
        Util.initialize((File)WORKSPACE_DIRECTORY, (BLLogger)BLLoggerPlay.getLogger());
        if (AUTOMATIC_EXPORT_PATH != null && !AUTOMATIC_EXPORT_PATH.isEmpty()) {
            WorkspaceFileSystem.AUT_EXPORT_BASE_PATH = AUTOMATIC_EXPORT_PATH;
        }
        Branding.getBranding().setupBlApi();
        Setup.migrateUserKeysAndINILetters();
        Setup.setupRaisinBank();
        Setup.setupSchedulers();
        Setup.setupPreferences();
        File tmpDir = new File(WORKSPACE_DIRECTORY, "tmp");
        if (!tmpDir.isDirectory() && !tmpDir.mkdirs()) {
            BLLoggerPlay.warning("Failed to create temporary directory " + tmpDir.getAbsolutePath() + "!");
        }
        System.setProperty("java.io.tmpdir", tmpDir.getAbsolutePath());
    }

    private static void setupSSL() {
        File dataDir = new File(WORKSPACE_DIRECTORY, "data");
        File certs = new File(dataDir, "certs");
        if (certs.exists()) {
            try {
                TrustManager[] mgr = new TrustManager[]{new BLTrustManager(certs){

                    protected boolean askUser(X509Certificate[] arg0, String arg1) {
                        return false;
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, mgr, new SecureRandom());
                EbicsHttpEngineImpl.setSSLContext((SSLContext)sslContext);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void setupSchedulers() {
        FetchScheduler.addPostProcessing(CmSchedulerPostProcessing.class);
        FetchScheduler.addPostProcessing(MyCustomerProtocolPostScheduler.class);
        FetchScheduler.addPostProcessing(SepaNotificationPostScheduler.class);
        FetchScheduler.addPostProcessing(FileExportPostProcessing.class);
        if (WorkspaceFileSystem.MY_NODE == null || WorkspaceFileSystem.MY_NODE.isPrimary()) {
            List list = Scheduler.findAll();
            for (Scheduler s : list) {
                try {
                    FetchScheduler.fetch((Scheduler)s, EbicsUtil::silentGetEbicsWorker);
                }
                catch (Exception e) {
                    BLLoggerPlay.error("Failed to initialize fetch scheduler", e);
                }
            }
            int hourDelta = TimeZone.getDefault().getRawOffset() - TimeZone.getTimeZone("CET").getRawOffset();
            Calendar now = Calendar.getInstance();
            DailyScheduleHandler.schedule((Runnable)((Object)new PeriodicPaymentExecutionRunnerImpl(null, DailyScheduleHandler.getCatcher())), true);
            DailyScheduleHandler.schedule(new FetchBicListScheduler(DailyScheduleHandler.getCatcher()), true);
            DailyScheduleHandler.schedule(new FetchExchangeRatesScheduler(DailyScheduleHandler.getCatcher()), true, 16 - hourDelta, 5);
            DailyScheduleHandler.schedule(new CleanupScheduler(), true);
            DailyScheduleHandler.schedule(new UpdateCheck(DailyScheduleHandler.getCatcher()), true, now.get(11), now.get(12));
            DailyScheduleHandler.schedule(new LoginSessionCleanUp(), true);
            if (RaisinApiEndpoint.USE_RAISIN_BANK) {
                DailyScheduleHandler.schedule(new RaisinDailyScheduler(DailyScheduleHandler.getCatcher()), true);
            }
        }
        DailyScheduleHandler.schedule((Runnable)new WorkspaceFileSystem.CleanUpScheduler(), true);
    }

    private static void setupPreferences() {
        CmPreferenceConstants.DB_MIGRATION_DONE.setDefaultValue(String.valueOf(true));
        PreferenceConstants.DATABASE_MIGRATION.setDefaultValue(String.valueOf(true));
        de.businesslogics.banking.awzel.PreferenceConstants.REPORT_WITHOUT_CONVERSION.setDefaultValue("never");
    }

    private static void migrateUserKeysAndINILetters() {
        block14: {
            Preference p = Preference.getPreference((Preference.ApplicationId)Preference.ApplicationId.BL_BANKING_WEB, (String)"userkey_migration_disabled");
            if (p != null && Boolean.parseBoolean(p.getValue())) {
                return;
            }
            BLLoggerPlay.info("Starting migration of user keys and INI letters from workspace to database ...");
            QueryIterator userQueryIterator = DB.find(User.class).where().ne("key_dir", (Object)"DATABASE").ne("key_dir", (Object)"DATABASE_MIGRATION_NEEDED").findIterate();
            block7: while (true) {
                while (userQueryIterator.hasNext()) {
                    User user = (User)userQueryIterator.next();
                    try {
                        boolean transportKeysPreliminaryMigration = false;
                        for (BankUser bankUser : BankUser.findBanksForUser((User)user)) {
                            boolean signatureKeysMigrated = Setup.migrateSignatureKey(bankUser);
                            boolean transportKeysMigrated = Setup.migrateTransportKeys(bankUser);
                            boolean iniLetterMigrated = Setup.migrateINILetter(bankUser);
                            transportKeysPreliminaryMigration |= transportKeysMigrated;
                            if (!signatureKeysMigrated && !transportKeysMigrated && !iniLetterMigrated) continue;
                            BLLoggerPlay.info("Finished database migration for user " + user.getName() + " (" + bankUser.getDefaultUser() + ")");
                            bankUser.save();
                        }
                        if (transportKeysPreliminaryMigration) {
                            user.setKeyDirectory("DATABASE_MIGRATION_NEEDED");
                        } else {
                            user.setKeyDirectory("DATABASE");
                        }
                        user.save();
                        continue block7;
                    }
                    catch (Exception e) {
                        BLLoggerPlay.warning("Error occurred while migrating signature key/transport keys/INI letter of user '" + user.getName() + "' (id=" + user.getId() + "): " + e.getMessage());
                    }
                }
                break block14;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (userQueryIterator != null) {
                    userQueryIterator.close();
                }
            }
        }
        BLLoggerPlay.info("... Finished migration of user keys and INI letters from workspace to database.");
    }

    private static boolean migrateSignatureKey(BankUser bankUser) throws GeneralSecurityException, IOException {
        byte[] sigKey;
        Keybag keybag = DatabaseToken.loadKeybag((BankUser)bankUser);
        if (keybag == null) {
            return false;
        }
        String propKey = bankUser.getDefaultUser() + "_" + bankUser.getSignatureVersion();
        if (keybag.getProperties().containsKey(propKey)) {
            sigKey = HexTool.fromHex((String)keybag.getProperties().getProperty(propKey));
        } else {
            sigKey = null;
            BLLoggerPlay.warning("Property '" + propKey + "' for sigKey of " + bankUser.getUser().getName() + " (" + bankUser.getDefaultUser() + ") not found in keybag!");
        }
        bankUser.setSigKey(sigKey);
        BLLoggerPlay.info("Migrating signature keys for " + bankUser.getDefaultUser() + " to database ...");
        return true;
    }

    private static boolean migrateTransportKeys(BankUser bankUser) throws GeneralSecurityException, IOException {
        byte[] authKey;
        byte[] encrKey;
        if (bankUser.getEncrKey() != null && bankUser.getAuthKey() != null) {
            return false;
        }
        Keybag keybag = DatabaseToken.loadKeybag((BankUser)bankUser);
        if (keybag == null) {
            return false;
        }
        String e001PropKey = bankUser.getDefaultUser() + "_E001";
        byte[] oldEncrKey = bankUser.getEncrKey();
        if (keybag.getProperties().containsKey(e001PropKey)) {
            encrKey = HexTool.fromHex((String)keybag.getProperties().getProperty(e001PropKey));
        } else {
            BLLoggerPlay.warning("Property '" + e001PropKey + "' for encrKey of " + bankUser.getUser().getName() + " (" + bankUser.getDefaultUser() + ") not found in keybag!");
            encrKey = null;
        }
        boolean encrKeyChanged = encrKey != oldEncrKey;
        String x001PropKey = bankUser.getDefaultUser() + "_X001";
        byte[] oldAuthKey = bankUser.getAuthKey();
        if (keybag.getProperties().containsKey(x001PropKey)) {
            authKey = HexTool.fromHex((String)keybag.getProperties().getProperty(x001PropKey));
        } else {
            BLLoggerPlay.warning("Property '" + x001PropKey + "' for authKey of " + bankUser.getUser().getName() + " (" + bankUser.getDefaultUser() + ") not found in keybag!");
            authKey = null;
        }
        boolean authKeyChanged = authKey != oldAuthKey;
        boolean encrCertChanged = false;
        byte[] encrCert = null;
        if (bankUser.isWithCerts()) {
            String e001CertPropKey = "E001_CERT";
            byte[] oldEncrCert = bankUser.getEncrCert();
            if (keybag.getProperties().containsKey("E001_CERT")) {
                encrCert = HexTool.fromHex((String)keybag.getProperties().getProperty("E001_CERT"));
            }
            encrCertChanged = encrCert != oldEncrCert;
        }
        boolean authCertChanged = false;
        byte[] authCert = null;
        if (bankUser.isWithCerts()) {
            String x001CertPropKey = "X001_CERT";
            byte[] oldAuthCert = bankUser.getAuthCert();
            if (keybag.getProperties().containsKey("X001_CERT")) {
                authCert = HexTool.fromHex((String)keybag.getProperties().getProperty("X001_CERT"));
            }
            authCertChanged = authCert != oldAuthCert;
        }
        boolean bankUserChanged = false;
        if (encrKeyChanged && encrKey != null) {
            bankUser.setEncrKey(encrKey);
            bankUserChanged = true;
            BLLoggerPlay.info("Migrating encryption key for " + bankUser.getDefaultUser() + " to database ...");
        }
        if (authKeyChanged && authKey != null) {
            bankUser.setAuthKey(authKey);
            bankUserChanged = true;
            BLLoggerPlay.info("Migrating authentication key for " + bankUser.getDefaultUser() + " to database ...");
        }
        if (encrCertChanged && encrCert != null) {
            bankUser.setEncrCert(encrCert);
            bankUserChanged = true;
            BLLoggerPlay.info("Migrating encryption certificate for " + bankUser.getDefaultUser() + " to database ...");
        }
        if (authCertChanged && authCert != null) {
            bankUser.setAuthCert(authCert);
            bankUserChanged = true;
            BLLoggerPlay.info("Migrating authentication certificate for " + bankUser.getDefaultUser() + " to database ...");
        }
        return bankUserChanged;
    }

    private static boolean migrateINILetter(BankUser bankUser) {
        if (bankUser.getIniLetter() != null) {
            return false;
        }
        File iniLetter = EbicsWorker.getINILetter((File)Util.getKeyDirectory((User)bankUser.getUser()), (BankSettings)bankUser.getBank());
        if (!iniLetter.exists()) {
            return false;
        }
        try {
            bankUser.setIniLetter(iniLetter);
            BLLoggerPlay.info("Migrating INI letter for " + bankUser.getDefaultUser() + " to database ...");
        }
        catch (IOException e) {
            BLLoggerPlay.error("Error occurred when trying to write INI letter file to database!", e);
            return false;
        }
        return true;
    }

    private static void setupRaisinBank() {
        if (RaisinApiEndpoint.USE_RAISIN_BANK) {
            BLLoggerPlay.info("Setting up Raisin API connection ...");
            try {
                RaisinApiEndpoint.createOrUpdateRaisinBank();
                new Thread(RaisinApiEndpoint::loadAllAccountsFromAPI).start();
            }
            catch (Exception e) {
                RaisinApiEndpoint.logError("An error occurred while setting up Raisin API connection", e);
            }
            BLLoggerPlay.info("... finished setting up Raisin API connection.");
        }
    }

    public Result databaseUpdateCheck(Http.Request request) {
        if (DatabaseConnection.getInstance() == null) {
            Setup.redirect((Call)routes.Setup.databaseCreate());
        }
        if (DB_UPDATE_RUNNER.getUpdatesToDo().isEmpty()) {
            return Setup.redirect((Call)routes.Setup.index());
        }
        return Setup.ok((Content)dbUpdate.render(request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result databaseCheck(Http.Request request) {
        if (WORKSPACE_DIRECTORY == null) {
            Setup.redirect((Call)routes.Setup.workspace());
        }
        JdbcSettings settings = null;
        try {
            File jdbc = new File(WORKSPACE_DIRECTORY, "jdbc.properties");
            if (jdbc.exists()) {
                settings = new JdbcSettings(WORKSPACE_DIRECTORY);
                Setup.databaseSetup();
                if (!Setup.isDatabaseUpTodate()) {
                    return Setup.redirect((Call)routes.Setup.databaseUpdateCheck());
                }
                return null;
            }
            Database db = new Database();
            db.url = "jdbc:h2:${workspace_loc}/bl;AUTO_SERVER=true;AUTO_SERVER_PORT=9090;MVCC=true";
            db.username = "bl";
            db.password = "_bl_";
            Form form = this.formFactory.form(Database.class).fill((Object)db);
            return Setup.ok((Content)database.render((Form<Database>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        catch (Exception e) {
            Exception db_exception = e;
            if (settings == null) {
                return Setup.redirect((Call)routes.Setup.workspace());
            }
            Database d = new Database();
            d.url = settings.getJdbcUrl();
            d.username = settings.getDbUser();
            d.password = settings.getDbPassword();
            Form f = this.formFactory.form(Database.class).fill((Object)d);
            f = f.withError("url", db_exception.toString());
            return Setup.ok((Content)database.render((Form<Database>)f, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
    }

    private static void databaseSetup() throws IOException, SQLException {
        if (DatabaseConnection.getInstance() == null || DB_UPDATE_RUNNER == null) {
            DB_UPDATE_RUNNER = DatabaseConnection.initDatabaseConnection(WORKSPACE_DIRECTORY);
            BLLoggerPlay.info("Updates to do: " + DB_UPDATE_RUNNER.getUpdatesToDo().size());
        }
    }

    private static boolean isDatabaseUpTodate() {
        if (DB_UPDATE_RUNNER != null) {
            return DB_UPDATE_RUNNER.getUpdatesToDo().isEmpty();
        }
        return false;
    }

    public static String getIPAddress(Http.Request request) {
        return request.header(IP_ADDRESS_HEADER).orElse(request.remoteAddress());
    }

    static {
        IMPRINT_URL = null;
        PRIVACY_PAGE_URL = null;
        ACCESSIBILITY_PAGE_URL = null;
        REQUIRE_2FA_FOR_LOGIN = false;
        ALLOW_ADMINS_TO_ADD_2FA = false;
        ALLOW_ADMINS_TO_DELETE_2FA = true;
        DISABLE_LOGIN_AUTOCOMPLETE = false;
        LOG_DES_DATA_AVAILABILITY = false;
        HTML_HEADER = "";
        FAVICON_ICO = "images/favicon.ico";
        FAVICON_PNG = "images/favicon.png";
        APPLE_TOUCH_ICON = "images/apple-touch-icon.png";
        MSTILE = "images/mstile.png";
        OPENID_HTTP_READ_TIMEOUT = 20000;
        SUPER_ADMINS = Collections.emptyList();
        IMPERSONATE = false;
        SESSION_TIMEOUT = 0L;
        INVALID_PASSWORD_DELAY = 5L;
        DELETE_USER_NAME = false;
        IP_ADDRESS_HEADER = "X-Forwarded-For";
        WORKSPACE_DIRECTORY = null;
        CONFIG_INI = null;
        SETUP_EXCEPTION = null;
    }
}

