/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.DesHistory;
import controllers.Setup;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import controllers.util.BankOrderCheckHandler;
import controllers.util.BankOrderResultHandler;
import controllers.util.BankOrderSignInfo;
import controllers.util.CsvImport;
import controllers.util.DsOrderPaymentInfo;
import controllers.util.EbicsUtil;
import controllers.util.GeneralUtils;
import controllers.util.OrderPermissionChecker;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.ProtocolPrinter;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.SendStateUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.api.dta.DTAZVPaymentCsvExport;
import de.businesslogics.banking.api.dta.DtazvDetailsPrinter;
import de.businesslogics.banking.api.mt101.MT101DetailsPrinter;
import de.businesslogics.banking.api.sepa.SEPAPaymentDataCsvExport;
import de.businesslogics.banking.api.sepa.SepaDetailsPrinter;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.payments.api.BankOrderCallback;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaCallbackApi;
import de.businesslogics.banking.sepa.api.SepaCallbackException;
import de.businesslogics.banking.sepa.api.SepaSendFileDetector;
import de.businesslogics.banking.transfer.api.CustomerProtocolPostScheduler;
import de.businesslogics.banking.transfer.api.DisplayMessagePrinter;
import de.businesslogics.banking.transfer.api.SendFileAutoDetectException;
import de.businesslogics.banking.transfer.api.SendFileDetector;
import de.businesslogics.banking.transfer.api.SendOrderHandler;
import de.businesslogics.banking.transfer.api.SentTableCsvExport;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.sepa.SEPACallbackGenerator;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.io.ContentFactory;
import de.businesslogics.io.Streams;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import io.ebean.ExpressionList;
import io.ebean.Query;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AustrianForeignPaymentForm;
import models.BankOrderWithFileAndPossibleBanks;
import models.BankOrderWithPayments;
import models.BankSelectionForm;
import models.DtazvPaymentForm;
import models.HvtPaymentForm;
import models.Mt101PaymentForm;
import models.PasswordForm;
import models.PaymentCsvImportForm;
import models.PaymentForm;
import models.PostbarPaymentForm;
import models.PrepareCallbackForm;
import models.SendFileForm;
import models.SendFilterForm;
import models.SepaPaymentForm;
import models.SignOrdersForm;
import models.SimpleTextForm;
import models.TaxOfficePaymentForm;
import models.WebAuthnData;
import models.payments.AustrianForeignPaymentHandler;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import models.payments.PostbarPaymentHandler;
import models.payments.TaxOfficePaymentHandler;
import org.apache.pekko.japi.function.Function2;
import org.apache.pekko.stream.javadsl.Flow;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.mvc.WebSocket;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Menu;
import views.Utils;
import views.html.orders.preparecallback;
import views.html.orders.sendfile;
import views.html.orders.sendfileselectbank;
import views.html.orders.sendorderfromcsv;
import views.html.orders.sent;
import views.html.orders.sentdetails;
import views.html.orders.sentpaymentdetails;
import views.html.orders.signorder;

@Security.Authenticated(value=AuthenticatorFor.SendFile.class)
public final class Sent
extends Controller {
    public static final String SENDITEMS_FLASH_NAME = "sendItems";
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    @Inject
    public Sent(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public static Seq<Tuple2<String, String>> getStatesForFilter(boolean ds, Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        if (ds) {
            for (DsOrderDetails.State state : DsOrderDetails.State.values()) {
                result.add(Scala.Tuple((Object)state.name(), (Object)SendStateUtil.getStateFilterText((DsOrderDetails.State)state, (Locale)locale)));
            }
        } else {
            for (SendFilter.State s : SendFilter.State.values()) {
                result.add(Scala.Tuple((Object)s.name(), (Object)SendStateUtil.getStateFilterText((SendFilter.State)s, (Locale)locale)));
            }
        }
        return Scala.toSeq(result);
    }

    private static Map<Integer, String> internalGetStates(boolean ds, Messages messages) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Locale locale = messages.lang().toLocale();
        if (ds) {
            for (DsOrderDetails.State state : DsOrderDetails.State.values()) {
                result.put(state.ordinal(), SendStateUtil.getStateFilterText((DsOrderDetails.State)state, (Locale)locale));
            }
        } else {
            for (SendFilter.State s : SendFilter.State.values()) {
                result.put(s.ordinal(), SendStateUtil.getStateFilterText((SendFilter.State)s, (Locale)locale));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, Integer> sendOrders(List<BankOrderWithPayments> bankOrders, char[] password2, BankOrderResultHandler resultHandler, String csvMd5Hash, String ipAddress) throws EbicsException, DisplayFileException, KnownFormatException, IOException, GeneralSecurityException {
        EbicsWorker worker;
        HashMap<Integer, Integer> toReturn = new HashMap<Integer, Integer>();
        HashSet<BankUser> bankUsers = new HashSet<BankUser>();
        for (BankOrderWithPayments bankOrderWithPayments : bankOrders) {
            String orderId;
            final BankOrder bankOrder = bankOrderWithPayments.getBankOrder();
            worker = EbicsUtil.getEbicsWorker(bankOrder.getBankUser(), password2);
            final ArrayList inputStream = new ArrayList();
            try {
                Boolean transportOnly = bankOrder.getBank().getTransportOnly();
                if (transportOnly == null) {
                    transportOnly = false;
                }
                ContentFactory cf = new ContentFactory(){
                    private static final long serialVersionUID = 1L;

                    public InputStream getContent() throws IOException {
                        if (!inputStream.isEmpty()) {
                            ((InputStream)inputStream.getFirst()).close();
                            inputStream.clear();
                        }
                        try {
                            if (bankOrder.isExternalFile()) {
                                inputStream.add(Files.newInputStream(bankOrder.getOrderFile().toPath(), new OpenOption[0]));
                            } else {
                                inputStream.add(EncryptData.getInstance().openInputStream(bankOrder.getOrderFile()));
                            }
                            return (InputStream)inputStream.getFirst();
                        }
                        catch (InvalidPasswordException e) {
                            BLLoggerPlay.error("Failed to open input stream on bank order file");
                            return null;
                        }
                    }
                };
                boolean isBTF = BTFTranslator.isBTFString((String)bankOrder.getOrderType());
                if (isBTF) {
                    RestrictedServiceType rst = BTFTranslator.convertFrom((String)bankOrder.getOrderType());
                    orderId = worker.sendFile30(cf, bankOrder.getOriginalFileName(), rst, new EbicsWorker[]{worker}, transportOnly.booleanValue(), bankOrder.getAdditionalInfo());
                } else {
                    orderId = worker.sendFile(cf, bankOrder.getOriginalFileName(), bankOrder.getOrderType(), new EbicsWorker[]{worker}, transportOnly.booleanValue(), bankOrder.getAdditionalInfo());
                }
            }
            finally {
                if (!inputStream.isEmpty()) {
                    try {
                        ((InputStream)inputStream.getFirst()).close();
                        inputStream.clear();
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to close input stream on order file " + bankOrder.getOrderFile().getAbsolutePath(), e);
                    }
                }
            }
            PaymentTransferType.PmtType pmtType = null;
            List<OpenPayment> openPayments = bankOrderWithPayments.getOpenPayments();
            ArrayList<PaymentFolder> folders2 = new ArrayList<PaymentFolder>();
            if (openPayments != null && !openPayments.isEmpty()) {
                pmtType = Sent.getPmtTypeForOrder(openPayments);
                folders2.addAll(openPayments.stream().map(OpenPayment::getFolder).toList());
            }
            Send send = bankOrder.storeSend(orderId, openPayments != null && !openPayments.isEmpty(), resultHandler, pmtType, folders2, csvMd5Hash, ipAddress);
            try {
                User user = bankOrder.getBankUser().getUser();
                if (openPayments != null && !openPayments.isEmpty()) {
                    for (OpenPayment payment : openPayments) {
                        Logger.logOpenPaymentSigned((User)user, (OpenPayment)payment, (String)orderId, (Send)send);
                    }
                } else if (bankOrder.getRecalledOrder() != null) {
                    Logger.logOrderRecalled((User)user, (Send)send, (Send)bankOrder.getRecalledOrder());
                } else {
                    Logger.logFileSent((User)user, (Send)send, (boolean)bankOrder.isVopOrder());
                }
            }
            catch (Exception e) {
                BLLoggerPlay.error("Error occurred while trying to log order signature!", e);
            }
            if (openPayments != null && !openPayments.isEmpty()) {
                OpenPayment.deletePayments((User)bankOrder.getBankUser().getUser(), openPayments);
                toReturn.put(send.getId(), openPayments.size());
            } else {
                toReturn.put(send.getId(), 0);
            }
            if (bankOrder.getRecalledOrder() != null) {
                Send recalledSendOrder = bankOrder.getRecalledOrder();
                recalledSendOrder.setCallback(send);
                recalledSendOrder.save();
                List recalledSignedPayments = bankOrder.getRecalledSignedOrders();
                if (recalledSignedPayments == null || recalledSignedPayments.isEmpty()) {
                    recalledSignedPayments = SignedPayment.findBySend((Send)recalledSendOrder);
                }
                for (SignedPayment signedPayment : recalledSignedPayments) {
                    signedPayment.setCallback(send);
                    signedPayment.save();
                }
            }
            bankUsers.add(bankOrder.getBankUser());
        }
        for (BankUser bankUser : bankUsers) {
            worker = EbicsUtil.getEbicsWorker(bankUser);
            CustomerProtocolPostScheduler.fetchProtocolAfterSend((EbicsWorker)worker, (BankUser)bankUser);
        }
        return toReturn;
    }

    private static PaymentTransferType.PmtType getPmtTypeForOrder(List<OpenPayment> payments) {
        if (payments.isEmpty()) {
            return null;
        }
        if (payments.stream().map(OpenPayment::getPmtType).distinct().count() == 1L) {
            return payments.getFirst().getPmtType();
        }
        Set normalizedPmtTypes = payments.stream().map(p -> Sent.getNormalizedPmtType(p.getPmtType())).collect(Collectors.toSet());
        if (normalizedPmtTypes.size() == 1) {
            return (PaymentTransferType.PmtType)normalizedPmtTypes.iterator().next();
        }
        BLLoggerPlay.warning("Could not find unique PmtType to use for sent order! PmtTypes found: " + String.valueOf(normalizedPmtTypes));
        return null;
    }

    private static PaymentTransferType.PmtType getNormalizedPmtType(PaymentTransferType.PmtType basePmtType) {
        if (PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT.equals((Object)basePmtType) || PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT.equals((Object)basePmtType) || PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT.equals((Object)basePmtType)) {
            return PaymentTransferType.PmtType.SEPA_TRANSFER;
        }
        if (PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE.equals((Object)basePmtType)) {
            return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN;
        }
        if (PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE.equals((Object)basePmtType)) {
            return PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER;
        }
        return basePmtType;
    }

    public static String getFilterDescription(SendFilter filter, Messages messages, SendFilter.SendFilterType type) {
        int compareState;
        boolean isDsFilter;
        StringBuilder result = new StringBuilder();
        boolean isSentFilter = type == SendFilter.SendFilterType.SENT_FILES;
        boolean isDsOverviewFilter = type == SendFilter.SendFilterType.DS_OVERVIEW;
        boolean bl = isDsFilter = type == SendFilter.SendFilterType.DS_OVERVIEW || type == SendFilter.SendFilterType.DS_SIGNED || type == SendFilter.SendFilterType.DS_CANCELLED;
        if (filter.getBank() != null) {
            result.append(messages.at("sent.filter.bank", new Object[]{filter.getBank().getDisplayName()}));
        }
        if (isSentFilter && filter.getAccount() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(messages.at("payment.filter.description.account", new Object[]{filter.getAccount().getName()}));
        }
        if (filter.getPmtType() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            String description = PaymentTypeUtil.getUniquePaymentName((Locale)messages.lang().toLocale(), (PaymentTransferType.PmtType)filter.getPmtType());
            if (filter.getPmtTypeComparator() == FilterComparator.PaymentType.EQUAL) {
                result.append(messages.at("payment.filter.description.filterPmtType.equal", new Object[]{description}));
            } else {
                result.append(messages.at("payment.filter.description.filterPmtType.notEqual", new Object[]{description}));
            }
        }
        if (filter.getOrderType() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            if (filter.getOrderTypeComparator() == FilterComparator.Text.STARTS_WITH) {
                result.append(messages.at("sent.filter.ordertype.startswith", new Object[]{filter.getOrderType()}));
            } else if (filter.getOrderTypeComparator() == FilterComparator.Text.ENDS_WITH) {
                result.append(messages.at("sent.filter.ordertype.endswith", new Object[]{filter.getOrderType()}));
            } else if (filter.getOrderTypeComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result.append(messages.at("sent.filter.ordertype.containsnot", new Object[]{filter.getOrderType()}));
            } else {
                result.append(messages.at("sent.filter.ordertype.contains", new Object[]{filter.getOrderType()}));
            }
        }
        if (filter.getOrderNumber() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            if (filter.getOrderNumberComparator() == FilterComparator.Text.STARTS_WITH) {
                result.append(messages.at("sent.filter.ordernumber.startswith", new Object[]{filter.getOrderNumber()}));
            } else if (filter.getOrderNumberComparator() == FilterComparator.Text.ENDS_WITH) {
                result.append(messages.at("sent.filter.ordernumber.endswith", new Object[]{filter.getOrderNumber()}));
            } else if (filter.getOrderNumberComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result.append(messages.at("sent.filter.ordernumber.containsnot", new Object[]{filter.getOrderNumber()}));
            } else {
                result.append(messages.at("sent.filter.ordernumber.contains", new Object[]{filter.getOrderNumber()}));
            }
        }
        if ((compareState = isDsFilter && !isDsOverviewFilter && filter.getDsState() != null ? filter.getDsState().ordinal() : (isSentFilter && filter.getSendState() != null ? filter.getSendState().ordinal() : -1)) >= 0) {
            Map<Integer, String> states = Sent.internalGetStates(isDsFilter, messages);
            for (Integer i : states.keySet()) {
                if (i != compareState) continue;
                if (!result.isEmpty()) {
                    result.append(", ");
                }
                result.append(messages.at("sent.filter.state", new Object[]{states.get(i), BankingApiMessages.getString((Locale)messages.lang().locale(), (String)Branding.getBranding().getSignedPaymentStateLabel(), (Object[])new Object[0])}));
                break;
            }
        }
        if (filter.getDateComparator() != null && filter.getFromDate() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(messages.at("sent.filter.date", new Object[]{filter.getDateComparator().ordinal(), filter.getFromDate(), filter.getToDate()}));
        }
        if (filter.getSender() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            if (filter.getSenderComparator() == FilterComparator.Text.STARTS_WITH) {
                result.append(messages.at(isDsFilter ? "sent.filter.submitter.startswith" : "sent.filter.sender.startswith", new Object[]{filter.getSender()}));
            } else if (filter.getSenderComparator() == FilterComparator.Text.ENDS_WITH) {
                result.append(messages.at(isDsFilter ? "sent.filter.submitter.endswith" : "sent.filter.sender.endswith", new Object[]{filter.getSender()}));
            } else if (filter.getSenderComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result.append(messages.at(isDsFilter ? "sent.filter.submitter.containsnot" : "sent.filter.sender.containsnot", new Object[]{filter.getSender()}));
            } else {
                result.append(messages.at(isDsFilter ? "sent.filter.submitter.contains" : "sent.filter.sender.contains", new Object[]{filter.getSender()}));
            }
        }
        if (filter.getAmountComparator() != null && filter.getFromAmount() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(messages.at("sent.filter.amount", new Object[]{filter.getAmountComparator().ordinal(), filter.getFromAmount(), filter.getToAmount()}));
        }
        if (isDsOverviewFilter && filter.getDsOverviewSigned() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            if (filter.getDsOverviewSigned() == Boolean.FALSE) {
                result.append(messages.at("sent.filter.signed", new Object[0]));
            } else {
                result.append(messages.at("sent.filter.notSigned", new Object[0]));
            }
        }
        return result.toString();
    }

    public static String loadJsParameters(Messages messages, List<Send> sendList, boolean useQuickSign, User user) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("fetchingMessage", messages.at("sent.fetching", new Object[0]));
        resultJson.put("saveLink", routes.Sent.save("999").toString());
        resultJson.put("updateLink", routes.Sent.update().toString());
        resultJson.put("indexLink", routes.Sent.index().toString());
        resultJson.put("useQuickSign", useQuickSign);
        resultJson.put("cancelMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.cancel", (Object[])new Object[0]));
        resultJson.put("addDecimalsUrl", routes.Application.addSumsWithCurrencyDecimals().toString());
        boolean allowAllStates = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.ALLOW_CALLBACK_FOR_ALL_STATES);
        resultJson.put("alwaysAllowCallback", allowAllStates);
        if (sendList != null && !sendList.isEmpty()) {
            ArrayNode sendItemsNode = resultJson.putArray("senditems");
            for (int i = 0; i < sendList.size(); ++i) {
                Send sent2 = sendList.get(i);
                ObjectNode sendItemNode = sendItemsNode.addObject();
                sendItemNode.put("pos", i);
                sendItemNode.put("id", sent2.getId());
                if (sent2.getAmount() != null) {
                    sendItemNode.put("amount", sent2.getAmount().toPlainString());
                }
                sendItemNode.put("currency", sent2.getCurrency());
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadProtocolModalJsParameters(Messages messages, String checkboxPrefix, boolean forPayments) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("checkboxPrefix", checkboxPrefix);
        resultJson.put("user", messages.at("bankdetails.userprofile.user", new Object[0]));
        resultJson.put("action", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.action", (Object[])new Object[0]));
        resultJson.put("message", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.message", (Object[])new Object[0]));
        resultJson.put("additionalInfo", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.additionalInformationSingular", (Object[])new Object[0]));
        resultJson.put("title", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.customerProtocol", (Object[])new Object[0]));
        resultJson.put("fetching", messages.at("sent.protocol.fetching", new Object[0]));
        resultJson.put("order", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.protocolOfOrder", (Object[])new Object[]{"ORDERTYPE", "ORDERID"}));
        if (forPayments) {
            resultJson.put("printLink", routes.SignedPayments.printProtocol(999).toString());
            resultJson.put("protocolLink", routes.SignedPayments.protocol(999).toString());
        } else {
            resultJson.put("printLink", routes.Sent.printProtocol(999).toString());
            resultJson.put("protocolLink", routes.Sent.protocol(999).toString());
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadSignOrderJsParameters(Messages messages, List<BankOrderWithPayments> bankOrders, Http.Request request) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("pageTitle", messages.at("signorder.page", new Object[]{999, bankOrders.size()}));
        resultJson.put("removedMessage", messages.at("signorder.removed", new Object[0]));
        resultJson.put("vopTooltip", messages.at("signorder.vopHint", new Object[0]));
        resultJson.put("vopButtonLabelSign", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.sign", (Object[])new Object[0]));
        resultJson.put("vopButtonLabelSubmit", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.submit", (Object[])new Object[0]));
        ArrayNode printUrlsNode = resultJson.putArray("printUrls");
        ObjectNode websocketRequestNode = resultJson.putObject("websocketRequest");
        websocketRequestNode.put("user", (String)request.attrs().get(Security.USERNAME));
        ArrayNode websocketRequestOrdersNode = websocketRequestNode.putArray("ords");
        StringBuilder paymentdIdsBuilder = new StringBuilder();
        int counter = 0;
        for (BankOrderWithPayments bankOrder : bankOrders) {
            printUrlsNode.addObject().put("id", counter++).put("url", routes.Sent.printTicket(bankOrder.toString()).toString());
            ObjectNode websocketRequestOrderNode = websocketRequestOrdersNode.addObject();
            websocketRequestOrderNode.put("info", bankOrder.toString());
            List<OpenPayment> openPayments = bankOrder.getOpenPayments();
            if (openPayments == null || openPayments.isEmpty()) continue;
            paymentdIdsBuilder.setLength(0);
            for (OpenPayment openPayment : openPayments) {
                if (openPayment.getId() == null) continue;
                if (!paymentdIdsBuilder.isEmpty()) {
                    paymentdIdsBuilder.append(',');
                }
                paymentdIdsBuilder.append(openPayment.getId());
            }
            websocketRequestOrderNode.put("pmts", paymentdIdsBuilder.toString());
        }
        resultJson.put("websocketUrl", Utils.webSocketUrl((Call)routes.Sent.signPaymentsController(), request));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static void printPaymentsToSendReport(File file2, BLDocument document, PaymentTransferType.PmtType pmtType, User user, Locale locale, boolean pageBreak) {
        try {
            if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
                SepaDetailsPrinter.addCreditToDocument((File)file2, (BLDocument)document, (boolean)pageBreak, (Locale)locale, (User)user);
            } else if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
                SepaDetailsPrinter.addDebitToDocument((File)file2, (BLDocument)document, (boolean)pageBreak, (Locale)locale, (User)user);
            } else if (DtazvApi.isDtazvPmtType((PaymentTransferType.PmtType)pmtType)) {
                DtazvDetailsPrinter.printPaymentInformation((File)file2, (BLDocument)document, (Locale)locale, (boolean)pageBreak);
            } else if (MT101Api.isMt101PmtType((PaymentTransferType.PmtType)pmtType)) {
                MT101DetailsPrinter.addToDocument((File)file2, (BLDocument)document, (boolean)pageBreak, (Locale)locale);
            }
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to print payment information to send report!", e);
        }
    }

    public Result index_tenant(Http.Request request, Integer tenant) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.SEND).setProperty("TENANT", tenant != null ? String.valueOf(tenant) : null);
        return Sent.redirect((Call)routes.Sent.index());
    }

    public Result index(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SendFilter filter = SendFilter.getFilter((User)user);
        Form filterForm = this.formFactory.form(SendFilterForm.class).fill((Object)new SendFilterForm(filter, false));
        return this.internalIndex(request, user, (Form<SendFilterForm>)filterForm, filter);
    }

    public Result indexSort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.SEND).updateSort(sort, asc);
        return Sent.redirect((Call)routes.Sent.index());
    }

    public Result indexPageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.SEND).updatePage(page, pageSize);
        return Sent.redirect((Call)routes.Sent.index());
    }

    private Result internalIndex(Http.Request request, User user, Form<SendFilterForm> filterForm, SendFilter filter) {
        List list;
        Tenant tenant;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.SEND);
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException e) {
            tenant = null;
        }
        Query query = this.sendQuery(user, sorting.getSortingColumn(), sorting.isSortingAscending(), filter, tenant);
        sorting.computeForQuery(query);
        query = query.setMaxRows(sorting.getPageSize()).setFirstRow(sorting.getPageNumber() * sorting.getPageSize());
        try {
            list = query.findPagedList().getList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.SEND, (Call)routes.Sent.index());
        }
        return Sent.ok((Content)sent.render(list, sorting, filterForm, filter, (Form<PasswordForm>)this.formFactory.form(PasswordForm.class), false, WebAuthnData.buildForSigning(user), tenant, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result filter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SendFilter sendFilter = SendFilter.getFilter((User)user);
        if (active) {
            Form<SendFilterForm> form = this.formFactory.form(SendFilterForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((SendFilterForm)form.get()).validate(form, sendFilter, false);
            }
            if (form.hasErrors()) {
                return this.internalIndex(request, user, form, sendFilter);
            }
            sendFilter.activateFor(SendFilter.SendFilterType.SENT_FILES);
        } else {
            sendFilter.setSendActive(false);
        }
        sendFilter.save();
        return Sent.redirect((Call)routes.Sent.index());
    }

    public CompletionStage<Result> update(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<ScheduledFuture> futures = new ArrayList<ScheduledFuture>();
            boolean fetched2 = false;
            HashMap<String, String> flashMap = new HashMap<String, String>();
            for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
                if (bankUser.getState() != BankUser.UserState.READY) continue;
                try {
                    EbicsWorker worker = EbicsUtil.getEbicsWorker(bankUser);
                    futures.add(CustomerProtocolPostScheduler.fetchProtocolNow((EbicsWorker)worker, (BankUser)bankUser));
                }
                catch (IOException | GeneralSecurityException e) {
                    BLLoggerPlay.error("An error occurred while fetching customer protocol from bank " + bankUser.getBank().getDisplayName() + ":", e);
                    Utils.addToFlash(flashMap, "error", messages.at("sent.error.whileFetchingCustomerProtocol", new Object[]{bankUser.getBank().getDisplayName()}) + " " + String.valueOf(e));
                }
            }
            for (ScheduledFuture future : futures) {
                try {
                    future.get();
                    fetched2 = true;
                }
                catch (InterruptedException | ExecutionException e) {
                    BLLoggerPlay.error("Failed to wait for update execution result!", e);
                }
            }
            if (fetched2) {
                flashMap.put("success", messages.at("sent.updated.success", new Object[0]));
            } else {
                flashMap.put("warning", messages.at("sent.updated.nothingToFetch", new Object[0]));
            }
            return Sent.ok().flashing(flashMap);
        }, this.executionContext.current());
    }

    public Result protocol(Http.Request request, int id) {
        Send send = (Send)DB.find(Send.class, (Object)id);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ObjectNode result = Json.newObject();
        if (send == null) {
            result.put("error", messages.at("sent.protocol.noentries", new Object[0]));
            return Sent.ok((byte[])Json.asciiStringify((JsonNode)result).getBytes(StandardCharsets.US_ASCII));
        }
        OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
        if (!permissionChecker.hasAccountPermissions(user, send)) {
            result.put("error", permissionChecker.getErrorMessage());
            return Sent.ok((byte[])Json.asciiStringify((JsonNode)result).getBytes(StandardCharsets.US_ASCII));
        }
        boolean addedEntry = false;
        List hacs = ProtocolUtil.getHacEntries((Send)send).findList();
        if (send.getFileType() != null) {
            result.put("ordertype", send.getFileType());
        } else {
            result.put("ordertype", send.getOrderType());
        }
        result.put("orderid", send.getOrderNumber());
        if (hacs.isEmpty()) {
            List ptks = ProtocolUtil.getPtkEntries((Send)send).findList();
            if (!ptks.isEmpty()) {
                ArrayNode ptksNode = result.putArray("ptks");
                for (PtkEntry ptk : ptks) {
                    ObjectNode ptkNode = Json.newObject();
                    ptkNode.put("ptk", ptk.getData());
                    ptksNode.add((JsonNode)ptkNode);
                }
                addedEntry = true;
            }
        } else {
            ArrayNode hacsNode = result.putArray("hacs");
            HashMap<String, String> userNameMap = new HashMap<String, String>();
            for (HacEntry hac : hacs) {
                ObjectNode hacNode = Json.newObject();
                hacNode.put("time", DateFormat.getDateTimeInstance(2, 2, messages.lang().locale()).format(hac.getHacTime()));
                String hacUserDefaultName = hac.getUserRepresentation();
                String hacUserName = (String)userNameMap.get(hacUserDefaultName);
                if (hacUserName == null) {
                    hacUserName = DesHistory.getHACActionUser(hac);
                    userNameMap.put(hacUserDefaultName, hacUserName);
                }
                hacNode.put("user", hacUserName);
                if (hac.getAction() != null) {
                    HAC30Entry.Action action = HAC30Entry.Action.values()[hac.getAction()];
                    hacNode.put("axn", HAC30Entry.getActionRepresentation((Locale)messages.lang().locale(), (HAC30Entry.Action)action));
                    hacNode.put("rsn", HAC30Entry.getReasonMessage((Locale)messages.lang().locale(), (String)hac.getReason(), (HAC30Entry.Action)action));
                }
                if (hac.getAdditionalInformation() != null) {
                    hacNode.put("addtnl", hac.getAdditionalInformation());
                }
                hacsNode.add((JsonNode)hacNode);
            }
            addedEntry = true;
        }
        if (!addedEntry) {
            result.put("error", messages.at("sent.protocol.noentries", new Object[0]));
        }
        return Sent.ok((byte[])Json.asciiStringify((JsonNode)result).getBytes(StandardCharsets.US_ASCII));
    }

    public CompletionStage<Result> printProtocol(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            List ptks;
            String protocolName;
            Send send = (Send)DB.find(Send.class, (Object)id);
            if (send == null) {
                return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.protocol.noentries", new Object[0]));
            }
            OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
            if (!permissionChecker.hasAccountPermissions(user, send)) {
                return Sent.redirect((Call)routes.Sent.index()).flashing("error", permissionChecker.getErrorMessage());
            }
            List hacs = ProtocolUtil.getHacEntries((Send)send).findList();
            String title = send.getFileType() != null ? BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.protocolOfOrder", (Object[])new Object[]{send.getFileType(), send.getOrderNumber()}) : BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.protocolOfOrder", (Object[])new Object[]{send.getOrderType(), send.getOrderNumber()});
            if (!hacs.isEmpty()) {
                protocolName = "HACReport";
                ptks = null;
            } else {
                ptks = ProtocolUtil.getPtkEntries((Send)send).findList();
                protocolName = "PTKReport";
            }
            ProtocolPrinter printer = new ProtocolPrinter(protocolName, title);
            boolean closePrinterInFinally = true;
            try {
                boolean printLogo = GeneralUtils.printLogo(user);
                File file2 = printer.createDocument(messages.lang().locale(), false, printLogo);
                for (HacEntry hac : hacs) {
                    printer.addHac(hac);
                }
                if (ptks != null) {
                    for (PtkEntry ptk : ptks) {
                        printer.addPtk(ptk);
                    }
                }
                closePrinterInFinally = false;
                printer.close();
                Util.applyPreferencesToPdf((File)file2, (User)user, null, (Locale)messages.lang().locale(), null, null, (boolean)printLogo);
                Result result = GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
                return result;
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to create PDF file for protocol!", e);
                Result result = Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.protocol.print.failed", new Object[]{e}));
                return result;
            }
            finally {
                if (closePrinterInFinally) {
                    try {
                        printer.close();
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to create PDF file for protocol!", e);
                    }
                }
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> printOrders(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List<Integer> ids = GeneralUtils.getSelectionIds(((String[])request.body().asFormUrlEncoded().get("sendItemIds"))[0]);
        if (ids.size() == 1) {
            return this.printOrder(request, ids.getFirst());
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<File> files = new ArrayList<File>();
                OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
                for (Integer id : ids) {
                    File file2;
                    Send send = (Send)DB.find(Send.class, (Object)id);
                    if (send == null || !permissionChecker.hasAccountPermissions(user, send) || (file2 = Branding.getBranding().printSendReport(send, user, messages)) == null) continue;
                    boolean printLogo = GeneralUtils.printLogo(user);
                    Util.applyPreferencesToPdf((File)file2, (User)user, null, (Locale)messages.lang().locale(), null, null, (boolean)printLogo);
                    files.add(file2);
                }
                if (files.isEmpty()) {
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.printreport.failed", new Object[]{permissionChecker.getErrorMessage()}));
                }
                return GeneralUtils.supplyZipFile(files, true, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("SendReports.zip"));
            }
            catch (Exception e) {
                BLLoggerPlay.error("Failed to create send report!", e);
                return Sent.redirect((Call)routes.Sent.index()).flashing("HTMLerror", messages.at("sent.printreport.failed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> printOrder(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            String flashMessage;
            Send send = (Send)DB.find(Send.class, (Object)id);
            String flashKey = "error";
            if (send == null) {
                flashMessage = messages.at("sent.printreport.notfound", new Object[0]);
            } else {
                OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
                if (!permissionChecker.hasAccountPermissions(user, send)) {
                    flashMessage = permissionChecker.getErrorMessage();
                } else {
                    try {
                        File file2 = Branding.getBranding().printSendReport(send, user, messages);
                        if (file2 != null) {
                            boolean printLogo = GeneralUtils.printLogo(user);
                            Util.applyPreferencesToPdf((File)file2, (User)user, null, (Locale)messages.lang().locale(), null, null, (boolean)printLogo);
                            return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
                        }
                        flashMessage = messages.at("sent.printreport.failed", new Object[]{""});
                    }
                    catch (PDFException | IOException | GeneralSecurityException e) {
                        BLLoggerPlay.error("Failed to create send report!", e);
                        flashMessage = messages.at("sent.printreport.failed", new Object[]{Utils.getLocalizedMessage(e, messages)});
                        flashKey = "HTMLerror";
                    }
                }
            }
            return Sent.redirect((Call)routes.Sent.index()).flashing(flashKey, flashMessage);
        }, this.executionContext.current());
    }

    public CompletionStage<Result> printTicket(Http.Request request, String bankOrderString) {
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        final User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            try {
                final BankOrder bankOrder = BankOrder.fromString(user, bankOrderString, messages.lang().toLocale());
                if (bankOrder == null) {
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.printreport.notfound", new Object[0]));
                }
                Tenant tenant = bankOrder.getBank().getTenant();
                StringBuilder buffer = new StringBuilder();
                bankOrder.getDisplayMessage().getSigningInfo().appendText(messages.lang().locale(), buffer);
                File file2 = new DisplayMessagePrinter(this, user, messages.lang().locale(), tenant){

                    protected void printPayments(BLDocument document, File file2, boolean pageBreak) {
                        Sent.printPaymentsToSendReport(file2, document, bankOrder.getPmtType(), user, messages.lang().locale(), pageBreak);
                    }
                }.print(bankOrder.getOrderFile(), buffer.toString());
                return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            catch (DisplayFileException | KnownFormatException | PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to print display file!", e);
                return Sent.redirect((Call)routes.Sent.index()).flashing("HTMLerror", messages.at("sent.printticket.failed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public Result orderDetails(Http.Request request, Integer id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Send send = (Send)DB.find(Send.class, (Object)id);
        if (send == null) {
            return Sent.redirect((Call)routes.Sent.index()).flashing("error", "order " + id + " not found.");
        }
        OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
        if (!permissionChecker.hasAccountPermissions(user, send)) {
            return Sent.redirect((Call)routes.Sent.index()).flashing("error", permissionChecker.getErrorMessage());
        }
        return Sent.ok((Content)sentdetails.render((Form<PasswordForm>)this.formFactory.form(PasswordForm.class), send, false, WebAuthnData.buildForSigning(user), null, request, messages));
    }

    public Result paymentDetails(Http.Request request, int id, int pageNumber) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Send send = (Send)DB.find(Send.class, (Object)id);
        if (send == null) {
            return Sent.redirect((Call)routes.Sent.index()).flashing("error", "order " + id + " not found.");
        }
        OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
        if (!permissionChecker.hasAccountPermissions(user, send)) {
            return Sent.redirect((Call)routes.Sent.index()).flashing("error", permissionChecker.getErrorMessage());
        }
        List<DsOrderPaymentInfo> paymentInfos = DsOrderPaymentInfo.loadForSendOrder(send);
        return this.loadPaymentDetails(paymentInfos, request, id, pageNumber, send);
    }

    public CompletionStage<Result> exportSend(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean displaySalaries = Util.displaySalaries((User)user);
        return CompletableFuture.supplyAsync(() -> {
            File exportFile;
            block9: {
                Send send = (Send)DB.find(Send.class, (Object)id);
                if (send == null) {
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", "order " + id + " not found.");
                }
                OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
                if (!permissionChecker.hasAccountPermissions(user, send)) {
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", permissionChecker.getErrorMessage());
                }
                exportFile = new File(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.paymentDetails", (Object[])new Object[0]) + ".csv");
                List<Object> paymentObjects = DsOrderPaymentInfo.loadForSendOrder(send).stream().filter(pi -> pi.getPayment() != null).map(pi -> pi.getPayment().getPayment()).toList();
                if (paymentObjects.isEmpty()) {
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("error.failedcsvexport", new Object[]{messages.at("desoverview.export.nodata", new Object[0])}));
                }
                try {
                    if (paymentObjects.getFirst() instanceof DTAZVPayment) {
                        List<DTAZVPayment> dtazvPaymentObjects = paymentObjects.stream().map(o -> (DTAZVPayment)o).toList();
                        new DTAZVPaymentCsvExport(messages.lang().locale()).write(exportFile, dtazvPaymentObjects);
                        break block9;
                    }
                    if (paymentObjects.getFirst() instanceof SEPAPaymentData) {
                        List<SEPAPaymentData> sepaPaymentObjects = paymentObjects.stream().map(o -> (SEPAPaymentData)o).toList();
                        new SEPAPaymentDataCsvExport(messages.lang().locale(), SepaApi.isCreditPmtType((PaymentTransferType.PmtType)send.getPmtType()), displaySalaries).write(exportFile, sepaPaymentObjects);
                        break block9;
                    }
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("error.failedcsvexport", new Object[]{messages.at("desoverview.export.onlysepadtazv", new Object[0])}));
                }
                catch (IOException e) {
                    return Sent.redirect((Call)routes.Sent.index()).flashing("HTMLerror", messages.at("error.failedcsvexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                }
            }
            try {
                return GeneralUtils.supplyWorkspaceFile(exportFile, true, false).as("binary/octet-stream").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(exportFile.getName()));
            }
            catch (IOException | GeneralSecurityException e) {
                return Sent.redirect((Call)routes.Sent.index()).flashing("HTMLerror", messages.at("desoverview.exportfailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public Result loadPaymentDetails(List<DsOrderPaymentInfo> paymentInfos, Http.Request request, int id, int pageNumber, Send send) {
        Form paymentForm;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (paymentInfos.isEmpty()) {
            BLLoggerPlay.warning("No payment details found for order " + send.getId());
            return Sent.redirect((Call)routes.Sent.orderDetails(id)).flashing("error", messages.at("sentdetails.error.nopayments", new Object[0]));
        }
        if (pageNumber < paymentInfos.size()) {
            try {
                boolean allowRecipientRecording;
                DsOrderPaymentInfo paymentInfo = paymentInfos.get(pageNumber);
                boolean bl = allowRecipientRecording = !PreferenceUtil.disableRecipientRecording((User)user);
                if (paymentInfo.getPayment() != null) {
                    Object paymentObject = paymentInfo.getPayment().getPayment();
                    if (Util.hideSalariesCompletely((User)user) && paymentInfo.getPayment().isSalaryPayment()) {
                        paymentForm = null;
                    }
                    if (paymentObject instanceof SEPAPaymentData) {
                        PaymentHandler<?> paymentHandler = paymentInfo.getPayment();
                        Objects.requireNonNull(paymentHandler);
                        PaymentHandler<?> paymentHandler2 = paymentHandler;
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PostbarPaymentHandler.class, TaxOfficePaymentHandler.class, AustrianForeignPaymentHandler.class}, paymentHandler2, n)) {
                            case 0: {
                                PostbarPaymentHandler ignored = (PostbarPaymentHandler)paymentHandler2;
                                paymentForm = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm((Object)send, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                                break;
                            }
                            case 1: {
                                TaxOfficePaymentHandler ignored2 = (TaxOfficePaymentHandler)paymentHandler2;
                                paymentForm = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm((Object)send, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                                break;
                            }
                            case 2: {
                                AustrianForeignPaymentHandler ignored3 = (AustrianForeignPaymentHandler)paymentHandler2;
                                paymentForm = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)new AustrianForeignPaymentForm((Object)send, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                                break;
                            }
                            default: {
                                boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION);
                                paymentForm = this.formFactory.form(SepaPaymentForm.class).fill((Object)new SepaPaymentForm(send, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), allowRecipientRecording, useMandates, false));
                                break;
                            }
                        }
                    }
                    if (paymentObject instanceof DTAZVPayment) {
                        paymentForm = this.formFactory.form(DtazvPaymentForm.class).fill((Object)new DtazvPaymentForm(send, (DTAZVPayment)paymentObject, allowRecipientRecording, false));
                    }
                    if (paymentObject instanceof MT101PaymentData) {
                        paymentForm = this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(send, (MT101PaymentData)paymentObject, allowRecipientRecording, false));
                    }
                    return Sent.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("error", messages.at("desoverview.unknownpaymenttype", new Object[0]));
                }
                DsOrderDetails orderdet = new SendOrderHandler(send).parseProtocol(messages.lang().locale());
                paymentForm = this.formFactory.form(HvtPaymentForm.class).fill((Object)new HvtPaymentForm(orderdet, paymentInfo.getHvtOrder()));
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to load payment information for open DES order " + id + ", page number: " + pageNumber + "!", e);
                return Sent.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToLoadPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        } else {
            BLLoggerPlay.warning("Page number out of range for order " + send.getId());
            return Sent.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
        }
        int pageCount = paymentInfos.size();
        return Sent.ok((Content)sentpaymentdetails.render(send, (Form<? extends PaymentForm>)paymentForm, pageNumber, pageCount, request, messages));
    }

    public Result sendFileForm(Http.Request request) {
        return Sent.ok((Content)sendfile.render((Form<SendFileForm>)this.formFactory.form(SendFileForm.class), new HashMap<String, String>(), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> prepareSendFile(Http.Request request) {
        Form form = this.formFactory.form(SendFileForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Http.MultipartFormData multipart = request.body().asMultipartFormData();
        Http.MultipartFormData.FilePart csvPart = multipart.getFile("send_order_file");
        List fileParts = multipart.getFiles();
        List<String> originalFileNames = fileParts.stream().map(Http.MultipartFormData.FilePart::getFilename).toList();
        File csvFile = csvPart != null ? ((Files.TemporaryFile)csvPart.getRef()).path().toFile() : null;
        ArrayList<File> files = new ArrayList<File>();
        for (Http.MultipartFormData.FilePart part : fileParts) {
            File f = ((Files.TemporaryFile)part.getRef()).path().toFile();
            if (f.length() <= 0L) continue;
            files.add(f);
        }
        return CompletableFuture.supplyAsync(() -> {
            List<BankOrderWithPayments> bankOrders = new ArrayList<BankOrderWithPayments>();
            HashMap<String, Send> existingOrders = new HashMap<String, Send>();
            HashMap<String, String> fMap = new HashMap<String, String>();
            Form validatedForm = !form.hasErrors() ? ((SendFileForm)form.get()).validate((Form<SendFileForm>)form, user, files, originalFileNames) : form;
            File file2 = null;
            ArrayList<BankOrderWithFileAndPossibleBanks> bankOrdersWithFileAndBanks = new ArrayList<BankOrderWithFileAndPossibleBanks>();
            if (!validatedForm.hasErrors()) {
                boolean isCSV = ((SendFileForm)validatedForm.get()).isCSVPaymentFile();
                PaymentTransferType.PmtType pmtType = null;
                if (isCSV) {
                    if (csvFile == null) {
                        BLLoggerPlay.error("Failed to take over uploaded CSV file from user " + user.getName());
                        validatedForm = validatedForm.withError("send_order_file", messages.at("sent.send.error.failedtoload", new Object[]{"file not found"}));
                        return Sent.ok((Content)sendfile.render((Form<SendFileForm>)validatedForm, fMap, request, messages));
                    }
                    bankUser = ((SendFileForm)validatedForm.get()).getBankUser();
                    pmtType = PaymentTransferType.PmtType.valueOf((String)((SendFileForm)validatedForm.get()).pmtTypeName);
                    orderOrFileType = SendParameters.getTransferTypeByBank((BankSettings)bankUser.getBank(), (PaymentTransferType.PmtType)pmtType);
                    if (validatedForm.hasErrors()) {
                        BLLoggerPlay.error("Failed to store the payments CSV file!");
                        validatedForm = validatedForm.withError("send_order_file", messages.at("sent.send.error.failedtoload", new Object[0])).withError("encoding", messages.at("payment.import.checkEncoding", new Object[0]));
                    } else {
                        PaymentCsvImportForm paymentCsvImportForm = new PaymentCsvImportForm();
                        HashMap<String, String> dataMap = new HashMap<String, String>();
                        ((SendFileForm)validatedForm.get()).prepareForCsv(csvFile, user);
                        ConverterFormat converterFormat = ((SendFileForm)validatedForm.get()).getConverterFormat();
                        Integer converterFormatId = converterFormat == null ? -1 : converterFormat.getId();
                        String[][] importData = paymentCsvImportForm.loadFromCsv(user, csvFile, pmtType, PaymentContextType.SENT_PAYMENT, dataMap, ((SendFileForm)validatedForm.get()).getPaymentConversionHandler(), ((SendFileForm)validatedForm.get()).getPaymentConversionHandler2(), converterFormat, ((SendFileForm)validatedForm.get()).encoding);
                        if (importData == null || importData.length == 0) {
                            validatedForm = validatedForm.withError("send_order_file", messages.at("payment.import.failed", new Object[]{"content is empty."})).withError("encoding", messages.at("payment.import.checkEncoding", new Object[0]));
                        } else {
                            DynamicForm csvImportForm = this.formFactory.form().fill(new HashMap<String, String>(dataMap));
                            try {
                                Send existingOrder2;
                                String fileId = CsvImport.writeDataToFile(importData);
                                String md5 = SystemUtils.calculateMD5Hash((File)csvFile);
                                if (new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CHECK_DOUBLE_TRANSMISSION) && (existingOrder2 = Send.findNewestByHash((String)md5)) != null) {
                                    existingOrders.put(existingOrder2.getOrigFileName(), existingOrder2);
                                }
                                return Sent.ok((Content)sendorderfromcsv.render((Form<DynamicForm.Dynamic>)csvImportForm, paymentCsvImportForm.getColumnFields(messages), importData, ((SendFileForm)validatedForm.get()).bankId, ((SendFileForm)validatedForm.get()).pmtTypeName, (String)orderOrFileType, converterFormatId, md5, csvPart.getFilename(), existingOrders, fileId, ((SendFileForm)validatedForm.get()).encoding, request, messages));
                            }
                            catch (IOException | GeneralSecurityException e2) {
                                BLLoggerPlay.error("Failed to store the payments CSV file!", e2);
                                validatedForm = validatedForm.withError("send_order_file", messages.at("sent.send.error.failedtoload", new Object[0])).withError("encoding", messages.at("payment.import.checkEncoding", new Object[0]));
                            }
                        }
                    }
                } else {
                    boolean singleFile = fileParts.size() == 1;
                    for (Http.MultipartFormData.FilePart part : fileParts) {
                        File formFile = ((Files.TemporaryFile)part.getRef()).path().toFile();
                        try {
                            Send existingOrder;
                            String md5 = SystemUtils.calculateMD5Hash((File)formFile);
                            if (new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CHECK_DOUBLE_TRANSMISSION) && (existingOrder = Send.findNewestByHash((String)md5)) != null) {
                                existingOrders.put(existingOrder.getOrigFileName(), existingOrder);
                            }
                            ArrayList possibleBanks = null;
                            if (((SendFileForm)validatedForm.get()).isSepaFile()) {
                                SendFileDetector.Result result = new SepaSendFileDetector().detect(formFile, user);
                                Map bankTransferTypeMap = result.getBankTransferTypeMap();
                                if (bankTransferTypeMap == null || bankTransferTypeMap.isEmpty()) {
                                    BLLoggerPlay.error("No bank detected!");
                                    Result existingOrder2 = Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("fetched.fetch.error.nobank", new Object[0]));
                                    return existingOrder2;
                                }
                                possibleBanks = new ArrayList(bankTransferTypeMap.keySet());
                                BankSettings bank = (BankSettings)possibleBanks.getFirst();
                                bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
                                orderOrFileType = (String)bankTransferTypeMap.get(bank);
                            } else {
                                bankUser = ((SendFileForm)validatedForm.get()).getBankUser();
                                orderOrFileType = ((SendFileForm)validatedForm.get()).orderOrFileType;
                            }
                            file2 = BankOrder.createOrderFile((String)bankUser.getBank().getUniqueKey(), (String)orderOrFileType, null);
                            Streams.copy((InputStream)Files.newInputStream(formFile.toPath(), new OpenOption[0]), (OutputStream)EncryptData.getInstance().openOutputStream(file2));
                            long originalFileSize = formFile.length();
                            BankOrder bankOrder = new BankOrder(bankUser, (String)orderOrFileType, file2, originalFileSize, md5, part.getFilename(), messages.lang().toLocale());
                            bankOrders.add(new BankOrderWithPayments(bankOrder, null));
                            if (!((SendFileForm)validatedForm.get()).isSepaFile() || possibleBanks == null || possibleBanks.size() <= 1) continue;
                            ArrayList<Tuple2<String, String>> possibleBanksSeqList = new ArrayList<Tuple2<String, String>>(possibleBanks.size());
                            for (BankSettings bank : possibleBanks) {
                                Object bankName = bank.getDisplayName();
                                if (user.getTenants().size() > 1) {
                                    bankName = (String)bankName + " (" + bank.getTenant().getName() + ")";
                                }
                                possibleBanksSeqList.add((Tuple2<String, String>)Scala.Tuple((Object)String.valueOf(bank.getBankId()), (Object)Utils.addZWNJ((String)bankName)));
                            }
                            bankOrdersWithFileAndBanks.add(new BankOrderWithFileAndPossibleBanks(bankOrder, part.getFilename(), possibleBanksSeqList));
                        }
                        catch (DisplayFileException | InvalidFileException e) {
                            BLLoggerPlay.error("Failed to take over uploaded file from user " + user.getName(), e);
                            String msg = messages.at("sent.send.error.parse", new Object[0]);
                            if (singleFile) {
                                validatedForm = validatedForm.withError("send_order_file", messages.at("sent.send.error.failedtoload", new Object[]{msg}));
                                continue;
                            }
                            Utils.addToFlash(fMap, "error", part.getFilename() + " : " + messages.at("sent.send.error.failedtoload", new Object[]{msg}));
                        }
                        catch (KnownFormatException | IOException | GeneralSecurityException e) {
                            BLLoggerPlay.error("Failed to take over uploaded file from user " + user.getName(), e);
                            if (singleFile) {
                                validatedForm = validatedForm.withError("send_order_file", messages.at("sent.send.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                                continue;
                            }
                            Utils.addToFlash(fMap, "HTMLerror", part.getFilename() + " : " + messages.at("sent.send.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                        }
                        catch (SendFileAutoDetectException e) {
                            String message;
                            if (e.getCause() != null) {
                                Throwable cause = e.getCause();
                                if (cause instanceof SAXParseException) {
                                    SAXParseException saxException = (SAXParseException)cause;
                                    String tmp = saxException.getMessage();
                                    if (tmp != null && tmp.contains("de.businesslogics.ebics.schema.SimpleStringElement$StringParser: ")) {
                                        tmp = tmp.replace("de.businesslogics.ebics.schema.SimpleStringElement$StringParser: ", "");
                                    }
                                    message = messages.at("sent.send.error.failedtoload.lines", new Object[]{saxException.getLineNumber(), saxException.getColumnNumber(), tmp});
                                } else {
                                    message = messages.at("sent.send.error.failedtoload", new Object[]{e.getMessage(messages.lang().toLocale())});
                                }
                            } else {
                                message = messages.at("sent.send.error.failedtoload", new Object[]{e.getMessage(messages.lang().toLocale())});
                            }
                            BLLoggerPlay.error("Failed to take over uploaded file from user " + user.getName(), e);
                            if (singleFile) {
                                validatedForm = validatedForm.withError("send_order_file", message);
                                continue;
                            }
                            Utils.addToFlash(fMap, "error", part.getFilename() + " : " + message);
                        }
                        catch (IllegalArgumentException e) {
                            if (singleFile) {
                                validatedForm = validatedForm.withError("pmtType", messages.at("payment.error.unknownpaymenttype", new Object[]{((SendFileForm)validatedForm.get()).pmtTypeName}));
                                continue;
                            }
                            Utils.addToFlash(fMap, "error", messages.at("payment.error.unknownpaymenttype", new Object[]{((SendFileForm)validatedForm.get()).pmtTypeName}));
                        }
                        finally {
                            if (formFile.delete()) continue;
                            BLLoggerPlay.warning("Failed to delete temporary file " + formFile.getAbsolutePath() + ", will be deleted on exit!");
                            formFile.deleteOnExit();
                        }
                    }
                }
            }
            if (!bankOrdersWithFileAndBanks.isEmpty()) {
                BankSelectionForm fo = new BankSelectionForm(bankOrdersWithFileAndBanks);
                return Sent.ok((Content)sendfileselectbank.render((Form<BankSelectionForm>)this.formFactory.form(BankSelectionForm.class).fill((Object)fo), bankOrdersWithFileAndBanks, bankOrders, request, messages));
            }
            if (!validatedForm.hasErrors()) {
                RejectingBankOrderCheckHandler<SendFileForm> checkHandler = new RejectingBankOrderCheckHandler<SendFileForm>(validatedForm, fMap, messages);
                for (BankOrderWithPayments bankOrder : bankOrders) {
                    bankOrder.getBankOrder().checkPaymentInformation(user, messages.lang().locale(), checkHandler);
                    if (!checkHandler.hasError()) continue;
                    for (ValidationError error : checkHandler.getForm().errors()) {
                        validatedForm = validatedForm.withError(error);
                    }
                }
            }
            if (validatedForm.hasErrors()) {
                if (file2 != null && !file2.delete()) {
                    BLLoggerPlay.warning("Failed to delete temporary file " + file2.getAbsolutePath() + ", will be deleted on exit!");
                    file2.deleteOnExit();
                }
                return Sent.ok((Content)sendfile.render(validatedForm, fMap, request, messages));
            }
            String requestString = BankOrder.getRequestStringForBankOrders(bankOrders = BankOrderWithPayments.sortByPmtType(bankOrders));
            if (requestString == null) {
                return Sent.ok((Content)sendfile.render(validatedForm, fMap, request, messages));
            }
            Form signOrdersForm = this.formFactory.form(SignOrdersForm.class).fill((Object)SignOrdersForm.fillForm(user, bankOrders));
            if (!new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CHECK_DOUBLE_TRANSMISSION)) {
                existingOrders = null;
            }
            return Sent.ok((Content)signorder.render((Form<SignOrdersForm>)signOrdersForm, bankOrders, Menu.Sent, false, fMap, existingOrders, WebAuthnData.buildForSigning(user), null, request, messages));
        }, this.executionContext.current());
    }

    public CompletionStage<Result> prepareSendFromCsvOrder(Http.Request request, Integer bankId, String pmtTypeName, String orderOrFileType, Integer converterFormatId, String md5Hash, String fileId, String encoding, String originalFileName) {
        Form form = this.formFactory.form(PaymentCsvImportForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            PaymentTransferType.PmtType pmtType;
            WorkspaceFile file2 = CsvImport.getFileById(fileId);
            File f = WorkspaceFileSystem.getFile((WorkspaceFile)file2);
            if (!f.isFile()) {
                BLLoggerPlay.error("Payments import file " + f.getAbsolutePath() + " was not found!");
                return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("payment.importfilenotfound", new Object[0]));
            }
            if (form.value().isEmpty()) {
                return Sent.redirect((Call)routes.Sent.index()).flashing("error", "Received empty form!");
            }
            ArrayList<ValidationError> errors = form.hasErrors() ? new ArrayList<ValidationError>(form.errors()) : null;
            try {
                pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeName);
            }
            catch (IllegalArgumentException e) {
                return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeName}));
            }
            String orderTypeOrBtf = orderOrFileType != null ? orderOrFileType : SendParameters.getTransferTypeByBank((BankSettings)BankSettings.getById((Integer)bankId), (PaymentTransferType.PmtType)pmtType);
            String[][] content = ((PaymentCsvImportForm)form.value().get()).loadFromForm(user, bankId, pmtType, PaymentContextType.SENT_PAYMENT, orderTypeOrBtf, converterFormatId, f);
            String[][] importData = ((PaymentCsvImportForm)form.value().get()).hasHeadline && content.length > 0 ? (String[][])Arrays.copyOfRange(content, 1, content.length) : content;
            if (importData == null || importData.length == 0) {
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.add(new ValidationError("", messages.at("payment.importfilenotfound", new Object[0])));
            }
            List<CsvImport.Field> columnFields = ((PaymentCsvImportForm)form.value().get()).getColumnFields(messages);
            DynamicForm dynamicForm = this.formFactory.form().fill(new HashMap(form.rawData()));
            if (errors != null) {
                for (ValidationError validationError : errors) {
                    dynamicForm = dynamicForm.withError(validationError);
                }
            } else {
                Form<PaymentCsvImportForm> validatedForm = ((PaymentCsvImportForm)form.get()).validate((Form<PaymentCsvImportForm>)form, PaymentContextType.OPEN_PAYMENT, bankId, user, null, null, null, null, null, importData, messages);
                if (validatedForm.hasErrors()) {
                    for (Object error : validatedForm.errors()) {
                        dynamicForm = dynamicForm.withError((ValidationError)error);
                    }
                }
            }
            HashMap<String, Send> existingOrders = new HashMap<String, Send>();
            if (new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CHECK_DOUBLE_TRANSMISSION)) {
                Send send = Send.findNewestByHash((String)md5Hash);
                if (send != null) {
                    existingOrders.put(send.getOrigFileName(), send);
                }
            } else {
                existingOrders = null;
            }
            if (dynamicForm.hasErrors()) {
                return Sent.ok((Content)sendorderfromcsv.render((Form<DynamicForm.Dynamic>)dynamicForm, columnFields, content, bankId, pmtTypeName, orderTypeOrBtf, converterFormatId, md5Hash, originalFileName, existingOrders, fileId, encoding, request, messages));
            }
            errors = new ArrayList();
            List<BankOrderWithPayments> list = ((PaymentCsvImportForm)form.get()).createBankOrders((Form<PaymentCsvImportForm>)form, user, importData, bankId, pmtType, orderTypeOrBtf, messages, encoding, errors);
            if ((list == null || list.isEmpty()) && !form.hasErrors()) {
                for (ValidationError error : errors) {
                    dynamicForm = dynamicForm.withError(error);
                }
                if (!dynamicForm.hasErrors()) {
                    dynamicForm = dynamicForm.withGlobalError(messages.at("sent.import.csv.couldnotconvertpayment", new Object[]{0}));
                }
            }
            if (list != null) {
                for (BankOrderWithPayments bankOrder : list) {
                    bankOrder.getBankOrder().setOriginalFileName(originalFileName);
                }
            }
            HashMap<String, String> flashMap = new HashMap<String, String>();
            if (!dynamicForm.hasErrors() && list != null) {
                RejectingBankOrderCheckHandler checkHandler = new RejectingBankOrderCheckHandler(dynamicForm, (Map<String, String>)flashMap, messages);
                for (BankOrderWithPayments bankOrder : list) {
                    bankOrder.getBankOrder().checkPaymentInformation(user, messages.lang().locale(), checkHandler);
                    if (!checkHandler.hasError()) continue;
                    dynamicForm = (DynamicForm)checkHandler.getForm();
                    break;
                }
            }
            if (dynamicForm.hasErrors()) {
                return Sent.ok((Content)sendorderfromcsv.render((Form<DynamicForm.Dynamic>)dynamicForm, columnFields, content, bankId, pmtTypeName, orderTypeOrBtf, converterFormatId, md5Hash, originalFileName, existingOrders, fileId, encoding, request, messages));
            }
            List<BankOrderWithPayments> list2 = BankOrderWithPayments.sortByPmtType(list);
            String requestString = BankOrder.getRequestStringForBankOrders(list2);
            if (requestString == null) {
                Utils.addToFlash(flashMap, "error", messages.at("payment.error.csvimportfailed", new Object[0]));
                return Sent.redirect((Call)routes.Sent.index()).flashing(flashMap);
            }
            Form signOrdersForm = this.formFactory.form(SignOrdersForm.class).fill((Object)SignOrdersForm.fillForm(user, list2));
            WorkspaceFileSystem.delete((WorkspaceFile)file2);
            return Sent.ok((Content)signorder.render((Form<SignOrdersForm>)signOrdersForm, list2, Menu.Sent, false, flashMap, existingOrders, WebAuthnData.buildForSigning(user), md5Hash, request, messages));
        }, this.executionContext.current());
    }

    public CompletionStage<Result> prepareSendSelectBank(Http.Request request, String bankOrderString) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(BankSelectionForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            try {
                List<BankOrderWithPayments> bankOrders;
                if (bankOrderString == null || bankOrderString.isEmpty()) {
                    return Sent.redirect((Call)routes.Sent.sendFileForm()).flashing("error", messages.at("sent.send.error.invalidparameter", new Object[]{bankOrderString}));
                }
                HashMap<String, String> flashMap = new HashMap<String, String>();
                List<BankOrderWithPayments> newBankOrders = new ArrayList<BankOrderWithPayments>();
                HashMap<String, Send> existingOrders = new HashMap<String, Send>();
                try {
                    bankOrders = BankOrder.getBankOrdersFromRequestString(user, bankOrderString, null, null, messages.lang().toLocale());
                }
                catch (DisplayFileException | KnownFormatException | IOException e) {
                    return Sent.redirect((Call)routes.Sent.sendFileForm()).flashing("HTMLerror", messages.at("sent.send.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                }
                if (bankOrders == null || bankOrders.isEmpty()) {
                    return Sent.redirect((Call)routes.Sent.sendFileForm()).flashing("error", messages.at("sent.printreport.notfound", new Object[0]));
                }
                if (form.hasErrors()) {
                    return Sent.redirect((Call)routes.Sent.sendFileForm()).flashing("error", messages.at("fetched.fetch.error.nobank", new Object[0]));
                }
                boolean checkDoubleTransmission = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.CHECK_DOUBLE_TRANSMISSION);
                for (BankOrderWithPayments bankOrderWithPayments : bankOrders) {
                    BankOrder bankOrder = bankOrderWithPayments.getBankOrder();
                    if (checkDoubleTransmission) {
                        Send existingOrder = Send.findNewestByHash((String)bankOrder.getMd5Hash());
                        if (existingOrder != null && existingOrder.getOrigFileName() != null) {
                            existingOrders.put(existingOrder.getOrigFileName(), existingOrder);
                        }
                    } else {
                        existingOrders = null;
                    }
                    ((BankSelectionForm)form.get()).setBankOrdersFromString(user, messages.lang().locale());
                    BankOrderWithFileAndPossibleBanks bo = ((BankSelectionForm)form.get()).getFileAndBankForOrder(bankOrder.toString());
                    if (bo.selectedBankId.equals(bankOrder.getBank().getBankId())) {
                        newBankOrders.add(new BankOrderWithPayments(bankOrder, null));
                        continue;
                    }
                    BankSettings targetBank = BankSettings.getById((Integer)bo.selectedBankId);
                    if (targetBank == null) {
                        Utils.addToFlash(flashMap, "warning", MessageFormat.format(messages.at("sent.send.selectbank.file.ignored", new Object[0]), bo.fileName, messages.at("fetched.fetch.error.nobank", new Object[0])));
                        continue;
                    }
                    BankUser targetBankUser = BankUser.findBankUser((BankSettings)targetBank, (User)user);
                    if (!BankUtils.isReady((BankUser)targetBankUser)) {
                        Utils.addToFlash(flashMap, "warning", MessageFormat.format(messages.at("sent.send.selectbank.file.ignored", new Object[0]), bo.fileName, messages.at("fetched.fetch.error.nobankaccess", new Object[0])));
                        continue;
                    }
                    File targetBankOrderFile = BankOrder.createOrderFile((String)targetBank.getUniqueKey(), (String)bankOrder.getOrderType(), null);
                    try {
                        Files.move(bankOrder.getOrderFile().toPath(), targetBankOrderFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to move file " + bankOrder.getOrderFile().getAbsolutePath() + " to " + targetBankOrderFile.getAbsolutePath(), e);
                    }
                    BankOrder targetBankOrder = bankOrder.getPmtType() != null ? new BankOrder(targetBankUser, bankOrder.getPmtType(), targetBankOrderFile, bankOrder.getOrderFileSize(), bankOrder.getMd5Hash(), messages.lang().toLocale()) : new BankOrder(targetBankUser, bankOrder.getOrderType(), targetBankOrderFile, bankOrder.getOrderFileSize(), bankOrder.getMd5Hash(), bankOrder.getOriginalFileName(), messages.lang().toLocale());
                    newBankOrders.add(new BankOrderWithPayments(targetBankOrder, null));
                }
                newBankOrders = BankOrderWithPayments.sortByPmtType(newBankOrders);
                RejectingBankOrderCheckHandler checkHandler = new RejectingBankOrderCheckHandler(form, flashMap, messages);
                for (BankOrderWithPayments bankOrderWithPayments : newBankOrders) {
                    bankOrderWithPayments.getBankOrder().checkPaymentInformation(user, messages.lang().locale(), checkHandler);
                }
                if (checkHandler.getForm().hasErrors()) {
                    void var12_17;
                    Form form2 = this.formFactory.form(SendFileForm.class);
                    for (ValidationError e : checkHandler.getForm().errors()) {
                        Form form3 = var12_17.withError(e);
                    }
                    return Sent.ok((Content)sendfile.render((Form<SendFileForm>)var12_17, flashMap, request, messages));
                }
                Form form4 = this.formFactory.form(SignOrdersForm.class).fill((Object)SignOrdersForm.fillForm(user, newBankOrders));
                return Sent.ok((Content)signorder.render((Form<SignOrdersForm>)form4, newBankOrders, Menu.Sent, false, flashMap, existingOrders, WebAuthnData.buildForSigning(user), null, request, messages));
            }
            catch (Throwable t) {
                BLLoggerPlay.error("Failed to move bank order", t);
                form.withError("send_order_file", messages.at("sent.send.error.failedtoload", new Object[]{Utils.getLocalizedMessage(t, messages)}));
                return Sent.redirect((Call)routes.Sent.sendFileForm());
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> sendFile(Http.Request request, String csvMd5Hash) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(SignOrdersForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            String bankOrderString = ((SignOrdersForm)form.get()).requestString;
            if (bankOrderString == null || bankOrderString.isEmpty()) {
                return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.send.error.invalidparameter", new Object[]{bankOrderString}));
            }
            if (!BankOrder.checkForDoubleTransmission(bankOrderString)) {
                return Sent.redirect((Call)routes.Sent.index()).flashing("warning", messages.at("sent.send.error.double", new Object[0]));
            }
            try {
                Form passwordResultForm;
                List<BankOrderWithPayments> bankOrders;
                try {
                    bankOrders = BankOrder.getBankOrdersFromRequestString(user, bankOrderString, ((SignOrdersForm)form.get()).additionalInfos, ((SignOrdersForm)form.get()).useVop, messages.lang().toLocale());
                }
                catch (DisplayFileException | KnownFormatException | IOException e) {
                    Result result = Sent.redirect((Call)routes.Sent.index()).flashing("HTMLerror", messages.at("sent.send.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                    BankOrder.finishedBankOrder(bankOrderString);
                    return result;
                }
                if (bankOrders == null || bankOrders.isEmpty()) {
                    Result e = Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.printreport.notfound", new Object[0]));
                    return e;
                }
                if (!form.hasErrors()) {
                    passwordResultForm = ((SignOrdersForm)form.get()).checkPassword(form, user, PasswordForm.PasswordType.EBICS_PASSWORD, messages.lang().locale());
                    if (passwordResultForm.value().isPresent() && ((SignOrdersForm)passwordResultForm.value().get()).isUserLocked()) {
                        BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                        bankOrders.forEach(bo -> OpenPayment.unlockPayments(bo.getOpenPayments()));
                        Result result = Sent.redirect((Call)routes.Sent.index()).flashing("error", "login.locked.user");
                        return result;
                    }
                } else {
                    passwordResultForm = form;
                }
                if (passwordResultForm.hasErrors()) {
                    Result result = Sent.ok((Content)signorder.render(passwordResultForm, bankOrders, Menu.Sent, true, null, null, WebAuthnData.buildForSigning(user), csvMd5Hash, request, messages));
                    return result;
                }
                HashMap<String, String> flashMap = new HashMap<String, String>();
                Map<Integer, Integer> sendOrders = Sent.sendOrders(bankOrders, ((SignOrdersForm)form.get()).password.toCharArray(), new BankOrderResultHandler(messages, flashMap), csvMd5Hash, Setup.getIPAddress(request));
                StringBuilder ids = new StringBuilder();
                for (Integer i : sendOrders.keySet()) {
                    if (!ids.isEmpty()) {
                        ids.append(",");
                    }
                    ids.append(i.toString());
                }
                flashMap.put(SENDITEMS_FLASH_NAME, ids.toString());
                if (sendOrders.size() == 1) {
                    flashMap.put("success", messages.at("sent.send.sent", new Object[0]));
                } else {
                    flashMap.put("success", MessageFormat.format(messages.at("sent.send.sent.multi", new Object[0]), sendOrders.size()));
                }
                Result result = Sent.redirect((Call)routes.Sent.index()).flashing(flashMap);
                return result;
            }
            finally {
                BankOrder.finishedBankOrder(bankOrderString);
            }
        }, this.executionContext.current());
    }

    public WebSocket signPaymentsController() {
        final BankOrderSignInfo signInfo = new BankOrderSignInfo();
        return WebSocket.Text.accept(request -> Flow.fromFunction((org.apache.pekko.japi.function.Function & Serializable)in -> {
            if ("COMMIT".equals(in)) {
                signInfo.committed();
            } else if (!signInfo.parseFromRequest((String)in, Locale.getDefault())) {
                return "ERROR";
            }
            return "";
        }).watchTermination((Function2 & Serializable)(notUsed, stage) -> {
            stage.whenCompleteAsync((result, throwable) -> new Timer().schedule(new TimerTask(this){

                @Override
                public void run() {
                    signInfo.finished();
                }
            }, 5000L));
            return "";
        }));
    }

    public CompletionStage<Result> save(Http.Request request, String idsString) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List<Integer> ids = GeneralUtils.getSelectionIds(idsString);
        return CompletableFuture.supplyAsync(() -> Sent.lambda$save$19(messages, ids, user), this.executionContext.current());
    }

    public CompletionStage<Result> exportOverview(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
            ArrayList<Send> toExport = new ArrayList<Send>();
            if (idsList.isEmpty()) {
                Tenant tenant;
                Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.SEND);
                int sort = sorting.getSortingColumn() == null ? 1 : sorting.getSortingColumn();
                boolean asc = sorting.isSortAscending();
                SortingHandler sortingHandler = new SortingHandler(user, Sorting.Table.SEND);
                try {
                    int tenantId = Integer.parseInt(sortingHandler.getProperty("TENANT", "-1"));
                    tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
                }
                catch (NumberFormatException e) {
                    tenant = null;
                }
                toExport.addAll(this.sendQuery(user, sort, asc, SendFilter.getFilter((User)user), tenant).findList());
            } else if (ids.length() == 1) {
                Send send = (Send)DB.find(Send.class, (Object)idsList.getFirst());
                if (send == null || BankUser.findBankUser((BankSettings)send.getBank(), (User)user) == null) {
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.export.notfound", new Object[0]));
                }
                toExport.add(send);
            } else {
                List banks2 = BankSettings.findBanksForUser((User)user);
                ExpressionList expressionList = DB.find(Send.class).where().in("id", idsList);
                if (banks2 == null || banks2.isEmpty()) {
                    expressionList.isNull("bank");
                } else if (banks2.size() == 1) {
                    expressionList.eq("bank", banks2.getFirst());
                } else {
                    expressionList.in("bank", (Collection)banks2);
                }
                toExport.addAll(expressionList.findList());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                boolean useSentStateLabel = Branding.getBranding().getSignedPaymentStateLabel().equals("GeneralMessages.state");
                new SentTableCsvExport(messages.lang().locale(), useSentStateLabel).write((OutputStream)baos, toExport);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to generated CSV overview of send orders!", e);
                return Sent.redirect((Call)routes.Sent.index()).flashing("HTMLerror", messages.at("sent.export.failed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
            return Sent.ok((byte[])baos.toByteArray()).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(messages.at("sent.title", new Object[0]) + ".csv"));
        }, this.executionContext.current());
    }

    private Query<Send> sendQuery(User user, int sort, boolean asc, SendFilter filter, Tenant tenant) {
        boolean hideSalaries = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getString((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS).equals(PreferenceConstants.SALARY_PERMISSION.NO.toString());
        Query query = Send.findSendByUser((User)user, (boolean)hideSalaries);
        if (tenant != null) {
            query = query.where().eq("bank.tenant", (Object)tenant).query();
        }
        if (filter.isSendActive() && !filter.isEmpty(SendFilter.SendFilterType.SENT_FILES)) {
            query.where(filter.getSendExpression());
        }
        switch (sort) {
            case 0: {
                if (asc) {
                    query = query.order("bank asc,orderType asc,fileType asc,orderNumber asc");
                    break;
                }
                query = query.order("bank desc,orderType desc,fileType desc,orderNumber desc");
                break;
            }
            case 2: {
                if (asc) {
                    query = query.order("state asc");
                    break;
                }
                query = query.order("state desc");
                break;
            }
            case 3: {
                if (asc) {
                    query = query.order("amount asc");
                    break;
                }
                query = query.order("amount desc");
                break;
            }
            case 4: {
                if (asc) {
                    query = query.order("file.size asc");
                    break;
                }
                query = query.order("file.size desc");
                break;
            }
            case 5: {
                if (asc) {
                    query = query.order("origFileName asc");
                    break;
                }
                query = query.order("origFileName desc");
                break;
            }
            case 6: {
                if (asc) {
                    query = query.order("sender asc");
                    break;
                }
                query = query.order("sender desc");
                break;
            }
            default: {
                query = asc ? query.order("sent asc") : query.order("sent desc");
            }
        }
        return query;
    }

    public Result prepareCallbackOrders(Http.Request request, String contextString) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        PaymentContextType context = PaymentContextType.valueOf(contextString);
        boolean isSignedPaymentContext = PaymentContextType.SIGNED_PAYMENT.equals((Object)context);
        play.api.mvc.Call redirectTo = isSignedPaymentContext ? routes.SignedPayments.index(true) : routes.Sent.index();
        String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (idsList.isEmpty()) {
            return Sent.redirect((Call)redirectTo).flashing("error", messages.at("notFound.title", new Object[0]));
        }
        boolean allowAllStates = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.ALLOW_CALLBACK_FOR_ALL_STATES);
        if (isSignedPaymentContext) {
            Send send;
            PrepareCallbackForm callbackForm = new PrepareCallbackForm();
            List selectedSignedPayments = DB.find(SignedPayment.class).where().in("id", idsList).findList();
            List<Integer> selectedSignedPaymentIds = selectedSignedPayments.stream().map(SignedPayment::getId).toList();
            for (Integer signedPaymentId : idsList) {
                if (selectedSignedPaymentIds.contains(signedPaymentId)) continue;
                Utils.addToFlash(flashMap, "warning", messages.at("notFound.title", new Object[0]) + " (SignedPayment " + signedPaymentId + ")");
            }
            ArrayList<SignedPayment> signedPaymentsToRecall = new ArrayList<SignedPayment>();
            String bicWarning = null;
            for (SignedPayment payment : selectedSignedPayments) {
                block30: {
                    send = payment.getSend();
                    OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
                    if (!permissionChecker.hasAccountPermissions(user, send)) {
                        Utils.addToFlash(flashMap, "warning", permissionChecker.getErrorMessage());
                        continue;
                    }
                    if (!SepaCallbackApi.isCallbackAllowed((boolean)allowAllStates, (Send)send)) {
                        Utils.addToFlash(flashMap, "warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.cannotRecall", (Object[])new Object[]{PaymentUtils.getOrderDescription(send.getBank(), send.getOrderType(), send.getFileTypeOrBTF(), send.getOrderNumber(), messages), BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.recallCondition", (Object[])new Object[0])}));
                        continue;
                    }
                    String permissionError = SepaCallbackApi.checkSepaCallbackPermission((User)user, (Send)send, (Locale)messages.lang().locale());
                    if (permissionError != null) {
                        Utils.addToFlash(flashMap, "warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.cannotRecall", (Object[])new Object[]{PaymentUtils.getOrderDescription(send.getBank(), send.getOrderType(), send.getFileTypeOrBTF(), send.getOrderNumber(), messages), permissionError}));
                        continue;
                    }
                    try {
                        String bicMessage;
                        File sepaFile = WorkspaceFileSystem.toFile((WorkspaceFile)send.getFile());
                        boolean isCreditFile = !SepaApi.isDebitOrderType((String)send.getOriginalSendType());
                        EncryptData encryptData = EncryptData.getInstance();
                        BLLogger logger = BLLoggerPlay.getLogger();
                        Map paymentsMap = SepaCallbackApi.getPaymentsMap((File)sepaFile, (boolean)isCreditFile, (EncryptData)encryptData, Collections.singletonList(payment), (BLLogger)logger);
                        SEPALogicalFile logicalFile = (SEPALogicalFile)paymentsMap.keySet().iterator().next();
                        List payments = (List)paymentsMap.get(logicalFile);
                        if (payments.size() <= 1 || payments.size() != logicalFile.getTransactions().size()) {
                            SepaCallbackApi.checkForSalaryPayments((boolean)Util.displaySalaries((User)user), Collections.singletonList(payment), (BLLogger)logger);
                        }
                        if ((bicMessage = SepaCallbackApi.checkForOriginatorBic((SEPALogicalFile)logicalFile, (Locale)messages.lang().locale())) == null) break block30;
                        bicWarning = bicMessage;
                        String presetBic = "";
                        if (payment.getAccount() != null && payment.getAccount().getBic() != null) {
                            presetBic = payment.getAccount().getBic();
                        }
                        callbackForm.bicForSignedPayment.put(payment.getId(), presetBic);
                    }
                    catch (Exception e) {
                        String flashKey = "warning";
                        String errorDescription = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.recallCondition", (Object[])new Object[0]);
                        if (e instanceof SepaCallbackException) {
                            SepaCallbackException sce = (SepaCallbackException)e;
                            errorDescription = sce.getMessage(messages.lang().locale(), false);
                        } else {
                            String localizedMessage = Utils.getLocalizedMessage(e, messages);
                            if (localizedMessage != null && !localizedMessage.isEmpty()) {
                                errorDescription = localizedMessage;
                                flashKey = "HTMLwarning";
                            }
                        }
                        String flashMsg = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.cannotRecall", (Object[])new Object[]{PaymentUtils.getOrderDescription(send.getBank(), send.getOrderType(), send.getFileTypeOrBTF(), send.getOrderNumber(), messages), errorDescription});
                        Utils.addToFlash(flashMap, flashKey, flashMsg);
                        continue;
                    }
                }
                signedPaymentsToRecall.add(payment);
            }
            if (bicWarning != null) {
                Utils.addToFlash(flashMap, "warning", bicWarning);
            }
            if (signedPaymentsToRecall.isEmpty()) {
                Utils.addToFlash(flashMap, "error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.created", (Object[])new Object[]{0}));
                return Sent.redirect((Call)redirectTo).flashing(flashMap);
            }
            for (SignedPayment payment : signedPaymentsToRecall) {
                send = payment.getSend();
                String message = SepaCallbackApi.checkForDoubleCallback((Send)send, Collections.singletonList(payment), (Locale)messages.lang().locale());
                if (message == null) continue;
                Utils.addToFlash(flashMap, "warning", PaymentUtils.getOrderDescription(send.getBank(), send.getOrderType(), send.getFileTypeOrBTF(), send.getOrderNumber(), messages) + ": " + message);
            }
            if (Utils.hasErrorFlash(flashMap)) {
                return Sent.redirect((Call)redirectTo).flashing(flashMap);
            }
            callbackForm.paymentContextTypeName = contextString;
            callbackForm.sentItemIds = null;
            callbackForm.signedPaymentIds = signedPaymentsToRecall.stream().map(SignedPayment::getId).map(Object::toString).collect(Collectors.joining(","));
            Form form = this.formFactory.form(PrepareCallbackForm.class).fill((Object)callbackForm);
            return Sent.ok((Content)preparecallback.render((Form<PrepareCallbackForm>)form, null, signedPaymentsToRecall, context, flashMap, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        PrepareCallbackForm callbackForm = new PrepareCallbackForm();
        List selectedSentOrders = DB.find(Send.class).where().in("id", idsList).findList();
        List<Integer> selectedSentIds = selectedSentOrders.stream().map(Send::getId).toList();
        for (Integer sentId : idsList) {
            if (selectedSentIds.contains(sentId)) continue;
            Utils.addToFlash(flashMap, "warning", messages.at("notFound.title", new Object[0]) + " (Send " + sentId + ")");
        }
        ArrayList<Send> sentOrdersToRecall = new ArrayList<Send>();
        String bicWarning = null;
        for (Send send : selectedSentOrders) {
            block31: {
                if (!SepaCallbackApi.isCallbackAllowed((boolean)allowAllStates, (Send)send)) {
                    Utils.addToFlash(flashMap, "warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.cannotRecall", (Object[])new Object[]{PaymentUtils.getOrderDescription(send.getBank(), send.getOrderType(), send.getFileTypeOrBTF(), send.getOrderNumber(), messages), BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.recallCondition", (Object[])new Object[0])}));
                    continue;
                }
                try {
                    File sepaFile = WorkspaceFileSystem.toFile((WorkspaceFile)send.getFile());
                    boolean isCreditFile = !SepaApi.isDebitOrderType((String)send.getOriginalSendType());
                    EncryptData encryptData = EncryptData.getInstance();
                    BLLogger logger = BLLoggerPlay.getLogger();
                    SEPALogicalFile logicalFile = SepaCallbackApi.getLogicalFile((File)sepaFile, (boolean)isCreditFile, (EncryptData)encryptData, (BLLogger)logger);
                    String bicMessage = SepaCallbackApi.checkForOriginatorBic((SEPALogicalFile)logicalFile, (Locale)messages.lang().locale());
                    if (bicMessage == null) break block31;
                    bicWarning = bicMessage;
                    callbackForm.bicForSentItem.put(send.getId(), "");
                }
                catch (Exception e) {
                    String flashKey = "warning";
                    String errorDescription = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.recallCondition", (Object[])new Object[0]);
                    if (e instanceof SepaCallbackException) {
                        SepaCallbackException sce = (SepaCallbackException)e;
                        errorDescription = sce.getMessage(messages.lang().locale(), false);
                    } else {
                        String localizedMessage = Utils.getLocalizedMessage(e, messages);
                        if (localizedMessage != null && !localizedMessage.isEmpty()) {
                            errorDescription = localizedMessage;
                            flashKey = "HTMLwarning";
                        }
                    }
                    String flashMsg = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.cannotRecall", (Object[])new Object[]{PaymentUtils.getOrderDescription(send.getBank(), send.getOrderType(), send.getFileTypeOrBTF(), send.getOrderNumber(), messages), errorDescription});
                    Utils.addToFlash(flashMap, flashKey, flashMsg);
                    continue;
                }
            }
            sentOrdersToRecall.add(send);
        }
        if (bicWarning != null) {
            Utils.addToFlash(flashMap, "warning", bicWarning);
        }
        if (sentOrdersToRecall.isEmpty()) {
            Utils.addToFlash(flashMap, "error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.created", (Object[])new Object[]{0}));
            return Sent.redirect((Call)redirectTo).flashing(flashMap);
        }
        for (Send send : sentOrdersToRecall) {
            String message = SepaCallbackApi.checkForDoubleCallback((Send)send, null, (Locale)messages.lang().locale());
            if (message == null) continue;
            Utils.addToFlash(flashMap, "warning", PaymentUtils.getOrderDescription(send.getBank(), send.getOrderType(), send.getFileTypeOrBTF(), send.getOrderNumber(), messages) + ": " + message);
        }
        if (Utils.hasErrorFlash(flashMap)) {
            return Sent.redirect((Call)redirectTo).flashing(flashMap);
        }
        callbackForm.paymentContextTypeName = contextString;
        callbackForm.signedPaymentIds = null;
        callbackForm.sentItemIds = sentOrdersToRecall.stream().map(Send::getId).map(Object::toString).collect(Collectors.joining(","));
        Form form = this.formFactory.form(PrepareCallbackForm.class).fill((Object)callbackForm);
        return Sent.ok((Content)preparecallback.render((Form<PrepareCallbackForm>)form, sentOrdersToRecall, null, context, flashMap, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result callbackOrders(Http.Request request) {
        play.api.mvc.Call redirectTo;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form form = this.formFactory.form(PrepareCallbackForm.class).bindFromRequest(request, new String[0]);
        PaymentContextType context = PaymentContextType.valueOf(((PrepareCallbackForm)form.get()).paymentContextTypeName);
        String callbackReason = ((PrepareCallbackForm)form.get()).callbackReason;
        Map<Integer, String> bicsForSignedPayments = ((PrepareCallbackForm)form.get()).bicForSignedPayment;
        Map<Integer, String> bicsForSentItems = ((PrepareCallbackForm)form.get()).bicForSentItem;
        SEPACallbackGenerator.CallbackReasonCode callbackReasonCode = SEPACallbackGenerator.CallbackReasonCode.valueOf((String)callbackReason);
        String callbackAdditionalInfos = ((PrepareCallbackForm)form.get()).furtherInformation;
        boolean isSignedPaymentContext = PaymentContextType.SIGNED_PAYMENT.equals((Object)context);
        play.api.mvc.Call call = redirectTo = isSignedPaymentContext ? routes.SignedPayments.index(false) : routes.Sent.index();
        if (isSignedPaymentContext) {
            List<SignedPayment> signedPayments;
            List<Integer> signedPaymentsIdsList = GeneralUtils.getSelectionIds(((PrepareCallbackForm)form.get()).signedPaymentIds);
            List signedPaymentsToRecall = DB.find(SignedPayment.class).where().in("id", signedPaymentsIdsList).findList();
            HashMap<String, String> flashMap = new HashMap<String, String>();
            HashMap<Send, List<SignedPayment>> signedPaymentsBySendItem = new HashMap<Send, List<SignedPayment>>();
            for (Object signedPayment : signedPaymentsToRecall) {
                Send send = signedPayment.getSend();
                if (signedPaymentsBySendItem.containsKey(send)) {
                    ((List)signedPaymentsBySendItem.get(send)).add(signedPayment);
                    continue;
                }
                signedPayments = new ArrayList<Object>();
                signedPayments.add((SignedPayment)signedPayment);
                signedPaymentsBySendItem.put(send, signedPayments);
            }
            ArrayList<BankOrder> callbackOrdersToSign = new ArrayList<BankOrder>();
            for (Object sendOrder : signedPaymentsBySendItem.keySet()) {
                signedPayments = (List)signedPaymentsBySendItem.get(sendOrder);
                String manualBic = bicsForSignedPayments.getOrDefault(((SignedPayment)signedPayments.getFirst()).getId(), null);
                try {
                    callbackOrdersToSign.addAll(this.createSepaCallbackOrders(user, (Send)sendOrder, signedPayments, callbackReasonCode, callbackAdditionalInfos, manualBic, messages.lang().locale()));
                }
                catch (Exception e) {
                    Object errorMsg = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.error", (Object[])new Object[]{PaymentUtils.getOrderDescription(sendOrder.getBank(), sendOrder.getOrderType(), sendOrder.getFileTypeOrBTF(), sendOrder.getOrderNumber(), messages)});
                    String localizedMessage = Utils.getLocalizedMessage(e, messages);
                    if (localizedMessage != null && !localizedMessage.isEmpty()) {
                        errorMsg = (String)errorMsg + " " + localizedMessage;
                    }
                    Utils.addToFlash(flashMap, "HTMLerror", (String)errorMsg);
                }
            }
            if (callbackOrdersToSign.isEmpty()) {
                return Sent.redirect((Call)redirectTo).flashing(flashMap);
            }
            List<BankOrderWithPayments> ordersList = new ArrayList<BankOrderWithPayments>();
            for (BankOrder order : callbackOrdersToSign) {
                ordersList.add(new BankOrderWithPayments(order, new ArrayList<OpenPayment>()));
            }
            ordersList = BankOrderWithPayments.sortByPmtType(ordersList);
            Form signOrdersForm = this.formFactory.form(SignOrdersForm.class).fill((Object)SignOrdersForm.fillForm(user, ordersList));
            return Sent.ok((Content)signorder.render((Form<SignOrdersForm>)signOrdersForm, ordersList, Menu.Sent, false, flashMap, null, WebAuthnData.buildForSigning(user), null, request, messages));
        }
        List<Integer> sentItemIdsList = GeneralUtils.getSelectionIds(((PrepareCallbackForm)form.get()).sentItemIds);
        List ordersToRecall = DB.find(Send.class).where().in("id", sentItemIdsList).findList();
        HashMap<String, String> flashMap = new HashMap<String, String>();
        ArrayList<BankOrder> callbackOrdersToSign = new ArrayList<BankOrder>();
        for (Object send : ordersToRecall) {
            String manualBic = bicsForSentItems.getOrDefault(send.getId(), null);
            try {
                callbackOrdersToSign.addAll(this.createSepaCallbackOrders(user, (Send)send, null, callbackReasonCode, callbackAdditionalInfos, manualBic, messages.lang().locale()));
            }
            catch (Exception e) {
                Object errorMsg = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.callbackOrders.error", (Object[])new Object[]{PaymentUtils.getOrderDescription(send.getBank(), send.getOrderType(), send.getFileTypeOrBTF(), send.getOrderNumber(), messages)});
                String localizedMessage = Utils.getLocalizedMessage(e, messages);
                if (localizedMessage != null && !localizedMessage.isEmpty()) {
                    errorMsg = (String)errorMsg + " " + localizedMessage;
                }
                Utils.addToFlash(flashMap, "HTMLerror", (String)errorMsg);
            }
        }
        if (callbackOrdersToSign.isEmpty()) {
            return Sent.redirect((Call)redirectTo).flashing(flashMap);
        }
        List<BankOrderWithPayments> ordersList = new ArrayList<BankOrderWithPayments>();
        for (BankOrder order : callbackOrdersToSign) {
            ordersList.add(new BankOrderWithPayments(order, new ArrayList<OpenPayment>()));
        }
        ordersList = BankOrderWithPayments.sortByPmtType(ordersList);
        Form signOrdersForm = this.formFactory.form(SignOrdersForm.class).fill((Object)SignOrdersForm.fillForm(user, ordersList));
        return Sent.ok((Content)signorder.render((Form<SignOrdersForm>)signOrdersForm, ordersList, Menu.Sent, false, flashMap, null, WebAuthnData.buildForSigning(user), null, request, messages));
    }

    private List<BankOrder> createSepaCallbackOrders(User user, Send send, List<SignedPayment> signedPayments, SEPACallbackGenerator.CallbackReasonCode callbackReason, String callbackAdditionalInfo, String manualBic, Locale locale) throws InvalidPasswordException, IOException, SepaCallbackException, DisplayFileException, KnownFormatException, SAXException {
        String bicMessage;
        SEPALogicalFile logicalFile;
        boolean isCreditFile;
        EncryptData encryptData = EncryptData.getInstance();
        BLLogger logger = BLLoggerPlay.getLogger();
        List payments = null;
        File sepaFile = WorkspaceFileSystem.toFile((WorkspaceFile)send.getFile());
        boolean bl = isCreditFile = !SepaApi.isDebitOrderType((String)send.getOriginalSendType());
        if (signedPayments == null || signedPayments.isEmpty()) {
            logicalFile = SepaCallbackApi.getLogicalFile((File)sepaFile, (boolean)isCreditFile, (EncryptData)encryptData, (BLLogger)logger);
        } else {
            Map paymentsMap = SepaCallbackApi.getPaymentsMap((File)sepaFile, (boolean)isCreditFile, (EncryptData)encryptData, signedPayments, (BLLogger)logger);
            payments = (List)paymentsMap.get(logicalFile = (SEPALogicalFile)paymentsMap.keySet().iterator().next());
            if (payments.size() > 1 && payments.size() == logicalFile.getTransactions().size()) {
                payments = null;
            } else {
                SepaCallbackApi.checkForSalaryPayments((boolean)Util.displaySalaries((User)user), signedPayments, (BLLogger)logger);
            }
        }
        if (manualBic == null && (bicMessage = SepaCallbackApi.checkForOriginatorBic((SEPALogicalFile)logicalFile, (Locale)locale)) != null) {
            throw new SepaCallbackException((Throwable)new Exception(bicMessage));
        }
        BankSettings bank = send.getBank();
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        BankOrderCallback bankOrderCallback = (bankSettings, pmtType, orderType, orderFile, orderDataSize) -> {
            try {
                return new BankOrder(bankUser, pmtType, orderFile, orderDataSize, send, signedPayments, SystemUtils.calculateMD5Hash((File)orderFile), locale);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        };
        return SepaCallbackApi.createBankOrders((BankUser)bankUser, (BankOrderCallback)bankOrderCallback, (SEPACallbackGenerator.CallbackReasonCode)callbackReason, (String)callbackAdditionalInfo, (SEPALogicalFile)logicalFile, (List)payments, (String)manualBic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Result lambda$save$19(Messages messages, List ids, User user) {
        if (Branding.getBranding().hideSaveInSentFiles()) {
            return Sent.redirect((Call)routes.Sent.index()).flashing("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
        }
        if (ids.isEmpty() || ids.stream().allMatch((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isNull(java.lang.Object ), (Ljava/lang/Integer;)Z)())) {
            return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.printreport.notfound", new Object[0]));
        }
        list = new ArrayList<Send>();
        singleFile = ids.size() == 1;
        var5_5 = ids.iterator();
        while (var5_5.hasNext()) {
            block17: {
                id = (Integer)var5_5.next();
                send = (Send)DB.find(Send.class, (Object)id);
                if (send == null) {
                    if (!singleFile) continue;
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.printreport.notfound", new Object[0]));
                }
                permissionChecker = new OrderPermissionChecker(messages.lang().locale());
                if (!permissionChecker.hasAccountPermissions(user, send)) {
                    if (!singleFile) continue;
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", permissionChecker.getErrorMessage());
                }
                handler = new SendOrderHandler(send);
                if (handler.getDataFile() == null || !handler.getDataFile().isFile() || handler.getDataFile().length() == 0L) {
                    if (!singleFile) continue;
                    return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.save.error.filemissing", new Object[0]));
                }
                v0 = isCreditPmtType = send.getPmtType() != null && SepaApi.isCreditPmtType((PaymentTransferType.PmtType)send.getPmtType()) != false;
                if (Util.displaySalaries((User)user) || !isCreditPmtType) break block17;
                inputStream = null;
                try {
                    inputStream = EncryptData.getInstance().openInputStream(new SendOrderHandler(send).getDataFile());
                    handlers = PaymentHandler.getHandlers(inputStream, send.getPmtType(), send.getBank().getCountryCode());
                    orderContainsSalaryPayment = false;
lbl29:
                    // 3 sources

                    for (PaymentHandler<?> payment : handlers) {
                        if (!payment.isSalaryPayment()) continue;
                        if (!singleFile) ** GOTO lbl-1000
                        var16_18 = Sent.redirect((Call)routes.Sent.index()).flashing("error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.noPermissionToStoreSalaryPayments", (Object[])new Object[0]));
                        ** GOTO lbl42
                    }
                    ** GOTO lbl46
                }
                catch (IOException | GeneralSecurityException | PaymentException e) {
                    block16: {
                        try {
                            BLLoggerPlay.error("Failed to check, if order data contains salary payments!", e);
                        }
                        catch (Throwable var17_19) {
                            SystemUtils.close(inputStream);
                            throw var17_19;
                        }
lbl42:
                        // 1 sources

                        SystemUtils.close((AutoCloseable)inputStream);
                        return var16_18;
lbl-1000:
                        // 1 sources

                        {
                            orderContainsSalaryPayment = true;
                            ** GOTO lbl29
lbl46:
                            // 1 sources

                            if (!orderContainsSalaryPayment) break block16;
                        }
                        SystemUtils.close((AutoCloseable)inputStream);
                        continue;
                    }
                    SystemUtils.close((AutoCloseable)inputStream);
                    SystemUtils.close((AutoCloseable)inputStream);
                }
            }
            list.add(send);
        }
        try {
            if (list.isEmpty()) {
                return Sent.redirect((Call)routes.Sent.index()).flashing("error", messages.at("sent.printreport.notfound", new Object[0]));
            }
            if (list.size() == 1) {
                handler = new SendOrderHandler((Send)list.getFirst());
                return GeneralUtils.supplyWorkspaceFile(handler.getDataFile(), false, false).as("binary/octet-stream").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(handler.getDataFile().getName()));
            }
            filesToSave = list.stream().map((Function<Send, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$save$18(de.businesslogics.banking.database.vo.Send ), (Lde/businesslogics/banking/database/vo/Send;)Ljava/io/File;)()).collect(Collectors.toList());
            return GeneralUtils.supplyZipFile(filesToSave, false, false).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("sentFiles.zip"));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to create download to send order!", e);
            return Sent.redirect((Call)routes.Sent.index()).flashing("HTMLerror", Utils.getLocalizedMessage(e, messages));
        }
    }

    private static /* synthetic */ File lambda$save$18(Send s) {
        return WorkspaceFileSystem.getFile((WorkspaceFile)s.getFile());
    }

    private static final class RejectingBankOrderCheckHandler<T>
    implements BankOrderCheckHandler {
        private final Messages messages;
        private final Map<String, String> flashMap;
        private Form<T> form;
        private boolean hasError;

        public RejectingBankOrderCheckHandler(Form<T> form, Map<String, String> flashMap, Messages messages) {
            this.form = form;
            this.messages = messages;
            this.flashMap = flashMap;
        }

        @Override
        public void unknownOriginatorAccount(String account) {
            this.form = this.form.withGlobalError(this.messages.at("sent.send.error.unknownoriginatoraccount", new Object[]{account}));
            this.hasError = true;
        }

        @Override
        public void invalidBankConnection(String account) {
            this.form = this.form.withGlobalError(this.messages.at("sent.send.error.invalidrecipientaccount", new Object[]{account}));
            this.hasError = true;
        }

        @Override
        public void exceededAmount(String message) {
            this.form = this.form.withGlobalError(message);
            this.hasError = true;
        }

        @Override
        public void handleException(Exception e) {
            if (e instanceof KnownFormatException) {
                Utils.addToFlash(this.flashMap, "warning", e.getMessage());
            } else {
                this.form = this.form.withGlobalError(Utils.getLocalizedMessage(e, this.messages));
                this.hasError = true;
            }
        }

        @Override
        public boolean hasError() {
            return this.hasError;
        }

        public Form<T> getForm() {
            return this.form;
        }
    }
}

