/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.FileAppender;
import controllers.Authenticator;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.io.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.net.ssl.HttpsURLConnection;
import models.SendLogsForm;
import org.slf4j.LoggerFactory;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.html.settings.sendlogs;

@Security.Authenticated(value=Authenticator.class)
public final class SendLogs
extends Controller {
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    @Inject
    public SendLogs(MessagesApi messagesApi, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
    }

    public Result index(Http.Request request) {
        return SendLogs.ok((Content)sendlogs.render((Form<SendLogsForm>)this.formFactory.form(SendLogsForm.class), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> sendLogs(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form form = this.formFactory.form(SendLogsForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            String message = ((SendLogsForm)form.get()).buildMessage(user);
            try {
                FileInputStream in;
                ZipEntry e;
                Logger root;
                FileAppender appender;
                File f;
                URI url = new URI(System.getProperty("de.businesslogics.banking.licenseServer", "https://www.blbanking.de/license/upload/") + user.getWebLicense().getId());
                HttpsURLConnection c = (HttpsURLConnection)url.toURL().openConnection();
                EbicsHttpEngineImpl.setSSLSocketFactory((HttpsURLConnection)c);
                c.setDoOutput(true);
                OutputStream out = c.getOutputStream();
                ZipOutputStream zip = new ZipOutputStream(out);
                if (!message.isEmpty()) {
                    zip.setComment(message);
                }
                if (!message.isEmpty()) {
                    zip.putNextEntry(new ZipEntry("README.TXT"));
                    zip.write(message.getBytes(StandardCharsets.UTF_8));
                    zip.closeEntry();
                }
                if ((f = new File((appender = (FileAppender)(root = (Logger)LoggerFactory.getLogger((String)"ROOT")).getAppender("FILE")).getFile())).isFile()) {
                    e = new ZipEntry(".log");
                    zip.putNextEntry(e);
                    e.setTime(f.lastModified());
                    in = new FileInputStream(f);
                    Streams.copy((InputStream)in, (OutputStream)zip, (boolean)false);
                    in.close();
                    zip.closeEntry();
                }
                File[] logs2 = null;
                File tracesDir = new File(new File(Util.WORKSPACEDIR, "ebicstraces"), String.valueOf(user.getId()));
                if (tracesDir.isDirectory()) {
                    logs2 = tracesDir.listFiles();
                }
                if (logs2 != null) {
                    for (File file2 : logs2) {
                        if (file2.isDirectory()) continue;
                        in = new FileInputStream(file2);
                        e = new ZipEntry("ebicstraces/" + file2.getName());
                        e.setTime(file2.lastModified());
                        zip.putNextEntry(e);
                        Streams.copy((InputStream)in, (OutputStream)zip, (boolean)false);
                        in.close();
                        zip.closeEntry();
                    }
                }
                zip.close();
                InputStream response = c.getInputStream();
                String msg = new String(Streams.readAll((InputStream)response), StandardCharsets.US_ASCII);
                if (!msg.equalsIgnoreCase("<html><body>Upload done.</body></html>\r\n")) {
                    BLLoggerPlay.error("An error occurred while sending Logs: " + msg);
                    return SendLogs.redirect((Call)routes.Application.index()).flashing("error", messages.at("sendlogs.error", new Object[]{msg}));
                }
                response.close();
                return SendLogs.redirect((Call)routes.Application.index()).flashing("success", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.sendTracesDone", (Object[])new Object[0]));
            }
            catch (IOException | URISyntaxException e) {
                BLLoggerPlay.error("An error occurred while sending Logs", e);
                return SendLogs.redirect((Call)routes.Application.index()).flashing("error", messages.at("sendlogs.error", new Object[]{e.toString()}));
            }
        }, this.executionContext.current());
    }
}

