/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.CsvImport;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CsvColumnSeparator;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.VopUtil;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.dta.api.DtazvRecipientData;
import de.businesslogics.banking.mt101.api.MT101RecipientData;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.banking.sepa.api.ChequeRecipientData;
import de.businesslogics.banking.sepa.api.ConvertToOtherRecipientType;
import de.businesslogics.banking.sepa.api.PostbarRecipientData;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.banking.sepa.api.SepaMandateData;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.format.sepa.StatusCode;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.Update;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.ChequeRecipientForm;
import models.CsvImportInfo;
import models.DtazvRecipientForm;
import models.MT101RecipientForm;
import models.PostbarRecipientForm;
import models.RecipientForm;
import models.RecipientImportForm;
import models.SepaForeignRecipientForm;
import models.SepaMandateForm;
import models.SepaRecipientForm;
import models.SimpleTextForm;
import models.TenantSelectForm;
import models.payments.LoadVopRecipientNamesForm;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.japi.function.Function2;
import org.apache.pekko.stream.javadsl.Flow;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.mvc.WebSocket;
import play.twirl.api.Content;
import views.Utils;
import views.html.payments.editrecipient;
import views.html.payments.loadVopRecipientNames;
import views.html.payments.mandates;
import views.html.payments.newrecipient;
import views.html.payments.recipients;
import views.html.payments.recipientsimportcolumns;
import views.html.payments.recipientsimportfile;

@Security.Authenticated(value=AuthenticatorFor.Payment.class)
public final class Recipients
extends Controller {
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    public static String editPageHelpUrl(PaymentType paymentType) {
        if (paymentType == PaymentType.SEPA) {
            return "payments/sepa-recipient";
        }
        if (paymentType == PaymentType.MANDATE) {
            return "payments/sepa-mandate";
        }
        if (paymentType == PaymentType.DTAZV) {
            return "payments/dtazv-recipient";
        }
        if (paymentType == PaymentType.MT101) {
            return "payments/mt101-recipient";
        }
        if (paymentType == PaymentType.AUSTRIAN_POSTBAR) {
            return "payments/postbar-recipient";
        }
        if (paymentType == PaymentType.AUSTRIAN_TAX_OFFICE) {
            return "payments/tax-recipient";
        }
        if (paymentType == PaymentType.CHEQUE) {
            return "payments/cheque-recipient";
        }
        if (paymentType == PaymentType.SEPA_FOREIGN) {
            return "payments/xml-recipient";
        }
        return "payments/record-recipient";
    }

    public static String loadMandatesJsParameters(boolean allowRecipientRecording, boolean filterActive, int numberOfTenants, Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("numberOfTenants", numberOfTenants);
        resultJson.put("allowRecipientRecording", allowRecipientRecording);
        resultJson.put("filterActive", filterActive);
        ObjectNode deleteMessageNode = resultJson.putObject("deleteMessage");
        deleteMessageNode.put("none", messages.at("mandates.delete", new Object[]{0}));
        deleteMessageNode.put("single", messages.at("mandates.delete", new Object[]{1}));
        deleteMessageNode.put("multiple", messages.at("mandates.delete", new Object[]{999}));
        ObjectNode deleteTitleNode = resultJson.putObject("deleteTitle");
        deleteTitleNode.put("none", messages.at("mandates.delete.title", new Object[]{0}));
        deleteTitleNode.put("single", messages.at("mandates.delete.title", new Object[]{1}));
        deleteTitleNode.put("multiple", messages.at("mandates.delete.title", new Object[]{999}));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadRecipientsJsParameters(boolean allowRecipientRecording, boolean filterActive, int numberOfTenants, Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("numberOfTenants", numberOfTenants);
        resultJson.put("allowRecipientRecording", allowRecipientRecording);
        resultJson.put("filterActive", filterActive);
        ObjectNode deleteMessageNode = resultJson.putObject("deleteMessage");
        deleteMessageNode.put("none", messages.at("recipients.reallydelete.message", new Object[]{0}));
        deleteMessageNode.put("single", messages.at("recipients.reallydelete.message", new Object[]{1}));
        deleteMessageNode.put("multiple", messages.at("recipients.reallydelete.message", new Object[]{999}));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String getCreatorOfFourEyesRecipient(Http.Request request, int databaseId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentRecipient pr = PaymentRecipient.findById((int)databaseId, (User)user);
        User creator = pr.getCreatedUser();
        if (creator != null && !creator.equals(user)) {
            return creator.getName();
        }
        return null;
    }

    public static PaymentRecipient getHistoricFourEyesRecipient(Http.Request request, int databaseId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return null;
        }
        PaymentRecipient pr = PaymentRecipient.findById((int)databaseId, (User)user);
        return pr.findHistoricRecipient();
    }

    public static DtazvRecipientData getHistoricFourEyesDtazvRecipient(PaymentRecipient historicPayment) {
        if (historicPayment == null) {
            return null;
        }
        DtazvRecipientData recipient = new DtazvRecipientData();
        try {
            recipient.setPaymentRecipient(historicPayment);
        }
        catch (IOException io) {
            return null;
        }
        return recipient;
    }

    public static MT101RecipientData getHistoricFourEyesMt101Recipient(PaymentRecipient historicPayment) {
        if (historicPayment == null) {
            return null;
        }
        MT101RecipientData recipient = new MT101RecipientData();
        try {
            recipient.setPaymentRecipient(historicPayment);
        }
        catch (IOException io) {
            return null;
        }
        return recipient;
    }

    public static SepaRecipientData getHistoricFourEyesSepaRecipient(PaymentRecipient historicPayment) {
        if (historicPayment == null) {
            return null;
        }
        SepaRecipientData recipient = new SepaRecipientData();
        try {
            recipient.setPaymentRecipient(historicPayment);
        }
        catch (IOException io) {
            return null;
        }
        return recipient;
    }

    public static SepaMandateData getHistoricFourEyesSepaMandateRecipient(PaymentRecipient historicPayment) {
        if (historicPayment == null) {
            return null;
        }
        SepaMandateData mandate = new SepaMandateData();
        try {
            mandate.setPaymentRecipient(historicPayment);
        }
        catch (IOException io) {
            return null;
        }
        return mandate;
    }

    public static PostbarRecipientData getHistoricFourEyesPostbarRecipient(PaymentRecipient historicPayment) {
        if (historicPayment == null) {
            return null;
        }
        PostbarRecipientData recipient = new PostbarRecipientData();
        try {
            recipient.setPaymentRecipient(historicPayment);
        }
        catch (IOException io) {
            return null;
        }
        return recipient;
    }

    public static boolean isOwnFourEyesRecipient(Http.Request request, int databaseId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return false;
        }
        PaymentRecipient pr = PaymentRecipient.findById((int)databaseId, (User)user);
        boolean otherCreator = false;
        if (pr != null && pr.isInProcess()) {
            otherCreator = pr.isInProcessByOtherUser(user);
        }
        return !otherCreator;
    }

    public static boolean isFourEyesRecipientConfirmDialog(Http.Request request, int databaseId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return false;
        }
        if (!new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION)) {
            return false;
        }
        PaymentRecipient pr = PaymentRecipient.findById((int)databaseId, (User)user);
        boolean isConfirmDialog = false;
        if (pr != null && pr.isInProcess()) {
            isConfirmDialog = pr.isInProcessByOtherUser(user);
        }
        return isConfirmDialog;
    }

    public static boolean isNewRecipient(Http.Request request, int databaseId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return false;
        }
        PaymentRecipient pr = PaymentRecipient.findById((int)databaseId, (User)user);
        return pr.findHistoricRecipient() == null;
    }

    public static boolean isInProcessFourEyes(Http.Request request, int databaseId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return false;
        }
        PaymentRecipient pr = PaymentRecipient.findById((int)databaseId, (User)user);
        if (pr != null && pr.isInProcess()) {
            return pr.isInProcess();
        }
        return false;
    }

    public static void updateVopStatusAfterRecipientChanged(SepaRecipientData recipientData, boolean recipientIbanChanged, boolean recipientNameChanged) {
        if (recipientIbanChanged) {
            recipientData.setVopResult(null);
            recipientData.setVopReason(null);
            recipientData.setVopAdditionalInfo(null);
            recipientData.setVopName(null);
        } else if (recipientNameChanged) {
            String vopResult = recipientData.getVopResult();
            if (VopUtil.isCloseMatch((String)vopResult) && recipientData.getName().equals(recipientData.getVopName())) {
                recipientData.setVopResult(StatusCode.VopResultCodes.RCVC.name());
            } else if (!VopUtil.isNotApplicable((String)vopResult)) {
                recipientData.setVopResult(null);
                recipientData.setVopReason(null);
                recipientData.setVopAdditionalInfo(null);
            }
        }
    }

    @Inject
    public Recipients(MessagesApi messagesApi, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
    }

    public Result index(Http.Request request, boolean onlyMandates) {
        List list;
        String sortingDirection;
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = onlyMandates ? new SortingHandler(user, Sorting.Table.PMT_MANDATES) : new SortingHandler(user, Sorting.Table.PMT_RECIPIENT);
        SimpleTextFilter filter = onlyMandates ? SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.MANDATES) : SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.RECIPIENTS);
        Query query = PaymentRecipient.findRecipients((User)user);
        if (onlyMandates) {
            query.where().eq("paymentType", (Object)PaymentType.MANDATE);
        }
        if (filter.isFilterActive()) {
            query.where(PaymentRecipient.getFilterExpression((String)filter.getFilterText()));
        }
        try {
            tenant = Tenant.findById((int)Integer.parseInt(sorting.getProperty("TENANT", "-1")), (User)user, (boolean)false);
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Invalid value for tenant in recipients table!", e);
            tenant = null;
        }
        if (tenant != null) {
            query.where().eq("tenant", (Object)tenant);
        }
        String string = sortingDirection = sorting.isSortingAscending() ? " ASC" : " DESC";
        String orderBy = sorting.getSortingColumn() == 0 ? "displayName" + sortingDirection : (sorting.getSortingColumn() == 1 ? "name" + sortingDirection : (sorting.getSortingColumn() == 2 ? (onlyMandates ? "sepaMandateId" + sortingDirection : "paymentType" + sortingDirection) : (sorting.getSortingColumn() == 3 ? "accountNumber" + sortingDirection : (sorting.getSortingColumn() == 4 ? "bankCode" + sortingDirection : (sorting.getSortingColumn() == 5 ? "bankName" + sortingDirection : (sorting.getSortingColumn() == 6 && tenant == null ? "tenant.name" + sortingDirection : (sorting.getSortingColumn() == 7 ? "version" + sortingDirection : (sorting.getSortingColumn() == 8 ? "vopResult" + sortingDirection + ", vopDate" + sortingDirection : "displayName" + sortingDirection))))))));
        query.orderBy(orderBy);
        sorting.computeForQuery(query);
        SimpleTextForm filterValue = new SimpleTextForm();
        filterValue.text = filter.getFilterText();
        Form filterForm = this.formFactory.form(SimpleTextForm.class).fill((Object)filterValue);
        Form form = this.formFactory.form(TenantSelectForm.class);
        String filterText = filter.isFilterActive() ? filter.getFilterText() : null;
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            Sorting.Table table = onlyMandates ? Sorting.Table.PMT_MANDATES : Sorting.Table.PMT_RECIPIENT;
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, table, (Call)routes.Recipients.index(onlyMandates));
        }
        if (onlyMandates) {
            return Recipients.ok((Content)mandates.render(list, (Form<TenantSelectForm>)form, sorting, tenant, (Form<SimpleTextForm>)filterForm, filterText, request, messages));
        }
        return Recipients.ok((Content)recipients.render(list, (Form<TenantSelectForm>)form, sorting, tenant, (Form<SimpleTextForm>)filterForm, filterText, request, messages));
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending, boolean onlyMandates) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (onlyMandates) {
            new SortingHandler(user, Sorting.Table.PMT_MANDATES).updateSort(sort, ascending);
        } else {
            new SortingHandler(user, Sorting.Table.PMT_RECIPIENT).updateSort(sort, ascending);
        }
        return Recipients.redirect((Call)routes.Recipients.index(onlyMandates));
    }

    public Result indexWithPage(Http.Request request, int pageNumber, int pageSize, boolean onlyMandates) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (onlyMandates) {
            new SortingHandler(user, Sorting.Table.PMT_MANDATES).updatePage(pageNumber, pageSize);
        } else {
            new SortingHandler(user, Sorting.Table.PMT_RECIPIENT).updatePage(pageNumber, pageSize);
        }
        return Recipients.redirect((Call)routes.Recipients.index(onlyMandates));
    }

    public Result indexWithTenant(Http.Request request, Integer tenant, boolean onlyMandates) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, onlyMandates ? Sorting.Table.PMT_MANDATES : Sorting.Table.PMT_RECIPIENT).setProperty("TENANT", tenant != null ? String.valueOf(tenant) : null);
        return Recipients.redirect((Call)routes.Recipients.index(onlyMandates));
    }

    public Result indexWithFilter(Http.Request request, boolean active, boolean onlyMandates) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SimpleTextFilter filter = onlyMandates ? SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.MANDATES) : SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.RECIPIENTS);
        if (active) {
            Form filterForm = this.formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
            String filterText = ((SimpleTextForm)filterForm.get()).text;
            if (filterText != null && !filterText.isEmpty()) {
                filter.setFilterText(filterText);
                filter.setFilterActive(true);
            } else {
                filter.setFilterText(null);
                filter.setFilterActive(false);
            }
        } else {
            filter.setFilterActive(false);
        }
        filter.save();
        return Recipients.redirect((Call)routes.Recipients.index(onlyMandates));
    }

    public Result create(Http.Request request, String type, boolean mandates2) {
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)user)) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        PaymentType paymentType = PaymentType.valueOf((String)type);
        switch (paymentType) {
            case DTAZV: {
                form = this.formFactory.form(DtazvRecipientForm.class).fill((Object)new DtazvRecipientForm());
                break;
            }
            case SEPA: 
            case AUSTRIAN_TAX_OFFICE: {
                form = this.formFactory.form(SepaRecipientForm.class).fill((Object)new SepaRecipientForm());
                break;
            }
            case MANDATE: {
                form = this.formFactory.form(SepaMandateForm.class).fill((Object)new SepaMandateForm());
                break;
            }
            case MT101: {
                form = this.formFactory.form(MT101RecipientForm.class).fill((Object)new MT101RecipientForm());
                break;
            }
            case AUSTRIAN_POSTBAR: {
                form = this.formFactory.form(PostbarRecipientForm.class).fill((Object)new PostbarRecipientForm());
                break;
            }
            case SEPA_FOREIGN: {
                form = this.formFactory.form(SepaForeignRecipientForm.class).fill((Object)new SepaForeignRecipientForm());
                break;
            }
            case CHEQUE: {
                form = this.formFactory.form(ChequeRecipientForm.class).fill((Object)new ChequeRecipientForm());
                break;
            }
            default: {
                return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.unknownpaymenttype", new Object[]{paymentType}));
            }
        }
        form.value().ifPresent(recipientForm -> recipientForm.loadDefaultFormSettings(user));
        return Recipients.ok((Content)newrecipient.render((Form<? extends RecipientForm>)form, paymentType, mandates2, null, null, request, messages));
    }

    public Result edit(Http.Request request, int id, boolean mandates2) {
        return this.editRecipient(request, id, mandates2, false);
    }

    public Result editMode(Http.Request request, int id, boolean mandates2) {
        return this.editRecipient(request, id, mandates2, true);
    }

    public Result editRecipient(Http.Request request, int id, boolean mandates2, boolean editMode) {
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentRecipient paymentRecipient = PaymentRecipient.findById((int)id, (User)user);
        if (paymentRecipient == null) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.unknown", new Object[0]));
        }
        switch (paymentRecipient.getPaymentType()) {
            case DTAZV: {
                form = this.formFactory.form(DtazvRecipientForm.class).fill((Object)new DtazvRecipientForm(paymentRecipient));
                break;
            }
            case SEPA: 
            case AUSTRIAN_TAX_OFFICE: {
                form = this.formFactory.form(SepaRecipientForm.class).fill((Object)new SepaRecipientForm(paymentRecipient));
                break;
            }
            case MANDATE: {
                form = this.formFactory.form(SepaMandateForm.class).fill((Object)new SepaMandateForm(paymentRecipient));
                break;
            }
            case MT101: {
                form = this.formFactory.form(MT101RecipientForm.class).fill((Object)new MT101RecipientForm(paymentRecipient));
                break;
            }
            case AUSTRIAN_POSTBAR: {
                form = this.formFactory.form(PostbarRecipientForm.class).fill((Object)new PostbarRecipientForm(paymentRecipient));
                break;
            }
            case SEPA_FOREIGN: {
                form = this.formFactory.form(SepaForeignRecipientForm.class).fill((Object)new SepaForeignRecipientForm(paymentRecipient));
                break;
            }
            case CHEQUE: {
                form = this.formFactory.form(ChequeRecipientForm.class).fill((Object)new ChequeRecipientForm(paymentRecipient));
                break;
            }
            default: {
                return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.unknownpaymenttype", new Object[]{paymentRecipient.getPaymentType()}));
            }
        }
        Form tenantSelectForm = this.formFactory.form(TenantSelectForm.class);
        return Recipients.ok((Content)editrecipient.render((Form<? extends RecipientForm>)form, id, paymentRecipient.getPaymentType(), mandates2, (Form<TenantSelectForm>)tenantSelectForm, editMode, request, messages));
    }

    public Result saveNew(Http.Request request, String paymentTypeString, boolean mandates2) {
        PaymentRecipient pr;
        Form<? extends RecipientForm> form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)user)) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        PaymentType paymentType = PaymentType.valueOf((String)paymentTypeString);
        switch (paymentType) {
            case DTAZV: {
                form = this.formFactory.form(DtazvRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case SEPA: 
            case AUSTRIAN_TAX_OFFICE: {
                form = this.formFactory.form(SepaRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case MANDATE: {
                form = this.formFactory.form(SepaMandateForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case MT101: {
                form = this.formFactory.form(MT101RecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case AUSTRIAN_POSTBAR: {
                form = this.formFactory.form(PostbarRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case SEPA_FOREIGN: {
                form = this.formFactory.form(SepaForeignRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case CHEQUE: {
                form = this.formFactory.form(ChequeRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            default: {
                return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.unknownpaymenttype", new Object[]{paymentTypeString}));
            }
        }
        if (!form.hasErrors()) {
            form = ((RecipientForm)form.get()).validate(form, messages, User.getUser((String)((String)request.attrs().get(Security.USERNAME))));
        }
        if (form.hasErrors()) {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("error", messages.at("general.formerror", new Object[0]));
            return Recipients.ok((Content)newrecipient.render(form, paymentType, mandates2, null, flashMap, request, messages));
        }
        Tenant tenant = Tenant.getDefaultTenant();
        if (((RecipientForm)form.get()).tenantId != null) {
            tenant = Tenant.findById((int)((RecipientForm)form.get()).tenantId, (User)user, (boolean)user.isTenantAdmin());
        }
        if ((pr = PaymentRecipient.findNonHistoricRecipientByDisplayName((PaymentType)paymentType, (String)((RecipientForm)form.get()).displayName, (Tenant)tenant)) != null) {
            return Recipients.ok((Content)newrecipient.render((Form<? extends RecipientForm>)form.withError("displayName", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.displayNameAlreadyExists.recipient", (Object[])new Object[0])), paymentType, mandates2, null, null, request, messages));
        }
        PaymentRecipient paymentRecipient = new PaymentRecipient();
        paymentRecipient.setPaymentType(paymentType);
        try {
            ((RecipientForm)form.get()).store(paymentRecipient, user);
            if (paymentRecipient.getPaymentType() == PaymentType.MANDATE) {
                Logger.logSepaMandateCreated((User)user, (PaymentRecipient)paymentRecipient);
            } else {
                Logger.logRecipientCreated((User)user, (PaymentRecipient)paymentRecipient);
            }
            String flashMessage = mandates2 ? messages.at("mandates.created", new Object[0]) : messages.at("recipients.created", new Object[0]);
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("success", flashMessage);
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to save payment recipient!", e);
            String message = Utils.getLocalizedMessage(e, messages);
            String flashMessage = mandates2 ? messages.at("mandates.error.failedtocreate", new Object[]{message}) : messages.at("recipients.error.failedtocreate", new Object[]{message});
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("HTMLerror", flashMessage);
            return Recipients.ok((Content)newrecipient.render(form, paymentType, mandates2, null, flashMap, request, messages));
        }
    }

    public Result convertDTAZVToSEPA(Http.Request request, int id) {
        boolean mandates2 = false;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)user)) {
            return Recipients.redirect((Call)routes.Recipients.index(false)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findById((int)id, (User)user);
        if (paymentRecipient == null) {
            return Recipients.redirect((Call)routes.Recipients.index(false)).flashing("error", messages.at("recipients.unknown", new Object[0]));
        }
        if (paymentRecipient.getPaymentType() != PaymentType.DTAZV) {
            return Recipients.redirect((Call)routes.Recipients.index(false)).flashing("error", messages.at("recipients.transformSEPA.error", new Object[0]));
        }
        PaymentRecipient newPay = new PaymentRecipient();
        try {
            newPay = ConvertToOtherRecipientType.convertDtazvToSepaRecipient((PaymentRecipient)paymentRecipient);
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to save payment recipient!", e);
        }
        Form form = this.formFactory.form(SepaRecipientForm.class).fill((Object)new SepaRecipientForm(newPay));
        return Recipients.ok((Content)newrecipient.render((Form<? extends RecipientForm>)form, PaymentType.SEPA, false, paymentRecipient.getId(), null, request, messages));
    }

    public static Integer toBeConverted(String displayName, PaymentType paymentType, User user) {
        PaymentRecipient foundOne = (PaymentRecipient)PaymentRecipient.findRecipients((User)user, Collections.singletonList(paymentType)).where().eq("displayName", (Object)displayName).setMaxRows(1).findOne();
        if (foundOne == null) {
            return null;
        }
        return foundOne.getId();
    }

    public Result convertDTAZVToSEPAForeign(Http.Request request, int id) {
        boolean mandates2 = false;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)user)) {
            return Recipients.redirect((Call)routes.Recipients.index(false)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findById((int)id, (User)user);
        if (paymentRecipient == null) {
            return Recipients.redirect((Call)routes.Recipients.index(false)).flashing("error", messages.at("recipients.unknown", new Object[0]));
        }
        if (paymentRecipient.getPaymentType() != PaymentType.DTAZV) {
            return Recipients.redirect((Call)routes.Recipients.index(false)).flashing("error", messages.at("recipients.transformSEPA.error", new Object[0]));
        }
        PaymentRecipient newPay = new PaymentRecipient();
        try {
            newPay = ConvertToOtherRecipientType.convertDtazvToSepaForeignRecipient((PaymentRecipient)paymentRecipient);
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to save payment recipient!", e);
        }
        Form form = this.formFactory.form(SepaForeignRecipientForm.class).fill((Object)new SepaForeignRecipientForm(newPay));
        return Recipients.ok((Content)newrecipient.render((Form<? extends RecipientForm>)form, PaymentType.SEPA_FOREIGN, false, paymentRecipient.getId(), null, request, messages));
    }

    public Result update(Http.Request request, int id, boolean mandates2) {
        boolean displayNameChanged;
        Form<? extends RecipientForm> form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)user)) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findById((int)id, (User)user);
        if (paymentRecipient == null) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.unknown", new Object[0]));
        }
        switch (paymentRecipient.getPaymentType()) {
            case DTAZV: {
                form = this.formFactory.form(DtazvRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case SEPA: 
            case AUSTRIAN_TAX_OFFICE: {
                form = this.formFactory.form(SepaRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case MANDATE: {
                form = this.formFactory.form(SepaMandateForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case MT101: {
                form = this.formFactory.form(MT101RecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case AUSTRIAN_POSTBAR: {
                form = this.formFactory.form(PostbarRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case SEPA_FOREIGN: {
                form = this.formFactory.form(SepaForeignRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            case CHEQUE: {
                form = this.formFactory.form(ChequeRecipientForm.class).bindFromRequest(request, new String[0]);
                break;
            }
            default: {
                return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.unknownpaymenttype", new Object[]{paymentRecipient.getPaymentType()}));
            }
        }
        if (!form.hasErrors()) {
            form = ((RecipientForm)form.get()).validate(form, messages, User.getUser((String)((String)request.attrs().get(Security.USERNAME))));
        }
        Form tenantSelectForm = this.formFactory.form(TenantSelectForm.class);
        if (form.hasErrors()) {
            return Recipients.ok((Content)editrecipient.render(form, id, paymentRecipient.getPaymentType(), mandates2, (Form<TenantSelectForm>)tenantSelectForm, true, request, messages));
        }
        boolean bl = displayNameChanged = !paymentRecipient.getDisplayName().equals(((RecipientForm)form.get()).displayName);
        if (displayNameChanged) {
            PaymentRecipient pr;
            Tenant tenant = Tenant.getDefaultTenant();
            if (((RecipientForm)form.get()).tenantId != null) {
                tenant = Tenant.findById((int)((RecipientForm)form.get()).tenantId, (User)user, (boolean)user.isTenantAdmin());
            }
            if ((pr = PaymentRecipient.findNonHistoricRecipientByDisplayName((PaymentType)paymentRecipient.getPaymentType(), (String)((RecipientForm)form.get()).displayName, (Tenant)tenant)) != null) {
                return Recipients.ok((Content)editrecipient.render((Form<? extends RecipientForm>)form.withError("displayName", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.displayNameAlreadyExists.recipient", (Object[])new Object[0])), id, paymentRecipient.getPaymentType(), mandates2, (Form<TenantSelectForm>)tenantSelectForm, true, request, messages));
            }
        }
        try {
            ((RecipientForm)form.get()).store(paymentRecipient, user);
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to save payment recipient!", e);
            return Recipients.ok((Content)editrecipient.render(form, id, paymentRecipient.getPaymentType(), mandates2, (Form<TenantSelectForm>)tenantSelectForm, true, request, messages)).flashing("HTMLerror", Utils.getLocalizedMessage(e, messages));
        }
        String flashMessage = mandates2 ? messages.at("mandates.updated", new Object[0]) : messages.at("recipients.updated", new Object[0]);
        return Recipients.redirect((Call)routes.Recipients.edit(id, mandates2)).flashing("success", flashMessage);
    }

    public CompletionStage<Result> duplicate(Http.Request request, boolean mandates2) {
        return this.duplicateRecipients(request, mandates2, null);
    }

    public CompletionStage<Result> duplicateRecipient(Http.Request request, boolean mandates2, Integer id) {
        return this.duplicateRecipients(request, mandates2, id);
    }

    public CompletionStage<Result> duplicateRecipients(Http.Request request, boolean mandates2, Integer id) {
        play.api.mvc.Call redirectTo;
        String recipientIds;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id != null) {
            recipientIds = id.toString();
            redirectTo = routes.Recipients.edit(id, mandates2);
        } else {
            recipientIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.Recipients.index(mandates2);
        }
        Form tenantSelectForm = this.formFactory.form(TenantSelectForm.class).bindFromRequest(request, new String[0]);
        Integer tenantId = ((TenantSelectForm)tenantSelectForm.get()).getSelectedTenantId();
        return CompletableFuture.supplyAsync(() -> {
            String resultMessageKey;
            if (PreferenceUtil.disableRecipientRecording((User)user)) {
                return Recipients.redirect((Call)redirectTo).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
            }
            List<Integer> ids = GeneralUtils.getSelectionIds(recipientIds);
            List recipients2 = PaymentRecipient.findByIds(ids, (User)user);
            Tenant tenantToUse = tenantId != null ? Tenant.findById((int)tenantId, (User)user, (boolean)false) : null;
            int successCount = 0;
            for (PaymentRecipient paymentRecipient : recipients2) {
                if (!PreferenceUtil.allowUnrestrictedRecipientRecording((User)user) && (!PreferenceUtil.useFourEyesForRecipientRecording((User)user) || paymentRecipient.isInProcess())) continue;
                Tenant tenant = tenantToUse != null ? tenantToUse : paymentRecipient.getTenant();
                PaymentRecipient newPaymentRecipient = new PaymentRecipient();
                newPaymentRecipient.setPaymentType(paymentRecipient.getPaymentType());
                newPaymentRecipient.setDisplayName(RecipientData.getUniqueDisplayName((String)paymentRecipient.getDisplayName(), (PaymentType)paymentRecipient.getPaymentType(), (Tenant)tenant));
                newPaymentRecipient.setName(paymentRecipient.getName());
                newPaymentRecipient.setAccountNumber(paymentRecipient.getAccountNumber());
                newPaymentRecipient.setBankCode(paymentRecipient.getBankCode());
                newPaymentRecipient.setBankName(paymentRecipient.getBankName());
                newPaymentRecipient.setPurpose(paymentRecipient.getPurpose());
                newPaymentRecipient.setSepaMandateId(paymentRecipient.getSepaMandateId());
                newPaymentRecipient.setRecipientInfo(paymentRecipient.getRecipientInfo());
                newPaymentRecipient.setTenant(tenant);
                newPaymentRecipient.save(user, false);
                ++successCount;
            }
            if (recipients2.size() == successCount) {
                resultMessageKey = mandates2 ? "mandates.duplicated" : "recipients.duplicated";
                return Recipients.redirect((Call)redirectTo).flashing("success", messages.at(resultMessageKey, new Object[]{successCount}));
            }
            resultMessageKey = mandates2 ? "mandates.duplicated.ignored" : "recipients.duplicated.ignored";
            return Recipients.redirect((Call)redirectTo).flashing("warning", messages.at(resultMessageKey, new Object[]{successCount, recipients2.size() - successCount}));
        }, this.executionContext.current());
    }

    public Result delete(Http.Request request, boolean mandates2) {
        return this.deleteRecipients(request, mandates2, null);
    }

    public Result deleteRecipient(Http.Request request, boolean mandates2, Integer id) {
        return this.deleteRecipients(request, mandates2, id);
    }

    public Result deleteRecipients(Http.Request request, boolean mandates2, Integer id) {
        int count;
        Update delete;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        String recipientIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = id != null ? Collections.singletonList(id) : GeneralUtils.getSelectionIds(recipientIds);
        List recipients2 = PaymentRecipient.findByIds(ids, (User)user);
        if (ids.size() == 1) {
            delete = DB.createUpdate(PaymentRecipient.class, (String)"DELETE FROM PaymentRecipient WHERE id = :id");
            delete.set("id", (Object)ids.get(0));
        } else if (ids.size() > 1) {
            delete = DB.createUpdate(PaymentRecipient.class, (String)"DELETE FROM PaymentRecipient WHERE id IN (:ids)");
            delete.set("ids", ids);
        } else {
            delete = null;
        }
        if (delete != null) {
            count = delete.execute();
            for (PaymentRecipient recipient : recipients2) {
                if (recipient.getPaymentType() == PaymentType.MANDATE) {
                    Logger.logSepaMandateDeleted((User)user, (PaymentRecipient)recipient);
                    continue;
                }
                Logger.logRecipientDeleted((User)user, (PaymentRecipient)recipient);
            }
        } else {
            count = 0;
        }
        String resultMessageKey = mandates2 ? "mandates.deleted" : "recipients.deleted";
        String flashKey = count == 0 ? "warning" : "success";
        return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing(flashKey, messages.at(resultMessageKey, new Object[]{count}));
    }

    public Result rejectRecipient(Http.Request request, int id, boolean mandates2) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        PaymentRecipient pr = PaymentRecipient.findById((int)id, (User)user);
        pr.discard(user);
        return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("success", messages.at("payment.recipient.rejected", new Object[]{pr.getDisplayName()}));
    }

    public Result confirmRecipient(Http.Request request, int id, boolean mandates2) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        if (!new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION)) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("payment.recipient.confirmed.error.nopermission", new Object[0]));
        }
        PaymentRecipient pr = PaymentRecipient.findById((int)id, (User)user);
        if (pr.getCreatedUser().equals(user)) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("payment.recipient.confirmed.error.hasCreated", new Object[]{pr.getDisplayName()}));
        }
        pr.confirm(user, Integer.valueOf(id), null);
        return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("success", messages.at("payment.recipient.confirmed", new Object[0]));
    }

    public static boolean isRecipientEditable(User user, int id) {
        if (PreferenceUtil.disableRecipientRecording((User)user)) {
            return false;
        }
        if (PreferenceUtil.allowUnrestrictedRecipientRecording((User)user)) {
            return true;
        }
        PaymentRecipient pr = PaymentRecipient.findById((int)id, (User)user);
        boolean isConfirmDialog = false;
        if (pr != null && pr.isInProcess()) {
            isConfirmDialog = pr.isInProcessByOtherUser(user);
        }
        return !isConfirmDialog;
    }

    public CompletionStage<Result> exportIds(Http.Request request, boolean mandates2) {
        return this.saveRecipients(request, mandates2, null);
    }

    public CompletionStage<Result> exportRecipient(Http.Request request, boolean mandates2, Integer id) {
        return this.saveRecipients(request, mandates2, id);
    }

    public CompletionStage<Result> saveRecipients(Http.Request request, boolean mandates2, Integer id) {
        play.api.mvc.Call redirectTo;
        String recipientIds;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            recipientIds = id.toString();
            redirectTo = routes.Recipients.edit(id, mandates2);
        } else {
            recipientIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.Recipients.index(mandates2);
        }
        return CompletableFuture.supplyAsync(() -> {
            String flashMessage;
            List<Integer> ids = GeneralUtils.getSelectionIds(recipientIds);
            List recipients2 = PaymentRecipient.findByIds(ids, (User)user);
            List<PaymentRecipient> recipientsConfirmed = new ArrayList();
            if (PreferenceUtil.useFourEyesForRecipientRecording((User)user)) {
                for (PaymentRecipient paymentRecipient : recipients2) {
                    if (paymentRecipient.isInProcess()) continue;
                    recipientsConfirmed.add(paymentRecipient);
                }
            } else {
                recipientsConfirmed = recipients2;
            }
            String flashKey = "error";
            if (recipientsConfirmed != null && !recipientsConfirmed.isEmpty()) {
                String filename = mandates2 ? messages.at("mandates", new Object[0]) + ".csv" : messages.at("recipients", new Object[0]) + ".csv";
                PipedInputStream in = new PipedInputStream();
                try {
                    this.createRecipientExportFile(in, user, messages.lang().locale(), recipientsConfirmed);
                    return Recipients.ok((InputStream)in).as("text/csv").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(filename));
                }
                catch (IOException e) {
                    BLLoggerPlay.error("Failed to create recipient export file!", e);
                    flashMessage = Utils.getLocalizedMessage(e, messages);
                    flashKey = "HTMLerror";
                }
            } else {
                flashMessage = PreferenceUtil.useFourEyesForRecipientRecording((User)user) && recipients2 != null && !recipients2.isEmpty() ? messages.at("recipients.export.norecipients.notconfirmed", new Object[0]) : messages.at("recipients.export.norecipients", new Object[0]);
            }
            return Recipients.redirect((Call)redirectTo).flashing(flashKey, flashMessage);
        }, this.executionContext.current());
    }

    public Result updateVopNames(Http.Request request, Integer recipientId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return Recipients.redirect((Call)routes.Recipients.index(false)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        Form vopForm = this.formFactory.form(LoadVopRecipientNamesForm.class).bindFromRequest(request, new String[0]);
        Map<Integer, Boolean> selectedRecipientsFromForm = ((LoadVopRecipientNamesForm)vopForm.get()).selectedRecipients;
        String recipientIdsFromPostBody = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Object> ids = recipientId != null ? Collections.singletonList(recipientId) : (selectedRecipientsFromForm != null && !selectedRecipientsFromForm.isEmpty() ? selectedRecipientsFromForm.keySet().stream().filter(selectedRecipientsFromForm::get).collect(Collectors.toList()) : GeneralUtils.getSelectionIds(recipientIdsFromPostBody));
        List recipients2 = PaymentRecipient.findByIds(ids, (User)user);
        if (recipients2.isEmpty()) {
            return Recipients.redirect((Call)routes.Recipients.index(false)).flashing("warning", messages.at("recipients.vopNameUpdate.nothingToUpdate", new Object[0]));
        }
        ArrayList<PaymentRecipient> recipientsSkipped = new ArrayList<PaymentRecipient>();
        HashMap<PaymentRecipient, String> recipientsSuccess = new HashMap<PaymentRecipient, String>();
        try (Transaction t = DB.beginTransaction();){
            for (PaymentRecipient recipient : recipients2) {
                String currentDisplayName = recipient.getDisplayName();
                String currentName = recipient.getName();
                String vopName = recipient.getVopName();
                if (vopName == null || vopName.equals(currentName)) {
                    recipientsSkipped.add(recipient);
                    continue;
                }
                recipient.setName(vopName);
                if (currentName.equals(currentDisplayName)) {
                    recipient.setDisplayName(vopName);
                }
                recipient.setVopResult(StatusCode.VopResultCodes.RCVC.name());
                recipient.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
                recipientsSuccess.put(recipient, currentName);
            }
            t.commit();
        }
        for (PaymentRecipient recipient : recipientsSuccess.keySet()) {
            Logger.logRecipientRenamedFromVOP((User)user, (PaymentRecipient)recipient, (String)((String)recipientsSuccess.get(recipient)), (String)recipient.getName());
            Logger.logRecipientModified((User)user, (PaymentRecipient)recipient, (Logger.RecipientField)Logger.RecipientField.NAME, (String)((String)recipientsSuccess.get(recipient)), (String)recipient.getName());
        }
        int countSuccess = recipientsSuccess.size();
        int countSkipped = recipientsSkipped.size();
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (countSuccess == 1) {
            String newName = ((PaymentRecipient)recipientsSuccess.entrySet().iterator().next().getKey()).getName();
            Utils.addToFlash(flashMap, "success", messages.at("recipients.vopNameUpdate.successSingle", new Object[]{newName}));
        } else if (countSuccess > 1) {
            Utils.addToFlash(flashMap, "success", messages.at("recipients.vopNameUpdate.successMulti", new Object[]{countSuccess}));
        }
        if (countSkipped == 1) {
            String name = ((PaymentRecipient)recipientsSkipped.getFirst()).getName();
            Utils.addToFlash(flashMap, "warning", messages.at("recipients.vopNameUpdate.failedSingle", new Object[]{name}));
        } else if (countSkipped > 1) {
            Utils.addToFlash(flashMap, "warning", messages.at("recipients.vopNameUpdate.failedMulti", new Object[]{countSkipped}));
        }
        if (ids.size() == 1) {
            return Recipients.redirect((Call)routes.Recipients.edit(ids.getFirst(), false)).flashing(flashMap);
        }
        return Recipients.redirect((Call)routes.Recipients.index(false)).flashing(flashMap);
    }

    public Result updateVopNamesPage(Http.Request request, String recipientIds) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List<Integer> recipientIdsList = GeneralUtils.getSelectionIds(recipientIds);
        String referer = Utils.getHeaderValue(request, "referer");
        String redirectTo = referer != null ? referer : routes.Recipients.index(false).url();
        try {
            LoadVopRecipientNamesForm formValues = new LoadVopRecipientNamesForm();
            Form form = this.formFactory.form(LoadVopRecipientNamesForm.class).fill((Object)formValues);
            List<LoadVopRecipientNamesForm.RecipientVopResult> vopRecipients = formValues.loadRecipientsMap(user, recipientIdsList);
            if (vopRecipients.isEmpty()) {
                return Recipients.redirect((String)redirectTo).flashing("info", messages.at("recipients.vopNameUpdate.nothingToUpdate", new Object[0]));
            }
            return Recipients.ok((Content)loadVopRecipientNames.render(vopRecipients, (Form<LoadVopRecipientNamesForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to load the VOP recipient name update page!", e);
            return Recipients.redirect((String)redirectTo).flashing("HTMLerror", messages.at("recipients.vopNameUpdate.error", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
    }

    public Result importFile(Http.Request request, boolean mandates2) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (PreferenceUtil.disableRecipientRecording((User)User.getUser((String)((String)request.attrs().get(Security.USERNAME))))) {
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
        }
        RecipientImportForm form = new RecipientImportForm();
        form.setDefaultFileImportParameters(mandates2, messages);
        return Recipients.ok((Content)recipientsimportfile.render((Form<DynamicForm.Dynamic>)this.formFactory.form().fill(form.buildDataMap()), mandates2, request, messages));
    }

    public CompletionStage<Result> importFileConfig(Http.Request request, boolean mandates2) {
        Form form = this.formFactory.form(RecipientImportForm.class).bindFromRequest(request, new String[0]);
        Http.MultipartFormData fileFormData = request.body().asMultipartFormData();
        Http.MultipartFormData.FilePart filePart = fileFormData.getFile("import_recipient_file");
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            File formFile = null;
            try {
                String fileId;
                String[][] importData;
                if (PreferenceUtil.disableRecipientRecording((User)user)) {
                    Result result = Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
                    return result;
                }
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                if (filePart == null || filePart.getRef() == null || ((Files.TemporaryFile)filePart.getRef()).path() == null) {
                    errors.add(new ValidationError("import_recipient_file", "error.required"));
                    importData = null;
                } else if (!form.hasErrors()) {
                    formFile = ((Files.TemporaryFile)filePart.getRef()).path().toFile();
                    importData = ((RecipientImportForm)form.get()).readFile(formFile, user, messages, true, errors);
                } else {
                    importData = null;
                    errors.addAll(form.errors());
                }
                if (!errors.isEmpty()) {
                    DynamicForm dynamicForm = this.formFactory.form().fill(new HashMap(form.rawData()));
                    for (ValidationError error : errors) {
                        dynamicForm = dynamicForm.withError(error);
                    }
                    Result result = Recipients.ok((Content)recipientsimportfile.render((Form<DynamicForm.Dynamic>)dynamicForm, mandates2, request, messages));
                    return result;
                }
                try {
                    fileId = CsvImport.writeDataToFile(importData);
                }
                catch (IOException | GeneralSecurityException e) {
                    BLLoggerPlay.error("Failed to store CSV file with import recipients!", e);
                    DynamicForm dynamicForm = this.formFactory.form().fill(new HashMap(form.rawData()));
                    for (ValidationError error : errors) {
                        dynamicForm = dynamicForm.withError(error);
                    }
                    Result result = Recipients.ok((Content)recipientsimportfile.render((Form<DynamicForm.Dynamic>)dynamicForm.withGlobalError(Utils.getLocalizedMessage(e, messages)), mandates2, request, messages));
                    if (formFile != null && formFile.isFile() && !formFile.delete()) {
                        formFile.deleteOnExit();
                    }
                    return result;
                }
                HashMap<String, Object> dynamicData = new HashMap<String, Object>(form.rawData());
                ((RecipientImportForm)form.get()).setDefaultImportConfigParameters(PaymentType.valueOf((String)((RecipientImportForm)form.get()).paymentType), mandates2, dynamicData, importData);
                Result result = Recipients.ok((Content)recipientsimportcolumns.render((Form<DynamicForm.Dynamic>)this.formFactory.form().fill(dynamicData), ((RecipientImportForm)form.get()).tenantId, ((RecipientImportForm)form.get()).paymentType, fileId, RecipientImportForm.getFormatColumns(PaymentType.valueOf((String)((RecipientImportForm)form.get()).paymentType), user, messages), importData, mandates2, request, messages));
                return result;
            }
            finally {
                if (formFile != null && formFile.isFile() && !formFile.delete()) {
                    formFile.deleteOnExit();
                }
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> importFileStore(Http.Request request, String paymentType, Integer tenantId, String fileId, boolean mandates2) {
        Form form = this.formFactory.form(RecipientImportForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            int storedNumber;
            String[][] importData;
            if (PreferenceUtil.disableRecipientRecording((User)user)) {
                return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.recordingnotallowed", new Object[0]));
            }
            WorkspaceFile file2 = CsvImport.getFileById(fileId);
            File f = WorkspaceFileSystem.getFile((WorkspaceFile)file2);
            if (!f.isFile()) {
                BLLoggerPlay.error("Recipients import file " + f.getAbsolutePath() + " was not found!");
                return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing("error", messages.at("recipients.importfilenotfound", new Object[0]));
            }
            if (!form.hasErrors()) {
                ((RecipientImportForm)form.get()).paymentType = paymentType;
                ((RecipientImportForm)form.get()).tenantId = tenantId;
                ((RecipientImportForm)form.get()).separator = CsvColumnSeparator.SEMICOLON.name();
                ((RecipientImportForm)form.get()).encoding = Charset.defaultCharset().name();
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                importData = ((RecipientImportForm)form.get()).readFile(f, user, messages, false, errors);
                if (!errors.isEmpty()) {
                    DynamicForm dynamicForm = this.formFactory.form().fill(new HashMap(form.rawData()));
                    for (ValidationError error : errors) {
                        dynamicForm = dynamicForm.withError(error);
                    }
                    return Recipients.ok((Content)recipientsimportfile.render((Form<DynamicForm.Dynamic>)dynamicForm, mandates2, request, messages));
                }
            } else {
                importData = new String[0][0];
            }
            HashMap<String, String> flashMap = new HashMap<String, String>();
            if (importData != null && importData.length > 0 && !form.hasErrors()) {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                storedNumber = ((RecipientImportForm)form.get()).storeRecipients((Form<RecipientImportForm>)form, messages, user, importData, errors, flashMap);
                if (!errors.isEmpty()) {
                    DynamicForm dynamicForm = this.formFactory.form().fill(new HashMap(form.rawData()));
                    for (ValidationError error : errors) {
                        dynamicForm = dynamicForm.withError(error);
                    }
                    return Recipients.ok((Content)recipientsimportcolumns.render((Form<DynamicForm.Dynamic>)dynamicForm, tenantId, paymentType, fileId, RecipientImportForm.getFormatColumns(PaymentType.valueOf((String)paymentType), user, messages), importData, mandates2, request, messages));
                }
            } else {
                storedNumber = 0;
            }
            if (form.hasErrors()) {
                DynamicForm dynamicForm = this.formFactory.form().fill(new HashMap(form.rawData()));
                for (ValidationError error : form.errors()) {
                    dynamicForm = dynamicForm.withError(error);
                }
                return Recipients.ok((Content)recipientsimportcolumns.render((Form<DynamicForm.Dynamic>)dynamicForm, tenantId, paymentType, fileId, RecipientImportForm.getFormatColumns(PaymentType.valueOf((String)paymentType), user, messages), importData, mandates2, request, messages));
            }
            WorkspaceFileSystem.delete((WorkspaceFile)file2);
            int ignoredNumber = importData == null ? 0 : importData.length - storedNumber;
            String flashKey = storedNumber > 0 ? "success" : "warning";
            String flashTextKey = "recipients.import.done";
            if (((RecipientImportForm)form.get()).paymentType.equals("MANDATE")) {
                flashTextKey = "recipients.import.done.mandate";
            }
            flashMap.put(flashKey, messages.at(flashTextKey, new Object[]{storedNumber, ignoredNumber}));
            return Recipients.redirect((Call)routes.Recipients.index(mandates2)).flashing(flashMap);
        }, this.executionContext.current());
    }

    public WebSocket csvImportController() {
        final CsvImportInfo info = new CsvImportInfo();
        return WebSocket.Text.accept(request -> Flow.fromFunction((Function & Serializable)in -> {
            info.handleRequest((String)in);
            return "";
        }).watchTermination((Function2 & Serializable)(notUsed, stage) -> {
            stage.whenCompleteAsync((result, throwable) -> new Timer().schedule(new TimerTask(this){

                @Override
                public void run() {
                    info.closed();
                }
            }, 5000L));
            return "";
        }));
    }

    private void createRecipientExportFile(PipedInputStream target, User user, Locale locale, List<PaymentRecipient> recipients2) throws IOException {
        HashMap recipientsMap = new HashMap();
        for (PaymentRecipient recipient : recipients2) {
            DtazvRecipientData data;
            if (recipient.getPaymentType() == PaymentType.DTAZV) {
                data = new DtazvRecipientData();
            } else if (recipient.getPaymentType() == PaymentType.SEPA) {
                data = new SepaRecipientData();
            } else if (recipient.getPaymentType() == PaymentType.MANDATE) {
                data = new SepaMandateData();
            } else if (recipient.getPaymentType() == PaymentType.MT101) {
                data = new MT101RecipientData();
            } else if (recipient.getPaymentType() == PaymentType.CHEQUE) {
                data = new ChequeRecipientData();
            } else if (recipient.getPaymentType() == PaymentType.AUSTRIAN_TAX_OFFICE) {
                data = new SepaRecipientData();
            } else if (recipient.getPaymentType() == PaymentType.SEPA_FOREIGN) {
                data = new SepaForeignRecipientData();
            } else {
                if (recipient.getPaymentType() != PaymentType.AUSTRIAN_POSTBAR) continue;
                data = new PostbarRecipientData();
            }
            data.setPaymentRecipient(recipient);
            if (!recipientsMap.containsKey(recipient.getPaymentType())) {
                recipientsMap.put(recipient.getPaymentType(), new ArrayList());
            }
            ((List)recipientsMap.get(recipient.getPaymentType())).add(data);
        }
        if (recipientsMap.isEmpty()) {
            return;
        }
        new Thread(() -> {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(new PipedOutputStream(target));
                for (List list : recipientsMap.values()) {
                    boolean addedHeader = false;
                    for (RecipientData recipientData : list) {
                        recipientData.csvExport((Writer)writer, user, locale, ';', !addedHeader, "\r\n");
                        addedHeader = true;
                    }
                    writer.write("\r\n");
                }
            }
            catch (Throwable t) {
                try {
                    BLLoggerPlay.error("Failed to generate recipients export file!", t);
                }
                catch (Throwable throwable) {
                    Util.closeStream(writer);
                    throw throwable;
                }
                Util.closeStream((Closeable)writer);
            }
            Util.closeStream((Closeable)writer);
        }).start();
    }
}

