/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.Setup;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PreferenceUtil;
import de.businesslogics.banking.api.ProgressMonitorDummy;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.api.JdbcSettings;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.ds.api.DsCleanUp;
import de.businesslogics.banking.mt940.api.CmCleanUp;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.transfer.api.TransferCleanUp;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.IProgressMonitorWrapper;
import de.businesslogics.util.PaymentUtils;
import io.ebean.Transaction;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import models.ChangePasswordForm;
import models.LoadDefaultPreferencesForm;
import models.WebAuthnData;
import models.preferences.PreferenceChangedHandler;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.libs.ws.WSClient;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Option;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.settings.adminsettings;
import views.html.settings.loadDefaultPreferences;
import views.html.settings.preferences;

@Security.Authenticated(value=AuthenticatorFor.Settings.class)
public final class Preferences
extends Controller {
    private static final Map<Integer, String> formIds = new HashMap<Integer, String>();
    private static final Map<Type, List<DatabasePreferenceConstant>> bankingPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> bankingPrintPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> passwordRequirementsPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> transferPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> transferSendReportPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> transferCleanupPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> transferCleanupSentPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> transferCleanupFetchedPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> transferCleanupNotificationsPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> transferCleanupProtocolPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> desPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> desCleanupPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> desCleanupSignedPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> desCleanupRejectedPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> paymentPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> paymentPrintPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> paymentDisplayPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> sepaPaymentPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> cmPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> cmDisplayPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> cmPrintPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> cmCleanupPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> cmCleanupStatementsPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> cmCleanupAdvicesPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> cmCleanupDtiPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> cmCleanupExportedFilesPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> awzelPreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, List<DatabasePreferenceConstant>> updatePreferences = new HashMap<Type, List<DatabasePreferenceConstant>>();
    private static final Map<Type, Map<Preference.ApplicationId, Map<Category, List<DatabasePreferenceConstant>>>> allPreferences = new HashMap<Type, Map<Preference.ApplicationId, Map<Category, List<DatabasePreferenceConstant>>>>();
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;
    private final WSClient wsClient;

    public static List<DatabasePreferenceConstant> getPreferences(Type ofType, Category forCategory) {
        return switch (forCategory.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Preferences.getBankingPreferences(ofType);
            case 1 -> Preferences.getBankingPrintPreferences(ofType);
            case 2 -> Preferences.getPasswordRequirementsPreferences(ofType);
            case 3 -> Preferences.getUpdatePreferences(ofType);
            case 4 -> Preferences.getTransferPreferences(ofType);
            case 5 -> Preferences.getTransferSendReportPreferences(ofType);
            case 6 -> Preferences.getTransferCleanupPreferences(ofType);
            case 7 -> Preferences.getTransferCleanupSentPreferences(ofType);
            case 9 -> Preferences.getTransferCleanupNotificationsPreferences(ofType);
            case 8 -> Preferences.getTransferCleanupFetchedPreferences(ofType);
            case 10 -> Preferences.getTransferCleanupProtocolPreferences(ofType);
            case 11 -> Preferences.getDesPreferences(ofType);
            case 12 -> Preferences.getDesCleanupPreferences(ofType);
            case 13 -> Preferences.getDesCleanupSignedPreferences(ofType);
            case 14 -> Preferences.getDesCleanupRejectedPreferences(ofType);
            case 15 -> Preferences.getPaymentPreferences(ofType);
            case 16 -> Preferences.getSepaPaymentPreferences(ofType);
            case 17 -> Preferences.getPaymentDisplayPreferences(ofType);
            case 18 -> Preferences.getPaymentPrintPreferences(ofType);
            case 19 -> Preferences.getCmPreferences(ofType);
            case 20 -> Preferences.getCmDisplayPreferences(ofType);
            case 21 -> Preferences.getCmPrintPreferences(ofType);
            case 22 -> Preferences.getCmCleanupPreferences(ofType);
            case 23 -> Preferences.getCmCleanupStatementsPreferences(ofType);
            case 24 -> Preferences.getCmCleanupAdvicesPreferences(ofType);
            case 25 -> Preferences.getCmCleanupDtiPreferences(ofType);
            case 26 -> Preferences.getCmCleanupExportedFilesPreferences(ofType);
            case 27 -> Preferences.getAwzelPreferences(ofType);
        };
    }

    private static Map<Preference.ApplicationId, Map<Category, List<DatabasePreferenceConstant>>> getAllPreferences(Type forType) {
        if (!allPreferences.containsKey((Object)forType) || allPreferences.get((Object)forType).isEmpty()) {
            HashMap allPreferencesForType = new HashMap();
            allPreferences.put(forType, allPreferencesForType);
            HashMap<Category, List<DatabasePreferenceConstant>> bankingPreferences = new HashMap<Category, List<DatabasePreferenceConstant>>();
            bankingPreferences.put(Category.GENERAL, Preferences.getBankingPreferences(forType));
            bankingPreferences.put(Category.GENERAL_PRINT, Preferences.getBankingPrintPreferences(forType));
            bankingPreferences.put(Category.GENERAL_PASSWORD, Preferences.getPasswordRequirementsPreferences(forType));
            bankingPreferences.put(Category.EDS, Preferences.getDesPreferences(forType));
            bankingPreferences.put(Category.EDS_CLEANUP, Preferences.getDesCleanupPreferences(forType));
            bankingPreferences.put(Category.EDS_CLEANUP_SIGNED, Preferences.getDesCleanupSignedPreferences(forType));
            bankingPreferences.put(Category.EDS_CLEANUP_REJECTED, Preferences.getDesCleanupRejectedPreferences(forType));
            allPreferencesForType.put(Preference.ApplicationId.BANKING, bankingPreferences);
            HashMap<Category, List<DatabasePreferenceConstant>> transferPreferences = new HashMap<Category, List<DatabasePreferenceConstant>>();
            transferPreferences.put(Category.TRANSFER, Preferences.getTransferPreferences(forType));
            transferPreferences.put(Category.TRANSFER_SEND_REPORT, Preferences.getTransferSendReportPreferences(forType));
            transferPreferences.put(Category.TRANSFER_CLEANUP, Preferences.getTransferCleanupPreferences(forType));
            transferPreferences.put(Category.TRANSFER_CLEANUP_SENT, Preferences.getTransferCleanupSentPreferences(forType));
            transferPreferences.put(Category.TRANSFER_CLEANUP_FETCHED, Preferences.getTransferCleanupFetchedPreferences(forType));
            transferPreferences.put(Category.TRANSFER_CLEANUP_NOTIFICATIONS, Preferences.getTransferCleanupNotificationsPreferences(forType));
            transferPreferences.put(Category.TRANSFER_CLEANUP_PROTOCOL, Preferences.getTransferCleanupProtocolPreferences(forType));
            allPreferencesForType.put(Preference.ApplicationId.TRANSFER, transferPreferences);
            HashMap<Category, List<DatabasePreferenceConstant>> cmPreferences = new HashMap<Category, List<DatabasePreferenceConstant>>();
            cmPreferences.put(Category.CM, Preferences.getCmPreferences(forType));
            cmPreferences.put(Category.CM_DISPLAY, Preferences.getCmDisplayPreferences(forType));
            cmPreferences.put(Category.CM_PRINT, Preferences.getCmPrintPreferences(forType));
            cmPreferences.put(Category.CM_CLEANUP, Preferences.getCmCleanupPreferences(forType));
            cmPreferences.put(Category.CM_CLEANUP_STATEMENTS, Preferences.getCmCleanupStatementsPreferences(forType));
            cmPreferences.put(Category.CM_CLEANUP_ADVICES, Preferences.getCmCleanupAdvicesPreferences(forType));
            cmPreferences.put(Category.CM_CLEANUP_DTI, Preferences.getCmCleanupDtiPreferences(forType));
            cmPreferences.put(Category.CM_CLEANUP_EXPORTED_FILES, Preferences.getCmCleanupExportedFilesPreferences(forType));
            allPreferencesForType.put(Preference.ApplicationId.CM, cmPreferences);
            HashMap<Category, List<DatabasePreferenceConstant>> paymentPreferences = new HashMap<Category, List<DatabasePreferenceConstant>>();
            paymentPreferences.put(Category.PAYMENTS, Preferences.getPaymentPreferences(forType));
            paymentPreferences.put(Category.PAYMENTS_DISPLAY, Preferences.getPaymentDisplayPreferences(forType));
            paymentPreferences.put(Category.PAYMENTS_PRINT, Preferences.getPaymentPrintPreferences(forType));
            allPreferencesForType.put(Preference.ApplicationId.PAYMENTS, paymentPreferences);
            HashMap<Category, List<DatabasePreferenceConstant>> sepaPreferences = new HashMap<Category, List<DatabasePreferenceConstant>>();
            sepaPreferences.put(Category.PAYMENTS_SEPA, Preferences.getSepaPaymentPreferences(forType));
            allPreferencesForType.put(Preference.ApplicationId.SEPA, sepaPreferences);
            HashMap<Category, List<DatabasePreferenceConstant>> awvPreferences = new HashMap<Category, List<DatabasePreferenceConstant>>();
            awvPreferences.put(Category.AWV, Preferences.getAwzelPreferences(forType));
            allPreferencesForType.put(Preference.ApplicationId.AWZEL, awvPreferences);
            HashMap<Category, List<DatabasePreferenceConstant>> updatePreferences = new HashMap<Category, List<DatabasePreferenceConstant>>();
            updatePreferences.put(Category.GENERAL_UPDATE, Preferences.getUpdatePreferences(forType));
            allPreferencesForType.put(Preference.ApplicationId.UPDATE, updatePreferences);
        }
        return allPreferences.get((Object)forType);
    }

    private static boolean isOfType(DatabasePreferenceConstant preference2, Type type) {
        if (Type.ADMIN_SETTING == type) {
            return preference2.isOnlyConfigurableByAdmin() || !preference2.isUserSpecific();
        }
        if (Type.TENANT_SETTING == type) {
            return preference2.isOnlyConfigurableByAdminOrTenantAdmin();
        }
        return preference2.isUserSpecific() && !preference2.isOnlyConfigurableByAdmin() && !preference2.isOnlyConfigurableByAdminOrTenantAdmin();
    }

    private static List<DatabasePreferenceConstant> filterPreferences(List<DatabasePreferenceConstant> preferences2, Type byType) {
        return preferences2.stream().filter(p -> Preferences.isOfType(p, byType)).toList();
    }

    public static boolean showPreferenceForUser(User user, DatabasePreferenceConstant preference2) {
        if (preference2 == de.businesslogics.banking.preferences.PreferenceConstants.PRINT_AMOUNTS_OF_SALARY_PAYMENTS) {
            return Util.displayOpenSalaries((User)user);
        }
        if (preference2 == de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION) {
            return Branding.getBranding().showAllowInvalidBankConnectionPreference();
        }
        if (preference2 == de.businesslogics.banking.preferences.PreferenceConstants.REQUIRE_2FA_FOR_LOGIN && !Yubikey.hasAnyKeys((User)user)) {
            return false;
        }
        if (!(GeneralUtils.isSuperAdmin(user) || preference2 != de.businesslogics.banking.preferences.PreferenceConstants.ENCRYPT_DATA && preference2 != de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED && preference2 != de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED_AGE && preference2 != de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED_UNIT && preference2 != de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED && preference2 != de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED_AGE && preference2 != de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED_UNIT && preference2 != de.businesslogics.banking.preferences.PreferenceConstants.ALLOW_USER_CREATION && preference2 != de.businesslogics.banking.preferences.PreferenceConstants.ALLOW_TENANT_CREATION && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_AGE && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_FILES && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_UNIT && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_AGE && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_FILES && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_UNIT && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL_AGE && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL_UNIT && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_AGE && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_FILES && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_UNIT && preference2 != de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_UP && preference2 != CmPreferenceConstants.CLEAN_ADVICES && preference2 != CmPreferenceConstants.CLEAN_ADVICES_AGE && preference2 != CmPreferenceConstants.CLEAN_ADVICES_UNIT && preference2 != CmPreferenceConstants.CLEAN_AUTOMATIC && preference2 != CmPreferenceConstants.CLEAN_DTI_FILES && preference2 != CmPreferenceConstants.CLEAN_DTI_FILES_AGE && preference2 != CmPreferenceConstants.CLEAN_DTI_FILES_UNIT && preference2 != CmPreferenceConstants.CLEAN_STATEMENTS && preference2 != CmPreferenceConstants.CLEAN_STATEMENTS_AGE && preference2 != CmPreferenceConstants.CLEAN_STATEMENTS_UNIT && preference2 != CmPreferenceConstants.CLEAN_EXPORTED_FILES && preference2 != CmPreferenceConstants.CLEAN_EXPORTED_FILES_AGE && preference2 != CmPreferenceConstants.CLEAN_EXPORTED_FILES_UNIT)) {
            return false;
        }
        return user.isAdminOrTenantAdmin() && preference2.isOnlyConfigurableByAdminOrTenantAdmin() || user.isAdmin() || !preference2.isOnlyConfigurableByAdmin() && preference2.isUserSpecific();
    }

    public static Option<String> getLabelOverride(DatabasePreferenceConstant preference2) {
        if (preference2 == CmPreferenceConstants.DISPLAY_ONLY_SINGLE_BOOKINGS) {
            return Option.apply((Object)"preferences.cm.displaySingleBookings");
        }
        if (preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_UP || preference2 == de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_UP || preference2 == CmPreferenceConstants.CLEAN_AUTOMATIC) {
            return Option.apply((Object)"preferences.cleanup.automatic");
        }
        if (preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_AGE || preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_AGE || preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_AGE || preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL_AGE || preference2 == de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED_AGE || preference2 == de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED_AGE || preference2 == CmPreferenceConstants.CLEAN_STATEMENTS_AGE || preference2 == CmPreferenceConstants.CLEAN_ADVICES_AGE || preference2 == CmPreferenceConstants.CLEAN_DTI_FILES_AGE || preference2 == CmPreferenceConstants.CLEAN_EXPORTED_FILES_AGE) {
            return Option.apply((Object)"preferences.cleanup.olderthan.number");
        }
        if (preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_UNIT || preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_UNIT || preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_UNIT || preference2 == de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL_UNIT || preference2 == de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED_UNIT || preference2 == de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED_UNIT || preference2 == CmPreferenceConstants.CLEAN_STATEMENTS_UNIT || preference2 == CmPreferenceConstants.CLEAN_ADVICES_UNIT || preference2 == CmPreferenceConstants.CLEAN_DTI_FILES_UNIT || preference2 == CmPreferenceConstants.CLEAN_EXPORTED_FILES_UNIT) {
            return Option.apply((Object)"preferences.cleanup.olderthan.unit");
        }
        return Option.empty();
    }

    public static long getNumberOfPreferencesShownForUser(User user, List<DatabasePreferenceConstant> preferences2) {
        return preferences2.stream().filter(p -> Preferences.showPreferenceForUser(user, p)).count();
    }

    public static String getFormId(Preference.ApplicationId application, DatabasePreferenceConstant pref) {
        int key = application.ordinal() * 255 ^ pref.getId().hashCode();
        Object result = formIds.get(key);
        if (result == null) {
            result = application.name().toLowerCase() + "_" + pref.getId();
            formIds.put(key, (String)result);
        }
        return result;
    }

    public static Seq<Tuple3<String, String, Boolean>> getSelectableOptions(Locale locale, User user, DatabasePreferenceConstant pref) {
        ArrayList<Tuple3> result = new ArrayList<Tuple3>();
        String[][] options = pref.getSelectableOptions(locale);
        if (options != null) {
            for (String[] option : options) {
                String key = option[1];
                String label = option[0];
                boolean hidden2 = Preferences.hideSelectableOption(key, pref, user);
                result.add(new Tuple3((Object)key, (Object)label, (Object)hidden2));
            }
        }
        return Scala.toSeq(result);
    }

    public static boolean hideSelectableOption(String optionKey, DatabasePreferenceConstant pref, User user) {
        if (de.businesslogics.banking.awzel.PreferenceConstants.REPORT_WITHOUT_CONVERSION.equals((Object)pref) && "prompt".equals(optionKey)) {
            return true;
        }
        if (de.businesslogics.banking.preferences.PreferenceConstants.STARTPAGE_BUTTONS.equals((Object)pref)) {
            if (PreferenceConstants.BUTTONS_ON_START_PAGE.EDS.getValueAsString().equals(optionKey)) {
                return user.isLocalUser() || !PreferenceUtil.doAllowVEU((User)user);
            }
            if (PreferenceConstants.BUTTONS_ON_START_PAGE.OPEN_PAYMETS.getValueAsString().equals(optionKey)) {
                return !PreferenceUtil.doAllowPaymentRecording((User)user);
            }
            if (PreferenceConstants.BUTTONS_ON_START_PAGE.CM.getValueAsString().equals(optionKey)) {
                return !PreferenceUtil.doAllowViewAccountStatements((User)user);
            }
            if (PreferenceConstants.BUTTONS_ON_START_PAGE.BANKS.getValueAsString().equals(optionKey)) {
                return !PreferenceUtil.doAllowSettings((User)user) || Branding.getBranding().hideBankIconOnLandingPage() || !PreferenceUtil.doAllowBanksAndAccounts((User)user);
            }
            if (PreferenceConstants.BUTTONS_ON_START_PAGE.TENANTS.getValueAsString().equals(optionKey)) {
                return !user.isAdminOrTenantAdmin() || !PreferenceUtil.doAllowSettings((User)user);
            }
            if (PreferenceConstants.BUTTONS_ON_START_PAGE.SEND_FILE.getValueAsString().equals(optionKey)) {
                return user.isLocalUser() || !PreferenceUtil.doAllowViewSentFiles((User)user);
            }
            if (PreferenceConstants.BUTTONS_ON_START_PAGE.FETCH_FILE.getValueAsString().equals(optionKey)) {
                return user.isLocalUser() || !PreferenceUtil.doAllowViewFetchedFiles((User)user);
            }
        }
        return false;
    }

    public static Seq<Tuple2<Symbol, String>> getLimitsForNumericPreference(DatabasePreferenceConstant pref) {
        ArrayList<Tuple2> resultList = new ArrayList<Tuple2>();
        if (pref == de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_MIN_LENGTH) {
            resultList.add(Scala.Tuple((Object)Symbol.apply((String)"min"), (Object)"1"));
        } else if (pref == de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_CHANGE_IN_DAYS || pref == de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_CHECK_HISTORY || pref == de.businesslogics.banking.transfer.gui.PreferenceConstants.PTK_DELAY || pref == de.businesslogics.banking.payments.core.PreferenceConstants.PERIODIC_PREFIX_IN_WORKING_DAYS || pref == de.businesslogics.banking.payments.core.PreferenceConstants.MAX_ENTRIES_FOR_RECIPIENT_POPUP || pref == CmPreferenceConstants.TOLERANCE_DTI_MT940_MATCHING) {
            resultList.add(Scala.Tuple((Object)Symbol.apply((String)"min"), (Object)"0"));
        } else if (pref == de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_USER_LOCKED) {
            resultList.add(Scala.Tuple((Object)Symbol.apply((String)"min"), (Object)"1"));
        }
        return Scala.toSeq(resultList);
    }

    public static List<DatabasePreferenceConstant> getBankingPreferences(Type forType) {
        if (!bankingPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> bankingPreferencesForType = Setup.REQUIRE_2FA_FOR_LOGIN ? Arrays.asList(de.businesslogics.banking.preferences.PreferenceConstants.ENCRYPT_DATA, de.businesslogics.banking.preferences.PreferenceConstants.SESSION_TIMEOUT, de.businesslogics.banking.preferences.PreferenceConstants.REFRESH_HTD, de.businesslogics.banking.preferences.PreferenceConstants.EBICS_TRACES, de.businesslogics.banking.preferences.PreferenceConstants.STARTPAGE_BUTTONS) : Arrays.asList(de.businesslogics.banking.preferences.PreferenceConstants.ENCRYPT_DATA, de.businesslogics.banking.preferences.PreferenceConstants.SESSION_TIMEOUT, de.businesslogics.banking.preferences.PreferenceConstants.REFRESH_HTD, de.businesslogics.banking.preferences.PreferenceConstants.EBICS_TRACES, de.businesslogics.banking.preferences.PreferenceConstants.USE_2FA_FOR_SIGING, de.businesslogics.banking.preferences.PreferenceConstants.REQUIRE_2FA_FOR_LOGIN, de.businesslogics.banking.preferences.PreferenceConstants.STARTPAGE_BUTTONS);
            bankingPreferences.put(forType, Preferences.filterPreferences(bankingPreferencesForType, forType));
        }
        return bankingPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getBankingPrintPreferences(Type forType) {
        if (!bankingPrintPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> bankingPrintPreferencesForType = Branding.getBranding().alwaysPrintLogo() ? Arrays.asList(de.businesslogics.banking.preferences.PreferenceConstants.PRINT_PAGE_NUMBERS, de.businesslogics.banking.preferences.PreferenceConstants.PRINT_DATE_TIME, de.businesslogics.banking.preferences.PreferenceConstants.PRINT_USER_NAME, de.businesslogics.banking.preferences.PreferenceConstants.PRINT_AMOUNTS_OF_SALARY_PAYMENTS) : Arrays.asList(de.businesslogics.banking.preferences.PreferenceConstants.PRINT_PAGE_NUMBERS, de.businesslogics.banking.preferences.PreferenceConstants.PRINT_DATE_TIME, de.businesslogics.banking.preferences.PreferenceConstants.PRINT_USER_NAME, de.businesslogics.banking.preferences.PreferenceConstants.PRINT_LOGO, de.businesslogics.banking.preferences.PreferenceConstants.PRINT_AMOUNTS_OF_SALARY_PAYMENTS);
            bankingPrintPreferences.put(forType, Preferences.filterPreferences(bankingPrintPreferencesForType, forType));
        }
        return bankingPrintPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getPasswordRequirementsPreferences(Type forType) {
        if (!passwordRequirementsPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> passwordRequirementsPreferencesForType = Arrays.asList(de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_MIN_LENGTH, de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_LETTER, de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_LOWER, de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_UPPER, de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_NUMBER, de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_NEED_SPECIAL, de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_CHANGE_IN_DAYS, de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_CHECK_HISTORY, de.businesslogics.banking.preferences.PreferenceConstants.PASSWORD_USER_LOCKED);
            passwordRequirementsPreferences.put(forType, Preferences.filterPreferences(passwordRequirementsPreferencesForType, forType));
        }
        return passwordRequirementsPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getTransferPreferences(Type forType) {
        if (!transferPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> transferPreferencesForType = Arrays.asList(de.businesslogics.banking.transfer.gui.PreferenceConstants.DO_VOP_CHECK, de.businesslogics.banking.transfer.gui.PreferenceConstants.PTK_DELAY, de.businesslogics.banking.transfer.gui.PreferenceConstants.IMPORT_UNKNOWN_SENDITEMS, de.businesslogics.banking.transfer.gui.PreferenceConstants.CHECK_DOUBLE_TRANSMISSION, de.businesslogics.banking.transfer.gui.PreferenceConstants.PRESELECT_FROM_TO_FETCH, de.businesslogics.banking.transfer.gui.PreferenceConstants.ALLOW_CALLBACK_FOR_ALL_STATES);
            transferPreferences.put(forType, Preferences.filterPreferences(transferPreferencesForType, forType));
        }
        return transferPreferences.get((Object)forType);
    }

    public static Seq<Tuple2<String, String>> getDatabaseTypes(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)DBType.H2.name().toLowerCase(), (Object)messages.at("setup.database.type.h2", new Object[0])));
        result.add(Scala.Tuple((Object)DBType.MARIADB.name().toLowerCase(), (Object)messages.at("setup.database.type.mariadb", new Object[0])));
        result.add(Scala.Tuple((Object)DBType.MYSQL.name().toLowerCase(), (Object)messages.at("setup.database.type.mysql", new Object[0])));
        result.add(Scala.Tuple((Object)DBType.MSSQL.name().toLowerCase(), (Object)messages.at("setup.database.type.mssql", new Object[0])));
        result.add(Scala.Tuple((Object)DBType.ORACLE.name().toLowerCase(), (Object)messages.at("setup.database.type.oracle", new Object[0])));
        result.add(Scala.Tuple((Object)DBType.PSQL.name().toLowerCase(), (Object)messages.at("setup.database.type.postgres", new Object[0])));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getDatabaseURLTemplates() {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)("db_type_" + DBType.H2.name().toLowerCase()), (Object)"jdbc:h2:file:${workspace_loc}/bl;MVCC=true;IGNORECASE=true"));
        result.add(Scala.Tuple((Object)("db_type_" + DBType.HSQL.name().toLowerCase()), (Object)"jdbc:hsqldb:file:${workspace_loc}/bl.hsql"));
        result.add(Scala.Tuple((Object)("db_type_" + DBType.MARIADB.name().toLowerCase()), (Object)"jdbc:mariadb://<hostname>:3306/<dbname>"));
        result.add(Scala.Tuple((Object)("db_type_" + DBType.MYSQL.name().toLowerCase()), (Object)"jdbc:mysql://<hostname>:3306/<dbname>"));
        result.add(Scala.Tuple((Object)("db_type_" + DBType.MSSQL.name().toLowerCase()), (Object)"jdbc:sqlserver://<server_name>:1433;databaseName=<db_name>"));
        result.add(Scala.Tuple((Object)("db_type_" + DBType.PSQL.name().toLowerCase()), (Object)"jdbc:postgresql://<hostname>:5432/<db_name>"));
        result.add(Scala.Tuple((Object)("db_type_" + DBType.ORACLE.name().toLowerCase()), (Object)"jdbc:oracle:thin:@<server>:1521:<db_name>"));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getSelectablePreferencePages(User forUser, Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)Type.PERSONAL_SETTING.name(), (Object)messages.at("preferences.forMePersonally", new Object[0])));
        if (forUser.isAdmin()) {
            result.add(Scala.Tuple((Object)Type.ADMIN_SETTING.name(), (Object)messages.at("adminsettings.forEntireInstallation", new Object[0])));
        }
        List sortedManagedTenants = forUser.getManageableTenants();
        sortedManagedTenants.sort(Comparator.comparing(Tenant::getName));
        for (Tenant tenant : sortedManagedTenants) {
            result.add(Scala.Tuple((Object)tenant.getId().toString(), (Object)messages.at("tenantsettings.forTenant", new Object[]{tenant.getName()})));
        }
        return Scala.toSeq(result);
    }

    public static List<DatabasePreferenceConstant> getTransferSendReportPreferences(Type forType) {
        if (!transferSendReportPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> transferSendReportPreferencesForType = Arrays.asList(de.businesslogics.banking.transfer.gui.PreferenceConstants.SEND_REPORT_WITH_TICKET, de.businesslogics.banking.transfer.gui.PreferenceConstants.SEND_REPORT_WITH_PTK, de.businesslogics.banking.transfer.gui.PreferenceConstants.SEND_REPORT_WITH_DETAILS, de.businesslogics.banking.transfer.gui.PreferenceConstants.SEND_REPORT_DETAILS_WITH_PAGE_BREAK);
            transferSendReportPreferences.put(forType, Preferences.filterPreferences(transferSendReportPreferencesForType, forType));
        }
        return transferSendReportPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getTransferCleanupPreferences(Type forType) {
        if (!transferCleanupPreferences.containsKey((Object)forType)) {
            List<de.businesslogics.banking.transfer.gui.PreferenceConstants> transferCleanupPreferencesForType = List.of(de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_UP);
            transferCleanupPreferences.put(forType, Preferences.filterPreferences(transferCleanupPreferencesForType, forType));
        }
        return transferCleanupPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getTransferCleanupSentPreferences(Type forType) {
        if (!transferCleanupSentPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> transferCleanupSentPreferencesForType = Arrays.asList(de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_FILES, de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_AGE, de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_UNIT);
            transferCleanupSentPreferences.put(forType, Preferences.filterPreferences(transferCleanupSentPreferencesForType, forType));
        }
        return transferCleanupSentPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getTransferCleanupFetchedPreferences(Type forType) {
        if (!transferCleanupFetchedPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> transferCleanupFetchedPreferencesForType = Arrays.asList(de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_FILES, de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_AGE, de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_UNIT);
            transferCleanupFetchedPreferences.put(forType, Preferences.filterPreferences(transferCleanupFetchedPreferencesForType, forType));
        }
        return transferCleanupFetchedPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getTransferCleanupNotificationsPreferences(Type forType) {
        if (!transferCleanupNotificationsPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> transferCleanupNotificationsPreferencesForType = Arrays.asList(de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_FILES, de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_AGE, de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_UNIT);
            transferCleanupNotificationsPreferences.put(forType, Preferences.filterPreferences(transferCleanupNotificationsPreferencesForType, forType));
        }
        return transferCleanupNotificationsPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getTransferCleanupProtocolPreferences(Type forType) {
        if (!transferCleanupProtocolPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> transferCleanupProtocolPreferencesForType = Arrays.asList(de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL, de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL_AGE, de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL_UNIT);
            transferCleanupProtocolPreferences.put(forType, Preferences.filterPreferences(transferCleanupProtocolPreferencesForType, forType));
        }
        return transferCleanupProtocolPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getDesPreferences(Type forType) {
        if (!desPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> desPreferencesForType = Arrays.asList(de.businesslogics.banking.preferences.PreferenceConstants.DS_OVERVIEW_ON_STARTUP, de.businesslogics.banking.preferences.PreferenceConstants.DS_DISPLAY_DETAILS, de.businesslogics.banking.preferences.PreferenceConstants.DS_QUICK_SIGN, de.businesslogics.banking.preferences.PreferenceConstants.DS_PRINT_DETAILS_WITH_PAGE_BREAK);
            desPreferences.put(forType, Preferences.filterPreferences(desPreferencesForType, forType));
        }
        return desPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getDesCleanupPreferences(Type forType) {
        if (!desCleanupPreferences.containsKey((Object)forType)) {
            List<de.businesslogics.banking.preferences.PreferenceConstants> desCleanupPreferencesForType = List.of(de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_UP);
            desCleanupPreferences.put(forType, Preferences.filterPreferences(desCleanupPreferencesForType, forType));
        }
        return desCleanupPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getDesCleanupSignedPreferences(Type forType) {
        if (!desCleanupSignedPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> desCleanupPreferencesForType = Arrays.asList(de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED, de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED_AGE, de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED_UNIT);
            desCleanupSignedPreferences.put(forType, Preferences.filterPreferences(desCleanupPreferencesForType, forType));
        }
        return desCleanupSignedPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getDesCleanupRejectedPreferences(Type forType) {
        if (!desCleanupRejectedPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> desCleanupPreferencesForType = Arrays.asList(de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED, de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED_AGE, de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED_UNIT);
            desCleanupRejectedPreferences.put(forType, Preferences.filterPreferences(desCleanupPreferencesForType, forType));
        }
        return desCleanupRejectedPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getPaymentPreferences(Type forType) {
        if (!paymentPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> paymentPreferencesForType = Arrays.asList(de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION, de.businesslogics.banking.payments.core.PreferenceConstants.PERIODIC_PREFIX_IN_WORKING_DAYS, de.businesslogics.banking.payments.core.PreferenceConstants.ANOTHER_PAYMENT_DIALOG, de.businesslogics.banking.payments.core.PreferenceConstants.SEND_PAYMENTS_SEPARATELY, de.businesslogics.banking.payments.core.PreferenceConstants.CHECK_PERMISSION_FOR_PAYMENT_RECORDING, de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_ORIGINATOR_RECORDING, de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_UNKNOWN_ACCOUNTS, de.businesslogics.banking.payments.core.PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG, de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_RECIPIENT_RECORDING, de.businesslogics.banking.payments.core.PreferenceConstants.MAX_ENTRIES_FOR_RECIPIENT_POPUP, de.businesslogics.banking.payments.core.PreferenceConstants.OVERWRITE_RECIPIENT_DATA, de.businesslogics.banking.payments.core.PreferenceConstants.CHECK_LIMIT);
            paymentPreferences.put(forType, Preferences.filterPreferences(paymentPreferencesForType, forType));
        }
        return paymentPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getPaymentPrintPreferences(Type forType) {
        if (!paymentPrintPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> paymentPrintPreferencesForType = Arrays.asList(de.businesslogics.banking.payments.core.PreferenceConstants.NEW_PAGE_ON_PRINT, de.businesslogics.banking.payments.core.PreferenceConstants.GROUP_PAYMENTS_IN_OVERVIEW);
            paymentPrintPreferences.put(forType, Preferences.filterPreferences(paymentPrintPreferencesForType, forType));
        }
        return paymentPrintPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getPaymentDisplayPreferences(Type forType) {
        if (!paymentDisplayPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> paymentDisplayPreferencesForType = Arrays.asList(de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION, de.businesslogics.banking.payments.core.PreferenceConstants.SHOW_ALL_SIGNED_PAYMENTS, de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_RECIPIENTS_WITH_ACCOUNT_NUMBER, de.businesslogics.banking.payments.core.PreferenceConstants.SHOW_ACCOUNT_NAME_WITH_IBAN, de.businesslogics.banking.payments.core.PreferenceConstants.SHOW_RECIPIENT_WITH_ACCOUNT_NUMBER);
            paymentDisplayPreferences.put(forType, Preferences.filterPreferences(paymentDisplayPreferencesForType, forType));
        }
        return paymentDisplayPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getSepaPaymentPreferences(Type forType) {
        if (!sepaPaymentPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> sepaPaymentPreferencesForType = Arrays.asList(PreferenceConstants.ALLOW_INVALID_CREDITOR_ID, PreferenceConstants.DISPLAY_PAYMENT_CATEGORIES, PreferenceConstants.DISPLAY_PAYMENT_TYPES, PreferenceConstants.USE_MANDATE_ADMISTRATION, PreferenceConstants.DISPLAY_DIALOG_TO_DETERMINE_IBAN, PreferenceConstants.EXTENDED_FILE_CHECK, PreferenceConstants.SCL_CHECK, PreferenceConstants.ALLOW_FOREIGN_CURRENCIES, PreferenceConstants.SAVE_ACCOUNT_CURRENCY, PreferenceConstants.ALLOW_ONLY_ISO11649_CREDTIOR_REFERENCES, PreferenceConstants.ALLOW_UK_TRANSFER_WITHOUT_ORIGINATOR_ADDRESS, PreferenceConstants.ALLOW_CH_TRANSFER_WITHOUT_ORIGINATOR_ADDRESS, PreferenceConstants.ALLOW_CH_TRANSFER_WITHOUT_RECIPIENT_ADDRESS, PreferenceConstants.ALLOW_BOM);
            sepaPaymentPreferences.put(forType, Preferences.filterPreferences(sepaPaymentPreferencesForType, forType));
        }
        return sepaPaymentPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getCmPreferences(Type forType) {
        if (!cmPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> cmPreferencesForType = Arrays.asList(CmPreferenceConstants.DELETE_OLD_ADVICES, CmPreferenceConstants.SPLIT_MT940_PURPOSE_INTO_SEPA_TAGS, CmPreferenceConstants.MERGE_SHEETS_IN_STATEMENT_CONVERSION, CmPreferenceConstants.CONVERSION_USE_POSITIVE_DEBITS, CmPreferenceConstants.ENRICH_DTI_INFORMATIONS, CmPreferenceConstants.DTI_MT940_MATCHING_WITH_AMOUNT, CmPreferenceConstants.TOLERANCE_DTI_MT940_MATCHING, CmPreferenceConstants.HISTORY_TIME_RANGE, CmPreferenceConstants.AUTOMATIC_EXPORT_LANGUAGE, CmPreferenceConstants.ALLOW_ACCOUNT_RENAMING_FOR_NONADMINS);
            cmPreferences.put(forType, Preferences.filterPreferences(cmPreferencesForType, forType));
        }
        return cmPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getCmDisplayPreferences(Type forType) {
        if (!cmDisplayPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> cmDisplayPreferencesForType = Arrays.asList(CmPreferenceConstants.HIGHLIGHT_NEW_STATEMENTS, CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS, CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO, CmPreferenceConstants.DISPLAY_ONLY_SINGLE_BOOKINGS, CmPreferenceConstants.HIDE_AUTOMATIC_EXPORTS, CmPreferenceConstants.DISPLAY_FULL_PURPOSE, CmPreferenceConstants.SHOW_BALANCE_LIST_ON_START_PAGE);
            cmDisplayPreferences.put(forType, Preferences.filterPreferences(cmDisplayPreferencesForType, forType));
        }
        return cmDisplayPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getCmPrintPreferences(Type forType) {
        if (!cmPrintPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> cmPrintPreferencesForType = Arrays.asList(CmPreferenceConstants.PRINT_ACCOUNT_OVERVIEW_GROUPING, CmPreferenceConstants.PRINT_PAGE_INFORMATIONS, CmPreferenceConstants.REPEAT_STATEMENT_INFORMATIONS, CmPreferenceConstants.NEW_PAGE_ON_PRINT, CmPreferenceConstants.PRINT_ONE_BOOKING_PER_PAGE, CmPreferenceConstants.INSERT_SEPARATOR_BETWEEN_STATEMENTS, CmPreferenceConstants.PRINT_ALL_BOOKING_DETAILS, CmPreferenceConstants.PRINT_SINGLE_BOOKINGS, CmPreferenceConstants.PRINT_SEPARATELY_PER_BANK, CmPreferenceConstants.PRINT_TOTAL_AMOUNT_PER_STATEMENT, CmPreferenceConstants.PRINT_TOTAL_AMOUNT, CmPreferenceConstants.PRINT_ADDITIONAL_STATEMENT_INFO, CmPreferenceConstants.PRINT_BOOKING_SORTING, CmPreferenceConstants.PRINT_ACCOUNT_OWNER, CmPreferenceConstants.PRINT_ALTERNATING_BACKGROUND);
            cmPrintPreferences.put(forType, Preferences.filterPreferences(cmPrintPreferencesForType, forType));
        }
        return cmPrintPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getCmCleanupPreferences(Type forType) {
        if (!cmCleanupPreferences.containsKey((Object)forType)) {
            List<CmPreferenceConstants> cmCleanupPreferencesForType = List.of(CmPreferenceConstants.CLEAN_AUTOMATIC);
            cmCleanupPreferences.put(forType, Preferences.filterPreferences(cmCleanupPreferencesForType, forType));
        }
        return cmCleanupPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getCmCleanupStatementsPreferences(Type forType) {
        if (!cmCleanupStatementsPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> cmCleanupStatementsPreferencesForType = Arrays.asList(CmPreferenceConstants.CLEAN_STATEMENTS, CmPreferenceConstants.CLEAN_STATEMENTS_AGE, CmPreferenceConstants.CLEAN_STATEMENTS_UNIT);
            cmCleanupStatementsPreferences.put(forType, Preferences.filterPreferences(cmCleanupStatementsPreferencesForType, forType));
        }
        return cmCleanupStatementsPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getCmCleanupAdvicesPreferences(Type forType) {
        if (!cmCleanupAdvicesPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> cmCleanupAdvicesPreferencesForType = Arrays.asList(CmPreferenceConstants.CLEAN_ADVICES, CmPreferenceConstants.CLEAN_ADVICES_AGE, CmPreferenceConstants.CLEAN_ADVICES_UNIT);
            cmCleanupAdvicesPreferences.put(forType, Preferences.filterPreferences(cmCleanupAdvicesPreferencesForType, forType));
        }
        return cmCleanupAdvicesPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getCmCleanupDtiPreferences(Type forType) {
        if (!cmCleanupDtiPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> cmCleanupDtiPreferencesForType = Arrays.asList(CmPreferenceConstants.CLEAN_DTI_FILES, CmPreferenceConstants.CLEAN_DTI_FILES_AGE, CmPreferenceConstants.CLEAN_DTI_FILES_UNIT);
            cmCleanupDtiPreferences.put(forType, Preferences.filterPreferences(cmCleanupDtiPreferencesForType, forType));
        }
        return cmCleanupDtiPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getCmCleanupExportedFilesPreferences(Type forType) {
        if (!cmCleanupExportedFilesPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> cmCleanupExportedFilesPreferencesForType = Arrays.asList(CmPreferenceConstants.CLEAN_EXPORTED_FILES, CmPreferenceConstants.CLEAN_EXPORTED_FILES_AGE, CmPreferenceConstants.CLEAN_EXPORTED_FILES_UNIT);
            cmCleanupExportedFilesPreferences.put(forType, Preferences.filterPreferences(cmCleanupExportedFilesPreferencesForType, forType));
        }
        return cmCleanupExportedFilesPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getAwzelPreferences(Type forType) {
        if (!awzelPreferences.containsKey((Object)forType)) {
            List<DatabasePreferenceConstant> awzelPreferencesForType = Arrays.asList(de.businesslogics.banking.awzel.PreferenceConstants.COLLECT_FROM_STATEMENTS, de.businesslogics.banking.awzel.PreferenceConstants.COLLECT_FROM_PAYMENTS, de.businesslogics.banking.awzel.PreferenceConstants.REPORT_WITHOUT_CONVERSION, de.businesslogics.banking.awzel.PreferenceConstants.EXPORT_FORMAT);
            awzelPreferences.put(forType, Preferences.filterPreferences(awzelPreferencesForType, forType));
        }
        return awzelPreferences.get((Object)forType);
    }

    public static List<DatabasePreferenceConstant> getUpdatePreferences(Type forType) {
        if (!updatePreferences.containsKey((Object)forType)) {
            List<de.businesslogics.banking.update.PreferenceConstants> updatePreferencesForType = List.of(de.businesslogics.banking.update.PreferenceConstants.UPDATE_INFORMATION);
            updatePreferences.put(forType, Preferences.filterPreferences(updatePreferencesForType, forType));
        }
        return updatePreferences.get((Object)forType);
    }

    @Inject
    public Preferences(FormFactory formFactory, MessagesApi messagesApi, WSClient wsClient, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
        this.wsClient = wsClient;
    }

    public Result showPreferences(Http.Request request) {
        return this.show(request, Type.PERSONAL_SETTING, null);
    }

    public Result showAdminPreferences(Http.Request request, Integer tenantId) {
        boolean isAdminSettings;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        boolean bl = isAdminSettings = tenantId == null;
        if (isAdminSettings && !user.isAdmin()) {
            return Preferences.redirect((Call)routes.Application.index()).flashing("error", messages.at("settings.nopermission", new Object[0]));
        }
        if (!isAdminSettings && !user.isAdminOrTenantAdmin()) {
            return Preferences.redirect((Call)routes.Application.index()).flashing("error", messages.at("settings.nopermission", new Object[0]));
        }
        return this.show(request, isAdminSettings ? Type.ADMIN_SETTING : Type.TENANT_SETTING, tenantId);
    }

    private Result show(Http.Request request, Type preferenceType, Integer tenantId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        HashMap<String, Object> formDataMap = new HashMap<String, Object>();
        this.loadPreferences(formDataMap, user, tenantId == null ? null : Tenant.findById((int)tenantId), preferenceType);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        this.loadDatabaseSettings(request, formDataMap, user, flashMap);
        DynamicForm form = this.formFactory.form().fill(formDataMap);
        if (Type.ADMIN_SETTING == preferenceType) {
            return Preferences.ok((Content)adminsettings.render((Form<DynamicForm.Dynamic>)form, user, null, false, request, this.messagesApi.preferred((Http.RequestHeader)request))).flashing(flashMap);
        }
        if (Type.TENANT_SETTING == preferenceType) {
            return Preferences.ok((Content)adminsettings.render((Form<DynamicForm.Dynamic>)form, user, tenantId, false, request, this.messagesApi.preferred((Http.RequestHeader)request))).flashing(flashMap);
        }
        Form passwordForm = this.formFactory.form(ChangePasswordForm.class);
        return Preferences.ok((Content)preferences.render((Form<DynamicForm.Dynamic>)form, (Form<ChangePasswordForm>)passwordForm, user, false, WebAuthnData.build(user), request, this.messagesApi.preferred((Http.RequestHeader)request))).flashing(flashMap);
    }

    public Result loadDefaultPreferences(Http.Request request) {
        return this.loadDefaults(request, Type.PERSONAL_SETTING, null);
    }

    public Result loadDefaultAdminPreferences(Http.Request request, Integer tenantId) {
        Type type;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Type type2 = type = tenantId == null ? Type.ADMIN_SETTING : Type.TENANT_SETTING;
        if (type == Type.ADMIN_SETTING && !user.isAdmin() || type == Type.TENANT_SETTING && !user.isAdminOrTenantAdmin()) {
            return Preferences.redirect((Call)routes.Application.index()).flashing("error", messages.at("settings.nopermission", new Object[0]));
        }
        return this.loadDefaults(request, type, tenantId);
    }

    private Result loadDefaults(Http.Request request, Type preferenceType, Integer tenantId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Tenant tenant = tenantId != null ? Tenant.findById((int)tenantId) : null;
        HashMap<Category, List<LoadDefaultPreferencesForm.PreferenceStatus>> modifiedPrefsPerCategory = new HashMap<Category, List<LoadDefaultPreferencesForm.PreferenceStatus>>();
        Map<Preference.ApplicationId, Map<Category, List<DatabasePreferenceConstant>>> allPrefs = Preferences.getAllPreferences(preferenceType);
        for (Preference.ApplicationId appId : allPrefs.keySet()) {
            Map<Category, List<DatabasePreferenceConstant>> prefsForAppId = allPrefs.get(appId);
            for (Category category : prefsForAppId.keySet()) {
                this.loadDefaultsInternal(preferenceType, appId, category, tenant, user, modifiedPrefsPerCategory);
            }
        }
        List<Category> categoriesSorted = modifiedPrefsPerCategory.keySet().stream().sorted(Comparator.comparingInt(Enum::ordinal)).toList();
        if (modifiedPrefsPerCategory.isEmpty()) {
            play.api.mvc.Call redirectTo = preferenceType == Type.ADMIN_SETTING ? routes.Preferences.showAdminPreferences(null) : (preferenceType == Type.PERSONAL_SETTING ? routes.Preferences.showPreferences() : routes.Preferences.showAdminPreferences(tenantId));
            return Preferences.redirect((Call)redirectTo).flashing("info", messages.at("preferences.loadDefaults.alreadyDefault", new Object[0]));
        }
        LoadDefaultPreferencesForm formValues = new LoadDefaultPreferencesForm();
        formValues.tenantId = tenantId;
        formValues.type = preferenceType;
        Form form = this.formFactory.form(LoadDefaultPreferencesForm.class).fill((Object)formValues);
        return Preferences.ok((Content)loadDefaultPreferences.render(preferenceType, tenantId, categoriesSorted, modifiedPrefsPerCategory, (Form<LoadDefaultPreferencesForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private void loadDefaultsInternal(Type preferenceType, Preference.ApplicationId applicationId, Category category, Tenant tenant, User user, Map<Category, List<LoadDefaultPreferencesForm.PreferenceStatus>> modifiedPrefsPerCategory) {
        List<DatabasePreferenceConstant> prefsInCategory = Preferences.getPreferences(preferenceType, category).stream().filter(p -> Preferences.showPreferenceForUser(user, p)).toList();
        if (!prefsInCategory.isEmpty()) {
            DatabasePreferenceStore store = new DatabasePreferenceStore(applicationId, user, tenant);
            ArrayList<LoadDefaultPreferencesForm.PreferenceStatus> preferenceStatuses = new ArrayList<LoadDefaultPreferencesForm.PreferenceStatus>();
            for (DatabasePreferenceConstant dbpc : prefsInCategory) {
                boolean currentDiffersFromDefault;
                String currentValue = store.getString(dbpc);
                String defaultValue = dbpc.getDefaultValue();
                if (preferenceType == Type.TENANT_SETTING) {
                    DatabasePreferenceStore globalStore = new DatabasePreferenceStore(applicationId, user, null);
                    String globalValue = globalStore.getString(dbpc);
                    currentDiffersFromDefault = globalValue != null ? !globalValue.equals(currentValue) : !defaultValue.equals(currentValue);
                } else {
                    boolean bl = currentDiffersFromDefault = !defaultValue.equals(currentValue);
                }
                if (!currentDiffersFromDefault) continue;
                preferenceStatuses.add(new LoadDefaultPreferencesForm.PreferenceStatus(dbpc, currentValue, defaultValue));
            }
            if (!preferenceStatuses.isEmpty()) {
                modifiedPrefsPerCategory.put(category, preferenceStatuses);
            }
        }
    }

    public Result storeDefaultPreferences(Http.Request request) {
        String flashMessage;
        String flashType;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form form = this.formFactory.form(LoadDefaultPreferencesForm.class).bindFromRequest(request, new String[0]);
        Type type = ((LoadDefaultPreferencesForm)form.get()).type;
        Integer tenantId = ((LoadDefaultPreferencesForm)form.get()).tenantId;
        Tenant tenant = null;
        String tenantName = "";
        if (tenantId != null) {
            tenant = Tenant.findById((int)tenantId);
            tenantName = tenant.getName();
        }
        int nReset = 0;
        Set prefsToReset = ((LoadDefaultPreferencesForm)form.get()).selectedPreferences.keySet().stream().filter(pref -> ((LoadDefaultPreferencesForm)form.get()).selectedPreferences.get(pref)).collect(Collectors.toSet());
        Map<Preference.ApplicationId, Map<Category, List<DatabasePreferenceConstant>>> allPrefs = Preferences.getAllPreferences(type);
        for (Preference.ApplicationId appId : allPrefs.keySet()) {
            for (Category category : allPrefs.get(appId).keySet()) {
                DatabasePreferenceStore store = new DatabasePreferenceStore(appId, user, tenant);
                for (DatabasePreferenceConstant dbc : allPrefs.get(appId).get((Object)category)) {
                    boolean changed;
                    if (!Preferences.showPreferenceForUser(user, dbc) || !prefsToReset.contains(dbc.toString()) || !(changed = store.resetPreference(dbc))) continue;
                    ++nReset;
                }
            }
        }
        String string = flashType = nReset == 0 ? "info" : "success";
        if (type == Type.PERSONAL_SETTING) {
            flashMessage = messages.at("preferences.loadDefaults.resetPreferences", new Object[]{nReset});
            return Preferences.redirect((Call)routes.Preferences.showPreferences()).flashing(flashType, flashMessage);
        }
        if (type == Type.TENANT_SETTING) {
            flashMessage = messages.at("preferences.loadDefaults.resetTenantSettings", new Object[]{nReset, tenantName});
            return Preferences.redirect((Call)routes.Preferences.showAdminPreferences(tenantId)).flashing(flashType, flashMessage);
        }
        flashMessage = messages.at("preferences.loadDefaults.resetAdminSettings", new Object[]{nReset});
        return Preferences.redirect((Call)routes.Preferences.showAdminPreferences(null)).flashing(flashType, flashMessage);
    }

    public CompletionStage<Result> updatePreferences(Http.Request request) {
        return this.update(request, Type.PERSONAL_SETTING, null);
    }

    public CompletionStage<Result> updateAdminPreferences(Http.Request request, Integer tenantId) {
        Type type;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Type type2 = type = tenantId == null ? Type.ADMIN_SETTING : Type.TENANT_SETTING;
        if (type == Type.ADMIN_SETTING && !user.isAdmin() || type == Type.TENANT_SETTING && !user.isAdminOrTenantAdmin()) {
            return CompletableFuture.supplyAsync(() -> Preferences.redirect((Call)routes.Application.index()).flashing("error", messages.at("settings.nopermission", new Object[0])));
        }
        return this.update(request, type, tenantId);
    }

    private CompletionStage<Result> update(Http.Request request, Type preferenceType, Integer tenantId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        DynamicForm form = this.formFactory.form().bindFromRequest(request, new String[0]);
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            long compare;
            long newValue;
            Map map;
            Map prefs;
            String newValue2;
            HashMap<Preference.ApplicationId, Map> modifiedPreferences = new HashMap<Preference.ApplicationId, Map>();
            DynamicForm preferencesForm = form;
            Tenant tenant = tenantId == null ? null : Tenant.findById((int)tenantId);
            for (Preference.ApplicationId applicationId : Preferences.getAllPreferences(preferenceType).keySet()) {
                DatabasePreferenceStore store = new DatabasePreferenceStore(applicationId, user, tenant);
                for (List<DatabasePreferenceConstant> prefsInCategory : Preferences.getAllPreferences(preferenceType).get(applicationId).values()) {
                    for (DatabasePreferenceConstant pref : prefsInCategory) {
                        boolean modified;
                        String oldValue;
                        if (!Preferences.showPreferenceForUser(user, pref)) continue;
                        String formField = (String)preferencesForm.rawData().get(Preferences.getFormId(applicationId, pref));
                        try {
                            if (pref.getType() == DatabasePreferenceConstant.DataType.BOOLEAN) {
                                boolean b = Boolean.parseBoolean(formField);
                                oldValue = String.valueOf(store.getBoolean(pref));
                                newValue2 = String.valueOf(b);
                                modified = b != store.getBoolean(pref);
                            } else if (pref.getType() == DatabasePreferenceConstant.DataType.INTEGER) {
                                int i = formField != null && !formField.isEmpty() ? Integer.parseInt(formField) : 0;
                                oldValue = String.valueOf(store.getInt(pref));
                                newValue2 = String.valueOf(i);
                                modified = i != store.getInt(pref);
                            } else if (pref.getType() == DatabasePreferenceConstant.DataType.LONG) {
                                long l = formField != null && !formField.isEmpty() ? Long.parseLong(formField) : 0L;
                                oldValue = String.valueOf(store.getLong(pref));
                                newValue2 = String.valueOf(l);
                                modified = l != store.getLong(pref);
                            } else if (pref.getType() == DatabasePreferenceConstant.DataType.DOUBLE || pref.getType() == DatabasePreferenceConstant.DataType.FLOAT) {
                                BigDecimal d;
                                BigDecimal bigDecimal = d = formField == null ? BigDecimal.ZERO : PaymentUtils.parseAmount((String)formField, (Locale)messages.lang().locale());
                                if (pref.getType() == DatabasePreferenceConstant.DataType.DOUBLE) {
                                    oldValue = String.valueOf(store.getDouble(pref));
                                    newValue2 = String.valueOf(d.doubleValue());
                                    modified = d.doubleValue() != store.getDouble(pref);
                                } else {
                                    oldValue = String.valueOf(store.getFloat(pref));
                                    newValue2 = String.valueOf(d.floatValue());
                                    modified = d.floatValue() != store.getFloat(pref);
                                }
                            } else if (pref.getType() == DatabasePreferenceConstant.DataType.BOOLEAN_GROUP) {
                                String[] uploaded = (String[])request.body().asFormUrlEncoded().get(Preferences.getFormId(applicationId, pref));
                                int newInt = 0;
                                if (uploaded != null) {
                                    for (String s : uploaded) {
                                        newInt |= Integer.parseInt(s);
                                    }
                                }
                                oldValue = String.valueOf(store.getInt(pref));
                                newValue2 = String.valueOf(newInt);
                                modified = newInt != store.getInt(pref);
                            } else if (formField == null || formField.isEmpty()) {
                                oldValue = store.getString(pref);
                                newValue2 = null;
                                modified = store.getString(pref) != null;
                            } else {
                                oldValue = store.getString(pref);
                                newValue2 = formField;
                                modified = !formField.equals(store.getString(pref));
                            }
                        }
                        catch (Exception e) {
                            BLLoggerPlay.warning("Failed to read parameter " + Preferences.getFormId(applicationId, pref) + " from preferences form!", e);
                            preferencesForm = preferencesForm.withError(Preferences.getFormId(applicationId, pref), messages.at("error.invalid", new Object[0]));
                            continue;
                        }
                        if (!modified) continue;
                        prefs = modifiedPreferences.computeIfAbsent(applicationId, k -> new HashMap());
                        prefs.put(pref, new String[]{oldValue, newValue2});
                    }
                }
            }
            if (modifiedPreferences.containsKey(Preference.ApplicationId.BANKING) && (map = (Map)modifiedPreferences.get(Preference.ApplicationId.BANKING)).containsKey(de.businesslogics.banking.preferences.PreferenceConstants.SESSION_TIMEOUT) && (newValue = Long.valueOf(((String[])map.get(de.businesslogics.banking.preferences.PreferenceConstants.SESSION_TIMEOUT))[1]).longValue()) > (compare = Setup.SESSION_TIMEOUT / 1000L / 60L)) {
                preferencesForm = preferencesForm.withError("banking_sessionTimeout", messages.at("preferences.sessionTimeout.toolarge", new Object[]{compare}));
            }
            if (preferencesForm.hasErrors()) {
                if (Type.ADMIN_SETTING == preferenceType) {
                    return Preferences.ok((Content)adminsettings.render((Form<DynamicForm.Dynamic>)preferencesForm, user, null, false, request, messages));
                }
                if (Type.TENANT_SETTING == preferenceType) {
                    return Preferences.ok((Content)adminsettings.render((Form<DynamicForm.Dynamic>)preferencesForm, user, tenantId, false, request, messages));
                }
                Form changePasswordForm = this.formFactory.form(ChangePasswordForm.class).bindFromRequest(request, new String[0]);
                return Preferences.ok((Content)preferences.render((Form<DynamicForm.Dynamic>)preferencesForm, (Form<ChangePasswordForm>)changePasswordForm, user, false, WebAuthnData.build(user), request, messages));
            }
            HashMap<String, String> flashMap = new HashMap<String, String>();
            try (Transaction t = DB.beginTransaction();){
                int counter = 0;
                for (Preference.ApplicationId applicationId : modifiedPreferences.keySet()) {
                    DatabasePreferenceStore store = new DatabasePreferenceStore(applicationId, user, tenant){

                        protected void preferenceChanged(DatabasePreferenceConstant key, String oldValue, String newValue) {
                            PreferenceChangedHandler.Finder.reportChangedPreference(this.applicationId, key, this.user, this.tenant, oldValue, newValue, messages, Preferences.this.wsClient);
                        }
                    };
                    prefs = (Map)modifiedPreferences.get(applicationId);
                    for (DatabasePreferenceConstant pref : prefs.keySet()) {
                        newValue2 = ((String[])prefs.get(pref))[1];
                        store.setValue(pref, newValue2);
                        ++counter;
                    }
                }
                t.commit();
                if (counter > 0) {
                    AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
                    logger.logPreferencesModified(user, counter);
                    for (Preference.ApplicationId applicationId : modifiedPreferences.keySet()) {
                        prefs = (Map)modifiedPreferences.get(applicationId);
                        for (DatabasePreferenceConstant pref : prefs.keySet()) {
                            String oldValue = ((String[])prefs.get(pref))[0];
                            String newValue3 = ((String[])prefs.get(pref))[1];
                            logger.logPreferenceModifiedDetail(user, tenant, pref, oldValue, newValue3);
                        }
                    }
                }
                flashMap.put("success", messages.at("preferences.updated", new Object[]{counter}));
            }
            play.api.mvc.Call redirectTo = Type.ADMIN_SETTING == preferenceType ? routes.Preferences.showAdminPreferences(null) : (Type.TENANT_SETTING == preferenceType ? routes.Preferences.showAdminPreferences(tenantId) : routes.Preferences.showPreferences());
            return Preferences.redirect((Call)redirectTo).flashing(flashMap);
        }, this.executionContext.current());
    }

    public Result changePassword(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form<ChangePasswordForm> passwordForm = this.formFactory.form(ChangePasswordForm.class).bindFromRequest(request, new String[0]);
        if (!passwordForm.hasErrors()) {
            passwordForm = ((ChangePasswordForm)passwordForm.get()).validate(passwordForm, user, true, messages.lang().toLocale());
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (passwordForm.hasErrors()) {
            HashMap<String, Object> preferencesFormDataMap = new HashMap<String, Object>();
            this.loadPreferences(preferencesFormDataMap, user, null, Type.PERSONAL_SETTING);
            this.loadDatabaseSettings(request, preferencesFormDataMap, user, flashMap);
            DynamicForm preferencesForm = this.formFactory.form().fill(preferencesFormDataMap);
            return Preferences.ok((Content)preferences.render((Form<DynamicForm.Dynamic>)preferencesForm, passwordForm, user, false, WebAuthnData.build(user), request, messages)).flashing(flashMap);
        }
        if (((ChangePasswordForm)passwordForm.get()).update(user)) {
            flashMap.put("success", messages.at("preferences.changepassword.done", new Object[0]));
        } else {
            flashMap.put("error", messages.at("preferences.changepassword.failed", new Object[0]));
        }
        return Preferences.redirect((Call)routes.Preferences.showPreferences()).flashing(flashMap);
    }

    public CompletionStage<Result> cleanupTransfers(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            TransferCleanUp cleanUp = new TransferCleanUp();
            cleanUp.doCleanup(new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, null), (IProgressMonitorWrapper)ProgressMonitorDummy.getInstance());
            BLLoggerPlay.info("Transfer data cleanup was executed.");
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logPreferencesCleanedUpTransfers(user);
            return Preferences.ok();
        }, this.executionContext.current());
    }

    public CompletionStage<Result> cleanupDes(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            DsCleanUp cleanUp = new DsCleanUp();
            cleanUp.doCleanup(new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null), (IProgressMonitorWrapper)ProgressMonitorDummy.getInstance());
            BLLoggerPlay.info("Des data cleanup was executed.");
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logPreferencesCleanedUpDes(user);
            return Preferences.ok();
        }, this.executionContext.current());
    }

    public CompletionStage<Result> cleanupCm(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            CmCleanUp cleanUp = new CmCleanUp();
            cleanUp.doCleanup(new DatabasePreferenceStore(Preference.ApplicationId.CM, null), (IProgressMonitorWrapper)ProgressMonitorDummy.getInstance());
            BLLoggerPlay.info("Cm data cleanup was executed.");
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logPreferencesCleanedUpCm(user);
            return Preferences.ok();
        }, this.executionContext.current());
    }

    public Result unlockAllPayments(Http.Request request) {
        int count;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        play.api.mvc.Call redirectTo = routes.Preferences.showPreferences();
        if (user.isAdmin()) {
            count = OpenPayment.unlockPayments();
        } else if (user.isTenantAdmin()) {
            banksOfUser = BankSettings.findBanksForTenants((List)user.getManagedTenants()).stream().map(BankSettings::getBankId).collect(Collectors.toList());
            count = OpenPayment.unlockPaymentsForBanks(banksOfUser);
        } else {
            banksOfUser = BankSettings.findBanksForUser((User)user).stream().map(BankSettings::getBankId).collect(Collectors.toList());
            count = OpenPayment.unlockPaymentsForBanks(banksOfUser);
        }
        String flashKey = count == 0 ? "info" : "success";
        return Preferences.redirect((Call)redirectTo).flashing(flashKey, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.unlockedPayments", (Object[])new Object[]{count}));
    }

    private void loadPreferences(Map<String, Object> dataMap, User user, Tenant tenant, Type forType) {
        dataMap.put("settingsPage", forType == Type.TENANT_SETTING ? tenant.getId().toString() : forType.name());
        for (Preference.ApplicationId applicationId : Preferences.getAllPreferences(forType).keySet()) {
            DatabasePreferenceStore store = new DatabasePreferenceStore(applicationId, user, tenant);
            for (List<DatabasePreferenceConstant> prefsInCategory : Preferences.getAllPreferences(forType).get(applicationId).values()) {
                for (DatabasePreferenceConstant pref : prefsInCategory) {
                    String value;
                    if (!Preferences.showPreferenceForUser(user, pref) || (value = store.getString(pref)) == null) continue;
                    dataMap.put(Preferences.getFormId(applicationId, pref), value);
                }
            }
        }
    }

    private void loadDatabaseSettings(Http.Request request, Map<String, Object> dataMap, User user, Map<String, String> flashMap) {
        if (!user.isAdmin()) {
            return;
        }
        try {
            JdbcSettings settings = new JdbcSettings(Util.WORKSPACEDIR);
            dataMap.put("db_type", settings.getDbType().name().toLowerCase());
            dataMap.put("db_url", settings.getJdbcUrl());
            dataMap.put("db_user", settings.getDbUser());
            ApplicationInfo appInfo = (ApplicationInfo)DB.find(ApplicationInfo.class).where().eq("prop_name", (Object)"db_layout").setMaxRows(1).findOne();
            String version = appInfo == null ? "" : appInfo.getPropValue();
            dataMap.put("db_version", version);
        }
        catch (IOException e) {
            Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
            BLLoggerPlay.error("Failed to load JDBC settings!", e);
            flashMap.put("HTMLerror", messages.at("preferences.error.dbsettings", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
    }

    public static enum Category {
        GENERAL,
        GENERAL_PRINT,
        GENERAL_PASSWORD,
        GENERAL_UPDATE,
        TRANSFER,
        TRANSFER_SEND_REPORT,
        TRANSFER_CLEANUP,
        TRANSFER_CLEANUP_SENT,
        TRANSFER_CLEANUP_FETCHED,
        TRANSFER_CLEANUP_NOTIFICATIONS,
        TRANSFER_CLEANUP_PROTOCOL,
        EDS,
        EDS_CLEANUP,
        EDS_CLEANUP_SIGNED,
        EDS_CLEANUP_REJECTED,
        PAYMENTS,
        PAYMENTS_SEPA,
        PAYMENTS_DISPLAY,
        PAYMENTS_PRINT,
        CM,
        CM_DISPLAY,
        CM_PRINT,
        CM_CLEANUP,
        CM_CLEANUP_STATEMENTS,
        CM_CLEANUP_ADVICES,
        CM_CLEANUP_DTI,
        CM_CLEANUP_EXPORTED_FILES,
        AWV;


        public String getLocalizedName(Messages messages) {
            Object result = this.name().startsWith("TRANSFER") ? messages.at("preferences.tabtransfer", new Object[0]) : (this.name().startsWith("EDS") ? messages.at("bankdetails.des", new Object[0]) : (this.name().startsWith("PAYMENTS") ? messages.at("preferences.tabpayments", new Object[0]) : (this.name().startsWith("CM") ? messages.at("preferences.tabcm", new Object[0]) : (this.name().startsWith("AWV") ? messages.at("awv", new Object[0]) : BankingApiMessages.getString((String)"GeneralMessages.general", (Object[])new Object[]{messages.lang().locale()})))));
            if (this.name().contains("CLEANUP")) {
                result = (String)result + " - " + messages.at("preferences.cleanup", new Object[0]);
            } else if (this.name().contains("DISPLAY")) {
                result = (String)result + " - " + messages.at("preferences.displaysettings", new Object[0]);
            } else if (this.name().contains("PRINT")) {
                result = (String)result + " - " + messages.at("preferences.printsettings", new Object[0]);
            }
            if (this == GENERAL_PASSWORD) {
                result = (String)result + " - " + messages.at("preferences.passwordrequirements", new Object[0]);
            } else if (this == GENERAL_UPDATE) {
                result = (String)result + " - " + messages.at("preferences.loadDefaults.updatePrefs", new Object[0]);
            } else if (this == TRANSFER_SEND_REPORT) {
                result = (String)result + " - " + messages.at("preferences.sendreport", new Object[0]);
            } else if (this == TRANSFER_CLEANUP_SENT) {
                result = (String)result + " - " + de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_SEND_FILES.getLabel(messages.lang().locale());
            } else if (this == TRANSFER_CLEANUP_FETCHED) {
                result = (String)result + " - " + de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_FETCH_FILES.getLabel(messages.lang().locale());
            } else if (this == TRANSFER_CLEANUP_NOTIFICATIONS) {
                result = (String)result + " - " + de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_NOTIFICATION_FILES.getLabel(messages.lang().locale());
            } else if (this == TRANSFER_CLEANUP_PROTOCOL) {
                result = (String)result + " - " + de.businesslogics.banking.transfer.gui.PreferenceConstants.CLEAN_PROTOCOL.getLabel(messages.lang().locale());
            } else if (this == EDS_CLEANUP_SIGNED) {
                result = (String)result + " - " + de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_SIGNED.getLabel(messages.lang().locale());
            } else if (this == EDS_CLEANUP_REJECTED) {
                result = (String)result + " - " + de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_REJECTED.getLabel(messages.lang().locale());
            } else if (this == CM_CLEANUP_STATEMENTS) {
                result = (String)result + " - " + CmPreferenceConstants.CLEAN_STATEMENTS.getLabel(messages.lang().locale());
            } else if (this == CM_CLEANUP_ADVICES) {
                result = (String)result + " - " + CmPreferenceConstants.CLEAN_ADVICES.getLabel(messages.lang().locale());
            } else if (this == CM_CLEANUP_DTI) {
                result = (String)result + " - " + CmPreferenceConstants.CLEAN_DTI_FILES.getLabel(messages.lang().locale());
            } else if (this == CM_CLEANUP_EXPORTED_FILES) {
                result = (String)result + " - " + CmPreferenceConstants.CLEAN_EXPORTED_FILES.getLabel(messages.lang().locale());
            } else if (this == PAYMENTS_SEPA) {
                result = (String)result + " - " + messages.at("bankdetails.sepaPayments", new Object[0]);
            }
            return result;
        }
    }

    public static enum Type {
        PERSONAL_SETTING,
        ADMIN_SETTING,
        TENANT_SETTING;

    }
}

