/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.Payments;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.DateFormatter;
import controllers.util.GeneralUtils;
import controllers.util.PeriodicPaymentExecutionRunnerImpl;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PeriodicPaymentFileExport;
import de.businesslogics.banking.payments.api.PeriodicPaymentTableCsvExport;
import de.businesslogics.banking.payments.api.PeriodicPaymentsTableOverviewPrinter;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.ScheduleHandler;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.pdf.PDFException;
import io.ebean.Query;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AustrianForeignPaymentForm;
import models.DeleteFolderForm;
import models.DtazvPaymentForm;
import models.GenerateOpenPaymentFromTemplateForm;
import models.MovePaymentToFolderForm;
import models.Mt101PaymentForm;
import models.PaymentFilterForm;
import models.PaymentFolderForm;
import models.PaymentForm;
import models.PeriodicParametersForm;
import models.PostbarPaymentForm;
import models.SepaPaymentForm;
import models.SimpleSelectionForm;
import models.SimpleTextForm;
import models.TaxOfficePaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.payments.editpayment;
import views.html.payments.newpayment;
import views.html.payments.periodicpayments;

@Security.Authenticated(value=AuthenticatorFor.Payment.class)
public final class PeriodicPayments
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static Query<PeriodicPayment> getQueryCheckPermission(User user) {
        return PeriodicPayments.getQueryCheckPermission(user, null);
    }

    public static Query<PeriodicPayment> getQueryCheckPermission(User user, PaymentFolder paymentFolder) {
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        return PeriodicPayment.getDefaultQuery((User)user, (PaymentFolder)paymentFolder, (boolean)preferences2.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION), (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
    }

    public static String loadJsParameters(List<PeriodicPayment> payments, Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("selectInfoMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.totalAmountInfo", (Object[])new Object[]{999, "AMOUNT"}));
        ObjectNode node = resultJson.putObject("generateNowMessage");
        node.put("single", messages.at("periodicpayments.generatenow", new Object[]{1}));
        node.put("multiple", messages.at("periodicpayments.generatenow", new Object[]{999}));
        node = resultJson.putObject("reallyDeleteMessage");
        node.put("single", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.confirmDeletePayments", (Object[])new Object[]{1}));
        node.put("multiple", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.confirmDeletePayments", (Object[])new Object[]{999}));
        if (payments != null && !payments.isEmpty()) {
            ArrayNode paymentsNode = resultJson.putArray("paymentInfos");
            for (PeriodicPayment payment : payments) {
                node = paymentsNode.addObject();
                node.put("id", payment.getId());
                node.put("amount", payment.getAmount());
                node.put("currency", payment.getAmountCurrency());
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public PeriodicPayments(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result filterForm(Http.Request request, boolean filterActive) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        if (!filterActive) {
            filter.setPeriodicPaymentsFilterActive(Boolean.valueOf(false));
            filter.save();
        } else {
            filter.setPeriodicPaymentsFilterActive(Boolean.valueOf(true));
            Form form = this.formFactory.form(PaymentFilterForm.class).bindFromRequest(request, new String[0]);
            if (form.hasErrors()) {
                return this.index(request, (Form<PaymentFilterForm>)form, false);
            }
            PaymentFilterForm data = (PaymentFilterForm)form.get();
            data.saveDataPeriodic(filter);
        }
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false));
    }

    public Result index(Http.Request request, boolean loadSelection) {
        return this.index(request, null, loadSelection);
    }

    public Result index(Http.Request request, Form<PaymentFilterForm> paymentFilterForm, boolean loadSelection) {
        List list;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_PERIODIC);
        int folderId = -1;
        try {
            folderId = Integer.parseInt(sorting.getProperty("folder", "-1"));
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to read parameters from sorting properties for open payments table!", e);
        }
        PaymentFolder paymentFolder = Payments.getFolder(user, folderId);
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        if (paymentFilterForm == null) {
            PaymentFilterForm data = new PaymentFilterForm(filter);
            paymentFilterForm = this.formFactory.form(PaymentFilterForm.class).fill((Object)data);
        }
        if (!filter.isPeriodicPaymentsFilterActive()) {
            filter = null;
        }
        String selection = null;
        if (loadSelection) {
            selection = sorting.getProperty("selection");
        }
        sorting.setProperty("selection", null);
        Query<PeriodicPayment> query = this.getDefaultQuery(user, sorting.getSorting(), paymentFolder, filter);
        sorting.computeForQuery(query);
        MovePaymentToFolderForm moveToFolderFormValues = new MovePaymentToFolderForm();
        moveToFolderFormValues.paymentContextType = PaymentContextType.PERIODIC_PAYMENT;
        Form moveToFolderForm = this.formFactory.form(MovePaymentToFolderForm.class).fill((Object)moveToFolderFormValues);
        Form newFolderNameForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        if (paymentFolder != null && !paymentFolder.equals(PaymentFolder.NULL_FOLDER)) {
            newFolderNameForm = newFolderNameForm.fill((Object)new PaymentFolderForm(null, paymentFolder.getTenant().getId()));
            changeFolderNameForm = changeFolderNameForm.fill((Object)new SimpleTextForm(paymentFolder.getName()));
        }
        DeleteFolderForm deleteFolderFormValues = new DeleteFolderForm();
        deleteFolderFormValues.policyForOpenPayments = "dontdelete";
        deleteFolderFormValues.policyForPeriodicPayments = "dontdelete";
        deleteFolderFormValues.policyForPaymentTemplates = "dontdelete";
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class).fill((Object)deleteFolderFormValues);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.PMT_PERIODIC, (Call)routes.PeriodicPayments.index(loadSelection));
        }
        return PeriodicPayments.ok((Content)periodicpayments.render(list, sorting, selection, paymentFolder, (Form<PaymentFilterForm>)paymentFilterForm, filter, (Form<MovePaymentToFolderForm>)moveToFolderForm, (Form<PaymentFolderForm>)newFolderNameForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<DeleteFolderForm>)deleteFolderForm, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result createNewFolder(Http.Request request) {
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing(Payments.createNewFolder(request, this.formFactory, this.messagesApi));
    }

    public Result changeFolderName(Http.Request request, Integer folderId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFolder paymentFolder = PaymentFolder.findById((Integer)folderId, (User)user);
        if (paymentFolder == null) {
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("openpayments.folder.foldernotfound", new Object[0]));
        }
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing(Payments.renameFolder(request, paymentFolder, this.formFactory, this.messagesApi));
    }

    public Result moveToFolder(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Map<String, String> flashMap = Payments.moveToFolder(request, this.formFactory, this.messagesApi);
        String paymentIds = flashMap.get("paymentIds");
        flashMap.remove("paymentIds");
        if (!Utils.hasSuccessFlash(flashMap)) {
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_PERIODIC);
            sorting.setProperty("selection", paymentIds);
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(true)).flashing(flashMap);
        }
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing(flashMap);
    }

    public Result deleteFolder(Http.Request request, Integer folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_PERIODIC);
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing(Payments.deleteFolder(request, this.formFactory, this.messagesApi, folderId, sorting));
    }

    public Result indexWithPage(Http.Request request, int pageNumber, int pageSize, int folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sortingHandler = new SortingHandler(user, Sorting.Table.PMT_PERIODIC);
        sortingHandler.updatePage(pageNumber, pageSize);
        sortingHandler.setProperty("folder", String.valueOf(folderId));
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false));
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.PMT_PERIODIC).updateSort(sort, ascending);
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false));
    }

    public Result newPayment(Http.Request request, String pmtTypeStr) {
        Form form;
        PaymentTransferType.PmtType pmtType;
        Messages messages;
        User user;
        block11: {
            user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            messages = this.messagesApi.preferred((Http.RequestHeader)request);
            try {
                pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeStr);
            }
            catch (IllegalArgumentException e) {
                return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
            }
            Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_PERIODIC);
            int folderId = Integer.parseInt(GeneralUtils.getSortingProperties(sorting).getProperty("folder", "-1"));
            try {
                boolean singleBooking = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.DISPLAY_PAYMENT_AS_SINGLE_BOOKING);
                boolean saveRecipient = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SAVE_RECIPIENT);
                PaymentFolder folder = Payments.getFolder(user, folderId);
                if (SepaPaymentForm.isSepaPmtType(pmtType)) {
                    SepaPaymentForm sepaPaymentForm = new SepaPaymentForm(PaymentContextType.PERIODIC_PAYMENT, pmtType, user, folder, singleBooking, saveRecipient);
                    sepaPaymentForm.setDefaultValues(pmtType);
                    sepaPaymentForm.executionDate = new Date();
                    form = this.formFactory.form(SepaPaymentForm.class).fill((Object)sepaPaymentForm);
                    break block11;
                }
                if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
                    DtazvPaymentForm dtazvPaymentForm = new DtazvPaymentForm(PaymentContextType.PERIODIC_PAYMENT, pmtType, folder, saveRecipient);
                    dtazvPaymentForm.currency = "EUR";
                    dtazvPaymentForm.executionDate = new Date();
                    form = this.formFactory.form(DtazvPaymentForm.class).fill((Object)dtazvPaymentForm);
                    break block11;
                }
                if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
                    form = this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(PaymentContextType.PERIODIC_PAYMENT, pmtType, folder, saveRecipient));
                    break block11;
                }
                if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
                    form = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm(PaymentContextType.PERIODIC_PAYMENT, pmtType, user, folder, saveRecipient));
                    break block11;
                }
                if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
                    form = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm(PaymentContextType.PERIODIC_PAYMENT, pmtType, user, folder, singleBooking, saveRecipient));
                    break block11;
                }
                if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
                    AustrianForeignPaymentForm sepaPaymentForm = new AustrianForeignPaymentForm(PaymentContextType.PERIODIC_PAYMENT, pmtType, user, Payments.getFolder(user, folderId), singleBooking, saveRecipient);
                    sepaPaymentForm.setDefaultValues(pmtType);
                    sepaPaymentForm.executionDate = new Date();
                    form = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)sepaPaymentForm);
                    break block11;
                }
                return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to initialize new payment!", e);
                return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("HTMLerror", messages.at("payment.error.failedtocreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }
        if (!form.hasErrors()) {
            ((PaymentForm)form.get()).loadDefaultFormSettings(user);
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        return PeriodicPayments.ok((Content)newpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.PERIODIC_PAYMENT, pmtType, flashMap, request, messages));
    }

    public Result saveNewPayment(Http.Request request, String pmtTypeStr, String paymentContext) {
        PaymentForm paymentForm;
        Form form;
        PaymentTransferType.PmtType pmtType;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        try {
            pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeStr);
        }
        catch (IllegalArgumentException e) {
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_PERIODIC);
        int folderId = Integer.parseInt(GeneralUtils.getSortingProperties(sorting).getProperty("folder", "-1"));
        if (SepaPaymentForm.isSepaPmtType(pmtType)) {
            form = this.formFactory.form(SepaPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (SepaPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
            form = this.formFactory.form(DtazvPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
            form = this.formFactory.form(Mt101PaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
            form = this.formFactory.form(PostbarPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
            form = this.formFactory.form(TaxOfficePaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
            form = this.formFactory.form(AustrianForeignPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (AustrianForeignPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else {
            form = null;
            paymentForm = null;
        }
        if (form == null || paymentForm == null) {
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtType}));
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        try {
            if (!form.hasErrors()) {
                String accountId = Utils.fieldValue(form, "originatorAccountId");
                if (accountId == null) {
                    form = form.withError("originatorAccountId", "error.invalid");
                    return PeriodicPayments.ok((Content)newpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.PERIODIC_PAYMENT, pmtType, flashMap, request, messages));
                }
                BankSettings bank = Account.findById((int)Integer.parseInt(accountId)).getBank();
                String orderType = SendParameters.getOrderType((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
                String fileType = SendParameters.getBTF((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
                if (!Util.isOrderType((String)orderType)) {
                    BLLoggerPlay.warning("Try to save periodic payment with unexpected order type '" + orderType + "'");
                }
                paymentForm.createNewVO(PaymentContextType.PERIODIC_PAYMENT, pmtType, orderType, fileType, Payments.getFolder(user, folderId));
                form = paymentForm.validateInputData((Form<? extends PaymentForm>)form, messages, this.formFactory, user, flashMap);
            }
            if (form.hasErrors()) {
                return PeriodicPayments.ok((Content)newpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.PERIODIC_PAYMENT, pmtType, flashMap, request, messages));
            }
            paymentForm.store(user, flashMap, messages);
            this.checkToGenerateStoredPayment(user, paymentForm.getDatabaseId(), flashMap, messages);
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to store new periodic payment for payment type " + pmtTypeStr + "!", e);
            return PeriodicPayments.ok((Content)newpayment.render((Form<? extends PaymentForm>)form.withGlobalError(messages.at("payment.error.failedtosave", new Object[]{Utils.getLocalizedMessage(e, messages)})), PaymentContextType.PERIODIC_PAYMENT, pmtType, flashMap, request, messages));
        }
        flashMap.put("success", messages.at("periodicpayments.created", new Object[0]));
        this.checkPermissionForModifiedPayment(user, (Form<? extends PaymentForm>)form, flashMap, messages);
        PaymentContextType paymentContextType = PaymentContextType.valueOf(paymentContext);
        if (paymentContextType == PaymentContextType.OPEN_TO_PERIODIC_PAYMENT) {
            return PeriodicPayments.redirect((Call)routes.OpenPayments.index(false)).flashing(flashMap);
        }
        if (paymentContextType == PaymentContextType.SIGNED_TO_PERIODIC_PAYMENT) {
            return PeriodicPayments.redirect((Call)routes.SignedPayments.index(false)).flashing(flashMap);
        }
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing(flashMap);
    }

    public Result update(Http.Request request, int paymentId) {
        PaymentForm paymentForm;
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PeriodicPayment periodicPayment = (PeriodicPayment)PeriodicPayments.getQueryCheckPermission(user).where().eq("id", (Object)paymentId).findOne();
        if (periodicPayment == null) {
            if (PeriodicPayment.findById((Integer)paymentId) == null) {
                return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("editpayment.error.deleted", new Object[0]));
            }
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("editpayment.error.nopermission", new Object[0]));
        }
        PaymentTransferType.PmtType pmtType = periodicPayment.getPmtType();
        if (SepaPaymentForm.isSepaPmtType(pmtType)) {
            form = this.formFactory.form(SepaPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (SepaPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
            form = this.formFactory.form(DtazvPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
            form = this.formFactory.form(Mt101PaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
            form = this.formFactory.form(PostbarPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
            form = this.formFactory.form(TaxOfficePaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
            form = this.formFactory.form(AustrianForeignPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (AustrianForeignPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else {
            form = null;
            paymentForm = null;
        }
        if (form == null || paymentForm == null) {
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtType}));
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        try {
            if (!form.hasErrors()) {
                paymentForm.updateVO(PaymentContextType.PERIODIC_PAYMENT, paymentId, pmtType);
                form = paymentForm.validateInputData((Form<? extends PaymentForm>)form, messages, this.formFactory, user, flashMap);
            }
            Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class);
            Form newFolderForm = this.formFactory.form(PaymentFolderForm.class);
            Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
            Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
            Form folderSelectForm = this.formFactory.form(SimpleSelectionForm.class);
            Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
            Form generateForm = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).bindFromRequest(request, new String[0]);
            if (form.hasErrors()) {
                return PeriodicPayments.ok((Content)editpayment.render(form, PaymentContextType.PERIODIC_PAYMENT, paymentId, pmtType, paymentForm.getClass(), null, periodicPayment.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateForm, true, request, messages));
            }
            ((PaymentForm)form.get()).store(user, flashMap, messages);
            this.checkToGenerateStoredPayment(user, ((PaymentForm)form.get()).getDatabaseId(), flashMap, messages);
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to update payment with ID " + paymentId + "!", e);
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("HTMLerror", messages.at("payment.error.failedtosave", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
        flashMap.put("success", messages.at("payment.modified", new Object[0]));
        this.checkPermissionForModifiedPayment(user, form, flashMap, messages);
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.payment(paymentId)).flashing(flashMap);
    }

    public Result payment(Http.Request request, int paymentId) {
        return this.paymentEditMode(request, paymentId, false);
    }

    public Result paymentEdit(Http.Request request, int paymentId) {
        return this.paymentEditMode(request, paymentId, true);
    }

    private Result paymentEditMode(Http.Request request, int paymentId, boolean inEditMode) {
        Form form;
        Class formClass;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PeriodicPayment periodicPayment = (PeriodicPayment)PeriodicPayments.getQueryCheckPermission(user).where().eq("id", (Object)paymentId).findOne();
        if (periodicPayment == null) {
            if (PeriodicPayment.findById((Integer)paymentId) == null) {
                return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("editpayment.error.deleted", new Object[0]));
            }
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", messages.at("editpayment.error.nopermission", new Object[0]));
        }
        BankSettings originatorBank = periodicPayment.getAccount().getBank();
        if (BankUtils.isDeactivated((BankUser)BankUser.findBankUser((BankSettings)originatorBank, (User)user))) {
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(true)).flashing("error", messages.at("payment.error.deactivated", new Object[]{1}));
        }
        PaymentTransferType.PmtType pmtType = periodicPayment.getPmtType();
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)user);
        try {
            boolean saveRecipient = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SAVE_RECIPIENT);
            if (SepaPaymentForm.isSepaPmtType(pmtType)) {
                boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
                formClass = SepaPaymentForm.class;
                form = this.formFactory.form(SepaPaymentForm.class).fill((Object)new SepaPaymentForm(periodicPayment, true, allowRecipientRecording, useMandates, saveRecipient));
            } else if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
                formClass = DtazvPaymentForm.class;
                form = this.formFactory.form(DtazvPaymentForm.class).fill((Object)new DtazvPaymentForm(periodicPayment, allowRecipientRecording, saveRecipient));
            } else if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
                formClass = Mt101PaymentForm.class;
                form = this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(periodicPayment, allowRecipientRecording, saveRecipient));
            } else if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
                formClass = PostbarPaymentForm.class;
                form = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm(periodicPayment, true, allowRecipientRecording, saveRecipient));
            } else if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
                formClass = TaxOfficePaymentForm.class;
                form = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm(periodicPayment, true, allowRecipientRecording, saveRecipient));
            } else if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
                formClass = AustrianForeignPaymentForm.class;
                form = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)new AustrianForeignPaymentForm(periodicPayment, true, allowRecipientRecording, saveRecipient));
            } else {
                formClass = null;
                form = null;
            }
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to load payment with ID " + paymentId + "!", e);
            return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("HTMLerror", messages.at("payment.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class);
        Form newFolderForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
        Form folderSelectForm = this.formFactory.form(SimpleSelectionForm.class);
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form generateForm = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).bindFromRequest(request, new String[0]);
        return PeriodicPayments.ok((Content)editpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.PERIODIC_PAYMENT, paymentId, pmtType, formClass, null, periodicPayment.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateForm, inEditMode, request, messages));
    }

    public Result findPeriods(Http.Request request, String firstExecution, String previousExecution, String nextExecution, String executionIntervalString, Integer executionCount, boolean calculateNextExecutionDate) {
        Date date2;
        if (firstExecution == null || firstExecution.isEmpty() || executionIntervalString == null || executionIntervalString.isEmpty() || executionCount == null) {
            return PeriodicPayments.notFound();
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        PeriodicPayment periodicPayment = new PeriodicPayment();
        DateFormatter dateFormatter = new DateFormatter();
        try {
            date2 = dateFormatter.parse(firstExecution, messages.lang().locale());
            if (date2 != null) {
                periodicPayment.setFirstExecutionDate(new java.sql.Date(date2.getTime()));
            }
        }
        catch (ParseException e) {
            return PeriodicPayments.notFound();
        }
        if (previousExecution != null && !previousExecution.isEmpty()) {
            try {
                date2 = dateFormatter.parse(previousExecution, messages.lang().locale());
                if (date2 != null) {
                    periodicPayment.setPreviousExecutionDate(new java.sql.Date(date2.getTime()));
                }
            }
            catch (ParseException e) {
                return PeriodicPayments.notFound();
            }
        }
        if (nextExecution != null && !nextExecution.isEmpty()) {
            try {
                date2 = dateFormatter.parse(nextExecution, messages.lang().locale());
                if (date2 != null) {
                    periodicPayment.setNextExecutionDate(new java.sql.Date(date2.getTime()));
                }
            }
            catch (ParseException e) {
                return PeriodicPayments.notFound();
            }
        }
        for (PeriodicPayment.ExecutionInterval interval : PeriodicPayment.ExecutionInterval.values()) {
            if (!interval.name().equals(executionIntervalString)) continue;
            periodicPayment.setExecutionInterval(interval);
            break;
        }
        if (periodicPayment.getExecutionInterval() == null) {
            return PeriodicPayments.notFound();
        }
        ScheduleHandler scheduleHandler = new ScheduleHandler(periodicPayment);
        scheduleHandler.calculateFirstExecutionDate(executionCount.intValue());
        if (calculateNextExecutionDate) {
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.add(5, -1);
            scheduleHandler.calculateNextExecutionDate(cal.getTime());
        }
        if (executionCount > 0) {
            scheduleHandler.calculateLastExecutionDate(executionCount.intValue());
        }
        StringBuilder resultBuilder = new StringBuilder().append(dateFormatter.print(periodicPayment.getFirstExecutionDate(), messages.lang().locale())).append('\t');
        if (periodicPayment.getNextExecutionDate() != null) {
            resultBuilder.append(dateFormatter.print(periodicPayment.getNextExecutionDate(), messages.lang().locale())).append('\t');
        }
        if (periodicPayment.getLastExecutionDate() != null) {
            resultBuilder.append(dateFormatter.print(periodicPayment.getLastExecutionDate(), messages.lang().locale()));
        }
        return PeriodicPayments.ok((byte[])resultBuilder.toString().getBytes(StandardCharsets.UTF_8));
    }

    public CompletionStage<Result> generateNow(Http.Request request) {
        return this.generatePaymentsNow(request, null);
    }

    public CompletionStage<Result> generatePaymentNow(Http.Request request, Integer id) {
        return this.generatePaymentsNow(request, id);
    }

    public CompletionStage<Result> generatePaymentsNow(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        String ids;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            ids = id.toString();
            redirectTo = routes.PeriodicPayments.payment(id);
        } else {
            ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.PeriodicPayments.index(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            List<Integer> idsToGenerate = GeneralUtils.getSelectionIds(ids);
            List selectedPayments = idsToGenerate.isEmpty() ? new ArrayList() : PeriodicPayments.getQueryCheckPermission(user).where().in("id", idsToGenerate).findList();
            List<PeriodicPayment> toGenerate = selectedPayments.stream().filter(p -> !BankUser.findBankUser((BankSettings)p.getBank(), (User)user).isDeactivated()).toList();
            if (selectedPayments.size() > toGenerate.size()) {
                Utils.addToFlash(flashMap, "warning", messages.at("payment.error.deactivated", new Object[]{selectedPayments.size() - toGenerate.size()}));
            }
            int counter = 0;
            try (Transaction t = DB.beginTransaction();){
                ArrayList caught = new ArrayList();
                PeriodicPaymentExecutionRunnerImpl runner = new PeriodicPaymentExecutionRunnerImpl(user, caught::add);
                Date now = new Date();
                for (PeriodicPayment periodicPayment : toGenerate) {
                    Date executionDate = periodicPayment.getPreviousExecutionDate() != null && periodicPayment.getPreviousExecutionDate().after(now) ? periodicPayment.getPreviousExecutionDate() : now;
                    runner.generatePayment(periodicPayment, executionDate);
                    if (!caught.isEmpty()) {
                        Utils.addToFlash(flashMap, "HTMLerror", messages.at("periodicpayments.generatefailed", new Object[]{Utils.getLocalizedMessage((Throwable)caught.getFirst(), messages)}));
                        Result result = PeriodicPayments.redirect((Call)redirectTo).flashing(flashMap);
                        return result;
                    }
                    ++counter;
                }
                t.commit();
            }
            String flashKey = counter == 0 ? "error" : "success";
            Utils.addToFlash(flashMap, flashKey, messages.at("payment.open.created", new Object[]{counter}));
            return PeriodicPayments.redirect((Call)redirectTo).flashing(flashMap);
        }, this.executionContext.current());
    }

    public CompletionStage<Result> savePayments(Http.Request request) {
        return this.savePeriodicPayments(request, null);
    }

    public CompletionStage<Result> savePayment(Http.Request request, Integer id) {
        return this.savePeriodicPayments(request, id);
    }

    public CompletionStage<Result> savePeriodicPayments(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        String ids;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            ids = id.toString();
            redirectTo = routes.PeriodicPayments.payment(id);
        } else {
            ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.PeriodicPayments.index(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            List<Integer> idsToSave = GeneralUtils.getSelectionIds(ids);
            List toSave = idsToSave.isEmpty() ? new ArrayList() : PeriodicPayments.getQueryCheckPermission(user).where().in("id", idsToSave).findList();
            if (toSave == null) {
                return PeriodicPayments.redirect((Call)redirectTo).flashing("error", messages.at("payment.error.nopaymentsselected", new Object[0]));
            }
            if (toSave.isEmpty()) {
                return PeriodicPayments.redirect((Call)redirectTo).flashing("error", messages.at("payment.save.nopaymentfile", new Object[0]));
            }
            try {
                String fileName = "Bl_PeriodicPayments_" + new SimpleDateFormat("yyMMdd").format(new Date()) + ".zip";
                File exportFile = Util.createTempFile((String)fileName, (String)".tmp", (boolean)true);
                new PeriodicPaymentFileExport().exportPayments(toSave, exportFile, false);
                return GeneralUtils.supplyWorkspaceFile(exportFile, false, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(fileName));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to save periodic payment!", e);
                return PeriodicPayments.redirect((Call)redirectTo).flashing("error", messages.at("payment.save.nopaymentfile", new Object[0]));
            }
        }, this.executionContext.current());
    }

    public Result delete(Http.Request request) {
        return this.deletePayments(request, null);
    }

    public Result deletePayment(Http.Request request, Integer id) {
        return this.deletePayments(request, id);
    }

    public Result deletePayments(Http.Request request, Integer id) {
        String flashMessage;
        String flashKey;
        List<Integer> paymentIds;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            paymentIds = Collections.singletonList(id);
        } else {
            String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            paymentIds = GeneralUtils.getSelectionIds(ids);
        }
        if (!paymentIds.isEmpty()) {
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            Query query = PeriodicPayments.getQueryCheckPermission(user).where().in("id", paymentIds).query();
            query.order().clear();
            List idsToDelete = query.findIds();
            for (PeriodicPayment paymentToDelete : DB.find(PeriodicPayment.class).where().in("id", (Collection)idsToDelete).findList()) {
                Logger.logPeriodicPaymentDeleted((User)user, (PeriodicPayment)paymentToDelete);
            }
            DB.deleteAll(PeriodicPayment.class, (Collection)idsToDelete);
            flashKey = idsToDelete.isEmpty() ? "warning" : "success";
            flashMessage = messages.at("payment.deletedpayments", new Object[]{idsToDelete.size()});
        } else {
            flashKey = "error";
            flashMessage = messages.at("payment.error.nopaymentsselected", new Object[0]);
        }
        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing(flashKey, flashMessage);
    }

    public Result duplicate(Http.Request request) {
        return this.duplicatePayments(request, null);
    }

    public Result duplicatePayment(Http.Request request, Integer id) {
        return this.duplicatePayments(request, id);
    }

    public Result duplicatePayments(Http.Request request, Integer id) {
        String flashMessage;
        String flashKey;
        play.api.mvc.Call redirectTo;
        List<Integer> idsToCopy;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            idsToCopy = Collections.singletonList(id);
            redirectTo = routes.PeriodicPayments.payment(id);
        } else {
            String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            idsToCopy = GeneralUtils.getSelectionIds(ids);
            redirectTo = routes.PeriodicPayments.index(false);
        }
        if (!idsToCopy.isEmpty()) {
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            List toCopy = PeriodicPayments.getQueryCheckPermission(user).where().in("id", idsToCopy).findList();
            int counter = 0;
            if (!toCopy.isEmpty()) {
                try (Transaction t = DB.beginTransaction();){
                    for (PeriodicPayment periodicPayment : toCopy) {
                        PeriodicPayment newPayment = new PeriodicPayment();
                        newPayment.setBank(periodicPayment.getBank());
                        newPayment.setAccount(periodicPayment.getAccount());
                        newPayment.setOrderType(periodicPayment.getOrderType());
                        newPayment.setFileType(periodicPayment.getFileTypeOrBTF());
                        newPayment.setPmtType(periodicPayment.getPmtType());
                        newPayment.setCredit(periodicPayment.isCredit());
                        newPayment.setUrgent(periodicPayment.isUrgent().booleanValue());
                        newPayment.setRecipient(periodicPayment.getRecipient());
                        newPayment.setAmount(periodicPayment.getAmount());
                        newPayment.setAmountCurrency(periodicPayment.getAmountCurrency());
                        newPayment.setPurpose(periodicPayment.getPurpose());
                        newPayment.setExecutionInterval(periodicPayment.getExecutionInterval());
                        newPayment.setFirstExecutionDate(periodicPayment.getFirstExecutionDate());
                        newPayment.setLastExecutionDate(periodicPayment.getLastExecutionDate());
                        newPayment.setPreviousExecutionDate(periodicPayment.getPreviousExecutionDate());
                        newPayment.setNextExecutionDate(periodicPayment.getNextExecutionDate());
                        newPayment.setPaymentData(periodicPayment.getPaymentData());
                        newPayment.setGenericPurpose(periodicPayment.getGenericPurpose());
                        newPayment.setFolder(periodicPayment.getFolder());
                        newPayment.setSalaryPayment(periodicPayment.getSalaryPayment());
                        newPayment.setOriginator(periodicPayment.getOriginator());
                        newPayment.save(user, false);
                        Logger.logPeriodicPaymentCreated((User)user, (PeriodicPayment)newPayment);
                        ++counter;
                    }
                    t.commit();
                }
            }
            flashKey = counter == 0 ? "warning" : "success";
            flashMessage = messages.at("payment.duplicated", new Object[]{counter});
        } else {
            flashKey = "error";
            flashMessage = messages.at("payment.error.nopaymentsselected", new Object[0]);
        }
        return PeriodicPayments.redirect((Call)redirectTo).flashing(flashKey, flashMessage);
    }

    public CompletionStage<Result> printOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        return CompletableFuture.supplyAsync(() -> {
            try {
                List toPrint;
                if (ids == null || ids.isEmpty()) {
                    toPrint = !filter.isPeriodicPaymentsFilterActive() ? this.getDefaultQuery(user, Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_PERIODIC), null, null).findList() : this.getDefaultQuery(user, Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_PERIODIC), null, filter).findList();
                } else {
                    List<Integer> idsToPrint = GeneralUtils.getSelectionIds(ids);
                    if (idsToPrint.isEmpty()) {
                        return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", "payment.error.nopaymentsselected");
                    }
                    toPrint = PeriodicPayments.getQueryCheckPermission(user).where().in("id", idsToPrint).findList();
                }
                File file2 = new PeriodicPaymentsTableOverviewPrinter(this, user, messages.lang().toLocale(), BLLoggerPlay.getLogger(), GeneralUtils.printLogo(user)){
                    private Integer lastPaymentId;
                    private PaymentHandler<?> paymentHandler;

                    protected String getOrderState(PeriodicPayment payment) {
                        return null;
                    }

                    protected boolean isSalaryPayment(PeriodicPayment payment) {
                        PaymentHandler<?> paymentHandler = this.getPaymentData(payment);
                        if (paymentHandler != null) {
                            return paymentHandler.isSalaryPayment();
                        }
                        return false;
                    }

                    protected String getRecipientAccountRepresentation(PeriodicPayment payment) {
                        PaymentHandler<?> paymentHandler = this.getPaymentData(payment);
                        if (paymentHandler != null) {
                            return paymentHandler.getRecipientAccount();
                        }
                        return "";
                    }

                    private PaymentHandler<?> getPaymentData(PeriodicPayment payment) {
                        if (this.paymentHandler == null || !payment.getId().equals(this.lastPaymentId)) {
                            try {
                                this.paymentHandler = PaymentHandler.getHandler(payment.getPmtType(), payment.getPaymentData());
                                this.lastPaymentId = payment.getId();
                            }
                            catch (PaymentException e) {
                                BLLoggerPlay.error("Failed to load payment handler for periodic payment " + payment.getId(), e);
                                this.paymentHandler = null;
                                this.lastPaymentId = null;
                            }
                        }
                        return this.paymentHandler;
                    }
                }.print(toPrint);
                return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to print periodic payments overview to PDF file!", e);
                return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToPrintPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> exportOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        boolean includeIban = new SortingHandler(user, Sorting.Table.PMT_PERIODIC).isColumnDisplayed(7);
        return CompletableFuture.supplyAsync(() -> {
            List toExport;
            if (ids == null || ids.isEmpty()) {
                toExport = !filter.isPeriodicPaymentsFilterActive() ? this.getDefaultQuery(user, Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_PERIODIC), null, null).findList() : this.getDefaultQuery(user, Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_PERIODIC), null, filter).findList();
            } else {
                List<Integer> idsToExport = GeneralUtils.getSelectionIds(ids);
                if (idsToExport.isEmpty()) {
                    return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", "payment.error.nopaymentsselected");
                }
                toExport = PeriodicPayments.getQueryCheckPermission(user).where().in("id", idsToExport).findList();
            }
            try {
                String fileName = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.periodicPayments", (Object[])new Object[0]) + ".csv";
                File tmpFile = Util.createTempFile((String)fileName, (String)".tmp", (boolean)true);
                try (CountingFilterOutputStream outputStream = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(tmpFile));){
                    new PeriodicPaymentTableCsvExport(this, messages.lang().toLocale(), Util.displayOpenSalaries((User)user), includeIban){
                        private Integer lastPaymentId;
                        private PaymentHandler<?> paymentHandler;

                        protected boolean isSalaryPayment(PeriodicPayment payment) {
                            PaymentHandler<?> handler = this.getPaymentData(payment);
                            if (handler != null) {
                                return handler.isSalaryPayment();
                            }
                            return false;
                        }

                        protected String getPaymentTypeDescription(PeriodicPayment payment) {
                            return PaymentTypeUtil.getUniquePaymentName((Locale)messages.lang().toLocale(), (PaymentTransferType.PmtType)payment.getPmtType());
                        }

                        private PaymentHandler<?> getPaymentData(PeriodicPayment payment) {
                            if (this.paymentHandler == null || !payment.getId().equals(this.lastPaymentId)) {
                                try {
                                    this.paymentHandler = PaymentHandler.getHandler(payment.getPmtType(), payment.getPaymentData());
                                    this.lastPaymentId = payment.getId();
                                }
                                catch (PaymentException e) {
                                    BLLoggerPlay.error("Failed to load payment handler for periodic payment " + payment.getId(), e);
                                    this.paymentHandler = null;
                                    this.lastPaymentId = null;
                                }
                            }
                            return this.paymentHandler;
                        }
                    }.write((OutputStream)outputStream, (Iterable)toExport);
                }
                return GeneralUtils.supplyWorkspaceFile(tmpFile, false, true).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(fileName));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to export open payments overview to CSV file!", e);
                return PeriodicPayments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("HTMLerror", messages.at("payment.error.failedtoexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    private Query<PeriodicPayment> getDefaultQuery(User user, Sorting sorting, PaymentFolder paymentFolder, PaymentFilter filter) {
        String columnName;
        int sortingColumn;
        Query<PeriodicPayment> query = PeriodicPayments.getQueryCheckPermission(user, paymentFolder);
        if (filter != null && filter.isPeriodicPaymentsFilterActive() && filter.getPeriodicExpression() != null) {
            query.where(filter.getPeriodicExpression());
        }
        if (sorting.getSortingColumn() == null) {
            sorting.setSortingColumn(Integer.valueOf(0));
            sorting.setSortAscending(true);
        }
        if ((sortingColumn = sorting.getSortingColumn().intValue()) == 0) {
            columnName = "account.name";
        } else if (sortingColumn == 1) {
            columnName = "orderType";
        } else if (sortingColumn == 2) {
            columnName = "recipient";
        } else if (sortingColumn == 3) {
            columnName = "amount";
        } else if (sortingColumn == 4) {
            columnName = "purpose";
        } else if (sortingColumn == 5) {
            columnName = "lastExecutionDate";
        } else if (sortingColumn == 6) {
            columnName = "nextExecutionDate";
        } else if (sortingColumn == 7) {
            columnName = "account.iban";
        } else if (sortingColumn == 8) {
            columnName = "folder.name";
        } else if (sortingColumn == 9) {
            columnName = "created_user_id";
        } else if (sortingColumn == 10) {
            columnName = "exec_ival";
        } else if (sortingColumn == 11) {
            columnName = "originator";
        } else {
            BLLoggerPlay.warning("User " + user.getName() + " (" + user.getId() + ") tried to sort periodic payments by unknown column with ID " + sortingColumn + "!");
            columnName = null;
        }
        if (columnName != null) {
            if (sorting.isSortAscending()) {
                query.orderBy(columnName);
            } else {
                query.orderBy(columnName + " DESC");
            }
        }
        query.orderBy().desc("id");
        return query;
    }

    private void checkPermissionForModifiedPayment(User user, Form<? extends PaymentForm> form, Map<String, String> flashMap, Messages messages) {
        if (PeriodicPayments.getQueryCheckPermission(user).where().eq("id", (Object)((PaymentForm)form.get()).getDatabaseId()).findOne() == null) {
            String pmtTypeName = ((PaymentForm)form.get()).getPmtType().name();
            flashMap.put("warning", messages.at("payment.warning.missingpermissionforpayment", new Object[]{pmtTypeName}));
        }
    }

    private void checkToGenerateStoredPayment(User user, Integer databaseId, Map<String, String> flashMap, Messages messages) {
        if (databaseId == null || databaseId < 0) {
            return;
        }
        PeriodicPayment periodicPaymentVO = (PeriodicPayment)PeriodicPayments.getQueryCheckPermission(user).where().eq("id", (Object)databaseId).findOne();
        if (periodicPaymentVO == null) {
            return;
        }
        ArrayList caught = new ArrayList();
        int count = new PeriodicPaymentExecutionRunnerImpl(user, caught::add).generatePayment(periodicPaymentVO);
        if (!caught.isEmpty()) {
            flashMap.put("HTMLerror", messages.at("periodicpayments.generatefailed", new Object[]{Utils.getLocalizedMessage((Throwable)caught.get(0), messages)}));
        } else if (count > 0) {
            flashMap.put("info", messages.at("payment.open.created", new Object[]{count}));
        }
    }
}

