/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.DesOverview;
import controllers.OpenPayments;
import controllers.PeriodicPayments;
import controllers.SignedPayments;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import controllers.util.CsvImport;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.account.BankInfo;
import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.DsBank;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SclDirectory;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.dta.api.DtazvOriginatorData;
import de.businesslogics.banking.dta.api.DtazvRecipientData;
import de.businesslogics.banking.mt101.api.MT101OriginatorData;
import de.businesslogics.banking.mt101.api.MT101RecipientData;
import de.businesslogics.banking.payments.api.BankingPaymentPrinter;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.api.ChequeRecipientData;
import de.businesslogics.banking.sepa.api.PostbarRecipientData;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.banking.sepa.api.SepaMandateData;
import de.businesslogics.banking.sepa.api.SepaOriginatorData;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.at.AustrianFeeItem;
import de.businesslogics.format.sepa.at.AustrianFeeMessage;
import de.businesslogics.format.sepa.at.AustrianFeeMessageHandler;
import de.businesslogics.format.sepa.at.AustrianFeeType;
import de.businesslogics.format.sepa.at.AustrianFeeTypeProvider;
import de.businesslogics.format.sepa.at.KnownTaxOfficeRecipient;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Query;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import javax.inject.Inject;
import models.CsvImportInfo;
import models.DeleteFolderForm;
import models.MovePaymentToFolderForm;
import models.PaymentCsvImportForm;
import models.PaymentFolderForm;
import models.PaymentImportForm;
import models.PeriodicParametersForm;
import models.SimpleSelectionForm;
import models.SimpleTextForm;
import models.TaxOfficePaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentLockInfo;
import models.payments.PaymentPrinterInfo;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.japi.function.Function2;
import org.apache.pekko.stream.javadsl.Flow;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.ValidationError;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.mvc.WebSocket;
import play.twirl.api.Content;
import views.Utils;
import views.html.payments.paymentcsvimport;
import views.html.payments.paymentimport;

@Security.Authenticated(value=AuthenticatorFor.Payment.class)
public final class Payments
extends Controller {
    public static final String PROPS_FOLDER = "folder";
    public static final String PROPS_SELECTION = "selection";
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    public static String getFilterDescription(PaymentFilter paymentFilter, User user, boolean signed, boolean periodic, boolean template, Messages messages) {
        Account account;
        boolean open = !signed && !periodic && !template;
        StringBuilder result = new StringBuilder();
        if (paymentFilter.getAccountId() != null && (account = Account.findById((int)paymentFilter.getAccountId())) != null) {
            result.append(messages.at("payment.filter.description.account", new Object[]{Account.getDefaultDisplayName((Account)account)}));
        }
        if (paymentFilter.getPmtType() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            String description = PaymentTypeUtil.getUniquePaymentName((Locale)messages.lang().toLocale(), (PaymentTransferType.PmtType)paymentFilter.getPmtType());
            if (paymentFilter.getPmtTypeComparator() == FilterComparator.PaymentType.EQUAL) {
                result.append(messages.at("payment.filter.description.filterPmtType.equal", new Object[]{description}));
            } else {
                result.append(messages.at("payment.filter.description.filterPmtType.notEqual", new Object[]{description}));
            }
        }
        if (paymentFilter.getText() != null && !paymentFilter.getText().isEmpty()) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            if (paymentFilter.getTextComparator() == FilterComparator.Text.STARTS_WITH) {
                result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.text.startswith", (Object[])new Object[]{paymentFilter.getText()}));
            } else if (paymentFilter.getTextComparator() == FilterComparator.Text.ENDS_WITH) {
                result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.text.endswith", (Object[])new Object[]{paymentFilter.getText()}));
            } else if (paymentFilter.getTextComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.text.containsnot", (Object[])new Object[]{paymentFilter.getText()}));
            } else {
                result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"Filter.text.contains", (Object[])new Object[]{paymentFilter.getText()}));
            }
        }
        if (paymentFilter.getAmountComparator() != null && paymentFilter.getAmountFrom() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(messages.at("sent.filter.amount", new Object[]{paymentFilter.getAmountComparator().ordinal(), paymentFilter.getAmountFrom(), paymentFilter.getAmountTo()}));
        }
        if (!(template || periodic || paymentFilter.getExecutionDateCompator() == null || paymentFilter.getFromExecutionDate() == null && paymentFilter.getToExecutionDate() == null)) {
            java.sql.Date toDate;
            java.sql.Date fromDate;
            FilterComparator.Date comparator;
            if (!result.isEmpty()) {
                result.append(", ");
            }
            if (paymentFilter.getExecutionDateCompator() == FilterComparator.Date.BETWEEN && paymentFilter.getFromExecutionDate() == null) {
                comparator = FilterComparator.Date.LESS;
                fromDate = paymentFilter.getToExecutionDate();
                toDate = null;
            } else if (paymentFilter.getExecutionDateCompator() == FilterComparator.Date.BETWEEN && paymentFilter.getToExecutionDate() == null) {
                comparator = FilterComparator.Date.GREATER;
                fromDate = paymentFilter.getFromExecutionDate();
                toDate = null;
            } else {
                comparator = paymentFilter.getExecutionDateCompator();
                fromDate = paymentFilter.getFromExecutionDate();
                toDate = paymentFilter.getToExecutionDate();
            }
            result.append(messages.at("payment.filter.description.executiondate", new Object[]{comparator.ordinal(), fromDate, toDate}));
        }
        if (signed && paymentFilter.getState() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(messages.at("payment.filter.description.state", new Object[]{SendUtil.getStateFilterText((PaymentFilter.State)paymentFilter.getState(), (Locale)messages.lang().locale())}));
        }
        if ((open || periodic) && user != null && paymentFilter.getFilterUserId() != null) {
            User filterUser = User.getByIdForTenants((int)paymentFilter.getFilterUserId(), (Collection)user.getTenants(), (boolean)true);
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(messages.at("payment.filter.description.filterUser", new Object[]{filterUser != null ? filterUser.getName() : messages.at("general.invaliduser", new Object[]{paymentFilter.getFilterUserId()})}));
        }
        return result.toString();
    }

    public static PaymentFolder getFolder(User user, int folderId) {
        if (folderId == -1) {
            return null;
        }
        if (folderId == -2) {
            return PaymentFolder.NULL_FOLDER;
        }
        return PaymentFolder.findById((Integer)folderId, (User)user);
    }

    static Map<String, String> createNewFolder(Http.Request request, FormFactory formFactory, MessagesApi messagesApi) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        Form<PaymentFolderForm> form = formFactory.form(PaymentFolderForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFolder paymentFolder = new PaymentFolder();
        if (!form.hasErrors()) {
            form = ((PaymentFolderForm)form.get()).validateFolderChanges(form, paymentFolder, user);
        }
        if (!form.hasErrors()) {
            flashMap.put("success", messages.at("openpayments.folder.created", new Object[]{paymentFolder.getName()}));
        } else {
            flashMap.put("error", messages.at("openpayments.folder.invalidparameters", new Object[0]));
        }
        return flashMap;
    }

    static Map<String, String> renameFolder(Http.Request request, PaymentFolder paymentFolder, FormFactory formFactory, MessagesApi messagesApi) {
        Form form = formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
        Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        HashMap validationErrors = new HashMap(1);
        form.value().ifPresent(f -> {
            if (f.text == null || f.text.isEmpty()) {
                validationErrors.put("text", "error.required");
            } else {
                PaymentFolder folder = PaymentFolder.findByName((String)f.text, (Tenant)paymentFolder.getTenant());
                if (folder != null && !folder.equals(paymentFolder)) {
                    validationErrors.put("text", "openpayments.folder.alreadyexists");
                } else {
                    paymentFolder.setName(f.text);
                    DB.save((Object)paymentFolder);
                }
            }
        });
        if (!validationErrors.isEmpty()) {
            for (String key : validationErrors.keySet()) {
                form = form.withError(key, (String)validationErrors.get(key));
            }
        }
        if (!form.hasErrors()) {
            flashMap.put("success", messages.at("openpayments.folder.changedname", new Object[]{paymentFolder.getName()}));
        } else {
            flashMap.put("error", messages.at("openpayments.folder.invalidparameters", new Object[0]));
        }
        return flashMap;
    }

    static Map<String, String> moveToFolder(Http.Request request, FormFactory formFactory, MessagesApi messagesApi) {
        Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = formFactory.form(MovePaymentToFolderForm.class).bindFromRequest(request, new String[0]);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (!form.hasErrors()) {
            flashMap.put("paymentIds", ((MovePaymentToFolderForm)form.get()).paymentIds);
            ((MovePaymentToFolderForm)form.get()).validate(flashMap, messages, user);
            ((MovePaymentToFolderForm)form.get()).store(flashMap, messages, user);
        } else {
            flashMap.put("error", messages.at("openpayments.error.failedtomovepayments", new Object[0]));
        }
        return flashMap;
    }

    static Map<String, String> deleteFolder(Http.Request request, FormFactory formFactory, MessagesApi messagesApi, int folderId, Sorting sorting) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Messages messages = messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFolder paymentFolder = PaymentFolder.findById((Integer)folderId, (User)user);
        if (paymentFolder != null) {
            Form form = formFactory.form(DeleteFolderForm.class).bindFromRequest(request, new String[0]);
            DeleteFolderForm deleteFolderForm = (DeleteFolderForm)form.get();
            try (Transaction t = DB.beginTransaction();){
                Tenant tenant = paymentFolder.getTenant();
                boolean onlyPaymentsWithPermission = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, tenant).getBoolean((DatabasePreferenceConstant)PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION);
                SignedPayment.removeFolderReferences((PaymentFolder)paymentFolder);
                if ("delete".equals(deleteFolderForm.policyForOpenPayments)) {
                    OpenPayment.deleteByFolder((User)user, (PaymentFolder)paymentFolder, (boolean)onlyPaymentsWithPermission, (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
                } else {
                    OpenPayment.removeFolderReferences((PaymentFolder)paymentFolder);
                }
                if ("delete".equals(deleteFolderForm.policyForPeriodicPayments)) {
                    PeriodicPayment.deleteByFolder((User)user, (PaymentFolder)paymentFolder, (boolean)onlyPaymentsWithPermission, (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
                } else {
                    PeriodicPayment.removeFolderReferences((PaymentFolder)paymentFolder);
                }
                if ("delete".equals(deleteFolderForm.policyForPaymentTemplates)) {
                    PaymentTemplate.deleteByFolder((User)user, (PaymentFolder)paymentFolder, (boolean)onlyPaymentsWithPermission, (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
                } else {
                    PaymentTemplate.removeFolderReferences((PaymentFolder)paymentFolder);
                }
                Properties props = GeneralUtils.getSortingProperties(sorting);
                try {
                    int sortingFolderId = Integer.parseInt(props.getProperty(PROPS_FOLDER, "-1"));
                    if (sortingFolderId == folderId) {
                        props.remove(PROPS_FOLDER);
                    }
                    GeneralUtils.storeSortingProperties(props, sorting);
                }
                catch (NumberFormatException e) {
                    BLLoggerPlay.error("Failed to read parameters from sorting properties for payments table!", e);
                }
                DB.delete((Object)paymentFolder);
                t.commit();
                flashMap.put("success", messages.at("openpayments.folder.deleted", new Object[]{paymentFolder.getName()}));
            }
            catch (Throwable e) {
                BLLoggerPlay.error("Failed to delete open payments folder!", e);
                flashMap.put("error", messages.at("openpayments.folder.deleted.error", new Object[]{paymentFolder.getName()}));
            }
        } else {
            flashMap.put("error", messages.at("openpayments.folder.deleted.notfound", new Object[0]));
        }
        return flashMap;
    }

    @Inject
    public Payments(MessagesApi messagesApi, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
    }

    public Result findBankFromBlz(String blz) {
        String bankName;
        if (RegularExpressions.GERMAN_BANK_CODE.matches(blz) && (bankName = BLZCache.getBankName((String)blz.replaceAll("\\s", ""))) != null) {
            return Payments.ok((byte[])bankName.getBytes(StandardCharsets.UTF_8));
        }
        return Payments.ok();
    }

    public Result findBankFromBic(String bic) {
        SclDirectory scl;
        if (RegularExpressions.BIC.matches(bic) && (scl = SclDirectory.getForBIC((String)bic.replaceAll("\\s", ""))) != null && scl.getName() != null) {
            return Payments.ok((byte[])scl.getName().getBytes(StandardCharsets.UTF_8));
        }
        return Payments.ok();
    }

    public Result findDtazvCustomerNumberForOriginatorAccount(int originatorAccountId) {
        Account account = (Account)DB.find(Account.class, (Object)originatorAccountId);
        if (account != null && !account.getGermanAccountNumber().isEmpty()) {
            return Payments.ok((byte[])account.getGermanAccountNumber().getBytes(StandardCharsets.UTF_8));
        }
        return Payments.ok();
    }

    public Result findBics(String searchString, String serviceString) {
        BicLoader.Service service = null;
        for (BicLoader.Service bicService : BicLoader.Service.values()) {
            if (!bicService.name().equals(serviceString)) continue;
            service = bicService;
            break;
        }
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (SclDirectory sclDirectory : BicLoader.getInstance().findSclDirectoriesContaining(searchString, service)) {
            if (!builder.isEmpty()) {
                builder.append('\n');
            }
            builder.append(sclDirectory.getBic()).append(" - ").append(sclDirectory.getName());
            if (count++ < 9) continue;
            break;
        }
        byte[] resultData = builder.toString().getBytes(StandardCharsets.US_ASCII);
        return Payments.ok((byte[])resultData);
    }

    public Result findOriginators(Http.Request request, String searchString, int tenantId, String types) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        if (types != null) {
            for (String type : types.split(" ")) {
                paymentTypes.add(PaymentType.valueOf((String)type));
            }
        }
        Tenant tenant = tenantId >= 0 ? Tenant.findById((int)tenantId, (User)user, (boolean)false) : null;
        Query query = tenant == null ? PaymentOriginator.findQueryforUser((User)user) : DB.find(PaymentOriginator.class).where().eq("tenant", (Object)tenant).orderBy("name asc, paymentType asc").query();
        if (!paymentTypes.isEmpty()) {
            query.where().in("paymentType", paymentTypes);
        }
        if (searchString != null && !searchString.isEmpty()) {
            query.where().like("name", "%" + searchString + "%");
        }
        query.orderBy("name");
        query.setMaxRows(10);
        StringBuilder result = new StringBuilder();
        for (PaymentOriginator originator : query.findList()) {
            DtazvOriginatorData originatorData;
            if (!result.isEmpty()) {
                result.append('\n');
            }
            if (originator.getPaymentType() == PaymentType.SEPA) {
                String pmtType = originator.getPaymentType().name();
                String name = "";
                String creditorId = "";
                String taxNumber = "";
                String dept = "";
                String subDept = "";
                String street = "";
                String buildingNumber = "";
                String buildingName = "";
                String floor = "";
                String town = "";
                String postCode = "";
                String subCountry = "";
                String country = "";
                SepaOriginatorData originatorData2 = new SepaOriginatorData();
                try {
                    AddressData oAddress;
                    originatorData2.setPaymentOriginator(originator);
                    name = originatorData2.getName();
                    if (originatorData2.getCreditorId() != null) {
                        creditorId = originatorData2.getCreditorId();
                    }
                    if (originatorData2.getTaxNumber() != null) {
                        taxNumber = originatorData2.getTaxNumber();
                    }
                    if ((oAddress = originatorData2.getAddress()) != null) {
                        if (oAddress.getDepartment() != null) {
                            dept = oAddress.getDepartment();
                        }
                        if (oAddress.getSubDepartment() != null) {
                            subDept = oAddress.getSubDepartment();
                        }
                        if (oAddress.getStreetName() != null) {
                            street = oAddress.getStreetName();
                        }
                        if (oAddress.getBuildingNumber() != null) {
                            buildingNumber = oAddress.getBuildingNumber();
                        }
                        if (oAddress.getBuildingName() != null) {
                            buildingName = oAddress.getBuildingName();
                        }
                        if (oAddress.getFloor() != null) {
                            floor = oAddress.getFloor();
                        }
                        if (oAddress.getTownName() != null) {
                            town = oAddress.getTownName();
                        }
                        if (oAddress.getPostCode() != null) {
                            postCode = oAddress.getPostCode();
                        }
                        if (oAddress.getCountrySubDivision() != null) {
                            subCountry = oAddress.getCountrySubDivision();
                        }
                        if (oAddress.getCountry() != null) {
                            country = oAddress.getCountry();
                        }
                    }
                }
                catch (IOException e) {
                    BLLoggerPlay.error("Failed to load payment originator!", e);
                }
                result.append(pmtType).append('\t');
                result.append(name).append('\t');
                result.append(creditorId).append('\t');
                result.append(taxNumber).append('\t');
                result.append(dept).append('\t');
                result.append(subDept).append('\t');
                result.append(street).append('\t');
                result.append(buildingNumber).append('\t');
                result.append(buildingName).append('\t');
                result.append(floor).append('\t');
                result.append(town).append('\t');
                result.append(postCode).append('\t');
                result.append(subCountry).append('\t');
                result.append(country).append('\t');
                continue;
            }
            if (originator.getPaymentType() == PaymentType.DTAZV) {
                originatorData = new DtazvOriginatorData();
                try {
                    originatorData.setPaymentOriginator(originator);
                    result.append(originator.getPaymentType().name()).append('\t');
                    result.append(originatorData.getName()).append('\t');
                    if (originatorData.getName2() != null) {
                        result.append(originatorData.getName2());
                    }
                    result.append('\t');
                    if (originatorData.getStreet() != null) {
                        result.append(originatorData.getStreet());
                    }
                    result.append('\t');
                    if (originatorData.getTown() != null) {
                        result.append(originatorData.getTown());
                    }
                    result.append('\t');
                    if (originatorData.getContact() == null) continue;
                    result.append(originatorData.getContact());
                }
                catch (IOException e) {
                    BLLoggerPlay.error("Failed to load payment originator!", e);
                }
                continue;
            }
            if (originator.getPaymentType() != PaymentType.MT101) continue;
            originatorData = new MT101OriginatorData();
            try {
                originatorData.setPaymentOriginator(originator);
                result.append(originator.getPaymentType().name()).append('\t');
                result.append(originatorData.getName()).append('\t');
                if (originatorData.getName2() != null) {
                    result.append(originatorData.getName2());
                }
                result.append('\t');
                if (originatorData.getStreet() != null) {
                    result.append(originatorData.getStreet());
                }
                result.append('\t');
                if (originatorData.getTown() != null) {
                    result.append(originatorData.getTown());
                }
                result.append('\t');
                if (originatorData.getSenderBic() != null) {
                    result.append(originatorData.getSenderBic());
                }
                result.append('\t');
                if (originatorData.getReceiverBic() == null) continue;
                result.append(originatorData.getReceiverBic());
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load payment originator!", e);
            }
        }
        return Payments.ok((byte[])result.toString().getBytes(StandardCharsets.UTF_8));
    }

    public Result findRecipients(Http.Request request, String searchString, int tenantId, String types) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        if (types != null) {
            for (String type : types.split(" ")) {
                paymentTypes.add(PaymentType.valueOf((String)type));
            }
        }
        if (paymentTypes.isEmpty()) {
            return Payments.ok();
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Tenant tenant = tenantId >= 0 ? Tenant.findById((int)tenantId, (User)user, (boolean)false) : null;
        List tenants2 = tenant != null ? Collections.singletonList(tenant) : user.getTenants();
        List recipients2 = PaymentRecipient.findRecipientsByNameOrAccountNumberLike(paymentTypes, (String)searchString, (List)tenants2);
        if (recipients2 == null) {
            recipients2 = new ArrayList();
        } else if (recipients2.size() > 10) {
            recipients2 = recipients2.subList(0, 10);
        }
        StringBuilder result = new StringBuilder();
        int count = 0;
        block24: for (PaymentRecipient recipient : recipients2) {
            if (count++ >= 10) break;
            if (!result.isEmpty()) {
                result.append('\n');
            }
            result.append(recipient.getId()).append('\t');
            result.append(recipient.getPaymentType().name()).append('\t');
            result.append(recipient.getDisplayName()).append('\t');
            result.append(recipient.getName()).append('\t');
            if (recipient.getAccountNumber() != null) {
                result.append(recipient.getAccountNumber());
            }
            result.append('\t');
            if (recipient.getBankCode() != null) {
                result.append(recipient.getBankCode());
            }
            result.append('\t');
            switch (recipient.getPaymentType()) {
                case SEPA: {
                    SepaRecipientData recipientData = new SepaRecipientData();
                    try {
                        recipientData.setPaymentRecipient(recipient);
                        if (recipientData.getMandateSignDate() != null) {
                            result.append(Utils.getJavaDatePickerFormat(messages.lang().locale()).format(recipientData.getMandateSignDate()));
                        }
                        result.append('\t');
                        if (recipientData.getSequenceType() != null) {
                            result.append(recipientData.getSequenceType());
                        }
                        result.append('\t');
                        if (recipient.getSepaMandateId() != null) {
                            result.append(recipient.getSepaMandateId());
                        }
                        result.append('\t');
                        if (recipient.getPurpose() != null) {
                            result.append(recipient.getPurpose());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getCountry() != null) {
                            result.append(recipientData.getAddress().getCountry());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getDepartment() != null) {
                            result.append(recipientData.getAddress().getDepartment());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getSubDepartment() != null) {
                            result.append(recipientData.getAddress().getSubDepartment());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getStreetName() != null) {
                            result.append(recipientData.getAddress().getStreetName());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getBuildingNumber() != null) {
                            result.append(recipientData.getAddress().getBuildingNumber());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getBuildingName() != null) {
                            result.append(recipientData.getAddress().getBuildingName());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getFloor() != null) {
                            result.append(recipientData.getAddress().getFloor());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getTownName() != null) {
                            result.append(recipientData.getAddress().getTownName());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getPostCode() != null) {
                            result.append(recipientData.getAddress().getPostCode());
                        }
                        result.append('\t');
                        if (recipientData.getAddress() != null && recipientData.getAddress().getCountrySubDivision() != null) {
                            result.append(recipientData.getAddress().getCountrySubDivision());
                        }
                        result.append('\t');
                        if (recipientData.getLeiNumber() == null || recipientData.getLeiNumber().isEmpty()) continue block24;
                        result.append(recipientData.getLeiNumber());
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to load SEPA payment recipient!", e);
                    }
                    break;
                }
                case MANDATE: {
                    SepaMandateData sepaMandateData = new SepaMandateData();
                    try {
                        sepaMandateData.setPaymentRecipient(recipient);
                        if (sepaMandateData.getCreditor() != null) {
                            result.append(sepaMandateData.getCreditor());
                        }
                        result.append('\t');
                        if (sepaMandateData.getCreditorId() != null) {
                            result.append(sepaMandateData.getCreditorId());
                        }
                        result.append('\t');
                        if (recipient.getSepaMandateId() != null) {
                            result.append(recipient.getSepaMandateId());
                        }
                        result.append('\t');
                        if (sepaMandateData.getMandateSignDate() != null) {
                            result.append(Utils.getJavaDatePickerFormat(messages.lang().locale()).format(sepaMandateData.getMandateSignDate()));
                        }
                        result.append('\t');
                        if (recipient.getPurpose() != null) {
                            result.append(recipient.getPurpose());
                        }
                        result.append('\t');
                        if (sepaMandateData.getMandateType() != null) {
                            result.append(sepaMandateData.getMandateType().name());
                        }
                        result.append('\t');
                        if (sepaMandateData.getSequenceType() != null) {
                            result.append(sepaMandateData.getSequenceType().name());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getCountry() != null) {
                            result.append(sepaMandateData.getAddress().getCountry());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getDepartment() != null) {
                            result.append(sepaMandateData.getAddress().getDepartment());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getSubDepartment() != null) {
                            result.append(sepaMandateData.getAddress().getSubDepartment());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getStreetName() != null) {
                            result.append(sepaMandateData.getAddress().getStreetName());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getBuildingNumber() != null) {
                            result.append(sepaMandateData.getAddress().getBuildingNumber());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getBuildingName() != null) {
                            result.append(sepaMandateData.getAddress().getBuildingName());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getFloor() != null) {
                            result.append(sepaMandateData.getAddress().getFloor());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getTownName() != null) {
                            result.append(sepaMandateData.getAddress().getTownName());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getPostCode() != null) {
                            result.append(sepaMandateData.getAddress().getPostCode());
                        }
                        result.append('\t');
                        if (sepaMandateData.getAddress() != null && sepaMandateData.getAddress().getCountrySubDivision() != null) {
                            result.append(sepaMandateData.getAddress().getCountrySubDivision());
                        }
                        result.append('\t');
                        if (sepaMandateData.getLeiNumber() == null || sepaMandateData.getLeiNumber().isEmpty()) continue block24;
                        result.append(sepaMandateData.getLeiNumber());
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to load SEPA mandate!", e);
                    }
                    break;
                }
                case DTAZV: {
                    DtazvRecipientData dtazvRecipientData = new DtazvRecipientData();
                    try {
                        dtazvRecipientData.setPaymentRecipient(recipient);
                        if (dtazvRecipientData.getName2() != null) {
                            result.append(dtazvRecipientData.getName2());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getStreet() != null) {
                            result.append(dtazvRecipientData.getStreet());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getTown() != null) {
                            result.append(dtazvRecipientData.getTown());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getCountry() != null) {
                            result.append(dtazvRecipientData.getCountry());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getBankName() != null) {
                            result.append(dtazvRecipientData.getBankName());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getBankName2() != null) {
                            result.append(dtazvRecipientData.getBankName2());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getBankStreet() != null) {
                            result.append(dtazvRecipientData.getBankStreet());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getBankTown() != null) {
                            result.append(dtazvRecipientData.getBankTown());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getBankCountry() != null) {
                            result.append(dtazvRecipientData.getBankCountry());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getPurpose1() != null) {
                            result.append(dtazvRecipientData.getPurpose1());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getPurpose2() != null) {
                            result.append(dtazvRecipientData.getPurpose2());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getPurpose3() != null) {
                            result.append(dtazvRecipientData.getPurpose3());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getPurpose4() != null) {
                            result.append(dtazvRecipientData.getPurpose4());
                        }
                        result.append('\t');
                        if (dtazvRecipientData.getFeeType() == null) continue block24;
                        result.append(dtazvRecipientData.getFeeType());
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to load DTAZV recipient!", e);
                    }
                    break;
                }
                case MT101: {
                    MT101RecipientData mt101RecipientData = new MT101RecipientData();
                    try {
                        mt101RecipientData.setPaymentRecipient(recipient);
                        if (mt101RecipientData.getName2() != null) {
                            result.append(mt101RecipientData.getName2());
                        }
                        result.append('\t');
                        if (mt101RecipientData.getStreet() != null) {
                            result.append(mt101RecipientData.getStreet());
                        }
                        result.append('\t');
                        if (mt101RecipientData.getTown() != null) {
                            result.append(mt101RecipientData.getTown());
                        }
                        result.append('\t');
                        if (mt101RecipientData.getPurpose1() != null) {
                            result.append(mt101RecipientData.getPurpose1());
                        }
                        result.append('\t');
                        if (mt101RecipientData.getPurpose2() != null) {
                            result.append(mt101RecipientData.getPurpose2());
                        }
                        result.append('\t');
                        if (mt101RecipientData.getPurpose3() != null) {
                            result.append(mt101RecipientData.getPurpose3());
                        }
                        result.append('\t');
                        if (mt101RecipientData.getPurpose4() != null) {
                            result.append(mt101RecipientData.getPurpose4());
                        }
                        result.append('\t');
                        if (mt101RecipientData.getFeeType() != null) {
                            result.append(mt101RecipientData.getFeeType());
                        }
                        result.append('\t');
                        if (mt101RecipientData.getFeeType() == null) continue block24;
                        result.append(mt101RecipientData.getIntermediaryBankCode());
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to load MT101 recipient!", e);
                    }
                    break;
                }
                case AUSTRIAN_POSTBAR: {
                    PostbarRecipientData postbarRecipientData = new PostbarRecipientData();
                    try {
                        postbarRecipientData.setPaymentRecipient(recipient);
                        if (postbarRecipientData.getAddress1() != null) {
                            result.append(postbarRecipientData.getAddress1());
                        }
                        result.append('\t');
                        if (postbarRecipientData.getAddress2() != null) {
                            result.append(postbarRecipientData.getAddress2());
                        }
                        result.append('\t');
                        if (postbarRecipientData.getPlz() != null) {
                            result.append(postbarRecipientData.getPlz());
                        }
                        result.append('\t');
                        result.append(!postbarRecipientData.isForward());
                        result.append('\t');
                        result.append(postbarRecipientData.isInPerson());
                        result.append('\t');
                        if (postbarRecipientData.getPayOffMode() != null) {
                            result.append(postbarRecipientData.getPayOffMode().name());
                        }
                        result.append('\t');
                        if (postbarRecipientData.getSmsNumber() != null) {
                            result.append(postbarRecipientData.getSmsNumber());
                        }
                        result.append('\t');
                        if (postbarRecipientData.getPostPlz() != null) {
                            result.append(postbarRecipientData.getPostPlz());
                        }
                        result.append('\t');
                        if (recipient.getPurpose() != null) {
                            result.append(recipient.getPurpose());
                        }
                        result.append('\t');
                        if (recipient.getReference() == null) continue block24;
                        result.append(recipient.getReference());
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to load Postbar recipient!", e);
                    }
                    break;
                }
                case SEPA_FOREIGN: {
                    SepaForeignRecipientData sepaforeignRecipientData = new SepaForeignRecipientData();
                    try {
                        String country = "";
                        String recipientIban = "";
                        String clearingSystem = "";
                        String recipientBic = "";
                        String bankName = "";
                        String bankCountry = "";
                        String purpose = "";
                        String dept = "";
                        String subDept = "";
                        String street = "";
                        String buildingNumber = "";
                        String buildingName = "";
                        String floor = "";
                        String town = "";
                        String postCode = "";
                        String subCountry = "";
                        String bankDept = "";
                        String bankSubDebt = "";
                        String bankStreet = "";
                        String bankBuildingNumber = "";
                        String bankBuildingName = "";
                        String bankFloor = "";
                        String bankTown = "";
                        String bankPostCode = "";
                        String bankSubCountry = "";
                        sepaforeignRecipientData.setPaymentRecipient(recipient);
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getCountry() != null) {
                            country = sepaforeignRecipientData.getAddress().getCountry();
                        }
                        if (sepaforeignRecipientData.getAccountNumber() != null) {
                            recipientIban = sepaforeignRecipientData.getAccountNumber();
                        }
                        if (sepaforeignRecipientData.getClearingSystemId() != null) {
                            clearingSystem = sepaforeignRecipientData.getClearingSystemId();
                        }
                        if (sepaforeignRecipientData.getBankCode() != null) {
                            recipientBic = sepaforeignRecipientData.getBankCode();
                        }
                        if (sepaforeignRecipientData.getBankName() != null) {
                            bankName = sepaforeignRecipientData.getBankName();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getCountry() != null) {
                            bankCountry = sepaforeignRecipientData.getBankAddress().getCountry();
                        }
                        if (recipient.getPurpose() != null) {
                            purpose = recipient.getPurpose();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getDepartment() != null) {
                            dept = sepaforeignRecipientData.getAddress().getDepartment();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getSubDepartment() != null) {
                            subDept = sepaforeignRecipientData.getAddress().getSubDepartment();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getStreetName() != null) {
                            street = sepaforeignRecipientData.getAddress().getStreetName();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getBuildingNumber() != null) {
                            buildingNumber = sepaforeignRecipientData.getAddress().getBuildingNumber();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getBuildingName() != null) {
                            buildingName = sepaforeignRecipientData.getAddress().getBuildingName();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getFloor() != null) {
                            floor = sepaforeignRecipientData.getAddress().getFloor();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getTownName() != null) {
                            town = sepaforeignRecipientData.getAddress().getTownName();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getPostCode() != null) {
                            postCode = sepaforeignRecipientData.getAddress().getPostCode();
                        }
                        if (sepaforeignRecipientData.getAddress() != null && sepaforeignRecipientData.getAddress().getCountrySubDivision() != null) {
                            subCountry = sepaforeignRecipientData.getAddress().getCountrySubDivision();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getDepartment() != null) {
                            bankDept = sepaforeignRecipientData.getBankAddress().getDepartment();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getSubDepartment() != null) {
                            bankSubDebt = sepaforeignRecipientData.getBankAddress().getSubDepartment();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getStreetName() != null) {
                            bankStreet = sepaforeignRecipientData.getBankAddress().getStreetName();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getBuildingNumber() != null) {
                            bankBuildingNumber = sepaforeignRecipientData.getBankAddress().getBuildingNumber();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getBuildingName() != null) {
                            bankBuildingName = sepaforeignRecipientData.getBankAddress().getBuildingName();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getFloor() != null) {
                            bankFloor = sepaforeignRecipientData.getBankAddress().getFloor();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getTownName() != null) {
                            bankTown = sepaforeignRecipientData.getBankAddress().getTownName();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getPostCode() != null) {
                            bankPostCode = sepaforeignRecipientData.getBankAddress().getPostCode();
                        }
                        if (sepaforeignRecipientData.getBankAddress() != null && sepaforeignRecipientData.getBankAddress().getCountrySubDivision() != null) {
                            bankSubCountry = sepaforeignRecipientData.getBankAddress().getCountrySubDivision();
                        }
                        result.append(country).append('\t');
                        result.append(recipientIban).append('\t');
                        result.append(clearingSystem).append('\t');
                        result.append(recipientBic).append('\t');
                        result.append(bankName).append('\t');
                        result.append(bankCountry).append('\t');
                        result.append(purpose).append('\t');
                        result.append(dept).append('\t');
                        result.append(subDept).append('\t');
                        result.append(street).append('\t');
                        result.append(buildingNumber).append('\t');
                        result.append(buildingName).append('\t');
                        result.append(floor).append('\t');
                        result.append(town).append('\t');
                        result.append(postCode).append('\t');
                        result.append(subCountry).append('\t');
                        result.append(bankDept).append('\t');
                        result.append(bankSubDebt).append('\t');
                        result.append(bankStreet).append('\t');
                        result.append(bankBuildingNumber).append('\t');
                        result.append(bankBuildingName).append('\t');
                        result.append(bankFloor).append('\t');
                        result.append(bankTown).append('\t');
                        result.append(bankPostCode).append('\t');
                        result.append(bankSubCountry);
                        if (sepaforeignRecipientData.getFeeType() == null) continue block24;
                        result.append(sepaforeignRecipientData.getFeeType());
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to load Foreign SEPA recipient!", e);
                    }
                    break;
                }
                case CHEQUE: {
                    ChequeRecipientData chequeRecipientData = new ChequeRecipientData();
                    try {
                        chequeRecipientData.setPaymentRecipient(recipient);
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getDepartment() != null) {
                            result.append(chequeRecipientData.getAddress().getDepartment());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getSubDepartment() != null) {
                            result.append(chequeRecipientData.getAddress().getSubDepartment());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getStreetName() != null) {
                            result.append(chequeRecipientData.getAddress().getStreetName());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getBuildingNumber() != null) {
                            result.append(chequeRecipientData.getAddress().getBuildingNumber());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getBuildingName() != null) {
                            result.append(chequeRecipientData.getAddress().getBuildingName());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getFloor() != null) {
                            result.append(chequeRecipientData.getAddress().getFloor());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getTownName() != null) {
                            result.append(chequeRecipientData.getAddress().getTownName());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getPostCode() != null) {
                            result.append(chequeRecipientData.getAddress().getPostCode());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getCountrySubDivision() != null) {
                            result.append(chequeRecipientData.getAddress().getCountrySubDivision());
                        }
                        result.append('\t');
                        if (chequeRecipientData.getAddress() != null && chequeRecipientData.getAddress().getCountry() != null) {
                            result.append(chequeRecipientData.getAddress().getCountry());
                        }
                        result.append('\t');
                        if (recipient.getPurpose() == null) continue block24;
                        result.append(recipient.getPurpose());
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to load SEPA mandate!", e);
                    }
                    break;
                }
            }
        }
        if (!paymentTypes.isEmpty() && paymentTypes.contains(PaymentType.AUSTRIAN_TAX_OFFICE)) {
            int count2 = 0;
            int diff = 10 - count;
            if (diff > 0) {
                count2 -= diff - 5;
            }
            ArrayList list = new ArrayList();
            KnownTaxOfficeRecipient.getKnownRecipients().stream().filter(r -> r.getName().contains(searchString) || r.getIban().contains(searchString)).forEach(list::add);
            for (KnownTaxOfficeRecipient recipient2 : list) {
                if (count2++ >= 5) break;
                if (!result.isEmpty()) {
                    result.append('\n');
                }
                result.append('\t');
                result.append(PaymentType.AUSTRIAN_TAX_OFFICE.name()).append('\t');
                result.append(recipient2.getName()).append('\t');
                result.append(recipient2.getName()).append('\t');
                if (recipient2.getIban() != null) {
                    result.append(recipient2.getIban());
                }
                result.append('\t');
                result.append('\t');
            }
        }
        byte[] resultData = result.toString().getBytes(StandardCharsets.UTF_8);
        return Payments.ok((byte[])resultData);
    }

    public Result findGermanBankcodes(String searchString) {
        StringBuilder resultBuilder = new StringBuilder();
        if (BLZCache.CACHE == null) {
            BLZCache.initialize((File)Util.WORKSPACEDIR, (BLLogger)BLLoggerPlay.getLogger());
        }
        int count = 0;
        for (BankInfo info : BLZCache.CACHE.getAllBankInfos()) {
            if (!resultBuilder.isEmpty()) {
                resultBuilder.append('\n');
            }
            if (info.getBankCode() == null || searchString != null && !searchString.isEmpty() && !info.getBankCode().startsWith(searchString)) continue;
            resultBuilder.append(info.getBankCode()).append(" - ").append(info.getName());
            if (count++ < 9) continue;
            break;
        }
        return Payments.ok((String)resultBuilder.toString());
    }

    public Result saveAsOpenPayments(Http.Request request, String paymentContextTypeString) {
        return this.saveAsOpenPaymentsOrPayment(request, null, paymentContextTypeString);
    }

    public Result saveAsOpenPayment(Http.Request request, Integer id, String paymentContextTypeString) {
        return this.saveAsOpenPaymentsOrPayment(request, id, paymentContextTypeString);
    }

    private Result saveAsOpenPaymentsOrPayment(Http.Request request, Integer id, String paymentContextTypeString) {
        play.api.mvc.Call nextOperation;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        String paymentIdsString = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        PaymentContextType paymentContextType = Payments.readPaymentContext(paymentContextTypeString);
        if (paymentContextType == PaymentContextType.SIGNED_PAYMENT) {
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_SIGNED);
            sorting.setProperty(PROPS_SELECTION, paymentIdsString);
            nextOperation = id != null ? routes.SignedPayments.payment(id, null) : routes.SignedPayments.index(true);
        } else {
            BLLoggerPlay.error("Invalid payment type for saving as payment template: " + paymentContextTypeString);
            return Payments.notFound();
        }
        List<Integer> paymentIds = GeneralUtils.getSelectionIds(paymentIdsString);
        if (paymentIds.isEmpty()) {
            return Payments.redirect((Call)nextOperation).flashing("error", messages.at("payment.error.nopaymentsselected", new Object[0]));
        }
        ArrayList<SaveAsOpenPaymentParameters> toSave = new ArrayList<SaveAsOpenPaymentParameters>();
        List selectedSignedPayments = SignedPayments.getQueryCheckPermission(user).where().in("id", paymentIds).findList();
        int numberOfPaymentsWithoutBankUser = paymentIds.size() - selectedSignedPayments.size();
        if (numberOfPaymentsWithoutBankUser > 0) {
            Utils.addToFlash(flashMap, "warning", messages.at("payment.error.noBankUser", new Object[]{numberOfPaymentsWithoutBankUser}));
        }
        int numberOfDeactivatedPayments = 0;
        for (SignedPayment signedPayment : selectedSignedPayments) {
            BankUser bankUser = BankUser.findBankUser((BankSettings)signedPayment.getAccount().getBank(), (User)user);
            if (bankUser != null && bankUser.isDeactivated()) {
                ++numberOfDeactivatedPayments;
                continue;
            }
            toSave.add(new SaveAsOpenPaymentParameters(signedPayment));
        }
        if (numberOfDeactivatedPayments > 0) {
            Utils.addToFlash(flashMap, "warning", messages.at("payment.error.deactivated", new Object[]{numberOfDeactivatedPayments}));
        }
        if (toSave.isEmpty()) {
            Utils.addToFlash(flashMap, "error", messages.at("openpayments.error.failedtocreate", new Object[]{paymentIds.size()}));
            return Payments.redirect((Call)nextOperation).flashing(flashMap);
        }
        Form form = this.formFactory.form(SimpleSelectionForm.class).bindFromRequest(request, new String[0]);
        PaymentFolder folder = null;
        if (!form.hasErrors() && ((SimpleSelectionForm)form.get()).id != null && ((SimpleSelectionForm)form.get()).id >= 0 && (folder = PaymentFolder.findById((Integer)((SimpleSelectionForm)form.get()).id, (User)user)) == null) {
            form = form.withError("id", messages.at("payment.error.unknownfolder", new Object[0]));
        }
        if (form.hasErrors()) {
            return Payments.redirect((Call)nextOperation).flashing("error", messages.at("payment.open.invalidparameters", new Object[]{paymentIds.size()}));
        }
        boolean importSalaries = Util.importSalaries((User)user);
        int counter = 0;
        for (SaveAsOpenPaymentParameters params : toSave) {
            try {
                PaymentHandler<?> handler = PaymentHandler.getHandler(params.getPmtType(), params.getPaymentData());
                if (!importSalaries && params.isSalaryAmount()) continue;
                OpenPayment openPayment = handler.createOpenPayment(params.getBankSettings(), params.getPmtType(), folder, true);
                openPayment.save(user, false);
                Logger.logOpenPaymentCreated((User)user, (OpenPayment)openPayment);
                ++counter;
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to modify payments!", e);
                Utils.addToFlash(flashMap, "HTMLerror", messages.at("payment.error.failedtocreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }
        if (counter == 0) {
            Utils.addToFlash(flashMap, "warning", messages.at("payment.open.created", new Object[]{counter}));
        } else {
            Utils.addToFlash(flashMap, "success", messages.at("payment.open.created", new Object[]{counter}));
        }
        return Payments.redirect((Call)nextOperation).flashing(flashMap);
    }

    public Result saveAsPeriodicPayment(Http.Request request, Integer paymentId, String paymentContextTypeString) {
        HashMap<String, String> flashMap;
        play.api.mvc.Call redirectTo;
        block22: {
            PaymentFolder folder;
            byte[] paymentData;
            PaymentTransferType.PmtType pmtType;
            BankSettings bankSettings;
            Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            PaymentContextType paymentContextType = Payments.readPaymentContext(paymentContextTypeString);
            if (paymentContextType == PaymentContextType.OPEN_TO_PERIODIC_PAYMENT) {
                sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
                sorting.setProperty(PROPS_SELECTION, String.valueOf(paymentId));
                redirectTo = routes.OpenPayments.index(true);
                OpenPayment openPayment = (OpenPayment)OpenPayments.getQueryCheckPermission(user).where().eq("id", (Object)paymentId).findOne();
                if (openPayment == null) {
                    return Payments.redirect((Call)redirectTo).flashing("error", messages.at("payment.periodic.paymentnotfound", new Object[0]));
                }
                bankUser = BankUser.findBankUser((BankSettings)openPayment.getBank(), (User)user);
                if (bankUser != null && bankUser.isDeactivated()) {
                    return Payments.redirect((Call)redirectTo).flashing("error", messages.at("openpayments.error.deactivated", new Object[0]));
                }
                bankSettings = openPayment.getBank();
                pmtType = openPayment.getPmtType();
                paymentData = openPayment.getPaymentData();
                folder = openPayment.getFolder();
            } else if (paymentContextType == PaymentContextType.SIGNED_TO_PERIODIC_PAYMENT) {
                sorting = new SortingHandler(user, Sorting.Table.PMT_SIGNED);
                sorting.setProperty(PROPS_SELECTION, String.valueOf(paymentId));
                redirectTo = routes.SignedPayments.index(true);
                SignedPayment signedPayment = (SignedPayment)SignedPayments.getQueryCheckPermission(user).where().eq("id", (Object)paymentId).findOne();
                if (signedPayment == null) {
                    return Payments.redirect((Call)redirectTo).flashing("error", messages.at("payment.periodic.paymentnotfound", new Object[0]));
                }
                bankUser = BankUser.findBankUser((BankSettings)signedPayment.getAccount().getBank(), (User)user);
                if (bankUser != null && bankUser.isDeactivated()) {
                    return Payments.redirect((Call)redirectTo).flashing("error", messages.at("payment.error.deactivated", new Object[]{1}));
                }
                bankSettings = signedPayment.getSend().getBank();
                pmtType = signedPayment.getPmtType();
                paymentData = signedPayment.getPaymentData();
                folder = null;
            } else {
                BLLoggerPlay.error("Invalid payment context type for saving as periodic payment: " + paymentContextTypeString);
                return Payments.redirect((Call)routes.PeriodicPayments.index(false)).flashing("error", "Invalid payment context type for saving as periodic payment: " + paymentContextTypeString);
            }
            Form form = this.formFactory.form(PeriodicParametersForm.class).bindFromRequest(request, new String[0]);
            java.sql.Date firstExecution = null;
            java.sql.Date previousExecution = null;
            java.sql.Date nextExecution = null;
            java.sql.Date lastExecution = null;
            PeriodicPayment.ExecutionInterval executionInterval = null;
            if (!form.hasErrors()) {
                if (((PeriodicParametersForm)form.get()).firstExecution != null) {
                    firstExecution = new java.sql.Date(((PeriodicParametersForm)form.get()).firstExecution.getTime());
                }
                if (((PeriodicParametersForm)form.get()).previousExecution != null) {
                    previousExecution = new java.sql.Date(((PeriodicParametersForm)form.get()).previousExecution.getTime());
                }
                if (((PeriodicParametersForm)form.get()).nextExecution != null) {
                    nextExecution = new java.sql.Date(((PeriodicParametersForm)form.get()).nextExecution.getTime());
                }
                if (((PeriodicParametersForm)form.get()).lastExecution != null) {
                    lastExecution = new java.sql.Date(((PeriodicParametersForm)form.get()).lastExecution.getTime());
                }
                if (((PeriodicParametersForm)form.get()).executionInterval != null) {
                    executionInterval = PeriodicPayment.ExecutionInterval.valueOf((String)((PeriodicParametersForm)form.get()).executionInterval);
                }
                if (firstExecution == null) {
                    form = form.withError("firstExecution", messages.at("error.required", new Object[0]));
                }
                if (nextExecution == null) {
                    form = form.withError("nextExecution", messages.at("error.required", new Object[0]));
                }
                if (executionInterval == null) {
                    form = form.withError("executionInterval", messages.at("error.required", new Object[0]));
                }
            }
            flashMap = new HashMap<String, String>();
            if (!form.hasErrors()) {
                try {
                    PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(pmtType, paymentData);
                    if (paymentHandler.isSalaryPayment() && !Util.displaySalaries((User)user)) {
                        flashMap.put("error", messages.at("payment.template.nosalarypermission", new Object[0]));
                        break block22;
                    }
                    PeriodicPayment periodicPayment = paymentHandler.createPeriodicPayment(bankSettings, pmtType, folder, false);
                    periodicPayment.setFirstExecutionDate(firstExecution);
                    periodicPayment.setPreviousExecutionDate(previousExecution);
                    periodicPayment.setNextExecutionDate(nextExecution);
                    periodicPayment.setLastExecutionDate(lastExecution);
                    periodicPayment.setExecutionInterval(executionInterval);
                    periodicPayment.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
                    Logger.logPeriodicPaymentCreated((User)user, (PeriodicPayment)periodicPayment);
                    flashMap.put("success", messages.at("periodicpayments.created", new Object[0]));
                }
                catch (PaymentException e) {
                    flashMap.put("HTMLerror", messages.at("payment.periodic.creationfailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                }
            } else {
                flashMap.put("error", messages.at("payment.periodic.invalidparameters", new Object[0]));
            }
        }
        return Payments.redirect((Call)redirectTo).flashing(flashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result saveAsPaymentTemplate(Http.Request request, Integer paymentId, String paymentContextTypeString) {
        String templateName;
        PaymentFolder folder;
        byte[] paymentData;
        PaymentTransferType.PmtType pmtType;
        Tenant tenant;
        BankSettings bankSettings;
        play.api.mvc.Call redirectTo;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentContextType paymentContextType = Payments.readPaymentContext(paymentContextTypeString);
        if (paymentContextType == PaymentContextType.OPEN_PAYMENT) {
            redirectTo = routes.OpenPayments.index(true);
            sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
            sorting.setProperty(PROPS_SELECTION, String.valueOf(paymentId));
            OpenPayment openPayment = (OpenPayment)OpenPayments.getQueryCheckPermission(user).where().eq("id", (Object)paymentId).findOne();
            if (openPayment == null) {
                return Payments.redirect((Call)redirectTo).flashing("error", messages.at("payment.template.paymentnotfound", new Object[0]));
            }
            bankUser = BankUser.findBankUser((BankSettings)openPayment.getAccount().getBank(), (User)user);
            if (bankUser != null && bankUser.isDeactivated()) {
                return Payments.redirect((Call)redirectTo).flashing("error", messages.at("openpayments.error.deactivated", new Object[0]));
            }
            bankSettings = openPayment.getBank();
            tenant = bankSettings.getTenant();
            pmtType = openPayment.getPmtType();
            paymentData = openPayment.getPaymentData();
            folder = openPayment.getFolder();
        } else if (paymentContextType == PaymentContextType.SIGNED_PAYMENT) {
            redirectTo = routes.SignedPayments.index(true);
            sorting = new SortingHandler(user, Sorting.Table.PMT_SIGNED);
            sorting.setProperty(PROPS_SELECTION, String.valueOf(paymentId));
            SignedPayment signedPayment = (SignedPayment)SignedPayments.getQueryCheckPermission(user).where().eq("id", (Object)paymentId).findOne();
            if (signedPayment == null) {
                return Payments.redirect((Call)redirectTo).flashing("error", messages.at("payment.template.paymentnotfound", new Object[0]));
            }
            bankUser = BankUser.findBankUser((BankSettings)signedPayment.getAccount().getBank(), (User)user);
            if (bankUser != null && bankUser.isDeactivated()) {
                return Payments.redirect((Call)redirectTo).flashing("error", messages.at("payment.error.deactivated", new Object[]{1}));
            }
            bankSettings = signedPayment.getSend().getBank();
            tenant = bankSettings.getTenant();
            pmtType = signedPayment.getPmtType();
            paymentData = signedPayment.getPaymentData();
            folder = signedPayment.getFolder();
        } else {
            BLLoggerPlay.error("Invalid payment type for saving as payment template: " + paymentContextTypeString);
            return Payments.notFound();
        }
        Form form = this.formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
        String errorMessage = null;
        if (!form.hasErrors()) {
            templateName = ((SimpleTextForm)form.get()).text;
            if (templateName == null || templateName.isEmpty()) {
                errorMessage = messages.at("error.required", new Object[0]);
            } else if (templateName.length() > 80) {
                templateName = templateName.substring(0, 80);
            }
            if (!form.hasErrors() && PaymentTemplate.findTemplateByNameAndTenant((String)templateName, (Tenant)tenant) != null) {
                errorMessage = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]);
            }
        } else {
            templateName = null;
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (errorMessage == null && !form.hasErrors()) {
            try {
                PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(pmtType, paymentData);
                if (paymentHandler.isSalaryPayment() && !Util.displaySalaries((User)user)) {
                    flashMap.put("error", messages.at("payment.template.nosalarypermission", new Object[0]));
                }
                PaymentHandler.USED_TEMPLATE_NAMES.clear();
                PaymentTemplate template = paymentHandler.createPaymentTemplate(bankSettings, pmtType, templateName, folder);
                template.save();
                Logger.logPaymentTemplateCreated((User)user, (PaymentTemplate)template);
                flashMap.put("success", messages.at("paymenttemplates.created", new Object[0]));
            }
            catch (PaymentException e) {
                flashMap.put("HTMLerror", messages.at("payment.template.creationfailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
            finally {
                PaymentHandler.USED_TEMPLATE_NAMES.clear();
            }
        } else if (errorMessage != null) {
            flashMap.put("error", errorMessage);
        } else {
            flashMap.put("error", messages.at("payment.template.invalidparameters", new Object[0]));
        }
        return Payments.redirect((Call)redirectTo).flashing(flashMap);
    }

    public Result importForm(Http.Request request, String paymentContextTypeName) {
        PaymentContextType paymentContext = Payments.readPaymentContext(paymentContextTypeName);
        if (Branding.getBranding().hidePaymentImport()) {
            return Payments.redirect((Call)Payments.getRedirectTarget(paymentContext, false)).flashing("warning", BankingApiMessages.getString((Locale)this.messagesApi.preferred((Http.RequestHeader)request).lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentImportForm paymentImportForm = new PaymentImportForm();
        paymentImportForm.paymentContextTypeName = paymentContextTypeName;
        Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_OPEN);
        if (sorting != null) {
            try {
                int folderId = Integer.parseInt(GeneralUtils.getSortingProperties(sorting).getProperty(PROPS_FOLDER, "-1"));
                if (folderId >= 0) {
                    paymentImportForm.folderId = folderId;
                }
            }
            catch (NumberFormatException e) {
                BLLoggerPlay.warning("Failed to load folder ID for user " + user.getName(), e);
            }
        }
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        paymentImportForm.saveRecipient = PreferenceUtil.allowUnrestrictedRecipientRecording((User)user);
        if (paymentImportForm.saveRecipient) {
            paymentImportForm.saveRecipient = store.getBoolean((DatabasePreferenceConstant)PreferenceConstants.SAVE_RECIPIENT);
        }
        paymentImportForm.saveOriginator = store.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        return Payments.ok((Content)paymentimport.render((Form<PaymentImportForm>)this.formFactory.form(PaymentImportForm.class).fill((Object)paymentImportForm), paymentContext, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> importPayment(Http.Request request) {
        File csvFile;
        Form form = this.formFactory.form(PaymentImportForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentContextType paymentContext = Payments.readPaymentContext(((PaymentImportForm)form.get()).paymentContextTypeName);
        String referer = Utils.getHeaderValue(request, "referer");
        String redirectTo = referer == null || referer.contains("prepareorders") ? routes.DesOverview.index().toString() : referer;
        HashSet<String> errorMessages = new HashSet<String>();
        boolean importCsv = "CSV_FILE".equals(((PaymentImportForm)form.get()).fileFormat);
        boolean isEdsImport = false;
        HashMap<File, PaymentTransferType.PmtType> filePmtTypes = new HashMap<File, PaymentTransferType.PmtType>();
        HashMap<File, Integer> fileBankIds = new HashMap<File, Integer>();
        ArrayList<File> files = new ArrayList<File>();
        if (request.body().asMultipartFormData() != null) {
            try {
                Http.MultipartFormData csvFileFormData = request.body().asMultipartFormData();
                Http.MultipartFormData.FilePart csvFilePart = csvFileFormData.getFile("import_payment_file");
                csvFile = ((Files.DelegateTemporaryFile)csvFilePart.getRef()).path().toFile();
                Http.MultipartFormData fileFormData = request.body().asMultipartFormData();
                List fileParts = fileFormData.getFiles();
                Iterator iterator = fileParts.iterator();
                while (iterator.hasNext()) {
                    Http.MultipartFormData.FilePart part = (Http.MultipartFormData.FilePart)iterator.next();
                    File file2 = ((Files.TemporaryFile)part.getRef()).path().toFile();
                    if (file2.length() <= 0L) continue;
                    files.add(file2);
                }
            }
            catch (Exception e) {
                Form formWithError = form.withError("import_payment_file", messages.at("payment.import.failed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                if (importCsv) {
                    formWithError = formWithError.withError("encoding", messages.at("payment.import.checkEncoding", new Object[0]));
                }
                return CompletableFuture.completedFuture(Payments.ok((Content)paymentimport.render((Form<PaymentImportForm>)formWithError, paymentContext, request, messages)));
            }
        } else {
            csvFile = null;
            String orderIds = ((PaymentImportForm)form.get()).orderIds;
            List desOrders = null;
            List<Integer> idsList = GeneralUtils.getSelectionIds(orderIds);
            if (!idsList.isEmpty()) {
                for (BankUser bankUser : BankUser.findBanksForUser((User)user)) {
                    if (bankUser.getState() != BankUser.UserState.READY || !DsBank.get((BankSettings)bankUser.getBank()).isActivated()) continue;
                    if (desOrders == null) {
                        desOrders = DsOpenOrder.queryForBankUser((BankUser)bankUser).where().in("id", idsList).findList();
                        continue;
                    }
                    desOrders.addAll(DsOpenOrder.queryForBankUser((BankUser)bankUser).where().in("id", idsList).findList());
                }
            }
            if (desOrders != null && !desOrders.isEmpty()) {
                Iterator iterator = desOrders.iterator();
                while (iterator.hasNext()) {
                    DsOpenOrder order = (DsOpenOrder)iterator.next();
                    String permissionError = DesOverview.checkOrderPermission(user, order, messages);
                    if (permissionError != null) {
                        errorMessages.add(permissionError);
                        iterator.remove();
                        continue;
                    }
                    if (order.getOrderData() == null) {
                        iterator.remove();
                        continue;
                    }
                    File file3 = WorkspaceFileSystem.toFile((WorkspaceFile)order.getOrderData());
                    files.add(file3);
                    filePmtTypes.put(file3, order.getPmtType());
                    fileBankIds.put(file3, order.getBankUser().getBank().getBankId());
                }
                isEdsImport = true;
            }
        }
        if (!importCsv && files.isEmpty()) {
            if (isEdsImport) {
                HashMap<String, String> flashMap = new HashMap<String, String>();
                Utils.addToFlash(flashMap, "error", messages.at("payment.import.failed", new Object[]{""}));
                for (String errorMsg : errorMessages) {
                    Utils.addToFlash(flashMap, "error", errorMsg);
                }
                return CompletableFuture.completedFuture(Payments.redirect((Call)routes.DesOverview.index()).flashing(flashMap));
            }
            return CompletableFuture.completedFuture(Payments.ok((Content)paymentimport.render((Form<PaymentImportForm>)form.withError("import_payment_file", messages.at("payment.import.failed", new Object[]{""})), paymentContext, request, messages)));
        }
        boolean finalIsEdsImport = isEdsImport;
        return CompletableFuture.supplyAsync(() -> {
            Form<PaymentImportForm> validatedForm;
            if (Branding.getBranding().hidePaymentImport()) {
                return Payments.redirect((Call)Payments.getRedirectTarget(paymentContext, false)).flashing("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
            }
            HashMap<String, String> flashMap = new HashMap<String, String>();
            if (!finalIsEdsImport) {
                validatedForm = ((PaymentImportForm)form.get()).validate(form, messages, csvFile, user);
                if (validatedForm.hasErrors()) {
                    return Payments.ok((Content)paymentimport.render(validatedForm, paymentContext, request, messages));
                }
            } else {
                validatedForm = form;
            }
            if (importCsv) {
                Result dataMap;
                try {
                    PaymentCsvImportForm importForm = new PaymentCsvImportForm();
                    dataMap = new HashMap();
                    ((PaymentImportForm)validatedForm.get()).prepareForCsv(csvFile, user);
                    ConverterFormat converterFormat = ((PaymentImportForm)validatedForm.get()).getConverterFormat();
                    Integer converterFormatId = converterFormat == null ? -1 : converterFormat.getId();
                    String[][] content = importForm.loadFromCsv(user, csvFile, ((PaymentImportForm)validatedForm.get()).getPmtType(), paymentContext, (Map<String, String>)dataMap, ((PaymentImportForm)validatedForm.get()).getPaymentConversionHandler(), ((PaymentImportForm)validatedForm.get()).getPaymentConversionHandler2(), converterFormat, ((PaymentImportForm)validatedForm.get()).encoding);
                    if (content != null && content.length > 0) {
                        DynamicForm csvForm = this.formFactory.form().bind((Lang)request.acceptLanguages().getFirst(), request.attrs(), (Map)dataMap, new String[0]);
                        String fileId = CsvImport.writeDataToFile(content);
                        Result result = Payments.ok((Content)paymentcsvimport.render((Form<DynamicForm.Dynamic>)csvForm, paymentContext, importForm.getColumnFields(messages), content, ((PaymentImportForm)validatedForm.get()).bankId, ((PaymentImportForm)validatedForm.get()).getPmtType(), ((PaymentImportForm)validatedForm.get()).folderId, ((PaymentImportForm)validatedForm.get()).templateName, Utils.getDatePickerFormattedDate(messages.lang().locale(), ((PaymentImportForm)validatedForm.get()).firstExecution), Utils.getDatePickerFormattedDate(messages.lang().locale(), ((PaymentImportForm)validatedForm.get()).nextExecution), Utils.getDatePickerFormattedDate(messages.lang().locale(), ((PaymentImportForm)validatedForm.get()).lastExecution), ((PaymentImportForm)validatedForm.get()).executionInterval, ((PaymentImportForm)validatedForm.get()).saveRecipient, ((PaymentImportForm)validatedForm.get()).saveOriginator, converterFormatId, fileId, ((PaymentImportForm)validatedForm.get()).encoding, request, messages));
                        return result;
                    }
                    Result csvForm = Payments.ok((Content)paymentimport.render((Form<PaymentImportForm>)validatedForm.withError("import_payment_file", messages.at("payment.import.failed", new Object[]{"file content is empty."})).withError("encoding", messages.at("payment.import.checkEncoding", new Object[0])), paymentContext, request, messages));
                    return csvForm;
                }
                catch (Throwable t) {
                    BLLoggerPlay.error("Failed to load payment data from CSV file!", t);
                    dataMap = Payments.ok((Content)paymentimport.render((Form<PaymentImportForm>)validatedForm.withError("import_payment_file", messages.at("payment.import.failed", new Object[]{Utils.getLocalizedMessage(t, messages)})).withError("encoding", messages.at("payment.import.checkEncoding", new Object[0])), paymentContext, request, messages));
                    return dataMap;
                }
                finally {
                    if (csvFile != null && !csvFile.delete()) {
                        BLLoggerPlay.warning("Failed to delete temporary CSV payment file " + csvFile.getAbsolutePath() + "!");
                        csvFile.deleteOnExit();
                    }
                }
            }
            int numberOfImportedPayments = 0;
            int numberOfIgnoredPayments = 0;
            for (File file2 : files) {
                Integer bankId;
                PaymentTransferType.PmtType pt;
                if (!filePmtTypes.isEmpty()) {
                    pt = (PaymentTransferType.PmtType)filePmtTypes.get(file2);
                    bankId = (Integer)fileBankIds.get(file2);
                } else {
                    pt = ((PaymentImportForm)form.get()).getPmtType();
                    bankId = ((PaymentImportForm)form.get()).bankId;
                }
                try {
                    ((PaymentImportForm)validatedForm.get()).importPaymentFile(messages, file2, user, pt, bankId, errorMessages);
                    numberOfImportedPayments = ((PaymentImportForm)validatedForm.get()).savePayment(user);
                    numberOfIgnoredPayments = ((PaymentImportForm)validatedForm.get()).getIgnoredPayments();
                    try {
                        new BankOrder(BankUser.findBankUser((BankSettings)BankSettings.getById((Integer)bankId), (User)user), pt, file2, null, new DirectoryScanner(), messages.lang().toLocale());
                    }
                    catch (KnownFormatException e) {
                        String message = Utils.getLocalizedMessage(e, messages);
                        if (message == null) continue;
                        Utils.addToFlash(flashMap, "HTMLwarning", messages.at("payment.import.warning", new Object[]{message}));
                    }
                    catch (Exception e) {
                    }
                }
                catch (Exception e) {
                    Object errorMsg = Utils.getLocalizedMessage(e, messages);
                    if (e instanceof NoSuchFileException) {
                        errorMsg = "File not found: " + (String)errorMsg;
                    }
                    Utils.addToFlash(flashMap, "HTMLerror", messages.at("payment.csv.error.failed", new Object[]{errorMsg}));
                    BLLoggerPlay.error("Failed to import file!", e);
                }
            }
            for (String errorMsg : errorMessages) {
                Utils.addToFlash(flashMap, "error", errorMsg);
            }
            String flashKey = numberOfImportedPayments == 0 || numberOfIgnoredPayments > 0 ? "warning" : "success";
            String message = switch (paymentContext) {
                case PaymentContextType.PAYMENT_TEMPLATE -> "payment.importedtemplates";
                case PaymentContextType.PERIODIC_PAYMENT -> "periodicpayments.import.done";
                default -> "payment.importedpayments";
            };
            Utils.addToFlash(flashMap, flashKey, messages.at(message, new Object[]{numberOfImportedPayments, numberOfIgnoredPayments}));
            if (finalIsEdsImport) {
                return Payments.redirect((String)redirectTo).flashing(flashMap);
            }
            return Payments.redirect((Call)Payments.getRedirectTarget(paymentContext, false)).flashing(flashMap);
        }, this.executionContext.current());
    }

    public CompletionStage<Result> importCsvPayment(Http.Request request, String paymentContextTypeName, Integer bankId, String pmtTypeStr, Integer folderId, String templateName, String firstExecution, String nextExecution, String lastExecution, String executionInterval, boolean saveRecipient, boolean saveOriginator, Integer converterFormatId, String fileId, String encoding) {
        Form form = this.formFactory.form(PaymentCsvImportForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentContextType paymentContext = Payments.readPaymentContext(paymentContextTypeName);
        return CompletableFuture.supplyAsync(() -> {
            PaymentCsvImportForm csvImportForm;
            ArrayList<ValidationError> errors;
            PaymentTransferType.PmtType pmtType;
            if (Branding.getBranding().hidePaymentImport()) {
                return Payments.redirect((Call)Payments.getRedirectTarget(paymentContext, false)).flashing("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
            }
            try {
                pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeStr);
            }
            catch (IllegalArgumentException e) {
                return Payments.redirect((Call)Payments.getRedirectTarget(paymentContext, false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
            }
            if (form.hasErrors()) {
                errors = new ArrayList<ValidationError>(form.errors());
                csvImportForm = form.value().isPresent() ? (PaymentCsvImportForm)form.value().get() : new PaymentCsvImportForm();
            } else {
                errors = null;
                csvImportForm = (PaymentCsvImportForm)form.get();
            }
            WorkspaceFile file2 = null;
            boolean successful = false;
            try {
                Form<PaymentCsvImportForm> validatedForm;
                Result contentWithoutEmptyRows;
                file2 = CsvImport.getFileById(fileId);
                File f = WorkspaceFileSystem.getFile((WorkspaceFile)file2);
                if (!f.isFile()) {
                    BLLoggerPlay.error("Payments import file " + f.getAbsolutePath() + " was not found!");
                    Result result = Payments.redirect((Call)Payments.getRedirectTarget(paymentContext, false)).flashing("error", messages.at("payment.importfilenotfound", new Object[0]));
                    return result;
                }
                String[][] content = csvImportForm.loadFromForm(user, bankId, pmtType, paymentContext, null, converterFormatId, f);
                String[][] importData = csvImportForm.hasHeadline && content.length > 0 ? (String[][])Arrays.copyOfRange(content, 1, content.length) : content;
                if (importData != null) {
                    contentWithoutEmptyRows = new ArrayList();
                    for (String[] importDatum : importData) {
                        if (Arrays.stream(importDatum).allMatch(s -> s.trim().isEmpty())) continue;
                        contentWithoutEmptyRows.add(importDatum);
                    }
                    if (contentWithoutEmptyRows.size() < importData.length) {
                        importData = new String[contentWithoutEmptyRows.size()][];
                        for (int i = 0; i < contentWithoutEmptyRows.size(); ++i) {
                            importData[i] = (String[])contentWithoutEmptyRows.get(i);
                        }
                    }
                }
                if (importData == null || importData.length == 0) {
                    contentWithoutEmptyRows = Payments.ok((Content)paymentcsvimport.render((Form<DynamicForm.Dynamic>)this.formFactory.form().bind((Lang)request.acceptLanguages().getFirst(), request.attrs(), form.rawData(), new String[0]).withGlobalError("payment.importfilenotfound"), paymentContext, csvImportForm.getColumnFields(messages), content, bankId, pmtType, folderId, templateName, firstExecution, nextExecution, lastExecution, executionInterval, saveRecipient, saveOriginator, converterFormatId, fileId, encoding, request, messages));
                    return contentWithoutEmptyRows;
                }
                List<CsvImport.Field> columnFields = csvImportForm.getColumnFields(messages);
                if (errors == null && (validatedForm = csvImportForm.validate((Form<PaymentCsvImportForm>)form, paymentContext, bankId, user, templateName, firstExecution, nextExecution, lastExecution, executionInterval, importData, messages)).hasErrors()) {
                    errors = new ArrayList(validatedForm.errors());
                }
                HashMap<String, String> flashMap = new HashMap<String, String>();
                if (errors == null || errors.isEmpty()) {
                    try {
                        HashSet<String> errorMessages = new HashSet<String>();
                        csvImportForm.runImport((Form<PaymentCsvImportForm>)form, user, pmtType, importData, folderId, saveRecipient, saveOriginator, encoding, messages, errorMessages);
                        for (String errorMessage : errorMessages) {
                            Utils.addToFlash(flashMap, "error", errorMessage);
                        }
                    }
                    catch (Throwable t) {
                        errors = new ArrayList();
                        errors.add(new ValidationError(null, "payment.csv.error.failed", Collections.singletonList(Utils.getLocalizedMessage(t, messages))));
                    }
                }
                if (errors != null && !errors.isEmpty()) {
                    DynamicForm dynamicForm = this.formFactory.form().bind((Lang)request.acceptLanguages().getFirst(), request.attrs(), form.rawData(), new String[0]);
                    for (ValidationError error : errors) {
                        dynamicForm = dynamicForm.withError(error);
                    }
                    Result result = Payments.ok((Content)paymentcsvimport.render((Form<DynamicForm.Dynamic>)dynamicForm, paymentContext, columnFields, content, bankId, pmtType, folderId, templateName, firstExecution, nextExecution, lastExecution, executionInterval, saveRecipient, saveOriginator, converterFormatId, fileId, encoding, request, messages));
                    return result;
                }
                String flashKey = ((PaymentCsvImportForm)form.get()).hasImportedPayments() ? "success" : "warning";
                Utils.addToFlash(flashMap, flashKey, csvImportForm.getResultMessage(messages, importData.length));
                successful = true;
                Result result = Payments.redirect((Call)Payments.getRedirectTarget(paymentContext, false)).flashing(flashMap);
                return result;
            }
            catch (Throwable t) {
                BLLoggerPlay.error("Failed to load payment data from CSV file!", t);
                Result result = Payments.redirect((Call)routes.Payments.importForm(paymentContextTypeName)).flashing("HTMLerror", messages.at("payment.import.failed", new Object[]{Utils.getLocalizedMessage(t, messages)}));
                return result;
            }
            finally {
                if (file2 != null && successful) {
                    WorkspaceFileSystem.delete((WorkspaceFile)file2);
                }
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> print(Http.Request request, String paymentContextTypeString) {
        return this.printPayments(request, null, paymentContextTypeString);
    }

    public CompletionStage<Result> printPayment(Http.Request request, Integer id, String paymentContextTypeString) {
        return this.printPayments(request, id, paymentContextTypeString);
    }

    private CompletionStage<Result> printPayments(Http.Request request, Integer id, String paymentContextTypeString) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String paymentIdsString = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> {
            play.api.mvc.Call returnOperation;
            PaymentContextType paymentContextType = Payments.readPaymentContext(paymentContextTypeString);
            if (paymentContextType == PaymentContextType.OPEN_PAYMENT) {
                sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
                sorting.setProperty(PROPS_SELECTION, paymentIdsString);
                returnOperation = routes.OpenPayments.index(true);
            } else if (paymentContextType == PaymentContextType.SIGNED_PAYMENT) {
                sorting = new SortingHandler(user, Sorting.Table.PMT_SIGNED);
                sorting.setProperty(PROPS_SELECTION, paymentIdsString);
                returnOperation = id != null ? routes.SignedPayments.payment(id, null) : routes.SignedPayments.index(true);
            } else if (paymentContextType == PaymentContextType.PERIODIC_PAYMENT) {
                sorting = new SortingHandler(user, Sorting.Table.PMT_PERIODIC);
                sorting.setProperty(PROPS_SELECTION, paymentIdsString);
                returnOperation = routes.PeriodicPayments.index(true);
            } else {
                BLLoggerPlay.error("Invalid payment type for payment printing: " + paymentContextTypeString);
                return Payments.notFound();
            }
            List<Integer> paymentIds = GeneralUtils.getSelectionIds(paymentIdsString);
            if (paymentIds.isEmpty()) {
                BLLoggerPlay.error("No payments are selected to be printed!");
                return Payments.notFound();
            }
            HashMap<Object, PaymentPrinterInfo> toPrint = new HashMap<Object, PaymentPrinterInfo>();
            if (paymentContextType == PaymentContextType.OPEN_PAYMENT) {
                for (OpenPayment openPayment : OpenPayments.getQueryCheckPermission(user).where().in("id", paymentIds).findList()) {
                    try {
                        PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(openPayment.getPmtType(), openPayment.getPaymentData());
                        toPrint.put(openPayment, new PaymentPrinterInfo(paymentHandler, openPayment.getOrderTypeOrFileType()));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.error("Failed to load open payment information for printing!", e);
                    }
                }
            } else if (paymentContextType == PaymentContextType.SIGNED_PAYMENT) {
                for (SignedPayment signedPayment : SignedPayments.getQueryCheckPermission(user).where().in("id", paymentIds).findList()) {
                    if (signedPayment.isSalaryPayment() && !Util.displaySalaries((User)user)) continue;
                    try {
                        PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(signedPayment.getPmtType(), signedPayment.getPaymentData());
                        toPrint.put(signedPayment, new PaymentPrinterInfo(paymentHandler, signedPayment.getSend().getOriginalSendType(), signedPayment));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.error("Failed to load signed payment information for printing!", e);
                    }
                }
                if (toPrint.isEmpty()) {
                    return Payments.redirect((Call)returnOperation).flashing("error", messages.at("signedpayments.print.paymentnotfound", new Object[0]));
                }
            } else {
                for (PeriodicPayment periodicPayment : PeriodicPayments.getQueryCheckPermission(user).where().in("id", paymentIds).findList()) {
                    try {
                        PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(periodicPayment.getPmtType(), periodicPayment.getPaymentData());
                        toPrint.put(periodicPayment, new PaymentPrinterInfo(paymentHandler, periodicPayment.getOrderTypeOrFileType()));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.error("Failed to load periodic payment information for printing!", e);
                    }
                }
            }
            if (toPrint.isEmpty()) {
                return Payments.redirect((Call)returnOperation).flashing("error", messages.at("payment.open.paymentnotfound", new Object[]{paymentIds.size()}));
            }
            try {
                File file2 = BankingPaymentPrinter.printPayments((User)user, (BLLogger)BLLoggerPlay.getLogger(), (Locale)messages.lang().locale(), toPrint, (boolean)GeneralUtils.printLogo(user));
                return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to print payments to PDF file!", e);
                return Payments.redirect((Call)returnOperation).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToPrintPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public Result bankNameForIban(String iban) {
        String bankName = BLZCache.getBankNameFromIBAN((String)iban);
        if (bankName != null) {
            return Payments.ok((String)bankName);
        }
        return Payments.ok();
    }

    public WebSocket editPaymentController() {
        PaymentLockInfo lockInfo = new PaymentLockInfo();
        return WebSocket.Text.accept(request -> Flow.fromFunction((Function & Serializable)in -> {
            lockInfo.handleRequest((String)in);
            return "";
        }).watchTermination((Function2 & Serializable)(notUsed, stage) -> {
            stage.whenCompleteAsync((result, throwable) -> lockInfo.unlock());
            return "";
        }));
    }

    public WebSocket csvImportController() {
        final CsvImportInfo info = new CsvImportInfo();
        return WebSocket.Text.accept(request -> Flow.fromFunction((Function & Serializable)in -> {
            info.handleRequest((String)in);
            return "";
        }).watchTermination((Function2 & Serializable)(notUsed, stage) -> {
            stage.whenCompleteAsync((result, throwable) -> new Timer().schedule(new TimerTask(this){

                @Override
                public void run() {
                    info.closed();
                }
            }, 5000L));
            return "";
        }));
    }

    public Result calculateIbanAndBicForSepa(Http.Request request, String accountNumber, String bankCode) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ObjectNode resultJson = Json.newObject();
        Pattern BLZ_PATTERN = RegularExpressions.GERMAN_BANK_CODE.getPattern();
        if (bankCode == null || !BLZ_PATTERN.matcher(bankCode).matches() || accountNumber == null || accountNumber.trim().isEmpty()) {
            resultJson.put("recipientIbanError", messages.at("accounts.calculateIban.missingValues", new Object[0]));
            resultJson.put("recipientIban", "");
            resultJson.put("recipientBic", "");
            resultJson.put("recipientBank", "");
            return Payments.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
        }
        SEPABankConnection sepaBankConnection = BLZCache.getSEPABankConnection((String)bankCode, (String)accountNumber);
        if (sepaBankConnection == null) {
            resultJson.put("recipientIban", "");
            resultJson.put("recipientBic", "");
            resultJson.put("recipientBank", "");
            resultJson.put("recipientIbanError", messages.at("sepapayment.determineIban.failed", new Object[0]));
            return Payments.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
        }
        resultJson.put("recipientIbanError", "");
        resultJson.put("recipientIban", sepaBankConnection.getIban());
        resultJson.put("recipientBic", sepaBankConnection.getBic());
        resultJson.put("recipientBank", BLZCache.getBankNameFromIBAN((String)sepaBankConnection.getIban()));
        return Payments.ok((byte[])Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    private AustrianFeeType getFeeType(String value, AustrianFeeTypeProvider.DateType dateType) {
        for (AustrianFeeType fee : TaxOfficePaymentForm.FEE_TYPE_PROVIDER.getFeeTypes(dateType)) {
            if (!fee.getCode().equals(value)) continue;
            return fee;
        }
        return null;
    }

    private static PaymentContextType readPaymentContext(String paymentContextTypeName) {
        try {
            return PaymentContextType.valueOf(paymentContextTypeName);
        }
        catch (IllegalArgumentException e) {
            return PaymentContextType.OPEN_PAYMENT;
        }
    }

    private static Call getRedirectTarget(PaymentContextType paymentContext, boolean selection) {
        return switch (paymentContext) {
            case PaymentContextType.PAYMENT_TEMPLATE -> routes.PaymentTemplates.index(selection);
            case PaymentContextType.PERIODIC_PAYMENT -> routes.PeriodicPayments.index(selection);
            default -> routes.OpenPayments.index(selection);
        };
    }

    public Result determineTaxPurpose(Http.Request request) {
        JsonNode dateline = null;
        try {
            List<AustrianFeeMessage> feeMessages = new ArrayList();
            JsonNode j = request.body().asJson();
            JsonNode datelines = j.get("datelines");
            if (datelines != null && datelines.isArray()) {
                Iterator datelinesIterator = datelines.elements();
                while (datelinesIterator.hasNext()) {
                    JsonNode json = (JsonNode)datelinesIterator.next();
                    dateline = json.get("dateline");
                    if (dateline.get("type") != null && dateline.get("month1") != null && dateline.get("month2") != null && dateline.get("quarter") != null && dateline.get("year") != null && dateline.get("date") != null && dateline.get("datelang") != null) {
                        String type = dateline.get("type").asText();
                        String month1 = dateline.get("month1").asText();
                        String month2 = dateline.get("month2").asText();
                        String quarter = dateline.get("quarter").asText();
                        String yearText = dateline.get("year").asText();
                        String dateText = dateline.get("date").asText();
                        Locale locale = this.messagesApi.preferred((Http.RequestHeader)request).lang().toLocale();
                        ArrayList<AustrianFeeItem> feeItems = new ArrayList<AustrianFeeItem>();
                        AustrianFeeTypeProvider.DateType dateType = AustrianFeeTypeProvider.DateType.valueOf((String)type);
                        JsonNode feelines = dateline.get("feelines");
                        if (feelines != null && feelines.isArray()) {
                            Iterator feelinesIterator = feelines.elements();
                            while (feelinesIterator.hasNext()) {
                                JsonNode node = (JsonNode)feelinesIterator.next();
                                String feetypeJson = node.get("feetype").asText();
                                String amountJson = node.get("amount").asText();
                                AustrianFeeType feetype = this.getFeeType(feetypeJson, dateType);
                                if (feetype == null) continue;
                                BigDecimal amount2 = new BigDecimal(amountJson);
                                boolean isCredit = amount2.signum() < 0;
                                feeItems.add(new AustrianFeeItem(feetype, amount2.abs(), isCredit));
                            }
                        }
                        Integer year = Integer.parseInt(yearText);
                        SimpleDateFormat df = Utils.getJavaDatePickerFormat(locale);
                        Date date2 = df.parse(dateText);
                        String dateString = AustrianFeeMessageHandler.FeeMessageDate.getDateInfo((AustrianFeeTypeProvider.DateType)dateType, (Integer)year, (String)month1, (String)month2, (String)quarter, (Date)date2);
                        if (feeItems.isEmpty()) continue;
                        feeMessages.add(new AustrianFeeMessage(dateString, feeItems));
                        continue;
                    }
                    return Payments.ok();
                }
                if (!feeMessages.isEmpty()) {
                    feeMessages = AustrianFeeMessageHandler.getUniqueFeeMessages(feeMessages);
                    String purpose = AustrianFeeMessageHandler.getPurpose(feeMessages);
                    ObjectNode resultJson = Json.newObject();
                    resultJson.put("purpose", purpose);
                    return Payments.ok((String)Json.asciiStringify((JsonNode)resultJson));
                }
            }
        }
        catch (Exception e) {
            Object errorMsg = "Failed to determine tax purpose!";
            if (dateline != null) {
                errorMsg = (String)errorMsg + " Error occurred in date line: " + String.valueOf(dateline);
            }
            BLLoggerPlay.error((String)errorMsg, e);
            return Payments.internalServerError();
        }
        return Payments.noContent();
    }

    public Result convertAmount(Http.Request request) {
        BigDecimal amount2 = null;
        BigDecimal conversionFactor = null;
        try {
            JsonNode params = request.body().asJson();
            amount2 = new BigDecimal(params.get("amount").asText());
            conversionFactor = new BigDecimal(params.get("conversionFactor").asText());
            boolean convertToEur = Boolean.parseBoolean(params.get("convertToEur").asText());
            BigDecimal convertedAmount = convertToEur ? amount2.divide(conversionFactor, RoundingMode.HALF_DOWN) : amount2.multiply(conversionFactor);
            ObjectNode resultJson = Json.newObject();
            resultJson.put("convertedAmount", convertedAmount.toPlainString());
            return Payments.ok((String)Json.asciiStringify((JsonNode)resultJson));
        }
        catch (Exception e) {
            String message = "Failed to convert amount " + String.valueOf(amount2) + " with conversion factor " + String.valueOf(conversionFactor);
            BLLoggerPlay.warning(message, e);
            return Payments.badRequest((String)message);
        }
    }

    public Result calculateDiscount(Http.Request request) {
        BigDecimal amount2 = null;
        BigDecimal discountPercentage = null;
        try {
            JsonNode params = request.body().asJson();
            amount2 = new BigDecimal(params.get("amount").asText());
            discountPercentage = new BigDecimal(params.get("discountPercentage").asText());
            discountPercentage = discountPercentage.min(new BigDecimal(100)).max(BigDecimal.ZERO);
            BigDecimal discountFactor = discountPercentage.divide(BigDecimal.valueOf(100L));
            BigDecimal discountAmount = amount2.multiply(discountFactor);
            BigDecimal discountedAmount = amount2.subtract(discountAmount);
            ObjectNode resultJson = Json.newObject();
            resultJson.put("discountAmount", discountAmount.toPlainString());
            resultJson.put("discountedAmount", discountedAmount.toPlainString());
            return Payments.ok((String)Json.asciiStringify((JsonNode)resultJson));
        }
        catch (Exception e) {
            String message = "Failed to calculate discount for amount " + String.valueOf(amount2) + " with discount percentage " + String.valueOf(discountPercentage);
            BLLoggerPlay.warning(message, e);
            return Payments.badRequest((String)message);
        }
    }

    private static final class SaveAsOpenPaymentParameters {
        private final BankSettings bankSettings;
        private final PaymentTransferType.PmtType pmtType;
        private final String orderOrFileType;
        private final byte[] paymentData;
        private final boolean isSalaryAmount;

        public SaveAsOpenPaymentParameters(SignedPayment signedPayment) {
            this.bankSettings = signedPayment.getSend().getBank();
            this.pmtType = signedPayment.getPmtType();
            this.orderOrFileType = signedPayment.getSend().getOriginalSendType();
            this.paymentData = signedPayment.getPaymentData();
            this.isSalaryAmount = signedPayment.isSalaryPayment();
        }

        public BankSettings getBankSettings() {
            return this.bankSettings;
        }

        public PaymentTransferType.PmtType getPmtType() {
            return this.pmtType;
        }

        public byte[] getPaymentData() {
            return this.paymentData;
        }

        public boolean isSalaryAmount() {
            return this.isSalaryAmount;
        }
    }
}

