/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.Payments;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import io.ebean.Query;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AustrianForeignPaymentForm;
import models.DeleteFolderForm;
import models.DtazvPaymentForm;
import models.GenerateOpenPaymentFromTemplateForm;
import models.MovePaymentToFolderForm;
import models.Mt101PaymentForm;
import models.PaymentFilterForm;
import models.PaymentFolderForm;
import models.PaymentForm;
import models.PeriodicParametersForm;
import models.PostbarPaymentForm;
import models.SepaPaymentForm;
import models.SimpleSelectionForm;
import models.SimpleTextForm;
import models.TaxOfficePaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.payments.editpayment;
import views.html.payments.newpayment;
import views.html.payments.paymenttemplates;

@Security.Authenticated(value=AuthenticatorFor.Payment.class)
public final class PaymentTemplates
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static Query<PaymentTemplate> getQueryCheckPermission(User user) {
        return PaymentTemplates.getQueryCheckPermission(user, null, null);
    }

    public static Query<PaymentTemplate> getQueryCheckPermission(User user, PaymentFolder folder, PaymentFilter filter) {
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        Query query = PaymentTemplate.getDefaultQuery((User)user, (PaymentFolder)folder, (boolean)store.getBoolean((DatabasePreferenceConstant)PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION), (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
        if (filter != null && filter.isPaymentsTemplateFilterActive() && filter.getTemplateExpression() != null) {
            query.where(filter.getTemplateExpression());
        }
        return query;
    }

    public static String loadJsParameters(List<PaymentTemplate> payments, Messages messages) {
        ObjectNode resultJson = Json.newObject();
        ObjectNode node = resultJson.putObject("deleteMessage");
        node.put("single", messages.at("paymenttemplates.delete.title", new Object[]{1}));
        node.put("multiple", messages.at("paymenttemplates.delete.title", new Object[]{999}));
        node = resultJson.putObject("selectFolderMessage");
        node.put("single", messages.at("paymenttemplates.generate.selectfolder", new Object[]{1}));
        node.put("multiple", messages.at("paymenttemplates.generate.selectfolder", new Object[]{999}));
        node = resultJson.putObject("deleteQuestionMessage");
        node.put("single", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.confirmDeleteTemplates", (Object[])new Object[]{1}));
        node.put("multiple", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.confirmDeleteTemplates", (Object[])new Object[]{999}));
        resultJson.put("selectInfoMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.totalAmountInfo", (Object[])new Object[]{999, "AMOUNT"}));
        if (payments != null && !payments.isEmpty()) {
            ArrayNode paymentsNode = resultJson.putArray("payments");
            for (PaymentTemplate payment : payments) {
                node = paymentsNode.addObject();
                node.put("id", payment.getId());
                node.put("amount", payment.getAmount());
                node.put("currency", payment.getAmountCurrency());
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public PaymentTemplates(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result createNewFolder(Http.Request request) {
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing(Payments.createNewFolder(request, this.formFactory, this.messagesApi));
    }

    public Result changeFolderName(Http.Request request, Integer folderId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFolder paymentFolder = PaymentFolder.findById((Integer)folderId, (User)user);
        if (paymentFolder == null) {
            return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("openpayments.folder.foldernotfound", new Object[0]));
        }
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing(Payments.renameFolder(request, paymentFolder, this.formFactory, this.messagesApi));
    }

    public Result moveToFolder(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Map<String, String> flashMap = Payments.moveToFolder(request, this.formFactory, this.messagesApi);
        String paymentIds = flashMap.get("paymentIds");
        flashMap.remove("paymentIds");
        if (!Utils.hasSuccessFlash(flashMap)) {
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_TEMPLATE);
            sorting.setProperty("selection", paymentIds);
            return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(true)).flashing(flashMap);
        }
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing(flashMap);
    }

    public Result deleteFolder(Http.Request request, Integer folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_TEMPLATE);
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing(Payments.deleteFolder(request, this.formFactory, this.messagesApi, folderId, sorting));
    }

    public Result filterForm(Http.Request request, boolean filterActive) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        if (!filterActive) {
            filter.setPaymentsTemplateFilterActive(Boolean.valueOf(false));
            filter.save();
        } else {
            filter.setPaymentsTemplateFilterActive(Boolean.valueOf(true));
            Form form = this.formFactory.form(PaymentFilterForm.class).bindFromRequest(request, new String[0]);
            if (form.hasErrors()) {
                return this.index(request, (Form<PaymentFilterForm>)form, false);
            }
            PaymentFilterForm data = (PaymentFilterForm)form.get();
            data.saveDataTemplate(filter);
        }
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false));
    }

    public Result index(Http.Request request, boolean loadSelection) {
        return this.index(request, null, loadSelection);
    }

    public Result index(Http.Request request, Form<PaymentFilterForm> paymentFilterForm, boolean loadSelection) {
        List list;
        String[] sortColumnNames;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_TEMPLATE);
        int folderId = -1;
        try {
            folderId = Integer.parseInt(sorting.getProperty("folder", "-1"));
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to read parameters from sorting properties for open payments table!", e);
        }
        PaymentFolder paymentFolder = Payments.getFolder(user, folderId);
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        if (paymentFilterForm == null) {
            PaymentFilterForm data = new PaymentFilterForm(filter);
            paymentFilterForm = this.formFactory.form(PaymentFilterForm.class).fill((Object)data);
        }
        if (!filter.isPaymentsTemplateFilterActive()) {
            filter = null;
        }
        String selection = null;
        if (loadSelection) {
            selection = sorting.getProperty("selection");
        }
        sorting.setProperty("selection", null);
        Query<PaymentTemplate> query = PaymentTemplates.getQueryCheckPermission(user, paymentFolder, filter);
        sorting.computeForQuery(query);
        int sortingColumn = sorting.getSortingColumn();
        if (sortingColumn == 0) {
            sortColumnNames = new String[]{"name"};
        } else if (sortingColumn == 1) {
            sortColumnNames = new String[]{"account.name"};
        } else if (sortingColumn == 2) {
            sortColumnNames = new String[]{"orderType", "fileType"};
        } else if (sortingColumn == 3) {
            sortColumnNames = new String[]{"recipient"};
        } else if (sortingColumn == 4) {
            sortColumnNames = new String[]{"amount"};
        } else if (sortingColumn == 5) {
            sortColumnNames = new String[]{"account.iban"};
        } else if (sortingColumn == 6) {
            sortColumnNames = new String[]{"folder.name"};
        } else if (sortingColumn == 7) {
            sortColumnNames = new String[]{"originator"};
        } else {
            BLLoggerPlay.warning("User " + user.getName() + " (" + user.getId() + ") tried to sort payment templates by unknown column with ID " + sortingColumn + "!");
            sortColumnNames = new String[]{"name"};
        }
        StringBuilder order = new StringBuilder();
        for (String column : sortColumnNames) {
            if (!order.isEmpty()) {
                order.append(',');
            }
            order.append(column);
            if (sorting.isSortingAscending()) {
                order.append(" ASC");
                continue;
            }
            order.append(" DESC");
        }
        query.orderBy(order.toString());
        query.orderBy().desc("id");
        Form newFolderNameForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        MovePaymentToFolderForm moveToFolderFormValues = new MovePaymentToFolderForm();
        moveToFolderFormValues.paymentContextType = PaymentContextType.PAYMENT_TEMPLATE;
        Form moveToFolderForm = this.formFactory.form(MovePaymentToFolderForm.class).fill((Object)moveToFolderFormValues);
        GenerateOpenPaymentFromTemplateForm generateFormValues = new GenerateOpenPaymentFromTemplateForm();
        generateFormValues.generateFolderId = paymentFolder == null || PaymentFolder.NULL_FOLDER.equals(paymentFolder) ? -2 : paymentFolder.getId();
        Form generateOpenPaymentForm = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).fill((Object)generateFormValues);
        if (paymentFolder != null && !paymentFolder.equals(PaymentFolder.NULL_FOLDER)) {
            newFolderNameForm = newFolderNameForm.fill((Object)new PaymentFolderForm(null, paymentFolder.getTenant().getId()));
            changeFolderNameForm = changeFolderNameForm.fill((Object)new SimpleTextForm(paymentFolder.getName()));
        }
        DeleteFolderForm deleteFolderFormValues = new DeleteFolderForm();
        deleteFolderFormValues.policyForOpenPayments = "dontdelete";
        deleteFolderFormValues.policyForPeriodicPayments = "dontdelete";
        deleteFolderFormValues.policyForPaymentTemplates = "dontdelete";
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class).fill((Object)deleteFolderFormValues);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.PMT_TEMPLATE, (Call)routes.PaymentTemplates.index(loadSelection));
        }
        return PaymentTemplates.ok((Content)paymenttemplates.render(list, sorting, paymentFolder, (Form<PaymentFilterForm>)paymentFilterForm, filter, (Form<GenerateOpenPaymentFromTemplateForm>)generateOpenPaymentForm, selection, (Form<MovePaymentToFolderForm>)moveToFolderForm, (Form<PaymentFolderForm>)newFolderNameForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<DeleteFolderForm>)deleteFolderForm, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.PMT_TEMPLATE).updateSort(sort, ascending);
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false));
    }

    public Result indexPage(Http.Request request, int pageNumber, int pageSize, int folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sortingHandler = new SortingHandler(user, Sorting.Table.PMT_TEMPLATE);
        sortingHandler.updatePage(pageNumber, pageSize);
        sortingHandler.setProperty("folder", String.valueOf(folderId));
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false));
    }

    public Result details(Http.Request request, int templateId) {
        return this.detailsEditmode(request, templateId, false);
    }

    public Result detailsEdit(Http.Request request, int templateId) {
        return this.detailsEditmode(request, templateId, true);
    }

    public Result detailsEditmode(Http.Request request, int templateId, boolean inEditMode) {
        Class formClass;
        Form paymentForm;
        PaymentTemplate paymentTemplate;
        Messages messages;
        block11: {
            messages = this.messagesApi.preferred((Http.RequestHeader)request);
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            paymentTemplate = (PaymentTemplate)PaymentTemplates.getQueryCheckPermission(user).where().eq("id", (Object)templateId).findOne();
            if (paymentTemplate == null) {
                if (DB.find(PaymentTemplate.class, (Object)templateId) == null) {
                    return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("paymenttemplates.notfound", new Object[0]));
                }
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("paymenttemplates.nopermission", new Object[0]));
            }
            BankSettings originatorBank = paymentTemplate.getAccount().getBank();
            if (BankUtils.isDeactivated((BankUser)BankUser.findBankUser((BankSettings)originatorBank, (User)user))) {
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(true)).flashing("error", messages.at("payment.error.deactivated", new Object[]{1}));
            }
            boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)user);
            try {
                boolean saveRecipient = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.SAVE_RECIPIENT);
                if (SepaPaymentForm.isSepaPmtType(paymentTemplate.getPmtType())) {
                    boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION);
                    paymentForm = this.formFactory.form(SepaPaymentForm.class).fill((Object)new SepaPaymentForm(paymentTemplate, true, allowRecipientRecording, useMandates, saveRecipient));
                    formClass = SepaPaymentForm.class;
                    break block11;
                }
                if (DtazvPaymentForm.isAzvPmtType(paymentTemplate.getPmtType())) {
                    paymentForm = this.formFactory.form(DtazvPaymentForm.class).fill((Object)new DtazvPaymentForm(paymentTemplate, allowRecipientRecording, saveRecipient));
                    formClass = DtazvPaymentForm.class;
                    break block11;
                }
                if (Mt101PaymentForm.isMt101PmtType(paymentTemplate.getPmtType())) {
                    paymentForm = this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(paymentTemplate, allowRecipientRecording, saveRecipient));
                    formClass = Mt101PaymentForm.class;
                    break block11;
                }
                if (PostbarPaymentForm.isPostbarPmtType(paymentTemplate.getPmtType())) {
                    paymentForm = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm(paymentTemplate, true, allowRecipientRecording, saveRecipient));
                    formClass = PostbarPaymentForm.class;
                    break block11;
                }
                if (TaxOfficePaymentForm.isTaxofficePmtType(paymentTemplate.getPmtType())) {
                    paymentForm = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm(paymentTemplate, true, allowRecipientRecording, saveRecipient));
                    formClass = TaxOfficePaymentForm.class;
                    break block11;
                }
                if (AustrianForeignPaymentForm.isATXPmtType(paymentTemplate.getPmtType())) {
                    paymentForm = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)new AustrianForeignPaymentForm(paymentTemplate, true, allowRecipientRecording, saveRecipient));
                    formClass = AustrianForeignPaymentForm.class;
                    break block11;
                }
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("paymenttemplates.unknowntype", new Object[0]));
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to open payment template with ID " + templateId, e);
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("HTMLerror", messages.at("paymenttemplates.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class);
        Form newFolderForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
        Form folderSelectForm = this.formFactory.form(SimpleSelectionForm.class);
        GenerateOpenPaymentFromTemplateForm generateFormValues = new GenerateOpenPaymentFromTemplateForm();
        generateFormValues.generateFolderId = paymentTemplate.getFolder() == null ? -2 : paymentTemplate.getFolder().getId();
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form generateform = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).fill((Object)generateFormValues);
        return PaymentTemplates.ok((Content)editpayment.render((Form<? extends PaymentForm>)paymentForm, PaymentContextType.PAYMENT_TEMPLATE, templateId, paymentTemplate.getPmtType(), formClass, null, paymentTemplate.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateform, inEditMode, request, messages));
    }

    public Result update(Http.Request request, int id) {
        PaymentForm paymentForm;
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentTemplate paymentTemplate = (PaymentTemplate)PaymentTemplates.getQueryCheckPermission(user).where().eq("id", (Object)id).findOne();
        if (paymentTemplate == null) {
            if (DB.find(PaymentTemplate.class, (Object)id) == null) {
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("paymenttemplates.notfound", new Object[0]));
            }
            return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("paymenttemplates.nopermission", new Object[0]));
        }
        PaymentTransferType.PmtType pmtType = paymentTemplate.getPmtType();
        if (SepaPaymentForm.isSepaPmtType(pmtType)) {
            form = this.formFactory.form(SepaPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (SepaPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
            form = this.formFactory.form(DtazvPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
            form = this.formFactory.form(Mt101PaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
            form = this.formFactory.form(PostbarPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
            form = this.formFactory.form(TaxOfficePaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
            form = this.formFactory.form(AustrianForeignPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (AustrianForeignPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else {
            return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtType}));
        }
        if (paymentForm == null) {
            return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtType}));
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class);
        Form newFolderForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
        Form folderSelectForm = this.formFactory.form(SimpleSelectionForm.class);
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form generateform = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).bindFromRequest(request, new String[0]);
        try {
            if (!form.hasErrors()) {
                paymentForm.updateVO(PaymentContextType.PAYMENT_TEMPLATE, id, pmtType);
                form = paymentForm.validateInputData((Form<? extends PaymentForm>)form, messages, this.formFactory, user, flashMap);
            }
            if (form.hasErrors()) {
                return PaymentTemplates.ok((Content)editpayment.render(form, PaymentContextType.PAYMENT_TEMPLATE, id, pmtType, paymentForm.getClass(), null, paymentTemplate.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateform, true, request, messages));
            }
            paymentForm.store(user, flashMap, messages);
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to update payment template with ID " + id + "!", e);
            return PaymentTemplates.ok((Content)editpayment.render(form, PaymentContextType.PAYMENT_TEMPLATE, id, pmtType, paymentForm.getClass(), null, paymentTemplate.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateform, true, request, messages)).flashing("HTMLerror", messages.at("payment.error.failedtosave", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
        this.checkPermissionForModifiedPayment(user, form, messages, flashMap);
        flashMap.put("success", messages.at("paymenttemplates.modified", new Object[0]));
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.details(id)).flashing(flashMap);
    }

    public Result newTemplate(Http.Request request, String pmtTypeStr) {
        Form paymentForm;
        PaymentTransferType.PmtType pmtType;
        Messages messages;
        User user;
        block11: {
            user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            messages = this.messagesApi.preferred((Http.RequestHeader)request);
            try {
                pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeStr);
            }
            catch (IllegalArgumentException e) {
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
            }
            Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_TEMPLATE);
            int folderId = Integer.parseInt(GeneralUtils.getSortingProperties(sorting).getProperty("folder", "-1"));
            try {
                PaymentFolder folder = Payments.getFolder(user, folderId);
                boolean singleBooking = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.DISPLAY_PAYMENT_AS_SINGLE_BOOKING);
                boolean saveRecipient = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.SAVE_RECIPIENT);
                if (SepaPaymentForm.isSepaPmtType(pmtType)) {
                    paymentForm = this.formFactory.form(SepaPaymentForm.class).fill((Object)new SepaPaymentForm(PaymentContextType.PAYMENT_TEMPLATE, pmtType, user, folder, singleBooking, saveRecipient));
                    break block11;
                }
                if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
                    paymentForm = this.formFactory.form(DtazvPaymentForm.class).fill((Object)new DtazvPaymentForm(PaymentContextType.PAYMENT_TEMPLATE, pmtType, folder, saveRecipient));
                    break block11;
                }
                if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
                    paymentForm = this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(PaymentContextType.PAYMENT_TEMPLATE, pmtType, folder, saveRecipient));
                    break block11;
                }
                if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
                    paymentForm = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm(PaymentContextType.PAYMENT_TEMPLATE, pmtType, user, folder, saveRecipient));
                    break block11;
                }
                if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
                    paymentForm = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm(PaymentContextType.PAYMENT_TEMPLATE, pmtType, user, folder, singleBooking, saveRecipient));
                    break block11;
                }
                if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
                    AustrianForeignPaymentForm taxOfficePaymentForm = new AustrianForeignPaymentForm(PaymentContextType.PAYMENT_TEMPLATE, pmtType, user, folder, singleBooking, saveRecipient);
                    paymentForm = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)taxOfficePaymentForm);
                    break block11;
                }
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("paymenttemplates.unknowntype", new Object[0]));
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to open new payment template for order type " + pmtTypeStr, e);
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("HTMLerror", messages.at("paymenttemplates.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }
        if (!paymentForm.hasErrors()) {
            ((PaymentForm)paymentForm.get()).loadDefaultFormSettings(user);
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        return PaymentTemplates.ok((Content)newpayment.render((Form<? extends PaymentForm>)paymentForm, PaymentContextType.PAYMENT_TEMPLATE, pmtType, flashMap, request, messages));
    }

    public Result create(Http.Request request, String pmtTypeStr) {
        PaymentForm paymentForm;
        Form form;
        PaymentTransferType.PmtType pmtType;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        try {
            pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeStr);
        }
        catch (IllegalArgumentException e) {
            return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
        }
        if (SepaPaymentForm.isSepaPmtType(pmtType)) {
            form = this.formFactory.form(SepaPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (SepaPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
            form = this.formFactory.form(DtazvPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
            form = this.formFactory.form(Mt101PaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
            form = this.formFactory.form(PostbarPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
            form = this.formFactory.form(TaxOfficePaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
            form = this.formFactory.form(AustrianForeignPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (AustrianForeignPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else {
            form = null;
            paymentForm = null;
        }
        if (form == null || paymentForm == null) {
            return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtType}));
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        HashMap<String, String> flashMap = new HashMap<String, String>();
        try {
            String accountId = Utils.fieldValue(form, "originatorAccountId");
            if (accountId == null) {
                form = form.withError("originatorAccountId", "error.invalid");
                return PaymentTemplates.ok((Content)newpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.PAYMENT_TEMPLATE, pmtType, flashMap, request, messages));
            }
            BankSettings bank = Account.findById((int)Integer.parseInt(accountId)).getBank();
            String orderType = SendParameters.getOrderType((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
            String fileType = SendParameters.getBTF((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
            if (!Util.isOrderType((String)orderType)) {
                BLLoggerPlay.warning("Try to save payment template with unexpected order type '" + orderType + "'");
            }
            paymentForm.createNewVO(PaymentContextType.PAYMENT_TEMPLATE, pmtType, orderType, fileType, null);
            if (!form.hasErrors()) {
                form = paymentForm.validateInputData((Form<? extends PaymentForm>)form, messages, this.formFactory, user, flashMap);
            }
            if (form.hasErrors()) {
                return PaymentTemplates.ok((Content)newpayment.render(form, PaymentContextType.PAYMENT_TEMPLATE, pmtType, flashMap, request, messages));
            }
            paymentForm.store(user, flashMap, messages);
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to create payment template with payment type " + pmtTypeStr + "!", e);
            return PaymentTemplates.ok((Content)newpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.PAYMENT_TEMPLATE, pmtType, flashMap, request, messages)).flashing("HTMLerror", messages.at("payment.error.failedtosave", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
        this.checkPermissionForModifiedPayment(user, form, messages, flashMap);
        flashMap.put("success", messages.at("paymenttemplates.created", new Object[0]));
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing(flashMap);
    }

    public CompletionStage<Result> generate(Http.Request request) {
        return this.generatePayments(request, null);
    }

    public CompletionStage<Result> generatePayment(Http.Request request, Integer id) {
        return this.generatePayments(request, id);
    }

    public CompletionStage<Result> generatePayments(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form form = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).bindFromRequest(request, new String[0]);
        if (id != null) {
            ((GenerateOpenPaymentFromTemplateForm)form.get()).paymentIds = id.toString();
            redirectTo = routes.PaymentTemplates.details(id);
        } else {
            redirectTo = routes.PaymentTemplates.index(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            if (!form.hasErrors() && !((GenerateOpenPaymentFromTemplateForm)form.get()).validate(user, flashMap, messages)) {
                return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing(flashMap);
            }
            if (!form.hasErrors()) {
                ((GenerateOpenPaymentFromTemplateForm)form.get()).generate(user, flashMap, messages);
            }
            return PaymentTemplates.redirect((Call)redirectTo).flashing(flashMap);
        }, this.executionContext.current());
    }

    public Result delete(Http.Request request) {
        return this.deletePayments(request, null);
    }

    public Result deletePayment(Http.Request request, Integer id) {
        return this.deletePayments(request, id);
    }

    public Result deletePayments(Http.Request request, Integer id) {
        String flashMessage;
        String flashKey;
        List<Integer> paymentIds;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            paymentIds = Collections.singletonList(id);
        } else {
            String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            paymentIds = GeneralUtils.getSelectionIds(ids);
        }
        if (!paymentIds.isEmpty()) {
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            Query query = PaymentTemplates.getQueryCheckPermission(user).where().in("id", paymentIds).query();
            query.order().clear();
            List idsToDelete = query.findIds();
            for (PaymentTemplate paymentToDelete : DB.find(PaymentTemplate.class).where().in("id", (Collection)idsToDelete).findList()) {
                Logger.logPaymentTemplateDeleted((User)user, (PaymentTemplate)paymentToDelete);
            }
            DB.deleteAll(PaymentTemplate.class, (Collection)idsToDelete);
            flashKey = idsToDelete.isEmpty() ? "warning" : "success";
            flashMessage = messages.at("paymenttemplates.deleted", new Object[]{idsToDelete.size()});
        } else {
            flashKey = "error";
            flashMessage = messages.at("payment.error.nopaymentsselected", new Object[0]);
        }
        return PaymentTemplates.redirect((Call)routes.PaymentTemplates.index(false)).flashing(flashKey, flashMessage);
    }

    public CompletionStage<Result> duplicate(Http.Request request) {
        return this.duplicatePayments(request, null);
    }

    public CompletionStage<Result> duplicatePayment(Http.Request request, Integer id) {
        return this.duplicatePayments(request, id);
    }

    public CompletionStage<Result> duplicatePayments(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        String ids;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id != null) {
            ids = id.toString();
            redirectTo = routes.PaymentTemplates.details(id);
        } else {
            ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.PaymentTemplates.index(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
            List paymentTemplates = idsList.isEmpty() ? null : PaymentTemplates.getQueryCheckPermission(user).where().in("id", idsList).findList();
            if (paymentTemplates == null || paymentTemplates.isEmpty()) {
                return PaymentTemplates.redirect((Call)redirectTo).flashing("error", messages.at("paymenttemplates.notfound", new Object[0]));
            }
            int count = 0;
            PaymentHandler.USED_TEMPLATE_NAMES.clear();
            HashMap<String, String> flashMap = new HashMap<String, String>();
            for (PaymentTemplate paymentTemplate : paymentTemplates) {
                PaymentTransferType.PmtType pmtType = paymentTemplate.getPmtType();
                PaymentFolder folder = paymentTemplate.getFolder();
                try {
                    PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(pmtType, paymentTemplate.getPaymentData());
                    PaymentTemplate newPaymentTemplate = paymentHandler.createPaymentTemplate(paymentTemplate.getBank(), pmtType, paymentTemplate.getName(), folder);
                    newPaymentTemplate.save();
                    Logger.logPaymentTemplateCreated((User)user, (PaymentTemplate)newPaymentTemplate);
                    ++count;
                }
                catch (PaymentException e) {
                    BLLoggerPlay.error("Failed to duplicate payment template!", e);
                    Utils.addToFlash(flashMap, "HTMLerror", messages.at("paymenttemplates.failedtoduplicate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                }
            }
            PaymentHandler.USED_TEMPLATE_NAMES.clear();
            if (count == 0) {
                flashMap.put("warning", messages.at("paymenttemplates.duplicated", new Object[]{count}));
            } else {
                flashMap.put("success", messages.at("paymenttemplates.duplicated", new Object[]{count}));
            }
            return PaymentTemplates.redirect((Call)redirectTo).flashing(flashMap);
        }, this.executionContext.current());
    }

    private void checkPermissionForModifiedPayment(User user, Form<? extends PaymentForm> form, Messages messages, Map<String, String> flashMap) {
        if (PaymentTemplates.getQueryCheckPermission(user).where().eq("id", (Object)Objects.requireNonNull(((PaymentForm)form.get()).getDatabaseId())).findOne() == null) {
            String pmtTypeName = ((PaymentForm)form.get()).getPmtType().name();
            flashMap.put("warning", messages.at("payment.warning.missingpermissionforpayment", new Object[]{pmtTypeName}));
        }
    }
}

