/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.Setup;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.database.vo.PdfStatementsFilter;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.bka.api.BKAProcessing;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.format.PdfDocumentType;
import de.businesslogics.io.Streams;
import de.businesslogics.util.HexTool;
import io.ebean.Query;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.PdfStatementFilterForm;
import models.PdfStatementsExportDirForm;
import models.SimpleTextForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.html.cm.pdfStatements;
import views.html.cm.pdfstatementsexportform;

@Security.Authenticated(value=AuthenticatorFor.CM.class)
public class PDFStatements
extends Controller {
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;

    @Inject
    public PDFStatements(MessagesApi messagesApi, FormFactory formFactory) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
    }

    private Result indexWithFilter(Http.Request request, PdfStatementsFilter filter, Form<PdfStatementFilterForm> filterForm, User user) {
        List list;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sort = new SortingHandler(user, Sorting.Table.CM_PDF_STATEMENT);
        Query<CmPdfStatement> query = this.query(user, sort.getSortingColumn(), sort.isSortingAscending(), filter);
        sort.computeForQuery(query);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.CM_PDF_STATEMENT, (Call)routes.PDFStatements.index());
        }
        return PDFStatements.ok((Content)pdfStatements.render(list, sort, filterForm, filter, request, messages));
    }

    public Result index(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PdfStatementsFilter filter = PdfStatementsFilter.getFilter((User)user);
        Form filterForm = this.formFactory.form(PdfStatementFilterForm.class).fill((Object)new PdfStatementFilterForm(filter));
        return this.indexWithFilter(request, filter, (Form<PdfStatementFilterForm>)filterForm, user);
    }

    private Query<CmPdfStatement> query(User user, int sort, boolean asc, PdfStatementsFilter filter) {
        boolean checkAccountPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        Query query = CmPdfStatement.queryAllTypesByUser((User)user, (boolean)checkAccountPermission);
        if (filter.isStatementActive() && !filter.isEmpty()) {
            query.where(filter.getExpression());
        }
        String sortColumn = switch (sort) {
            case 1 -> "type";
            case 2 -> "statementDate";
            case 3 -> "statementNumber";
            case 4 -> "zipFileName";
            default -> "account";
        };
        if (asc) {
            query.orderBy(sortColumn + " asc");
        } else {
            query.orderBy(sortColumn + " desc");
        }
        return query;
    }

    public Result index_sort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_PDF_STATEMENT).updateSort(sort, asc);
        return PDFStatements.redirect((Call)routes.PDFStatements.index());
    }

    public Result index_pageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_PDF_STATEMENT).updatePage(page, pageSize);
        return PDFStatements.redirect((Call)routes.PDFStatements.index());
    }

    public Result filter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PdfStatementsFilter filter = PdfStatementsFilter.getFilter((User)user);
        if (active) {
            Form<PdfStatementFilterForm> form = this.formFactory.form(PdfStatementFilterForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((PdfStatementFilterForm)form.get()).validate(form, filter);
            }
            if (form.hasErrors()) {
                return this.indexWithFilter(request, filter, form, user);
            }
            filter.setStatementActive(!filter.isEmpty());
        } else {
            filter.setStatementActive(false);
        }
        filter.save();
        return PDFStatements.redirect((Call)routes.PDFStatements.index());
    }

    public static String getFilterDescription(PdfStatementsFilter filter, Messages messages) {
        StringBuilder result = new StringBuilder();
        if (filter.getBank() != null) {
            result.append(messages.at("sent.filter.bank", new Object[]{filter.getBank().getDisplayName()}));
        }
        if (filter.getAccountId() != null) {
            Account account;
            if (result.length() > 0) {
                result.append(", ");
            }
            if ((account = Account.findById((int)filter.getAccountId())) != null) {
                result.append(messages.at("payment.filter.description.account", new Object[]{Account.getDefaultDisplayName((Account)account)}));
            }
        }
        if (filter.getDateComparator() != null && filter.getFromDate() != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(messages.at("cm.filter.date", new Object[]{filter.getDateComparator().ordinal(), filter.getFromDate(), filter.getToDate()}));
        }
        if (filter.getType() != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(messages.at("pdfstatements.filter.type", new Object[]{PdfDocumentType.getDescription((String)filter.getType().name(), (Locale)messages.lang().toLocale())}));
        }
        return result.toString();
    }

    public Result file(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        CmPdfStatement stmt = CmPdfStatement.findByIdAndUser((int)id, (User)user);
        if (stmt == null) {
            return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("error", messages.at("pdfstatements.error.noSuchFile", new Object[0]));
        }
        File file2 = this.getFile(stmt);
        if (!file2.exists() || !file2.isFile()) {
            return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("error", messages.at("pdfstatements.error.noSuchFile", new Object[0]));
        }
        try {
            if (!this.checkHashValue(file2, stmt)) {
                return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.fileHasWrongHash", (Object[])new Object[0]));
            }
            return GeneralUtils.supplyWorkspaceFile(file2, false, false).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to create download for PDF statement!", e);
            return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("error", messages.at("pdfstatements.error.couldNotDownload", new Object[]{1}));
        }
    }

    private File getFile(CmPdfStatement stmt) {
        File pdfFile = WorkspaceFileSystem.getFile((WorkspaceFile)stmt.getLocalFile());
        if (!pdfFile.exists()) {
            pdfFile = new File(WorkspaceFileSystem.BKA_DIRECTORY, stmt.getZipFileName());
        }
        return pdfFile;
    }

    private boolean checkHashValue(File file2, CmPdfStatement stmt) throws IOException, GeneralSecurityException {
        DigestOutputStream dout = new DigestOutputStream(new OutputStream(this){

            @Override
            public void write(int b) {
            }
        }, MessageDigest.getInstance("SHA-256"));
        Streams.copy((InputStream)EncryptData.getInstance().openInputStream(file2), (OutputStream)dout);
        dout.close();
        byte[] hash = dout.getMessageDigest().digest();
        return Arrays.equals(hash, HexTool.fromHex((String)stmt.getLocalFile().getSha256Hash()));
    }

    public Result delete(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean allowToDelete = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS);
        if (!allowToDelete) {
            return PDFStatements.redirect((Call)routes.CmAccountOverview.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("cm.deletedAccounts.nopermission", new Object[0]));
        }
        String idsString = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        int countSuccess = 0;
        int countFailed = 0;
        for (int i : GeneralUtils.getSelectionIds(idsString)) {
            CmPdfStatement stmt = CmPdfStatement.findByIdAndUser((int)i, (User)user);
            if (stmt == null) {
                ++countFailed;
                continue;
            }
            try {
                WorkspaceFileSystem.delete((WorkspaceFile)stmt.getLocalFile());
                DB.delete((Object)stmt);
                ++countSuccess;
            }
            catch (Exception e) {
                BLLoggerPlay.error("Could not delete PDF statement", e);
                ++countFailed;
            }
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (countSuccess > 0) {
            flashMap.put("success", this.messagesApi.preferred((Http.RequestHeader)request).at("pdfstatements.success.deleted", new Object[]{countSuccess}));
        }
        if (countFailed > 0) {
            flashMap.put("warning", this.messagesApi.preferred((Http.RequestHeader)request).at("pdfstatements.error.cannotDelete", new Object[]{countFailed}));
        }
        return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing(flashMap);
    }

    public Result exportDirForm(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!user.isAdmin()) {
            return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("error", messages.at("pdfstatements.exportdir.error.adminOnly", new Object[0]));
        }
        if (Setup.AUTOMATIC_EXPORT_PATH != null && Setup.AUTOMATIC_EXPORT_PATH.length() != 0) {
            return PDFStatements.redirect((Call)routes.PDFStatements.index());
        }
        PdfStatementsExportDirForm value = PdfStatementsExportDirForm.fillForm(user);
        Form form = this.formFactory.form(PdfStatementsExportDirForm.class).fill((Object)value);
        return PDFStatements.ok((Content)pdfstatementsexportform.render((Form<PdfStatementsExportDirForm>)form, request, messages));
    }

    public Result setExportDir(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (!user.isAdmin()) {
            return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("error", messages.at("pdfstatements.exportdir.error.adminOnly", new Object[0]));
        }
        Form form = this.formFactory.form(PdfStatementsExportDirForm.class).bindFromRequest(request, new String[0]);
        if (form.hasErrors()) {
            return PDFStatements.ok((Content)pdfstatementsexportform.render((Form<PdfStatementsExportDirForm>)form, request, messages));
        }
        boolean value = ((PdfStatementsExportDirForm)form.get()).setPref(user);
        return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("success", value ? messages.at("pdfstatements.exportdir.success.added", new Object[0]) : messages.at("pdfstatements.exportdir.success.removed", new Object[0]));
    }

    public Result getExampleFileName(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return PDFStatements.badRequest((String)"noPattern");
        }
        try {
            return PDFStatements.ok((String)BKAProcessing.getExample().substitute(pattern));
        }
        catch (Exception e) {
            return PDFStatements.badRequest((String)"incorrectPattern");
        }
    }

    public Result getZipFile(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String idsString = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        ArrayList<File> list = new ArrayList<File>();
        for (int i : GeneralUtils.getSelectionIds(idsString)) {
            File file2;
            CmPdfStatement stmt = CmPdfStatement.findByIdAndUser((int)i, (User)user);
            if (stmt == null || (file2 = this.getFile(stmt)) == null || !file2.exists() || !file2.isFile()) continue;
            list.add(file2);
        }
        if (list.isEmpty()) {
            return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("error", messages.at("fetched.error.noFilesToZip", new Object[0]));
        }
        try {
            return GeneralUtils.supplyZipFile(list, false, false).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("pdfStatementsFiles.zip"));
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to create zip download to pdf statements!", e);
            return PDFStatements.redirect((Call)routes.PDFStatements.index()).flashing("error", messages.at("pdfstatements.error.couldNotDownload", new Object[]{list.size()}));
        }
    }

    public static Seq<Tuple2<String, String>> getTypes(Locale locale) {
        ArrayList<Tuple2> resultList = new ArrayList<Tuple2>();
        resultList.add(Scala.Tuple((Object)"", (Object)""));
        for (CmPdfStatement.Type t : CmPdfStatement.Type.values()) {
            resultList.add(new Tuple2((Object)t.name(), (Object)PdfDocumentType.getDescription((String)t.name(), (Locale)locale)));
        }
        resultList.sort((t2, t1) -> ((String)t2._2).compareToIgnoreCase((String)t1._2));
        return Scala.toSeq(resultList);
    }
}

