/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import io.ebean.Query;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.DtazvOriginatorForm;
import models.MT101OriginatorForm;
import models.OriginatorForm;
import models.SepaOriginatorForm;
import models.SimpleTextForm;
import models.TenantSelectForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.payments.editoriginator;
import views.html.payments.neworiginator;
import views.html.payments.originators;

@Security.Authenticated(value=AuthenticatorFor.Payment.class)
public final class Originators
extends Controller {
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    public static String editHelpUrl(PaymentType paymentType) {
        if (paymentType == PaymentType.SEPA || paymentType == PaymentType.MANDATE) {
            return "payments/sepa-originator";
        }
        if (paymentType == PaymentType.DTAZV) {
            return "payments/dtazv-originator";
        }
        if (paymentType == PaymentType.MT101) {
            return "payments/mt101-originator";
        }
        return "payments/record-originator";
    }

    public static String loadJsParameters(Messages messages, boolean allowOriginatorRecording, int numberOfTenants) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("numberOfTenants", numberOfTenants);
        resultJson.put("allowOriginatorRecording", allowOriginatorRecording);
        ObjectNode tupleObjectNode = resultJson.putObject("reallyDeleteMessage");
        tupleObjectNode.put("single", messages.at("originators.reallydelete.message.single", new Object[0]));
        tupleObjectNode.put("multiple", messages.at("originators.reallydelete.message.multiple", new Object[]{999}));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public Originators(MessagesApi messagesApi, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
    }

    public Result index(Http.Request request) {
        List list;
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_ORIGINATOR);
        Query query = PaymentOriginator.findQueryforUser((User)user);
        try {
            tenant = Tenant.findById((int)Integer.parseInt(sorting.getProperty("TENANT", "-1")), (User)user, (boolean)false);
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Invalid value for tenant in originators table!", e);
            tenant = null;
        }
        if (tenant != null) {
            query.where().eq("tenant", (Object)tenant);
        }
        String sortColumnName = sorting.getSortingColumn() == 1 ? "paymentType" : (sorting.getSortingColumn() == 2 && tenant == null ? "tenant.name" : "name");
        if (sorting.isSortingAscending()) {
            query.orderBy(sortColumnName + " ASC");
        } else {
            query.orderBy(sortColumnName + " DESC");
        }
        sorting.computeForQuery(query);
        Form form = this.formFactory.form(TenantSelectForm.class);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.PMT_ORIGINATOR, (Call)routes.Originators.index());
        }
        return Originators.ok((Content)originators.render(list, (Form<TenantSelectForm>)form, sorting, tenant, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.PMT_ORIGINATOR).updateSort(sort, ascending);
        return Originators.redirect((Call)routes.Originators.index());
    }

    public Result indexWithPage(Http.Request request, int pageNumber, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.PMT_ORIGINATOR).updatePage(pageNumber, pageSize);
        return Originators.redirect((Call)routes.Originators.index());
    }

    public Result indexWithTenant(Http.Request request, Integer tenant) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.PMT_ORIGINATOR).setProperty("TENANT", tenant != null ? String.valueOf(tenant) : null);
        return Originators.redirect((Call)routes.Originators.index());
    }

    public Result create(Http.Request request, String type) {
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (this.isOriginatorRecordingForbidden(user)) {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.recordingnotallowed", new Object[0]));
        }
        PaymentType paymentType = PaymentType.valueOf((String)type);
        if (paymentType == PaymentType.DTAZV) {
            form = this.formFactory.form(DtazvOriginatorForm.class).fill((Object)new DtazvOriginatorForm());
        } else if (paymentType == PaymentType.SEPA) {
            form = this.formFactory.form(SepaOriginatorForm.class).fill((Object)new SepaOriginatorForm());
        } else if (paymentType == PaymentType.MT101) {
            form = this.formFactory.form(MT101OriginatorForm.class).fill((Object)new MT101OriginatorForm());
        } else {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.unknownpaymenttype", new Object[]{type}));
        }
        form.value().ifPresent(originatorForm -> originatorForm.loadDefaultFormSettings(user));
        return Originators.ok((Content)neworiginator.render((Form<? extends OriginatorForm>)form, paymentType, null, request, messages));
    }

    public Result edit(Http.Request request, int id) {
        return this.editOriginator(request, id, false);
    }

    public Result editMode(Http.Request request, int id) {
        return this.editOriginator(request, id, true);
    }

    public Result editOriginator(Http.Request request, int id, boolean editMode) {
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentOriginator paymentOriginator = PaymentOriginator.findById((int)id, (User)user);
        if (paymentOriginator == null) {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.unknown", new Object[0]));
        }
        if (paymentOriginator.getPaymentType() == PaymentType.DTAZV) {
            form = this.formFactory.form(DtazvOriginatorForm.class).fill((Object)new DtazvOriginatorForm(paymentOriginator));
        } else if (paymentOriginator.getPaymentType() == PaymentType.SEPA) {
            form = this.formFactory.form(SepaOriginatorForm.class).fill((Object)new SepaOriginatorForm(paymentOriginator));
        } else if (paymentOriginator.getPaymentType() == PaymentType.MT101) {
            form = this.formFactory.form(MT101OriginatorForm.class).fill((Object)new MT101OriginatorForm(paymentOriginator));
        } else {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.unknownpaymenttype", new Object[]{paymentOriginator.getPaymentType()}));
        }
        Form tenantSelectFormForm = this.formFactory.form(TenantSelectForm.class);
        return Originators.ok((Content)editoriginator.render((Form<? extends OriginatorForm>)form, id, paymentOriginator.getPaymentType(), (Form<TenantSelectForm>)tenantSelectFormForm, editMode, null, request, messages));
    }

    public Result saveNew(Http.Request request, String paymentTypeString) {
        Form<? extends OriginatorForm> form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (this.isOriginatorRecordingForbidden(user)) {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.recordingnotallowed", new Object[0]));
        }
        PaymentType paymentType = PaymentType.valueOf((String)paymentTypeString);
        if (paymentType == PaymentType.DTAZV) {
            form = this.formFactory.form(DtazvOriginatorForm.class).bindFromRequest(request, new String[0]);
        } else if (paymentType == PaymentType.SEPA) {
            form = this.formFactory.form(SepaOriginatorForm.class).bindFromRequest(request, new String[0]);
        } else if (paymentType == PaymentType.MT101) {
            form = this.formFactory.form(MT101OriginatorForm.class).bindFromRequest(request, new String[0]);
        } else {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.unknownpaymenttype", new Object[]{paymentTypeString}));
        }
        if (!form.hasErrors()) {
            form = ((OriginatorForm)form.get()).validate(form, user, messages, null);
        }
        if (form.hasErrors()) {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("error", messages.at("general.formerror", new Object[0]));
            return Originators.ok((Content)neworiginator.render(form, paymentType, flashMap, request, messages));
        }
        PaymentOriginator paymentOriginator = new PaymentOriginator();
        paymentOriginator.setPaymentType(paymentType);
        try {
            ((OriginatorForm)form.get()).store(paymentOriginator, user);
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to save payment originator!", e);
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("HTMLerror", Utils.getLocalizedMessage(e, messages));
            return Originators.ok((Content)neworiginator.render(form, paymentType, flashMap, request, messages));
        }
        Logger.logOriginatorCreated((User)user, (PaymentOriginator)paymentOriginator);
        return Originators.redirect((Call)routes.Originators.index()).flashing("success", messages.at("originators.created", new Object[0]));
    }

    public Result update(Http.Request request, Integer id) {
        Form<? extends OriginatorForm> form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (this.isOriginatorRecordingForbidden(user)) {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.recordingnotallowed", new Object[0]));
        }
        PaymentOriginator paymentOriginator = PaymentOriginator.findById((int)id, (User)user);
        if (paymentOriginator == null) {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.unknown", new Object[0]));
        }
        if (paymentOriginator.getPaymentType() == PaymentType.DTAZV) {
            form = this.formFactory.form(DtazvOriginatorForm.class).bindFromRequest(request, new String[0]);
        } else if (paymentOriginator.getPaymentType() == PaymentType.SEPA) {
            form = this.formFactory.form(SepaOriginatorForm.class).bindFromRequest(request, new String[0]);
        } else if (paymentOriginator.getPaymentType() == PaymentType.MT101) {
            form = this.formFactory.form(MT101OriginatorForm.class).bindFromRequest(request, new String[0]);
        } else {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.unknownpaymenttype", new Object[]{paymentOriginator.getPaymentType()}));
        }
        Form tenantSelectFormForm = this.formFactory.form(TenantSelectForm.class);
        if (!form.hasErrors()) {
            form = ((OriginatorForm)form.get()).validate(form, user, messages, paymentOriginator);
        }
        if (form.hasErrors()) {
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("error", messages.at("general.formerror", new Object[0]));
            return Originators.ok((Content)editoriginator.render(form, id, paymentOriginator.getPaymentType(), (Form<TenantSelectForm>)tenantSelectFormForm, true, flashMap, request, messages));
        }
        try {
            ((OriginatorForm)form.get()).store(paymentOriginator, user);
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to save payment originator!", e);
            HashMap<String, String> flashMap = new HashMap<String, String>();
            flashMap.put("HTMLerror", Utils.getLocalizedMessage(e, messages));
            return Originators.ok((Content)editoriginator.render(form, id, paymentOriginator.getPaymentType(), (Form<TenantSelectForm>)tenantSelectFormForm, true, flashMap, request, messages));
        }
        return Originators.redirect((Call)routes.Originators.edit(id)).flashing("success", messages.at("originators.updated", new Object[0]));
    }

    public CompletionStage<Result> duplicate(Http.Request request) {
        return this.duplicateOriginators(request, null);
    }

    public CompletionStage<Result> duplicateOriginator(Http.Request request, Integer id) {
        return this.duplicateOriginators(request, id);
    }

    public CompletionStage<Result> duplicateOriginators(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        String originatorIds;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id != null) {
            originatorIds = id.toString();
            redirectTo = routes.Originators.edit(id);
        } else {
            originatorIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.Originators.index();
        }
        Form tenantSelectForm = this.formFactory.form(TenantSelectForm.class).bindFromRequest(request, new String[0]);
        Integer tenantId = ((TenantSelectForm)tenantSelectForm.get()).getSelectedTenantId();
        return CompletableFuture.supplyAsync(() -> {
            if (this.isOriginatorRecordingForbidden(user)) {
                return Originators.redirect((Call)redirectTo).flashing("error", messages.at("originators.recordingnotallowed", new Object[0]));
            }
            List<Integer> ids = GeneralUtils.getSelectionIds(originatorIds);
            List list = ids.isEmpty() ? null : PaymentOriginator.findByIdList(ids, (User)user);
            Tenant tenantToUse = tenantId != null ? Tenant.findById((int)tenantId, (User)user, (boolean)false) : null;
            int successCount = 0;
            if (list != null && !list.isEmpty()) {
                for (PaymentOriginator paymentOriginator : list) {
                    Tenant tenant = tenantToUse != null ? tenantToUse : paymentOriginator.getTenant();
                    PaymentOriginator newPaymentOriginator = new PaymentOriginator();
                    newPaymentOriginator.setName(this.getUniqueOriginatorName(paymentOriginator.getPaymentType(), paymentOriginator.getName(), tenant));
                    newPaymentOriginator.setPaymentType(paymentOriginator.getPaymentType());
                    newPaymentOriginator.setOriginatorInfo(paymentOriginator.getOriginatorInfo());
                    newPaymentOriginator.setTenant(tenant);
                    newPaymentOriginator.save();
                    ++successCount;
                    Logger.logOriginatorCreated((User)user, (PaymentOriginator)newPaymentOriginator);
                }
            }
            String flashKey = successCount == 0 ? "warning" : "success";
            return Originators.redirect((Call)redirectTo).flashing(flashKey, messages.at("originators.duplicated", new Object[]{successCount}));
        }, this.executionContext.current());
    }

    public Result delete(Http.Request request) {
        return this.deleteOriginators(request, null);
    }

    public Result deleteOriginator(Http.Request request, Integer id) {
        return this.deleteOriginators(request, id);
    }

    public Result deleteOriginators(Http.Request request, Integer id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (this.isOriginatorRecordingForbidden(user)) {
            return Originators.redirect((Call)routes.Originators.index()).flashing("error", messages.at("originators.recordingnotallowed", new Object[0]));
        }
        String originatorIds = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = GeneralUtils.getSelectionIds(originatorIds);
        List originators2 = PaymentOriginator.findByIdList(ids, (User)user);
        int count = originators2.size();
        PaymentOriginator.delete((Collection)originators2);
        for (PaymentOriginator paymentOriginator : originators2) {
            Logger.logOriginatorDeleted((User)user, (PaymentOriginator)paymentOriginator);
        }
        String flashKey = count == 0 ? "warning" : "success";
        return Originators.redirect((Call)routes.Originators.index()).flashing(flashKey, messages.at("originators.deleted", new Object[]{count}));
    }

    private boolean isOriginatorRecordingForbidden(User user) {
        return !new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
    }

    private String getUniqueOriginatorName(PaymentType paymentType, String name, Tenant tenant) {
        int id = 1;
        while (id < Integer.MAX_VALUE) {
            String result;
            if (PaymentOriginator.findOriginatorByName((PaymentType)paymentType, (String)(result = name + "." + id++), (Tenant)tenant) != null) continue;
            return result;
        }
        return null;
    }
}

