/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.Payments;
import controllers.Sent;
import controllers.Setup;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import controllers.util.BankOrderCheckHandler;
import controllers.util.BankOrderFactory;
import controllers.util.BankOrderResultHandler;
import controllers.util.BigDecimalFormatter;
import controllers.util.DateFormatter;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.account.BankInfo;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.OrderTypeUtil;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import de.businesslogics.banking.payments.api.OpenPaymentsTableCsvExport;
import de.businesslogics.banking.payments.api.OpenPaymentsTableOverviewPrinter;
import de.businesslogics.banking.payments.api.PaymentApiMessages;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.DateUtils;
import io.ebean.Query;
import io.ebean.Transaction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AustrianForeignPaymentForm;
import models.BankOrderWithPayments;
import models.DeleteFolderForm;
import models.DtazvPaymentForm;
import models.GenerateOpenPaymentFromTemplateForm;
import models.ModifyOpenPaymentsForm;
import models.MovePaymentToFolderForm;
import models.Mt101PaymentForm;
import models.PasswordForm;
import models.PaymentFilterForm;
import models.PaymentFolderForm;
import models.PaymentForm;
import models.PeriodicParametersForm;
import models.PostbarPaymentForm;
import models.SepaPaymentForm;
import models.SignOrdersForm;
import models.SimpleSelectionForm;
import models.SimpleTextForm;
import models.TaxOfficePaymentForm;
import models.WebAuthnData;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Menu;
import views.Utils;
import views.html.orders.signorder;
import views.html.payments.editpayment;
import views.html.payments.newpayment;
import views.html.payments.openpayments;

@Security.Authenticated(value=AuthenticatorFor.Payment.class)
public final class OpenPayments
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static Query<OpenPayment> getQueryCheckPermission(User user) {
        return OpenPayments.getQueryCheckPermission(user, null);
    }

    private static Query<OpenPayment> getQueryCheckPermission(User user, PaymentFolder folder) {
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        return OpenPayment.getDefaultQuery((User)user, (PaymentFolder)folder, (boolean)preferences2.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION), (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
    }

    public static String loadJsParameters(List<OpenPayment> payments, Http.Request request, Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("saveAsPeriodicLink", routes.Payments.saveAsPeriodicPayment(999, PaymentContextType.OPEN_TO_PERIODIC_PAYMENT.name()).toString());
        resultJson.put("saveAsTemplateLink", routes.Payments.saveAsPaymentTemplate(999, PaymentContextType.OPEN_PAYMENT.name()).toString());
        resultJson.put("signMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.sign", (Object[])new Object[0]));
        ObjectNode stringTupleNode = resultJson.putObject("reallyDeleteMessage");
        stringTupleNode.put("none", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.confirmDeletePayments", (Object[])new Object[]{0}));
        stringTupleNode.put("single", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.confirmDeletePayments", (Object[])new Object[]{1}));
        stringTupleNode.put("multiple", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.confirmDeletePayments", (Object[])new Object[]{999}));
        stringTupleNode = resultJson.putObject("modifyPaymentsTitle");
        stringTupleNode.put("none", messages.at("openpayments.modifypayments", new Object[]{0}));
        stringTupleNode.put("single", messages.at("openpayments.modifypayments", new Object[]{1}));
        stringTupleNode.put("multiple", messages.at("openpayments.modifypayments", new Object[]{999}));
        if (payments != null && !payments.isEmpty()) {
            ArrayNode paymentsNode = resultJson.putArray("paymentInfos");
            for (OpenPayment payment : payments) {
                ObjectNode paymentNode = paymentsNode.addObject();
                paymentNode.put("id", payment.getId());
                paymentNode.put("amount", payment.getAmount().toPlainString());
                paymentNode.put("currency", payment.getAmountCurrency());
            }
        }
        resultJson.put("showSignPrepareModal", request.flash().get("sign_prepare").isPresent());
        resultJson.put("addDecimalsUrl", routes.Application.addSumsWithCurrencyDecimals().toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static boolean isOriginatorAccountDeactivated(OpenPayment openPayment, User user) {
        BankSettings originatorBank = openPayment.getAccount().getBank();
        return BankUtils.isDeactivated((BankUser)BankUser.findBankUser((BankSettings)originatorBank, (User)user));
    }

    public static boolean isPaymentLocked(OpenPayment openPayment, User forUser) {
        return OpenPayments.getLockingUserName(openPayment, forUser) != null;
    }

    public static String getLockingUserName(OpenPayment forOpenPayment, User forUser) {
        if (forOpenPayment != null && forOpenPayment.getLockingUser() != null && !forUser.equals(forOpenPayment.getLockingUser())) {
            return forOpenPayment.getLockingUser().getName();
        }
        return null;
    }

    private static void deleteOrderFile(BankOrder bankOrder) {
        if (bankOrder.getOrderFile().delete()) {
            BLLoggerPlay.error("can not delete file on first try: " + bankOrder.getOrderFile().getAbsolutePath());
            bankOrder.getOrderFile().deleteOnExit();
        }
    }

    @Inject
    public OpenPayments(FormFactory formFactory, Formatters formatters, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
        formatters.register(Date.class, (Formatters.SimpleFormatter)new DateFormatter());
        formatters.register(BigDecimal.class, (Formatters.SimpleFormatter)new BigDecimalFormatter());
    }

    public Result index(Http.Request request, boolean loadSelection) {
        return this.index(request, null, loadSelection, null);
    }

    private Result index(Http.Request request, Form<PaymentFilterForm> paymentFilterForm, boolean loadSelection, String lockedPayments) {
        List list;
        int folderId = -1;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
        try {
            folderId = Integer.parseInt(sorting.getProperty("folder", "-1"));
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to read parameters from sorting properties for open payments table!", e);
        }
        String selection = null;
        if (loadSelection) {
            selection = sorting.getProperty("selection");
        }
        sorting.setProperty("selection", null);
        PaymentFolder paymentFolder = Payments.getFolder(user, folderId);
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        if (paymentFilterForm == null) {
            PaymentFilterForm data = new PaymentFilterForm(filter);
            paymentFilterForm = this.formFactory.form(PaymentFilterForm.class).fill((Object)data);
        }
        if (!filter.isOpenPaymentsFilterActive()) {
            filter = null;
        }
        Query<OpenPayment> query = this.getDefaultQuery(user, sorting.getSorting(), paymentFolder, filter);
        sorting.computeForQuery(query);
        MovePaymentToFolderForm moveToFolderFormValues = new MovePaymentToFolderForm();
        moveToFolderFormValues.paymentContextType = PaymentContextType.OPEN_PAYMENT;
        Form folderSelectionForm = this.formFactory.form(MovePaymentToFolderForm.class).fill((Object)moveToFolderFormValues);
        Form modifyOpenPaymentsForm = this.formFactory.form(ModifyOpenPaymentsForm.class).fill((Object)new ModifyOpenPaymentsForm());
        Form paymentTemplateNameForm = this.formFactory.form(SimpleTextForm.class);
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form newFolderNameForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        if (paymentFolder != null && !paymentFolder.equals(PaymentFolder.NULL_FOLDER)) {
            newFolderNameForm = newFolderNameForm.fill((Object)new PaymentFolderForm(null, paymentFolder.getTenant().getId()));
            changeFolderNameForm = changeFolderNameForm.fill((Object)new SimpleTextForm(paymentFolder.getName()));
        }
        DeleteFolderForm deleteFolderFormValues = new DeleteFolderForm();
        deleteFolderFormValues.policyForOpenPayments = "dontdelete";
        deleteFolderFormValues.policyForPeriodicPayments = "dontdelete";
        deleteFolderFormValues.policyForPaymentTemplates = "dontdelete";
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class).fill((Object)deleteFolderFormValues);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.PMT_OPEN, (Call)routes.OpenPayments.index(loadSelection));
        }
        return OpenPayments.ok((Content)openpayments.render(list, sorting, paymentFolder, lockedPayments, (Form<PaymentFilterForm>)paymentFilterForm, filter, selection, (Form<MovePaymentToFolderForm>)folderSelectionForm, (Form<ModifyOpenPaymentsForm>)modifyOpenPaymentsForm, (Form<SimpleTextForm>)paymentTemplateNameForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<PaymentFolderForm>)newFolderNameForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<DeleteFolderForm>)deleteFolderForm, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private Query<OpenPayment> getDefaultQuery(User user, Sorting sorting, PaymentFolder paymentFolder, PaymentFilter filter) {
        String columnName;
        int sortingColumn;
        Query<OpenPayment> query = OpenPayments.getQueryCheckPermission(user, paymentFolder);
        if (filter != null && filter.getOpenExpression() != null) {
            query.where(filter.getOpenExpression());
        }
        if (sorting.getSortingColumn() == null) {
            sorting.setSortingColumn(Integer.valueOf(0));
            sorting.setSortAscending(true);
        }
        if ((sortingColumn = sorting.getSortingColumn().intValue()) == 0) {
            columnName = "account.name";
        } else if (sortingColumn == 1) {
            columnName = "recipient";
        } else if (sortingColumn == 2) {
            columnName = "amount";
        } else if (sortingColumn == 3) {
            columnName = "orderType";
        } else if (sortingColumn == 4) {
            columnName = "purpose";
        } else if (sortingColumn == 5) {
            columnName = "executionDate";
        } else if (sortingColumn == 6) {
            columnName = "folder.name";
        } else if (sortingColumn == 7) {
            columnName = "account.iban";
        } else if (sortingColumn == 8) {
            columnName = "createdUser";
        } else if (sortingColumn == 9) {
            columnName = "originator";
        } else {
            BLLoggerPlay.warning("User " + user.getName() + " (" + user.getId() + ") tried to sort open payments by unknown column with ID " + sortingColumn + "!");
            columnName = null;
        }
        if (columnName != null) {
            query.orderBy(null);
            if (sorting.isSortAscending()) {
                query.orderBy(columnName + " ASC");
            } else {
                query.orderBy(columnName + " DESC");
            }
        }
        return query;
    }

    public Result indexWithPage(Http.Request request, int pageNumber, int pageSize, int folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sortingHandler = new SortingHandler(user, Sorting.Table.PMT_OPEN);
        sortingHandler.updatePage(pageNumber, pageSize);
        sortingHandler.setProperty("folder", String.valueOf(folderId));
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false));
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.PMT_OPEN).updateSort(sort, ascending);
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false));
    }

    public Result filterForm(Http.Request request, boolean filterActive) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFilter filter = PaymentFilter.getFilter((User)user);
        if (!filterActive) {
            filter.setOpenPaymentsFilterActive(Boolean.valueOf(false));
            filter.save();
        } else {
            filter.setOpenPaymentsFilterActive(Boolean.valueOf(true));
            Form form = this.formFactory.form(PaymentFilterForm.class).bindFromRequest(request, new String[0]);
            if (form.hasErrors()) {
                return this.index(request, (Form<PaymentFilterForm>)form, false, null);
            }
            PaymentFilterForm data = (PaymentFilterForm)form.get();
            data.saveDataOpen(filter);
        }
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false));
    }

    public Result newPayment(Http.Request request, String pmtTypeStr) {
        Form form;
        PaymentTransferType.PmtType pmtType;
        User user;
        Messages messages;
        block12: {
            messages = this.messagesApi.preferred((Http.RequestHeader)request);
            user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            try {
                pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeStr);
            }
            catch (IllegalArgumentException e) {
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
            }
            if (!PaymentUtils.canUserCreatePayments((String)request.attrs().get(Security.USERNAME), pmtType)) {
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("payment.error.nopermission.pmttype", new Object[]{pmtTypeStr}));
            }
            Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_OPEN);
            int folderId = Integer.parseInt(GeneralUtils.getSortingProperties(sorting).getProperty("folder", "-1"));
            try {
                boolean singleBooking = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.DISPLAY_PAYMENT_AS_SINGLE_BOOKING);
                boolean saveRecipient = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SAVE_RECIPIENT);
                if (SepaPaymentForm.isSepaPmtType(pmtType)) {
                    SepaPaymentForm sepaPaymentForm = new SepaPaymentForm(PaymentContextType.OPEN_PAYMENT, pmtType, user, Payments.getFolder(user, folderId), singleBooking, saveRecipient);
                    form = this.formFactory.form(SepaPaymentForm.class).fill((Object)sepaPaymentForm);
                    break block12;
                }
                if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
                    DtazvPaymentForm dtazvPaymentForm = new DtazvPaymentForm(PaymentContextType.OPEN_PAYMENT, pmtType, Payments.getFolder(user, folderId), saveRecipient);
                    dtazvPaymentForm.currency = "EUR";
                    form = this.formFactory.form(DtazvPaymentForm.class).fill((Object)dtazvPaymentForm);
                    break block12;
                }
                if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
                    Mt101PaymentForm mt101PaymentForm = new Mt101PaymentForm(PaymentContextType.OPEN_PAYMENT, pmtType, Payments.getFolder(user, folderId), saveRecipient);
                    form = this.formFactory.form(Mt101PaymentForm.class).fill((Object)mt101PaymentForm);
                    break block12;
                }
                if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
                    PostbarPaymentForm postbarPaymentForm = new PostbarPaymentForm(PaymentContextType.OPEN_PAYMENT, pmtType, user, Payments.getFolder(user, folderId), saveRecipient);
                    form = this.formFactory.form(PostbarPaymentForm.class).fill((Object)postbarPaymentForm);
                    break block12;
                }
                if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
                    TaxOfficePaymentForm taxOfficePaymentForm = new TaxOfficePaymentForm(PaymentContextType.OPEN_PAYMENT, pmtType, user, Payments.getFolder(user, folderId), singleBooking, saveRecipient);
                    form = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)taxOfficePaymentForm);
                    break block12;
                }
                if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
                    AustrianForeignPaymentForm taxOfficePaymentForm = new AustrianForeignPaymentForm(PaymentContextType.OPEN_PAYMENT, pmtType, user, Payments.getFolder(user, folderId), singleBooking, saveRecipient);
                    form = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)taxOfficePaymentForm);
                    break block12;
                }
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to create new payment!", e);
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("HTMLerror", messages.at("payment.error.failedtocreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }
        if (!form.hasErrors()) {
            ((PaymentForm)form.get()).loadDefaultFormSettings(user);
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        return OpenPayments.ok((Content)newpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.OPEN_PAYMENT, pmtType, flashMap, request, messages));
    }

    public Result saveNewPayment(Http.Request request, String pmtTypeStr) {
        PaymentForm paymentForm;
        Form form;
        PaymentTransferType.PmtType pmtType;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        try {
            pmtType = PaymentTransferType.PmtType.valueOf((String)pmtTypeStr);
        }
        catch (IllegalArgumentException e) {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtTypeStr}));
        }
        if (SepaPaymentForm.isSepaPmtType(pmtType)) {
            form = this.formFactory.form(SepaPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (SepaPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                if (PaymentTransferType.PmtType.SEPA_TRANSFER.equals((Object)pmtType) && !"EUR".equals(sepaPaymentForm.currency)) {
                    pmtType = PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER;
                }
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
            form = this.formFactory.form(DtazvPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
            form = this.formFactory.form(Mt101PaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
            form = this.formFactory.form(PostbarPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
            form = this.formFactory.form(TaxOfficePaymentForm.class).bindFromRequest(request, new String[0]);
            TaxOfficePaymentForm taxOfficePaymentForm = (TaxOfficePaymentForm)Utils.getForm(form);
            if (taxOfficePaymentForm != null) {
                if (SEPAServiceLevel.URGP.name().equals(taxOfficePaymentForm.serviceLevel)) {
                    pmtType = PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT;
                }
                taxOfficePaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
            form = this.formFactory.form(AustrianForeignPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (AustrianForeignPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else {
            form = null;
            paymentForm = null;
        }
        if (form == null || paymentForm == null) {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtType}));
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        HashMap<String, String> flashMap = new HashMap<String, String>();
        try {
            String accountId = Utils.fieldValue(form, "originatorAccountId");
            if (accountId == null) {
                form = form.withError("originatorAccountId", "error.invalid");
                return OpenPayments.ok((Content)newpayment.render(form, PaymentContextType.OPEN_PAYMENT, pmtType, flashMap, request, messages));
            }
            if (!form.hasErrors()) {
                form = paymentForm.validateBeforeVOCreation((Form<? extends PaymentForm>)form, messages, this.formFactory, flashMap);
            }
            BankSettings bank = Account.findById((int)Integer.parseInt(accountId)).getBank();
            String orderType = SendParameters.getOrderType((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
            String fileType = SendParameters.getBTF((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
            if (!Util.isOrderType((String)orderType)) {
                BLLoggerPlay.warning("Try to save open payment with unexpected order type '" + orderType + "'");
            }
            PaymentFolder selectedFolder = null;
            paymentForm.createNewVO(PaymentContextType.OPEN_PAYMENT, pmtType, orderType, fileType, selectedFolder);
            form = paymentForm.validateInputData(form, messages, this.formFactory, user, flashMap);
            if (form.hasErrors()) {
                return OpenPayments.ok((Content)newpayment.render(form, PaymentContextType.OPEN_PAYMENT, pmtType, flashMap, request, messages));
            }
            paymentForm.store(user, flashMap, messages);
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to store new payment for payment type " + pmtTypeStr + "!", e);
            return OpenPayments.ok((Content)newpayment.render((Form<? extends PaymentForm>)form.withGlobalError(messages.at("payment.error.failedtosave", new Object[]{Utils.getLocalizedMessage(e, messages)})), PaymentContextType.OPEN_PAYMENT, pmtType, flashMap, request, messages));
        }
        this.checkPermissionForModifiedPayment(user, form, flashMap, messages);
        PreferenceConstants.AnotherPaymentDialog anotherPayment = PreferenceConstants.AnotherPaymentDialog.valueOf((String)new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getString((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.ANOTHER_PAYMENT_DIALOG));
        if (anotherPayment == PreferenceConstants.AnotherPaymentDialog.YES) {
            flashMap.put("success", messages.at("payment.created", new Object[0]));
            return OpenPayments.redirect((Call)routes.OpenPayments.newPayment(pmtTypeStr)).flashing(flashMap);
        }
        if (anotherPayment == PreferenceConstants.AnotherPaymentDialog.ASK) {
            flashMap.put("ask_new_payment", String.valueOf(true));
            return OpenPayments.redirect((Call)routes.OpenPayments.newPayment(pmtTypeStr)).flashing(flashMap);
        }
        flashMap.put("success", messages.at("payment.created", new Object[0]));
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing(flashMap);
    }

    public Result payment(Http.Request request, Integer paymentId) {
        return this.paymentEditmode(request, paymentId, false);
    }

    public Result paymentEdit(Http.Request request, Integer paymentId) {
        return this.paymentEditmode(request, paymentId, true);
    }

    private Result paymentEditmode(Http.Request request, Integer paymentId, boolean inEditMode) {
        Form form;
        Class formClass;
        OpenPayment openPayment;
        User user;
        Messages messages;
        block11: {
            messages = this.messagesApi.preferred((Http.RequestHeader)request);
            user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            openPayment = (OpenPayment)OpenPayments.getQueryCheckPermission(user).where().eq("id", (Object)paymentId).findOne();
            if (openPayment == null) {
                if (DB.find(OpenPayment.class, (Object)paymentId) == null) {
                    return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("editpayment.error.deleted", new Object[0]));
                }
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("editpayment.error.nopermission", new Object[0]));
            }
            if (OpenPayments.isOriginatorAccountDeactivated(openPayment, user)) {
                return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("error", messages.at("openpayments.error.deactivated", new Object[0]));
            }
            try {
                boolean saveRecipient = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SAVE_RECIPIENT);
                boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)user);
                if (SepaPaymentForm.isSepaPmtType(openPayment.getPmtType())) {
                    boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
                    formClass = SepaPaymentForm.class;
                    form = this.formFactory.form(SepaPaymentForm.class).fill((Object)new SepaPaymentForm(openPayment, true, allowRecipientRecording, useMandates, saveRecipient));
                    break block11;
                }
                if (DtazvPaymentForm.isAzvPmtType(openPayment.getPmtType())) {
                    formClass = DtazvPaymentForm.class;
                    form = this.formFactory.form(DtazvPaymentForm.class).fill((Object)new DtazvPaymentForm(openPayment, allowRecipientRecording, saveRecipient));
                    break block11;
                }
                if (Mt101PaymentForm.isMt101PmtType(openPayment.getPmtType())) {
                    formClass = Mt101PaymentForm.class;
                    form = this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(openPayment, allowRecipientRecording, saveRecipient));
                    break block11;
                }
                if (PostbarPaymentForm.isPostbarPmtType(openPayment.getPmtType())) {
                    formClass = PostbarPaymentForm.class;
                    form = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm(openPayment, true, allowRecipientRecording, saveRecipient));
                    break block11;
                }
                if (TaxOfficePaymentForm.isTaxofficePmtType(openPayment.getPmtType())) {
                    formClass = TaxOfficePaymentForm.class;
                    form = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm(openPayment, true, allowRecipientRecording, saveRecipient));
                    break block11;
                }
                if (AustrianForeignPaymentForm.isATXPmtType(openPayment.getPmtType())) {
                    formClass = AustrianForeignPaymentForm.class;
                    form = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)new AustrianForeignPaymentForm(openPayment, true, allowRecipientRecording, saveRecipient));
                    break block11;
                }
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("editpayment.unknowntype", new Object[0]));
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to load payment with ID " + paymentId + "!", e);
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("HTMLerror", messages.at("payment.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }
        Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
        Form folderSelectForm = this.formFactory.form(SimpleSelectionForm.class);
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class);
        Form newFolderForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form generateForm = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).bindFromRequest(request, new String[0]);
        return OpenPayments.ok((Content)editpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.OPEN_PAYMENT, paymentId, openPayment.getPmtType(), formClass, OpenPayments.getLockingUserName(openPayment, user), openPayment.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateForm, inEditMode, request, messages));
    }

    public Result update(Http.Request request, int databaseId) {
        PaymentForm paymentForm;
        Form form;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        OpenPayment openPayment = (OpenPayment)OpenPayments.getQueryCheckPermission(user).where().eq("id", (Object)databaseId).findOne();
        if (openPayment == null) {
            if (DB.find(OpenPayment.class, (Object)databaseId) == null) {
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("editpayment.error.deleted", new Object[0]));
            }
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("editpayment.error.nopermission", new Object[0]));
        }
        if (OpenPayments.isOriginatorAccountDeactivated(openPayment, user)) {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("error", messages.at("openpayments.error.deactivated", new Object[0]));
        }
        PaymentTransferType.PmtType pmtType = openPayment.getPmtType();
        if (SepaPaymentForm.isSepaPmtType(pmtType)) {
            form = this.formFactory.form(SepaPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (SepaPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                if (PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER.equals((Object)pmtType) && "EUR".equals(sepaPaymentForm.currency)) {
                    pmtType = PaymentTransferType.PmtType.SEPA_TRANSFER;
                }
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
            form = this.formFactory.form(DtazvPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
            form = this.formFactory.form(Mt101PaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
            form = this.formFactory.form(PostbarPaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
            form = this.formFactory.form(TaxOfficePaymentForm.class).bindFromRequest(request, new String[0]);
            paymentForm = (PaymentForm)Utils.getForm(form);
        } else if (AustrianForeignPaymentForm.isATXPmtType(pmtType)) {
            form = this.formFactory.form(AustrianForeignPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (AustrianForeignPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.setDefaultValues(pmtType);
            }
            paymentForm = sepaPaymentForm;
        } else {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtType}));
        }
        if (paymentForm == null) {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{pmtType}));
        }
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class);
        Form newFolderForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
        Form folderSelectForm = this.formFactory.form(SimpleSelectionForm.class);
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form generateForm = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).bindFromRequest(request, new String[0]);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        try {
            if (!form.hasErrors()) {
                paymentForm.updateVO(PaymentContextType.OPEN_PAYMENT, databaseId, pmtType);
                form = paymentForm.validateInputData((Form<? extends PaymentForm>)form, messages, this.formFactory, user, flashMap);
            }
            if (!form.hasErrors() && openPayment.getLockingUser() != null && !user.equals(openPayment.getLockingUser())) {
                form = form.withGlobalError(messages.at("editpayment.error.locked", new Object[]{openPayment.getLockingUser().getName()}));
            }
            if (form.hasErrors()) {
                return OpenPayments.ok((Content)editpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.OPEN_PAYMENT, databaseId, pmtType, paymentForm.getClass(), OpenPayments.getLockingUserName(openPayment, user), openPayment.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateForm, true, request, messages));
            }
            paymentForm.store(user, flashMap, messages);
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to update payment with ID " + databaseId + "!", e);
            return OpenPayments.ok((Content)editpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.OPEN_PAYMENT, databaseId, pmtType, paymentForm.getClass(), OpenPayments.getLockingUserName(openPayment, user), openPayment.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateForm, true, request, messages)).flashing("HTMLerror", messages.at("payment.error.failedtosave", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
        this.checkPermissionForModifiedPayment(user, form, flashMap, messages);
        flashMap.put("success", messages.at("payment.modified", new Object[0]));
        return OpenPayments.redirect((Call)routes.OpenPayments.payment(databaseId)).flashing(flashMap);
    }

    public Result transformToInstantTransfer(Http.Request request, int databaseId) {
        return this.saveSepaTransformation(request, databaseId, PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER);
    }

    public Result transformToTransfer(Http.Request request, int databaseId) {
        return this.saveSepaTransformation(request, databaseId, PaymentTransferType.PmtType.SEPA_TRANSFER);
    }

    public Result transformToUrgentTransfer(Http.Request request, int databaseId) {
        return this.saveSepaTransformation(request, databaseId, PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER);
    }

    private Result saveSepaTransformation(Http.Request request, int databaseId, PaymentTransferType.PmtType newPaymentType) {
        SepaPaymentForm sepaPaymentForm;
        Form form;
        boolean inEditMode = false;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        OpenPayment openPayment = (OpenPayment)OpenPayments.getQueryCheckPermission(user).where().eq("id", (Object)databaseId).findOne();
        if (openPayment == null) {
            if (DB.find(OpenPayment.class, (Object)databaseId) == null) {
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("editpayment.error.deleted", new Object[0]));
            }
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("editpayment.error.nopermission", new Object[0]));
        }
        if (OpenPayments.isOriginatorAccountDeactivated(openPayment, user)) {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("error", messages.at("openpayments.error.deactivated", new Object[0]));
        }
        PaymentTransferType.PmtType currentPmtType = openPayment.getPmtType();
        BankSettings bank = openPayment.getBank();
        String newBTF = SendParameters.getBTF((BankSettings)bank, (PaymentTransferType.PmtType)newPaymentType);
        String newOrderType = SendParameters.getOrderType((BankSettings)bank, (PaymentTransferType.PmtType)newPaymentType);
        openPayment.setPmtType(newPaymentType);
        openPayment.setOrderType(newOrderType);
        openPayment.setFileType(newBTF);
        openPayment.setPaymentData(null);
        if (SepaPaymentForm.isSepaPmtType(openPayment.getPmtType())) {
            form = this.formFactory.form(SepaPaymentForm.class).bindFromRequest(request, new String[0]);
            sepaPaymentForm = (SepaPaymentForm)Utils.getForm(form);
            if (sepaPaymentForm != null) {
                sepaPaymentForm.isDebit = SepaApi.isDebitPmtType((PaymentTransferType.PmtType)newPaymentType);
                sepaPaymentForm.isUrgent = SepaApi.isUrgent((PaymentTransferType.PmtType)newPaymentType);
                sepaPaymentForm.debitType = SepaPaymentForm.getDebitType(newPaymentType);
                sepaPaymentForm.isInstant = SepaApi.isInstantCreditPaymentType((PaymentTransferType.PmtType)newPaymentType);
                sepaPaymentForm.isSepaForeign = SepaApi.isForeignPayment((PaymentTransferType.PmtType)newPaymentType);
            }
        } else {
            return OpenPayments.redirect((Call)routes.OpenPayments.payment(databaseId)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{newPaymentType}));
        }
        SepaPaymentForm paymentForm = sepaPaymentForm;
        if (paymentForm == null) {
            return OpenPayments.redirect((Call)routes.OpenPayments.payment(databaseId)).flashing("error", messages.at("payment.error.unknownpaymenttype", new Object[]{openPayment.getPmtType()}));
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (!form.hasErrors()) {
            paymentForm.setOpenPaymentVOWithPmtType(openPayment, newPaymentType);
            form = paymentForm.validateInputData((Form<? extends PaymentForm>)form, messages, this.formFactory, user, flashMap);
        }
        if (!form.hasErrors() && openPayment.getLockingUser() != null && !user.equals(openPayment.getLockingUser())) {
            form = form.withGlobalError(messages.at("editpayment.error.locked", new Object[]{openPayment.getLockingUser().getName()}));
        }
        Form deleteFolderForm = this.formFactory.form(DeleteFolderForm.class);
        Form newFolderForm = this.formFactory.form(PaymentFolderForm.class);
        Form changeFolderNameForm = this.formFactory.form(SimpleTextForm.class);
        Form paymentTemplateForm = this.formFactory.form(SimpleTextForm.class);
        Form folderSelectForm = this.formFactory.form(SimpleSelectionForm.class);
        Form periodicParametersForm = this.formFactory.form(PeriodicParametersForm.class);
        Form generateForm = this.formFactory.form(GenerateOpenPaymentFromTemplateForm.class).bindFromRequest(request, new String[0]);
        if (form.hasErrors()) {
            return OpenPayments.ok((Content)editpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.OPEN_PAYMENT, databaseId, currentPmtType, paymentForm.getClass(), OpenPayments.getLockingUserName(openPayment, user), openPayment.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateForm, inEditMode, request, messages));
        }
        try {
            paymentForm.store(user, flashMap, messages);
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to update payment with ID " + databaseId + "!", e);
            return OpenPayments.ok((Content)editpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.OPEN_PAYMENT, databaseId, currentPmtType, paymentForm.getClass(), OpenPayments.getLockingUserName(openPayment, user), openPayment.getFolder(), (Form<SimpleSelectionForm>)folderSelectForm, null, (Form<DeleteFolderForm>)deleteFolderForm, (Form<PaymentFolderForm>)newFolderForm, (Form<SimpleTextForm>)changeFolderNameForm, (Form<SimpleTextForm>)paymentTemplateForm, (Form<PeriodicParametersForm>)periodicParametersForm, (Form<GenerateOpenPaymentFromTemplateForm>)generateForm, inEditMode, request, messages)).flashing("HTMLerror", messages.at("payment.error.failedtosave", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
        Logger.logOpenPaymentModified((User)user, (OpenPayment)openPayment, (Logger.PaymentField)Logger.PaymentField.PAYMENT_TYPE, (String)currentPmtType.name(), (String)newPaymentType.name());
        this.checkPermissionForModifiedPayment(user, (Form<? extends PaymentForm>)form, flashMap, messages);
        flashMap.put("success", messages.at("payment.modified", new Object[0]));
        return OpenPayments.redirect((Call)routes.OpenPayments.payment(databaseId)).flashing(flashMap);
    }

    public CompletionStage<Result> prepareSign(Http.Request request) {
        return this.prepareSignPayments(request, null);
    }

    public CompletionStage<Result> prepareSignPayment(Http.Request request, Integer id) {
        return this.prepareSignPayments(request, id);
    }

    private CompletionStage<Result> prepareSignPayments(Http.Request request, Integer id) {
        play.api.mvc.Call redirectBack;
        String paymentIds;
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id != null) {
            paymentIds = id.toString();
            redirectBack = routes.OpenPayments.payment(id);
        } else {
            paymentIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectBack = routes.OpenPayments.index(true);
        }
        return CompletableFuture.supplyAsync(() -> {
            List<BankOrderPayment<PaymentHandler<?>>> bankOrderPayments;
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
            sorting.setProperty("selection", paymentIds);
            Query<OpenPayment> query = this.getSelectedPaymentsQuery(user, paymentIds);
            if (query == null) {
                return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("error", "Invalid payment IDs: " + paymentIds);
            }
            try {
                bankOrderPayments = BankOrder.loadPaymentsToSign(query, user);
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to load open payments!", e);
                return OpenPayments.redirect((Call)redirectBack).flashing("HTMLerror", messages.at("openpayments.error.failedtoloadbankorders", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
            if (bankOrderPayments.isEmpty()) {
                return OpenPayments.redirect((Call)redirectBack).flashing("error", messages.at("openpayments.error.nobankuserorready", new Object[0]));
            }
            BankOrderFactory factory = new BankOrderFactory(user, messages.lang().locale());
            factory.checkOpenPayments(user, bankOrderPayments);
            if (factory.getNumberOfInactivePayments() > 0) {
                int selectionSize = query.findCount();
                int numberOfPaymentsParam = selectionSize == 1 ? 1 : (selectionSize == factory.getNumberOfInactivePayments() ? 2 : 3);
                return OpenPayments.redirect((Call)redirectBack).flashing("error", PaymentApiMessages.getString((Locale)messages.lang().locale(), (String)"OpenPayments.sign.inactivePayments", (Object[])new Object[]{numberOfPaymentsParam}));
            }
            ArrayList<OpenPayment> toLock = new ArrayList<OpenPayment>();
            for (BankOrderPayment<PaymentHandler<?>> p2 : bankOrderPayments) {
                toLock.add(p2.getOpenPayment());
            }
            if (!OpenPayment.lockPayments((User)user, toLock)) {
                User lockingUser = OpenPayment.getLockingUser(toLock);
                if (user.equals(lockingUser)) {
                    return this.index(request, null, true, toLock.stream().map(p -> p.getId().toString()).collect(Collectors.joining(",")));
                }
                return OpenPayments.redirect((Call)redirectBack).flashing("error", PaymentApiMessages.getString((Locale)messages.lang().locale(), (String)"OpenPayments.paymentsLocked.message", (Object[])new Object[]{toLock.size(), lockingUser != null ? lockingUser.getName() : ""}));
            }
            try {
                if (!factory.getTooEarlyPayments().isEmpty()) {
                    OpenPayment.unlockPayments(toLock);
                    int maxOffset = this.getEarliestExecutionDateOffset(factory.getTooEarlyPayments());
                    return OpenPayments.redirect((Call)redirectBack).flashing("sign_prepare", PaymentApiMessages.getString((Locale)messages.lang().locale(), (String)"OpenPayments.executionDate.tooNew", (Object[])new Object[]{factory.getTooEarlyPayments().size(), query.findCount(), this.getDateFromOffset(maxOffset), maxOffset}));
                }
                if (!factory.getExceededPayments().isEmpty()) {
                    OpenPayment.unlockPayments(toLock);
                    return OpenPayments.redirect((Call)redirectBack).flashing("sign_prepare", PaymentApiMessages.getString((Locale)messages.lang().locale(), (String)"OpenPayments.executionDate.tooOld", (Object[])new Object[]{factory.getExceededPayments().size(), query.findCount()}));
                }
                if (!factory.getPaymentsToCorrect().isEmpty()) {
                    OpenPayment.unlockPayments(toLock);
                    return OpenPayments.redirect((Call)redirectBack).flashing("sign_prepare", (String)factory.getPaymentsToCorrect().keySet().iterator().next());
                }
                List<BankOrderWithPayments> bankOrders = BankOrderWithPayments.getListFromMap(factory.createBankOrders(user, bankOrderPayments));
                if (bankOrders.isEmpty()) {
                    return OpenPayments.redirect((Call)redirectBack).flashing("error", "openpayments.error.failedtocollectbankorders");
                }
                final HashMap flashMap = new HashMap();
                BankOrderCheckHandler checkHandler = new BankOrderCheckHandler(){
                    private boolean hasError;

                    @Override
                    public void unknownOriginatorAccount(String account) {
                        flashMap.put("error", messages.at("sent.send.error.unknownoriginatoraccount", new Object[]{account}));
                        this.hasError = true;
                    }

                    @Override
                    public void invalidBankConnection(String account) {
                        flashMap.put("error", messages.at("sent.send.error.invalidrecipientaccount", new Object[]{account}));
                        this.hasError = true;
                    }

                    @Override
                    public void exceededAmount(String message) {
                        flashMap.put("error", message);
                        this.hasError = true;
                    }

                    @Override
                    public void handleException(Exception e) {
                        flashMap.put("HTMLerror", Utils.getLocalizedMessage(e, messages));
                        this.hasError = true;
                    }

                    @Override
                    public boolean hasError() {
                        return this.hasError;
                    }
                };
                for (BankOrderWithPayments bankOrder : bankOrders) {
                    bankOrder.getBankOrder().checkPaymentInformation(user, messages.lang().locale(), checkHandler);
                    if (!checkHandler.hasError()) continue;
                    break;
                }
                if (checkHandler.hasError()) {
                    OpenPayment.unlockPayments(toLock);
                    bankOrders.forEach(bo -> OpenPayments.deleteOrderFile(bo.getBankOrder()));
                    return OpenPayments.redirect((Call)redirectBack).flashing(flashMap);
                }
                Form form = this.formFactory.form(SignOrdersForm.class).fill((Object)SignOrdersForm.fillForm(user, bankOrders));
                return OpenPayments.ok((Content)signorder.render((Form<SignOrdersForm>)form, bankOrders, Menu.OpenPayments, false, null, null, WebAuthnData.buildForSigning(user), null, request, messages));
            }
            catch (Throwable t) {
                OpenPayment.unlockPayments(toLock);
                BLLoggerPlay.error("Failed to create bank orders!", t);
                return OpenPayments.redirect((Call)redirectBack).flashing("HTMLerror", messages.at("openpayments.error.failedtocreatebankorders", new Object[]{Utils.getLocalizedMessage(t, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> fixPaymentsAndPrepareSign(Http.Request request) {
        return this.fixPaymentsAndPrepareSignPayments(request, null);
    }

    public CompletionStage<Result> fixPaymentsAndPrepareSignPayment(Http.Request request, Integer id) {
        return this.fixPaymentsAndPrepareSignPayments(request, id);
    }

    public CompletionStage<Result> fixPaymentsAndPrepareSignPayments(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        String paymentIds;
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id != null) {
            paymentIds = id.toString();
            redirectTo = routes.OpenPayments.payment(id);
        } else {
            paymentIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.OpenPayments.index(true);
        }
        return CompletableFuture.supplyAsync(() -> {
            List<BankOrderWithPayments> bankOrders;
            List<BankOrderPayment<PaymentHandler<?>>> bankOrderPayments;
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
            sorting.setProperty("selection", paymentIds);
            Query<OpenPayment> query = this.getSelectedPaymentsQuery(user, paymentIds);
            if (query == null) {
                return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("error", "Invalid payment IDs: " + paymentIds);
            }
            try {
                bankOrderPayments = BankOrder.loadPaymentsToSign(query, user);
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to load open payments!", e);
                return OpenPayments.redirect((Call)redirectTo).flashing("HTMLerror", messages.at("openpayments.error.failedtoloadbankorders", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
            if (bankOrderPayments.isEmpty()) {
                return OpenPayments.redirect((Call)redirectTo).flashing("error", messages.at("openpayments.error.nobankuserorready", new Object[0]));
            }
            BankOrderFactory factory = new BankOrderFactory(user, messages.lang().locale());
            factory.checkOpenPayments(user, bankOrderPayments);
            ArrayList<OpenPayment> toLock = new ArrayList<OpenPayment>();
            ArrayList<OpenPayment> toUnlock = new ArrayList<OpenPayment>();
            for (BankOrderPayment<PaymentHandler<?>> p : bankOrderPayments) {
                if (!user.equals(p.getOpenPayment().getLockingUser())) {
                    toLock.add(p.getOpenPayment());
                }
                toUnlock.add(p.getOpenPayment());
            }
            if (!OpenPayment.lockPayments((User)user, toLock)) {
                User lockingUser = OpenPayment.getLockingUser(toLock);
                return OpenPayments.redirect((Call)redirectTo).flashing("error", PaymentApiMessages.getString((Locale)messages.lang().locale(), (String)"OpenPayments.paymentsLocked.message", (Object[])new Object[]{query.findCount(), lockingUser != null ? lockingUser.getName() : ""}));
            }
            try {
                if (factory.getNumberOfInactivePayments() <= 0) {
                    if (!factory.getTooEarlyPayments().isEmpty()) {
                        int maxOffset = this.getEarliestExecutionDateOffset(factory.getTooEarlyPayments());
                        this.updateExecutionDate(user, factory.getTooEarlyPayments(), this.getDateFromOffset(maxOffset));
                    } else if (!factory.getExceededPayments().isEmpty()) {
                        this.updateExecutionDate(user, factory.getExceededPayments(), new Date());
                    } else if (!factory.getPaymentsToCorrect().isEmpty()) {
                        this.fixPayments(user, (List)factory.getPaymentsToCorrect().values().iterator().next());
                    }
                }
            }
            catch (PaymentException e) {
                OpenPayment.unlockPayments(toUnlock);
                BLLoggerPlay.error("Failed to fix payments for signing them!", e);
                return OpenPayments.redirect((Call)redirectTo).flashing("HTMLerror", messages.at("openpayments.error.failedtofixpayments", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
            try {
                bankOrders = BankOrderWithPayments.getListFromMap(factory.createBankOrders(user, bankOrderPayments));
            }
            catch (Exception e) {
                return OpenPayments.redirect((Call)redirectTo).flashing("HTMLerror", messages.at("openpayments.error.failedtocollectbankorders", new Object[0]) + ": " + Utils.getLocalizedMessage(e, messages));
            }
            if (bankOrders.isEmpty()) {
                OpenPayment.unlockPayments(toUnlock);
                return OpenPayments.redirect((Call)redirectTo).flashing("error", "openpayments.error.failedtocollectbankorders");
            }
            final HashMap flashMap = new HashMap();
            BankOrderCheckHandler checkHandler = new BankOrderCheckHandler(){
                private boolean hasError;

                @Override
                public void unknownOriginatorAccount(String account) {
                    flashMap.put("error", messages.at("sent.send.error.unknownoriginatoraccount", new Object[]{account}));
                    this.hasError = true;
                }

                @Override
                public void invalidBankConnection(String account) {
                    flashMap.put("error", messages.at("sent.send.error.invalidrecipientaccount", new Object[]{account}));
                    this.hasError = true;
                }

                @Override
                public void exceededAmount(String message) {
                    flashMap.put("error", message);
                    this.hasError = true;
                }

                @Override
                public void handleException(Exception e) {
                    flashMap.put("HTMLerror", Utils.getLocalizedMessage(e, messages));
                    this.hasError = true;
                }

                @Override
                public boolean hasError() {
                    return this.hasError;
                }
            };
            for (BankOrderWithPayments bankOrder : bankOrders) {
                bankOrder.getBankOrder().checkPaymentInformation(user, messages.lang().locale(), checkHandler);
                if (!checkHandler.hasError()) continue;
                break;
            }
            if (checkHandler.hasError()) {
                bankOrders.forEach(bo -> OpenPayments.deleteOrderFile(bo.getBankOrder()));
                OpenPayment.unlockPayments(toUnlock);
                return OpenPayments.redirect((Call)redirectTo).flashing(flashMap);
            }
            Form form = this.formFactory.form(SignOrdersForm.class).fill((Object)SignOrdersForm.fillForm(user, bankOrders));
            return OpenPayments.ok((Content)signorder.render((Form<SignOrdersForm>)form, bankOrders, Menu.OpenPayments, false, null, null, WebAuthnData.buildForSigning(user), null, request, messages));
        }, this.executionContext.current());
    }

    public CompletionStage<Result> signOrder(Http.Request request) {
        Form form = this.formFactory.form(SignOrdersForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        play.api.mvc.Call redirectTo = routes.OpenPayments.index(false);
        return CompletableFuture.supplyAsync(() -> {
            String bankOrderStrings = String.join((CharSequence)"", ((SignOrdersForm)form.get()).bankOrdersStrings);
            if (!BankOrder.checkForDoubleTransmission(bankOrderStrings)) {
                return OpenPayments.redirect((Call)redirectTo).flashing("warning", messages.at("sent.send.error.double", new Object[]{bankOrderStrings}));
            }
            try {
                Form passwordResultForm;
                List<BankOrderWithPayments> bankOrders;
                if (bankOrderStrings.isEmpty()) {
                    Result result = OpenPayments.redirect((Call)redirectTo).flashing("error", messages.at("sent.send.error.invalidparameter", new Object[]{bankOrderStrings}));
                    return result;
                }
                try {
                    bankOrders = BankOrder.getBankOrdersFromRequestString(user, bankOrderStrings, ((SignOrdersForm)form.get()).additionalInfos, ((SignOrdersForm)form.get()).useVop, messages.lang().toLocale());
                }
                catch (DisplayFileException | KnownFormatException | IOException e) {
                    Result result = OpenPayments.redirect((Call)redirectTo).flashing("HTMLerror", messages.at("openpayments.sign.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                    BankOrder.finishedBankOrder(bankOrderStrings);
                    return result;
                }
                if (bankOrders == null || bankOrders.isEmpty()) {
                    Result e = OpenPayments.redirect((Call)redirectTo).flashing("error", messages.at("openpayments.sign.error.ordernotfound", new Object[0]));
                    return e;
                }
                if (!form.hasErrors()) {
                    passwordResultForm = ((SignOrdersForm)form.get()).checkPassword(form, user, PasswordForm.PasswordType.EBICS_PASSWORD, messages.lang().locale());
                    if (passwordResultForm.value().isPresent() && ((SignOrdersForm)passwordResultForm.value().get()).isUserLocked()) {
                        BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                        bankOrders.forEach(bo -> OpenPayment.unlockPayments(bo.getOpenPayments()));
                        bankOrders.forEach(bo -> OpenPayments.deleteOrderFile(bo.getBankOrder()));
                        Result result = OpenPayments.redirect((Call)redirectTo).flashing("error", messages.at("login.locked.user", new Object[0]));
                        return result;
                    }
                } else {
                    passwordResultForm = form;
                }
                if (passwordResultForm.hasErrors()) {
                    Result result = OpenPayments.ok((Content)signorder.render(passwordResultForm, bankOrders, Menu.OpenPayments, true, null, null, WebAuthnData.buildForSigning(user), null, request, messages));
                    return result;
                }
                HashMap<String, String> flashMap = new HashMap<String, String>();
                Map<Integer, Integer> sendOrders = Sent.sendOrders(bankOrders, ((SignOrdersForm)form.get()).password.toCharArray(), new BankOrderResultHandler(messages, flashMap), null, Setup.getIPAddress(request));
                int signedPaymentsNumber = 0;
                for (Integer i : sendOrders.values()) {
                    signedPaymentsNumber += i.intValue();
                }
                StringBuilder ids = new StringBuilder();
                for (Integer i : sendOrders.keySet()) {
                    if (!ids.isEmpty()) {
                        ids.append(",");
                    }
                    ids.append(i.toString());
                }
                flashMap.put("success", messages.at("openpayments.signed", new Object[]{signedPaymentsNumber}));
                flashMap.put("sendItems", ids.toString());
                Result result = OpenPayments.redirect((Call)redirectTo).flashing(flashMap);
                return result;
            }
            finally {
                BankOrder.finishedBankOrder(bankOrderStrings);
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> savePayments(Http.Request request) {
        return this.savePaymentsAction(request, null);
    }

    public CompletionStage<Result> savePayment(Http.Request request, Integer id) {
        return this.savePaymentsAction(request, id);
    }

    public CompletionStage<Result> savePaymentsAction(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        String paymentIds;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id != null) {
            paymentIds = id.toString();
            redirectTo = routes.OpenPayments.payment(id);
        } else {
            paymentIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.OpenPayments.index(true);
        }
        return CompletableFuture.supplyAsync(() -> {
            List<BankOrderPayment<PaymentHandler<?>>> bankOrderPayments;
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
            sorting.setProperty("selection", paymentIds);
            Query<OpenPayment> query = this.getSelectedPaymentsQuery(user, paymentIds);
            if (query == null) {
                return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("error", "Invalid payment IDs: " + paymentIds);
            }
            try {
                bankOrderPayments = BankOrder.loadPayments(query, user);
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to load open payments!", e);
                return OpenPayments.redirect((Call)redirectTo).flashing("HTMLerror", messages.at("openpayments.error.failedtocreatebankorders", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
            BankOrderFactory factory = new BankOrderFactory(user, messages.lang().locale());
            List<BankOrderWithPayments> bankOrders = BankOrderWithPayments.getListFromMap(factory.createBankOrders(user, bankOrderPayments));
            if (bankOrders.isEmpty()) {
                return OpenPayments.redirect((Call)redirectTo).flashing("error", messages.at("payment.save.nopaymentfile", new Object[0]));
            }
            try {
                if (bankOrders.size() != 1) {
                    List<File> orderFiles = bankOrders.stream().map(bo -> bo.getBankOrder().getOrderFile()).collect(Collectors.toList());
                    return GeneralUtils.supplyZipFile(orderFiles, false, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("paymentOrders.zip"));
                }
                BankOrder bankOrder = bankOrders.getFirst().getBankOrder();
                return GeneralUtils.supplyWorkspaceFile(bankOrder.getOrderFile(), false, true).withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(bankOrder.getOrderFile().getName())).as("binary/octet-stream");
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to read bank order file", e);
                return OpenPayments.redirect((Call)redirectTo).flashing("HTMLerror", messages.at("openpayments.error.failedtoloadbankorders", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public Result deletePayments(Http.Request request) {
        return this.deleteOpenPayments(request, null);
    }

    public Result deletePayment(Http.Request request, Integer id) {
        return this.deleteOpenPayments(request, id);
    }

    public Result deleteOpenPayments(Http.Request request, Integer id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String paymentIds = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
        sorting.setProperty("selection", paymentIds);
        Query<OpenPayment> query = this.getSelectedPaymentsQuery(user, paymentIds);
        if (query == null) {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("error", "Invalid payment IDs: " + paymentIds);
        }
        List ids = query.findIds();
        for (OpenPayment paymentToDelete : DB.find(OpenPayment.class).where().in("id", (Collection)ids).findList()) {
            Logger.logOpenPaymentDeleted((User)user, (OpenPayment)paymentToDelete);
        }
        DB.deleteAll(OpenPayment.class, (Collection)ids);
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("success", messages.at("payment.deletedpayments", new Object[]{ids.size()}));
    }

    public CompletionStage<Result> duplicate(Http.Request request) {
        return this.duplicateAction(request, null);
    }

    public CompletionStage<Result> duplicatePayment(Http.Request request, Integer id) {
        return this.duplicateAction(request, id);
    }

    public CompletionStage<Result> duplicateAction(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        String paymentIds;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id != null) {
            paymentIds = id.toString();
            redirectTo = routes.OpenPayments.payment(id);
        } else {
            paymentIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.OpenPayments.index(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            Query<OpenPayment> query = this.getSelectedPaymentsQuery(user, paymentIds);
            int counter = 0;
            if (query != null) {
                try (Transaction t = DB.beginTransaction();){
                    for (OpenPayment toCopy : query.findList()) {
                        if (BankUser.findBankUser((BankSettings)toCopy.getBank(), (User)user) == null) continue;
                        OpenPayment newPayment = new OpenPayment();
                        newPayment.setBank(toCopy.getBank());
                        newPayment.setAccount(toCopy.getAccount());
                        newPayment.setOrderType(toCopy.getOrderType());
                        newPayment.setFileType(toCopy.getFileTypeOrBTF());
                        newPayment.setPmtType(toCopy.getPmtType());
                        newPayment.setCredit(toCopy.isCredit());
                        newPayment.setUrgent(toCopy.isUrgent());
                        newPayment.setRecipient(toCopy.getRecipient());
                        newPayment.setAmount(toCopy.getAmount());
                        newPayment.setAmountCurrency(toCopy.getAmountCurrency());
                        newPayment.setPurpose(toCopy.getPurpose());
                        newPayment.setExecutionDate(toCopy.getExecutionDate());
                        newPayment.setPaymentData(toCopy.getPaymentData());
                        newPayment.setFolder(toCopy.getFolder());
                        newPayment.setSalaryPayment(toCopy.getSalaryPayment());
                        newPayment.setOriginator(toCopy.getOriginator());
                        newPayment.save(user, false);
                        Logger.logOpenPaymentCreated((User)user, (OpenPayment)newPayment);
                        ++counter;
                    }
                    t.commit();
                }
            }
            return OpenPayments.redirect((Call)redirectTo).flashing("success", messages.at("payment.duplicated", new Object[]{counter}));
        }, this.executionContext.current());
    }

    public Result moveToFolder(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Map<String, String> flashMap = Payments.moveToFolder(request, this.formFactory, this.messagesApi);
        String paymentIds = flashMap.get("paymentIds");
        flashMap.remove("paymentIds");
        if (!Utils.hasSuccessFlash(flashMap)) {
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
            sorting.setProperty("selection", paymentIds);
            return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing(flashMap);
        }
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing(flashMap);
    }

    public CompletionStage<Result> modifyPayments(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form form = this.formFactory.form(ModifyOpenPaymentsForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> flashMap;
            String paymentIds;
            block10: {
                Form<ModifyOpenPaymentsForm> validatedForm;
                if (!form.hasErrors()) {
                    paymentIds = ((ModifyOpenPaymentsForm)form.get()).paymentIds;
                    validatedForm = ((ModifyOpenPaymentsForm)form.get()).validate(form, user);
                } else {
                    paymentIds = "";
                    validatedForm = form;
                }
                Query<OpenPayment> query = this.getSelectedPaymentsQuery(user, paymentIds);
                flashMap = new HashMap<String, String>();
                if (!validatedForm.hasErrors()) {
                    try {
                        int count = ((ModifyOpenPaymentsForm)validatedForm.get()).modify(BankOrder.loadPayments(query, user), user);
                        if (count == 0) {
                            flashMap.put("warning", messages.at("openpayments.modifypayments.done", new Object[]{count}));
                            break block10;
                        }
                        flashMap.put("success", messages.at("openpayments.modifypayments.done", new Object[]{count}));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.error("Error modifying a payment!", e);
                        flashMap.put("HTMLerror", messages.at("openpayments.error.failedtomodify", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                    }
                } else {
                    int count = query.findCount();
                    if (count == 0) {
                        flashMap.put("error", messages.at("payment.error.nopaymentsselected", new Object[0]));
                    } else {
                        flashMap.put("error", messages.at("openpayments.error.modifypaymentsformerror", new Object[]{count}));
                    }
                }
            }
            if (!Utils.hasSuccessFlash(flashMap)) {
                SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
                sorting.setProperty("selection", paymentIds);
                return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing(flashMap);
            }
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing(flashMap);
        }, this.executionContext.current());
    }

    public Result createNewFolder(Http.Request request) {
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing(Payments.createNewFolder(request, this.formFactory, this.messagesApi));
    }

    public Result changeFolderName(Http.Request request, Integer folderId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentFolder paymentFolder = PaymentFolder.findById((Integer)folderId, (User)user);
        if (paymentFolder == null) {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("openpayments.folder.foldernotfound", new Object[0]));
        }
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing(Payments.renameFolder(request, paymentFolder, this.formFactory, this.messagesApi));
    }

    public Result deleteFolder(Http.Request request, Integer folderId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_OPEN);
        return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing(Payments.deleteFolder(request, this.formFactory, this.messagesApi, folderId, sorting));
    }

    public CompletionStage<Result> printOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String paymentIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> {
            try {
                Query<OpenPayment> query;
                if (paymentIds == null || paymentIds.isEmpty()) {
                    Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_OPEN);
                    Properties props = GeneralUtils.getSortingProperties(sorting);
                    int folderId = Integer.parseInt(props.getProperty("folder", "-1"));
                    PaymentFilter filter = PaymentFilter.getFilter((User)user);
                    if (!filter.isOpenPaymentsFilterActive()) {
                        filter = null;
                    }
                    query = this.getDefaultQuery(user, sorting, Payments.getFolder(user, folderId), filter);
                } else {
                    query = this.getSelectedPaymentsQuery(user, paymentIds);
                }
                List toPrint = query.findList();
                Iterator iter = toPrint.iterator();
                while (iter.hasNext()) {
                    OpenPayment openPayment = (OpenPayment)iter.next();
                    if (BankUser.findBankUser((BankSettings)openPayment.getBank(), (User)user) != null) continue;
                    iter.remove();
                }
                File file2 = new OpenPaymentsTableOverviewPrinter(this, user, messages.lang().locale(), BLLoggerPlay.getLogger(), GeneralUtils.printLogo(user)){
                    private Integer lastPaymentId;
                    private PaymentHandler<?> paymentHandler;

                    protected boolean isSalaryPayment(OpenPayment payment) {
                        PaymentHandler<?> paymentHandler = this.getPaymentData(payment);
                        if (paymentHandler != null) {
                            return paymentHandler.isSalaryPayment();
                        }
                        return false;
                    }

                    protected String getRecipientAccountRepresentation(OpenPayment payment) {
                        PaymentHandler<?> paymentHandler = this.getPaymentData(payment);
                        if (paymentHandler != null) {
                            return paymentHandler.getRecipientAccount();
                        }
                        return "";
                    }

                    private PaymentHandler<?> getPaymentData(OpenPayment payment) {
                        if (this.paymentHandler == null || !payment.getId().equals(this.lastPaymentId)) {
                            try {
                                this.paymentHandler = PaymentHandler.getHandler(payment.getPmtType(), payment.getPaymentData());
                                this.lastPaymentId = payment.getId();
                            }
                            catch (PaymentException e) {
                                BLLoggerPlay.error("Failed to load payment handler for open payment " + payment.getId(), e);
                                this.paymentHandler = null;
                                this.lastPaymentId = null;
                            }
                        }
                        return this.paymentHandler;
                    }
                }.print(toPrint);
                return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to print open payments overview to PDF file!", e);
                SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
                sorting.setProperty("selection", paymentIds);
                return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToPrintPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> exportOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String paymentIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        boolean includeIban = new SortingHandler(user, Sorting.Table.PMT_OPEN).isColumnDisplayed(7);
        return CompletableFuture.supplyAsync(() -> {
            Query<OpenPayment> query;
            if (paymentIds == null || paymentIds.isEmpty()) {
                Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.PMT_OPEN);
                Properties props = GeneralUtils.getSortingProperties(sorting);
                int folderId = Integer.parseInt(props.getProperty("folder", "-1"));
                PaymentFilter filter = PaymentFilter.getFilter((User)user);
                if (!filter.isOpenPaymentsFilterActive()) {
                    filter = null;
                }
                query = this.getDefaultQuery(user, sorting, Payments.getFolder(user, folderId), filter);
            } else {
                query = this.getSelectedPaymentsQuery(user, paymentIds);
            }
            try {
                String filename = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)Branding.getBranding().getOpenPaymentsLabel(), (Object[])new Object[0]) + ".csv";
                File tmpFile = Util.createTempFile((String)filename, (String)".tmp", (boolean)true);
                OutputStream outputStream = EncryptData.getInstance().openOutputStream(tmpFile);
                try {
                    List toExport = query.findList();
                    Iterator iter = toExport.iterator();
                    while (iter.hasNext()) {
                        OpenPayment openPayment = (OpenPayment)iter.next();
                        if (BankUser.findBankUser((BankSettings)openPayment.getBank(), (User)user) != null) continue;
                        iter.remove();
                    }
                    new OpenPaymentsTableCsvExport(this, messages.lang().locale(), Util.displayOpenSalaries((User)user), PaymentFolder.hasFolders((User)user), includeIban){

                        protected boolean isSalaryPayment(OpenPayment payment) {
                            try {
                                PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(payment.getPmtType(), payment.getPaymentData());
                                return paymentHandler.isSalaryPayment();
                            }
                            catch (PaymentException e) {
                                BLLoggerPlay.error("Failed to determine, if open payment is a salary payment!", e);
                                return false;
                            }
                        }

                        protected String getPaymentTypeDescription(OpenPayment payment) {
                            return new PaymentTypeUtil(messages.lang().toLocale()).getNameForOpenPaymentOverview(payment);
                        }
                    }.write(outputStream, (Iterable)toExport);
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        BLLoggerPlay.warning("Failed to close output stream on temporary file " + tmpFile.getAbsolutePath() + "!", e);
                    }
                }
                return GeneralUtils.supplyWorkspaceFile(tmpFile, false, true).as("text/comma-separated-values").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(filename));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to export open payments overview to CSV file!", e);
                SortingHandler sorting = new SortingHandler(user, Sorting.Table.PMT_OPEN);
                sorting.setProperty("selection", paymentIds);
                return OpenPayments.redirect((Call)routes.OpenPayments.index(true)).flashing("HTMLerror", messages.at("payment.error.failedtoexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public Result getBicFromIban(String iban) {
        if (IbanUtil.isGermanIban((String)iban)) {
            String bankCode = IbanUtil.getBankCode((String)iban);
            if (bankCode == null) {
                return OpenPayments.badRequest();
            }
            BankInfo bankInfo = BLZCache.CACHE.findByBankCode(bankCode);
            if (bankInfo == null) {
                return OpenPayments.badRequest();
            }
            String bic = bankInfo.getBicCode();
            if (bic != null) {
                return OpenPayments.ok((String)bic);
            }
        }
        return OpenPayments.badRequest();
    }

    private Query<OpenPayment> getSelectedPaymentsQuery(User user, String paymentIds) {
        Query q;
        List<Integer> idsList;
        if (paymentIds != null && !paymentIds.isEmpty() && !(idsList = GeneralUtils.getSelectionIds(paymentIds)).isEmpty() && (q = OpenPayments.getQueryCheckPermission(user).where().in("id", idsList).orderBy("id").query()).findCount() > 0) {
            return q;
        }
        return null;
    }

    private int getEarliestExecutionDateOffset(List<BankOrderPayment<PaymentHandler<?>>> payments) {
        int maxOffset = -1;
        HashMap<Integer, PaymentProperties> paymentPropertiesMap = new HashMap<Integer, PaymentProperties>();
        for (BankOrderPayment<PaymentHandler<?>> p : payments) {
            PaymentProperties paymentProperties = (PaymentProperties)paymentPropertiesMap.get(p.getOpenPayment().getBank().getBankId());
            if (paymentProperties == null) {
                paymentProperties = PaymentProperties.findForBank((BankSettings)p.getOpenPayment().getBank());
                paymentPropertiesMap.put(p.getOpenPayment().getBank().getBankId(), paymentProperties);
            }
            int tmpOffset = ((PaymentHandler)p.getPaymentData()).getMaxExecutionDateOffset(paymentProperties);
            if (maxOffset >= 0 && tmpOffset >= maxOffset) continue;
            maxOffset = tmpOffset;
        }
        return maxOffset;
    }

    private Date getDateFromOffset(int offset) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, offset);
        return DateUtils.getPreviousWorkingDay((Calendar)cal).getTime();
    }

    private void updateExecutionDate(User user, List<BankOrderPayment<PaymentHandler<?>>> payments, Date executionDate) throws PaymentException {
        try (Transaction t = DB.beginTransaction();){
            HashMap<BankSettings, PaymentProperties> paymentPropertiesMap = new HashMap<BankSettings, PaymentProperties>();
            for (BankOrderPayment<PaymentHandler<?>> p : payments) {
                BankSettings bank = p.getOpenPayment().getBank();
                PaymentProperties paymentProperties = (PaymentProperties)paymentPropertiesMap.get(bank);
                if (paymentProperties == null) {
                    paymentProperties = PaymentProperties.findForBank((BankSettings)bank);
                    paymentPropertiesMap.put(bank, paymentProperties);
                }
                ((PaymentHandler)p.getPaymentData()).setEarliestExecutionDate(executionDate, bank, paymentProperties);
                p.getOpenPayment().setExecutionDate(new Timestamp(((PaymentHandler)p.getPaymentData()).getExecutionDate().getTime()));
                p.getOpenPayment().setPaymentData(((PaymentHandler)p.getPaymentData()).buildPaymentData(bank));
                p.getOpenPayment().save(user, false);
            }
            t.commit();
        }
    }

    private void fixPayments(User user, List<BankOrderPayment<PaymentHandler<?>>> payments) throws PaymentException {
        try (Transaction t = DB.beginTransaction();){
            for (BankOrderPayment<PaymentHandler<?>> p : payments) {
                ((PaymentHandler)p.getPaymentData()).correctPayment(p.getOpenPayment(), user);
                p.getOpenPayment().setPaymentData(((PaymentHandler)p.getPaymentData()).buildPaymentData(p.getOpenPayment().getBank()));
                p.getOpenPayment().save(user, false);
            }
            t.commit();
        }
    }

    public Result unlockPayments(Http.Request request) {
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        play.api.mvc.Call redirectTo = routes.OpenPayments.index(true);
        String paymentIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List paymentsToUnlock = GeneralUtils.getSelectionIds(paymentIds).stream().map(OpenPayment::findById).collect(Collectors.toList());
        if (paymentsToUnlock.isEmpty()) {
            return OpenPayments.redirect((Call)redirectTo).flashing("error", messages.at("payment.open.paymentnotfound", new Object[]{1}));
        }
        List visibleBanks = operator.isAdminOrTenantAdmin() ? BankSettings.findBanksForTenants((List)operator.getManageableTenants()) : BankSettings.findBanksForUser((User)operator);
        if ((paymentsToUnlock = paymentsToUnlock.stream().filter(p -> visibleBanks.contains(p.getBank())).collect(Collectors.toList())).isEmpty()) {
            return OpenPayments.redirect((Call)redirectTo).flashing("error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
        }
        int count = OpenPayment.unlockPayments(paymentsToUnlock);
        String flashKey = count == 0 ? "info" : "success";
        return OpenPayments.redirect((Call)redirectTo).flashing(flashKey, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.unlockedPayments", (Object[])new Object[]{count}));
    }

    private void checkPermissionForModifiedPayment(User user, Form<? extends PaymentForm> form, Map<String, String> flashMap, Messages messages) {
        Integer databaseId = ((PaymentForm)form.get()).getDatabaseId();
        if (databaseId != null && OpenPayments.getQueryCheckPermission(user).where().eq("id", (Object)databaseId).findOne() == null) {
            PaymentTransferType.PmtType pmtType = PaymentTransferType.PmtType.valueOf((String)((PaymentForm)form.get()).getPmtType().name());
            String orderType = SendParameters.getTransferTypeByAccount((Integer)((PaymentForm)form.get()).originatorAccountId, (PaymentTransferType.PmtType)pmtType);
            flashMap.put("warning", messages.at("payment.warning.missingpermissionforpayment", new Object[]{orderType}));
        }
    }

    public CompletionStage<Result> printHTDReport(Http.Request request) {
        User currentUser = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            try {
                File dest = Util.createTempFile((String)"HTDReport", (String)".pdf", (boolean)true);
                FileOutputStream fos = new FileOutputStream(dest);
                Date now = new Date();
                BLDocument document = Util.createBLDocument((OutputStream)fos, (BLDocument.PageLayout)BLDocument.PageLayout.A4_LANDSCAPE, (String)messages.at("openpayments.printHTDReport.title", new Object[]{now}), (boolean)GeneralUtils.printLogo(currentUser), (Locale)messages.lang().toLocale());
                document.addHeadline(messages.at("openpayments.printHTDReport.title", new Object[]{now}));
                PDFCreator creator = PDFCreator.getInstance();
                boolean foundAtLeastOneUser = false;
                for (User user : Branding.getBranding().getUserForHTDReport(currentUser)) {
                    for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
                        BankUserHtdInfo htd = BankUserHtdInfo.findForBankUser((BankUser)bankUser);
                        if (htd == null) continue;
                        foundAtLeastOneUser = true;
                        document.addText(messages.at("openpayments.printHTDReport.customerName", new Object[]{bankUser.getBank().getDisplayName()}));
                        document.addNewLine();
                        document.addText(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.customerID2", (Object[])new Object[]{bankUser.getBank().getCustomerId()}));
                        document.addNewLine();
                        document.addText(messages.at("openpayments.printHTDReport.userName", new Object[]{htd.getUserName()}));
                        document.addNewLine();
                        document.addText(messages.at("openpayments.printHTDReport.userId", new Object[]{htd.getUserId()}));
                        document.addNewLine();
                        document.addNewLine();
                        BLTable table = creator.createTable(6);
                        table.setWidths(new int[]{2, 2, 7, 2, 3, 3});
                        table.addCell(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountNumber", (Object[])new Object[0]));
                        table.addCell(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.blzBic", (Object[])new Object[0]));
                        table.addCell(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountOwner", (Object[])new Object[0]));
                        table.addCell(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.currency", (Object[])new Object[0]));
                        table.addCell(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.orderTypes", (Object[])new Object[0]));
                        table.addCell(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.signatureClass", (Object[])new Object[0]));
                        List accountPermissions = AccountPermission.findByBankUser((BankUser)bankUser).findList();
                        List userPermissions = UserPermission.findByBankUser((BankUser)bankUser).findList();
                        List orderTypes = OrderTypeUtil.findOrderTypesForSendDialog((BankUser)bankUser);
                        for (Account account : Account.findAccountsForBank((BankSettings)bankUser.getBank())) {
                            Object p2;
                            boolean found = false;
                            for (Object p2 : accountPermissions) {
                                if (!p2.getAccount().equals(account)) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            if (account.getGermanAccountNumber() == null || account.getGermanAccountNumber().isEmpty()) {
                                table.addCell(account.getIban());
                            } else {
                                table.addCell(account.getGermanAccountNumber());
                            }
                            if (account.getGermanBankCode() == null || account.getGermanBankCode().isEmpty()) {
                                table.addCell(account.getBic());
                            } else {
                                table.addCell(account.getGermanBankCode());
                            }
                            table.addCell(account.getAccountHolderHTD());
                            table.addCell(account.getCurrency());
                            TreeMap<UserPermission.AuthorizationLevel, Set> permissions = new TreeMap<UserPermission.AuthorizationLevel, Set>();
                            p2 = userPermissions.iterator();
                            while (p2.hasNext()) {
                                UserPermission p3 = (UserPermission)p2.next();
                                if (p3.getAuthLevel() == null || !orderTypes.contains(p3.getOrderType()) || p3.getAccountPermission() != null && !Objects.equals(p3.getAccountPermission().getAccount().getId(), account.getId())) continue;
                                Set set = permissions.computeIfAbsent(p3.getAuthLevel(), authorizationLevel -> new TreeSet());
                                set.add(p3.getOrderType().getGeneralizedOrderType());
                            }
                            boolean first = true;
                            for (UserPermission.AuthorizationLevel l : permissions.keySet()) {
                                if (!first) {
                                    table.addEmptyCell(4);
                                }
                                first = false;
                                StringBuilder b = new StringBuilder();
                                for (String s : (Set)permissions.get(l)) {
                                    if (!b.isEmpty()) {
                                        b.append(", ");
                                    }
                                    b.append(s);
                                }
                                table.addCell(b.toString());
                                String name = switch (l) {
                                    default -> throw new MatchException(null, null);
                                    case UserPermission.AuthorizationLevel.FIRST -> "A-";
                                    case UserPermission.AuthorizationLevel.SECOND -> "B-";
                                    case UserPermission.AuthorizationLevel.SINGLE -> "E-";
                                    case UserPermission.AuthorizationLevel.TRANSPORT -> "T-";
                                };
                                table.addCell(messages.at("sent.signed", new Object[]{name}));
                            }
                            if (!permissions.keySet().isEmpty()) continue;
                            table.addCell("");
                            table.addCell("");
                        }
                        document.addTable(table);
                        document.addNewLine();
                    }
                }
                document.addNewLine();
                Branding.getBranding().addToHTDReport(creator, document, messages);
                document.close();
                if (foundAtLeastOneUser) {
                    return GeneralUtils.supplyWorkspaceFile(dest, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("REPORT.pdf"));
                }
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("openpayments.error.failedfetchhtd", new Object[0]));
            }
            catch (Exception e) {
                BLLoggerPlay.error("Failed to create HTD report!", e);
                return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", e.toString());
            }
        }, this.executionContext.current());
    }

    public Result createFromBookings(Http.Request request, Integer accountId, Integer statementId, Integer pageId, Integer folder) {
        return this.createFromBookingOrDti(request, routes.Bookings.bookings(accountId, null, statementId, pageId, folder, null), true, accountId, statementId, pageId, folder);
    }

    public Result createFromDti(Http.Request request, Integer accountId, Integer statementId) {
        return this.createFromBookingOrDti(request, routes.DtiView.dti(accountId, statementId, null), false, accountId, statementId, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public Result createFromBookingOrDti(Http.Request request, play.api.mvc.Call redirect, boolean bookings2, Integer accountIdRedirect, Integer statementId, Integer pageId, Integer folder) {
        Form form;
        String bookingIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        List<Integer> ids = GeneralUtils.getSelectionIds(bookingIds);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        PaymentTransferType.PmtType pmtType = PaymentTransferType.PmtType.SEPA_TRANSFER;
        HashMap<String, String> flashMap = new HashMap<String, String>();
        boolean saveRecipient = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SAVE_RECIPIENT);
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)user);
        boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
        if (!PaymentUtils.canUserCreatePayments((String)request.attrs().get(Security.USERNAME), pmtType)) {
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing("error", messages.at("payment.error.nopermission.pmttype", new Object[]{pmtType.name()}));
        }
        if (ids.size() > 1) {
            ArrayList<SepaPaymentForm> formsToStore = new ArrayList<SepaPaymentForm>();
            ArrayList<Integer> idsToStore = new ArrayList<Integer>();
            for (CmBooking booking : DB.find(CmBooking.class).where().in("id", ids).findList()) {
                try {
                    SepaPaymentForm sepaForm = new SepaPaymentForm(booking, user, flashMap, messages, true, allowRecipientRecording, useMandates, saveRecipient);
                    sepaForm.referer = redirect.toString();
                    Form form2 = this.formFactory.form(SepaPaymentForm.class).fill((Object)sepaForm);
                    sepaForm.setDefaultValues(pmtType);
                    SepaPaymentForm paymentForm = sepaForm;
                    try {
                        void var22_30;
                        String accountId = Utils.fieldValue(form2, "originatorAccountId");
                        if (accountId == null) {
                            Form form3 = form2.withError("originatorAccountId", "error.invalid");
                            continue;
                        }
                        BankSettings bank = Account.findById((int)Integer.parseInt(accountId)).getBank();
                        String orderType = SendParameters.getOrderType((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
                        String fileType = SendParameters.getBTF((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
                        if (!Util.isOrderType((String)orderType)) {
                            BLLoggerPlay.warning("Try to save open payment with unexpected order type '" + orderType + "'");
                        }
                        PaymentFolder selectedFolder = null;
                        paymentForm.createNewVO(PaymentContextType.OPEN_PAYMENT, pmtType, orderType, fileType, selectedFolder);
                        if (!form2.hasErrors()) {
                            Form<? extends PaymentForm> form4 = paymentForm.validateInputData((Form<? extends PaymentForm>)form2, messages, this.formFactory, user, flashMap);
                        }
                        if (var22_30.hasErrors()) continue;
                        formsToStore.add(paymentForm);
                        idsToStore.add(booking.getId());
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.error("Failed to store new payment for payment type " + String.valueOf(pmtType) + "! (bookingid=" + booking.getId() + ")", e);
                    }
                }
                catch (PaymentException paymentException) {
                    BLLoggerPlay.error("Failed to create new payment! (bookingid=" + booking.getId() + ")", paymentException);
                }
            }
            if (formsToStore.size() != ids.size()) {
                if (formsToStore.isEmpty()) {
                    return OpenPayments.redirect((Call)redirect).flashing("error", messages.at("bookings.createsepa.errorAll", new Object[0]));
                }
                String selectedIds = ((Object)idsToStore).toString();
                selectedIds = selectedIds.substring(1, selectedIds.length() - 1);
                String errormsg = messages.at("bookings.createsepa.error", new Object[]{formsToStore.size(), ids.size() - formsToStore.size()});
                if (bookings2) {
                    return OpenPayments.redirect((Call)routes.Bookings.bookings(accountIdRedirect, null, statementId, pageId, folder, selectedIds)).flashing("error", errormsg);
                }
                return OpenPayments.redirect((Call)routes.DtiView.dti(accountIdRedirect, statementId, selectedIds)).flashing("error", errormsg);
            }
            int savedOnes = 0;
            for (PaymentForm paymentForm : formsToStore) {
                try {
                    paymentForm.store(user, flashMap, messages);
                    ++savedOnes;
                }
                catch (PaymentException e) {
                    BLLoggerPlay.error("Failed to create new payment!", e);
                }
            }
            int notSaved = formsToStore.size() - savedOnes;
            if (notSaved == 0) {
                flashMap.put("success", messages.at("payment.open.created", new Object[]{savedOnes}));
            } else {
                flashMap.put("success", messages.at("payment.open.created.someFailed", new Object[]{savedOnes, notSaved}));
            }
            return OpenPayments.redirect((Call)routes.OpenPayments.index(false)).flashing(flashMap);
        }
        try {
            CmBooking booking = CmBooking.findById((int)ids.getFirst());
            SepaPaymentForm sepaForm = new SepaPaymentForm(booking, user, flashMap, messages, true, allowRecipientRecording, useMandates, saveRecipient);
            sepaForm.referer = redirect.toString();
            form = this.formFactory.form(SepaPaymentForm.class).fill((Object)sepaForm);
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to create new payment!", e);
            return OpenPayments.redirect((Call)redirect).flashing("HTMLerror", messages.at("payment.error.failedtocreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
        return OpenPayments.ok((Content)newpayment.render((Form<? extends PaymentForm>)form, PaymentContextType.OPEN_FROM_BOOKING, pmtType, flashMap, request, messages));
    }
}

