/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.Setup;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import controllers.util.GeneralUtils;
import controllers.util.SepaNotificationPostScheduler;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.SendOrderNameHandler;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.NotificationFilter;
import de.businesslogics.banking.database.vo.NotificationPmtInf;
import de.businesslogics.banking.database.vo.NotificationTrx;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.transfer.api.Camt029Printer;
import de.businesslogics.banking.transfer.api.Camt029Processing;
import de.businesslogics.banking.transfer.api.CustomerProtocolPostScheduler;
import de.businesslogics.banking.transfer.api.NotificationPrinter;
import de.businesslogics.banking.transfer.api.NotificationUtil;
import de.businesslogics.banking.transfer.api.SEPACreditNotificationProcessing;
import de.businesslogics.banking.transfer.api.SEPADebitNotificationProcessing;
import de.businesslogics.banking.transfer.api.SEPAInstantNotificationProcessing;
import de.businesslogics.banking.transfer.api.SEPANotificationPrinter;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.format.camt029.Camt029Extractor;
import de.businesslogics.format.camt029.Camt029LogicalFile;
import de.businesslogics.format.camt029.Camt029Notification;
import de.businesslogics.format.camt029.Camt029Transaction;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.sepa.GeneralSEPAReportExtractor;
import de.businesslogics.format.sepa.RejectedSEPALogicalFile;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.RejectedSEPAPayment;
import de.businesslogics.format.sepa.StatusCode;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.io.Streams;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.StringUtils;
import io.ebean.Query;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.NotificationFilterForm;
import models.NotificationImportForm;
import models.SimpleTextForm;
import org.xml.sax.SAXException;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.orders.notificationList;
import views.html.orders.notificationimport;
import views.html.orders.notifications;

@Security.Authenticated(value=AuthenticatorFor.Notifications.class)
public final class Notifications
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static String getFilterDescription(NotificationFilter filter, Messages messages) {
        StringBuilder result = new StringBuilder();
        if (filter.getBank() != null) {
            result.append(messages.at("sent.filter.bank", new Object[]{filter.getBank().getDisplayName()}));
        }
        if (filter.getOrderType() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            if (filter.getOrderTypeComparator() == FilterComparator.Text.STARTS_WITH) {
                result.append(messages.at("sent.filter.ordertype.startswith", new Object[]{filter.getOrderType()}));
            } else if (filter.getOrderTypeComparator() == FilterComparator.Text.ENDS_WITH) {
                result.append(messages.at("sent.filter.ordertype.endswith", new Object[]{filter.getOrderType()}));
            } else if (filter.getOrderTypeComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result.append(messages.at("sent.filter.ordertype.containsnot", new Object[]{filter.getOrderType()}));
            } else {
                result.append(messages.at("sent.filter.ordertype.contains", new Object[]{filter.getOrderType()}));
            }
        }
        if (filter.getDateComparator() != null && filter.getFromDate() != null) {
            if (!result.isEmpty()) {
                result.append(", ");
            }
            result.append(messages.at("notifications.filter.date", new Object[]{filter.getDateComparator().ordinal(), filter.getFromDate(), filter.getToDate()}));
        }
        return result.toString();
    }

    public Result filter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        NotificationFilter notificationFilter = NotificationFilter.getFilter((User)user);
        if (active) {
            Form<NotificationFilterForm> form = this.formFactory.form(NotificationFilterForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((NotificationFilterForm)form.get()).validate(form, notificationFilter);
            }
            if (form.hasErrors()) {
                return this.internalIndex(request, user, form, notificationFilter);
            }
            notificationFilter.setNotificationActive(!notificationFilter.isEmpty());
        } else {
            notificationFilter.setNotificationActive(false);
        }
        notificationFilter.save();
        return Notifications.redirect((Call)routes.Notifications.index());
    }

    private Result internalIndex(Http.Request request, User user, Form<NotificationFilterForm> filterForm, NotificationFilter filter) {
        List list;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.NOTIFICATION);
        Query query = this.notificationQuery(user, sorting.getSortingColumn(), sorting.isSortingAscending(), filter);
        sorting.computeForQuery(query);
        query = query.setFirstRow(sorting.getPageNumber() * sorting.getPageSize()).setMaxRows(sorting.getPageSize());
        try {
            list = query.findPagedList().getList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.NOTIFICATION, (Call)routes.Notifications.index());
        }
        return Notifications.ok((Content)notifications.render(list, sorting, filterForm, filter, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public static String getProtocolMessage(Notification notification) {
        Notification.Type type = notification.getType();
        if (type == Notification.Type.PTK) {
            try {
                int ptkId = Integer.parseInt(notification.getOrderInfo().substring(4));
                PtkEntry ptkEntry = (PtkEntry)DB.find(PtkEntry.class, (Object)ptkId);
                if (ptkEntry != null && ptkEntry.getData() != null) {
                    return ptkEntry.getData();
                }
            }
            catch (NumberFormatException e) {
                BLLoggerPlay.error("Failed to parse PTK ID of notification!", e);
            }
        } else if (type == Notification.Type.HAC) {
            try {
                int hacId = Integer.parseInt(notification.getOrderInfo().substring(4));
                HacEntry hacEntry = (HacEntry)DB.find(HacEntry.class, (Object)hacId);
                if (hacEntry != null && hacEntry.getAdditionalInformation() != null) {
                    return hacEntry.getAdditionalInformation();
                }
            }
            catch (NumberFormatException e) {
                BLLoggerPlay.error("Failed to parse HAC ID of notification!", e);
            }
        }
        return "";
    }

    public static String getNotificationDescription(User user, Notification notification, Messages messages) {
        return NotificationUtil.getDescription((Notification)notification, (Locale)messages.lang().locale(), (SendOrderNameHandler)new SendOrderNameHandler(user){

            public String getSpecialName(String generalizedOrderType, String orderNumber, Locale locale) {
                if (SepaApi.isCreditOrderType((String)generalizedOrderType)) {
                    if (SepaApi.isInstantCreditPaymentOrderType((String)generalizedOrderType)) {
                        return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_INSTANT_PAYMENT_ORDER, "SEPA") + " " + orderNumber;
                    }
                    if (SepaApi.isSEPAExpressPayment((String)generalizedOrderType)) {
                        return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_EXPRESS_PAYMENT_ORDER, "SEPA") + " " + orderNumber;
                    }
                    return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_TRANSFER_ORDER, "SEPA") + " " + orderNumber;
                }
                if (SepaApi.isDebitOrderType((String)generalizedOrderType)) {
                    if ("CDB".equals(generalizedOrderType)) {
                        return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_BUSINESS_DEBIT_ORDER, "SEPA") + " " + orderNumber;
                    }
                    return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_BASE_DEBIT_ORDER, "SEPA") + " " + orderNumber;
                }
                if ("CCC".equals(generalizedOrderType) || "CCS".equals(generalizedOrderType) || "CCX".equals(generalizedOrderType)) {
                    return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_CONTAINER_TRANSFER_ORDER, "SEPA") + " " + orderNumber;
                }
                if ("C1C".equals(generalizedOrderType) || "C1S".equals(generalizedOrderType) || "C1X".equals(generalizedOrderType) || "C2C".equals(generalizedOrderType) || "C2S".equals(generalizedOrderType) || "C2X".equals(generalizedOrderType) || "CDC".equals(generalizedOrderType) || "CDS".equals(generalizedOrderType) || "CDX".equals(generalizedOrderType)) {
                    return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_CONTAINER_DEBIT_ORDER, "SEPA") + " " + orderNumber;
                }
                if ("C55".equals(generalizedOrderType)) {
                    return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_CANCELLATION_ORDER, "SEPA") + " " + orderNumber;
                }
                if (DtazvApi.isDtazvOrderType((String)generalizedOrderType)) {
                    return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_FOREIGN_TRANSFER_ORDER, "DTAZV") + " " + orderNumber;
                }
                if (MT101Api.isMt101OrderType((String)generalizedOrderType)) {
                    return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_TRANSFER_ORDER, "MT101") + " " + orderNumber;
                }
                return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).ORDER_NAME_ORDER, generalizedOrderType) + " " + orderNumber;
            }
        });
    }

    public static boolean hasNotificationFile(Notification notification) {
        return notification.getFile() != null && !notification.isErrorNotificationFromHAC() && !notification.isErrorNotificationFromPTK();
    }

    public static Seq<Tuple2<String, String>> getNotificationTypes() {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)Notification.Type.Pain002Credit.name(), (Object)TransferApiMessages.getString((Locale)Locale.getDefault(), (String)"SEPACreditNotificationProcessing.description", (Object[])new Object[0])));
        result.add(Scala.Tuple((Object)Notification.Type.Pain002Debit.name(), (Object)TransferApiMessages.getString((Locale)Locale.getDefault(), (String)"SEPADebitNotificationProcessing.description", (Object[])new Object[0])));
        result.add(Scala.Tuple((Object)Notification.Type.Pain002Inst.name(), (Object)TransferApiMessages.getString((Locale)Locale.getDefault(), (String)"SEPAInstantNotificationProcessing.description", (Object[])new Object[0])));
        result.add(Scala.Tuple((Object)Notification.Type.Camt029.name(), (Object)TransferApiMessages.getString((Locale)Locale.getDefault(), (String)"Camt029Processing.description", (Object[])new Object[0])));
        return Scala.toSeq(result);
    }

    public static String loadJsParameters(Messages messages) {
        ObjectNode resultJson = Json.newObject();
        ObjectNode node = resultJson.putObject("deleteQuestion");
        node.put("single", messages.at("notifications.delete.question", new Object[]{1}));
        node.put("multiple", messages.at("notifications.delete.question", new Object[]{999}));
        node.put("none", messages.at("notifications.delete.question", new Object[]{0}));
        resultJson.put("updateMessage", messages.at("notifications.fetching", new Object[0]));
        resultJson.put("fetchingDetailsMessage", messages.at("notifications.fetchingDetails", new Object[0]));
        resultJson.put("numberOfPayments", messages.at("notifications.details.numberpayments", new Object[0]));
        resultJson.put("totalAmount", messages.at("notifications.details.totalamount", new Object[0]));
        resultJson.put("payee", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payee", (Object[])new Object[0]));
        resultJson.put("payer", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payer", (Object[])new Object[0]));
        resultJson.put("account", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.account", (Object[])new Object[0]));
        resultJson.put("purpose", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.purpose", (Object[])new Object[0]));
        resultJson.put("reason", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error", (Object[])new Object[0]));
        resultJson.put("bank", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bank", (Object[])new Object[0]));
        resultJson.put("customer", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountOwner", (Object[])new Object[0]));
        resultJson.put("status", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.statusCode", (Object[])new Object[0]));
        node = resultJson.putObject("hac");
        node.put("user", messages.at("bankdetails.userprofile.user", new Object[0]));
        node.put("action", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.action", (Object[])new Object[0]));
        node.put("message", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.message", (Object[])new Object[0]));
        node.put("additional", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.additionalInformationSingular", (Object[])new Object[0]));
        resultJson.put("updateUrl", routes.Notifications.fetch().toString());
        resultJson.put("fetchDetailsUrl", routes.Notifications.fetchDetails(999).toString());
        resultJson.put("indexUrl", routes.Notifications.index().toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public Notifications(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    private Query<Notification> notificationQuery(User user, int sort, boolean asc, NotificationFilter filter) {
        Query query = Notification.getNotificationQuery((User)user);
        if (filter.isNotificationActive() && !filter.isEmpty()) {
            query.where(filter.getExpression());
        }
        switch (sort) {
            case 0: {
                if (asc) {
                    query = query.order("bank asc,orderType asc,fileType asc");
                    break;
                }
                query = query.order("bank desc,orderType desc,fileType desc");
                break;
            }
            case 1: {
                if (asc) {
                    query = query.order("fetched ASC");
                    break;
                }
                query = query.order("fetched DESC");
                break;
            }
            case 2: {
                if (asc) {
                    query = query.order("nbOfRjct ASC");
                    break;
                }
                query = query.order("nbOfRjct DESC");
                break;
            }
            case 3: {
                query = query.order("file.size " + (asc ? "ASC" : "DESC"));
            }
        }
        return query;
    }

    public Result index(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.NOTIFICATION);
        NotificationFilter filter = NotificationFilter.getFilter((User)user);
        Form form = this.formFactory.form(NotificationFilterForm.class).fill((Object)new NotificationFilterForm(filter));
        Query<Notification> query = this.notificationQuery(user, sorting.getSortingColumn(), sorting.isSortingAscending(), filter);
        sorting.computeForQuery(query);
        return Notifications.ok((Content)notifications.render(query.setMaxRows(sorting.getPageSize()).setFirstRow(sorting.getPageNumber() * sorting.getPageSize()).findPagedList().getList(), sorting, (Form<NotificationFilterForm>)form, filter, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.NOTIFICATION).updateSort(sort, ascending);
        return Notifications.redirect((Call)routes.Notifications.index());
    }

    public Result indexPage(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.NOTIFICATION).updatePage(page, pageSize);
        return Notifications.redirect((Call)routes.Notifications.index());
    }

    public Result detailPage(Http.Request request, int notificationId, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.NOTIFICATION_TRX).updatePage(page, pageSize);
        return Notifications.redirect((Call)routes.Notifications.getDetails(notificationId));
    }

    public Result detailSort(Http.Request request, int notificationId, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.NOTIFICATION_TRX).updateSort(sort, ascending);
        return Notifications.redirect((Call)routes.Notifications.getDetails(notificationId));
    }

    public Result detailFilter(Http.Request request, int notificationId, String filter) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.NOTIFICATION_TRX).setProperty("txSts", filter);
        return Notifications.redirect((Call)routes.Notifications.getDetails(notificationId));
    }

    public CompletionStage<Result> getDetails(Http.Request request, int notificationId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            Notification notification = (Notification)Notification.getNotificationQuery((User)user).where().eq("id", (Object)notificationId).findOne();
            if (notification == null) {
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("error", messages.at("notifications.notfound", new Object[0]));
            }
            if (notification.getSend() != null && notification.getSend().isWithSalaries() && !Util.displaySalaries((User)user)) {
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("error", messages.at("notifications.error.salary", new Object[0]));
            }
            Query query = DB.find(NotificationTrx.class).where().eq("notification", (Object)notification).query();
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.NOTIFICATION_TRX);
            Object stateFilter = messages.at("notifications.txFilter", new Object[0]);
            if (sorting.getProperty("txSts") == null || "AUTO".equals(sorting.getProperty("txSts"))) {
                stateFilter = messages.at("notifications.txFilter", new Object[0]);
                if (notification.getNbOfRjct() != null && notification.getNbOfRjct() > 0) {
                    query.where().eq("txSts", (Object)"RJCT");
                    stateFilter = (String)stateFilter + " (" + StatusCode.getShortDescription((String)"RJCT", (StatusCode.StatusCodeContext)StatusCode.StatusCodeContext.SEPA, null, (Locale)messages.lang().toLocale()) + ")";
                } else {
                    stateFilter = (String)stateFilter + " (" + messages.at("notifications.txFilter.all", new Object[0]) + ")";
                }
            } else if (!"ALL".equals(sorting.getProperty("txSts"))) {
                query.where().eq("txSts", (Object)sorting.getProperty("txSts"));
                stateFilter = StatusCode.getShortDescription((String)sorting.getProperty("txSts"), (StatusCode.StatusCodeContext)StatusCode.StatusCodeContext.SEPA, null, (Locale)messages.lang().toLocale());
            } else {
                stateFilter = messages.at("notifications.txFilter.all", new Object[0]);
            }
            switch (sorting.getSortingColumn()) {
                case 0: {
                    query.orderBy("recipient " + (sorting.isSortingAscending() ? "asc" : "desc"));
                    break;
                }
                case 1: {
                    query.orderBy("recipientAccountNumber " + (sorting.isSortingAscending() ? "asc" : "desc"));
                    break;
                }
                case 3: {
                    query.orderBy("purpose " + (sorting.isSortingAscending() ? "asc" : "desc"));
                    break;
                }
                case 2: {
                    query.orderBy("amount " + (sorting.isSortingAscending() ? "asc" : "desc"));
                    break;
                }
                case 4: {
                    query.orderBy("txSts " + (sorting.isSortingAscending() ? "asc" : "desc"));
                }
            }
            sorting.computeForQuery(query);
            return Notifications.ok((Content)notificationList.render(notification, query.findList(), sorting, (String)stateFilter, request, messages));
        }, this.executionContext.current());
    }

    public CompletionStage<Result> fetch(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<ScheduledFuture<List<Fetch>>> futures = new ArrayList<ScheduledFuture<List<Fetch>>>();
            boolean fetched2 = false;
            HashMap<String, String> flashMap = new HashMap<String, String>();
            for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
                if (bankUser.getState() != BankUser.UserState.READY) continue;
                try {
                    EbicsWorker worker = EbicsUtil.getEbicsWorker(bankUser);
                    futures.add(CustomerProtocolPostScheduler.fetchProtocolNow((EbicsWorker)worker, (BankUser)bankUser));
                    futures.add(SepaNotificationPostScheduler.fetchNotificationsNow(worker, bankUser));
                }
                catch (IOException | GeneralSecurityException e) {
                    BLLoggerPlay.error("An error occurred while fetching notifications from bank " + bankUser.getBank().getDisplayName() + ":", e);
                    Utils.addToFlash(flashMap, "HTMLerror", messages.at("notifications.fetchfailed", new Object[]{bankUser.getBank().getDisplayName(), Utils.getLocalizedMessage(e, messages)}));
                }
            }
            for (ScheduledFuture scheduledFuture : futures) {
                try {
                    scheduledFuture.get();
                    fetched2 = true;
                }
                catch (InterruptedException | ExecutionException e) {
                    BLLoggerPlay.error("Failed to wait for update execution result!", e);
                }
            }
            if (fetched2) {
                flashMap.put("success", messages.at("notifications.fetched", new Object[0]));
            } else {
                flashMap.put("warning", messages.at("notifications.nothingToFetch", new Object[0]));
            }
            return Notifications.ok().flashing(flashMap);
        }, this.executionContext.current());
    }

    public CompletionStage<Result> fetchDetails(Http.Request request, int id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            Notification notification = (Notification)DB.find(Notification.class, (Object)id);
            if (notification != null && BankUser.findBankUser((BankSettings)notification.getBank(), (User)user) != null) {
                if (notification.isErrorNotificationFromPTK() || notification.isErrorNotificationFromHAC()) {
                    return Notifications.ok((byte[])this.getErrorNotificationDetails(notification, messages.lang().locale()));
                }
                if (notification.isAdditionalInfoFromPTK() || notification.isAdditionalInfoFromHAC()) {
                    return Notifications.ok((byte[])this.getAdditionalNotificationDetails(notification, messages.lang().locale()));
                }
                if (this.canGenerateNotificationDetails(notification)) {
                    File file2 = WorkspaceFileSystem.getFile((WorkspaceFile)notification.getFile());
                    if (file2.isFile() && file2.length() > 0L) {
                        return Notifications.ok((byte[])this.getNotificationDetails(notification.getType(), file2, messages.lang().locale()));
                    }
                    BLLoggerPlay.error("Could not find notification file " + notification.getFile().getPath());
                }
            }
            return Notifications.ok();
        }, this.executionContext.current());
    }

    public Result delete(Http.Request request) {
        return this.deleteNotifications(request, null);
    }

    public Result deleteNotification(Http.Request request, Integer id) {
        return this.deleteNotifications(request, id);
    }

    public Result deleteNotifications(Http.Request request, Integer id) {
        List<Integer> idsList;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            idsList = Collections.singletonList(id);
        } else {
            String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            idsList = GeneralUtils.getSelectionIds(ids);
        }
        int count = 0;
        if (!idsList.isEmpty()) {
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            for (Notification notification : DB.find(Notification.class).where().in("id", idsList).findList()) {
                if (BankUser.findBankUser((BankSettings)notification.getBank(), (User)user) == null) continue;
                WorkspaceFileSystem.delete((WorkspaceFile)notification.getFile());
                notification.delete();
                ++count;
            }
        }
        String flashKey = count == 0 ? "warning" : "success";
        return Notifications.redirect((Call)routes.Notifications.index()).flashing(flashKey, messages.at("notifications.delete", new Object[]{count}));
    }

    public Result updateVopNamesPage(Http.Request request, Integer notificationId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String referer = Utils.getHeaderValue(request, "referer");
        String redirectTo = referer != null ? referer : routes.Notifications.getDetails(notificationId).url();
        try {
            ArrayList<String> recipientIdsList = new ArrayList<String>();
            Notification notification = (Notification)DB.find(Notification.class).where().eq("id", (Object)notificationId).setMaxRows(1).findOne();
            if (notification == null) {
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("error", messages.at("notifications.notfound", new Object[0]));
            }
            List notificationTransactions = NotificationTrx.find((Notification)notification);
            for (NotificationTrx notificationTransaction : notificationTransactions) {
                String accountNumber;
                String recipientName = notificationTransaction.getRecipient();
                PaymentRecipient matchingRecipient = PaymentRecipient.findRecipientByAccountInfo((PaymentType)PaymentType.SEPA, (String)recipientName, (String)(accountNumber = notificationTransaction.getRecipientAccountNumber()), null, (Tenant)notification.getBank().getTenant());
                if (matchingRecipient == null) continue;
                recipientIdsList.add(matchingRecipient.getId().toString());
            }
            if (recipientIdsList.isEmpty()) {
                return Notifications.redirect((String)redirectTo).flashing("info", messages.at("recipients.vopNameUpdate.nothingToUpdate", new Object[0]));
            }
            return Notifications.redirect((Call)routes.Recipients.updateVopNamesPage(String.join((CharSequence)",", recipientIdsList)));
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to load the VOP recipient name update page!", e);
            return Notifications.redirect((String)redirectTo).flashing("HTMLerror", messages.at("recipients.vopNameUpdate.error", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
    }

    public Result importForm(Http.Request request) {
        return Notifications.ok((Content)notificationimport.render((Form<NotificationImportForm>)this.formFactory.form(NotificationImportForm.class).fill((Object)new NotificationImportForm()), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result uploadDone(Http.Request request, int numberOfFiles) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return Notifications.redirect((Call)routes.Notifications.index()).flashing("success", messages.at("notifications.imported", new Object[]{numberOfFiles}));
    }

    public Result uploadChunk(Http.Request request) {
        Notification.Type notificationType;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Http.MultipartFormData data = request.body().asMultipartFormData();
        Http.MultipartFormData.FilePart filePart = data.getFile("file");
        Map parameter = data.asFormUrlEncoded();
        if (!GeneralUtils.checkUploadFile(filePart.getFilename())) {
            return Notifications.badRequest().flashing("error", "general.upload.error.insecure");
        }
        BankSettings bank = BankSettings.getByIdAndUser((Integer)Integer.valueOf(((String[])parameter.get("bankId"))[0]), (User)user);
        if (bank == null) {
            return Notifications.ok((String)messages.at("bank.error.noSuchBank", new Object[0]));
        }
        try {
            notificationType = Notification.Type.valueOf((String)((String[])parameter.get("notificationType"))[0]);
        }
        catch (Exception e) {
            return Notifications.ok((String)messages.at("notifications.unknowntype", new Object[0]));
        }
        File tmpDir = new File(Setup.WORKSPACE_DIRECTORY, "tmp");
        File userDir = new File(tmpDir, "upload_" + user.getId());
        File file2 = new File(userDir, ((String[])parameter.get("filename"))[0]);
        try {
            userDir.mkdirs();
            FileOutputStream out = new FileOutputStream(file2, parameter.get("firstChunk") == null);
            FileInputStream in = new FileInputStream(((Files.TemporaryFile)filePart.getRef()).path().toFile());
            Streams.copy((InputStream)in, (OutputStream)out);
            if (parameter.get("lastChunk") != null) {
                Camt029Processing processing = switch (notificationType) {
                    case Notification.Type.Camt029 -> new Camt029Processing(Util.logger, EncryptData.getInstance());
                    case Notification.Type.Pain002Credit -> new SEPACreditNotificationProcessing(Util.logger, EncryptData.getInstance());
                    case Notification.Type.Pain002Debit -> new SEPADebitNotificationProcessing(Util.logger, EncryptData.getInstance());
                    case Notification.Type.Pain002Inst -> new SEPAInstantNotificationProcessing(Util.logger, EncryptData.getInstance());
                    default -> null;
                };
                if (processing != null) {
                    processing.initializeForImport(bank);
                    processing.process((InputStream)new FileInputStream(file2));
                }
                if (!file2.delete()) {
                    file2.deleteOnExit();
                }
            }
            return Notifications.ok();
        }
        catch (Exception io) {
            BLLoggerPlay.error("Failed to import notification file " + file2.getAbsolutePath(), io);
            if (parameter.get("lastChunk") != null && !file2.delete()) {
                file2.deleteOnExit();
            }
            return Notifications.ok((String)io.getMessage());
        }
    }

    public CompletionStage<Result> file(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            Notification notification = (Notification)DB.find(Notification.class, (Object)id);
            if (notification == null || BankUser.findBankUser((BankSettings)notification.getBank(), (User)user) == null) {
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("error", messages.at("notifications.notfound", new Object[0]));
            }
            Notification.Type notificationType = notification.getType();
            if (notification.isProtocolType()) {
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("error", "no download of HAC nor PTK");
            }
            if (notificationType == Notification.Type.UNKNOWN) {
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("error", messages.at("notifications.unknowntype", new Object[0]));
            }
            File file2 = WorkspaceFileSystem.getFile((WorkspaceFile)notification.getFile());
            if (!file2.isFile() || file2.length() == 0L) {
                BLLoggerPlay.error("Could not find notification file " + notification.getFile().getPath());
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("error", messages.at("notifications.filenotfound", new Object[0]));
            }
            try {
                return GeneralUtils.supplyWorkspaceFile(file2, false, false).as("application/octet-stream").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to supply workspace file " + file2.getAbsolutePath(), e);
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("HTMLerror", messages.at("notifications.filesupplyfailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> print(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            Notification notification = (Notification)DB.find(Notification.class, (Object)id);
            if (notification == null || BankUser.findBankUser((BankSettings)notification.getBank(), (User)user) == null) {
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("error", messages.at("notifications.notfound", new Object[0]));
            }
            try {
                File file2 = Util.createTempFile((String)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.notifications", (Object[])new Object[0]), (String)".pdf", (boolean)true);
                try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    NotificationPrinterImpl printer = new NotificationPrinterImpl(request, fileOutputStream, user, messages.lang().locale());
                    printer.print(notification);
                    printer.finish();
                }
                Util.applyPreferencesToPdf((File)file2, (User)user, null, (Locale)messages.lang().locale(), null, null, (boolean)GeneralUtils.printLogo(user));
                return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to print notification!", e);
                return Notifications.redirect((Call)routes.Notifications.index()).flashing("HTMLerror", messages.at("notifications.failedtoprint", new Object[]{1, Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    private boolean canGenerateNotificationDetails(Notification notification) {
        return switch (notification.getType()) {
            case Notification.Type.Camt029, Notification.Type.Pain002Credit, Notification.Type.Pain002Debit, Notification.Type.Pain002Inst -> true;
            default -> false;
        };
    }

    private byte[] getAdditionalNotificationDetails(Notification notification, Locale locale) {
        ObjectNode result = Json.newObject();
        Integer id = Integer.valueOf(notification.getOrderInfo().substring(notification.getOrderInfo().indexOf(46) + 1));
        if (notification.isAdditionalInfoFromHAC()) {
            result.put("title", TransferApiMessages.getString((Locale)locale, (String)"notification.print.hac.title", (Object[])new Object[0]));
            HacEntry hac = HacEntry.findById((int)id);
            result.put("message", hac.getAdditionalInformation());
        } else if (notification.isAdditionalInfoFromPTK()) {
            result.put("title", TransferApiMessages.getString((Locale)locale, (String)"notification.print.ptk.title", (Object[])new Object[0]));
            PtkEntry ptkEntry = PtkEntry.findById((int)id);
            result.put("message", ptkEntry.getData());
        }
        return Json.asciiStringify((JsonNode)result).getBytes(StandardCharsets.US_ASCII);
    }

    private byte[] getErrorNotificationDetails(Notification notification, Locale locale) {
        ObjectNode result;
        block7: {
            Query ptkQuery;
            block6: {
                result = Json.newObject();
                result.put("title", NotificationUtil.getErrorProtocolTitle((Send)notification.getSend(), (String)notification.getType().name(), (Locale)locale));
                result.put("message", NotificationUtil.getErrorProtocolMessage((Send)notification.getSend(), (String)notification.getType().name(), (Locale)locale));
                if (!notification.isErrorNotificationFromHAC()) break block6;
                Query hacQuery = ProtocolUtil.getHacEntries((Send)notification.getSend());
                if (hacQuery.findCount() <= 0) break block7;
                ArrayNode hacNode = result.putArray("hacs");
                HashMap<String, String> userNameMap = new HashMap<String, String>();
                for (HacEntry hac : hacQuery.findList()) {
                    ObjectNode hacEntryNode = hacNode.addObject();
                    hacEntryNode.put("time", DateFormat.getDateTimeInstance(2, 2, locale).format(hac.getHacTime()));
                    String hacUserDefaultName = hac.getUserRepresentation();
                    String hacUserName = (String)userNameMap.get(hacUserDefaultName);
                    if (hacUserName == null) {
                        User hacUser = BankUser.findLoginUserByUserIdAndCustomerId((BankSettings)hac.getBank(), (String)hac.getUserId(), (String)hac.getCustomerId());
                        hacUserName = hacUser != null ? hacUser.getName() : hacUserDefaultName;
                        userNameMap.put(hacUserDefaultName, hacUserName);
                    }
                    hacEntryNode.put("user", hacUserName);
                    if (hac.getAction() != null) {
                        HAC30Entry.Action action = HAC30Entry.Action.values()[hac.getAction()];
                        hacEntryNode.put("axn", HAC30Entry.getActionRepresentation((Locale)locale, (HAC30Entry.Action)action));
                        String reasonMessage = HAC30Entry.getReasonMessage((Locale)locale, (String)hac.getReason(), (HAC30Entry.Action)action);
                        if (reasonMessage != null) {
                            hacEntryNode.put("rsn", reasonMessage);
                        }
                    }
                    if (hac.getAdditionalInformation() == null) continue;
                    hacEntryNode.put("addtnl", hac.getAdditionalInformation());
                }
                break block7;
            }
            if (notification.isErrorNotificationFromPTK() && (ptkQuery = ProtocolUtil.getPtkEntries((Send)notification.getSend())).findCount() > 0) {
                ArrayNode ptkNode = result.putArray("ptks");
                for (PtkEntry ptkEntry : ptkQuery.findList()) {
                    ptkNode.addObject().put("ptk", ptkEntry.getData());
                }
            }
        }
        return Json.asciiStringify((JsonNode)result).getBytes(StandardCharsets.US_ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getNotificationDetails(Notification.Type type, File file2, Locale locale) {
        ObjectNode result = Json.newObject();
        InputStream inputStream = null;
        try {
            inputStream = EncryptData.getInstance().openInputStream(file2);
            if (type == Notification.Type.Pain002Credit || type == Notification.Type.Pain002Debit || type == Notification.Type.Pain002Inst) {
                ArrayNode orderNode = result.putArray("orders");
                for (RejectedSEPAOrder order : GeneralSEPAReportExtractor.getRejectedOrders((InputStream)inputStream)) {
                    for (RejectedSEPALogicalFile logicalFile : order.getRejectedLogicalFiles()) {
                        ArrayNode reasonsNode;
                        ObjectNode node;
                        if (logicalFile.getRejectedPayments() == null || logicalFile.getRejectedPayments().isEmpty()) {
                            node = orderNode.addObject();
                            node.put("msgid", logicalFile.getLogicalFileId());
                            node.put("pmtnumber", logicalFile.getCountTransactions());
                            node.put("amount", Utils.formatAmount(logicalFile.getTotalAmount(), "EUR", locale));
                            reasonsNode = node.putArray("reasons");
                            this.addStatusReasonCode(reasonsNode, logicalFile.getStatusReasons(), locale);
                            continue;
                        }
                        for (RejectedSEPAPayment payment : logicalFile.getRejectedPayments()) {
                            node = orderNode.addObject();
                            node.put("msgid", payment.getPayment().getEndToEndId());
                            node.put("amount", Utils.formatAmount(payment.getPayment().getAmount(), "EUR", locale));
                            if (payment.getPayment().isCredit()) {
                                node.put("payee", payment.getPayment().getRecipient());
                            } else {
                                node.put("payer", payment.getPayment().getRecipient());
                            }
                            if (payment.getPayment().getRecipientBic() != null) {
                                node.put("recipientacc", payment.getPayment().getRecipientBic() + "/" + payment.getPayment().getRecipientIban());
                            } else {
                                node.put("recipientacc", payment.getPayment().getRecipientIban());
                            }
                            node.put("purpose", payment.getPayment().getPurpose());
                            reasonsNode = node.putArray("reasons");
                            this.addStatusReasonCode(reasonsNode, payment.getStatusReasons(), locale);
                        }
                    }
                }
            } else if (type == Notification.Type.Camt029) {
                Camt029Notification notification = Camt029Extractor.getNotification((InputStream)inputStream);
                result.put("msgid", notification.getAssignmentId());
                result.put("customer", notification.getAssignee());
                result.put("bank", notification.getAssigner());
                result.put("status", notification.getStatus());
                ArrayNode logicalFilesNode = result.putArray("logicalfiles");
                for (Camt029LogicalFile logicalFile : notification.getLogicalFiles()) {
                    ObjectNode node = logicalFilesNode.addObject();
                    node.put("statusmessage", NotificationUtil.getLogicalFileStatusDescription((Locale)locale, (Camt029LogicalFile)logicalFile, (String)notification.getStatus()));
                }
                ArrayNode transactionsNode = result.putArray("transactions");
                if (!notification.getTransactions().isEmpty()) {
                    result.put("transactionsmsg", NotificationUtil.getTransactionStatusDescription((Locale)locale, (String)notification.getStatus()));
                    for (Camt029Transaction transaction : notification.getTransactions()) {
                        ObjectNode node = transactionsNode.addObject();
                        node.put("summaryinfos", NotificationUtil.getTransactionDetails((Locale)locale, (Camt029Transaction)transaction));
                    }
                }
            }
        }
        catch (IOException | GeneralSecurityException | SAXException e) {
            BLLoggerPlay.error("Failed to parse notification details!", e);
        }
        finally {
            Util.closeStream((Closeable)inputStream);
        }
        return Json.asciiStringify((JsonNode)result).getBytes(StandardCharsets.US_ASCII);
    }

    private void addStatusReasonCode(ArrayNode node, List<StatusReason> reasons, Locale locale) {
        if (reasons != null) {
            for (StatusReason reason : reasons) {
                if (reason.getStatusReasonCode() == null) continue;
                String description = RejectedSEPAOrder.getDescription((String)reason.getStatusReasonCode(), (Locale)locale);
                if (reason.getAdditionalInfos() != null && !reason.getAdditionalInfos().isEmpty()) {
                    StringBuilder b = new StringBuilder();
                    for (String info : reason.getAdditionalInfos()) {
                        if (!b.isEmpty()) {
                            b.append(" ");
                        }
                        b.append(info);
                    }
                    description = b.toString();
                }
                node.addObject().put("reason", description + " (" + reason.getStatusReasonCode() + ")");
            }
        }
    }

    public static Call getLink(Notification notification) {
        return NotificationPmtInf.find((Notification)notification).size() > 0 ? routes.Notifications.getDetails(notification.getId()) : null;
    }

    public static String fileSize(Notification notification, Locale locale) {
        if (notification.getSize() != null) {
            return StringUtils.toHumanReadableBinaryPrefixes((long)notification.getSize(), (Locale)locale);
        }
        return "";
    }

    private static final class NotificationPrinterImpl
    extends NotificationPrinter {
        public NotificationPrinterImpl(Http.Request request, OutputStream outputStream, User user, Locale locale) {
            super(outputStream, user, locale);
            this.printLogo = GeneralUtils.printLogo(user);
        }

        public void printOther(Notification notification) {
            switch (notification.getType()) {
                case Pain002Credit: 
                case Pain002Debit: 
                case Pain002Inst: 
                case Pain002Vop: {
                    try {
                        SEPANotificationPrinter printer = new SEPANotificationPrinter(EncryptData.getInstance(), this.locale);
                        SortingHandler sorting = new SortingHandler(this.user, Sorting.Table.NOTIFICATION_TRX);
                        if (sorting.getProperty("txSts") == null || "AUTO".equals(sorting.getProperty("txSts")) || "RJCT".equals(sorting.getProperty("txSts"))) {
                            printer.setPrintOnlyRejected(true);
                        }
                        BLDocument document = this.createDocumentOrPage(printer.getPageSize(notification));
                        printer.addToDocument(notification, document);
                    }
                    catch (Exception e) {
                        BLLoggerPlay.error("Failed to print SEPA notification to PDF document!");
                    }
                    break;
                }
                case Camt029: {
                    try {
                        Camt029Printer printer = new Camt029Printer(EncryptData.getInstance(), this.locale);
                        BLDocument document = this.createDocumentOrPage(printer.getPageSize(notification));
                        printer.addToDocument(notification, document);
                        break;
                    }
                    catch (Exception e) {
                        BLLoggerPlay.error("Failed to print Camt029 notification to PDF document!");
                    }
                }
            }
        }
    }
}

