/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.Setup;
import controllers.routes;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.UserEffectivePermissions;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.Log;
import de.businesslogics.banking.database.vo.LogFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expression;
import io.ebean.Query;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import models.LogFilterForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.settings.logs;

@Security.Authenticated(value=AuthenticatorFor.Settings.class)
public class Logs
extends Controller {
    private static final Map<Logger.VisibleFor, Collection<String>> MESSAGE_NAMES_FOR_GROUP = new HashMap<Logger.VisibleFor, Collection<String>>();
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static Seq<Tuple2<String, String>> getUsersForFilter(String userName) {
        ArrayList<Tuple2> resultList = new ArrayList<Tuple2>();
        resultList.add(Scala.Tuple((Object)"", (Object)""));
        User operator = User.getUser((String)userName);
        if (operator == null) {
            return Scala.toSeq(resultList);
        }
        List usersToAdd = operator.isAdmin() ? User.getAll() : User.getAllForTenants((Collection)operator.getVisibleTenants(), (boolean)true);
        for (User u : usersToAdd) {
            resultList.add(Scala.Tuple((Object)String.valueOf(u.getId()), (Object)Utils.addZWNJ(u.getName())));
        }
        return Scala.toSeq(resultList);
    }

    public static Seq<Tuple2<String, String>> getTypesForFilter(String userName) {
        ArrayList<Tuple2> resultList = new ArrayList<Tuple2>();
        resultList.add(Scala.Tuple((Object)"", (Object)""));
        User operator = User.getUser((String)userName);
        if (operator == null) {
            return Scala.toSeq(resultList);
        }
        boolean superAdminsExist = !Setup.SUPER_ADMINS.isEmpty();
        boolean isSuperAdmin = GeneralUtils.isSuperAdmin(operator);
        for (Logger.Message type : Logger.Message.values()) {
            if (!isSuperAdmin && !type.canBeSeenByUser(operator, superAdminsExist)) continue;
            resultList.add(Scala.Tuple((Object)type.name(), (Object)Utils.addZWNJ(type.name())));
        }
        return Scala.toSeq(resultList);
    }

    public static String getFilterDescription(LogFilter logFilter, User user, Messages messages) {
        Account account;
        ArrayList<Object> result = new ArrayList<Object>();
        if (logFilter.getType() != null) {
            result.add(messages.at("logs.filter.type", new Object[0]) + ": " + logFilter.getType());
        }
        if (logFilter.getAccountId() != null && (account = Account.findById((int)logFilter.getAccountId())) != null) {
            result.add(messages.at("payment.filter.description.account", new Object[]{Account.getDefaultDisplayName((Account)account)}));
        }
        if (logFilter.getDateCompator() != null && (logFilter.getFromDate() != null || logFilter.getToDate() != null)) {
            Date toDate;
            Date fromDate;
            FilterComparator.Date comparator;
            if (logFilter.getDateCompator() == FilterComparator.Date.BETWEEN && logFilter.getFromDate() == null) {
                comparator = FilterComparator.Date.LESS;
                fromDate = logFilter.getToDate();
                toDate = null;
            } else if (logFilter.getDateCompator() == FilterComparator.Date.BETWEEN && logFilter.getToDate() == null) {
                comparator = FilterComparator.Date.GREATER;
                fromDate = logFilter.getFromDate();
                toDate = null;
            } else {
                comparator = logFilter.getDateCompator();
                fromDate = logFilter.getFromDate();
                toDate = logFilter.getToDate();
            }
            result.add(messages.at("logs.filter.date", new Object[]{comparator.ordinal(), fromDate, toDate}));
        }
        if (user != null && logFilter.getFilterUserId() != null) {
            User filterUser = User.getByIdForTenants((int)logFilter.getFilterUserId(), (Collection)user.getVisibleTenants(), (boolean)true);
            String userName = filterUser != null ? filterUser.getName() : messages.at("general.invaliduser", new Object[]{logFilter.getFilterUserId()});
            result.add(BankingApiMessages.getString((String)"GeneralMessages.logs.actor", (Object[])new Object[0]) + ": " + userName);
        }
        return String.join((CharSequence)", ", result);
    }

    private static Collection<String> getMessageNamesForGroup(Logger.VisibleFor userGroup) {
        if (!MESSAGE_NAMES_FOR_GROUP.containsKey(userGroup)) {
            Collection visibleMessageNames = Arrays.stream(Logger.Message.values()).filter(m -> m.isVisibleForUserGroup(userGroup)).map(Enum::name).collect(Collectors.toSet());
            MESSAGE_NAMES_FOR_GROUP.put(userGroup, visibleMessageNames);
        }
        return MESSAGE_NAMES_FOR_GROUP.get(userGroup);
    }

    @Inject
    public Logs(FormFactory formFactory, Formatters formatters, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result filterForm(Http.Request request, boolean filterActive) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        LogFilter filter = LogFilter.getFilter((User)user);
        if (!filterActive) {
            filter.setActive(Boolean.valueOf(false));
            filter.save();
        } else {
            filter.setActive(Boolean.valueOf(true));
            Form form = this.formFactory.form(LogFilterForm.class).bindFromRequest(request, new String[0]);
            if (form.hasErrors()) {
                return this.index(request, (Form<LogFilterForm>)form);
            }
            LogFilterForm data = (LogFilterForm)form.get();
            data.saveData(filter);
        }
        return Logs.redirect((Call)routes.Logs.index());
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.LOGS).updateSort(sort, ascending);
        return Logs.redirect((Call)routes.Logs.index());
    }

    public Result indexPage(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.LOGS).updatePage(page, pageSize);
        return Logs.redirect((Call)routes.Logs.index());
    }

    public Result index(Http.Request request) {
        return this.index(request, null);
    }

    private Result index(Http.Request request, Form<LogFilterForm> logFilterForm) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (user == null) {
            return Logs.redirect((Call)routes.Application.index()).flashing("warning", this.messagesApi.preferred((Http.RequestHeader)request).at("general.noPermission", new Object[0]));
        }
        LogFilter filter = LogFilter.getFilter((User)user);
        if (logFilterForm == null) {
            LogFilterForm data = new LogFilterForm(filter);
            logFilterForm = this.formFactory.form(LogFilterForm.class).fill((Object)data);
        }
        if (filter != null && !filter.isActive()) {
            filter = null;
        }
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.LOGS);
        Query<Log> query = this.logQuery(user, sorting.getSortingColumn(), sorting.isSortingAscending(), filter);
        sorting.computeForQuery(query);
        return Logs.ok((Content)logs.render(query.setMaxRows(sorting.getPageSize()).setFirstRow(sorting.getPageNumber() * sorting.getPageSize()).findPagedList().getList(), (Form<LogFilterForm>)logFilterForm, filter, sorting, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private Query<Log> logQuery(User user, int sort, boolean asc, LogFilter filter) {
        Expression filterExpr;
        Query query = DB.find(Log.class);
        if (!user.isAdmin()) {
            query.where().in("tenant", (Collection)user.getVisibleTenants()).query();
        }
        boolean superAdminsExist = !Setup.SUPER_ADMINS.isEmpty();
        boolean isSuperAdmin = GeneralUtils.isSuperAdmin(user);
        Logger.VisibleFor userGroup = isSuperAdmin || !superAdminsExist && user.isAdmin() ? Logger.VisibleFor.SUPER_ADMINS : (user.isAdmin() ? Logger.VisibleFor.ADMINS : (user.isTenantAdmin() ? Logger.VisibleFor.TENANT_ADMINS : Logger.VisibleFor.ALL));
        query.where().in("messageName", Logs.getMessageNamesForGroup(userGroup));
        if (!user.isAdmin()) {
            UserEffectivePermissions.addUserEffectivePermissions((User)user, (Query)query, (boolean)false);
        }
        if (filter != null && (filterExpr = filter.getExpression()) != null) {
            query.where(filterExpr);
        }
        query.setIncludeSoftDeletes();
        switch (sort) {
            case 0: {
                if (asc) {
                    query = query.order("logTime asc");
                    break;
                }
                query = query.order("logTime  desc");
                break;
            }
            case 1: {
                query = asc ? query.order("actor.name ASC") : query.order("actor.name DESC");
            }
        }
        return query;
    }
}

