/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import controllers.Authenticator;
import controllers.Banks;
import controllers.Setup;
import controllers.Yubikeys;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.LicenseHandler;
import controllers.util.PasswordKeyEncryptionHandler;
import de.businesslogics.banking.api.AbstractLicenseHandler;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmBookingFilter;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.LoginSession;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WebAuthn;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Base64Util;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import models.ChangePasswordForm;
import models.LoginForm;
import models.LoginSetup;
import models.WebAuthnData;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import views.Utils;
import views.html.login.changeFirstPassword;
import views.html.login.checkYubikey;
import views.html.login.index;
import views.html.login.license;
import views.html.login.licenseInvalid;
import views.html.login.loginError;
import views.html.login.migration;
import views.html.login.setup;
import views.html.logoff;
import views.html.settings.yubikeyAddWebAuthnView;

@Singleton
public class Logins
extends Controller {
    private static final List<Tuple2<String, String>> LANGUAGES = new ArrayList<Tuple2<String, String>>();
    public static String openIdLogOffUrl;
    public static final String URL_SESSION_KEY = "GOTO_URL";
    private static final String PASSWORD_SESSION_KEY = "pwd";
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService single = Executors.newSingleThreadExecutor();

    public static List<Tuple2<String, String>> getLanguages() {
        return LANGUAGES;
    }

    @Inject
    public Logins(FormFactory formFactory, MessagesApi messagesApi) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
    }

    public Result invalidLicense(Http.Request request, String userName) {
        User user;
        HashMap<String, String> data = new HashMap<String, String>();
        Optional optional = request.attrs().getOptional(Security.USERNAME);
        if (optional.isPresent() && (user = User.getUser((String)((String)optional.get()))) != null && user.getWebLicense() != null) {
            data.put("license", user.getWebLicense().getId());
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return Logins.ok((Content)licenseInvalid.render(this.formFactory.form().fill(data), userName, request, messages));
    }

    public Result openIdLogin(Http.Request request, String code, String error, String error_description) throws IOException {
        if (error != null || error_description != null) {
            if (error_description == null) {
                error_description = "";
            }
            return Logins.ok((Content)loginError.render(error + " " + error_description, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        if (code == null) {
            return Logins.ok((Content)loginError.render("No code from SSO", request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        try {
            AuthorizationCodeTokenRequest actr = Setup.OPENID_CLIENT.newTokenRequest(code);
            actr.setRedirectUri(Authenticator.buildOpenIdRedirectURL(request));
            IdTokenResponse response = IdTokenResponse.execute((TokenRequest)actr);
            IdToken token = response.parseIdToken();
            if (Setup.OPENID_VERIFIER.verify(token)) {
                Object value;
                User user = null;
                Object name = "attribute " + Setup.OPENID_USERID_ATTRIBUTE + " not found in profile ";
                Object o = token.getPayload().get((Object)Setup.OPENID_USERID_ATTRIBUTE);
                if (o != null) {
                    name = o.toString();
                    user = User.getUser((String)o.toString());
                }
                if (user == null) {
                    BLLoggerPlay.warning("User '" + (String)name + "' not found in database.");
                    BLLoggerPlay.warning("Payload of the response: " + response.getIdToken());
                    return Logins.ok((Content)loginError.render(this.messagesApi.preferred((Http.RequestHeader)request).apply("login.invalid.user", new Object[0]), request, this.messagesApi.preferred((Http.RequestHeader)request)));
                }
                Locale locale = null;
                if (Setup.OPENID_LOCALE_ATTRIBUTE != null && (value = token.getPayload().get((Object)Setup.OPENID_LOCALE_ATTRIBUTE)) != null) {
                    locale = Locale.forLanguageTag(value.toString());
                }
                if (Setup.OPENID_ADDITIONAL_USER_ATTRIBUTE != null) {
                    value = token.getPayload().get((Object)Setup.OPENID_ADDITIONAL_USER_ATTRIBUTE);
                    if (value == null) {
                        BLLoggerPlay.warning("Additional attribute '" + Setup.OPENID_ADDITIONAL_USER_ATTRIBUTE + "' not found payload.");
                        BLLoggerPlay.warning("Payload of the response: " + response.getIdToken());
                        return Logins.ok((Content)loginError.render(this.messagesApi.preferred((Http.RequestHeader)request).apply("login.invalid.user", new Object[0]), request, this.messagesApi.preferred((Http.RequestHeader)request)));
                    }
                    if (Setup.OPENID_ADDITIONAL_USER_VALUE_GREATER_AS != null) {
                        int intValue = 0;
                        try {
                            intValue = Integer.parseInt(value.toString());
                        }
                        catch (NumberFormatException e) {
                            BLLoggerPlay.warning("Cannot parse additional attribute value as integer: " + String.valueOf(value));
                        }
                        if (intValue <= Setup.OPENID_ADDITIONAL_USER_VALUE_GREATER_AS) {
                            BLLoggerPlay.warning("The value of the additional attribute '" + Setup.OPENID_ADDITIONAL_USER_ATTRIBUTE + "' is too small: Should be greater than " + Setup.OPENID_ADDITIONAL_USER_VALUE_GREATER_AS + " but is " + intValue);
                            BLLoggerPlay.warning("Payload of the response: " + response.getIdToken());
                            return Logins.ok((Content)loginError.render(this.messagesApi.preferred((Http.RequestHeader)request).apply("login.invalid.user", new Object[0]), request, this.messagesApi.preferred((Http.RequestHeader)request)));
                        }
                    }
                }
                Authenticator.setOpenIdToken((String)name, response);
                return this.finishSuccessfulLogin(request, user, locale);
            }
            return Logins.ok((String)token.toString());
        }
        catch (Exception responseException) {
            BLLoggerPlay.error("error reading openid response", responseException);
            return Logins.ok((Content)loginError.render(responseException.getMessage(), request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
    }

    public Result invalidLicenseUpdate(Http.Request request, String userName) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        DynamicForm form = this.formFactory.form().bindFromRequest(request, new String[0]);
        CheckLicenseResult result = this.checkLicense(form.get("license"), form, messages);
        if ((form = result.form()).hasErrors()) {
            return Logins.ok((Content)licenseInvalid.render(form, userName, request, messages));
        }
        License vo = result.licenseVO();
        for (User user : User.getAll()) {
            user.setWebLicense(vo);
            user.save();
        }
        return Logins.redirect((Call)routes.Application.index());
    }

    public Result index(Http.Request request) {
        return this.indexUser(request, "");
    }

    public Result indexUser(Http.Request request, String userName) {
        long id;
        if (Setup.SETUP_COMPLETE && request.session().get("id").isPresent() && Authenticator.checkLoginSession(id = Long.parseLong((String)request.session().get("id").get()))) {
            return Logins.redirect((Call)routes.Application.index());
        }
        if (Setup.OPENID_CLIENT != null) {
            return Logins.redirect((Call)routes.Application.index());
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (!Setup.SETUP_COMPLETE) {
            return Logins.redirect((Call)routes.Setup.index());
        }
        if (User.getAll().isEmpty()) {
            return Logins.ok((Content)license.render(this.formFactory.form(), request, messages));
        }
        Optional optional = request.attrs().getOptional(Security.USERNAME);
        if (optional.isPresent() && User.getUser((String)((String)optional.get())) != null) {
            return Logins.redirect((Call)routes.Application.index());
        }
        Form form = this.formFactory.form(LoginForm.class).fill((Object)LoginForm.getFormForUser(userName));
        return Logins.ok((Content)index.render((Form<LoginForm>)form, request, messages));
    }

    public CompletionStage<Result> login(Http.Request request) {
        String ipAddress = Setup.getIPAddress(request);
        if (Setup.OPENID_CLIENT != null) {
            return CompletableFuture.completedFuture(Logins.redirect((Call)routes.Application.index()));
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form f = this.formFactory.form(LoginForm.class).bindFromRequest(request, new String[0]);
        if (f.hasErrors()) {
            return CompletableFuture.completedFuture(Logins.ok((Content)index.render((Form<LoginForm>)f, request, messages)));
        }
        User userToLogIn = User.getUser((String)((LoginForm)f.get()).username);
        if (Setup.REQUIRE_2FA_FOR_LOGIN) {
            WebAuthnData webauthnData = null;
            DynamicForm form = null;
            if (userToLogIn != null) {
                if (Yubikey.hasKeyOfType((User)userToLogIn, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.WEBAUTHN})) {
                    webauthnData = WebAuthnData.build(userToLogIn);
                }
                if (Yubikey.hasKeyOfType((User)userToLogIn, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.YUBIKEY, Yubikey.SecurityType.OATH})) {
                    form = this.formFactory.form();
                }
            }
            if (form != null || webauthnData != null) {
                return CompletableFuture.completedFuture(Logins.ok((Content)checkYubikey.render(((LoginForm)f.get()).username, form, webauthnData, request, messages)).addingToSession(request, PASSWORD_SESSION_KEY, ((LoginForm)f.get()).password));
            }
            return CompletableFuture.completedFuture(Logins.ok((Content)checkYubikey.render(((LoginForm)f.get()).username, null, WebAuthnData.buildDummyData(((LoginForm)f.get()).username), request, messages)));
        }
        if (userToLogIn == null) {
            BLLoggerPlay.info("FAILED LOGIN ATTEMPT: User " + ((LoginForm)f.get()).username + " does not exist. (IP: " + ipAddress + ")");
            ScheduledFuture<Result> future = this.scheduledExecutorService.schedule(() -> Logins.ok((Content)index.render((Form<LoginForm>)f.withGlobalError("login.invalid.user"), request, messages)), Setup.INVALID_PASSWORD_DELAY, TimeUnit.SECONDS);
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return (Result)future.get();
                }
                catch (Exception e) {
                    return null;
                }
            }, this.single);
        }
        if (userToLogIn.isLocked()) {
            BLLoggerPlay.info("FAILED LOGIN ATTEMPT: User " + ((LoginForm)f.get()).username + " is locked. (IP: " + ipAddress + ")");
            if (userToLogIn.isAdmin()) {
                new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logAdminLoginFailed(userToLogIn, "user is locked.", ipAddress);
            }
            ScheduledFuture<Result> future = this.scheduledExecutorService.schedule(() -> Logins.ok((Content)index.render((Form<LoginForm>)f.withGlobalError("login.locked.user"), request, messages)), Setup.INVALID_PASSWORD_DELAY, TimeUnit.SECONDS);
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return (Result)future.get();
                }
                catch (Exception e) {
                    return null;
                }
            }, this.single);
        }
        try {
            if (!DatabaseToken.checkPassword((User)userToLogIn, (char[])((LoginForm)f.get()).password.toCharArray(), (BLLogger)BLLoggerPlay.getLogger())) {
                String errorKey;
                BLLoggerPlay.info("FAILED LOGIN ATTEMPT: Incorrect password for user " + userToLogIn.getName() + ". (IP: " + ipAddress + ")");
                if (userToLogIn.isAdmin()) {
                    new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logAdminLoginFailed(userToLogIn, "incorrect password.", ipAddress);
                }
                if (userToLogIn.setLoginError()) {
                    BLLoggerPlay.info("User " + ((LoginForm)f.get()).username + " has been locked. (IP: " + ipAddress + ")");
                    errorKey = "login.locked.user";
                    if (userToLogIn.isAdmin()) {
                        new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logAdminLocked(userToLogIn, ipAddress);
                    }
                } else {
                    errorKey = "login.invalid.user";
                }
                ScheduledFuture<Result> future = this.scheduledExecutorService.schedule(() -> Logins.ok((Content)index.render((Form<LoginForm>)f.withGlobalError(errorKey), request, messages)), Setup.INVALID_PASSWORD_DELAY, TimeUnit.SECONDS);
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return (Result)future.get();
                    }
                    catch (Exception e) {
                        return null;
                    }
                }, this.single);
            }
        }
        catch (Exception e) {
            BLLoggerPlay.error(e.toString(), e);
            return CompletableFuture.completedFuture(Logins.ok((Content)index.render((Form<LoginForm>)f.withGlobalError("login.invalid.user"), request, messages)));
        }
        WebAuthnData webauthnData = null;
        DynamicForm form = null;
        if (Yubikey.hasKeyOfType((User)userToLogIn, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.WEBAUTHN})) {
            webauthnData = WebAuthnData.build(userToLogIn);
        }
        if (Yubikey.hasKeyOfType((User)userToLogIn, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.YUBIKEY, Yubikey.SecurityType.OATH})) {
            form = this.formFactory.form();
        }
        if (form != null || webauthnData != null) {
            return CompletableFuture.completedFuture(Logins.ok((Content)checkYubikey.render(((LoginForm)f.get()).username, form, webauthnData, request, messages)).addingToSession(request, PASSWORD_SESSION_KEY, ((LoginForm)f.get()).password));
        }
        char[] password2 = ((LoginForm)f.get()).password.toCharArray();
        try {
            BLLoggerPlay.info("SUCCESSFUL LOGIN: for user " + userToLogIn.getName() + ". (IP: " + ipAddress + ")");
            if (userToLogIn.isAdmin()) {
                new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logAdminLoginSuccessful(userToLogIn, ipAddress, null);
            }
            EncryptData.checkForEncryptionKeyMigration((User)userToLogIn, (EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(password2));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error(e.toString(), e);
            return CompletableFuture.completedFuture(Logins.internalServerError((String)Utils.getLocalizedMessage(e, messages)));
        }
        this.deactivateAllFilters(userToLogIn);
        return CompletableFuture.completedFuture(this.finishSuccessfulLogin(request, userToLogIn, null));
    }

    private void deactivateAllFilters(User user) {
        SendFilter sendFilter = SendFilter.getFilter((User)user);
        sendFilter.setSendActive(false);
        sendFilter.setDsSignedActive(false);
        sendFilter.setDsCancelledActive(false);
        sendFilter.save();
        PaymentFilter paymentFilter = PaymentFilter.getFilter((User)user);
        paymentFilter.setOpenPaymentsFilterActive(Boolean.valueOf(false));
        paymentFilter.setSignedPaymentsFilterActive(false);
        paymentFilter.save();
        SimpleTextFilter filterRecipients = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.RECIPIENTS);
        filterRecipients.setFilterActive(false);
        filterRecipients.save();
        SimpleTextFilter filterMandates = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.MANDATES);
        filterMandates.setFilterActive(false);
        filterMandates.save();
        SimpleTextFilter cmFilter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.CM_OVERVIEW);
        cmFilter.setFilterActive(false);
        cmFilter.save();
        CmBookingFilter cmBookingsFilter = CmBookingFilter.getFilter((User)user);
        cmBookingsFilter.setFilterActive(Boolean.valueOf(false));
        cmBookingsFilter.save();
        SimpleTextFilter accountsFilter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.ACCOUNTS);
        accountsFilter.setFilterActive(false);
        accountsFilter.save();
    }

    public Result loginWithYubikey(Http.Request request, String username) {
        String ipAddress = Setup.getIPAddress(request);
        if (username == null) {
            return Logins.redirect((Call)routes.Logins.login());
        }
        User user = User.getUser((String)username);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (user == null) {
            BLLoggerPlay.info("FAILED LOGIN ATTEMPT: User " + username + " does not exist. (IP: " + ipAddress + ")");
            return Logins.redirect((Call)routes.Logins.login()).flashing("error", messages.at("login.invalid.user", new Object[0]));
        }
        Optional tmp = request.session().get(PASSWORD_SESSION_KEY);
        char[] password2 = null;
        if (tmp.isPresent()) {
            password2 = ((String)tmp.get()).toCharArray();
        }
        if (password2 == null) {
            BLLoggerPlay.info("FAILED LOGIN ATTEMPT: Timeout when waiting for the 2nd factor. (IP: " + ipAddress + ")");
            return Logins.redirect((Call)routes.Logins.login()).flashing("error", messages.at("login.invalid.user", new Object[0]));
        }
        DynamicForm form = this.formFactory.form().bindFromRequest(request, new String[0]);
        boolean showWebAuthMigrationPage = false;
        Yubikey.SecurityType securityType = null;
        if (form.get("otp") != null && !form.get("otp").isEmpty()) {
            String otp = form.get("otp");
            if (!Yubikeys.validateOTP(otp, user)) {
                BLLoggerPlay.info("FAILED LOGIN ATTEMPT: Invalid OTP for user " + user.getName() + ". (IP: " + ipAddress + ")");
                return Logins.redirect((Call)routes.Logins.login()).flashing("error", messages.at("login.invalid.user", new Object[0])).removingFromSession(request, new String[]{PASSWORD_SESSION_KEY});
            }
            securityType = Yubikey.SecurityType.OATH;
        } else if (form.get("credentialId") != null && !form.get("credentialId").isEmpty()) {
            ArrayList<WebAuthn> usedKey = new ArrayList<WebAuthn>();
            if (Yubikeys.isWebAuthnInvalid(user, form, usedKey)) {
                return Logins.redirect((Call)routes.Logins.login()).flashing("error", messages.at("login.invalid.user", new Object[0]));
            }
            if (((WebAuthn)usedKey.getFirst()).getRpId() != null && !((WebAuthn)usedKey.getFirst()).getRpId().equals(Setup.WEBAUTHN_RPID)) {
                showWebAuthMigrationPage = true;
            }
            securityType = Yubikey.SecurityType.WEBAUTHN;
        } else {
            BLLoggerPlay.info("FAILED LOGIN ATTEMPT: No 2nd factor for user " + user.getName() + ". (IP: " + ipAddress + ")");
            return Logins.redirect((Call)routes.Logins.login()).flashing("error", messages.at("login.invalid.user", new Object[0])).removingFromSession(request, new String[]{PASSWORD_SESSION_KEY});
        }
        try {
            if (!DatabaseToken.checkPassword((User)user, (char[])password2, (BLLogger)BLLoggerPlay.getLogger())) {
                BLLoggerPlay.info("FAILED LOGIN ATTEMPT: Incorrect password for user " + user.getName() + ". (IP: " + ipAddress + ")");
                if (user.setLoginError()) {
                    BLLoggerPlay.info("User " + user.getName() + " has been locked.");
                }
                return Logins.redirect((Call)routes.Logins.login()).flashing("error", messages.at("login.invalid.user", new Object[0])).removingFromSession(request, new String[]{PASSWORD_SESSION_KEY});
            }
            EncryptData.checkForEncryptionKeyMigration((User)user, (EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(password2));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error(e.toString(), e);
            return Logins.redirect((Call)routes.Logins.login()).flashing("error", messages.at("login.invalid.user", new Object[0])).removingFromSession(request, new String[]{PASSWORD_SESSION_KEY});
        }
        if (showWebAuthMigrationPage) {
            String random = UUID.randomUUID().toString();
            user.setChallenge(random);
            DB.save((Object)user);
            return Logins.redirect((String)(Setup.WEBAUTHN_URL + routes.Logins.webAuthnMigration(random).url()));
        }
        BLLoggerPlay.info("SUCCESSFUL LOGIN: for user " + user.getName() + ". (IP: " + ipAddress + ")");
        if (user.isAdmin()) {
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logAdminLoginSuccessful(user, ipAddress, securityType);
        }
        return this.finishSuccessfulLogin(request, user, null).removingFromSession(request, new String[]{PASSWORD_SESSION_KEY});
    }

    public Result webAuthnMigration(Http.Request request, String uuid) {
        User user = User.getByWebAuthMigrationUUID((String)uuid);
        if (user == null) {
            return Logins.notFound();
        }
        return Logins.ok((Content)migration.render(user.getRandomId(), Yubikeys.buildWebAuthnScript(user), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result webAuthnMigrationPost(Http.Request request, String userRandomId) {
        String flashMessage;
        String flashKey;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = (User)DB.find(User.class).where().eq("random_id", (Object)userRandomId).findOne();
        if (user == null) {
            return Logins.notFound();
        }
        byte[] tmp = User.getChallenge((User)user);
        if (tmp == null) {
            return Logins.redirect((Call)routes.Logins.logoff()).flashing("error", messages.at("yubikeys.addWebauthnError", new Object[0]));
        }
        try {
            boolean hasOtherKey = Yubikey.hasKeyOfType((User)user, (Yubikey.SecurityType[])new Yubikey.SecurityType[0]);
            String credentialId = Yubikeys.checkWebAuthnRegistration(request, user, tmp);
            if (credentialId != null) {
                flashKey = "success";
                flashMessage = Yubikeys.getFlashMessageForKeyAdded(user, user, credentialId, hasOtherKey, messages);
            } else {
                flashKey = "error";
                flashMessage = messages.at("yubikeys.addWebauthnError", new Object[0]);
            }
        }
        catch (Exception e) {
            BLLoggerPlay.error("Could not validate WebAuthn key", e);
            flashKey = "error";
            flashMessage = messages.at("yubikeys.addWebauthnError", new Object[0]);
        }
        return this.finishSuccessfulLogin(request, user, null).flashing(flashKey, flashMessage);
    }

    private Result finishSuccessfulLogin(Http.Request request, User user, Locale locale) {
        user.setLastDesFetch(null);
        user.save();
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String loginInfo = PasswordRequirement.getRequirement().getLoginInfo(user, messages.lang().toLocale());
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (loginInfo != null) {
            flashMap.put("warning", loginInfo);
        }
        if (user.getLastLogin() == null) {
            flashMap.put("info", messages.at(Branding.getBranding().getFirstLoginMessage(), new Object[]{Setup.DISPLAY_NAME}));
        } else {
            flashMap.put("info", messages.at(Branding.getBranding().getLoginMessage(), new Object[]{user.getLastLogin(), Setup.DISPLAY_NAME}));
        }
        if (user.wasErrorCounterReset()) {
            Utils.addToFlash(flashMap, "warning", messages.at("login.done.errorCounterWasReset", new Object[0]));
        }
        if (user.getErrorCounter() > 0) {
            Utils.addToFlash(flashMap, "warning", messages.at("login.done.failedlogins", new Object[]{user.getErrorCounter()}));
        }
        user.cleanLoginError();
        request = request.addAttr(Security.USERNAME, (Object)user.getName());
        if (BankUser.hasUserInitializedBanks((User)user)) {
            Banks.updateHTD(user);
        }
        String url = request.session().get(URL_SESSION_KEY).orElse(routes.Application.index().url());
        Result result = Logins.redirect((String)url);
        if (!flashMap.isEmpty()) {
            result = result.flashing(flashMap);
        }
        LoginSession session = LoginSession.createSession((User)user);
        result = result.addingToSession(request, "id", session.getId().toString());
        if (locale != null) {
            result = result.withLang(locale, this.messagesApi);
        }
        return result.removingFromSession(request, new String[]{URL_SESSION_KEY});
    }

    public Result licenseCheck(Http.Request request) {
        User user;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        DynamicForm form = this.formFactory.form().bindFromRequest(request, new String[0]);
        CheckLicenseResult result = this.checkLicense(form.get("license"), form, messages);
        if ((form = result.form()).hasErrors()) {
            return Logins.ok((Content)license.render(form, request, messages));
        }
        Optional optional = request.attrs().getOptional(Security.USERNAME);
        if (optional.isPresent() && (user = User.getUser((String)((String)optional.get()))) != null) {
            user.setWebLicense(result.licenseVO());
            user.save();
            return Logins.ok((Content)changeFirstPassword.render((Form<ChangePasswordForm>)this.formFactory.form(ChangePasswordForm.class), true, request, messages));
        }
        LoginSetup s = new LoginSetup();
        s.license = result.licenseKey();
        if (Branding.getBranding().doTenantsWithBank()) {
            s.localUser = true;
        }
        return Logins.ok((Content)setup.render((Form<LoginSetup>)this.formFactory.form(LoginSetup.class).fill((Object)s), request, messages));
    }

    public Result createUser(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form<LoginSetup> form = this.formFactory.form(LoginSetup.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            form = ((LoginSetup)form.get()).validate(form, messages.lang().toLocale());
        }
        if (form.hasErrors()) {
            return Logins.ok((Content)setup.render(form, request, messages));
        }
        User u = ((LoginSetup)form.get()).store();
        try {
            EncryptData.checkForEncryptionKeyMigration((User)u, (EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(((LoginSetup)form.get()).password.toCharArray()));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to migrate encryption key!", e);
            return Logins.internalServerError((String)Utils.getLocalizedMessage(e, messages));
        }
        if (u.isLocalUser() && Branding.getBranding().doTenantsWithBank()) {
            DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, u);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VEU, false);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS, false);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SEND_FILES, false);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FETCH_FILES, false);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FOLDER_FILES, false);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS, false);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_AWV_RECORDING, false);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_PAYMENT_RECORDING, false);
            store.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SYNCHRONISATION, false);
        }
        if (Authenticator.require2FAforLogin(u)) {
            return Logins.redirect((Call)routes.Logins.addWebAuthnPage()).flashing("newUser", u.getName());
        }
        LoginSession loginSession = LoginSession.createSession((User)u);
        request = request.addAttr(Security.USERNAME, (Object)u.getName());
        if (u.isLocalUser()) {
            return Logins.redirect((Call)routes.Application.index()).addingToSession(request, "id", loginSession.getId().toString()).flashing("newUser", u.getName());
        }
        return Logins.redirect((Call)routes.Banks.createBankFromLicense()).addingToSession(request, "id", loginSession.getId().toString()).flashing("newUser", u.getName());
    }

    public Result addWebAuthnPage(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Integer userId = Integer.valueOf(request.session().get("loginuser").orElse("0"));
        User user = (User)DB.find(User.class).where().eq("id", (Object)userId).findOne();
        return Logins.ok((Content)yubikeyAddWebAuthnView.render(Yubikeys.buildWebAuthnScript(user), user, true, null, request, messages));
    }

    public Result addWebAuthn(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Integer userId = Integer.valueOf(request.session().get("loginuser").orElse("0"));
        User user = (User)DB.find(User.class).where().eq("id", (Object)userId).findOne();
        if (user == null) {
            return Logins.redirect((Call)routes.Logins.addWebAuthnPage()).flashing("error", messages.at("users.unknown", new Object[0]));
        }
        byte[] tmp = User.getChallenge((User)user);
        if (tmp == null) {
            return Logins.redirect((Call)routes.Logins.addWebAuthnPage()).flashing("error", messages.at("yubikeys.addWebauthnError", new Object[0]));
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        try {
            String credentialId = Yubikeys.checkWebAuthnRegistration(request, user, tmp);
            if (credentialId != null) {
                flashMap.put("success", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.tokenAddedFirst", (Object[])new Object[]{credentialId}));
            } else {
                flashMap.put("error", messages.at("yubikeys.addWebauthnError", new Object[0]));
            }
        }
        catch (Exception e) {
            BLLoggerPlay.error("Could not validate WebAuthn key", e);
            flashMap.put("error", messages.at("yubikeys.addWebauthnError", new Object[0]));
        }
        if (Utils.hasErrorFlash(flashMap)) {
            return Logins.redirect((Call)routes.Logins.addWebAuthnPage()).flashing(flashMap);
        }
        Utils.addToFlash(flashMap, "info", messages.at("setup.complete", new Object[0]));
        return Logins.redirect((Call)routes.Logins.indexUser(user.getName())).flashing(flashMap);
    }

    public Result switchLang(Http.Request request, String language) {
        Optional username = request.session().get("username");
        Optional ref = request.headers().get("Referer");
        Result result = ref.isPresent() ? Logins.redirect((String)((String)ref.get())) : (username.isPresent() ? Logins.redirect((Call)routes.Logins.index()) : Logins.redirect((Call)routes.Application.index()));
        for (Lang l : request.acceptLanguages()) {
            if (!language.equals(l.language())) continue;
            return result.withLang(l, this.messagesApi);
        }
        return result.withLang(Lang.forCode((String)language), this.messagesApi);
    }

    @Security.Authenticated(value=Authenticator.class)
    public Result openIdLogOff(Http.Request request) {
        Optional optional = request.attrs().getOptional(Security.USERNAME);
        optional.ifPresent(Authenticator::revokeOpenIdToken);
        return this.logoff(request);
    }

    public Result logoff(Http.Request request) {
        Optional id = request.session().get("id");
        id.ifPresent(s -> LoginSession.closeSession((long)Long.parseLong(s)));
        return Logins.ok((Content)logoff.render(request, this.messagesApi.preferred((Http.RequestHeader)request))).withNewSession();
    }

    private CheckLicenseResult checkLicense(String licenseText, DynamicForm form, Messages messages) {
        boolean downloadLicense;
        AbstractLicenseHandler.LicenseCheckResult checkResult;
        License licenseVO = null;
        if (licenseText != null) {
            licenseText = licenseText.trim();
        }
        if (licenseText == null || licenseText.isEmpty()) {
            return new CheckLicenseResult(form.withError("license", "error.required"), null, licenseText);
        }
        if (licenseText.length() > 11) {
            try {
                byte[] raw = Base64Util.decode((String)licenseText);
                licenseText = new String(raw, 0, 11);
                licenseVO = License.findById((String)licenseText);
                if (licenseVO == null) {
                    licenseVO = new License();
                    licenseVO.setId(licenseText);
                }
                licenseVO.setContent(Arrays.copyOfRange(raw, 11, raw.length));
                licenseVO.save();
            }
            catch (Exception raw) {
                // empty catch block
            }
        }
        if (!licenseText.matches("[a-z0-9]{11}")) {
            return new CheckLicenseResult(form.withError("license", "error.invalid"), licenseVO, licenseText);
        }
        if (licenseVO == null && (licenseVO = License.findById((String)licenseText)) == null) {
            licenseVO = new License();
            licenseVO.setId(licenseText);
        }
        if ((checkResult = (downloadLicense = licenseVO.getContent() == null || licenseVO.getContent().length == 0) ? LicenseHandler.getInstance().downloadLicense(licenseVO) : LicenseHandler.getInstance().checkLicense(licenseVO)) == AbstractLicenseHandler.LicenseCheckResult.OK) {
            licenseVO.save();
            return new CheckLicenseResult(form, licenseVO, licenseText);
        }
        String message = checkResult.getMessage(messages.lang().locale());
        if (message != null) {
            return new CheckLicenseResult(form.withError("license", message), licenseVO, licenseText);
        }
        return new CheckLicenseResult(form.withError("license", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"License.unknown", (Object[])new Object[0])), licenseVO, licenseText);
    }

    public Result deImpersonate(Http.Request request) {
        long sessionId;
        long id = Long.parseLong(request.session().get("iid").orElse("0"));
        if (id > 0L && (sessionId = Long.parseLong(request.session().get("id").orElse("0"))) > 0L) {
            LoginSession.impersonateUser((long)sessionId, (User)((User)DB.find(User.class, (Object)id)));
        }
        return Logins.redirect((Call)routes.Application.index()).removingFromSession(request, new String[]{"iid"});
    }

    static {
        for (String language : new String[]{"de", "en", "fr", "es", "nl", "pl", "pt"}) {
            Locale locale = new Locale.Builder().setLanguage(language).build();
            LANGUAGES.add((Tuple2<String, String>)Scala.Tuple((Object)language, (Object)StringUtils.capitalize((String)locale.getDisplayLanguage(locale))));
        }
        openIdLogOffUrl = null;
    }

    private record CheckLicenseResult(DynamicForm form, License licenseVO, String licenseKey) {
    }
}

