/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Banks;
import controllers.SetupAuthenticator;
import controllers.UserSetupAuthenticator;
import controllers.branding.geva.GevaEbicsUserLoader;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import controllers.util.GeneralUtils;
import controllers.util.LicenseHandler;
import controllers.util.PasswordKeyEncryptionHandler;
import de.businesslogics.banking.api.AbstractLicenseHandler;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.schema.response.EbicsException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import models.ChangePasswordForm;
import models.GevaSetupForm;
import models.UserResetPasswordForm;
import play.Environment;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.html.setup.geva;
import views.html.setup.geva2;
import views.html.setup.gevaResetUser;
import views.html.setup.gevaUser;

public class GevaSetup
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final Environment environment;

    @Inject
    public GevaSetup(FormFactory formFactory, MessagesApi messagesApi, Environment environment) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.environment = environment;
    }

    @Security.Authenticated(value=SetupAuthenticator.class)
    public Result index(Http.Request request) {
        GevaEbicsUserLoader.SetupState setupState = GevaEbicsUserLoader.getInstance().getDoneState();
        return switch (setupState) {
            case GevaEbicsUserLoader.SetupState.START -> GevaSetup.ok((Content)geva.render((Form<GevaSetupForm>)this.formFactory.form(GevaSetupForm.class).fill((Object)new GevaSetupForm()), request, this.messagesApi.preferred((Http.RequestHeader)request)));
            case GevaEbicsUserLoader.SetupState.INITIALIZED -> GevaSetup.ok((Content)geva2.render(null, request, this.messagesApi.preferred((Http.RequestHeader)request)));
            default -> GevaSetup.redirect((Call)routes.Application.index());
        };
    }

    @Security.Authenticated(value=SetupAuthenticator.class)
    public Result getPDF() {
        return GevaSetup.ok((File)this.environment.getFile("geva.pdf")).withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("INI.pdf"));
    }

    @Security.Authenticated(value=SetupAuthenticator.class)
    public Result start(Http.Request request) {
        if (GevaEbicsUserLoader.getInstance().getDoneState() == null) {
            return GevaSetup.ok((Content)geva.render((Form<GevaSetupForm>)this.formFactory.form(GevaSetupForm.class).fill((Object)new GevaSetupForm()), request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        try {
            GevaEbicsUserLoader.getInstance().start(this.environment);
            return GevaSetup.redirect((Call)routes.Application.index());
        }
        catch (EbicsException | IOException | URISyntaxException | GeneralSecurityException e) {
            BLLoggerPlay.error("Error fetching the user-list from sync-server", e);
            return GevaSetup.ok((Content)geva2.render(e.toString(), request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
    }

    @Security.Authenticated(value=SetupAuthenticator.class)
    public Result initialize(Http.Request request) {
        AbstractLicenseHandler.LicenseCheckResult result;
        Form f = this.formFactory.form(GevaSetupForm.class).bindFromRequest(request, new String[0]);
        if (f.hasErrors()) {
            return GevaSetup.ok((Content)geva.render((Form<GevaSetupForm>)f, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String url = ((GevaSetupForm)f.get()).url;
        String licenseCode = ((GevaSetupForm)f.get()).licenseCode;
        try {
            new URI(url);
        }
        catch (URISyntaxException mal) {
            f = f.withError("url", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidUrl", (Object[])new Object[0]));
        }
        AbstractLicenseHandler h = LicenseHandler.getInstance();
        License license2 = License.findById((String)licenseCode);
        if (license2 == null) {
            license2 = new License();
            license2.setId(licenseCode);
            result = h.downloadLicense(license2);
        } else {
            result = h.checkLicense(license2);
        }
        if (!AbstractLicenseHandler.LicenseCheckResult.OK.equals((Object)result)) {
            f = f.withError("licenseCode", result.getMessage(Locale.GERMAN));
        }
        if (f.hasErrors()) {
            return GevaSetup.ok((Content)geva.render((Form<GevaSetupForm>)f, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        try {
            GevaEbicsUserLoader.getInstance().initialize((GevaSetupForm)f.get(), this.environment, license2);
            return GevaSetup.redirect((Call)routes.GevaSetup.index());
        }
        catch (Exception e) {
            f = f.withGlobalError(e.toString());
            return GevaSetup.ok((Content)geva.render((Form<GevaSetupForm>)f, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
    }

    @Security.Authenticated(value=UserSetupAuthenticator.class)
    public Result newUserIni(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Form<ChangePasswordForm> form = this.formFactory.form(ChangePasswordForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors() && form.value().isPresent()) {
            form = ((ChangePasswordForm)form.get()).validate(form, user, false, this.messagesApi.preferred((Http.RequestHeader)request).lang().toLocale());
        }
        if (form.hasErrors()) {
            if (form.value().isPresent() && ((ChangePasswordForm)form.value().get()).isUserLocked()) {
                BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                return GevaSetup.ok((Content)gevaUser.render((Form<ChangePasswordForm>)form.withGlobalError("login.locked.user"), request, this.messagesApi.preferred((Http.RequestHeader)request)));
            }
            return GevaSetup.ok((Content)gevaUser.render(form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        try {
            this.doUserIni(user, ((ChangePasswordForm)form.get()).newPassword.toCharArray());
        }
        catch (Exception e) {
            BLLoggerPlay.error("Error during user initialisation", e);
            form = form.withGlobalError(e.toString());
            return GevaSetup.ok((Content)gevaUser.render(form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        return GevaSetup.redirect((Call)routes.Application.index());
    }

    @Security.Authenticated(value=UserSetupAuthenticator.class)
    public Result resetUserIni(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        BLLoggerPlay.info("Resetting user " + user.getId());
        Form form = this.formFactory.form(UserResetPasswordForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors() && form.value().isPresent()) {
            form = ((UserResetPasswordForm)form.get()).validate((Form<UserResetPasswordForm>)form, user, messages.lang().toLocale());
        }
        if (form.hasErrors()) {
            return GevaSetup.ok((Content)gevaResetUser.render((Form<UserResetPasswordForm>)form, request, messages));
        }
        try {
            ((UserResetPasswordForm)form.get()).resetBanksForUser(user, true);
        }
        catch (EbicsException | IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Error during user reset", e);
        }
        try {
            this.doUserIni(user, ((UserResetPasswordForm)form.get()).newPassword.toCharArray());
        }
        catch (Exception e) {
            BLLoggerPlay.error("Error during user re-ini (after reset)", e);
            form = form.withGlobalError(e.toString());
            return GevaSetup.ok((Content)gevaResetUser.render((Form<UserResetPasswordForm>)form, request, messages));
        }
        return GevaSetup.redirect((Call)routes.Application.index()).flashing("success", messages.at("users.resetuser.done.local", new Object[]{user.getName()}));
    }

    private void doUserIni(User user, char[] newPassword) throws Exception {
        List bankUsers = BankUser.findBanksForUser((User)user);
        Iterator iterator = bankUsers.iterator();
        while (iterator.hasNext()) {
            BankUser bankUser;
            bankUser.setWithCerts((bankUser = (BankUser)iterator.next()).getBank().isFrenchBank() || BankUtils.isProtocolH005OrNewer((String)bankUser.getBank().getProtocolVersion()));
            EbicsUtil.initializeUser(bankUser.getBank(), user, bankUser, newPassword, Locale.GERMAN);
        }
        user.setEncryptionKey(EncryptData.getInstance().copyKey((EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(newPassword)));
        user.setLastPasswordChange(new Date(System.currentTimeMillis()));
        user.cleanLoginError();
        PasswordRequirement.getRequirement().saveUsage(user, newPassword, BLLoggerPlay.getLogger());
        Banks.updateHTD(user);
    }

    @Security.Authenticated(value=UserSetupAuthenticator.class)
    public Result newUser(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List bankUsers = BankUser.findBanksForUser((User)user);
        if (!bankUsers.isEmpty()) {
            for (BankUser bankuser : bankUsers) {
                if (!BankUser.UserState.READY.equals((Object)bankuser.getState())) continue;
                return GevaSetup.redirect((Call)routes.Application.index());
            }
        }
        Form form = this.formFactory.form(ChangePasswordForm.class);
        return GevaSetup.ok((Content)gevaUser.render((Form<ChangePasswordForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    @Security.Authenticated(value=UserSetupAuthenticator.class)
    public Result resetUser(Http.Request request) {
        Form form = this.formFactory.form(UserResetPasswordForm.class);
        return GevaSetup.ok((Content)gevaResetUser.render((Form<UserResetPasswordForm>)form, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }
}

