/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.Sent;
import controllers.Setup;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import controllers.util.BankOrderCheckHandler;
import controllers.util.BankOrderResultHandler;
import controllers.util.FolderFileItem;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.io.Streams;
import de.businesslogics.util.BLLogger;
import io.ebean.Query;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.BankOrderWithPayments;
import models.FolderForm;
import models.PasswordForm;
import models.SignOrdersForm;
import models.SimpleTextForm;
import models.WebAuthnData;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Menu;
import views.Utils;
import views.html.orders.folderfiles;
import views.html.orders.signorder;
import views.html.settings.editfolder;
import views.html.settings.folders;
import views.html.settings.newfolder;

@Security.Authenticated(value=AuthenticatorFor.Folders.class)
public final class Folders
extends Controller {
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    public static String loadJsParameters(Messages messages, List<FolderFileItem> files) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("signMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.sign", (Object[])new Object[0]));
        resultJson.put("deleteMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.delete", (Object[])new Object[0]));
        ObjectNode node = resultJson.putObject("deleteTitle");
        node.put("single", messages.at("folders.files.delete.title", new Object[]{1}));
        node.put("multiple", messages.at("folders.files.delete.title", new Object[]{999}));
        node.put("none", messages.at("folders.files.delete.title", new Object[]{0}));
        resultJson.put("uploadMessage", messages.at("folders.upload.message", new Object[0]));
        node = resultJson.putObject("deleteQuestion");
        node.put("single", messages.at("folders.files.delete.question", new Object[]{1}));
        node.put("multiple", messages.at("folders.files.delete.question", new Object[]{999}));
        node.put("none", messages.at("folders.files.delete.question", new Object[]{0}));
        resultJson.put("uploadMessage", messages.at("folders.upload.message", new Object[0]));
        resultJson.put("uploadLink", routes.Folders.listFiles().toString());
        ArrayNode filesNode = resultJson.putArray("files");
        for (int i = 0; i < files.size(); ++i) {
            ObjectNode fileNode = filesNode.addObject();
            fileNode.put("id", i);
            fileNode.put("info", files.get(i).toString());
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadAdminJsParameters(Messages messages) {
        ObjectNode resultJson = Json.newObject();
        ObjectNode node = resultJson.putObject("deleteTitle");
        node.put("single", messages.at("folders.delete.title", new Object[]{1}));
        node.put("multiple", messages.at("folders.delete.title", new Object[]{999}));
        node.put("none", messages.at("folders.delete.title", new Object[]{0}));
        node = resultJson.putObject("deleteQuestion");
        node.put("single", messages.at("folders.delete.question", new Object[]{1}));
        node.put("multiple", messages.at("folders.delete.question", new Object[]{999}));
        node.put("none", messages.at("folders.delete.question", new Object[]{0}));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public Folders(MessagesApi messagesApi, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
    }

    public Result index_tenant(Http.Request request, Integer tenant) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.DIRECTORY_SCANNER).setProperty("TENANT", tenant != null ? String.valueOf(tenant) : null);
        return Folders.redirect((Call)routes.Folders.index());
    }

    public Result index(Http.Request request) {
        List list;
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (user == null || !user.isAdmin()) {
            return Folders.redirect((Call)routes.Application.index()).flashing("error", messages.at("folders.nopermission", new Object[0]));
        }
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.DIRECTORY_SCANNER);
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException e) {
            tenant = null;
        }
        Query query = DB.find(DirectoryScanner.class);
        if (tenant != null) {
            query = query.where().eq("bank.tenant", (Object)tenant).query();
        }
        if (sorting.getSortingColumn() == 0) {
            if (sorting.isSortingAscending()) {
                query.order("bank.displayName asc");
            } else {
                query.order("bank.displayName desc");
            }
        } else if (sorting.getSortingColumn() == 1) {
            if (sorting.isSortingAscending()) {
                query.order("orderOrFileType asc");
            } else {
                query.order("orderOrFileType desc");
            }
        } else if (sorting.getSortingColumn() == 2) {
            if (sorting.isSortingAscending()) {
                query.order("directory asc");
            } else {
                query.order("directory desc");
            }
        } else if (sorting.getSortingColumn() == 3) {
            if (sorting.isSortingAscending()) {
                query.order("bank.tenant asc");
            } else {
                query.order("bank.tenant desc");
            }
        }
        sorting.computeForQuery(query);
        query = query.setFirstRow(sorting.getPageNumber() * sorting.getPageSize()).setMaxRows(sorting.getPageSize());
        try {
            list = query.findPagedList().getList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.DIRECTORY_SCANNER, (Call)routes.Folders.index());
        }
        return Folders.ok((Content)folders.render(list, sorting, tenant, request, messages));
    }

    public Result indexPage(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.DIRECTORY_SCANNER).updatePage(page, pageSize);
        return Folders.redirect((Call)routes.Folders.index());
    }

    public Result indexSort(Http.Request request, int column, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.DIRECTORY_SCANNER).updateSort(column, asc);
        return Folders.redirect((Call)routes.Folders.index());
    }

    public Result newFolder(Http.Request request, boolean post) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (user == null || !user.isAdmin()) {
            return Folders.redirect((Call)routes.Application.index()).flashing("error", messages.at("folders.nopermission", new Object[0]));
        }
        if (post) {
            Form<FolderForm> form = this.formFactory.form(FolderForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((FolderForm)form.get()).validate(form, null);
            }
            if (form.hasErrors()) {
                return Folders.ok((Content)newfolder.render(form, request, messages));
            }
            ((FolderForm)form.get()).save(user);
            return Folders.redirect((Call)routes.Folders.index()).flashing("success", messages.at("folders.new.done", new Object[0]));
        }
        return Folders.ok((Content)newfolder.render((Form<FolderForm>)this.formFactory.form(FolderForm.class), request, messages));
    }

    public Result edit(Http.Request request, Integer i, boolean post) {
        return this.editFolder(request, i, post, false);
    }

    public Result editMode(Http.Request request, Integer i, boolean post) {
        return this.editFolder(request, i, post, true);
    }

    public Result editFolder(Http.Request request, Integer i, boolean post, boolean inEditMode) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (user == null || !user.isAdmin()) {
            return Folders.redirect((Call)routes.Application.index()).flashing("error", messages.at("folders.nopermission", new Object[0]));
        }
        DirectoryScanner scanner = (DirectoryScanner)DB.find(DirectoryScanner.class, (Object)i);
        if (scanner == null) {
            return Folders.redirect((Call)routes.Folders.index()).flashing("error", messages.at("cm.error.noSuchItem", new Object[0]));
        }
        if (post) {
            Form<FolderForm> form = this.formFactory.form(FolderForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((FolderForm)form.get()).validate(form, scanner);
            }
            if (form.hasErrors()) {
                return Folders.ok((Content)newfolder.render(form, request, messages));
            }
            ((FolderForm)form.get()).save(user, scanner);
            return Folders.redirect((Call)routes.Folders.edit(i, false)).flashing("success", messages.at("folders.edit.done", new Object[0]));
        }
        return Folders.ok((Content)editfolder.render((Form<FolderForm>)this.formFactory.form(FolderForm.class).fill((Object)new FolderForm(scanner)), i, inEditMode, request, messages));
    }

    public Result delete(Http.Request request) {
        return this.deleteFolders(request, null);
    }

    public Result deleteFolder(Http.Request request, Integer id) {
        return this.deleteFolders(request, id);
    }

    public Result deleteFolders(Http.Request request, Integer id) {
        String ids = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        if (user == null || !user.isAdmin()) {
            return Folders.redirect((Call)routes.Application.index()).flashing("error", messages.at("folders.nopermission", new Object[0]));
        }
        List<Integer> folderIds = GeneralUtils.getSelectionIds(ids);
        int count = 0;
        if (!folderIds.isEmpty()) {
            for (DirectoryScanner dir : DB.find(DirectoryScanner.class).where().in("id", folderIds).findList()) {
                DB.delete((Object)dir);
                logger.logDirectoryScannerDeleted(user, dir);
                ++count;
            }
        }
        String flashKey = count == 0 ? "warning" : "success";
        return Folders.redirect((Call)routes.Folders.index()).flashing(flashKey, messages.at("folders.deleted", new Object[]{count}));
    }

    public CompletionStage<Result> listFiles(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            List<FolderFileItem> items;
            Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.DIRECTORY_SCANNER_FILES);
            try {
                items = FolderFileItem.findForUser(user);
                items.sort(new FolderFileItem.Comparator(sorting.getSortingColumn(), sorting.isSortingAscending()));
                items = sorting.computeForList(items);
            }
            catch (PersistenceException e) {
                return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.DIRECTORY_SCANNER_FILES, (Call)routes.Folders.listFiles());
            }
            return Folders.ok((Content)folderfiles.render(items, sorting, DirectoryScanner.findForUser((User)user), request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }, this.executionContext.current());
    }

    public Result listFilesSort(Http.Request request, int column, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.DIRECTORY_SCANNER_FILES).updateSort(column, asc);
        return Folders.redirect((Call)routes.Folders.listFiles());
    }

    public Result listFilesPage(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.DIRECTORY_SCANNER_FILES).updatePage(page, pageSize);
        return Folders.redirect((Call)routes.Folders.listFiles());
    }

    public CompletionStage<Result> createBankOrders(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        final Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            try {
                String fileIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
                List<FolderFileItem> list = FolderFileItem.fromString(fileIds);
                List<BankOrderWithPayments> bankOrders = new ArrayList<BankOrderWithPayments>();
                HashMap<String, Send> existingOrders = new HashMap<String, Send>();
                String errorMessage = fileIds;
                if (!list.isEmpty()) {
                    boolean checkForDoubleTransmission = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.CHECK_DOUBLE_TRANSMISSION);
                    for (FolderFileItem item : list) {
                        BankOrder bankOrder;
                        Send existingOrder;
                        if (checkForDoubleTransmission && (existingOrder = item.findExistingOrder()) != null) {
                            existingOrders.put(item.getFile().getName(), existingOrder);
                        }
                        if ((bankOrder = item.createBankOrder(user, messages.lang().toLocale())) != null) {
                            bankOrders.add(new BankOrderWithPayments(bankOrder, null));
                            continue;
                        }
                        errorMessage = messages.at("general.invalidbank", new Object[0]);
                    }
                }
                if (!bankOrders.isEmpty()) {
                    bankOrders = BankOrderWithPayments.sortByPmtType(bankOrders);
                    final HashMap<String, String> flashMap = new HashMap<String, String>();
                    BankOrderCheckHandler checkHandler = new BankOrderCheckHandler(){
                        private boolean hasError;

                        @Override
                        public void unknownOriginatorAccount(String account) {
                            flashMap.put("error", messages.at("sent.send.error.unknownoriginatoraccount", new Object[]{account}));
                            this.hasError = true;
                        }

                        @Override
                        public void invalidBankConnection(String account) {
                            flashMap.put("error", messages.at("sent.send.error.invalidrecipientaccount", new Object[]{account}));
                            this.hasError = true;
                        }

                        @Override
                        public void exceededAmount(String message) {
                            flashMap.put("error", message);
                            this.hasError = true;
                        }

                        @Override
                        public void handleException(Exception e) {
                            if (e instanceof KnownFormatException) {
                                flashMap.put("HTMLwarning", Utils.getLocalizedMessage(e, messages));
                            } else {
                                flashMap.put("HTMLerror", Utils.getLocalizedMessage(e, messages));
                                this.hasError = true;
                            }
                        }

                        @Override
                        public boolean hasError() {
                            return this.hasError;
                        }
                    };
                    for (BankOrderWithPayments bankOrder : bankOrders) {
                        bankOrder.getBankOrder().checkPaymentInformation(user, messages.lang().locale(), checkHandler);
                    }
                    if (checkHandler.hasError()) {
                        return Folders.redirect((Call)routes.Folders.listFiles()).flashing(flashMap);
                    }
                    return Folders.ok((Content)signorder.render((Form<SignOrdersForm>)this.formFactory.form(SignOrdersForm.class).fill((Object)SignOrdersForm.fillForm(user, bankOrders)), bankOrders, Menu.SendFolderFiles, false, flashMap, existingOrders, WebAuthnData.buildForSigning(user), null, request, messages));
                }
                return Folders.redirect((Call)routes.Folders.listFiles()).flashing("error", messages.at("sent.send.error.ordernotfound", new Object[]{errorMessage}));
            }
            catch (DisplayFileException | KnownFormatException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to create send order for import file!", e);
                return Folders.redirect((Call)routes.Folders.listFiles()).flashing("HTMLerror", messages.at("sent.send.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> sendFiles(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form passwordForm = this.formFactory.form(SignOrdersForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            String bankOrderString = ((SignOrdersForm)passwordForm.get()).requestString;
            if (bankOrderString == null || bankOrderString.isEmpty()) {
                return Folders.redirect((Call)routes.Folders.listFiles()).flashing("error", messages.at("sent.send.error.invalidparameter", new Object[]{bankOrderString}));
            }
            if (!BankOrder.checkForDoubleTransmission(bankOrderString)) {
                return Folders.redirect((Call)routes.Folders.listFiles()).flashing("warning", messages.at("sent.send.error.double", new Object[0]));
            }
            try {
                Form passwordResultForm;
                List<BankOrderWithPayments> bankOrders;
                try {
                    bankOrders = BankOrder.getBankOrdersFromRequestString(user, bankOrderString, ((SignOrdersForm)passwordForm.get()).additionalInfos, ((SignOrdersForm)passwordForm.get()).useVop, messages.lang().toLocale());
                }
                catch (DisplayFileException | KnownFormatException | IOException e) {
                    BLLoggerPlay.error("Failed to parse bank order from import folder!", e);
                    Result result = Folders.redirect((Call)routes.Folders.listFiles()).flashing("HTMLerror", messages.at("sent.send.error.failedtoload", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                    BankOrder.finishedBankOrder(bankOrderString);
                    return result;
                }
                if (bankOrders == null || bankOrders.isEmpty()) {
                    Result e = Folders.redirect((Call)routes.Folders.listFiles()).flashing("error", messages.at("sent.printreport.notfound", new Object[0]));
                    return e;
                }
                if (!passwordForm.hasErrors()) {
                    passwordResultForm = ((SignOrdersForm)passwordForm.get()).checkPassword(passwordForm, user, PasswordForm.PasswordType.EBICS_PASSWORD, messages.lang().locale());
                    if (passwordResultForm.value().isPresent() && ((SignOrdersForm)passwordResultForm.value().get()).isUserLocked()) {
                        BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                        bankOrders.forEach(bo -> OpenPayment.unlockPayments(bo.getOpenPayments()));
                        Result result = Folders.redirect((Call)routes.Folders.listFiles()).flashing("error", "login.locked.user");
                        return result;
                    }
                } else {
                    passwordResultForm = passwordForm;
                }
                if (passwordResultForm.hasErrors()) {
                    Result result = Folders.ok((Content)signorder.render(passwordResultForm, bankOrders, Menu.SendFolderFiles, true, null, null, WebAuthnData.buildForSigning(user), null, request, messages));
                    return result;
                }
                int orderCount = bankOrders.size();
                HashMap<String, String> flashMap = new HashMap<String, String>();
                Map<Integer, Integer> sendOrders = Sent.sendOrders(bankOrders, ((SignOrdersForm)passwordForm.get()).password.toCharArray(), new BankOrderResultHandler(messages, flashMap), null, Setup.getIPAddress(request));
                StringBuilder ids = new StringBuilder();
                for (Integer i : sendOrders.keySet()) {
                    if (!ids.isEmpty()) {
                        ids.append(",");
                    }
                    ids.append(i.toString());
                }
                flashMap.put("sendItems", ids.toString());
                flashMap.put("success", messages.at("folders.sent", new Object[]{orderCount}));
                Result result = Folders.redirect((Call)routes.Folders.listFiles()).flashing(flashMap);
                return result;
            }
            finally {
                BankOrder.finishedBankOrder(bankOrderString);
            }
        }, this.executionContext.current());
    }

    public Result deleteFiles(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String fileNames = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        if (fileNames == null || fileNames.isEmpty()) {
            return Folders.redirect((Call)routes.Folders.listFiles()).flashing("error", messages.at("sent.send.error.invalidparameter", new Object[]{fileNames}));
        }
        List<FolderFileItem> list = FolderFileItem.fromString(fileNames);
        int count = 0;
        for (FolderFileItem item : list) {
            if (!item.getFile().delete()) {
                BLLoggerPlay.warning("Failed to delete file " + item.getFile().getAbsolutePath());
                continue;
            }
            ++count;
        }
        String flashKey = count != list.size() ? "warning" : "success";
        return Folders.redirect((Call)routes.Folders.listFiles()).flashing(flashKey, messages.at("folders.files.deleted", new Object[]{count}));
    }

    public Result uploadDone(Http.Request request, Integer scannerId, String dzuuid, String filename) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List scanners = DirectoryScanner.findForUser((User)user);
        for (DirectoryScanner scanner : scanners) {
            if (!scanner.getId().equals(scannerId)) continue;
            File directory = new File(scanner.getDirectory());
            File file2 = new File(directory, ".tmp" + dzuuid);
            File dest = new File(directory, new File(filename).getName());
            if (file2.exists() && !file2.renameTo(dest)) {
                BLLoggerPlay.warning("Failed to move file " + file2.getAbsolutePath() + " to " + dest.getAbsolutePath());
            }
            return Folders.ok();
        }
        return Folders.notFound();
    }

    public Result uploadChunk(Http.Request request, Integer scannerId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List scanners = DirectoryScanner.findForUser((User)user);
        for (DirectoryScanner scanner : scanners) {
            if (!scanner.getId().equals(scannerId)) continue;
            Http.MultipartFormData data = request.body().asMultipartFormData();
            Http.MultipartFormData.FilePart filePart = data.getFile("file");
            if (!GeneralUtils.checkUploadFile(filePart.getFilename())) {
                return Folders.badRequest().flashing("error", "general.upload.error.insecure");
            }
            Map parameter = data.asFormUrlEncoded();
            String dzuuid = parameter.get("dzuuid") != null ? ((String[])parameter.get("dzuuid"))[0] : UUID.randomUUID().toString();
            File directory = new File(scanner.getDirectory());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            File file2 = new File(directory, ".tmp" + dzuuid);
            try {
                FileOutputStream out = new FileOutputStream(file2, true);
                FileInputStream in = new FileInputStream(((Files.TemporaryFile)filePart.getRef()).path().toFile());
                Streams.copy((InputStream)in, (OutputStream)out);
                return Folders.ok();
            }
            catch (IOException io) {
                BLLoggerPlay.error("Failed to store uploaded file in " + file2.getAbsolutePath(), io);
            }
        }
        return Folders.notFound();
    }
}

