/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.DateFormatter;
import controllers.util.EbicsUtil;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.FetchFilter;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.transfer.api.FetchScheduler;
import de.businesslogics.banking.transfer.api.HacPtkPrinterApi;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.NoDownloadDataAvailableException;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import io.ebean.Expr;
import io.ebean.Query;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.FetchFileForm;
import models.FetchFilterForm;
import models.SimpleTextForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.orders.fetched;
import views.html.orders.fetchfile;

@Security.Authenticated(value=AuthenticatorFor.FetchFile.class)
public class Fetched
extends Controller {
    private final MessagesApi messagesApi;
    private final FormFactory formFactory;
    private final ClassLoaderExecutionContext executionContext;

    public static Seq<Tuple2<String, String>> getFetchModes(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)String.valueOf(true), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.fetchFromPeriod", (Object[])new Object[0])));
        result.add(Scala.Tuple((Object)String.valueOf(false), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.fromProvision", (Object[])new Object[0])));
        return Scala.toSeq(result);
    }

    public static String loadJsParameters(Messages messages) {
        ObjectNode resultJson = Json.newObject();
        ObjectNode deleteMessage = resultJson.putObject("deleteMessage");
        deleteMessage.put("none", messages.at("fetched.delete.label", new Object[]{0}));
        deleteMessage.put("single", messages.at("fetched.delete.label", new Object[]{1}));
        deleteMessage.put("multiple", messages.at("fetched.delete.label", new Object[]{999}));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String fetchTypeDescription(Fetch fetch, Messages messages) {
        if (fetch == null || fetch.getFetchType() == null) {
            return null;
        }
        String key = BTFTranslator.isBTFString((String)fetch.getFetchType()) ? "fetched.types." + BTFTranslator.getFetchOrderTypeFromBTF((String)fetch.getFetchType()) : "fetched.types." + fetch.getFetchType();
        String result = messages.at(key, new Object[0]);
        if (result.equals(key)) {
            OrderType orderType = OrderType.findOrderType((BankSettings)fetch.getBank(), (OrderType.TransferType)OrderType.TransferType.FETCH, (String)fetch.getOrderType(), (String)fetch.getFileType());
            if (orderType != null) {
                result = orderType.getDescription();
            } else {
                return fetch.getFetchType();
            }
        }
        return result + " - " + fetch.getFetchType();
    }

    public static String getFilterDescription(FetchFilter filter, Messages messages) {
        StringBuilder result = new StringBuilder();
        if (filter.getBank() != null) {
            result.append(messages.at("sent.filter.bank", new Object[]{filter.getBank().getDisplayName()}));
        }
        if (filter.getOrderType() != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            if (filter.getOrderTypeComparator() == FilterComparator.Text.STARTS_WITH) {
                result.append(messages.at("sent.filter.ordertype.startswith", new Object[]{filter.getOrderType()}));
            } else if (filter.getOrderTypeComparator() == FilterComparator.Text.ENDS_WITH) {
                result.append(messages.at("sent.filter.ordertype.endswith", new Object[]{filter.getOrderType()}));
            } else if (filter.getOrderTypeComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result.append(messages.at("sent.filter.ordertype.containsnot", new Object[]{filter.getOrderType()}));
            } else {
                result.append(messages.at("sent.filter.ordertype.contains", new Object[]{filter.getOrderType()}));
            }
        }
        if (filter.getFetcher() != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            if (filter.getFetcherComparator() == FilterComparator.Text.STARTS_WITH) {
                result.append(messages.at("sent.filter.fetcher.startswith", new Object[]{filter.getFetcher()}));
            } else if (filter.getFetcherComparator() == FilterComparator.Text.ENDS_WITH) {
                result.append(messages.at("sent.filter.fetcher.endswith", new Object[]{filter.getFetcher()}));
            } else if (filter.getFetcherComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result.append(messages.at("sent.filter.fetcher.containsnot", new Object[]{filter.getFetcher()}));
            } else {
                result.append(messages.at("sent.filter.fetcher.contains", new Object[]{filter.getFetcher()}));
            }
        }
        if (filter.getDateComparator() != null && filter.getFromDate() != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(messages.at("fetched.filter.date", new Object[]{filter.getDateComparator().ordinal(), filter.getFromDate(), filter.getToDate()}));
        }
        return result.toString();
    }

    public Result filter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        FetchFilter fetchFilter = FetchFilter.getFilter((User)user);
        if (active) {
            Form<FetchFilterForm> form = this.formFactory.form(FetchFilterForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((FetchFilterForm)form.get()).validate(form, fetchFilter);
            }
            if (form.hasErrors()) {
                return this.internalIndex(request, user, form, fetchFilter);
            }
            fetchFilter.setFetchActive(!fetchFilter.isEmpty());
        } else {
            fetchFilter.setFetchActive(false);
        }
        fetchFilter.save();
        return Fetched.redirect((Call)routes.Fetched.index());
    }

    private Result internalIndex(Http.Request request, User user, Form<FetchFilterForm> filterForm, FetchFilter filter) {
        List list;
        Tenant tenant;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.FETCH);
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException e) {
            tenant = null;
        }
        Query query = this.fetchQuery(user, sorting.getSortingColumn(), sorting.isSortingAscending(), filter, tenant);
        sorting.computeForQuery(query);
        query = query.setFirstRow(sorting.getPageNumber() * sorting.getPageSize()).setMaxRows(sorting.getPageSize());
        try {
            list = query.findPagedList().getList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.FETCH, (Call)routes.Fetched.index());
        }
        return Fetched.ok((Content)fetched.render(list, sorting, filterForm, filter, tenant, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    @Inject
    public Fetched(MessagesApi messagesApi, Formatters formatters, FormFactory formFactory, ClassLoaderExecutionContext executionContext) {
        this.messagesApi = messagesApi;
        this.formFactory = formFactory;
        this.executionContext = executionContext;
        formatters.register(Date.class, (Formatters.SimpleFormatter)new DateFormatter());
    }

    public Result index_tenant(Http.Request request, Integer tenant) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.FETCH).setProperty("TENANT", tenant != null ? String.valueOf(tenant) : null);
        return Fetched.redirect((Call)routes.Fetched.index());
    }

    public Result index(Http.Request request) {
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.FETCH);
        FetchFilter filter = FetchFilter.getFilter((User)user);
        Form filterForm = this.formFactory.form(FetchFilterForm.class).fill((Object)new FetchFilterForm(filter));
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException e) {
            tenant = null;
        }
        Query<Fetch> query = this.fetchQuery(user, sorting.getSortingColumn(), sorting.isSortingAscending(), filter, tenant);
        sorting.computeForQuery(query);
        List list = query.setMaxRows(sorting.getPageSize()).setFirstRow(sorting.getPageNumber() * sorting.getPageSize()).findPagedList().getList();
        return Fetched.ok((Content)fetched.render(list, sorting, (Form<FetchFilterForm>)filterForm, filter, tenant, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private Query<Fetch> fetchQuery(User user, int sort, boolean asc, FetchFilter filter, Tenant tenant) {
        Query query = DB.find(Fetch.class).where(Expr.in((String)"bank", (Collection)BankSettings.findBanksForUser((User)user)));
        if (filter.isFetchActive() && !filter.isEmpty()) {
            query.where(filter.getExpression());
        }
        if (tenant != null) {
            query = query.where().eq("bank.tenant", (Object)tenant).query();
        }
        switch (sort) {
            case 0: {
                if (asc) {
                    query = query.order("orderType asc,fileType asc,fetched asc");
                    break;
                }
                query = query.order("orderType desc,fileType desc,fetched desc");
                break;
            }
            case 2: {
                if (asc) {
                    query = query.order("file.size asc,fetched asc");
                    break;
                }
                query = query.order("file.size desc,fetched desc");
                break;
            }
            case 3: {
                if (asc) {
                    query = query.order("bank.tenant asc,fetched asc");
                    break;
                }
                query = query.order("bank.tenant desc,fetched desc");
                break;
            }
            case 5: {
                if (asc) {
                    query = query.order("fetcher asc,fetched asc");
                    break;
                }
                query = query.order("fetcher desc,fetched desc");
                break;
            }
            default: {
                query = asc ? query.order("fetched asc,orderType asc,fileType asc") : query.order("fetched desc,orderType desc,fileType desc");
            }
        }
        return query;
    }

    public Result index_sort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.FETCH).updateSort(sort, asc);
        return Fetched.redirect((Call)routes.Fetched.index());
    }

    public Result index_pageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.FETCH).updatePage(page, pageSize);
        return Fetched.redirect((Call)routes.Fetched.index());
    }

    public Result getFetchedFile(Http.Request request, int id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Fetch f = Fetch.findByIdAndUser((int)id, (User)user);
        if (f == null) {
            return Fetched.redirect((Call)routes.Fetched.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("fetched.error.noSuchFile", new Object[0]));
        }
        File file2 = WorkspaceFileSystem.getFile((WorkspaceFile)f.getFile());
        if (!file2.exists() || !file2.isFile()) {
            return Fetched.redirect((Call)routes.Fetched.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("fetched.error.noSuchFile", new Object[0]));
        }
        try {
            Object name = file2.getName();
            if (this.isZip(f)) {
                name = (String)name + ".zip";
            }
            return GeneralUtils.supplyWorkspaceFile(file2, false, false).as("binary/octet-stream").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement((String)name));
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Failed to create download to fetched order!", e);
            return Fetched.redirect((Call)routes.Fetched.index()).flashing("HTMLerror", Utils.getLocalizedMessage(e, messages));
        }
    }

    private boolean isZip(Fetch f) {
        if (f.getFetchType().contains("ZIP")) {
            return true;
        }
        String s = BTFTranslator.getBTFFromFetchOrderType((String)f.getOrderType());
        if (s != null) {
            return s.contains("ZIP");
        }
        return false;
    }

    public CompletionStage<Result> print(Http.Request request, int id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            Fetch fetch = Fetch.findByIdAndUser((int)id, (User)user);
            if (fetch == null) {
                return Fetched.redirect((Call)routes.Fetched.index()).flashing("error", messages.at("fetched.error.noSuchFile", new Object[0]));
            }
            try {
                HacPtkPrinterApi printer = new HacPtkPrinterApi(BLLoggerPlay.getLogger(), EncryptData.getInstance());
                if (!printer.canHandle(fetch.getOrderType())) {
                    return Fetched.redirect((Call)routes.Fetched.index()).flashing("error", messages.at("fetched.error.cannotPrintOrderType", new Object[]{fetch.getOrderType()}));
                }
                File tmp = Util.createTempFile((String)(fetch.getOrderType() + "ProtocolFile"), (String)".pdf", (boolean)true);
                OutputStream pdfOutputStream = Files.newOutputStream(tmp.toPath(), new OpenOption[0]);
                boolean printLogo = GeneralUtils.printLogo(user);
                BLDocument document = Util.createBLDocument((OutputStream)pdfOutputStream, (BLDocument.PageLayout)BLDocument.PageLayout.A4, (String)fetch.getOrderType(), (boolean)printLogo, (Locale)messages.lang().locale());
                Tenant tenant = fetch.getBank().getTenant();
                printer.addToDocument(fetch.getBank(), WorkspaceFileSystem.getFile((WorkspaceFile)fetch.getFile()), fetch.getOrderType(), document, new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user, tenant).getBoolean((DatabasePreferenceConstant)PreferenceConstants.SEND_REPORT_DETAILS_WITH_PAGE_BREAK), messages.lang().locale());
                document.close();
                Util.applyPreferencesToPdf((File)tmp, (User)user, null, (Locale)messages.lang().locale(), null, null, (boolean)printLogo);
                return GeneralUtils.supplyWorkspaceFile(tmp, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(tmp.getName()));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error(e.toString(), e);
                return Fetched.redirect((Call)routes.Fetched.index()).flashing("HTMLerror", Utils.getLocalizedMessage(e, messages));
            }
        }, this.executionContext.current());
    }

    public Result getZipFile(Http.Request request) {
        String idsString = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        TreeMap<File, String> list = new TreeMap<File, String>();
        for (int i : GeneralUtils.getSelectionIds(idsString)) {
            Fetch f = Fetch.findByIdAndUser((int)i, (User)user);
            if (f == null) continue;
            File file2 = WorkspaceFileSystem.getFile((WorkspaceFile)f.getFile());
            Object name = file2.getName();
            if (this.isZip(f)) {
                name = (String)name + ".zip";
            }
            list.put(file2, (String)name);
        }
        if (list.isEmpty()) {
            return Fetched.redirect((Call)routes.Fetched.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("fetched.error.noFilesToZip", new Object[0]));
        }
        try {
            return GeneralUtils.supplyZipFile(list, false, false).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("fetchedFiles.zip"));
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to create zip download to fetched orders!", e);
            return Fetched.redirect((Call)routes.Fetched.index()).flashing("HTMLerror", Utils.getLocalizedMessage(e, messages));
        }
    }

    public Result delete(Http.Request request) {
        return this.deleteFetchedFiles(request, null);
    }

    public Result deleteFetchedFile(Http.Request request, Integer id) {
        return this.deleteFetchedFiles(request, id);
    }

    public Result deleteFetchedFiles(Http.Request request, Integer id) {
        String idsString = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        int countSuccess = 0;
        int countFailed = 0;
        for (int i : GeneralUtils.getSelectionIds(idsString)) {
            Fetch f = Fetch.findByIdAndUser((int)i, (User)user);
            if (this.deleteWithFile(f)) {
                ++countSuccess;
                continue;
            }
            ++countFailed;
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (countSuccess > 0) {
            flashMap.put("success", messages.at("fetched.success.deleted", new Object[]{countSuccess}));
        }
        if (countFailed > 0) {
            flashMap.put("warning", messages.at("pdfstatements.error.cannotDelete", new Object[]{countFailed}));
        }
        return Fetched.redirect((Call)routes.Fetched.index()).flashing(flashMap);
    }

    private boolean deleteWithFile(Fetch f) {
        if (f != null) {
            WorkspaceFileSystem.delete((WorkspaceFile)f.getFile());
            DB.delete((Object)f);
            return true;
        }
        return false;
    }

    public Result fetchFileForm(Http.Request request) {
        FetchFileForm data = new FetchFileForm();
        if (!new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, User.getUser((String)((String)request.attrs().get(Security.USERNAME)))).getBoolean((DatabasePreferenceConstant)PreferenceConstants.PRESELECT_FROM_TO_FETCH)) {
            data.fromToFetch = false;
        }
        return Fetched.ok((Content)fetchfile.render((Form<FetchFileForm>)this.formFactory.form(FetchFileForm.class).fill((Object)data), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> fetchFile(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form form = this.formFactory.form(FetchFileForm.class).bindFromRequest(request, new String[0]);
        return CompletableFuture.supplyAsync(() -> {
            if (form.hasErrors()) {
                return Fetched.ok((Content)fetchfile.render((Form<FetchFileForm>)form, request, messages));
            }
            FetchFileForm data = (FetchFileForm)form.get();
            Form<FetchFileForm> validatedForm = data.validate((Form<FetchFileForm>)form, user);
            if (validatedForm.hasErrors()) {
                return Fetched.ok((Content)fetchfile.render(validatedForm, request, messages));
            }
            BankSettings bank = BankSettings.getByIdAndUser((Integer)data.bankId, (User)user);
            BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
            HashMap<String, String> flashMap = new HashMap<String, String>();
            try {
                EbicsWorker worker = EbicsUtil.getEbicsWorker(data.getBankUser());
                YYMMDD from = data.fromDate == null ? null : new YYMMDD(data.fromDate.getTime());
                YYMMDD to = data.toDate == null ? null : new YYMMDD(data.toDate.getTime());
                Fetch f = FetchScheduler.fetchFileFromBank((BankUser)bankUser, (EbicsWorker)worker, (String)data.orderOrFileType, (YYMMDD)from, (YYMMDD)to);
                new Thread(null, () -> FetchScheduler.doPostProcessing((Fetch)f, null, (User)user), "Post-Processing-" + f.getOrderType()).start();
                flashMap.put("success", messages.at("fetched.fetch.fetched", new Object[]{data.orderOrFileType, bank.getDisplayName()}));
            }
            catch (NoDownloadDataAvailableException noData) {
                flashMap.put("info", messages.at("fetched.fetch.noData", new Object[]{data.orderOrFileType, bank.getDisplayName()}));
                BLLoggerPlay.info("No data for orderType " + data.orderOrFileType);
            }
            catch (Exception e) {
                flashMap.put("HTMLerror", BankingApiMessages.getErrorMessageWeb((Exception)e, (Locale)messages.lang().locale()));
                if (e instanceof EbicsException) {
                    BLLoggerPlay.error(e.toString());
                }
                BLLoggerPlay.error(e.toString(), e);
            }
            return Fetched.redirect((Call)routes.Fetched.index()).flashing(flashMap);
        }, this.executionContext.current());
    }

    public Result restartPostProcessing(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        Form form = this.formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
        if (form.hasErrors()) {
            return Fetched.redirect((Call)routes.Fetched.index()).flashing("error", messages.at("general.formerror", new Object[0]));
        }
        String idsString = ((SimpleTextForm)form.get()).text;
        List<Integer> fetchIds = GeneralUtils.getSelectionIds(idsString);
        List selectedFetchItems = fetchIds.stream().map(id -> Fetch.findByIdAndUser((int)id, (User)user)).filter(Objects::nonNull).collect(Collectors.toList());
        if (selectedFetchItems.isEmpty()) {
            return Fetched.redirect((Call)routes.Fetched.index()).flashing("error", messages.at("fetched.error.noSuchFile", new Object[0]));
        }
        for (Fetch fetchItem : selectedFetchItems) {
            new Thread(null, () -> FetchScheduler.doPostProcessing((Fetch)fetchItem, null, (User)user), "Post-Processing-" + fetchItem.getOrderType()).start();
        }
        return Fetched.redirect((Call)routes.Fetched.index()).flashing("success", messages.at("fetched.postprocessing.restarted", new Object[]{selectedFetchItems.size()}));
    }
}

