/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.Banks;
import controllers.ClusterFetchScheduler;
import controllers.DatabaseConnection;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import controllers.util.FileExportPostProcessing;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.SimpleTextFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.AdvicePreScheduler;
import de.businesslogics.banking.mt940.api.BkaPreScheduler;
import de.businesslogics.banking.mt940.api.BkiPreScheduler;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.DtiPreScheduler;
import de.businesslogics.banking.mt940.api.StatementsPreScheduler;
import de.businesslogics.banking.sepa.api.SepaNotificationPreScheduler;
import de.businesslogics.banking.transfer.api.CustomerProtocolPreScheduler;
import de.businesslogics.banking.transfer.api.FetchScheduler;
import de.businesslogics.banking.transfer.api.HVZPreScheduler;
import de.businesslogics.banking.transfer.api.NotificationSettings;
import de.businesslogics.banking.transfer.api.PreScheduler;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.BLLogger;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.CreateMissingSchedulesForm;
import models.SchedulerForm;
import models.SimpleTextForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.libs.ws.WSClient;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.banks.createMissingSchedules;
import views.html.settings.editfetchschedule;
import views.html.settings.fetchschedule;
import views.html.settings.newfetchschedule;

@Security.Authenticated(value=AuthenticatorFor.Settings.class)
public final class FetchSchedule
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClusterFetchScheduler clusterFetchScheduler;
    private final ClassLoaderExecutionContext executionContext;

    public static Seq<Tuple2<String, String>> getSchedulers(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (SchedulerType scheduler : SchedulerType.values()) {
            if (SchedulerType.BKA.equals((Object)scheduler) && Branding.getBranding().hidePDFStatements() || SchedulerType.HVZ.equals((Object)scheduler) && !HVZPreScheduler.canUseHVZPreScheduler()) continue;
            if (scheduler.getId().equals(SchedulerType.FREE.getId())) {
                result.add(Scala.Tuple((Object)"OPTION_DIVIDER", (Object)""));
            }
            result.add(Scala.Tuple((Object)scheduler.getId(), (Object)scheduler.getLabel(messages)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getRepeatOptions(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)String.valueOf(true), (Object)messages.at("fetchschedule.onceADay", new Object[0])));
        result.add(Scala.Tuple((Object)String.valueOf(false), (Object)messages.at("fetchschedule.interval", new Object[0])));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getExecutionTypeOptions(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)String.valueOf(0), (Object)messages.at("fetchschedule.weekdays", new Object[0])));
        result.add(Scala.Tuple((Object)String.valueOf(1), (Object)messages.at("fetchschedule.calendardays", new Object[0])));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getIntervals(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)String.valueOf(5), (Object)messages.at("fetchschedule.intervalMinutes", new Object[]{5})));
        result.add(Scala.Tuple((Object)String.valueOf(15), (Object)messages.at("fetchschedule.intervalMinutes", new Object[]{15})));
        result.add(Scala.Tuple((Object)String.valueOf(30), (Object)messages.at("fetchschedule.intervalMinutes", new Object[]{30})));
        result.add(Scala.Tuple((Object)String.valueOf(60), (Object)messages.at("fetchschedule.intervalHours", new Object[]{1})));
        return Scala.toSeq(result);
    }

    public static String getOrderTypesString(Scheduler scheduler) {
        return String.join((CharSequence)",", FetchScheduler.getOrderTypes((Scheduler)scheduler));
    }

    public static Date nextFetchForSchedule(Date nextFetch) {
        if (nextFetch == null || nextFetch.getTime() == 0L) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(nextFetch);
        c.add(13, 30);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static boolean hasMissingSchedules(User user, Tenant tenant) {
        if (user.isAdminOrTenantAdmin()) {
            Integer tenantId = null;
            if (tenant != null) {
                tenantId = tenant.getId();
            }
            return !FetchSchedule.getMissingSchedulesForAdminOrTenantAdmin(user, tenantId).isEmpty();
        }
        return !FetchSchedule.getMissingSchedulesForUser(user).isEmpty();
    }

    public static boolean hasMissingSchedulesOfType(User user, Collection<SchedulerType> types) {
        Map<BankSettings, List<MissingSchedulerDetails>> result = user.isAdminOrTenantAdmin() ? FetchSchedule.getMissingSchedulesForAdminOrTenantAdmin(user, null) : FetchSchedule.getMissingSchedulesForUser(user);
        return result.values().stream().map(list -> list.stream().map(msd -> msd.schedulerType).filter(types::contains).count()).anyMatch(x -> x > 0L);
    }

    public static Map<BankSettings, List<MissingSchedulerDetails>> getMissingSchedulesForUser(User user) {
        return FetchSchedule.getMissingSchedules(user, null, null);
    }

    public static Map<BankSettings, List<MissingSchedulerDetails>> getMissingSchedulesForAdminOrTenantAdmin(User adminOrTenantAdmin, Integer onlyForTenantWithId) {
        List<Tenant> tenantsToInclude = onlyForTenantWithId != null ? Collections.singletonList(Tenant.findById((int)onlyForTenantWithId, (User)adminOrTenantAdmin, (boolean)true)) : adminOrTenantAdmin.getManageableTenants();
        List<Integer> bankIds = BankSettings.findBanksForTenants((List)tenantsToInclude).stream().map(BankSettings::getBankId).collect(Collectors.toList());
        return FetchSchedule.getMissingSchedules(null, bankIds, null);
    }

    public static Map<BankSettings, List<MissingSchedulerDetails>> getMissingSchedules(User user, List<Integer> bankIds, Integer onlyForTenantWithId) {
        ExpressionList bankUsersQuery = DB.find(BankUser.class).where().eq("deactivated", (Object)false).eq("state", (Object)BankUser.UserState.READY);
        if (user != null) {
            bankUsersQuery = bankUsersQuery.eq("user", (Object)user);
        }
        if (bankIds != null && !bankIds.isEmpty()) {
            bankUsersQuery = bankUsersQuery.in("bank_id", bankIds);
        }
        if (onlyForTenantWithId != null) {
            Tenant tenant = Tenant.findById((int)onlyForTenantWithId);
            if (tenant == null) {
                throw new RuntimeException("Failed to load missing schedules for tenant with id " + onlyForTenantWithId + ": tenant not found!");
            }
            bankUsersQuery = bankUsersQuery.eq("bank.tenant", (Object)tenant);
        }
        List activeReadyBankUsers = bankUsersQuery.findList();
        HashMap<BankSettings, List<MissingSchedulerDetails>> missingSchedulerTypesPerBank = new HashMap<BankSettings, List<MissingSchedulerDetails>>();
        for (BankUser bankUser : activeReadyBankUsers) {
            if (BankUserHtdInfo.findForBankUser((BankUser)bankUser) == null) continue;
            BankSettings bank = bankUser.getBank();
            List<MissingSchedulerDetails> schedulersToCreate = FetchSchedule.getDefaultSchedulers(bankUser);
            schedulersToCreate = schedulersToCreate.stream().filter(s -> !FetchSchedule.schedulerOfTypeExists(bankUser.getBank(), s)).collect(Collectors.toList());
            schedulersToCreate = schedulersToCreate.stream().filter(s -> s.getOrderOrFileTypes().stream().map(o -> Util.hasFetchPermission((BankUser)bankUser, (String)o)).reduce((p1, p2) -> p1 != false || p2 != false).orElse(false)).collect(Collectors.toList());
            if (missingSchedulerTypesPerBank.containsKey(bank)) {
                schedulersToCreate = schedulersToCreate.stream().filter(m -> !((List)missingSchedulerTypesPerBank.get(bank)).stream().map(MissingSchedulerDetails::getSchedulerType).collect(Collectors.toSet()).contains((Object)m.schedulerType)).collect(Collectors.toList());
            }
            if (schedulersToCreate.isEmpty()) continue;
            if (!missingSchedulerTypesPerBank.containsKey(bank)) {
                missingSchedulerTypesPerBank.put(bank, new ArrayList());
            }
            ((List)missingSchedulerTypesPerBank.get(bank)).addAll(schedulersToCreate);
        }
        return missingSchedulerTypesPerBank;
    }

    public static boolean schedulerOfTypeExists(BankSettings forBank, MissingSchedulerDetails missingSchedulerDetails) {
        return FetchSchedule.schedulerOfTypeExists(forBank, missingSchedulerDetails.getSchedulerType(), missingSchedulerDetails.getOrderOrFileTypes());
    }

    public static boolean schedulerOfTypeExists(BankSettings forBank, SchedulerType schedulerType, Collection<String> orderOrFileTypes) {
        return DB.find(Scheduler.class).where().eq("bank", (Object)forBank).or(Expr.eq((String)"orderOrFileType", (Object)schedulerType.schedulerClass.getName()), Expr.in((String)"orderOrFileType", orderOrFileTypes)).findCount() > 0;
    }

    private static List<MissingSchedulerDetails> getDefaultSchedulers(BankUser bankUser) {
        BankSettings bank = bankUser.getBank();
        CMBank cmBank = CMBank.get((BankSettings)bank);
        NotificationSettings notificationsHandler = NotificationSettings.getForBank((BankSettings)bank);
        ArrayList<MissingSchedulerDetails> toReturn = new ArrayList<MissingSchedulerDetails>();
        HashSet<String> advicesOrderTypes = new HashSet<String>();
        if (cmBank.isAdviceFetchActivated()) {
            advicesOrderTypes.add(cmBank.getAdviceFetchType());
        }
        if (cmBank.isCreditAdviceFetchActivated()) {
            advicesOrderTypes.add(cmBank.getCreditAdviceFetchType());
        }
        if (!advicesOrderTypes.isEmpty()) {
            toReturn.add(new MissingSchedulerDetails(bankUser, SchedulerType.ADVICES, advicesOrderTypes));
        }
        HashSet<String> statementsOrderTypes = new HashSet<String>();
        if (cmBank.isStatementFetchActivated()) {
            statementsOrderTypes.add(cmBank.getStatementFetchType());
        }
        if (!statementsOrderTypes.isEmpty()) {
            toReturn.add(new MissingSchedulerDetails(bankUser, SchedulerType.STATEMENTS, statementsOrderTypes));
        }
        HashSet<String> dtiOrderTypes = new HashSet<String>();
        if (cmBank.isC54FetchActivated()) {
            dtiOrderTypes.add(cmBank.getC54FetchType());
        }
        if (!dtiOrderTypes.isEmpty()) {
            toReturn.add(new MissingSchedulerDetails(bankUser, SchedulerType.DTI, dtiOrderTypes));
        }
        HashSet<String> notificationsOrderTypes = new HashSet<String>();
        if (notificationsHandler.fetchCreditNotifications()) {
            notificationsOrderTypes.add(notificationsHandler.getFetchTypeForCreditNotifications());
        }
        if (notificationsHandler.fetchInstantNotifications()) {
            notificationsOrderTypes.add(notificationsHandler.getFetchTypeForInstantNotifications());
        }
        if (notificationsHandler.fetchDebitNotifications()) {
            notificationsOrderTypes.add(notificationsHandler.getFetchTypeForDebitNotifications());
        }
        if (notificationsHandler.fetchCallbackNotifications()) {
            notificationsOrderTypes.add(notificationsHandler.getFetchTypeForCallbackNotifications());
        }
        if (notificationsHandler.fetchForeignNotifications()) {
            notificationsOrderTypes.add(notificationsHandler.getFetchTypeForForeignNotifications());
        }
        if (!notificationsOrderTypes.isEmpty()) {
            toReturn.add(new MissingSchedulerDetails(bankUser, SchedulerType.SEPANOTIFICATIONS, notificationsOrderTypes));
        }
        HashSet<String> bkaOrderTypes = new HashSet<String>();
        if (cmBank.isBkaFetchActivated()) {
            bkaOrderTypes.add(cmBank.getBkaFetchType());
        }
        if (!bkaOrderTypes.isEmpty()) {
            toReturn.add(new MissingSchedulerDetails(bankUser, SchedulerType.BKA, bkaOrderTypes));
        }
        HashSet<String> bkiOrderTypes = new HashSet<String>();
        if (cmBank.isBkiFetchActivated()) {
            bkiOrderTypes.add(cmBank.getBkiFetchType());
        }
        if (!bkiOrderTypes.isEmpty()) {
            toReturn.add(new MissingSchedulerDetails(bankUser, SchedulerType.BKI, bkiOrderTypes));
        }
        return toReturn;
    }

    private void createDefaultSchedulerForSchedulerTypeId(User operator, BankUser bankUser, String schedulerTypeId, String frequencyType) {
        CreateMissingSchedulesForm.Frequency frequency;
        SchedulerType type = SchedulerType.getById(schedulerTypeId);
        if (type == null) {
            throw new RuntimeException("Unknown scheduler type id '" + schedulerTypeId + "'!");
        }
        try {
            frequency = CreateMissingSchedulesForm.Frequency.valueOf(frequencyType);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unknown scheduler frequency type '" + frequencyType + "'!", e);
        }
        Scheduler scheduler = new Scheduler();
        scheduler.setBank(bankUser.getBank());
        scheduler.setLoginUser(bankUser.getUser());
        scheduler.setOrderOrFileType(type.getClassName());
        switch (frequency) {
            case FREQUENCY_HOURLY: {
                scheduler.setYear("-");
                scheduler.setDays("2-6");
                scheduler.setHour("6-17");
                scheduler.setInterval(Scheduler.Interval.HOURLY);
                break;
            }
            case FREQUENCY_DAILY: {
                scheduler.setYear("-");
                scheduler.setDays("2-6");
                scheduler.setHour("6");
                scheduler.setMinute("00");
                scheduler.setInterval(Scheduler.Interval.NONE);
                break;
            }
            case FREQUENCY_MONTHLY: {
                scheduler.setYear("-");
                scheduler.setMonth("0-11");
                scheduler.setDays("1");
                scheduler.setHour("6");
                scheduler.setMinute("00");
                scheduler.setInterval(Scheduler.Interval.NONE);
            }
        }
        scheduler.save();
        BLLoggerPlay.info("Created the default '" + schedulerTypeId + "' fetch schedule for bank user '" + bankUser.getDefaultUser() + "' and bank id " + bankUser.getBank().getBankId() + ".");
        new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logSchedulerCreated(operator, scheduler);
        this.clusterFetchScheduler.updateScheduler(scheduler);
    }

    @Inject
    public FetchSchedule(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext, WSClient wsClient) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
        this.clusterFetchScheduler = new ClusterFetchScheduler(wsClient);
    }

    public Result index(Http.Request request) {
        List<Scheduler> list;
        Map<Scheduler, Date> nextScheduleMap;
        String filterText;
        Query query;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sort = new SortingHandler(user, Sorting.Table.SCHEDULER);
        if (user.isAdmin()) {
            query = Scheduler.queryAll();
        } else if (user.isTenantAdmin()) {
            Expression ex = Expr.in((String)"bank.users.user", (Object[])new Object[]{user});
            Expression ex2 = Expr.eq((String)"bank.tenant.managingUsers", (Object)user);
            query = DB.find(Scheduler.class).where().or(ex, ex2).query();
        } else {
            query = Scheduler.findForBanksOfUser((User)user);
        }
        Tenant tenant = null;
        try {
            int tenantId = Integer.parseInt(sort.getProperty("TENANT", "-1"));
            if (tenantId > 0 && (tenant = Tenant.findById((int)tenantId, (User)user, (boolean)true)) != null) {
                query.where().eq("bank.tenant", (Object)tenant);
            }
        }
        catch (NumberFormatException tenantId) {
            // empty catch block
        }
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.SCHEDULER);
        Form filterForm = this.formFactory.form(SimpleTextForm.class).fill((Object)new SimpleTextForm(filter.getFilterText()));
        String string = filterText = filter.isFilterActive() ? filter.getFilterText() : null;
        if (filter.isFilterActive()) {
            query.where().add(Scheduler.getFilterExpression((String)filter.getFilterText()));
        }
        sort.computeForQuery(query);
        if (sort.getSortingColumn() == 5) {
            List tmp = query.findList();
            nextScheduleMap = this.clusterFetchScheduler.buildNextScheduleMap(tmp);
            list = this.sortByNextFetch(tmp, nextScheduleMap, sort.isSortingAscending(), sort.getPageNumber(), sort.getPageSize());
        } else {
            Object sortString;
            switch (sort.getSortingColumn()) {
                case 0: {
                    if (sort.isSortingAscending()) {
                        sortString = "bank.displayName asc, orderOrFileType asc";
                        break;
                    }
                    sortString = "bank.displayName desc, orderOrFileType desc";
                    break;
                }
                case 1: {
                    if (sort.isSortingAscending()) {
                        sortString = "interval asc";
                        break;
                    }
                    sortString = "interval desc";
                    break;
                }
                case 3: {
                    if (sort.isSortingAscending()) {
                        sortString = "loginUser.name asc";
                        break;
                    }
                    sortString = "loginUser.name desc";
                    break;
                }
                case 4: {
                    sortString = sort.isSortingAscending() ? "lastFetch asc" : "lastFetch desc";
                    if (!DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType())) break;
                    sortString = (String)sortString + (sort.isSortingAscending() ? " NULLS FIRST" : " NULLS LAST");
                    break;
                }
                case 6: {
                    if (sort.isSortingAscending()) {
                        sortString = "bank.customerId asc";
                        break;
                    }
                    sortString = "bank.customerId desc";
                    break;
                }
                case 7: {
                    if (sort.isSortingAscending()) {
                        sortString = "bank.tenant.name asc";
                        break;
                    }
                    sortString = "bank.tenant.name desc";
                    break;
                }
                default: {
                    sortString = null;
                }
            }
            if (sortString != null) {
                query.order((String)sortString);
            }
            try {
                list = query.findList();
            }
            catch (PersistenceException e) {
                return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.SCHEDULER, (Call)routes.FetchSchedule.index());
            }
            nextScheduleMap = this.clusterFetchScheduler.buildNextScheduleMap(list);
        }
        FetchScheduler.QueueStatistics queueStatistics = null;
        if (user.isAdmin()) {
            queueStatistics = this.clusterFetchScheduler.getFetchSchedulerQueueStatistics();
        }
        return FetchSchedule.ok((Content)fetchschedule.render(list, nextScheduleMap, sort, tenant, (Form<SimpleTextForm>)filterForm, filterText, queueStatistics, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private List<Scheduler> sortByNextFetch(List<Scheduler> list, Map<Scheduler, Date> map, boolean asc, int page, int pageSize) {
        Comparator<Scheduler> comp = Comparator.comparing(scheduler -> {
            Date d = (Date)map.get(scheduler);
            return Objects.requireNonNullElseGet(d, () -> new Date(0L));
        });
        if (asc) {
            list.sort(comp);
        } else {
            list.sort(comp.reversed());
        }
        if (list.size() > pageSize) {
            int startIndex = page * pageSize;
            return list.subList(startIndex, Math.min(startIndex + pageSize, list.size()));
        }
        return list;
    }

    public Result indexSort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.SCHEDULER).updateSort(sort, asc);
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index());
    }

    public Result index_tenant(Http.Request request, int tenantId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.SCHEDULER).setProperty("TENANT", tenantId > 0 ? String.valueOf(tenantId) : null);
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index());
    }

    public Result indexPageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.SCHEDULER).updatePage(page, pageSize);
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index());
    }

    public Result newSchedulerForm(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SchedulerForm schedulerForm = new SchedulerForm();
        schedulerForm.loadDefaults(user);
        return FetchSchedule.ok((Content)newfetchschedule.render((Form<SchedulerForm>)this.formFactory.form(SchedulerForm.class).fill((Object)schedulerForm), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result newScheduler(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Scheduler scheduler = new Scheduler();
        Form<SchedulerForm> form = this.formFactory.form(SchedulerForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            form = ((SchedulerForm)form.get()).validate(form, scheduler, messages);
        }
        if (form.hasErrors()) {
            return FetchSchedule.ok((Content)newfetchschedule.render(form, request, messages));
        }
        scheduler.save();
        new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logSchedulerCreated(operator, scheduler);
        HashMap<String, String> flashMap = new HashMap<String, String>();
        this.checkScheduler(scheduler, flashMap, messages, operator);
        if (!Utils.hasErrorFlash(flashMap)) {
            flashMap.put("success", messages.at("fetchschedule.created", new Object[0]));
        }
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing(flashMap);
    }

    public Result edit(Http.Request request, int schedulerId) {
        return this.editFetchSchedule(request, schedulerId, false);
    }

    public Result editMode(Http.Request request, int schedulerId) {
        return this.editFetchSchedule(request, schedulerId, true);
    }

    public Result editFetchSchedule(Http.Request request, int schedulerId, boolean inEditMode) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Scheduler scheduler = Scheduler.findById((int)schedulerId);
        if (scheduler == null) {
            return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("warning", messages.at("fetchschedule.notfound", new Object[0]));
        }
        if (!scheduler.canBeEditedBy(user)) {
            return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("warning", messages.at("fetchschedule.nopermission", new Object[0]));
        }
        return FetchSchedule.ok((Content)editfetchschedule.render((Form<SchedulerForm>)this.formFactory.form(SchedulerForm.class).fill((Object)new SchedulerForm(user, scheduler)), schedulerId, inEditMode, request, messages));
    }

    public Result update(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Scheduler scheduler = (Scheduler)DB.find(Scheduler.class, (Object)id);
        if (scheduler == null) {
            return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("error", messages.at("fetchschedule.notfound", new Object[0]));
        }
        BankUser oldBankUser = scheduler.getBankUser();
        Form<SchedulerForm> form = this.formFactory.form(SchedulerForm.class).bindFromRequest(request, new String[0]);
        if (!form.hasErrors()) {
            form = ((SchedulerForm)form.get()).validate(form, scheduler, messages);
        }
        if (form.hasErrors()) {
            return FetchSchedule.ok((Content)editfetchschedule.render(form, id, true, request, messages));
        }
        scheduler.save();
        HashMap<String, String> flashMap = new HashMap<String, String>();
        this.checkScheduler(scheduler, flashMap, messages, operator);
        if (!Utils.hasErrorFlash(flashMap)) {
            boolean bankUserChanged;
            Utils.addToFlash(flashMap, "success", messages.at("fetchschedule.updated", new Object[0]));
            BankUser newBankUser = scheduler.getBankUser();
            boolean bl = bankUserChanged = !Objects.equals(oldBankUser, newBankUser);
            if (bankUserChanged) {
                new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logSchedulerChangedBankUser(operator, scheduler, oldBankUser == null ? null : oldBankUser.getUser(), newBankUser == null ? null : newBankUser.getUser());
            }
        }
        return FetchSchedule.redirect((Call)routes.FetchSchedule.edit(id)).flashing(flashMap);
    }

    public Result delete(Http.Request request) {
        return this.deleteSchedules(request, null);
    }

    public Result deleteSchedule(Http.Request request, Integer id) {
        return this.deleteSchedules(request, id);
    }

    public Result deleteSchedules(Http.Request request, Integer id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String idsString = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        int countSuccess = 0;
        int countFailed = 0;
        ArrayList<Scheduler> idsToRemove = new ArrayList<Scheduler>();
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        for (int i : GeneralUtils.getSelectionIds(idsString)) {
            Scheduler scheduler = Scheduler.findById((int)i);
            if (scheduler == null) continue;
            if (scheduler.canBeEditedBy(user)) {
                idsToRemove.add(scheduler);
                logger.logSchedulerDeleted(user, scheduler);
                ++countSuccess;
                continue;
            }
            ++countFailed;
        }
        if (!idsToRemove.isEmpty()) {
            this.clusterFetchScheduler.remove(idsToRemove);
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (countSuccess > 0) {
            flashMap.put("success", messages.at("fetchschedule.success.deleted", new Object[]{countSuccess}));
        }
        if (countFailed > 0) {
            flashMap.put("warning", messages.at("fetchschedule.error.cannotDelete", new Object[]{countFailed}));
        }
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing(flashMap);
    }

    public CompletionStage<Result> fetch(Http.Request request) {
        return this.fetchSchedules(request, null);
    }

    public CompletionStage<Result> fetchSchedule(Http.Request request, Integer id) {
        return this.fetchSchedules(request, id);
    }

    public CompletionStage<Result> fetchSchedules(Http.Request request, Integer id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String idsString = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        return CompletableFuture.supplyAsync(() -> {
            List<Integer> ids = GeneralUtils.getSelectionIds(idsString);
            Map<String, String> flashMap = this.clusterFetchScheduler.fetchNow(ids, messages);
            if (id != null) {
                return FetchSchedule.redirect((Call)routes.FetchSchedule.edit(id)).flashing(flashMap);
            }
            return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing(flashMap);
        }, this.executionContext.current());
    }

    public Result reschedule(Http.Request request, int schedulerId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Scheduler scheduler = Scheduler.findById((int)schedulerId);
        if (scheduler == null) {
            return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("warning", messages.at("fetchschedule.notfound", new Object[0]));
        }
        if (!scheduler.canBeEditedBy(operator)) {
            return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("warning", messages.at("fetchschedule.nopermission", new Object[0]));
        }
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (FetchScheduler.assignActiveBankUser((Scheduler)scheduler) == null) {
            flashMap.put("error", messages.at("fetchschedule.fetchfailed", new Object[]{messages.at("fetchschedule.warning.notFetched.noUser", new Object[0])}));
        } else {
            this.checkScheduler(scheduler, flashMap, messages, operator);
            if (!Utils.hasErrorFlash(flashMap)) {
                flashMap.put("success", messages.at("fetchschedule.rescheduled", new Object[0]));
            }
        }
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing(flashMap);
    }

    public Result getExampleExportDir(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return FetchSchedule.badRequest((String)"noPattern");
        }
        try {
            return FetchSchedule.ok((String)FileExportPostProcessing.getExample().substitute(pattern));
        }
        catch (Exception e) {
            return FetchSchedule.badRequest((String)"incorrectPattern");
        }
    }

    public Result index_filter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SimpleTextFilter filter = SimpleTextFilter.getFilter((User)user, (SimpleTextFilter.View)SimpleTextFilter.View.SCHEDULER);
        if (active) {
            Form filterForm = this.formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
            String filterText = ((SimpleTextForm)filterForm.get()).text;
            if (filterText != null && !filterText.isEmpty()) {
                filter.setFilterText(filterText);
                filter.setFilterActive(true);
            } else {
                filter.setFilterText(null);
                filter.setFilterActive(false);
            }
        } else {
            filter.setFilterActive(false);
        }
        filter.save();
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index());
    }

    public Result resetSchedulers(Http.Request request) {
        HashMap<String, String> flashMap = new HashMap<String, String>(1);
        try {
            FetchScheduler.reset();
            flashMap.put("success", "fetchschedule.reset.done");
        }
        catch (InterruptedException e) {
            BLLoggerPlay.error("Failed to reset schedulers!", e);
            flashMap.put("error", this.messagesApi.preferred((Http.RequestHeader)request).at("fetchschedule.reset.error", new Object[0]));
        }
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing(flashMap);
    }

    public Result adjustAssignedUsers(Http.Request request, Integer tenantId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User operator = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        HashMap<String, String> flashMap = new HashMap<String, String>();
        if (operator.isAdminOrTenantAdmin()) {
            try {
                int nChanged = this.adjustUsers(operator, tenantId);
                String flashKey = nChanged == 0 ? "info" : "success";
                flashMap.put(flashKey, messages.at("fetchschedule.adjustUsers.done.success", new Object[]{nChanged}));
            }
            catch (Exception e) {
                BLLoggerPlay.error("Failed to adjust assigned users for schedulers!", e);
                flashMap.put("error", messages.at("fetchschedule.adjustUsers.done.error", new Object[0]));
            }
        } else {
            flashMap.put("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
        }
        return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing(flashMap);
    }

    private int adjustUsers(User adminUser, Integer tenantId) {
        List schedulersToCheck;
        if (tenantId == null) {
            schedulersToCheck = adminUser.isAdmin() ? Scheduler.findAll() : Scheduler.findForManagedTenants((User)adminUser).findList();
        } else {
            Tenant tenant = Tenant.findById((int)tenantId, (User)adminUser, (boolean)true);
            if (tenant == null) {
                return 0;
            }
            schedulersToCheck = DB.find(Scheduler.class).where().eq("bank.tenant", (Object)tenant).findList();
        }
        ArrayList<Scheduler> schedulersToAdjust = new ArrayList<Scheduler>();
        for (Scheduler scheduler : schedulersToCheck) {
            User assigneduser = scheduler.getLoginUser();
            if (assigneduser == null) continue;
            BankSettings bank = scheduler.getBank();
            BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)assigneduser);
            if (bankUser == null) {
                schedulersToAdjust.add(scheduler);
                continue;
            }
            if (bankUser.isDeactivated()) {
                schedulersToAdjust.add(scheduler);
                continue;
            }
            try {
                Future<Boolean> future = Banks.updateHTD(bankUser, null);
                future.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!BankUtils.isReady((BankUser)bankUser)) {
                schedulersToAdjust.add(scheduler);
                continue;
            }
            if (!FetchScheduler.getOrderTypes((Scheduler)scheduler).stream().noneMatch(t -> Util.hasFetchPermission((BankUser)bankUser, (String)t))) continue;
            schedulersToAdjust.add(scheduler);
        }
        for (Scheduler toAdjust : schedulersToAdjust) {
            toAdjust.setLoginUser(null);
            toAdjust.save();
            FetchScheduler.assignActiveBankUser((Scheduler)toAdjust);
        }
        return schedulersToAdjust.size();
    }

    private void checkScheduler(Scheduler scheduler, Map<String, String> flashMap, Messages messages, User operator) {
        try {
            if (scheduler.getBankUser() != null) {
                EbicsUtil.getEbicsWorker(scheduler.getBankUser());
            }
            this.clusterFetchScheduler.updateScheduler(scheduler);
        }
        catch (IOException | GeneralSecurityException e) {
            flashMap.put("HTMLerror", messages.at("fetchschedule.fetchfailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            BLLoggerPlay.error("Failed to create new fetch schedule entry.", e);
            return;
        }
        if (scheduler.getLoginUser() != null) {
            boolean scheduleIsAssignedToLoggedInUser = operator.equals(scheduler.getLoginUser());
            for (String orderOrFileType : FetchScheduler.getOrderTypes((Scheduler)scheduler)) {
                if (Util.hasFetchPermission((BankUser)scheduler.getBankUser(), (String)orderOrFileType)) continue;
                if (scheduleIsAssignedToLoggedInUser) {
                    Utils.addToFlash(flashMap, "warning", messages.at("fetchschedule.warning.noOrderTypePermission", new Object[]{orderOrFileType}));
                    continue;
                }
                Utils.addToFlash(flashMap, "warning", messages.at("fetchschedule.warning.noOrderTypePermissionForUser", new Object[]{orderOrFileType, scheduler.getLoginUser().getName()}));
            }
        }
    }

    public Result createMissingSchedulesPage(Http.Request request, String bankIds, Integer tenantId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List<Integer> bankIdList = GeneralUtils.getSelectionIds(bankIds);
        String referer = Utils.getHeaderValue(request, "referer");
        try {
            Map<BankSettings, List<MissingSchedulerDetails>> missingSchedulerTypesPerBank = user.isAdminOrTenantAdmin() && bankIdList.isEmpty() ? FetchSchedule.getMissingSchedulesForAdminOrTenantAdmin(user, tenantId) : FetchSchedule.getMissingSchedules(user, bankIdList, tenantId);
            if (missingSchedulerTypesPerBank.isEmpty()) {
                if (tenantId != null) {
                    Tenant tenant = Tenant.findById((int)tenantId);
                    String tenantName = tenant == null ? tenantId.toString() : tenant.getName();
                    return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("info", messages.at("fetchschedule.createMissing.noneMissingForTenant", new Object[]{user.getName(), tenantName}));
                }
                return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("info", messages.at("fetchschedule.createMissing.noneMissing", new Object[]{user.getName()}));
            }
            CreateMissingSchedulesForm f = new CreateMissingSchedulesForm();
            for (Map.Entry<BankSettings, List<MissingSchedulerDetails>> missingSchedulerEntry : missingSchedulerTypesPerBank.entrySet()) {
                for (MissingSchedulerDetails missingScheduler : missingSchedulerEntry.getValue()) {
                    BankSettings bank = missingSchedulerEntry.getKey();
                    SchedulerType schedulerType = missingScheduler.getSchedulerType();
                    CreateMissingSchedulesForm.Frequency frequencyType = CreateMissingSchedulesForm.getDefaultFrequencyForSchedulerType(schedulerType);
                    CreateMissingSchedulesForm.ScheduleParameters params = new CreateMissingSchedulesForm.ScheduleParameters(true, frequencyType.name());
                    f.selectedSchedules.put(bank.getBankId() + "_" + schedulerType.getId(), params);
                }
            }
            Form form = this.formFactory.form(CreateMissingSchedulesForm.class).fill((Object)f);
            play.api.mvc.Call redirectTo = referer != null && referer.contains("/banks") ? routes.Banks.index() : routes.FetchSchedule.index();
            return FetchSchedule.ok((Content)createMissingSchedules.render(missingSchedulerTypesPerBank, (Form<CreateMissingSchedulesForm>)form, (Call)redirectTo, request, this.messagesApi.preferred((Http.RequestHeader)request)));
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to load the page for the creation of missing schedulers!", e);
            return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("HTMLerror", messages.at("fetchschedule.createMissing.error", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
    }

    public CompletionStage<Result> createMissingSchedules(Http.Request request) {
        Form form = this.formFactory.form(CreateMissingSchedulesForm.class).bindFromRequest(request, new String[0]);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            try {
                Map<BankSettings, List<MissingSchedulerDetails>> missingSchedulerTypesPerBank = user.isAdminOrTenantAdmin() ? FetchSchedule.getMissingSchedulesForAdminOrTenantAdmin(user, null) : FetchSchedule.getMissingSchedulesForUser(user);
                int numberOfSchedulesCreated = 0;
                HashMap<String, String> flashMap = new HashMap<String, String>();
                for (Map.Entry<BankSettings, List<MissingSchedulerDetails>> missingSchedulerEntry : missingSchedulerTypesPerBank.entrySet()) {
                    for (MissingSchedulerDetails missingSchedulerDetails : missingSchedulerEntry.getValue()) {
                        BankSettings bank = missingSchedulerEntry.getKey();
                        BankUser bankUser = missingSchedulerDetails.getBankUser();
                        String fieldId = bank.getBankId() + "_" + missingSchedulerDetails.getSchedulerType().getId();
                        boolean createScheduler = ((CreateMissingSchedulesForm)form.get()).selectedSchedules.containsKey(fieldId) && ((CreateMissingSchedulesForm)form.get()).selectedSchedules.get((Object)fieldId).selected;
                        if (!createScheduler) continue;
                        try {
                            this.createDefaultSchedulerForSchedulerTypeId(user, bankUser, missingSchedulerDetails.getSchedulerType().getId(), ((CreateMissingSchedulesForm)form.get()).selectedSchedules.get((Object)fieldId).frequency);
                            ++numberOfSchedulesCreated;
                        }
                        catch (Exception e) {
                            Utils.addToFlash(flashMap, "HTMLerror", messages.at("fetchschedule.error.cannotCreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                        }
                    }
                }
                String flashKey = numberOfSchedulesCreated == 0 ? "info" : "success";
                Utils.addToFlash(flashMap, flashKey, messages.at("fetchschedule.created.multi", new Object[]{numberOfSchedulesCreated}));
                return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing(flashMap);
            }
            catch (Exception e) {
                BLLoggerPlay.error("An error occurred while creating missing schedulers!", e);
                return FetchSchedule.redirect((Call)routes.FetchSchedule.index()).flashing("HTMLerror", messages.at("fetchschedule.createMissing.error", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public static enum SchedulerType {
        STATEMENTS("statements", "fetchschedule.statements", StatementsPreScheduler.class),
        ADVICES("advices", "fetchschedule.advice", AdvicePreScheduler.class),
        DTI("dti", "GeneralMessages.batchedTransactionFiles", DtiPreScheduler.class),
        BKA("bka", "GeneralMessages.pdfStatements", BkaPreScheduler.class),
        BKI("bki", "GeneralMessages.otherPdfDocuments", BkiPreScheduler.class),
        PROTOCOL("protocol", "GeneralMessages.customerProtocol", CustomerProtocolPreScheduler.class),
        SEPANOTIFICATIONS("sepanotifications", "fetchschedule.sepanotifications", SepaNotificationPreScheduler.class),
        HVZ("hvz", "fetchschedule.hvz", HVZPreScheduler.class),
        FREE("free", "fetchschedule.free", null);

        private final String id;
        private final String messageKey;
        private final Class<? extends PreScheduler> schedulerClass;

        private SchedulerType(String id, String messageKey, Class<? extends PreScheduler> schedulerClass) {
            this.id = id;
            this.messageKey = messageKey;
            this.schedulerClass = schedulerClass;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel(Messages messages) {
            if (this.messageKey.startsWith("GeneralMessages.")) {
                return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)this.messageKey, (Object[])new Object[0]);
            }
            return messages.at(this.messageKey, new Object[0]);
        }

        public String getClassName() {
            if (this.schedulerClass != null) {
                return this.schedulerClass.getName();
            }
            return "";
        }

        public static SchedulerType getById(String id) {
            for (SchedulerType scheduler : SchedulerType.values()) {
                if (!scheduler.id.equals(id)) continue;
                return scheduler;
            }
            return null;
        }

        public static SchedulerType getByClassname(String className) {
            for (SchedulerType scheduler : SchedulerType.values()) {
                if (!scheduler.getClassName().equals(className)) continue;
                return scheduler;
            }
            return FREE;
        }
    }

    public static class MissingSchedulerDetails {
        private final BankUser bankUser;
        private final SchedulerType schedulerType;
        private final Collection<String> orderOrFileTypes;

        public MissingSchedulerDetails(BankUser bankUser, SchedulerType schedulerType, Collection<String> orderOrFileTypes) {
            this.bankUser = bankUser;
            this.schedulerType = schedulerType;
            this.orderOrFileTypes = orderOrFileTypes;
        }

        public BankUser getBankUser() {
            return this.bankUser;
        }

        public SchedulerType getSchedulerType() {
            return this.schedulerType;
        }

        public Collection<String> getOrderOrFileTypes() {
            return this.orderOrFileTypes;
        }

        public String getOrderOrFileTypesAsString() {
            return String.join((CharSequence)", ", this.orderOrFileTypes);
        }
    }
}

