/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.CheckedState;
import controllers.DatabaseConnection;
import controllers.routes;
import controllers.util.BigDecimalFormatter;
import controllers.util.DateFormatter;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmBookingFilter;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.BookingSQLBuilder;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.persistence.DBType;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import models.BookingFilterForm;
import models.CmDateRangeForm;
import models.CmFolderIdForm;
import models.DeleteForm;
import models.cm.BookingExportForm;
import play.data.Form;
import play.data.FormFactory;
import play.data.format.Formatters;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.html.cm.dti;

@Security.Authenticated(value=AuthenticatorFor.CM.class)
public class DtiView
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    @Inject
    public DtiView(FormFactory formFactory, Formatters formatters, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        formatters.register(BigDecimal.class, (Formatters.SimpleFormatter)new BigDecimalFormatter());
        formatters.register(Date.class, (Formatters.SimpleFormatter)new DateFormatter());
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result dti(Http.Request request, Integer accountId, Integer statementId, String selectedIds) {
        return this.dti(request, accountId, statementId, null, null, null, null, null, selectedIds);
    }

    public Result dtiByBooking(Http.Request request, Integer bookingId) {
        return this.dti(request, -1, null, bookingId, null, null, null, null, null);
    }

    private Result dti(Http.Request request, Integer accountId, Integer statementId, Integer bookingId, Form<BookingFilterForm> bookingFilterForm, Form<CmDateRangeForm> dateRangeForm, Form<CmFolderIdForm> moveToFolderForm, Form<DeleteForm> deleteForm, String selectedIds) {
        ArrayList<CmBooking> bookings2;
        Object values;
        CmBooking parentBooking;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_DTI);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ArrayList<Account> accs = new ArrayList<Account>();
        Account acc = null;
        boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        List allAccounts = Account.findAccounts((User)user, null, null, (boolean)checkPermission);
        for (Account a : allAccounts) {
            if (CmStatement.findCountDtiFiles((Account)a, null, null, (boolean)true) <= 0) continue;
            accs.add(a);
            if (!a.getId().equals(accountId)) continue;
            acc = a;
        }
        if (acc == null && accountId != -1) {
            return DtiView.redirect((Call)routes.DtiView.dti(-1, null, null)).flashing("warning", messages.at("cm.error.noSuchAccount", new Object[0]));
        }
        accs.sort(Comparator.comparing(Account::getDefaultDisplayName));
        CmStatement statement = null;
        List statements = null;
        if (acc != null) {
            statements = CmStatement.findDtiFiles(acc, (int)0, (int)20, (boolean)true, null, null, (boolean)true).getList();
            if (statementId != null) {
                statement = this.statementForAccountAndId(acc, statementId);
            }
        }
        if (!(bookingId == null || (parentBooking = CmBooking.findById((int)bookingId)) != null && allAccounts.contains(parentBooking.getAccount()))) {
            return DtiView.redirect((Call)routes.DtiView.dti(-1, null, null)).flashing("warning", messages.at("cm.error.noSuchItem", new Object[0]));
        }
        CmBookingFilter filter = CmBookingFilter.getFilter((User)user);
        if (bookingFilterForm == null) {
            BookingFilterForm data = BookingFilterForm.getData(filter);
            bookingFilterForm = this.formFactory.form(BookingFilterForm.class).fill((Object)data);
        }
        if (!filter.isFilterActive()) {
            filter = null;
        }
        if (dateRangeForm == null) {
            CmDateRangeForm dateValues = new CmDateRangeForm();
            dateValues.fromDate = Date.from(ZonedDateTime.now().minusMonths(1L).toInstant());
            dateValues.toDate = new Date();
            dateValues.accountIds = "" + accountId;
            dateRangeForm = this.formFactory.form(CmDateRangeForm.class).fill((Object)dateValues);
        }
        if (moveToFolderForm == null) {
            values = new CmFolderIdForm();
            ((CmFolderIdForm)values).accountIds = "" + accountId;
            moveToFolderForm = this.formFactory.form(CmFolderIdForm.class).fill(values);
        }
        if (deleteForm == null) {
            values = new DeleteForm();
            ((DeleteForm)values).selectionIds = "" + accountId;
            deleteForm = this.formFactory.form(DeleteForm.class).fill(values);
        }
        Form exportForm = this.formFactory.form(BookingExportForm.class).fill((Object)new BookingExportForm());
        Query<CmBooking> q = DtiView.sortedPagedBookings(acc, statement, bookingId, accs, filter, sorting.getSortingColumn(), sorting.isSortingAscending());
        if (q != null) {
            sorting.computeForQuery(q);
            bookings2 = q.findList();
        } else {
            bookings2 = new ArrayList(0);
            sorting.computeForList(bookings2);
        }
        CheckedState checkedState = new CheckedState(user, statement, null, bookings2, null);
        return DtiView.ok((Content)dti.render(acc, accs, statement, statements, bookingId, bookings2, sorting, (Form<BookingFilterForm>)bookingFilterForm, filter, (Form<CmDateRangeForm>)dateRangeForm, (Form<CmFolderIdForm>)moveToFolderForm, (Form<DeleteForm>)deleteForm, (Form<BookingExportForm>)exportForm, selectedIds, checkedState, request, messages));
    }

    public Result dti_sort(Http.Request request, Integer accountId, Integer statementId, Integer bookingId, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_DTI).updateSort(sort, asc);
        if (bookingId != null) {
            return DtiView.redirect((Call)routes.DtiView.dtiByBooking(bookingId));
        }
        return DtiView.redirect((Call)routes.DtiView.dti(accountId, statementId, null));
    }

    public Result dti_pageSize(Http.Request request, Integer accountId, Integer statementId, Integer bookingId, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_DTI).updatePage(page, pageSize);
        if (bookingId != null) {
            return DtiView.redirect((Call)routes.DtiView.dtiByBooking(bookingId));
        }
        return DtiView.redirect((Call)routes.DtiView.dti(accountId, statementId, null));
    }

    public Result dti_filterForm(Http.Request request, Integer accountId, Integer statementId, Integer bookingId, boolean filterActive) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        CmBookingFilter filter = CmBookingFilter.getFilter((User)user);
        if (!filterActive) {
            filter.setFilterActive(Boolean.valueOf(false));
            filter.save();
        } else {
            filter.setFilterActive(Boolean.valueOf(true));
            Form filterForm = this.formFactory.form(BookingFilterForm.class).bindFromRequest(request, new String[0]);
            if (filterForm.hasErrors()) {
                Form dateRangeForm = this.formFactory.form(CmDateRangeForm.class).bindFromRequest(request, new String[0]);
                Form moveToFolderForm = this.formFactory.form(CmFolderIdForm.class).bindFromRequest(request, new String[0]);
                Form deleteForm = this.formFactory.form(DeleteForm.class).bindFromRequest(request, new String[0]);
                if (bookingId != null) {
                    accountId = -1;
                }
                return this.dti(request, accountId, statementId, bookingId, (Form<BookingFilterForm>)filterForm, (Form<CmDateRangeForm>)dateRangeForm, (Form<CmFolderIdForm>)moveToFolderForm, (Form<DeleteForm>)deleteForm, null);
            }
            BookingFilterForm data = (BookingFilterForm)filterForm.get();
            data.saveData(filter);
        }
        if (bookingId != null) {
            return DtiView.redirect((Call)routes.DtiView.dtiByBooking(bookingId));
        }
        return DtiView.redirect((Call)routes.DtiView.dti(accountId, statementId, null));
    }

    private CmStatement statementForAccountAndId(Account acc, Integer statementId) {
        Expression expr = Expr.eq((String)"account", (Object)acc);
        expr = Expr.and((Expression)expr, (Expression)Expr.eq((String)"id", (Object)statementId));
        return (CmStatement)DB.find(CmStatement.class).where(expr).findOne();
    }

    public static Query<CmBooking> sortedPagedBookings(Account acc, CmStatement statement, Integer bookingId, List<Account> accs, CmBookingFilter filter, int sort, boolean asc) {
        BookingSQLBuilder sqlBuilder = new BookingSQLBuilder();
        Expression expr = null;
        if (statement != null) {
            sqlBuilder.addCmStatement(statement);
        } else if (acc != null) {
            sqlBuilder.addDTIAccount(acc);
        } else if (bookingId != null) {
            expr = Expr.eq((String)"parent_booking_id", (Object)bookingId);
        } else {
            for (Account a : accs) {
                sqlBuilder.addDTIAccount(a);
            }
        }
        if (expr == null) {
            expr = sqlBuilder.getExpression(filter == null);
        }
        if (expr != null) {
            if (filter != null && filter.getExpression() != null) {
                expr = Expr.and((Expression)expr, (Expression)filter.getExpression());
            }
            Query q = DB.find(CmBooking.class).where(expr);
            String dateSortDirection = "";
            dateSortDirection = DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType()) ? (asc ? "ASC NULLS FIRST" : "DESC NULLS LAST") : (asc ? "ASC" : "DESC");
            switch (sort) {
                case 1: {
                    if (asc) {
                        q = q.order("valueDate " + dateSortDirection + ", pos asc");
                        break;
                    }
                    q = q.order("valueDate " + dateSortDirection + ", pos desc");
                    break;
                }
                case 2: {
                    if (asc) {
                        q = q.order("counterParty asc, localParty asc");
                        break;
                    }
                    q = q.order("counterParty desc, localParty desc");
                    break;
                }
                case 3: {
                    if (asc) {
                        q = q.order("purposeOverview asc");
                        break;
                    }
                    q = q.order("purposeOverview desc");
                    break;
                }
                case 4: {
                    if (asc) {
                        q = q.order("amount asc");
                        break;
                    }
                    q = q.order("amount desc");
                    break;
                }
                case 5: {
                    if (asc) {
                        q = q.order("balance asc");
                        break;
                    }
                    q = q.order("balance desc");
                    break;
                }
                default: {
                    q = asc ? q.order("bookingDate " + dateSortDirection + ", pos asc") : q.order("bookingDate " + dateSortDirection + ", pos desc");
                }
            }
            return q;
        }
        return null;
    }
}

