/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.Setup;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import controllers.util.DsOrderPaymentInfo;
import controllers.util.EbicsUtil;
import controllers.util.GeneralUtils;
import controllers.util.OrderPermissionChecker;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DSPrinter;
import de.businesslogics.banking.api.DSUtil;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.SendOrderNameHandler;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.api.dta.DTAZVPaymentCsvExport;
import de.businesslogics.banking.api.dta.DtazvDetailsPrinter;
import de.businesslogics.banking.api.mt101.MT101DetailsPrinter;
import de.businesslogics.banking.api.sepa.SEPAPaymentDataCsvExport;
import de.businesslogics.banking.api.sepa.SepaDetailsPrinter;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DsBank;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOpenOrderSigner;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.ds.LocalDSUtil;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.client.DistributedSignature;
import de.businesslogics.ebics.schema.BooleanElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.IntegerElement;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.String255Type;
import de.businesslogics.ebics.schema.orders.HVDResponseOrderData;
import de.businesslogics.ebics.schema.orders.HVTResponseOrderData;
import de.businesslogics.ebics.schema.orders.HVUOriginatorInfo;
import de.businesslogics.ebics.schema.orders.HVUSigningInfo;
import de.businesslogics.ebics.schema.orders.HVZOrderDetails;
import de.businesslogics.ebics.schema.orders.OrderDetails;
import de.businesslogics.ebics.schema.orders.SignerInfo;
import de.businesslogics.ebics.schema.orders.SignerPermission;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.CurrencyBase;
import de.businesslogics.ebics.schema.types.DataDigest;
import de.businesslogics.ebics.schema.types.Name;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.ebics.schema.types.UserID;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusCode;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AustrianForeignPaymentForm;
import models.DtazvPaymentForm;
import models.HvtPaymentForm;
import models.Mt101PaymentForm;
import models.PasswordForm;
import models.PaymentForm;
import models.PaymentImportForm;
import models.PostbarPaymentForm;
import models.SendFilterForm;
import models.SepaPaymentForm;
import models.SimpleTextForm;
import models.TaxOfficePaymentForm;
import models.WebAuthnData;
import models.payments.AustrianForeignPaymentHandler;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PostbarPaymentHandler;
import models.payments.TaxOfficePaymentHandler;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.orders.desdetails;
import views.html.orders.desoverview;
import views.html.orders.despaymentdetails;

@Security.Authenticated(value=AuthenticatorFor.DES.class)
public final class DesOverview
extends Controller {
    public static final int LOAD_PAYMENTS_MAX_SIZE = 0xA00000;
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static String getIdsString(List<DsOpenOrder> desOrders) {
        StringBuilder result = new StringBuilder();
        if (desOrders != null && !desOrders.isEmpty()) {
            for (DsOpenOrder desOrder : desOrders) {
                if (!result.isEmpty()) {
                    result.append(',');
                }
                result.append(desOrder.getId());
            }
        }
        return result.toString();
    }

    public static String loadOverviewJsParameters(Messages messages, List<DsOpenOrder> payments, boolean useQuickSign, boolean fetchNow) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("signMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.sign", (Object[])new Object[0]));
        resultJson.put("cancelMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.cancel", (Object[])new Object[0]));
        resultJson.put("fetchRunningMessage", messages.at("desoverview.fetchrunning", new Object[0]));
        resultJson.put("indexLink", routes.DesOverview.index().toString());
        resultJson.put("fetchOverviewLink", routes.DesOverview.fetchDesOverview().toString());
        resultJson.put("fetchNow", fetchNow);
        resultJson.put("useQuickSign", useQuickSign);
        if (payments != null && !payments.isEmpty()) {
            ArrayNode paymentsNode = resultJson.putArray("paymentInfos");
            for (DsOpenOrder payment : payments) {
                ObjectNode paymentNode = paymentsNode.addObject();
                paymentNode.put("id", payment.getId());
                if (payment.getAmount() != null) {
                    paymentNode.put("amount", payment.getAmount().toPlainString());
                }
                paymentNode.put("currency", payment.getAmountCurrency());
            }
        }
        resultJson.put("addDecimalsUrl", routes.Application.addSumsWithCurrencyDecimals().toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadDetailsJsParameters(Messages messages, List<DsOpenOrder> desOrders, String desOrdersId, PasswordForm.PasswordOperation operation, Integer showOrder) {
        ObjectNode resultJson = Json.newObject();
        if (showOrder != null) {
            resultJson.put("showOrder", showOrder);
        }
        resultJson.put("fetchingPaymentsMessage", messages.at("desdetails.fetchingpaymentinfo", new Object[0]));
        resultJson.put("fetchingDisplayFileMessage", messages.at("desdetails.fetchingdisplayfile", new Object[0]));
        resultJson.put("pageMessage", messages.at("desdetails.page", new Object[]{999, desOrders.size()}));
        resultJson.put("noPermissionMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"SepaDetailsPrinter.salaryPaymentHint", (Object[])new Object[0]));
        resultJson.put("loadingPaymentsMessage", messages.at("desdetails.loadingpayments", new Object[0]));
        resultJson.put("fetchPaymentsLink", routes.DesOverview.fetchPaymentDetails(999).toString());
        resultJson.put("loadPaymentsLink", routes.DesOverview.loadPayments(desOrdersId).toString());
        resultJson.put("paymentsLink", routes.DesOverview.paymentDetails(999, 888, desOrdersId, operation == null ? null : operation.toString()).toString());
        resultJson.put("displayFileLink", routes.DesOverview.fetchDisplayFile(999).toString());
        resultJson.put("printLink", routes.DesOverview.print("999").toString());
        resultJson.put("saveLink", routes.DesOverview.save("999").toString());
        resultJson.put("operation", operation == null ? null : operation.toString());
        if (!desOrders.isEmpty()) {
            ArrayNode ordersArray = resultJson.putArray("orders");
            for (DsOpenOrder desOrder : desOrders) {
                ObjectNode orderNode = ordersArray.addObject();
                orderNode.put("id", desOrder.getId());
                boolean canHandle = PaymentHandler.isHandlerPresent(desOrder.getPmtType());
                orderNode.put("paymentDataAvailable", desOrder.isPaymentDataAvailable() || canHandle && desOrder.isOrderDataAvailable());
                orderNode.put("paymentTypeKnown", canHandle);
                orderNode.put("orderDataAvailable", desOrder.isOrderDataAvailable());
                orderNode.put("orderDataPresent", desOrder.getOrderData() != null);
                orderNode.put("hasTicket", desOrder.getTicket() != null);
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public DesOverview(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result filter(Http.Request request, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SendFilter sendFilter = SendFilter.getFilter((User)user);
        if (active) {
            Form<SendFilterForm> form = this.formFactory.form(SendFilterForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((SendFilterForm)form.get()).validate(form, sendFilter, true);
            }
            if (form.hasErrors()) {
                return this.internalIndex(request, user, sendFilter, form);
            }
            sendFilter.activateFor(SendFilter.SendFilterType.DS_OVERVIEW);
        } else {
            sendFilter.setDsOverviewActive(false);
        }
        sendFilter.save();
        return DesOverview.redirect((Call)routes.DesOverview.index());
    }

    private Result internalIndex(Http.Request request, User user, SendFilter sendFilter, Form<SendFilterForm> filterForm) {
        List list;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.DS_OPEN);
        try {
            list = this.defaultQuery(user, sendFilter, sorting).findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.DS_OPEN, (Call)routes.DesOverview.index());
        }
        return DesOverview.ok((Content)desoverview.render(list, null, (Form<PasswordForm>)this.formFactory.form(PasswordForm.class), (Form<PasswordForm>)this.formFactory.form(PasswordForm.class), sorting, filterForm, sendFilter, false, false, WebAuthnData.buildForSigning(user), DesOverview.getLastDesFetchDateString(user, messages), (Form<PaymentImportForm>)this.formFactory.form(PaymentImportForm.class), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result index(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SendFilter sendFilter = SendFilter.getFilter((User)user);
        Form filterForm = this.formFactory.form(SendFilterForm.class).fill((Object)new SendFilterForm(sendFilter, true));
        return this.internalIndex(request, user, sendFilter, (Form<SendFilterForm>)filterForm);
    }

    public static Map<String, String> fetchDesOverviewSync(User user, Messages messages) {
        List ordersToDelete = null;
        boolean fetched2 = false;
        HashMap<String, String> flashMap = new HashMap<String, String>();
        for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
            DsBank dsBank;
            if (bankUser.getState() != BankUser.UserState.READY || (dsBank = DsBank.get((BankSettings)bankUser.getBank())) != null && !dsBank.isActivated()) continue;
            try {
                ordersToDelete = DsOpenOrder.queryForBankUser((BankUser)bankUser).findList();
                DistributedSignature distributedSignature = new DistributedSignature(EbicsUtil.getEbicsWorker(bankUser).getEbicsSession());
                List orderDetailsList = dsBank == null || dsBank.isHvz() ? distributedSignature.getDetailedOverview(null).getOrders() : distributedSignature.getOverview(null).getOrders();
                orderDetailsList.sort(new OrderDetailsComparator(user));
                for (OrderDetails orderDetails : orderDetailsList) {
                    DsOpenOrder dsOpenOrder = DesOverview.storeHvzOrderData(bankUser, orderDetails);
                    if (dsOpenOrder == null) continue;
                    ordersToDelete.remove(dsOpenOrder);
                    if (dsOpenOrder.getTicketAsString() != null) continue;
                    try {
                        HVDResponseOrderData hvd = distributedSignature.getDetails(orderDetails);
                        if (hvd == null) continue;
                        if (hvd.getDisplayFile() != null) {
                            dsOpenOrder.setTicket(hvd.getDisplayFile().getValue());
                        }
                        if (dsOpenOrder.getDigestHex() == null && hvd.getDataDigest() != null) {
                            dsOpenOrder.setDigestHex(HexTool.toHex((byte[])hvd.getDataDigest().getValue()));
                        }
                        if (dsOpenOrder.getDatasize() == null && hvd.getOrderDataSize() != null) {
                            dsOpenOrder.setDatasize(Long.valueOf(hvd.getOrderDataSize().longValue()));
                        }
                        dsOpenOrder.save();
                    }
                    catch (EbicsException ebics) {
                        BLLoggerPlay.warning("can not fetch HVT for bankUser " + bankUser.getId() + " with EBICS error " + ebics.getMessage());
                    }
                }
                fetched2 = true;
            }
            catch (EbicsException e) {
                BLLoggerPlay.error("Failed to fetch DES overview for bankuser-id " + bankUser.getId() + ": " + e.getMessage());
                String prefix = BankingApiMessages.getStringWithBoldPos1((Locale)messages.lang().locale(), (String)"GeneralMessages.error.prefix.eds", (Object[])new Object[]{bankUser.getBank().getDisplayName()});
                String error = prefix + "<br>" + BankingApiMessages.getErrorMessageWeb((Exception)((Object)e), (Locale)messages.lang().locale());
                Utils.addToFlash(flashMap, "HTMLerror", error);
            }
            catch (Throwable t) {
                BLLoggerPlay.error("Failed to fetch DES overview for bankuser-id " + bankUser.getId(), t);
                Utils.addToFlash(flashMap, "HTMLerror", messages.at("desoverview.fetcherror", new Object[]{bankUser.getBank().getDisplayName(), Utils.getLocalizedMessage(t, messages)}));
            }
            if (ordersToDelete == null || ordersToDelete.isEmpty()) continue;
            for (DsOpenOrder toDelete : ordersToDelete) {
                if (toDelete.getOrderData() != null) {
                    WorkspaceFileSystem.delete((WorkspaceFile)toDelete.getOrderData());
                }
                if (toDelete.getPaymentData() == null) continue;
                WorkspaceFileSystem.delete((WorkspaceFile)toDelete.getPaymentData());
            }
            DB.deleteAll((Collection)ordersToDelete);
            ordersToDelete = null;
        }
        if (flashMap.get("error") == null) {
            if (fetched2) {
                flashMap.put("success", messages.at("desoverview.fetched", new Object[0]));
            } else {
                flashMap.put("warning", messages.at("desoverview.nothingfetched", new Object[0]));
            }
        }
        if (fetched2 || user.getLastDesFetch() == null) {
            user.setLastDesFetch(new Timestamp(System.currentTimeMillis()));
            user.save();
        }
        return flashMap;
    }

    public Result indexWithPage(Http.Request request, int pageNumber, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.DS_OPEN);
        sorting.updatePage(pageNumber, pageSize);
        return DesOverview.redirect((Call)routes.DesOverview.index());
    }

    public Result indexSort(Http.Request request, int sort, boolean ascending) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.DS_OPEN).updateSort(sort, ascending);
        return DesOverview.redirect((Call)routes.DesOverview.index());
    }

    public CompletionStage<Result> orderDetails(Http.Request request, int dsOpenOrderId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            DsOpenOrder desOrder = (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)dsOpenOrderId);
            if (desOrder == null) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            if (!user.equals(desOrder.getBankUser().getUser())) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("desoverview.nobankpermission", new Object[0]));
            }
            if (desOrder.getOrderData() == null) {
                DesOverview.fetchOrderDataIgnoreError(desOrder, "Failed to fetch DES payment details!");
            }
            if (desOrder.getPmtType() != null) {
                String bftVOP = SendParameters.getBTFVop((BankSettings)desOrder.getBankUser().getBank(), (PaymentTransferType.PmtType)desOrder.getPmtType());
                String orderTypeVOP = SendParameters.getOrderTypeVop((BankSettings)desOrder.getBankUser().getBank(), (PaymentTransferType.PmtType)desOrder.getPmtType());
                if ((desOrder.getFileType().equals(bftVOP) || desOrder.getFileType().equals(orderTypeVOP)) && desOrder.getPaymentData() == null) {
                    DesOverview.fetchPaymentDataIgnoreError(desOrder, true);
                }
            }
            return DesOverview.ok((Content)desdetails.render((Form<PasswordForm>)this.formFactory.form(PasswordForm.class), (Form<PasswordForm>)this.formFactory.form(PasswordForm.class), (Form<PaymentImportForm>)this.formFactory.form(PaymentImportForm.class), Collections.singletonList(desOrder), false, false, null, -1, WebAuthnData.buildForSigning(user), null, request, messages));
        }, this.executionContext.current());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result prepareCancelSent(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        String bankOrderId = "Sent_" + ids;
        play.api.mvc.Call redirectTo = routes.Sent.index();
        if (!BankOrder.checkForDoubleTransmission(bankOrderId)) {
            return DesOverview.redirect((Call)redirectTo).flashing("error", messages.at("desoverview.signorders.error.double", new Object[]{2}));
        }
        try {
            Map<Send, DsOpenOrder> desOrders;
            List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
            List sentOrders = idsList.isEmpty() ? null : DB.find(Send.class).where().in("id", idsList).findList();
            if (sentOrders == null || sentOrders.isEmpty()) {
                String flashMessage = messages.at("desoverview.noorderstocancel", new Object[0]);
                Result result = DesOverview.redirect((Call)redirectTo).flashing("error", flashMessage);
                return result;
            }
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
            if (!permissionChecker.hasAccountPermissions(user, sentOrders)) {
                Result result = DesOverview.redirect((Call)redirectTo).flashing("error", permissionChecker.getErrorMessage());
                return result;
            }
            HashMap<String, String> flashMap = new HashMap<String, String>();
            try {
                desOrders = this.getDsOrdersForSendOrders(sentOrders, user, messages, flashMap);
            }
            catch (DesFetchException dfe) {
                Result result = DesOverview.redirect((Call)redirectTo).flashing(dfe.getFlashMap());
                BankOrder.finishedBankOrder(bankOrderId);
                return result;
            }
            Result result = this.prepareDesOperation(request, PasswordForm.PasswordOperation.CANCEL_FROM_SENT, -1, new ArrayList<DsOpenOrder>(desOrders.values()), flashMap, redirectTo);
            return result;
        }
        finally {
            BankOrder.finishedBankOrder(bankOrderId);
        }
    }

    public Result prepareCancelSignedPayments(Http.Request request) {
        return this.prepareCancelSignedPaymentsOrPayment(request, null);
    }

    public Result prepareCancelSignedPayment(Http.Request request, Integer id) {
        return this.prepareCancelSignedPaymentsOrPayment(request, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result prepareCancelSignedPaymentsOrPayment(Http.Request request, Integer id) {
        String ids;
        play.api.mvc.Call redirectTo;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            redirectTo = routes.SignedPayments.payment(id, null);
            ids = id.toString();
        } else {
            redirectTo = routes.SignedPayments.index(false);
            ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        }
        String bankOrderId = "Signed_" + ids;
        if (!BankOrder.checkForDoubleTransmission(bankOrderId)) {
            return DesOverview.redirect((Call)redirectTo).flashing("error", messages.at("desoverview.signorders.error.double", new Object[]{2}));
        }
        try {
            List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
            List selectedPayments = idsList.isEmpty() ? null : DB.find(SignedPayment.class).where().in("id", idsList).findList();
            if (selectedPayments == null || selectedPayments.isEmpty()) {
                String flashMessage = messages.at("desoverview.noorderstocancel", new Object[0]);
                Result result = DesOverview.redirect((Call)redirectTo).flashing("error", flashMessage);
                return result;
            }
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            Set<Send> sentOrders = selectedPayments.stream().map(SignedPayment::getSend).collect(Collectors.toSet());
            HashMap<String, String> flashMap = new HashMap<String, String>();
            Map<Send, DsOpenOrder> desOrders = this.getDsOrdersForSendOrders(sentOrders, user, messages, flashMap);
            HashSet<SignedPayment> missingPayments = new HashSet<SignedPayment>();
            for (Send sentOrder : sentOrders) {
                if (!desOrders.containsKey(sentOrder)) continue;
                List paymentsInOrder = DB.find(SignedPayment.class).where().eq("send_id", (Object)sentOrder.getId()).findList();
                for (SignedPayment paymentInOrder : paymentsInOrder) {
                    if (selectedPayments.contains(paymentInOrder)) continue;
                    missingPayments.add(paymentInOrder);
                }
            }
            if (!missingPayments.isEmpty()) {
                Utils.addToFlash(flashMap, "warning", messages.at("signedpayments.cancel.confirm", new Object[0]));
            }
            Result result = this.prepareDesOperation(request, PasswordForm.PasswordOperation.CANCEL, -1, new ArrayList<DsOpenOrder>(desOrders.values()), flashMap, redirectTo);
            return result;
        }
        catch (DesFetchException dfe) {
            Result result = DesOverview.redirect((Call)redirectTo).flashing(dfe.getFlashMap());
            return result;
        }
        finally {
            BankOrder.finishedBankOrder(bankOrderId);
        }
    }

    public Result prepareDesOperation(Http.Request request, String operation, int showOrder) {
        return this.prepareDesOperation(request, "sign".equalsIgnoreCase(operation) ? PasswordForm.PasswordOperation.SIGN : PasswordForm.PasswordOperation.CANCEL, showOrder, null, null, routes.DesOverview.index());
    }

    private Result prepareDesOperation(Http.Request request, PasswordForm.PasswordOperation operation, int showOrder, List<DsOpenOrder> presetOrders, Map<String, String> flashMap, play.api.mvc.Call redirectTo) {
        List desOrders = presetOrders;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (desOrders == null) {
            String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
            if (idsList.isEmpty()) {
                desOrders = new ArrayList<DsOpenOrder>();
            } else if (idsList.size() == 1) {
                desOrders = new ArrayList<DsOpenOrder>(1);
                DsOpenOrder desOrder = (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)idsList.getFirst());
                if (desOrder != null) {
                    desOrders.add(desOrder);
                }
            } else {
                desOrders = DB.find(DsOpenOrder.class).where().in("id", idsList).findList();
            }
        }
        boolean sign = PasswordForm.PasswordOperation.SIGN.equals((Object)operation);
        if (flashMap == null) {
            flashMap = new HashMap<String, String>();
        }
        Iterator<DsOpenOrder> iterator = desOrders.iterator();
        while (iterator.hasNext()) {
            DsOpenOrder desOrder = iterator.next();
            if (user.equals(desOrder.getBankUser().getUser()) && (!sign || desOrder.isSignable())) continue;
            iterator.remove();
        }
        if (desOrders.isEmpty()) {
            if (!Utils.hasErrorFlash(flashMap)) {
                String flashMessage = sign ? messages.at("desoverview.noorderstosign", new Object[0]) : messages.at("desoverview.noorderstocancel", new Object[0]);
                Utils.addToFlash(flashMap, "error", flashMessage);
            }
            return DesOverview.redirect((Call)redirectTo).flashing(flashMap);
        }
        return DesOverview.ok((Content)desdetails.render((Form<PasswordForm>)this.formFactory.form(PasswordForm.class), (Form<PasswordForm>)this.formFactory.form(PasswordForm.class), (Form<PaymentImportForm>)this.formFactory.form(PaymentImportForm.class), desOrders, false, false, operation, showOrder, WebAuthnData.buildForSigning(user), flashMap, request, messages));
    }

    public CompletionStage<Result> print(Http.Request request, String dsOpenOrderIds) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List<Integer> orderIds = GeneralUtils.getSelectionIds(dsOpenOrderIds);
        return CompletableFuture.supplyAsync(() -> {
            if (Branding.getBranding().hidePrintInDes()) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
            }
            List<DsOpenOrder> desOrders = orderIds.stream().map(id -> (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)id)).filter(Objects::nonNull).toList();
            if (desOrders.isEmpty()) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            for (DsOpenOrder dsOpenOrder : desOrders) {
                String string;
                if (dsOpenOrder.getDatasize() == null || dsOpenOrder.getDatasize() >= 0xA00000L || (string = DesOverview.checkOrderPermission(user, dsOpenOrder, messages)) == null) continue;
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", string);
            }
            HashMap signersByOrder = new HashMap();
            for (DsOpenOrder dsOpenOrder : desOrders) {
                ArrayList<DSPrinter.UserInfo> arrayList = new ArrayList<DSPrinter.UserInfo>();
                signersByOrder.put(dsOpenOrder, arrayList);
                if (dsOpenOrder.getSigners() == null) continue;
                for (DsOpenOrderSigner signer : dsOpenOrder.getSigners()) {
                    arrayList.add(new DSPrinter.UserInfo(signer));
                }
            }
            HashMap<DsOpenOrder, String> hashMap = new HashMap<DsOpenOrder, String>();
            for (DsOpenOrder dsOpenOrder : desOrders) {
                hashMap.put(dsOpenOrder, dsOpenOrder.getTicketAsString());
            }
            HashMap<DsOpenOrder, File> hashMap2 = new HashMap<DsOpenOrder, File>();
            for (DsOpenOrder dsOpenOrder : desOrders) {
                File dataFile = dsOpenOrder.getOrderData() != null ? WorkspaceFileSystem.getFile((WorkspaceFile)dsOpenOrder.getOrderData()) : null;
                hashMap2.put(dsOpenOrder, dataFile);
            }
            try {
                HashMap<DsOpenOrder, File> hashMap3 = new HashMap<DsOpenOrder, File>();
                for (DsOpenOrder desOrder : desOrders) {
                    boolean printLogo = GeneralUtils.printLogo(user);
                    File file2 = DSPrinter.print((String)desOrder.getFileType(), (String)desOrder.getOrderId(), (DSPrinter.UserInfo)new DSPrinter.UserInfo(desOrder), (List)((List)signersByOrder.get(desOrder)), (String)((String)hashMap.get(desOrder)), (BankSettings)desOrder.getBankUser().getBank(), (File)((File)hashMap2.get(desOrder)), (DSPrinter.DataFilePrintHandler)new WebDataFilePrintHandler(messages, user), (User)user, (Locale)messages.lang().toLocale(), (boolean)printLogo, (SendOrderNameHandler)new SendOrderNameHandler(user), (String)desOrder.getDigestHex(), (String)desOrder.getAdditionalOrderInfo(), (boolean)false);
                    String prefix = desOrder.getFileType() + "-" + desOrder.getOrderId();
                    Util.applyPreferencesToPdf((File)file2, (User)user, (String)prefix, (Locale)messages.lang().toLocale(), null, null, (boolean)printLogo);
                    hashMap3.put(desOrder, file2);
                }
                if (desOrders.size() == 1) {
                    File file2 = (File)hashMap3.get(desOrders.getFirst());
                    return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
                }
                ArrayList<File> arrayList = new ArrayList<File>(hashMap3.values());
                return GeneralUtils.supplyZipFile(arrayList, true, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.orders", (Object[])new Object[0]) + ".zip"));
            }
            catch (PDFException | IOException | GeneralSecurityException throwable) {
                BLLoggerPlay.error("Failed to print locale DS order!", throwable);
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("HTMLerror", messages.at("desoverview.printfailed", new Object[]{Utils.getLocalizedMessage(throwable, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> exportOverview(Http.Request request, int dsOpenOrderId) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean displaySalaries = Util.displaySalaries((User)user);
        return CompletableFuture.supplyAsync(() -> {
            File exportFile;
            block11: {
                String permissionError;
                DsOpenOrder desOrder = (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)dsOpenOrderId);
                if (desOrder == null) {
                    return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("deshistory.notfound", new Object[0]));
                }
                if (!user.equals(desOrder.getBankUser().getUser())) {
                    return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("desoverview.nobankpermission", new Object[0]));
                }
                File orderDataFile = WorkspaceFileSystem.getFile((WorkspaceFile)desOrder.getOrderData());
                if (!orderDataFile.isFile()) {
                    return DesOverview.redirect((Call)routes.DesOverview.orderDetails(dsOpenOrderId)).flashing("error", messages.at("desoverview.noorderdatafile", new Object[0]));
                }
                if (desOrder.getDatasize() != null && desOrder.getDatasize() < 0xA00000L && (permissionError = DesOverview.checkOrderPermission(user, desOrder, messages)) != null) {
                    return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", permissionError);
                }
                exportFile = new File(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.paymentDetails", (Object[])new Object[0]) + ".csv");
                List<Object> paymentObjects = DsOrderPaymentInfo.loadForOpenOrder(desOrder).stream().filter(pi -> pi.getPayment() != null).map(pi -> pi.getPayment().getPayment()).toList();
                if (paymentObjects.isEmpty()) {
                    return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("error.failedcsvexport", new Object[]{messages.at("desoverview.export.nodata", new Object[0])}));
                }
                try {
                    if (paymentObjects.getFirst() instanceof DTAZVPayment) {
                        List<DTAZVPayment> dtazvPaymentObjects = paymentObjects.stream().map(o -> (DTAZVPayment)o).toList();
                        new DTAZVPaymentCsvExport(messages.lang().locale()).write(exportFile, dtazvPaymentObjects);
                        break block11;
                    }
                    if (paymentObjects.getFirst() instanceof SEPAPaymentData) {
                        List<SEPAPaymentData> sepaPaymentObjects = paymentObjects.stream().map(o -> (SEPAPaymentData)o).toList();
                        new SEPAPaymentDataCsvExport(messages.lang().locale(), SepaApi.isCreditPmtType((PaymentTransferType.PmtType)desOrder.getPmtType()), displaySalaries).write(exportFile, sepaPaymentObjects);
                        break block11;
                    }
                    return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("error.failedcsvexport", new Object[]{messages.at("desoverview.export.onlysepadtazv", new Object[0])}));
                }
                catch (IOException e) {
                    return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("error.failedcsvexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                }
            }
            try {
                return GeneralUtils.supplyWorkspaceFile(exportFile, true, false).as("binary/octet-stream").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(exportFile.getName()));
            }
            catch (IOException | GeneralSecurityException e) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("HTMLerror", messages.at("desoverview.exportfailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> fetchDesOverview(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            Map<String, String> flashMap = DesOverview.fetchDesOverviewSync(user, messages);
            return DesOverview.ok().flashing(flashMap);
        }, this.executionContext.current());
    }

    private static DsOpenOrder storeHvzOrderData(BankUser bankUser, OrderDetails order) {
        Timestamp submissionDate;
        BankSettings bank;
        List sendItems;
        Send send;
        boolean newOrder;
        boolean isH005OrNewer = BankUtils.isProtocolH005OrNewer((String)bankUser.getBank().getProtocolVersion());
        if (order.getOriginatorInfo() == null || order.getOriginatorInfo().getPartnerID() == null) {
            return null;
        }
        String customerId = order.getOriginatorInfo().getPartnerID().getValue();
        String orderType = order.getFileFormat() != null ? order.getFileFormat().getValue() : (isH005OrNewer ? order.getService().toString() : order.getOrderType().getValue());
        if (order.getOrderID() == null) {
            return null;
        }
        String orderId = order.getOrderID().getValue();
        DsOpenOrder dsOpenOrder = (DsOpenOrder)DsOpenOrder.queryForBankUser((BankUser)bankUser).where().eq("customerId", (Object)customerId).eq("fileType", (Object)orderType).eq("orderId", (Object)orderId).order("submissionDate DESC").setMaxRows(1).findOne();
        boolean bl = newOrder = dsOpenOrder == null;
        if (newOrder) {
            dsOpenOrder = new DsOpenOrder();
            dsOpenOrder.setBankUser(bankUser);
            dsOpenOrder.setCustomerId(customerId);
            dsOpenOrder.setFileType(orderType);
            String transferType = DSUtil.getGeneralizedOrderType((OrderDetails)order);
            dsOpenOrder.setPmtType(SendParameters.getPmtType((BankSettings)bankUser.getBank(), (String)transferType));
            dsOpenOrder.setOrderId(orderId);
        }
        if (order.getOriginatorInfo() != null && order.getOriginatorInfo().getTimestamp() != null) {
            dsOpenOrder.setSubmissionDate(new Timestamp(order.getOriginatorInfo().getTimestamp().getDate().getTime()));
        }
        if (order.getOriginatorInfo() != null && order.getOriginatorInfo().getUserID() != null) {
            dsOpenOrder.setUserId(order.getOriginatorInfo().getUserID().getValue());
        }
        if ((send = LocalDSUtil.findByOrderDetails((BankSettings)bankUser.getBank(), (OrderDetails)order)) != null) {
            dsOpenOrder.setUserName(send.getSender());
        } else if (order.getOriginatorInfo() != null && order.getOriginatorInfo().getName() != null) {
            dsOpenOrder.setUserName(order.getOriginatorInfo().getName().getValue());
        }
        if (order.getOrderDataSize() != null) {
            dsOpenOrder.setDatasize(Long.valueOf(order.getOrderDataSize().longValue()));
        }
        boolean orderDataAvailable = false;
        boolean orderDetailsAvailable = false;
        if (order instanceof HVZOrderDetails) {
            HVZOrderDetails hvz = (HVZOrderDetails)order;
            if (hvz.getTotalAmount() != null) {
                dsOpenOrder.setAmount(hvz.getTotalAmount().getValue());
                if (hvz.getCurrency() != null) {
                    dsOpenOrder.setAmountCurrency(hvz.getCurrency().getValue());
                }
            }
            if (hvz.getFirstOrderInfo() != null && hvz.getFirstOrderInfo().getOrderPartyInfo() != null) {
                dsOpenOrder.setOriginator(hvz.getFirstOrderInfo().getOrderPartyInfo().getValue());
            }
            if (hvz.getDataDigest() != null) {
                dsOpenOrder.setDigestHex(HexTool.toHex((byte[])hvz.getDataDigest().getValue()));
            }
            if (hvz.getOrderDataAvailable() != null) {
                orderDataAvailable = hvz.getOrderDataAvailable().booleanValue();
                dsOpenOrder.setOrderDataAvailable(orderDataAvailable);
            }
            if (hvz.getOrderDetailsAvailable() != null) {
                orderDetailsAvailable = hvz.getOrderDetailsAvailable().booleanValue();
                dsOpenOrder.setPaymentDataAvailable(orderDetailsAvailable);
            }
        }
        if (order.getSigningInfo() != null) {
            dsOpenOrder.setNumSigDone(order.getSigningInfo().getNumSigDone());
            dsOpenOrder.setNumSigRequired(order.getSigningInfo().getNumSigRequired());
        } else {
            dsOpenOrder.setNumSigDone(1);
            dsOpenOrder.setNumSigRequired(2);
        }
        if (order.getSigners() != null && !order.getSigners().isEmpty()) {
            ArrayList<DsOpenOrderSigner> dsSigners = dsOpenOrder.getSigners();
            if (dsSigners == null) {
                dsSigners = new ArrayList<DsOpenOrderSigner>();
            }
            for (SignerInfo signerInfo : order.getSigners()) {
                String signCustomerId = signerInfo.getPartnerID() != null ? signerInfo.getPartnerID().getValue() : null;
                String signUserId = signerInfo.getUserID() != null ? signerInfo.getUserID().getValue() : null;
                DsOpenOrderSigner dsSigner = null;
                if (signCustomerId != null && signUserId != null) {
                    for (DsOpenOrderSigner existingDsSigner : dsSigners) {
                        if (!signCustomerId.equals(existingDsSigner.getCustomerId()) || !signUserId.equals(existingDsSigner.getUserId())) continue;
                        dsSigner = existingDsSigner;
                        break;
                    }
                }
                if (dsSigner == null) {
                    dsSigner = new DsOpenOrderSigner();
                    dsSigner.setCustomerId(signCustomerId);
                    dsSigner.setUserId(signUserId);
                    dsSigners.add(dsSigner);
                }
                if (signerInfo.getTimestamp() != null) {
                    dsSigner.setSignDate(new Timestamp(signerInfo.getTimestamp().getDate().getTime()));
                }
                if (order.getSigners().size() == 1) {
                    dsSigner.setUserName(dsOpenOrder.getUserName());
                } else if (dsSigner.getUserName() == null && signerInfo.getName() != null) {
                    dsSigner.setUserName(signerInfo.getName().getValue() + " (" + dsSigner.getCustomerId() + " / " + dsSigner.getUserId() + ")");
                }
                if (signerInfo.getPermission() == null || signerInfo.getPermission().getAuthorisationLevel().isEmpty()) continue;
                dsSigner.setPermission(Character.valueOf(signerInfo.getPermission().getAuthorisationLevel().charAt(0)));
            }
            dsOpenOrder.setSigners(dsSigners);
            long countTSignatures = dsOpenOrder.getSigners().stream().filter(dsOpenOrderSigner -> 'T' == dsOpenOrderSigner.getPermission().charValue()).count();
            if (countTSignatures > 0L && dsOpenOrder.getNumSigDone() == dsOpenOrder.getSigners().size()) {
                dsOpenOrder.setNumSigDone(dsOpenOrder.getNumSigDone() - (int)countTSignatures);
            }
            if (dsOpenOrder.getNumSigDone() == dsOpenOrder.getNumSigRequired()) {
                dsOpenOrder.setNumSigRequired(dsOpenOrder.getNumSigRequired() + 1);
            }
        }
        if (order.getAdditionalOrderInfo() != null) {
            dsOpenOrder.setAdditionalOrderInfo(order.getAdditionalOrderInfo().getValue());
        }
        if ((sendItems = Send.findByOrderDetails((BankSettings)(bank = bankUser.getBank()), (String)orderType, (String)orderId, (Timestamp)(submissionDate = new Timestamp(order.getOriginatorInfo().getTimestamp().getDate().getTime())))).size() == 1) {
            Send sendItem = (Send)sendItems.getFirst();
            try {
                if (sendItem.getFile() != null && dsOpenOrder.getOrderData() == null) {
                    File dsDirectory = LocalDSUtil.getDsDirectory();
                    File bankDsDirectory = new File(dsDirectory, dsOpenOrder.getBankUser().getBank().getUniqueKey());
                    bankDsDirectory.mkdirs();
                    File targetFile = File.createTempFile("open_", "." + BankOrder.getFileExtension((String)dsOpenOrder.getFileType()), bankDsDirectory);
                    Files.copy(WorkspaceFileSystem.getFile((WorkspaceFile)sendItem.getFile()).toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    WorkspaceFile copy = WorkspaceFileSystem.createFile((WorkspaceFile.Prefix)WorkspaceFile.Prefix.DS, (File)targetFile, (long)sendItem.getFile().getSize(), (String)sendItem.getFile().getMd5Hash(), (String)sendItem.getFile().getSha256Hash());
                    dsOpenOrder.setOrderData(copy);
                }
            }
            catch (IOException io) {
                BLLoggerPlay.error("can not copy data file from send-order", io);
            }
            PaymentTransferType.PmtType newPmtType = sendItem.getPmtType();
            if (newPmtType != null && newPmtType != dsOpenOrder.getPmtType()) {
                String newPmtTypeName = newPmtType.name();
                String oldPmtTypeName = dsOpenOrder.getPmtType() != null ? dsOpenOrder.getPmtType().name() : "null";
                BLLoggerPlay.info("Changed pmtType of dsOpenOrder from " + oldPmtTypeName + " to " + newPmtTypeName + " (derived from Send item " + sendItem.getId() + ").");
                dsOpenOrder.setPmtType(newPmtType);
            }
        } else if (sendItems.size() > 1) {
            BLLoggerPlay.warning("Found multiple (" + sendItems.size() + ") Send items for DsOpenOrder with params: bankId=" + bank.getBankId() + ", orderId=" + orderId + ", order/fileType=" + orderType + ", submissionDime=" + String.valueOf(submissionDate));
        }
        dsOpenOrder.setSignable(order.getSigningInfo().isReadyToBeSigned());
        dsOpenOrder.save();
        if (newOrder) {
            DesOverview.debugOrderDataLog(dsOpenOrder, "created with orderDataAvailable = " + orderDataAvailable);
            DesOverview.debugOrderDataLog(dsOpenOrder, "created with orderDetailsAvailable = " + orderDetailsAvailable);
        }
        return dsOpenOrder;
    }

    public CompletionStage<Result> fetchDisplayFile(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            DsOpenOrder dsOpenOrder = (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)id);
            if (dsOpenOrder == null) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            if (!user.equals(dsOpenOrder.getBankUser().getUser())) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("desoverview.nobankpermission", new Object[0]));
            }
            if (dsOpenOrder.getTicket() == null) {
                try {
                    BankUser bankUser = dsOpenOrder.getBankUser();
                    EbicsWorker worker = EbicsUtil.getEbicsWorker(bankUser);
                    boolean isH005OrNewer = BankUtils.isProtocolH005OrNewer((String)bankUser.getBank().getProtocolVersion());
                    HVDResponseOrderData hvd = isH005OrNewer ? new DistributedSignature(worker.getEbicsSession()).getDetails(new PartnerID(dsOpenOrder.getCustomerId()), BTFTranslator.convertFrom((String)dsOpenOrder.getFileType()), new OrderID(dsOpenOrder.getOrderId())) : new DistributedSignature(worker.getEbicsSession()).getDetails(new PartnerID(dsOpenOrder.getCustomerId()), new OrderType(dsOpenOrder.getFileType()), new OrderID(dsOpenOrder.getOrderId()));
                    if (hvd != null) {
                        if (hvd.getDisplayFile() != null) {
                            dsOpenOrder.setTicket(hvd.getDisplayFile().getValue());
                        }
                        if (dsOpenOrder.getDigestHex() == null && hvd.getDataDigest() != null) {
                            dsOpenOrder.setDigestHex(HexTool.toHex((byte[])hvd.getDataDigest().getValue()));
                        }
                        if (dsOpenOrder.getDatasize() == null && hvd.getOrderDataSize() != null) {
                            dsOpenOrder.setDatasize(Long.valueOf(hvd.getOrderDataSize().longValue()));
                        }
                        dsOpenOrder.save();
                    }
                }
                catch (EbicsException | IOException | GeneralSecurityException e) {
                    BLLoggerPlay.error("Failed to fetch order details for order " + dsOpenOrder.getId(), e);
                    String error = messages.at("desoverview.failedtofetchticket", new Object[]{Utils.getLocalizedMessage(e, messages)});
                    return DesOverview.ok((String)error);
                }
            }
            return DesOverview.ok((String)dsOpenOrder.getTicketAsString());
        }, this.executionContext.current());
    }

    public CompletionStage<Result> paymentDetails(Http.Request request, int id, int pageNumber, String originalOrders, String operation) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            DsOpenOrder dsOpenOrder = (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)id);
            if (dsOpenOrder == null || !dsOpenOrder.isOrderDataAvailable() && !dsOpenOrder.isPaymentDataAvailable()) {
                return DesOverview.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            if (!user.equals(dsOpenOrder.getBankUser().getUser())) {
                return DesOverview.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("error", messages.at("desoverview.nobankpermission", new Object[0]));
            }
            String permissionError = DesOverview.checkOrderPermission(user, dsOpenOrder, messages);
            if (permissionError != null) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", permissionError);
            }
            List<DsOrderPaymentInfo> paymentInfos = DsOrderPaymentInfo.loadForOpenOrder(dsOpenOrder);
            return this.loadPaymentDetails(paymentInfos, request, id, pageNumber, originalOrders, dsOpenOrder, operation);
        }, this.executionContext.current());
    }

    public Result loadPaymentDetails(List<DsOrderPaymentInfo> paymentInfos, Http.Request request, int id, int pageNumber, String originalOrders, DsOpenOrder dsOpenOrder, String operation) {
        Form paymentForm;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (pageNumber < paymentInfos.size()) {
            try {
                boolean allowRecipientRecording;
                DsOrderPaymentInfo paymentInfo = paymentInfos.get(pageNumber);
                boolean bl = allowRecipientRecording = !PreferenceUtil.disableRecipientRecording((User)user);
                if (paymentInfo.getPayment() != null) {
                    Object paymentObject = paymentInfo.getPayment().getPayment();
                    if (Util.hideSalariesCompletely((User)user) && paymentInfo.getPayment().isSalaryPayment()) {
                        paymentForm = null;
                    }
                    if (paymentObject instanceof SEPAPaymentData) {
                        PaymentHandler<?> paymentHandler = paymentInfo.getPayment();
                        Objects.requireNonNull(paymentHandler);
                        PaymentHandler<?> paymentHandler2 = paymentHandler;
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PostbarPaymentHandler.class, TaxOfficePaymentHandler.class, AustrianForeignPaymentHandler.class}, paymentHandler2, n)) {
                            case 0: {
                                PostbarPaymentHandler ignored = (PostbarPaymentHandler)paymentHandler2;
                                paymentForm = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm((Object)dsOpenOrder, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                                break;
                            }
                            case 1: {
                                TaxOfficePaymentHandler ignored2 = (TaxOfficePaymentHandler)paymentHandler2;
                                paymentForm = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm((Object)dsOpenOrder, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                                break;
                            }
                            case 2: {
                                AustrianForeignPaymentHandler ignored3 = (AustrianForeignPaymentHandler)paymentHandler2;
                                paymentForm = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)new AustrianForeignPaymentForm((Object)dsOpenOrder, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                                break;
                            }
                            default: {
                                boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION);
                                paymentForm = this.formFactory.form(SepaPaymentForm.class).fill((Object)new SepaPaymentForm(dsOpenOrder, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), allowRecipientRecording, useMandates, false));
                                break;
                            }
                        }
                    }
                    if (paymentObject instanceof DTAZVPayment) {
                        paymentForm = this.formFactory.form(DtazvPaymentForm.class).fill((Object)new DtazvPaymentForm(dsOpenOrder, (DTAZVPayment)paymentObject, allowRecipientRecording, false));
                    }
                    if (paymentObject instanceof MT101PaymentData) {
                        paymentForm = this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(dsOpenOrder, (MT101PaymentData)paymentObject, allowRecipientRecording, false));
                    }
                    return DesOverview.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("error", messages.at("desoverview.unknownpaymenttype", new Object[0]));
                }
                paymentForm = this.formFactory.form(HvtPaymentForm.class).fill((Object)new HvtPaymentForm(dsOpenOrder, paymentInfo.getHvtOrder()));
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to load payment information for open DES order " + id + ", page number: " + pageNumber + "!", e);
                return DesOverview.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToLoadPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        } else {
            BLLoggerPlay.warning("Page number out of range for order " + dsOpenOrder.getId());
            return DesOverview.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
        }
        int pageCount = paymentInfos.size();
        return DesOverview.ok((Content)despaymentdetails.render(dsOpenOrder, (Form<? extends PaymentForm>)paymentForm, pageNumber, pageCount, originalOrders, operation, request, messages));
    }

    public CompletionStage<Result> loadPayments(Http.Request request, String ids) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        List<Integer> orderIds = GeneralUtils.getSelectionIds(ids);
        return CompletableFuture.supplyAsync(() -> {
            ObjectNode result = Json.newObject();
            ArrayNode ordersArray = result.putArray("orders");
            boolean showSalaries = Util.displaySalaries((User)user);
            for (DsOpenOrder dsOpenOrder : DB.find(DsOpenOrder.class).where().in("id", (Collection)orderIds).findList()) {
                if (dsOpenOrder.getOrderData() == null && dsOpenOrder.getPaymentData() == null || !user.equals(dsOpenOrder.getBankUser().getUser()) || orderIds.size() > 1 && dsOpenOrder.getDatasize() != null && dsOpenOrder.getDatasize() >= 0xA00000L) continue;
                ObjectNode orderNode = ordersArray.addObject();
                orderNode.put("id", dsOpenOrder.getId());
                ArrayNode paymentsNode = orderNode.putArray("payments");
                for (DsOrderPaymentInfo paymentInfo : DsOrderPaymentInfo.loadForOpenOrder(dsOpenOrder)) {
                    ObjectNode paymentNode = paymentsNode.addObject();
                    if (paymentInfo.isSalaryPayment() && Util.hideSalariesCompletely((User)user)) {
                        paymentNode.put("hidden", true);
                        continue;
                    }
                    paymentNode.put("account", paymentInfo.getAccountName());
                    paymentNode.put("recipient", paymentInfo.getRecipient());
                    paymentNode.put("recipientAccount", paymentInfo.getRecipientAccount());
                    if (paymentInfo.getResult() != null) {
                        String color;
                        switch (paymentInfo.getResult()) {
                            case RCVC: {
                                String string = "table-success";
                                break;
                            }
                            case RVMC: {
                                String string = "table-warning";
                                break;
                            }
                            case RVNM: {
                                String string = "table-danger";
                                break;
                            }
                            case RVNA: {
                                String string = "table-info";
                                break;
                            }
                            default: {
                                String string = color = null;
                            }
                        }
                        if (color != null) {
                            paymentNode.put("color", color);
                        }
                        if (paymentInfo.getTooltip() != null) {
                            paymentNode.put("tooltip", Util.getShortVopResultDescription((String)paymentInfo.getResult().name(), (Locale)messages.lang().locale()) + ": " + paymentInfo.getTooltip());
                        } else {
                            paymentNode.put("tooltip", Util.getShortVopResultDescription((String)paymentInfo.getResult().name(), (Locale)messages.lang().locale()));
                        }
                    }
                    if (!paymentInfo.isSalaryPayment() || showSalaries) {
                        paymentNode.put("amount", Utils.formatAmount(paymentInfo.getAmount(), paymentInfo.getCurrency(), messages.lang().locale()));
                    }
                    paymentNode.put("purpose", paymentInfo.getPurpose());
                    paymentNode.put("date", DateFormat.getDateInstance(2, messages.lang().locale()).format(paymentInfo.getExecutionDate()));
                }
            }
            return DesOverview.ok((String)result.toString());
        }, this.executionContext.current());
    }

    public Result updateVopNamesPage(Http.Request request, String desOrderIds) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        List<Integer> edsOrderIdsList = GeneralUtils.getSelectionIds(desOrderIds);
        String referer = Utils.getHeaderValue(request, "referer");
        String redirectTo = referer != null ? referer : (edsOrderIdsList.size() == 1 ? routes.DesOverview.orderDetails(edsOrderIdsList.getFirst()).url() : routes.DesOverview.index().url());
        try {
            ArrayList<String> recipientIdsList = new ArrayList<String>();
            List orders = DB.find(DsOpenOrder.class).where().in("id", edsOrderIdsList).findList();
            for (DsOpenOrder dsOpenOrder : orders) {
                List<DsOrderPaymentInfo> infos = DsOrderPaymentInfo.loadForOpenOrder(dsOpenOrder);
                for (DsOrderPaymentInfo paymentInfo : infos) {
                    String accountNumber = paymentInfo.getRecipientAccount().replace(" ", "");
                    String recipientName = paymentInfo.getRecipient();
                    PaymentRecipient matchingRecipient = PaymentRecipient.findRecipientByAccountInfo((PaymentType)PaymentType.SEPA, (String)recipientName, (String)accountNumber, null, (Tenant)dsOpenOrder.getBankUser().getBank().getTenant());
                    if (matchingRecipient == null) continue;
                    recipientIdsList.add(matchingRecipient.getId().toString());
                }
            }
            if (recipientIdsList.isEmpty()) {
                return DesOverview.redirect((String)redirectTo).flashing("info", messages.at("recipients.vopNameUpdate.nothingToUpdate", new Object[0]));
            }
            return DesOverview.redirect((Call)routes.Recipients.updateVopNamesPage(String.join((CharSequence)",", recipientIdsList)));
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to load the VOP recipient name update page!", e);
            return DesOverview.redirect((String)redirectTo).flashing("HTMLerror", messages.at("recipients.vopNameUpdate.error", new Object[]{Utils.getLocalizedMessage(e, messages)}));
        }
    }

    public static boolean ordersContainVopCloseMatches(Collection<DsOpenOrder> orders) {
        for (DsOpenOrder dsOpenOrder : orders) {
            List<DsOrderPaymentInfo> infos = DsOrderPaymentInfo.loadForOpenOrder(dsOpenOrder);
            for (DsOrderPaymentInfo paymentInfo : infos) {
                if (!StatusCode.VopResultCodes.RVMC.equals((Object)paymentInfo.getResult())) continue;
                return true;
            }
        }
        return false;
    }

    public CompletionStage<Result> fetchPaymentDetails(Http.Request request, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            DsOpenOrder dsOpenOrder = (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)id);
            if (dsOpenOrder == null) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            if (!user.equals(dsOpenOrder.getBankUser().getUser())) {
                return DesOverview.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("error", messages.at("desoverview.nobankpermission", new Object[0]));
            }
            if (dsOpenOrder.getOrderData() == null) {
                try {
                    DesOverview.fetchOrderData(dsOpenOrder);
                }
                catch (EbicsException | IOException | GeneralSecurityException e) {
                    BLLoggerPlay.error("Failed to fetch DES payment details!", e);
                    String error = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToLoadPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)});
                    return DesOverview.redirect((Call)routes.DesOverview.orderDetails(id)).flashing("HTMLerror", error);
                }
            }
            return DesOverview.ok();
        }, this.executionContext.current());
    }

    public CompletionStage<Result> save(Http.Request request, String ids) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String referer = Utils.getHeaderValue(request, "referer");
        List<Integer> orderIds = GeneralUtils.getSelectionIds(ids);
        return CompletableFuture.supplyAsync(() -> {
            if (Branding.getBranding().hideSaveInDes()) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("warning", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.youHaveNoPermissionForThisPage", (Object[])new Object[0]));
            }
            List desOrders = DB.find(DsOpenOrder.class).where().in("id", (Collection)orderIds).findList();
            if (desOrders.isEmpty()) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            HashMap<DsOpenOrder, File> dataFileByOrder = new HashMap<DsOpenOrder, File>();
            for (DsOpenOrder desOrder : desOrders) {
                File orderDataFile;
                String permissionError;
                DesOverview.debugOrderDataLog(desOrder, "start download of order data from BL Banking Web to browser...");
                if (!user.equals(desOrder.getBankUser().getUser())) {
                    return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("desoverview.nobankpermission", new Object[0]));
                }
                if (desOrder.getDatasize() != null && desOrder.getDatasize() < 0xA00000L && (permissionError = DesOverview.checkOrderPermission(user, desOrder, messages)) != null) {
                    return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", permissionError);
                }
                if (desOrder.getOrderData() == null) {
                    DesOverview.debugOrderDataLog(desOrder, "order data not available in BL Banking Web, download from EBICS server...");
                    try {
                        orderDataFile = Util.createTempFile((String)"open_", (String)".HVT_original", (boolean)true);
                        OrderDetails orderDetails = DesOverview.buildHvzOrderDetails(desOrder);
                        OutputStream out = EncryptData.getInstance().openOutputStream(orderDataFile);
                        new DistributedSignature(EbicsUtil.getEbicsWorker(desOrder.getBankUser()).getEbicsSession()).fetchOrderFile(orderDetails, out);
                        DesOverview.debugOrderDataLog(desOrder, "successfully downloaded HVZ order details from EBICS server.");
                    }
                    catch (EbicsException | IOException | GeneralSecurityException e) {
                        BLLoggerPlay.error("Failed to fetch DES payment details!", e);
                        String error = BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToLoadPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)});
                        return DesOverview.redirect((String)referer).flashing("HTMLerror", error);
                    }
                } else {
                    DesOverview.debugOrderDataLog(desOrder, "order data is already available in BL Banking Web.");
                    orderDataFile = WorkspaceFileSystem.getFile((WorkspaceFile)desOrder.getOrderData());
                }
                if (!orderDataFile.isFile()) {
                    return DesOverview.redirect((String)referer).flashing("error", messages.at("desoverview.noorderdatafile", new Object[0]));
                }
                dataFileByOrder.put(desOrder, orderDataFile);
                if (Util.displaySalaries((User)user) || desOrder.getPmtType() == null || !SepaApi.isCreditPmtType((PaymentTransferType.PmtType)desOrder.getPmtType())) continue;
                InputStream inputStream = null;
                try {
                    inputStream = EncryptData.getInstance().openInputStream(orderDataFile);
                    for (PaymentHandler result : PaymentHandler.getHandlers(inputStream, desOrder.getPmtType(), desOrder.getBankUser().getBank().getCountryCode())) {
                        if (!result.isSalaryPayment()) continue;
                        Result result2 = DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.noPermissionToStoreSalaryPayments", (Object[])new Object[0]));
                        return result2;
                    }
                }
                catch (IOException | GeneralSecurityException | PaymentException e) {
                    Result result = DesOverview.redirect((String)referer).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToLoadPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
                    return result;
                }
                finally {
                    Util.closeStream((Closeable)inputStream);
                }
            }
            try {
                if (desOrders.size() == 1) {
                    File orderDataFile = (File)dataFileByOrder.get(desOrders.getFirst());
                    return GeneralUtils.supplyWorkspaceFile(orderDataFile, false, false).as("binary/octet-stream").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(orderDataFile.getName()));
                }
                ArrayList<File> fileList = new ArrayList<File>(dataFileByOrder.values());
                return GeneralUtils.supplyZipFile(fileList, false, false).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.orders", (Object[])new Object[0]) + ".zip"));
            }
            catch (IOException | GeneralSecurityException e) {
                return DesOverview.redirect((String)referer).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToLoadPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> signDesOrder(Http.Request request, int id) {
        return this.desOrderOperation(request, true, (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)id));
    }

    public CompletionStage<Result> cancelDesOrder(Http.Request request, int id) {
        return this.desOrderOperation(request, false, (DsOpenOrder)DB.find(DsOpenOrder.class, (Object)id));
    }

    private CompletionStage<Result> desOrderOperation(Http.Request request, boolean sign, DsOpenOrder dsOpenOrder) {
        Form passwordForm = this.formFactory.form(PasswordForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            if (dsOpenOrder == null) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            String bankOrderId = "EDS_" + dsOpenOrder.getId();
            if (!BankOrder.checkForDoubleTransmission(bankOrderId)) {
                return DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", messages.at("desoverview.signorders.error.double", new Object[]{sign ? 1 : 2}));
            }
            try {
                Form cancelPasswordForm;
                Form signPasswordForm;
                Form passwordResultForm;
                if (!user.equals(dsOpenOrder.getBankUser().getUser())) {
                    Result result = DesOverview.redirect((Call)routes.DesOverview.orderDetails(dsOpenOrder.getId())).flashing("error", "desoverview.nobankpermission");
                    return result;
                }
                if (!passwordForm.hasErrors()) {
                    passwordResultForm = ((PasswordForm)passwordForm.get()).checkPassword(passwordForm, user, PasswordForm.PasswordType.EBICS_PASSWORD, messages.lang().locale());
                    if (passwordResultForm.value().isPresent() && ((PasswordForm)passwordResultForm.value().get()).isUserLocked()) {
                        BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                        Result result = DesOverview.redirect((Call)routes.DesOverview.index()).flashing("error", "login.locked.user");
                        return result;
                    }
                } else {
                    passwordResultForm = passwordForm;
                }
                if (sign) {
                    signPasswordForm = passwordResultForm;
                    cancelPasswordForm = this.formFactory.form(PasswordForm.class);
                } else {
                    signPasswordForm = this.formFactory.form(PasswordForm.class);
                    cancelPasswordForm = passwordResultForm;
                }
                if (passwordResultForm.hasErrors()) {
                    ArrayList<DsOpenOrder> desOrders = new ArrayList<DsOpenOrder>();
                    desOrders.add(dsOpenOrder);
                    Result result = DesOverview.ok((Content)desdetails.render((Form<PasswordForm>)signPasswordForm, (Form<PasswordForm>)cancelPasswordForm, (Form<PaymentImportForm>)this.formFactory.form(PaymentImportForm.class), desOrders, sign, !sign, null, -1, WebAuthnData.buildForSigning(user), null, request, messages));
                    return result;
                }
                EbicsWorker worker = EbicsUtil.getEbicsWorker(dsOpenOrder.getBankUser(), ((PasswordForm)passwordForm.get()).password.toCharArray());
                DistributedSignature ds = new DistributedSignature(worker.getEbicsSession());
                this.signOrCancelOrder(ds, dsOpenOrder, sign, Setup.getIPAddress(request));
                String flashMessage = sign ? messages.at("desoverview.signed", new Object[]{1}) : messages.at("desoverview.cancelled", new Object[]{1});
                Result result = DesOverview.redirect((Call)routes.DesOverview.index()).flashing("success", flashMessage);
                return result;
            }
            finally {
                BankOrder.finishedBankOrder(bankOrderId);
            }
        }, this.executionContext.current());
    }

    public CompletionStage<Result> signDesOrders(Http.Request request) {
        return this.desOrdersOperation(request, true, null, (Call)routes.DesOverview.index(), null);
    }

    public CompletionStage<Result> cancelDesOrders(Http.Request request) {
        String operation = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text2;
        if (operation != null && operation.startsWith("CANCEL_FROM_SENT")) {
            return this.desOrdersOperation(request, false, null, (Call)routes.Sent.index(), null);
        }
        return this.desOrdersOperation(request, false, null, (Call)routes.DesOverview.index(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Result> cancelSentOrders(Http.Request request, Integer id) {
        String ids = id == -1 ? ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text : id.toString();
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String bankOrderId = "Sent_" + ids;
        play.api.mvc.Call redirectTo = routes.Sent.index();
        if (!BankOrder.checkForDoubleTransmission(bankOrderId)) {
            return CompletableFuture.supplyAsync(() -> DesOverview.redirect((Call)redirectTo).flashing("error", messages.at("desoverview.signorders.error.double", new Object[]{2})), this.executionContext.current());
        }
        try {
            List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
            List sentOrders = idsList.isEmpty() ? null : DB.find(Send.class).where().in("id", idsList).findList();
            if (sentOrders == null || sentOrders.isEmpty()) {
                String flashMessage = messages.at("desoverview.noorderstocancel", new Object[0]);
                CompletableFuture<Result> completableFuture = CompletableFuture.supplyAsync(() -> DesOverview.redirect((Call)redirectTo).flashing("error", flashMessage), this.executionContext.current());
                return completableFuture;
            }
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
            if (!permissionChecker.hasAccountPermissions(user, sentOrders)) {
                CompletableFuture<Result> completableFuture = CompletableFuture.supplyAsync(() -> DesOverview.redirect((Call)redirectTo).flashing("error", permissionChecker.getErrorMessage()), this.executionContext.current());
                return completableFuture;
            }
            HashMap<String, String> flashMap = new HashMap<String, String>();
            Map<Send, DsOpenOrder> desOrders = this.getDsOrdersForSendOrders(sentOrders, user, messages, flashMap);
            CompletionStage<Result> completionStage = this.desOrdersOperation(request, false, new ArrayList<DsOpenOrder>(desOrders.values()), (Call)redirectTo, flashMap);
            return completionStage;
        }
        catch (DesFetchException dfe) {
            CompletableFuture<Result> completableFuture = CompletableFuture.supplyAsync(() -> DesOverview.redirect((Call)redirectTo).flashing(dfe.getFlashMap()), this.executionContext.current());
            return completableFuture;
        }
        finally {
            BankOrder.finishedBankOrder(bankOrderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Result> cancelSignedPayments(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        String bankOrderId = "Signed_" + ids;
        play.api.mvc.Call redirectTo = routes.SignedPayments.index(false);
        if (!BankOrder.checkForDoubleTransmission(bankOrderId)) {
            return CompletableFuture.supplyAsync(() -> DesOverview.redirect((Call)redirectTo).flashing("error", messages.at("desoverview.signorders.error.double", new Object[]{2})), this.executionContext.current());
        }
        try {
            CompletableFuture<Result> completableFuture;
            List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
            List selectedPayments = idsList.isEmpty() ? null : DB.find(SignedPayment.class).where().in("id", idsList).findList();
            if (selectedPayments == null || selectedPayments.isEmpty()) {
                String flashMessage = messages.at("desoverview.noorderstocancel", new Object[0]);
                CompletableFuture<Result> completableFuture2 = CompletableFuture.supplyAsync(() -> DesOverview.redirect((Call)redirectTo).flashing("error", flashMessage), this.executionContext.current());
                return completableFuture2;
            }
            User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
            Set<Send> sentOrders = selectedPayments.stream().map(SignedPayment::getSend).collect(Collectors.toSet());
            OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
            if (!permissionChecker.hasAccountPermissions(user, sentOrders)) {
                CompletableFuture<Result> completableFuture3 = CompletableFuture.supplyAsync(() -> DesOverview.redirect((Call)redirectTo).flashing("error", permissionChecker.getErrorMessage()), this.executionContext.current());
                return completableFuture3;
            }
            HashMap<String, String> flashMap = new HashMap<String, String>();
            Map<Send, DsOpenOrder> desOrders = this.getDsOrdersForSendOrders(sentOrders, user, messages, flashMap);
            HashSet<SignedPayment> missingPayments = new HashSet<SignedPayment>();
            for (Send sentOrder : sentOrders) {
                if (!desOrders.containsKey(sentOrder)) continue;
                List paymentsInOrder = DB.find(SignedPayment.class).where().eq("send_id", (Object)sentOrder.getId()).findList();
                for (SignedPayment paymentInOrder : paymentsInOrder) {
                    if (selectedPayments.contains(paymentInOrder)) continue;
                    missingPayments.add(paymentInOrder);
                }
            }
            if (!missingPayments.isEmpty()) {
                Utils.addToFlash(flashMap, "warning", messages.at("signedpayments.cancel.confirm", new Object[0]));
                completableFuture = CompletableFuture.supplyAsync(() -> this.prepareDesOperation(request, PasswordForm.PasswordOperation.CANCEL, -1, new ArrayList<DsOpenOrder>(desOrders.values()), flashMap, redirectTo), this.executionContext.current());
                return completableFuture;
            }
            completableFuture = this.desOrdersOperation(request, false, new ArrayList<DsOpenOrder>(desOrders.values()), (Call)redirectTo, flashMap);
            return completableFuture;
        }
        catch (DesFetchException dfe) {
            CompletableFuture<Result> completableFuture = CompletableFuture.supplyAsync(() -> DesOverview.redirect((Call)redirectTo).flashing(dfe.getFlashMap()), this.executionContext.current());
            return completableFuture;
        }
        finally {
            BankOrder.finishedBankOrder(bankOrderId);
        }
    }

    private CompletionStage<Result> desOrdersOperation(Http.Request request, boolean sign, List<DsOpenOrder> ordersToOperate, Call redirectTo, Map<String, String> flashMap) {
        Form passwordForm = this.formFactory.form(PasswordForm.class).bindFromRequest(request, new String[0]);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            String bankOrderId = "EDS_" + ids;
            if (!BankOrder.checkForDoubleTransmission(bankOrderId)) {
                return DesOverview.redirect((Call)redirectTo).flashing("error", messages.at("desoverview.signorders.error.double", new Object[]{sign ? 1 : 2}));
            }
            try {
                Form passwordResultForm;
                DsOpenOrder dsOpenOrder2222;
                List orders;
                if (ordersToOperate == null) {
                    List<Integer> idsList = GeneralUtils.getSelectionIds(ids);
                    List ordersFromRequest = idsList.isEmpty() ? null : DB.find(DsOpenOrder.class).where().in("id", idsList).findList();
                    if (ordersFromRequest == null || ordersFromRequest.isEmpty()) {
                        String flashMessage = sign ? messages.at("desoverview.noorderstosign", new Object[0]) : messages.at("desoverview.noorderstocancel", new Object[0]);
                        Result result = DesOverview.redirect((Call)redirectTo).flashing("error", flashMessage);
                        return result;
                    }
                    orders = ordersFromRequest;
                } else {
                    orders = ordersToOperate;
                }
                HashMap<BankUser, List<DsOpenOrder>> ordersMap = new HashMap<BankUser, List<DsOpenOrder>>();
                for (DsOpenOrder dsOpenOrder2222 : orders) {
                    if (!user.equals(dsOpenOrder2222.getBankUser().getUser())) continue;
                    List bankDsOpenOrders = ordersMap.computeIfAbsent(dsOpenOrder2222.getBankUser(), k -> new ArrayList());
                    bankDsOpenOrders.add(dsOpenOrder2222);
                }
                if (!passwordForm.hasErrors()) {
                    passwordResultForm = ((PasswordForm)passwordForm.get()).checkPassword(passwordForm, user, PasswordForm.PasswordType.EBICS_PASSWORD, messages.lang().locale());
                    if (passwordResultForm.value().isPresent() && ((PasswordForm)passwordResultForm.value().get()).isUserLocked()) {
                        BLLoggerPlay.warning("User " + user.getName() + " was locked!");
                        dsOpenOrder2222 = DesOverview.redirect((Call)redirectTo).flashing("error", "login.locked.user");
                        return dsOpenOrder2222;
                    }
                } else {
                    passwordResultForm = passwordForm;
                }
                if (passwordResultForm.hasErrors()) {
                    dsOpenOrder2222 = this.errorPageForDesOrderOperations(request, user, ordersMap, passwordResultForm, sign, 0);
                    return dsOpenOrder2222;
                }
                int count = 0;
                for (BankUser bankUser : ordersMap.keySet()) {
                    Result iterator;
                    try {
                        DistributedSignature distributedSignature = new DistributedSignature(EbicsUtil.getEbicsWorker(bankUser, ((PasswordForm)passwordForm.get()).password.toCharArray()).getEbicsSession());
                        iterator = ((List)ordersMap.get(bankUser)).iterator();
                        while (iterator.hasNext()) {
                            this.signOrCancelOrder(distributedSignature, (DsOpenOrder)iterator.next(), sign, Setup.getIPAddress(request));
                            ++count;
                            iterator.remove();
                        }
                    }
                    catch (InvalidPasswordException e) {
                        iterator = this.errorPageForDesOrderOperations(request, user, ordersMap, (Form<PasswordForm>)passwordForm.withError("password", messages.at("general.passwordwrong", new Object[0])), sign, count);
                        BankOrder.finishedBankOrder(bankOrderId);
                        return iterator;
                    }
                    catch (EbicsException | IOException | GeneralSecurityException e) {
                        BLLoggerPlay.error("Failed to " + (sign ? "sign" : "cancel") + " orders " + ids, e);
                        String error = Utils.getLocalizedMessage(e, messages);
                        Result result = this.errorPageForDesOrderOperations(request, user, ordersMap, (Form<PasswordForm>)passwordForm.withGlobalError(error), sign, count);
                        BankOrder.finishedBankOrder(bankOrderId);
                        return result;
                    }
                }
                HashMap<String, String> flash2 = flashMap;
                if (flash2 == null) {
                    flash2 = new HashMap<String, String>();
                }
                String flashMessage = sign ? messages.at("desoverview.signed", new Object[]{count}) : messages.at("desoverview.cancelled", new Object[]{count});
                String flashKey = count == 0 ? "warning" : "success";
                Utils.addToFlash(flash2, flashKey, flashMessage);
                Result result = DesOverview.redirect((Call)redirectTo).flashing(flash2);
                return result;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                BankOrder.finishedBankOrder(bankOrderId);
            }
        }, this.executionContext.current());
    }

    private void signOrCancelOrder(DistributedSignature distributedSignature, DsOpenOrder openOrder, boolean sign, String ipAddress) throws EbicsException, IOException, GeneralSecurityException {
        File dataFile;
        String orderId;
        BankUser bankUser = openOrder.getBankUser();
        BankSettings bank = bankUser.getBank();
        OrderDetails orderDetails = DesOverview.buildHvzOrderDetails(openOrder);
        if (openOrder.getDigestHex() == null) {
            HVDResponseOrderData hvd = distributedSignature.getDetails(orderDetails);
            if (hvd != null && hvd.getDataDigest() != null) {
                openOrder.setDigestHex(HexTool.toHex((byte[])hvd.getDataDigest().getValue()));
                openOrder.save();
            } else {
                throw new GeneralSecurityException("desdetails.error.missingdigest");
            }
        }
        if (sign) {
            distributedSignature.sign(orderDetails, HexTool.fromHex((String)openOrder.getDigestHex()));
        } else {
            distributedSignature.cancel(orderDetails, HexTool.fromHex((String)openOrder.getDigestHex()));
        }
        HashSet<Account> accounts2 = new HashSet<Account>();
        for (DsOrderPaymentInfo paymentInfo : DsOrderPaymentInfo.loadForOpenOrder(openOrder)) {
            Account account;
            if (paymentInfo.getPayment() == null || (account = paymentInfo.getPayment().getOriginatorAccount(bank)) == null) continue;
            accounts2.add(account);
        }
        PaymentTransferType.PmtType pmtType = openOrder.getPmtType();
        boolean orderDataExistsForOpenOrder = false;
        Timestamp submissionDate = openOrder.getSubmissionDate();
        String orderOrFileType = openOrder.getFileType();
        List sendItems = Send.findByOrderDetails((BankSettings)bank, (String)orderOrFileType, (String)(orderId = openOrder.getOrderId()), (Timestamp)submissionDate);
        if (sendItems.size() == 1) {
            Send sendItem = (Send)sendItems.getFirst();
            if (openOrder.getOrderData() != null) {
                dataFile = WorkspaceFileSystem.getFile((WorkspaceFile)openOrder.getOrderData());
                orderDataExistsForOpenOrder = true;
            } else {
                dataFile = sendItem.getFile() != null ? WorkspaceFileSystem.getFile((WorkspaceFile)sendItem.getFile()) : null;
            }
            PaymentTransferType.PmtType newPmtType = sendItem.getPmtType();
            if (newPmtType != null) {
                pmtType = newPmtType;
            }
        } else {
            if (sendItems.size() > 1) {
                BLLoggerPlay.warning("Found multiple (" + sendItems.size() + ") Send items for DsOrderDetails with params: bankId=" + bank.getBankId() + ", orderId=" + orderId + ", order/fileType=" + orderOrFileType + ", submissionDime=" + String.valueOf(submissionDate));
            }
            if (openOrder.getOrderData() != null) {
                dataFile = WorkspaceFileSystem.getFile((WorkspaceFile)openOrder.getOrderData());
                orderDataExistsForOpenOrder = true;
            } else {
                dataFile = null;
            }
        }
        DsOrderDetails dsOrderDetails = LocalDSUtil.createDsOrder((BankSettings)bankUser.getBank(), (User)bankUser.getUser(), (OrderDetails)orderDetails, (byte[])openOrder.getTicket(), (File)dataFile, (DsOrderDetails.Type)(sign ? DsOrderDetails.Type.SIGNED : DsOrderDetails.Type.REJECTED), (boolean)true, (String)ipAddress);
        dsOrderDetails.setAccounts(new ArrayList(accounts2));
        dsOrderDetails.setPmtType(pmtType);
        dsOrderDetails.save();
        if (sign) {
            Logger.logEdsOrderSigned((User)bankUser.getUser(), (DsOpenOrder)openOrder);
        } else {
            Logger.logEdsOrderCancelled((User)bankUser.getUser(), (DsOpenOrder)openOrder);
        }
        if (orderDataExistsForOpenOrder) {
            WorkspaceFileSystem.delete((WorkspaceFile)openOrder.getOrderData());
        }
        DB.delete((Object)openOrder);
    }

    private Result errorPageForDesOrderOperations(Http.Request request, User user, Map<BankUser, List<DsOpenOrder>> ordersMap, Form<PasswordForm> passwordForm, boolean sign, int successfulCount) {
        Form cancelPasswordForm;
        Form signPasswordForm;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        HashMap<String, String> flash2 = new HashMap<String, String>();
        if (successfulCount > 0) {
            if (sign) {
                flash2.put("success", messages.at("desoverview.signed", new Object[]{successfulCount}));
            } else {
                flash2.put("success", messages.at("desoverview.cancelled", new Object[]{successfulCount}));
            }
        }
        if (new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.DS_QUICK_SIGN)) {
            Form cancelPasswordForm2;
            Form signPasswordForm2;
            SortingHandler sorting = new SortingHandler(user, Sorting.Table.DS_OPEN);
            if (sign) {
                signPasswordForm2 = passwordForm;
                cancelPasswordForm2 = this.formFactory.form(PasswordForm.class);
            } else {
                signPasswordForm2 = this.formFactory.form(PasswordForm.class);
                cancelPasswordForm2 = passwordForm;
            }
            SendFilter sendFilter = SendFilter.getFilter((User)user);
            Form filterForm = this.formFactory.form(SendFilterForm.class).fill((Object)new SendFilterForm(sendFilter, true));
            List list = this.defaultQuery(user, sendFilter, sorting).findList();
            return DesOverview.ok((Content)desoverview.render(list, this.transformOrdersMapToList(ordersMap), (Form<PasswordForm>)signPasswordForm2, (Form<PasswordForm>)cancelPasswordForm2, sorting, (Form<SendFilterForm>)filterForm, sendFilter, sign, !sign, WebAuthnData.buildForSigning(user), DesOverview.getLastDesFetchDateString(user, messages), (Form<PaymentImportForm>)this.formFactory.form(PaymentImportForm.class), request, this.messagesApi.preferred((Http.RequestHeader)request))).flashing(flash2);
        }
        if (sign) {
            signPasswordForm = passwordForm;
            cancelPasswordForm = this.formFactory.form(PasswordForm.class);
        } else {
            signPasswordForm = this.formFactory.form(PasswordForm.class);
            cancelPasswordForm = passwordForm;
        }
        return DesOverview.ok((Content)desdetails.render((Form<PasswordForm>)signPasswordForm, (Form<PasswordForm>)cancelPasswordForm, (Form<PaymentImportForm>)this.formFactory.form(PaymentImportForm.class), this.transformOrdersMapToList(ordersMap), sign, !sign, sign ? PasswordForm.PasswordOperation.SIGN : PasswordForm.PasswordOperation.CANCEL, -1, WebAuthnData.buildForSigning(user), null, request, this.messagesApi.preferred((Http.RequestHeader)request))).flashing(flash2);
    }

    private List<DsOpenOrder> transformOrdersMapToList(Map<BankUser, List<DsOpenOrder>> ordersMap) {
        ArrayList<DsOpenOrder> result = new ArrayList<DsOpenOrder>();
        for (BankUser bankUser : ordersMap.keySet()) {
            List<DsOpenOrder> orderList = ordersMap.get(bankUser);
            for (DsOpenOrder dsOpenOrder : orderList) {
                if (DB.find(DsOpenOrder.class, (Object)dsOpenOrder.getId()) == null) continue;
                result.add(dsOpenOrder);
            }
        }
        return result;
    }

    private Query<DsOpenOrder> defaultQuery(User user, SendFilter sendFilter, SortingHandler sorting) {
        Expression expr;
        boolean filterActive = sendFilter.isDsOverviewActive();
        int sortingColumn = sorting.getSortingColumn();
        boolean sortingAscending = sorting.isSortingAscending();
        BankSettings onlyThisBank = null;
        if (filterActive) {
            if (sendFilter.getBank() != null) {
                onlyThisBank = sendFilter.getBank();
            } else if (sendFilter.getAccount() != null && sendFilter.getAccount().getBank() != null) {
                onlyThisBank = sendFilter.getAccount().getBank();
            }
        }
        ArrayList<BankUser> bankUsersReady = new ArrayList<BankUser>();
        for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
            DsBank dsBank;
            if (bankUser.getState() != BankUser.UserState.READY || (dsBank = DsBank.get((BankSettings)bankUser.getBank())) != null && !dsBank.isActivated() || filterActive && onlyThisBank != null && !Objects.equals(bankUser.getBank().getBankId(), onlyThisBank.getBankId())) continue;
            bankUsersReady.add(bankUser);
        }
        if (bankUsersReady.isEmpty()) {
            return DB.find(DsOpenOrder.class).where().isNull("id").query();
        }
        Query query = bankUsersReady.size() == 1 ? DsOpenOrder.queryForBankUser((BankUser)((BankUser)bankUsersReady.getFirst())) : DsOpenOrder.queryForBankUsers(bankUsersReady);
        if (filterActive && !sendFilter.isEmpty(SendFilter.SendFilterType.DS_OVERVIEW) && (expr = sendFilter.getDsOverviewExpression()) != null) {
            query.where().add(expr);
        }
        String[] order = sortingColumn == 0 ? new String[]{"signable", "fileType", "orderId"} : (sortingColumn == 2 ? new String[]{"submissionDate"} : (sortingColumn == 3 ? new String[]{"customerId"} : (sortingColumn == 4 ? new String[]{"userName", "userId"} : (sortingColumn == 5 ? new String[]{"numSigDone", "numSigRequired"} : (sortingColumn == 6 ? new String[]{"amount"} : (sortingColumn == 7 ? new String[]{"datasize"} : (sortingColumn == 8 ? new String[]{"originator"} : (sortingColumn == 10 ? new String[]{"bankUser.bank.displayName", "fileType", "orderId"} : new String[]{"bankUser.bank.displayName", "fileType", "orderId"}))))))));
        for (String orderColumn : order) {
            if (sortingAscending) {
                query.orderBy().asc(orderColumn);
                continue;
            }
            query.orderBy().desc(orderColumn);
        }
        sorting.computeForQuery(query);
        return query;
    }

    public static String getLastDesFetchDateString(User forUser, Messages messages) {
        Timestamp date2 = forUser.getLastDesFetch();
        if (date2 == null) {
            return null;
        }
        return DateFormat.getDateTimeInstance(2, 2, messages.lang().locale()).format(date2);
    }

    private static OrderDetails buildHvzOrderDetails(DsOpenOrder dsOpenOrder) {
        String fileFormat;
        String orderType;
        boolean isH005OrNewer = BankUtils.isProtocolH005OrNewer((String)dsOpenOrder.getBankUser().getBank().getProtocolVersion());
        if (isH005OrNewer) {
            orderType = "BTU";
            fileFormat = dsOpenOrder.getFileType();
        } else if (dsOpenOrder.getBankUser().getBank().isFrenchBank()) {
            orderType = "FUL";
            fileFormat = dsOpenOrder.getFileType();
        } else {
            orderType = dsOpenOrder.getFileType();
            fileFormat = null;
        }
        HVUSigningInfo signingInfo = dsOpenOrder.getSigners() != null ? new HVUSigningInfo(true, dsOpenOrder.getNumSigRequired(), dsOpenOrder.getNumSigDone()) : null;
        Object result = dsOpenOrder.getDigestHex() == null ? (isH005OrNewer ? new OrderDetails(BTFTranslator.convertFrom((String)fileFormat), new OrderID(dsOpenOrder.getOrderId()), new IntegerElement(dsOpenOrder.getDatasize().longValue()), signingInfo, new HVUOriginatorInfo(new PartnerID(dsOpenOrder.getCustomerId()), new UserID(dsOpenOrder.getUserId()), dsOpenOrder.getUserName() == null ? null : new Name(dsOpenOrder.getUserName()), dsOpenOrder.getSubmissionDate() == null ? null : new TimeStamp((Date)dsOpenOrder.getSubmissionDate()))) : new OrderDetails(new OrderType(orderType), new OrderID(dsOpenOrder.getOrderId()), new IntegerElement(dsOpenOrder.getDatasize().longValue()), signingInfo, new HVUOriginatorInfo(new PartnerID(dsOpenOrder.getCustomerId()), new UserID(dsOpenOrder.getUserId()), dsOpenOrder.getUserName() == null ? null : new Name(dsOpenOrder.getUserName()), dsOpenOrder.getSubmissionDate() == null ? null : new TimeStamp((Date)dsOpenOrder.getSubmissionDate())))) : (isH005OrNewer ? new HVZOrderDetails(BTFTranslator.convertFrom((String)fileFormat), new OrderID(dsOpenOrder.getOrderId()), new DataDigest(HexTool.fromHex((String)dsOpenOrder.getDigestHex()), SignatureVersion.getInstance((String)dsOpenOrder.getBankUser().getSignatureVersion())), BooleanElement.getInstance((boolean)dsOpenOrder.isOrderDataAvailable()), new IntegerElement(dsOpenOrder.getDatasize().longValue()), BooleanElement.getInstance((boolean)dsOpenOrder.isOrderDataAvailable()), signingInfo, new HVUOriginatorInfo(new PartnerID(dsOpenOrder.getCustomerId()), new UserID(dsOpenOrder.getUserId()), dsOpenOrder.getUserName() == null ? null : new Name(dsOpenOrder.getUserName()), dsOpenOrder.getSubmissionDate() == null ? null : new TimeStamp((Date)dsOpenOrder.getSubmissionDate()))) : new HVZOrderDetails(new OrderType(orderType), new OrderID(dsOpenOrder.getOrderId()), new DataDigest(HexTool.fromHex((String)dsOpenOrder.getDigestHex()), SignatureVersion.getInstance((String)dsOpenOrder.getBankUser().getSignatureVersion())), BooleanElement.getInstance((boolean)dsOpenOrder.isOrderDataAvailable()), new IntegerElement(dsOpenOrder.getDatasize().longValue()), BooleanElement.getInstance((boolean)dsOpenOrder.isOrderDataAvailable()), signingInfo, new HVUOriginatorInfo(new PartnerID(dsOpenOrder.getCustomerId()), new UserID(dsOpenOrder.getUserId()), dsOpenOrder.getUserName() == null ? null : new Name(dsOpenOrder.getUserName()), dsOpenOrder.getSubmissionDate() == null ? null : new TimeStamp((Date)dsOpenOrder.getSubmissionDate()))));
        if (dsOpenOrder.getSigners() != null) {
            for (DsOpenOrderSigner signer : dsOpenOrder.getSigners()) {
                result.getSigners().add(new SignerInfo(new PartnerID(signer.getCustomerId()), new UserID(signer.getUserId()), signer.getUserName() != null ? new Name(signer.getUserName()) : null, new TimeStamp((Date)signer.getSignDate()), new SignerPermission(String.valueOf(signer.getPermission()))));
            }
        }
        if (result instanceof HVZOrderDetails && dsOpenOrder.getAmount() != null) {
            ((HVZOrderDetails)result).setTotalAmount(new HVZOrderDetails.TotalAmount(dsOpenOrder.getAmount()));
        }
        if (result instanceof HVZOrderDetails && dsOpenOrder.getAmountCurrency() != null) {
            ((HVZOrderDetails)result).setCurrency(new CurrencyBase(Currency.getInstance((String)dsOpenOrder.getAmountCurrency())));
        }
        if (fileFormat != null) {
            result.setFileFormat(new FileFormat(fileFormat));
        }
        if (dsOpenOrder.getAdditionalOrderInfo() != null) {
            result.setAdditionalOrderInfo(new String255Type(dsOpenOrder.getAdditionalOrderInfo()));
        }
        return result;
    }

    private static void fetchOrderDataIgnoreError(DsOpenOrder dsOpenOrder, String blLoggerMsg) {
        DesOverview.debugOrderDataLog(dsOpenOrder, "start fetching order data...");
        try {
            DesOverview.fetchOrderData(dsOpenOrder);
        }
        catch (EbicsException | IOException | GeneralSecurityException e) {
            BLLoggerPlay.error(blLoggerMsg, e);
        }
    }

    private static void fetchPaymentDataIgnoreError(DsOpenOrder dsOpenOrder, boolean updateRecipients) {
        try {
            DesOverview.fetchPaymentData(dsOpenOrder);
            if (updateRecipients) {
                Map<String, DsOrderPaymentInfo.VOPInfo> map = DsOrderPaymentInfo.loadFromHVTResponse(dsOpenOrder);
                List<PaymentType> allowedVopTypes = List.of(PaymentType.SEPA);
                for (DsOrderPaymentInfo.VOPInfo info : map.values()) {
                    PaymentRecipient recipient = PaymentRecipient.findRecipientByAccountInfo(allowedVopTypes, (String)info.getName(), (String)info.getIban(), null, List.of(dsOpenOrder.getBankUser().getBank().getTenant()));
                    if (recipient == null) continue;
                    recipient.setVopDate(new Timestamp(new Date().getTime()));
                    recipient.setVopResult(info.getResult().name());
                    recipient.setVopName(info.getComment());
                    DB.save((Object)recipient);
                }
            }
        }
        catch (EbicsException | IOException | GeneralSecurityException e) {
            BLLoggerPlay.error("Error fetching payment data", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchPaymentData(DsOpenOrder dsOpenOrder) throws IOException, EbicsException, GeneralSecurityException {
        OrderDetails orderDetails = DesOverview.buildHvzOrderDetails(dsOpenOrder);
        OutputStream dataFileOutputStream = null;
        try {
            File dsDirectory = LocalDSUtil.getDsDirectory();
            File bankDsDirector = new File(dsDirectory, dsOpenOrder.getBankUser().getBank().getUniqueKey());
            if (!bankDsDirector.isDirectory() && !bankDsDirector.mkdirs()) {
                throw new RuntimeException("Failed to create ds directory in workspace!");
            }
            if (dsOpenOrder.isPaymentDataAvailable()) {
                HVTResponseOrderData hvt = new DistributedSignature(EbicsUtil.getEbicsWorker(dsOpenOrder.getBankUser()).getEbicsSession()).fetchOrderDetails(orderDetails, 0, 0);
                File targetFile = File.createTempFile("open_", ".HVT", bankDsDirector);
                dataFileOutputStream = EncryptData.getInstance().openOutputStream(targetFile);
                new EbicsPrintStream(dataFileOutputStream).printOut((EbicsRootElement)hvt);
                dsOpenOrder.setPaymentData(WorkspaceFileSystem.createFile((WorkspaceFile.Prefix)WorkspaceFile.Prefix.DS, (File)targetFile, (long)targetFile.length(), null, null));
                dsOpenOrder.save();
                DesOverview.debugOrderDataLog(dsOpenOrder, "payment data saved succesfully.");
            } else {
                DesOverview.debugOrderDataLog(dsOpenOrder, "could not download payment data because paymentDataAvailable = false");
            }
        }
        finally {
            if (dataFileOutputStream != null) {
                try {
                    dataFileOutputStream.close();
                }
                catch (IOException e2) {
                    BLLoggerPlay.error("Failed to close output stream to data file!", e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fetchOrderData(DsOpenOrder dsOpenOrder) throws IOException, EbicsException, GeneralSecurityException {
        OrderDetails orderDetails = DesOverview.buildHvzOrderDetails(dsOpenOrder);
        OutputStream dataFileOutputStream = null;
        try {
            File dsDirectory = LocalDSUtil.getDsDirectory();
            File bankDsDirector = new File(dsDirectory, dsOpenOrder.getBankUser().getBank().getUniqueKey());
            if (!bankDsDirector.isDirectory() && !bankDsDirector.mkdirs()) {
                throw new RuntimeException("Failed to create ds directory in workspace!");
            }
            boolean orderChanged = false;
            if (dsOpenOrder.isOrderDataAvailable()) {
                File targetFile = File.createTempFile("open_", "." + BankOrder.getFileExtension((String)dsOpenOrder.getFileType()), bankDsDirector);
                dataFileOutputStream = EncryptData.getInstance().openOutputStream(targetFile);
                new DistributedSignature(EbicsUtil.getEbicsWorker(dsOpenOrder.getBankUser()).getEbicsSession()).fetchOrderFile(orderDetails, dataFileOutputStream);
                dsOpenOrder.setOrderData(WorkspaceFileSystem.createFile((WorkspaceFile.Prefix)WorkspaceFile.Prefix.DS, (File)targetFile, (long)targetFile.length(), null, null));
                orderChanged = true;
                DesOverview.debugOrderDataLog(dsOpenOrder, "order data saved successfully.");
            } else {
                DesOverview.debugOrderDataLog(dsOpenOrder, "could not download payment data because orderDataAvailable = false");
            }
            if (dsOpenOrder.isPaymentDataAvailable() && dsOpenOrder.getPaymentData() == null) {
                HVTResponseOrderData hvt = new DistributedSignature(EbicsUtil.getEbicsWorker(dsOpenOrder.getBankUser()).getEbicsSession()).fetchOrderDetails(orderDetails, 0, 0);
                File targetFile = File.createTempFile("open_", ".HVT", bankDsDirector);
                dataFileOutputStream = EncryptData.getInstance().openOutputStream(targetFile);
                new EbicsPrintStream(dataFileOutputStream).printOut((EbicsRootElement)hvt);
                dsOpenOrder.setPaymentData(WorkspaceFileSystem.createFile((WorkspaceFile.Prefix)WorkspaceFile.Prefix.DS, (File)targetFile, (long)targetFile.length(), null, null));
                orderChanged = true;
                DesOverview.debugOrderDataLog(dsOpenOrder, "payment data saved succesfully.");
            } else if (!dsOpenOrder.isPaymentDataAvailable()) {
                DesOverview.debugOrderDataLog(dsOpenOrder, "could not download payment data because paymentDataAvailable = false");
            }
            if (orderChanged) {
                dsOpenOrder.save();
            }
        }
        finally {
            if (dataFileOutputStream != null) {
                try {
                    dataFileOutputStream.close();
                }
                catch (IOException e2) {
                    BLLoggerPlay.error("Failed to close output stream to data file!", e2);
                }
            }
        }
    }

    public static String checkOrderPermission(User user, DsOpenOrder dsOpenOrder, Messages messages) {
        if (dsOpenOrder.getOrderData() == null) {
            DesOverview.fetchOrderDataIgnoreError(dsOpenOrder, "Failed to fetch DES payment details!");
        }
        List<DsOrderPaymentInfo> paymentInfos = DsOrderPaymentInfo.loadForOpenOrder(dsOpenOrder);
        Set paymentAccounts = paymentInfos.stream().map(DsOrderPaymentInfo::getAccount).collect(Collectors.toSet());
        OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
        if (!permissionChecker.hasAccountPermissions(user, dsOpenOrder, paymentAccounts)) {
            return permissionChecker.getErrorMessage();
        }
        return null;
    }

    private Map<Send, DsOpenOrder> getDsOrdersForSendOrders(Collection<Send> sendOrders, User user, Messages messages, Map<String, String> flashMap) throws DesFetchException {
        boolean finished = false;
        int nTries = 0;
        HashMap<Send, DsOpenOrder> desOrders = null;
        while (!finished && nTries < 2) {
            ++nTries;
            boolean needToFetchDES = false;
            desOrders = new HashMap<Send, DsOpenOrder>();
            for (Send sentOrder : sendOrders) {
                BankUser bankUser = BankUser.findBankUser((BankSettings)sentOrder.getBank(), (User)user);
                List desOrderCandidates = DB.find(DsOpenOrder.class).where().eq("bank_user_id", (Object)bankUser.getId()).eq("order_id", (Object)sentOrder.getOrderNumber()).or(Expr.eq((String)"file_type", (Object)sentOrder.getOrderType()), Expr.eq((String)"file_type", (Object)sentOrder.getFileTypeOrBTF())).findList();
                int nResults = desOrderCandidates.size();
                if (nResults == 0) {
                    needToFetchDES = true;
                    continue;
                }
                if (nResults == 1) {
                    desOrders.put(sentOrder, (DsOpenOrder)desOrderCandidates.getFirst());
                    continue;
                }
                DsOpenOrder desOrder = (DsOpenOrder)desOrderCandidates.stream().min((order1, order2) -> {
                    long delta1 = Math.abs(order1.getSubmissionDate().getTime() - sentOrder.getSent().getTime());
                    long delta2 = Math.abs(order2.getSubmissionDate().getTime() - sentOrder.getSent().getTime());
                    return Long.compare(delta1, delta2);
                }).get();
                desOrders.put(sentOrder, desOrder);
            }
            if (needToFetchDES) {
                Map<String, String> errorFlashMap = DesOverview.fetchDesOverviewSync(user, messages);
                if (errorFlashMap.get("error") == null) continue;
                throw new DesFetchException(flashMap);
            }
            finished = true;
        }
        if (flashMap != null) {
            int nSelectedTotal = sendOrders.size();
            int nFound = desOrders.size();
            if (nFound < nSelectedTotal) {
                int nMissing = nSelectedTotal - nFound;
                if (nSelectedTotal == 1) {
                    Utils.addToFlash(flashMap, "warning", messages.at("desdetails.cancelorder.notallcancelled.single", new Object[0]));
                } else {
                    Utils.addToFlash(flashMap, "warning", messages.at("desdetails.cancelorder.notallcancelled.multi", new Object[]{nMissing, nSelectedTotal}));
                }
            }
        }
        return desOrders;
    }

    private static void debugOrderDataLog(DsOpenOrder dsOpenOrder, String logEntry) {
        if (Setup.LOG_DES_DATA_AVAILABILITY) {
            try {
                BLLoggerPlay.info("DsOpenOrder " + dsOpenOrder.getId() + ": " + logEntry);
            }
            catch (Exception e) {
                BLLoggerPlay.warning("Exception occurred while trying to log DES data availability debug entry: " + e.getMessage());
            }
        }
    }

    private static final class OrderDetailsComparator
    implements Comparator<OrderDetails> {
        private final int sortColumn;
        private final boolean sortAscending;

        public OrderDetailsComparator(User user) {
            Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)Sorting.Table.DS_OPEN);
            this.sortColumn = sorting.getSortingColumn() == null ? 0 : sorting.getSortingColumn();
            this.sortAscending = sorting.isSortAscending();
        }

        @Override
        public int compare(OrderDetails o1, OrderDetails o2) {
            int result = this.checkForNull(o1, o2, () -> {
                if (this.sortColumn == 1) {
                    return this.checkForNull(o1.getOriginatorInfo(), o2.getOriginatorInfo(), () -> this.checkForNull(o1.getOriginatorInfo().getTimestamp(), o2.getOriginatorInfo().getTimestamp(), () -> o1.getOriginatorInfo().getTimestamp().getDate().compareTo(o2.getOriginatorInfo().getTimestamp().getDate())));
                }
                if (this.sortColumn == 2) {
                    return this.checkForNull(o1.getOriginatorInfo(), o2.getOriginatorInfo(), () -> this.checkForNull(o1.getOriginatorInfo().getPartnerID(), o2.getOriginatorInfo().getPartnerID(), () -> o1.getOriginatorInfo().getPartnerID().getValue().compareTo(o2.getOriginatorInfo().getPartnerID().getValue())));
                }
                if (this.sortColumn == 3) {
                    return this.checkForNull(o1.getOriginatorInfo(), o2.getOriginatorInfo(), () -> {
                        int lambdaResult = this.checkForNull(o1.getOriginatorInfo().getUserID(), o2.getOriginatorInfo().getUserID(), () -> o1.getOriginatorInfo().getUserID().getValue().compareTo(o2.getOriginatorInfo().getUserID().getValue()));
                        if (lambdaResult == 0) {
                            return this.checkForNull(o1.getOriginatorInfo().getName(), o2.getOriginatorInfo().getName(), () -> o1.getOriginatorInfo().getName().getValue().compareTo(o2.getOriginatorInfo().getName().getValue()));
                        }
                        return lambdaResult;
                    });
                }
                if (this.sortColumn == 4 && o1 instanceof HVZOrderDetails && o2 instanceof HVZOrderDetails) {
                    return this.checkForNull(((HVZOrderDetails)o1).getTotalAmount(), ((HVZOrderDetails)o2).getTotalAmount(), () -> ((HVZOrderDetails)o1).getTotalAmount().getValue().compareTo(((HVZOrderDetails)o2).getTotalAmount().getValue()));
                }
                if (this.sortColumn == 5) {
                    return this.checkForNull(o1.getOrderDataSize(), o2.getOrderDataSize(), () -> o1.getOrderDataSize().intValue() - o2.getOrderDataSize().intValue());
                }
                if (this.sortColumn == 6 && o1 instanceof HVZOrderDetails && o2 instanceof HVZOrderDetails) {
                    return this.checkForNull(((HVZOrderDetails)o1).getFirstOrderInfo(), ((HVZOrderDetails)o2).getFirstOrderInfo(), () -> this.checkForNull(((HVZOrderDetails)o1).getFirstOrderInfo().getOrderPartyInfo(), ((HVZOrderDetails)o2).getFirstOrderInfo().getOrderPartyInfo(), () -> ((HVZOrderDetails)o1).getFirstOrderInfo().getOrderPartyInfo().getValue().compareTo(((HVZOrderDetails)o2).getFirstOrderInfo().getOrderPartyInfo().getValue())));
                }
                int lambdaResult = o1.isH004AndBelow() ? this.checkForNull(o1.getOrderType(), o2.getOrderType(), () -> o1.getOrderType().getValue().compareTo(o2.getOrderType().getValue())) : this.checkForNull(o1.getService(), o2.getService(), () -> o1.getService().toString().compareTo(o2.getService().toString()));
                if (lambdaResult == 0 && (lambdaResult = this.checkForNull(o1.getFileFormat(), o2.getFileFormat(), () -> o1.getFileFormat().getValue().compareTo(o2.getFileFormat().getValue()))) == 0) {
                    lambdaResult = this.checkForNull(o1.getOrderID(), o2.getOrderID(), () -> o1.getOrderID().getValue().compareTo(o2.getOrderID().getValue()));
                }
                return lambdaResult;
            });
            if (!this.sortAscending) {
                result *= -1;
            }
            return result;
        }

        private int checkForNull(Object o1, Object o2, Supplier<Integer> notNullOp) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return notNullOp.get();
        }
    }

    private static class DesFetchException
    extends Exception {
        private final Map<String, String> flashMap;

        public DesFetchException(Map<String, String> flashMap) {
            this.flashMap = flashMap;
        }

        public Map<String, String> getFlashMap() {
            return this.flashMap;
        }
    }

    public static class WebDataFilePrintHandler
    implements DSPrinter.DataFilePrintHandler {
        private final User user;
        private final Messages messages;

        public WebDataFilePrintHandler(Messages messages, User user) {
            this.messages = messages;
            this.user = user;
        }

        public void printDataFileInfo(BLDocument document, File dataFile, BankSettings bankSettings, String orderType, boolean newPage, Locale locale) throws PDFException, IOException {
            try {
                PaymentTransferType.PmtType pmtType = SendParameters.getPmtType((BankSettings)bankSettings, (String)orderType);
                if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
                    SepaDetailsPrinter.addCreditToDocument((File)dataFile, (BLDocument)document, (boolean)newPage, (Locale)locale, (User)this.user);
                } else if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
                    SepaDetailsPrinter.addDebitToDocument((File)dataFile, (BLDocument)document, (boolean)newPage, (Locale)locale, (User)this.user);
                } else if (DtazvApi.isDtazvPmtType((PaymentTransferType.PmtType)pmtType)) {
                    DtazvDetailsPrinter.printPaymentInformation((File)dataFile, (BLDocument)document, (Locale)locale, (boolean)newPage);
                } else if (MT101Api.isMt101PmtType((PaymentTransferType.PmtType)pmtType)) {
                    MT101DetailsPrinter.addToDocument((File)dataFile, (BLDocument)document, (boolean)newPage, (Locale)this.messages.lang().locale());
                }
            }
            catch (PDFException | IOException e) {
                throw e;
            }
            catch (Exception e) {
                BLLoggerPlay.error("Failed to print payment information to send report!", e);
            }
        }
    }
}

