/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.DatabaseConnection;
import controllers.DesOverview;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.OrderPermissionChecker;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DSPrinter;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.ProtocolPrinter;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.SendOrderNameHandler;
import de.businesslogics.banking.api.SendStateUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.api.dta.DTAZVPaymentCsvExport;
import de.businesslogics.banking.api.sepa.SEPAPaymentDataCsvExport;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.DsSigningInfo;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.HVTOrderInfo;
import de.businesslogics.ebics.schema.orders.HVTResponseOrderData;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.persistence.DBType;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import io.ebean.Query;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.AustrianForeignPaymentForm;
import models.DtazvPaymentForm;
import models.HvtPaymentForm;
import models.Mt101PaymentForm;
import models.PaymentForm;
import models.PostbarPaymentForm;
import models.SendFilterForm;
import models.SepaPaymentForm;
import models.TaxOfficePaymentForm;
import models.payments.AustrianForeignPaymentHandler;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PostbarPaymentHandler;
import models.payments.TaxOfficePaymentHandler;
import org.xml.sax.SAXException;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.orders.deshistory;
import views.html.orders.deshistorydetails;
import views.html.orders.deshistorypaymentdetails;

@Security.Authenticated(value=AuthenticatorFor.DES.class)
public final class DesHistory
extends Controller {
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static String getSignatures(DsOrderDetails order, Messages messages) {
        int required;
        int done = order.getNumSigDone() != null ? order.getNumSigDone() : 0;
        int n = required = order.getNumSigRequired() != null ? order.getNumSigRequired() : 1;
        if (done < order.getSigningInfos().size()) {
            required = done = order.getSigningInfos().size();
        }
        return MessageFormat.format(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.numsignature", (Object[])new Object[0]), done, required);
    }

    public static String getState(DsOrderDetails order, Messages messages) {
        Locale locale = messages.lang().locale();
        String errorMsg = null;
        if (order.getErrorCode() != null && !order.getErrorCode().isEmpty()) {
            if (Character.isDigit(order.getErrorCode().charAt(0))) {
                Result result = Result.getInstance((int)Integer.parseInt(order.getErrorCode()));
                if (result != null) {
                    errorMsg = result.toString(locale);
                }
            } else {
                errorMsg = HAC30Entry.getReasonMessage((Locale)locale, (String)order.getErrorCode(), (HAC30Entry.Action)HAC30Entry.Action.FILE_UPLOAD);
            }
        }
        return SendStateUtil.getStateFilterText((DsOrderDetails.State)order.getState(), errorMsg, (Locale)locale);
    }

    public static String getProtocolAction(HacEntry hac, Locale locale) {
        if (hac.getAction() == null || hac.getAction() < 0 || hac.getAction() >= HAC30Entry.Action.values().length) {
            return "";
        }
        return HAC30Entry.getActionRepresentation((Locale)locale, (HAC30Entry.Action)HAC30Entry.Action.values()[hac.getAction()]);
    }

    public static String getHACActionUser(HacEntry hac) {
        String hacUserDefaultName = hac.getUserRepresentation();
        User hacUser = BankUser.findLoginUserByUserIdAndCustomerId((BankSettings)hac.getBank(), (String)hac.getUserId(), (String)hac.getCustomerId());
        if (hacUser != null) {
            return hacUser.getName() + " (" + hacUserDefaultName + ")";
        }
        return hacUserDefaultName;
    }

    public static String getProtocolReason(HacEntry hac, Locale locale) {
        HAC30Entry.Action action = hac.getAction() == null || hac.getAction() < 0 || hac.getAction() >= HAC30Entry.Action.values().length ? null : HAC30Entry.Action.values()[hac.getAction()];
        String result = HAC30Entry.getReasonMessage((Locale)locale, (String)hac.getReason(), action);
        return Objects.requireNonNullElse(result, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short showPaymentDetailsAndSaveButtons(DsOrderDetails dsOrderDetails, User user) {
        boolean showDetailsButton = true;
        int showSaveButton = 2;
        short show = 3;
        if (dsOrderDetails == null || dsOrderDetails.getDataFile() == null) {
            return 0;
        }
        if (user == null) {
            return 0;
        }
        Tenant tenant = dsOrderDetails.getBank().getTenant();
        if (!PaymentHandler.isHandlerPresent(dsOrderDetails.getPmtType()) || !new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user, tenant).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_DISPLAY_DETAILS)) {
            show = (short)(show - 1);
        }
        if (Util.displaySalaries((User)user) || dsOrderDetails.getPmtType() != null && !SepaApi.isCreditPmtType((PaymentTransferType.PmtType)dsOrderDetails.getPmtType())) {
            return show;
        }
        File file2 = WorkspaceFileSystem.getFile((WorkspaceFile)dsOrderDetails.getDataFile());
        if (!file2.isFile()) {
            return 0;
        }
        InputStream inputStream = null;
        try {
            inputStream = EncryptData.getInstance().openInputStream(file2);
            boolean foundSalaryPayment = false;
            for (PaymentHandler<?> handler : PaymentHandler.getHandlers(inputStream, dsOrderDetails.getPmtType(), dsOrderDetails.getBank().getCountryCode())) {
                if (!handler.isSalaryPayment()) continue;
                foundSalaryPayment = true;
                break;
            }
            if (foundSalaryPayment) {
                if (Util.hideSalariesCompletely((User)user)) {
                    short s = 0;
                    return s;
                }
                short s = show = (short)(show - 2);
                return s;
            }
            short s = show;
            return s;
        }
        catch (IOException | GeneralSecurityException | PaymentException e) {
            BLLoggerPlay.error("Failed to load payment details for DES order " + dsOrderDetails.getId(), e);
            short s = 2;
            return s;
        }
        finally {
            Util.closeStream((Closeable)inputStream);
        }
    }

    public static String loadIndexJsParameters(Messages messages, boolean signed, List<DsOrderDetails> edsList) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("fetchingMessage", messages.at("deshistory.fetching", new Object[0]));
        ObjectNode node = resultJson.putObject("deleteTitle");
        node.put("none", messages.at("deshistory.delete.title", new Object[]{0}));
        node.put("single", messages.at("deshistory.delete.title", new Object[]{1}));
        node.put("multiple", messages.at("deshistory.delete.title", new Object[]{999}));
        node = resultJson.putObject("deleteQuestion");
        node.put("none", messages.at("deshistory.delete.question", new Object[]{0}));
        node.put("single", messages.at("deshistory.delete.question", new Object[]{1}));
        node.put("multiple", messages.at("deshistory.delete.question", new Object[]{999}));
        resultJson.put("refreshLink", routes.Sent.update().toString());
        resultJson.put("indexLink", routes.DesHistory.index(signed).toString());
        resultJson.put("addDecimalsUrl", routes.Application.addSumsWithCurrencyDecimals().toString());
        if (edsList != null && !edsList.isEmpty()) {
            ArrayNode sendItemsNode = resultJson.putArray("paymentInfos");
            for (DsOrderDetails sent2 : edsList) {
                ObjectNode sendItemNode = sendItemsNode.addObject();
                sendItemNode.put("id", sent2.getId());
                if (sent2.getAmount() != null) {
                    sendItemNode.put("amount", sent2.getAmount().toPlainString());
                }
                sendItemNode.put("currency", sent2.getAmountCurrency());
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    @Inject
    public DesHistory(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public play.mvc.Result index(Http.Request request, boolean signed) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SendFilter sendFilter = SendFilter.getFilter((User)user);
        Form filterForm = this.formFactory.form(SendFilterForm.class).fill((Object)new SendFilterForm(sendFilter, true));
        return this.internalIndex(request, signed, user, (Form<SendFilterForm>)filterForm, sendFilter);
    }

    public play.mvc.Result indexSort(Http.Request request, int sort, boolean asc, boolean signed) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = signed ? new SortingHandler(user, Sorting.Table.DS_SIGNED) : new SortingHandler(user, Sorting.Table.DS_REJECTED);
        sorting.updateSort(sort, asc);
        return DesHistory.redirect((Call)routes.DesHistory.index(signed));
    }

    public play.mvc.Result indexPage(Http.Request request, int pageNumber, int pageSize, boolean signed) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SortingHandler sorting = signed ? new SortingHandler(user, Sorting.Table.DS_SIGNED) : new SortingHandler(user, Sorting.Table.DS_REJECTED);
        sorting.updatePage(pageNumber, pageSize);
        return DesHistory.redirect((Call)routes.DesHistory.index(signed));
    }

    public play.mvc.Result filterSigned(Http.Request request, boolean active) {
        return this.internalFilter(request, true, active);
    }

    public play.mvc.Result filterRejected(Http.Request request, boolean active) {
        return this.internalFilter(request, false, active);
    }

    public play.mvc.Result details(Http.Request request, boolean signed, Integer id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        DsOrderDetails order = (DsOrderDetails)DB.find(DsOrderDetails.class, (Object)id);
        if (order == null) {
            return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
        }
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
        if (!permissionChecker.hasAccountPermissions(user, order)) {
            return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", permissionChecker.getErrorMessage());
        }
        if (BankUser.findBankUser((BankSettings)order.getBank(), (User)user) == null) {
            return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("desoverview.nobankpermission", new Object[0]));
        }
        List hacs = ProtocolUtil.getHacEntries((DsOrderDetails)order).findList();
        List ptks = hacs.isEmpty() ? ProtocolUtil.getPtkEntries((DsOrderDetails)order).findList() : null;
        return DesHistory.ok((Content)deshistorydetails.render(order, signed, hacs, ptks, request, messages));
    }

    public CompletionStage<play.mvc.Result> print(Http.Request request, boolean signed, String ids) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        List<Integer> orderIds = GeneralUtils.getSelectionIds(ids);
        return CompletableFuture.supplyAsync(() -> {
            List<DsOrderDetails> orders = orderIds.stream().map(id -> (DsOrderDetails)DB.find(DsOrderDetails.class, (Object)id)).filter(Objects::nonNull).toList();
            if (orders.isEmpty()) {
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            for (DsOrderDetails dsOrderDetails : orders) {
                OrderPermissionChecker orderPermissionChecker = new OrderPermissionChecker(messages.lang().locale());
                if (orderPermissionChecker.hasAccountPermissions(user, dsOrderDetails)) continue;
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", orderPermissionChecker.getErrorMessage());
            }
            HashMap signersByOrder = new HashMap();
            for (DsOrderDetails dsOrderDetails : orders) {
                ArrayList<DSPrinter.UserInfo> arrayList = new ArrayList<DSPrinter.UserInfo>();
                signersByOrder.put(dsOrderDetails, arrayList);
                if (dsOrderDetails.getSigningInfos() == null) continue;
                for (DsSigningInfo signer : dsOrderDetails.getSigningInfos()) {
                    arrayList.add(new DSPrinter.UserInfo(signer));
                }
            }
            HashMap<DsOrderDetails, void> hashMap = new HashMap<DsOrderDetails, void>();
            for (DsOrderDetails dsOrderDetails : orders) {
                void var9_25;
                Object var9_22 = null;
                if (dsOrderDetails.getTicket() != null) {
                    try {
                        String string = new String(dsOrderDetails.getTicket(), "ISO-8859-15");
                    }
                    catch (UnsupportedEncodingException e) {
                        String string = new String(dsOrderDetails.getTicket());
                    }
                }
                hashMap.put(dsOrderDetails, var9_25);
            }
            HashMap<DsOrderDetails, File> hashMap2 = new HashMap<DsOrderDetails, File>();
            for (DsOrderDetails dsOrderDetails : orders) {
                File dataFile = dsOrderDetails.getDataFile() != null ? WorkspaceFileSystem.getFile((WorkspaceFile)dsOrderDetails.getDataFile()) : null;
                hashMap2.put(dsOrderDetails, dataFile);
            }
            try {
                HashMap<DsOrderDetails, File> hashMap3 = new HashMap<DsOrderDetails, File>();
                for (DsOrderDetails dsOrderDetails : orders) {
                    boolean printLogo = GeneralUtils.printLogo(user);
                    File file2 = DSPrinter.print((String)dsOrderDetails.getFileType(), (String)dsOrderDetails.getOrderId(), (DSPrinter.UserInfo)new DSPrinter.UserInfo(dsOrderDetails), (List)((List)signersByOrder.get(dsOrderDetails)), (String)((String)hashMap.get(dsOrderDetails)), (BankSettings)dsOrderDetails.getBank(), (File)((File)hashMap2.get(dsOrderDetails)), (DSPrinter.DataFilePrintHandler)new DesOverview.WebDataFilePrintHandler(messages, user), (User)user, (Locale)messages.lang().toLocale(), (boolean)printLogo, (SendOrderNameHandler)new SendOrderNameHandler(user), null, (String)dsOrderDetails.getAdditionalOrderInfo(), (dsOrderDetails.getType() == DsOrderDetails.Type.REJECTED ? 1 : 0) != 0);
                    String prefix = dsOrderDetails.getFileType() + "-" + dsOrderDetails.getOrderId();
                    Util.applyPreferencesToPdf((File)file2, (User)user, (String)prefix, (Locale)messages.lang().toLocale(), null, null, (boolean)printLogo);
                    hashMap3.put(dsOrderDetails, file2);
                }
                if (orders.size() == 1) {
                    File file2 = (File)hashMap3.get(orders.get(0));
                    return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
                }
                ArrayList<File> arrayList = new ArrayList<File>(hashMap3.values());
                return GeneralUtils.supplyZipFile(arrayList, true, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.orders", (Object[])new Object[0]) + ".zip"));
            }
            catch (PDFException | IOException | GeneralSecurityException throwable) {
                BLLoggerPlay.error("Failed to print locale DS order!", throwable);
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("HTMLerror", messages.at("desoverview.printfailed", new Object[]{Utils.getLocalizedMessage(throwable, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<play.mvc.Result> printProtocol(Http.Request request, boolean signed, int id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            String protocolName;
            List ptks;
            DsOrderDetails dsOrderDetails = (DsOrderDetails)DB.find(DsOrderDetails.class, (Object)id);
            if (dsOrderDetails == null) {
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
            if (!permissionChecker.hasAccountPermissions(user, dsOrderDetails)) {
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", permissionChecker.getErrorMessage());
            }
            List hacs = ProtocolUtil.getHacEntries((DsOrderDetails)dsOrderDetails).findList();
            if (hacs.isEmpty()) {
                ptks = ProtocolUtil.getPtkEntries((DsOrderDetails)dsOrderDetails).findList();
                protocolName = "PTKReport";
            } else {
                ptks = null;
                protocolName = "HACReport";
            }
            ProtocolPrinter printer = new ProtocolPrinter(protocolName, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.protocolOfOrder", (Object[])new Object[]{dsOrderDetails.getFileType(), dsOrderDetails.getOrderId()}));
            boolean printLogo = GeneralUtils.printLogo(user);
            try {
                File file2;
                try {
                    file2 = printer.createDocument(messages.lang().toLocale(), false, printLogo);
                    for (HacEntry hac : hacs) {
                        printer.addHac(hac);
                    }
                    if (ptks != null) {
                        for (PtkEntry ptk : ptks) {
                            printer.addPtk(ptk);
                        }
                    }
                }
                finally {
                    try {
                        printer.close();
                    }
                    catch (IOException e) {
                        BLLoggerPlay.error("Failed to create PDF file for protocol!", e);
                    }
                }
                try {
                    Util.applyPreferencesToPdf((File)file2, (User)user, null, (Locale)messages.lang().toLocale(), null, null, (boolean)printLogo);
                }
                catch (PDFException | IOException e) {
                    BLLoggerPlay.error("Failed to apply preferences for protocol PDF!", e);
                }
                return GeneralUtils.supplyWorkspaceFile(file2, true, true).as("application/pdf").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(file2.getName()));
            }
            catch (PDFException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to create PDF file for protocol!", e);
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("HTMLerror", messages.at("sent.protocol.print.failed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<play.mvc.Result> save(Http.Request request, boolean signed, String ids) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        List<Integer> orderIds = GeneralUtils.getSelectionIds(ids);
        return CompletableFuture.supplyAsync(() -> {
            List<DsOrderDetails> orders = orderIds.stream().map(id -> (DsOrderDetails)DB.find(DsOrderDetails.class, (Object)id)).filter(Objects::nonNull).toList();
            if (orders.isEmpty()) {
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
            }
            HashMap<DsOrderDetails, File> dataFileByOrder = new HashMap<DsOrderDetails, File>();
            for (DsOrderDetails dsOrderDetails : orders) {
                OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
                if (!permissionChecker.hasAccountPermissions(user, dsOrderDetails)) {
                    return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", permissionChecker.getErrorMessage());
                }
                File dataFile = dsOrderDetails.getDataFile() != null ? WorkspaceFileSystem.getFile((WorkspaceFile)dsOrderDetails.getDataFile()) : null;
                if (dataFile == null || !dataFile.isFile()) {
                    return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
                }
                dataFileByOrder.put(dsOrderDetails, dataFile);
                if (Util.displaySalaries((User)user) || dsOrderDetails.getPmtType() == null || !SepaApi.isCreditPmtType((PaymentTransferType.PmtType)dsOrderDetails.getPmtType())) continue;
                InputStream inputStream = null;
                try {
                    inputStream = EncryptData.getInstance().openInputStream(dataFile);
                    for (PaymentHandler<?> handler : PaymentHandler.getHandlers(inputStream, dsOrderDetails.getPmtType(), dsOrderDetails.getBank().getCountryCode())) {
                        if (!handler.isSalaryPayment()) continue;
                        play.mvc.Result result = DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
                        return result;
                    }
                }
                catch (IOException | GeneralSecurityException | PaymentException e) {
                    BLLoggerPlay.error("Failed to load payment details for DES order " + dsOrderDetails.getId(), e);
                }
                finally {
                    Util.closeStream((Closeable)inputStream);
                }
            }
            try {
                if (orders.size() == 1) {
                    File orderDataFile = (File)dataFileByOrder.get(orders.get(0));
                    return GeneralUtils.supplyWorkspaceFile(orderDataFile, false, false).as("binary/octet-stream").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(orderDataFile.getName()));
                }
                ArrayList<File> fileList = new ArrayList<File>(dataFileByOrder.values());
                return GeneralUtils.supplyZipFile(fileList, false, false).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.orders", (Object[])new Object[0]) + ".zip"));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to supply data file of DS order!", e);
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("HTMLerror", messages.at("deshistory.savefailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    public CompletionStage<play.mvc.Result> exportHistory(Http.Request request, boolean signed, int id) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        boolean displaySalaries = Util.displaySalaries((User)user);
        return CompletableFuture.supplyAsync(() -> {
            File exportFile;
            block11: {
                DsOrderDetails dsOrderDetails = (DsOrderDetails)DB.find(DsOrderDetails.class, (Object)id);
                if (dsOrderDetails == null) {
                    return DesHistory.redirect((Call)routes.DesHistory.details(signed, id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
                }
                OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
                if (!permissionChecker.hasAccountPermissions(user, dsOrderDetails)) {
                    return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", permissionChecker.getErrorMessage());
                }
                File dataFile = dsOrderDetails.getDataFile() != null ? WorkspaceFileSystem.getFile((WorkspaceFile)dsOrderDetails.getDataFile()) : null;
                if (dataFile == null || !dataFile.isFile()) {
                    return DesHistory.redirect((Call)routes.DesHistory.details(signed, id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
                }
                try {
                    InputStream orderDataInputStream = EncryptData.getInstance().openInputStream(dataFile);
                    List<PaymentHandler<?>> handlers = PaymentHandler.getHandlers(orderDataInputStream, dsOrderDetails.getPmtType(), dsOrderDetails.getBank().getCountryCode());
                    if (handlers == null || handlers.isEmpty()) {
                        return DesHistory.redirect((Call)routes.DesHistory.details(signed, id)).flashing("error", messages.at("error.failedcsvexport", new Object[]{messages.at("desoverview.export.nodata", new Object[0])}));
                    }
                    exportFile = new File(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.paymentDetails", (Object[])new Object[0]) + ".csv");
                    List<Object> paymentObjects = handlers.stream().filter(pi -> pi.getPayment() != null).map(pi -> pi.getPayment()).toList();
                    if (paymentObjects.isEmpty()) {
                        return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("error.failedcsvexport", new Object[]{messages.at("desoverview.export.nodata", new Object[0])}));
                    }
                    if (paymentObjects.get(0) instanceof DTAZVPayment) {
                        List<DTAZVPayment> dtazvPaymentObjects = paymentObjects.stream().map(o -> (DTAZVPayment)o).toList();
                        new DTAZVPaymentCsvExport(messages.lang().locale()).write(exportFile, dtazvPaymentObjects);
                        break block11;
                    }
                    if (paymentObjects.get(0) instanceof SEPAPaymentData) {
                        List<SEPAPaymentData> sepaPaymentObjects = paymentObjects.stream().map(o -> (SEPAPaymentData)o).toList();
                        new SEPAPaymentDataCsvExport(messages.lang().locale(), SepaApi.isCreditPmtType((PaymentTransferType.PmtType)dsOrderDetails.getPmtType()), displaySalaries).write(exportFile, sepaPaymentObjects);
                        break block11;
                    }
                    return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", messages.at("error.failedcsvexport", new Object[]{messages.at("desoverview.export.onlysepadtazv", new Object[0])}));
                }
                catch (InvalidPasswordException | IOException | PaymentException e) {
                    return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("HTMLerror", messages.at("error.failedcsvexport", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                }
            }
            try {
                return GeneralUtils.supplyWorkspaceFile(exportFile, true, false).as("binary/octet-stream").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(exportFile.getName()));
            }
            catch (IOException | GeneralSecurityException e) {
                return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("HTMLerror", messages.at("desoverview.exportfailed", new Object[]{Utils.getLocalizedMessage(e, messages)}));
            }
        }, this.executionContext.current());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public play.mvc.Result paymentDetails(Http.Request request, boolean signed, int id, int pageNumber) {
        int pageCount;
        Form paymentForm;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        DsOrderDetails dsOrderDetails = (DsOrderDetails)DB.find(DsOrderDetails.class, (Object)id);
        if (dsOrderDetails == null) {
            return DesHistory.redirect((Call)routes.DesHistory.details(signed, id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
        }
        OrderPermissionChecker permissionChecker = new OrderPermissionChecker(messages.lang().locale());
        if (!permissionChecker.hasAccountPermissions(user, dsOrderDetails)) {
            return DesHistory.redirect((Call)routes.DesHistory.index(signed)).flashing("error", permissionChecker.getErrorMessage());
        }
        File dataFile = dsOrderDetails.getDataFile() != null ? WorkspaceFileSystem.getFile((WorkspaceFile)dsOrderDetails.getDataFile()) : null;
        if (dataFile == null || !dataFile.isFile()) {
            return DesHistory.redirect((Call)routes.DesHistory.details(signed, id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
        }
        InputStream orderDataInputStream = null;
        try {
            orderDataInputStream = EncryptData.getInstance().openInputStream(dataFile);
            List<PaymentHandler<?>> handlers = PaymentHandler.getHandlers(orderDataInputStream, dsOrderDetails.getPmtType(), dsOrderDetails.getBank().getCountryCode());
            if (handlers != null && handlers.size() > pageNumber) {
                Object paymentObject = handlers.get(pageNumber).getPayment();
                if (paymentObject instanceof SEPAPaymentData) {
                    if (Util.hideSalariesCompletely((User)user) && handlers.get(pageNumber).isSalaryPayment()) {
                        BLLoggerPlay.warning("User " + user.getName() + " has no permission to view salary payments but tried to open a salary payment in the order with ID " + id + "!");
                        play.mvc.Result result = DesHistory.redirect((Call)routes.DesHistory.details(signed, id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
                        return result;
                    }
                    if (handlers.get(pageNumber) instanceof PostbarPaymentHandler) {
                        paymentForm = this.formFactory.form(PostbarPaymentForm.class).fill((Object)new PostbarPaymentForm((Object)dsOrderDetails, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                    } else if (handlers.get(pageNumber) instanceof TaxOfficePaymentHandler) {
                        paymentForm = this.formFactory.form(TaxOfficePaymentForm.class).fill((Object)new TaxOfficePaymentForm((Object)dsOrderDetails, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                    } else if (handlers.get(pageNumber) instanceof AustrianForeignPaymentHandler) {
                        paymentForm = this.formFactory.form(AustrianForeignPaymentForm.class).fill((Object)new AustrianForeignPaymentForm((Object)dsOrderDetails, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, false));
                    } else {
                        boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
                        paymentForm = this.formFactory.form(SepaPaymentForm.class).fill((Object)new SepaPaymentForm(dsOrderDetails, (SEPAPaymentData)paymentObject, Util.displaySalaries((User)user), false, useMandates, false));
                    }
                } else {
                    paymentForm = paymentObject instanceof DTAZVPayment ? this.formFactory.form(DtazvPaymentForm.class).fill((Object)new DtazvPaymentForm(dsOrderDetails, (DTAZVPayment)paymentObject, false, false)) : (paymentObject instanceof MT101PaymentData ? this.formFactory.form(Mt101PaymentForm.class).fill((Object)new Mt101PaymentForm(dsOrderDetails, (MT101PaymentData)paymentObject, false, false)) : null);
                }
                pageCount = handlers.size();
            } else {
                HVTResponseOrderData hvt = new HVTResponseOrderData(null, null, null);
                EbicsHandler handler = new EbicsHandler((ElementParser)new EbicsRootParser(null, (EbicsElement)hvt));
                handler.setValidate(false);
                handler.parse(orderDataInputStream, (String)null);
                if (pageNumber < 0 || pageNumber >= hvt.getOrderInfos().size()) {
                    play.mvc.Result result = DesHistory.redirect((Call)routes.DesHistory.details(signed, id)).flashing("error", messages.at("deshistory.notfound", new Object[0]));
                    return result;
                }
                paymentForm = this.formFactory.form(HvtPaymentForm.class).fill((Object)new HvtPaymentForm(dsOrderDetails, (HVTOrderInfo)hvt.getOrderInfos().get(pageNumber)));
                pageCount = hvt.getOrderInfos().size();
            }
        }
        catch (InvalidPasswordException | IOException | PaymentException | SAXException e) {
            BLLoggerPlay.error("Failed to load payment information for open DES order " + id + ", page number: " + pageNumber + "!", e);
            play.mvc.Result result = DesHistory.redirect((Call)routes.DesHistory.details(signed, id)).flashing("HTMLerror", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.failedToLoadPayment", (Object[])new Object[]{Utils.getLocalizedMessage(e, messages)}));
            return result;
        }
        finally {
            if (orderDataInputStream != null) {
                try {
                    orderDataInputStream.close();
                }
                catch (IOException e) {
                    BLLoggerPlay.error("Failed to close input stream on open DS order file " + dataFile.getAbsolutePath() + "!", e);
                }
            }
        }
        return DesHistory.ok((Content)deshistorypaymentdetails.render(dsOrderDetails, signed, (Form<? extends PaymentForm>)paymentForm, pageNumber, pageCount, request, messages));
    }

    private play.mvc.Result internalIndex(Http.Request request, boolean signed, User user, Form<SendFilterForm> filterForm, SendFilter sendFilter) {
        List list;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = signed ? new SortingHandler(user, Sorting.Table.DS_SIGNED) : new SortingHandler(user, Sorting.Table.DS_REJECTED);
        Query query = DsOrderDetails.findByTypeAndBanks((DsOrderDetails.Type)(signed ? DsOrderDetails.Type.SIGNED : DsOrderDetails.Type.REJECTED), (User)user);
        if (signed) {
            if (sendFilter.isDsSignedActive() && !sendFilter.isEmpty(SendFilter.SendFilterType.DS_SIGNED)) {
                query.where().add(sendFilter.getDsSignedExpression());
            }
        } else if (sendFilter.isDsCancelledActive() && !sendFilter.isEmpty(SendFilter.SendFilterType.DS_CANCELLED)) {
            query.where().add(sendFilter.getDsCancelledExpression());
        }
        String sort = sorting.isSortingAscending() ? " ASC" : " DESC";
        String dateSortSuffix = "";
        if (DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType())) {
            String string = dateSortSuffix = sorting.isSortingAscending() ? " NULLS FIRST" : " NULLS LAST";
        }
        String orderBy = sorting.getSortingColumn() == 1 ? "filename" + sort : (sorting.getSortingColumn() == 2 ? "submissionDate" + sort + dateSortSuffix : (sorting.getSortingColumn() == 3 ? "customerId" + sort : (sorting.getSortingColumn() == 4 ? "userName" + sort : (sorting.getSortingColumn() == 5 ? "numSigRequired" + sort : (sorting.getSortingColumn() == 6 ? "amount" + sort + ",datasize" + sort : (sorting.getSortingColumn() == 7 ? "state" + sort : "bank.displayName" + sort + ",fileType" + sort + ",orderId" + sort))))));
        query.order(orderBy);
        sorting.computeForQuery(query);
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            Sorting.Table table = signed ? Sorting.Table.DS_SIGNED : Sorting.Table.DS_REJECTED;
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, table, (Call)routes.DesHistory.index(signed));
        }
        return DesHistory.ok((Content)deshistory.render(list, signed, sorting, filterForm, sendFilter, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private play.mvc.Result internalFilter(Http.Request request, boolean signed, boolean active) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        SendFilter sendFilter = SendFilter.getFilter((User)user);
        if (!active) {
            if (signed) {
                sendFilter.setDsSignedActive(false);
            } else {
                sendFilter.setDsCancelledActive(false);
            }
        } else {
            Form<SendFilterForm> form = this.formFactory.form(SendFilterForm.class).bindFromRequest(request, new String[0]);
            if (!form.hasErrors()) {
                form = ((SendFilterForm)form.get()).validate(form, sendFilter, true);
            }
            if (form.hasErrors()) {
                return this.internalIndex(request, signed, user, form, sendFilter);
            }
            if (signed) {
                sendFilter.activateFor(SendFilter.SendFilterType.DS_SIGNED);
            } else {
                sendFilter.activateFor(SendFilter.SendFilterType.DS_CANCELLED);
            }
        }
        sendFilter.save();
        return DesHistory.redirect((Call)routes.DesHistory.index(signed));
    }
}

