/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AuthenticatorFor;
import controllers.DatabaseConnection;
import controllers.Setup;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.database.DatabaseMigrationRunner;
import de.businesslogics.banking.database.DatabaseUpdateRunner;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.api.DatabaseReorganize;
import de.businesslogics.banking.database.api.JdbcSettings;
import de.businesslogics.banking.database.vo.ClusterNode;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.IProgressMonitorWrapper;
import io.ebean.SqlRow;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import models.Database;
import models.SimpleTextForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Json;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import views.Utils;
import views.html.settings.databasemigration;
import views.html.settings.databasequery;
import views.html.settings.databasereorganize;

@Security.Authenticated(value=AuthenticatorFor.Settings.class)
public final class DatabaseMigration
extends Controller {
    private static MigrationHandler migrationHandler;
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static int currentProgress() {
        if (migrationHandler != null) {
            return (int)Math.round((double)DatabaseMigration.migrationHandler.worked * 100.0 / (double)DatabaseMigration.migrationHandler.totalWork);
        }
        return 0;
    }

    @Inject
    public DatabaseMigration(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result form(Http.Request request) {
        boolean finished;
        String status;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (!user.isAdmin()) {
            return DatabaseMigration.redirect((Call)routes.Preferences.showAdminPreferences(null)).flashing("error", messages.at("databasemigration.noadmin", new Object[0]));
        }
        if (ClusterNode.getThisNode() != null) {
            return DatabaseMigration.redirect((Call)routes.Preferences.showAdminPreferences(null)).flashing("error", messages.at("cluster.error.unavailableInCluster", new Object[0]));
        }
        if (migrationHandler != null) {
            status = migrationHandler.buildStatusMessage(messages);
            finished = !DatabaseMigration.migrationHandler.running;
        } else {
            status = null;
            finished = true;
        }
        if (finished && migrationHandler != null) {
            if (DatabaseMigration.migrationHandler.caught != null) {
                new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logDatabaseMigrationFinishedError(user, DatabaseMigration.migrationHandler.dbType.name(), DatabaseMigration.migrationHandler.jdbcUrl, DatabaseMigration.migrationHandler.dbUser);
            } else {
                new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logDatabaseMigrationFinishedSuccess(user, DatabaseMigration.migrationHandler.dbType.name(), DatabaseMigration.migrationHandler.jdbcUrl, DatabaseMigration.migrationHandler.dbUser);
            }
            migrationHandler = null;
        }
        return DatabaseMigration.ok((Content)databasemigration.render((Form<Database>)this.formFactory.form(Database.class), status, finished, request, messages));
    }

    public CompletionStage<Result> execute(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        return CompletableFuture.supplyAsync(() -> {
            if (!user.isAdmin()) {
                return DatabaseMigration.redirect((Call)routes.Preferences.showAdminPreferences(null)).flashing("error", messages.at("databasemigration.noadmin", new Object[0]));
            }
            if (ClusterNode.getThisNode() != null) {
                return DatabaseMigration.redirect((Call)routes.Preferences.showAdminPreferences(null)).flashing("error", messages.at("cluster.error.unavailableInCluster", new Object[0]));
            }
            if (migrationHandler != null && DatabaseMigration.migrationHandler.running) {
                return DatabaseMigration.redirect((Call)routes.DatabaseMigration.form());
            }
            Form form = this.formFactory.form(Database.class).bindFromRequest(request, new String[0]);
            if (form.hasErrors()) {
                return DatabaseMigration.ok((Content)databasemigration.render((Form<Database>)form, null, true, request, messages));
            }
            Form<Database> validatedForm = ((Database)form.get()).validate((Form<Database>)form);
            if (validatedForm.hasErrors()) {
                return DatabaseMigration.ok((Content)databasemigration.render(validatedForm, null, true, request, messages));
            }
            migrationHandler = new MigrationHandler(((Database)validatedForm.get()).url, ((Database)validatedForm.get()).username, ((Database)validatedForm.get()).password, messages.lang().toLocale());
            if (!migrationHandler.checkDatabaseConnection()) {
                migrationHandler = null;
                return DatabaseMigration.ok((Content)databasemigration.render((Form<Database>)validatedForm.withGlobalError("databasemigration.connectfailed"), null, true, request, messages));
            }
            new Thread(migrationHandler).start();
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logDatabaseMigrationStarted(user, DatabaseMigration.migrationHandler.dbType.name(), ((Database)validatedForm.get()).url, ((Database)validatedForm.get()).username);
            return DatabaseMigration.redirect((Call)routes.DatabaseMigration.form()).flashing("success", messages.at("databasemigration.started", new Object[0]));
        }, this.executionContext.current());
    }

    public Result status() {
        if (migrationHandler == null) {
            return DatabaseMigration.ok((String)"NOTRUNNING");
        }
        if (DatabaseMigration.migrationHandler.caught != null) {
            return DatabaseMigration.ok((String)"ERROR");
        }
        if (!DatabaseMigration.migrationHandler.running) {
            return DatabaseMigration.ok((String)"READY");
        }
        return DatabaseMigration.ok((String)Json.newObject().put("task", DatabaseMigration.migrationHandler.currentTaskName).put("progress", DatabaseMigration.currentProgress()).toString());
    }

    public Result query(Http.Request request) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (user == null || !user.isAdmin()) {
            return DatabaseMigration.redirect((Call)routes.Preferences.showAdminPreferences(null));
        }
        return DatabaseMigration.ok((Content)databasequery.render((Form<SimpleTextForm>)this.formFactory.form(SimpleTextForm.class), null, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public CompletionStage<Result> executeQuery(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            String resultMessage;
            Form form;
            block9: {
                if (user == null || !user.isAdmin()) {
                    return DatabaseMigration.redirect((Call)routes.Preferences.showAdminPreferences(null));
                }
                form = this.formFactory.form(SimpleTextForm.class).bindFromRequest(request, new String[0]);
                if (!form.hasErrors() && ((SimpleTextForm)form.get()).text == null || ((SimpleTextForm)form.get()).text.isEmpty()) {
                    form = form.withError("text", messages.at("error.required", new Object[0]));
                }
                if (!form.hasErrors()) {
                    String query = ((SimpleTextForm)form.get()).text.trim();
                    try {
                        if (query.length() > 6 && (query.substring(0, 6).equalsIgnoreCase("SELECT") || query.substring(0, 4).equalsIgnoreCase("SHOW"))) {
                            StringBuilder builder = new StringBuilder();
                            for (SqlRow row : DB.sqlQuery((String)query).findList()) {
                                builder.append(row.toString()).append('\n');
                            }
                            resultMessage = builder.toString();
                            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logExecutedCustomSqlQuery(user, query);
                            break block9;
                        }
                        int nRowsModified = DB.sqlUpdate((String)query).execute();
                        resultMessage = messages.at("databasequery.result.done", new Object[]{nRowsModified});
                        if (nRowsModified == 0) {
                            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logExecutedCustomSqlQuery(user, query);
                            break block9;
                        }
                        new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logExecutedCustomSqlUpdate(user, query, nRowsModified);
                    }
                    catch (Throwable t) {
                        BLLoggerPlay.error("Failed to execute custom query: \"" + query + "\"", t);
                        resultMessage = Utils.getLocalizedMessage(t, messages);
                    }
                } else {
                    resultMessage = null;
                }
            }
            return DatabaseMigration.ok((Content)databasequery.render((Form<SimpleTextForm>)form, resultMessage, request, messages));
        }, this.executionContext.current());
    }

    public CompletionStage<Result> reorganize(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        return CompletableFuture.supplyAsync(() -> {
            String msg;
            try {
                msg = DatabaseReorganize.doIt();
            }
            catch (Exception exception) {
                BLLoggerPlay.error("An error occurred while merging accounts", exception);
                return DatabaseMigration.redirect((Call)routes.Preferences.showAdminPreferences(null)).flashing("error", messages.at("databasereorganize.error", new Object[0]) + " " + String.valueOf(exception));
            }
            if (!msg.isEmpty()) {
                new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logDatabaseAccountsMerged(user);
                return DatabaseMigration.ok((Content)databasereorganize.render(messages.at("databasereorganize.account", new Object[0]) + " " + msg.replaceAll("\n", ", "), request, messages));
            }
            return DatabaseMigration.ok((Content)databasereorganize.render(messages.at("databasereorganize.nothing", new Object[0]), request, messages));
        }, this.executionContext.current());
    }

    private static final class MigrationHandler
    implements Runnable,
    IProgressMonitorWrapper {
        private final String jdbcUrl;
        private final String dbUser;
        private final String dbPassword;
        private final Locale locale;
        private DBType dbType;
        private boolean running;
        private Date startTime;
        private String currentTaskName;
        private Throwable caught;
        private int totalWork;
        private int worked;

        public MigrationHandler(String jdbcUrl, String dbUser, String dbPassword, Locale locale) {
            this.jdbcUrl = jdbcUrl;
            this.dbUser = dbUser;
            this.dbPassword = dbPassword;
            this.locale = locale;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            this.running = true;
            this.startTime = new Date();
            this.currentTaskName = null;
            this.caught = null;
            this.totalWork = 0;
            this.worked = 0;
            try {
                DatabaseMigrationRunner migrationRunner = new DatabaseMigrationRunner(this.dbType, this.jdbcUrl, this.dbUser, this.dbPassword, false, BLLoggerPlay.getLogger(), Setup.WORKSPACE_DIRECTORY, this.locale);
                migrationRunner.run((IProgressMonitorWrapper)this);
                if (migrationRunner.getErrorMessage() == null) {
                    new JdbcSettings(Setup.WORKSPACE_DIRECTORY, this.dbType, this.jdbcUrl, this.dbUser, this.dbPassword).storeSettings();
                    Class<DatabaseConnection> clazz = DatabaseConnection.class;
                    synchronized (DatabaseConnection.class) {
                        DatabaseConnection.shutdown();
                        DatabaseUpdateRunner updateRunner = DatabaseConnection.initDatabaseConnection(Setup.WORKSPACE_DIRECTORY);
                        ((DatabaseConnection)DatabaseConnection.getInstance()).webUpdates(updateRunner);
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        return;
                    }
                }
                this.caught = new Throwable(migrationRunner.getErrorMessage());
                return;
            }
            catch (Throwable t) {
                BLLoggerPlay.error("Database migration failed!", t);
                this.caught = t;
                return;
            }
            finally {
                this.running = false;
            }
        }

        public void beginTask(String name, int totalWork) {
            this.currentTaskName = name;
            this.totalWork += totalWork;
        }

        public void subTask(String name) {
            this.currentTaskName = name;
        }

        public boolean isCanceled() {
            return false;
        }

        public void worked(int work) {
            this.worked += work;
        }

        public void done() {
            this.worked = this.totalWork;
        }

        public IProgressMonitorWrapper newSubMonitor(int ticks) {
            this.totalWork += ticks;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkDatabaseConnection() {
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(this.jdbcUrl.replace("${workspace_loc}", Setup.WORKSPACE_DIRECTORY.getAbsolutePath()), this.dbUser, this.dbPassword);
                this.dbType = DBType.getInstance((Connection)conn);
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                BLLoggerPlay.warning("Database connection check to " + this.jdbcUrl + " failed!", e);
                this.dbType = null;
                boolean bl = false;
                return bl;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        BLLoggerPlay.warning("Failed to close JDBC connection to " + this.jdbcUrl, e);
                    }
                }
            }
        }

        public String buildStatusMessage(Messages messages) {
            if (this.startTime == null) {
                return null;
            }
            if (this.running) {
                return messages.at("databasemigration.running.info", new Object[]{this.startTime});
            }
            if (this.caught == null) {
                return messages.at("databasemigration.finished.successful", new Object[0]);
            }
            return messages.at("databasemigration.finished.failed", new Object[]{Utils.getLocalizedMessage(this.caught, messages)});
        }
    }
}

