/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.database.DatabaseUpdateRunner;
import de.businesslogics.banking.database.api.JdbcSettings;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.persistence.DBType;
import io.ebean.config.DatabaseConfig;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.persistence.Entity;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class DatabaseConnection
extends de.businesslogics.banking.database.api.DatabaseConnection {
    public static DatabaseUpdateRunner initDatabaseConnection(File workspaceDir) throws IOException, SQLException {
        DatabaseConnection con = (DatabaseConnection)de.businesslogics.banking.database.api.DatabaseConnection.connection;
        if (con == null) {
            con = new DatabaseConnection(workspaceDir);
        }
        DatabaseUpdateRunner updateRunner = new DatabaseUpdateRunner(BLLoggerPlay.getLogger(), workspaceDir);
        con.checkForUpdates(updateRunner);
        return updateRunner;
    }

    private void checkForUpdates(DatabaseUpdateRunner runner) throws SQLException {
        DBType dbType = runner.checkDatabaseConnection(this.getServer(), null, this.jdbcSettings.getSchema());
        DatabaseConnection.getInstance().setDbType(dbType);
        BankSettings.DATABASE_TYPE = dbType;
        runner.findDatabaseUpdateScripts(this.getServer(), dbType);
        if (!runner.getUpdatesToDo().isEmpty()) {
            new Thread(() -> this.webUpdates(runner)).start();
        }
    }

    public void webUpdates(DatabaseUpdateRunner runner) {
        try {
            LinkedHashMap list = runner.getUpdatesToDo();
            Iterator iterator = list.keySet().iterator();
            while (iterator.hasNext()) {
                int nextVersion = (Integer)iterator.next();
                runner.executeUpdate(this.getServer(), this.dbType, this.jdbcSettings.getSchema(), (String)list.get(nextVersion), nextVersion);
                iterator.remove();
            }
        }
        catch (SQLException sql) {
            BLLoggerPlay.error("Error running DB update.", sql);
        }
    }

    private DatabaseConnection(File workspaceDir) throws IOException {
        super(workspaceDir);
        de.businesslogics.banking.database.api.DatabaseConnection.connection = this;
    }

    protected JdbcSettings createDefaultSettings(File workspaceDir) throws IOException {
        throw new IOException("No default database for BL Banking Web");
    }

    protected void registerEntityClasses(DatabaseConfig serverConfig) {
        Reflections reflections = new Reflections("de.businesslogics.banking.database.vo", new Scanner[0]);
        Set allClasses = reflections.getTypesAnnotatedWith(Entity.class);
        for (Class c : allClasses) {
            serverConfig.addClass(c);
        }
    }
}

