/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AuthenticatorFor;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.SortingHandler;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.ConversionHelper;
import io.ebean.Query;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import models.ConversionForm;
import models.SimpleTextForm;
import models.TenantSelectForm;
import play.data.DynamicForm;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.Scala;
import play.libs.concurrent.ClassLoaderExecutionContext;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Security;
import play.twirl.api.Content;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import views.Utils;
import views.html.cm.conversionDelete;
import views.html.cm.conversionform;
import views.html.cm.conversionimport;
import views.html.cm.conversions;

@Security.Authenticated(value=AuthenticatorFor.CM.class)
public class Conversions
extends Controller {
    public static final String NO_CONVERSION = "noConversion";
    public static final String PDF_CONVERSION = "pdfConversion";
    private final FormFactory formFactory;
    private final MessagesApi messagesApi;
    private final ClassLoaderExecutionContext executionContext;

    public static String loadJsParameters(int numberOfTenants) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("numberOfTenants", numberOfTenants);
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static Seq<Tuple2<String, String>> conversionOptions(Messages messages, User user, boolean includeNoneOption, boolean includePdfOption) {
        return Conversions.conversionOptions(messages, user, includeNoneOption, includePdfOption, true, true);
    }

    public static Seq<Tuple2<String, String>> statementConversionOptions(Messages messages, User user, boolean includeNoneOption, boolean includePdfOption) {
        return Conversions.conversionOptions(messages, user, includeNoneOption, includePdfOption, true, false);
    }

    public static Seq<Tuple2<String, String>> bookingConversionOptions(Messages messages, User user, boolean includeNoneOption, boolean includePdfOption) {
        return Conversions.conversionOptions(messages, user, includeNoneOption, includePdfOption, false, true);
    }

    public static Seq<Tuple3<String, String, String>> conversionOptionsWithTenant(Messages messages, User user, boolean includeNoneOption, boolean includePdfOption) {
        ArrayList<Tuple3> result = new ArrayList<Tuple3>();
        if (includeNoneOption) {
            result.add(new Tuple3((Object)NO_CONVERSION, (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.noConversion", (Object[])new Object[0]), (Object)""));
        }
        if (includePdfOption) {
            result.add(new Tuple3((Object)PDF_CONVERSION, (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.pdfConversion", (Object[])new Object[0]), (Object)""));
        }
        for (Conversion c : Conversion.findAll((List)user.getVisibleTenants())) {
            Object conversionName = c.getName();
            if (user.getVisibleTenants().size() > 1) {
                conversionName = (String)conversionName + " (" + c.getTenant().getName() + ")";
            }
            result.add(new Tuple3((Object)String.valueOf(c.getId()), (Object)Utils.addZWNJ((String)conversionName), (Object)String.valueOf(c.getTenant().getId())));
        }
        return Scala.toSeq(result);
    }

    private static Seq<Tuple2<String, String>> conversionOptions(Messages messages, User user, boolean includeNoneOption, boolean includePdfOption, boolean includeStatementConversions, boolean includeBookingConversions) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeNoneOption) {
            result.add(new Tuple2((Object)NO_CONVERSION, (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.noConversion", (Object[])new Object[0])));
        }
        if (includePdfOption) {
            result.add(new Tuple2((Object)PDF_CONVERSION, (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.pdfConversion", (Object[])new Object[0])));
        }
        for (Conversion c : Conversion.findAll((List)user.getVisibleTenants())) {
            Conversion.Type type = c.getType();
            if ((!includeStatementConversions || type != Conversion.Type.StatementType && type != Conversion.Type.StatementTypeCFONB120) && (!includeBookingConversions || type != Conversion.Type.BookingType && type != Conversion.Type.BookingTypeCFONB120)) continue;
            Object conversionName = c.getName();
            if (user.getVisibleTenants().size() > 1) {
                conversionName = (String)conversionName + " (" + c.getTenant().getName() + ")";
            }
            result.add(Scala.Tuple((Object)String.valueOf(c.getId()), (Object)Utils.addZWNJ((String)conversionName)));
        }
        return Scala.toSeq(result);
    }

    @Inject
    public Conversions(FormFactory formFactory, MessagesApi messagesApi, ClassLoaderExecutionContext executionContext) {
        this.formFactory = formFactory;
        this.messagesApi = messagesApi;
        this.executionContext = executionContext;
    }

    public Result index(Http.Request request) {
        List list;
        Tenant tenant;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        SortingHandler sorting = new SortingHandler(user, Sorting.Table.CM_CONVERTER);
        try {
            int tenantId = Integer.parseInt(sorting.getProperty("TENANT", "-1"));
            tenant = Tenant.findById((int)tenantId, (User)user, (boolean)false);
        }
        catch (NumberFormatException ignored) {
            tenant = null;
        }
        Form form = this.formFactory.form(TenantSelectForm.class);
        Query<Conversion> query = this.conversionQuery(sorting.getSortingColumn(), sorting.isSortingAscending(), user, tenant);
        sorting.computeForQuery(query);
        try {
            list = query.findList();
        }
        catch (PersistenceException e) {
            return GeneralUtils.handleLoadOverviewFailed(e, messages, user, Sorting.Table.CM_CONVERTER, (Call)routes.Conversions.index());
        }
        return Conversions.ok((Content)conversions.render(list, (Form<TenantSelectForm>)form, sorting, tenant, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    private Query<Conversion> conversionQuery(int sort, boolean asc, User user, Tenant tenant) {
        Query query = Conversion.findQuery((List)user.getVisibleTenantsSorted());
        if (tenant != null) {
            query.where().eq("tenant", (Object)tenant);
        }
        query = sort == 1 ? (asc ? query.order("type asc, name asc, tenant asc") : query.order("type desc, name desc, tenant desc")) : (sort == 2 ? (asc ? query.order("tenant.name asc, name asc") : query.order("tenant.name desc, name desc")) : (asc ? query.order("name asc, tenant asc") : query.order("name desc, tenant desc")));
        return query;
    }

    public Result index_sort(Http.Request request, int sort, boolean asc) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_CONVERTER).updateSort(sort, asc);
        return Conversions.redirect((Call)routes.Conversions.index());
    }

    public Result index_pageSize(Http.Request request, int page, int pageSize) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        new SortingHandler(user, Sorting.Table.CM_CONVERTER).updatePage(page, pageSize);
        return Conversions.redirect((Call)routes.Conversions.index());
    }

    public Result index_Tenant(Http.Request request, int tenantId) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String propValue = tenantId >= 0 ? String.valueOf(tenantId) : null;
        new SortingHandler(user, Sorting.Table.CM_CONVERTER).setProperty("TENANT", propValue);
        return Conversions.redirect((Call)routes.Conversions.index());
    }

    public Result newConversion(Http.Request request) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        ConversionForm value = ConversionForm.getDefault(messages.lang().locale());
        value.referer = Utils.getHeaderValue(request, "referer");
        Form form = this.formFactory.form(ConversionForm.class).fill((Object)value);
        return Conversions.ok((Content)conversionform.render(null, (Form<ConversionForm>)form, false, request, messages));
    }

    public Result edit(Http.Request request, Integer id) {
        return this.editConversion(request, id, false);
    }

    public Result editEditMode(Http.Request request, Integer id) {
        return this.editConversion(request, id, true);
    }

    public Result editConversion(Http.Request request, Integer id, boolean inEditmode) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        String referer = Utils.getHeaderValue(request, "referer");
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Conversion conversion = (Conversion)Conversion.findQuery((List)user.getVisibleTenants()).where().eq("id", (Object)id).findOne();
        if (conversion == null) {
            return Conversions.redirect((String)referer).flashing("error", messages.at("conversions.error.noSuchConversion", new Object[0]));
        }
        ConversionForm value = ConversionForm.fill(conversion);
        value.referer = referer;
        Form form = this.formFactory.form(ConversionForm.class).fill((Object)value);
        return Conversions.ok((Content)conversionform.render(id, (Form<ConversionForm>)form, inEditmode, request, messages));
    }

    public Result postForm(Http.Request request, Integer id) {
        Form<ConversionForm> form;
        Conversion conversion;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (id != null) {
            conversion = Conversion.findById((int)id, (User)user);
            if (conversion == null) {
                return Conversions.redirect((Call)routes.Conversions.index()).flashing("error", messages.at("conversions.error.noSuchConversion", new Object[0]));
            }
        } else {
            conversion = new Conversion();
        }
        if (!(form = this.formFactory.form(ConversionForm.class).bindFromRequest(request, new String[0])).hasErrors()) {
            form = ((ConversionForm)form.get()).validateAndSave(form, conversion, user, messages.lang().locale());
        }
        if (form.hasErrors()) {
            return Conversions.ok((Content)conversionform.render(id, form, false, request, messages));
        }
        String flashMessage = messages.at("conversions.success.saved", new Object[]{conversion.getName()});
        if (((ConversionForm)form.get()).referer != null && ((ConversionForm)form.get()).referer.trim().length() != 0) {
            return Conversions.redirect((String)((ConversionForm)form.get()).referer).flashing("success", flashMessage);
        }
        return Conversions.redirect((Call)routes.Conversions.index()).flashing("success", flashMessage);
    }

    public Result getExampleDate(Http.Request request, String pattern) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern, messages.lang().locale());
            return Conversions.ok((String)messages.at("conversions.date.example", new Object[]{format.format(new Date())}));
        }
        catch (NullPointerException e) {
            DateFormat format = DateFormat.getDateInstance(2, messages.lang().locale());
            return Conversions.ok((String)messages.at("conversions.date.example", new Object[]{format.format(new Date())}));
        }
        catch (IllegalArgumentException e) {
            return Conversions.ok((String)"");
        }
    }

    public Result askDelete(Http.Request request) {
        return this.askDeleteConversions(request, null);
    }

    public Result askDeleteConversion(Http.Request request, Integer id) {
        return this.askDeleteConversions(request, id);
    }

    public Result askDeleteConversions(Http.Request request, Integer id) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String ids = id != null ? id.toString() : ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        ArrayList<Conversion> conversions2 = new ArrayList<Conversion>();
        for (Integer i : GeneralUtils.getSelectionIds(ids)) {
            Conversion c = Conversion.findById((int)i, (User)user);
            if (c == null) continue;
            conversions2.add(c);
        }
        HashMap<Conversion, Integer> conversionInfo = new HashMap<Conversion, Integer>();
        for (Conversion c : conversions2) {
            List affected = AutomaticExport.findByConversion(Collections.singletonList(c));
            conversionInfo.put(c, affected.size());
        }
        return Conversions.ok((Content)conversionDelete.render(ids, conversions2.size(), conversionInfo, request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result delete(Http.Request request) {
        String flashMessage;
        String flashKey;
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        String ids = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
        ArrayList<Conversion> conversions2 = new ArrayList<Conversion>();
        for (Integer i : GeneralUtils.getSelectionIds(ids)) {
            Conversion c = Conversion.findById((int)i, (User)user);
            if (c == null) continue;
            conversions2.add(c);
        }
        Conversion.delete(conversions2);
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        if (conversions2.size() > 0) {
            flashKey = "success";
            flashMessage = messages.at("conversions.success.deleted", new Object[]{conversions2.size()});
        } else {
            flashKey = "warning";
            flashMessage = messages.at("conversions.error.nothingToDelete", new Object[0]);
        }
        return Conversions.redirect((Call)routes.Conversions.index()).flashing(flashKey, flashMessage);
    }

    public CompletionStage<Result> exportConversions(Http.Request request, String idsString) {
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        List<Integer> ids = GeneralUtils.getSelectionIds(idsString);
        return CompletableFuture.supplyAsync(() -> {
            Result result;
            if (ids.size() == 0 || ids.stream().allMatch(Objects::isNull)) {
                return Conversions.redirect((Call)routes.Conversions.index()).flashing("error", messages.at("conversions.error.noSuchConversion", new Object[0]));
            }
            ArrayList<Conversion> list = new ArrayList<Conversion>();
            boolean singleFile = ids.size() == 1;
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                Conversion conversion = Conversion.findById((int)id, (User)user);
                if (conversion == null) {
                    if (!singleFile) continue;
                    return Conversions.redirect((Call)routes.Conversions.index()).flashing("error", messages.at("conversions.error.noSuchConversion", new Object[0]));
                }
                list.add(conversion);
            }
            File tmpDir = null;
            try {
                if (list.isEmpty()) {
                    Result id = Conversions.redirect((Call)routes.Conversions.index()).flashing("error", messages.at("conversions.error.noSuchConversion", new Object[0]));
                    return id;
                }
                if (list.size() == 1) {
                    Conversion conversion = (Conversion)list.get(0);
                    result = Conversions.ok((byte[])ConversionHelper.exportConversion((Conversion)conversion)).as("application/xml").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement(conversion.getName().replaceAll("\\W+", "_") + ".xml"));
                    return result;
                }
                ArrayList<File> filesToExport = new ArrayList<File>();
                tmpDir = Util.createTempFolder((String)"exported_conversions", (boolean)false);
                for (Conversion conversion : list) {
                    String filename = conversion.getName().replaceAll("\\W+", "_") + ".xml";
                    File exportFile = new File(tmpDir, filename);
                    FileOutputStream outputStream = null;
                    try {
                        outputStream = new FileOutputStream(exportFile);
                        outputStream.write(ConversionHelper.exportConversion((Conversion)conversion));
                        filesToExport.add(exportFile);
                    }
                    finally {
                        if (outputStream == null) continue;
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            BLLoggerPlay.error("Failed to close output stream to data file!", e);
                        }
                    }
                }
                result = GeneralUtils.supplyZipFile(filesToExport, true, true).as("application/zip").withHeader("Content-Disposition", GeneralUtils.getFilenameAsHtmlAttachement("conversions.zip"));
                return result;
            }
            catch (Exception e) {
                BLLoggerPlay.warning("An exception occurred while exporting conversion", e);
                result = Conversions.redirect((Call)routes.Conversions.index()).flashing("error", this.messagesApi.preferred((Http.RequestHeader)request).at("conversions.error.export", new Object[]{e.toString()}));
                return result;
            }
            finally {
                if (tmpDir != null && !tmpDir.delete()) {
                    BLLoggerPlay.warning("Failed to delete temporary directory " + tmpDir.getAbsolutePath() + ", will be deleted on exit!");
                    tmpDir.deleteOnExit();
                }
            }
        }, this.executionContext.current());
    }

    public Result importConversion(Http.Request request) {
        return Conversions.ok((Content)conversionimport.render(this.formFactory.form(), request, this.messagesApi.preferred((Http.RequestHeader)request)));
    }

    public Result importFile(Http.Request request) {
        Http.MultipartFormData fileFormData = request.body().asMultipartFormData();
        Http.MultipartFormData.FilePart filePart = fileFormData.getFile("import_file");
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        try {
            DynamicForm form = this.formFactory.form().bindFromRequest(request, new String[0]);
            Integer tenantId = form.get("tenantId") != null ? Integer.valueOf(form.get("tenantId")) : null;
            String error = TenantUtils.checkTenantId(tenantId, user);
            if (error != null) {
                return Conversions.ok((Content)conversionimport.render(form.withError("tenantId", error), request, messages));
            }
            Tenant tenant = TenantUtils.getTenantByIdAndUser(tenantId, user);
            Conversion c = ConversionHelper.importConversion((File)((Files.TemporaryFile)filePart.getRef()).path().toFile(), (Tenant)tenant);
            c.save();
            return Conversions.redirect((Call)routes.Conversions.index()).flashing("success", messages.at("conversions.success.imported", new Object[0]));
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to import conversion", e);
            DynamicForm form = this.formFactory.form().withError("", this.messagesApi.preferred((Http.RequestHeader)request).at("conversions.import.error", new Object[]{e.toString()}));
            return Conversions.ok((Content)conversionimport.render(form, request, messages));
        }
    }

    public Result defaultConversions(Http.Request request, boolean french) {
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        ConversionHelper.createDefaultConversions((List)user.getTenants(), (boolean)french, (Locale)messages.lang().locale());
        return Conversions.redirect((Call)routes.Conversions.index()).flashing("success", messages.at("conversions.success.defaultCreated", new Object[0]));
    }

    public CompletionStage<Result> duplicate(Http.Request request) {
        return this.duplicateConversion(request, null);
    }

    public CompletionStage<Result> duplicateId(Http.Request request, Integer id) {
        return this.duplicateConversion(request, id);
    }

    public CompletionStage<Result> duplicateConversion(Http.Request request, Integer id) {
        play.api.mvc.Call redirectTo;
        String conversionIds;
        Messages messages = this.messagesApi.preferred((Http.RequestHeader)request);
        User user = User.getUser((String)((String)request.attrs().get(Security.USERNAME)));
        if (id == null) {
            conversionIds = ((SimpleTextForm)this.formFactory.form(SimpleTextForm.class).bindFromRequest((Http.Request)request, (String[])new String[0]).get()).text;
            redirectTo = routes.Conversions.index();
        } else {
            conversionIds = id.toString();
            redirectTo = routes.Conversions.edit(id);
        }
        Form tenantSelectForm = this.formFactory.form(TenantSelectForm.class).bindFromRequest(request, new String[0]);
        Integer tenantId = ((TenantSelectForm)tenantSelectForm.get()).getSelectedTenantId();
        return CompletableFuture.supplyAsync(() -> {
            List<Integer> ids = GeneralUtils.getSelectionIds(conversionIds);
            List conversions2 = Conversion.findByIds(ids, (User)user);
            Tenant tenantToUse = tenantId != null ? Tenant.findById((int)tenantId, (User)user, (boolean)false) : null;
            int successCount = 0;
            for (Conversion conversion : conversions2) {
                Tenant tenant = tenantToUse != null ? tenantToUse : conversion.getTenant();
                Conversion newConversion = new Conversion();
                newConversion.setName(Conversion.getUniqueName((String)conversion.getName(), (Tenant)tenant));
                newConversion.setType(conversion.getType());
                newConversion.setIncludeHeader(conversion.isIncludeHeader());
                newConversion.setTenant(tenant);
                newConversion.setFieldSeparator(conversion.getFieldSeparator());
                newConversion.setTextSeparator(conversion.getTextSeparator());
                newConversion.setDateFormat(conversion.getDateFormat());
                newConversion.setNumberFormat(conversion.getNumberFormat());
                newConversion.setFields(conversion.getFields());
                newConversion.save();
                ++successCount;
            }
            String flashKey = successCount == 0 ? "warning" : "success";
            return Conversions.redirect((Call)redirectTo).flashing(flashKey, messages.at("conversions.duplicated", new Object[]{successCount}));
        }, this.executionContext.current());
    }
}

